#!/usr/bin/env python
"""
Module KDEAPP -- Python KDE Application Objects
Sub-Package GUI.TOOLKITS.KDE of Package PLIB -- Python GUI Toolkits
Copyright (C) 2008 by Peter A. Donis

Released under the GNU General Public License, Version 2
See the LICENSE and README files for more information

This module contains the KDE GUI application objects.
"""

import sys

import qt
import kdecore
import kdeui

from plib.gui.defs import *
from plib.gui._base import app

from _kdecommon import _PKDECommunicator

def _kdeparse(aboutdata):
    data = kdecore.KAboutData(aboutdata['name'], aboutdata['name'], aboutdata['version'])
    data.setCopyrightStatement(aboutdata['copyright'])
    data.setLicenseText(aboutdata['license'])
    data.setShortDescription(aboutdata['description'])
    for dev in aboutdata['developers']:
        data.addAuthor(dev)
    data.setHomepage(aboutdata['website'])
    # FIXME: wtf doesn't this work? Alternately, why doesn't setting the program
    # icon elsewhere cause it to display here?
    #data.setLogo(qt.QPixmap(aboutdata['icon']))
    return data

class _PKDEMainMixin(kdeui.KMainWindow, _PKDECommunicator):
    """
    Mixin class for KDE top windows and main windows.
    """
    
    def _init_icon(self):
        if (self.aboutdata is not None) and ('icon' in self.aboutdata):
            self.setIcon(qt.QPixmap(self.aboutdata['icon']))
    
    def _get_w(self):
        return self.width()
    w = property(_get_w)
    
    def set_caption(self, caption):
        self.setCaption(caption)
    
    def sizetoscreen(self, maximized):
        if maximized:
            if self.shown:
                self.showMaximized()
            else:
                self._showMax = True
        else:
            desktop = self.app.desktop()
            self.resize(desktop.width() - self.sizeoffset, desktop.height() - self.sizeoffset)
    
    def sizetoclient(self, clientwidth, clientheight):
        self.resize(clientwidth, clientheight)
    
    def center(self):
        desktop = self.app.desktop()
        self.move((desktop.width() - self.width())/2,
            (desktop.height() - self.height())/2)
    
    def show_init(self):
        if hasattr(self, '_showMax'):
            self.showMaximized()
            del self._showMax
        else:
            kdeui.KMainWindow.show(self)
    
    def about(self):
        if self.aboutdata is not None:
            kaboutdata = _kdeparse(self.aboutdata)
            kdeui.KAboutApplication(kaboutdata).exec_loop()
    
    def exit(self):
        self.close()
    
    def closeEvent(self, event):
        # 'automagic' code for SIGNAL_QUERYCLOSE
        if self.acceptclose():
            # FIXME: either figure a way to emit this signal first, before acceptclose(),
            # or change it to SIGNAL_BEFORECLOSE
            #self._emit_event(SIGNAL_QUERYCLOSE)
            event.accept()
        else:
            event.ignore()
    
    def hideEvent(self, event):
        self._emit_event(SIGNAL_HIDDEN)

class PKDETopWindow(_PKDEMainMixin, app.PTopWindowBase):
    
    def __init__(self, parent, cls=None):
        _PKDEMainMixin.__init__(self)
        app.PTopWindowBase.__init__(self, parent, cls)
        self.setCentralWidget(self.clientwidget)
        # This has to be at the end so app.PTopWindowBase.__init__ has a chance
        # to read the about data from the client widget, if applicable
        self._init_icon()
    
    def show_init(self):
        app.PTopWindowBase.show_init(self)
        _PKDEMainMixin.show_init(self)

class PKDEApplication(kdecore.KApplication, app.PApplicationBase, _PKDECommunicator):
    """
    Customized KDE application class.
    """
    
    mainwidgetclass = PKDETopWindow
    
    def __init__(self, arglist=[], cls=None):
        if cls is None:
            klass = self.mainwidgetclass
        else:
            klass = cls
        if klass.aboutdata is not None:
            kaboutdata = _kdeparse(klass.aboutdata)
        else:
            kaboutdata = kdecore.KAboutData('unnamed', 'unnamed', '0.0')
        kdecore.KCmdLineArgs.init(kaboutdata) # all the above because KDE requires this incantation first
        kdecore.KApplication.__init__(self)
        app.PApplicationBase.__init__(self, arglist, cls)
        self.mainwin = self.createMainWidget()
        # FIXME: something in here is resetting the caption? maybe the next line?
        self.setMainWidget(self.mainwin)
        
        # 'automagic' signal connection
        self.setup_notify(SIGNAL_BEFOREQUIT, self.before_quit)
    
    def _eventloop(self):
        self.exec_loop()
