#!/usr/bin/env python
"""
Module QTAPP -- Python Qt Application Objects
Sub-Package GUI.TOOLKITS.QT of Package PLIB -- Python GUI Toolkits
Copyright (C) 2008 by Peter A. Donis

Released under the GNU General Public License, Version 2
See the LICENSE and README files for more information

This module contains the Qt GUI application objects.
"""

import qt

from plib.gui.defs import *
from plib.gui._base import app

from _qtcommon import _PQtCommunicator

class PQtAboutDialog(app.PAboutDialogBase):
    
    attrnames = [ 'name',
        'version',
        'copyright',
        'license',
        'description',
        'developers',
        'website',
        'icon' ]
    
    formatstr = "%(aname)s %(aversion)s\n%(adescription)s\n%(acopyright)s\n%(adevelopers)s\n%(awebsite)s"
    
    def __getattribute__(self, name):
        # Here we have to modify the hack somewhat
        attrnames = object.__getattribute__(self, 'attrnames')
        if name in attrnames:
            object.__getattribute__(self, '__dict__')['temp'] = name
            name = 'store'
        return object.__getattribute__(self, name)
    
    def store(self, data):
        name = self.temp
        del self.temp
        if name == 'developers':
            data = ", ".join(data)
        setattr(self, "a%s" % name, data)
    
    def display(self):
        caption = "About %s" % self.aname
        body = self.formatstr % dict(("a%s" % name, getattr(self, "a%s" % name))
            for name in self.attrnames)
        qt.QMessageBox.about(self.mainwidget, caption, body)

class _PQtMainMixin(qt.QMainWindow, _PQtCommunicator):
    """
    Mixin class for Qt top windows and main windows.
    """
    
    aboutdialogclass = PQtAboutDialog
    
    def _get_w(self):
        return self.width()
    w = property(_get_w)
    
    def set_caption(self, caption):
        self.setCaption(caption)
    
    def sizetoscreen(self, maximized):
        if maximized:
            if self.shown:
                self.showMaximized()
            else:
                self._showMax = True
        else:
            desktop = self.app.desktop()
            self.resize(desktop.width() - self.sizeoffset, desktop.height() - self.sizeoffset)
    
    def sizetoclient(self, clientwidth, clientheight):
        self.resize(clientwidth, clientheight)
    
    def center(self):
        desktop = self.app.desktop()
        self.move((desktop.width() - self.width())/2,
            (desktop.height() - self.height())/2)
    
    def show_init(self):
        if hasattr(self, '_showMax'):
            self.showMaximized()
            del self._showMax
        else:
            qt.QMainWindow.show(self)
    
    def exit(self):
        self.close()
    
    def closeEvent(self, event):
        # 'automagic' code for SIGNAL_QUERYCLOSE
        if self.acceptclose():
            # FIXME: either figure a way to emit this signal first, before acceptclose(),
            # or change it to SIGNAL_BEFORECLOSE
            #self._emit_event(SIGNAL_QUERYCLOSE)
            event.accept()
        else:
            event.ignore()
    
    def hideEvent(self, event):
        self._emit_event(SIGNAL_HIDDEN)

class PQtTopWindow(_PQtMainMixin, app.PTopWindowBase):
    """
    Customized Qt top window class.
    """
    
    def __init__(self, parent, cls=None):
        _PQtMainMixin.__init__(self)
        app.PTopWindowBase.__init__(self, parent, cls)
        self.setCentralWidget(self.clientwidget)
    
    def show_init(self):
        app.PTopWindowBase.show_init(self)
        _PQtMainMixin.show_init(self)

class PQtApplication(qt.QApplication, app.PApplicationBase, _PQtCommunicator):
    """
    Customized Qt application class.
    """
    
    mainwidgetclass = PQtTopWindow
    
    def __init__(self, arglist=[], cls=None):
        qt.QApplication.__init__(self, arglist)
        app.PApplicationBase.__init__(self, arglist, cls)
        self.mainwin = self.createMainWidget()
        self.setMainWidget(self.mainwin)
        
        # 'automagic' signal connection
        self.setup_notify(SIGNAL_BEFOREQUIT, self.before_quit)
    
    def _eventloop(self):
        self.exec_loop()
