#!/usr/bin/env python
"""
TEST_STDLIB_BASESEQUENCE.PY -- test script for plib.stdlib.basesequence
Copyright (C) 2008-2009 by Peter A. Donis

Released under the GNU General Public License, Version 2
See the LICENSE and README files for more information

This script contains unit tests for the basesequence class.
"""

import unittest

from plib.stdlib import basesequence

import stdlib_abstract_testlib

class testsequence(basesequence):
    def __init__(self, seq=None):
        self._storage = []
        if seq:
            self._storage.extend(seq)
    def __len__(self):
        return len(self._storage)
    def _get_data(self, index):
        return self._storage[index]
    def _set_data(self, index, value):
        self._storage[index] = value

class Test_basesequence(stdlib_abstract_testlib.FixedLengthSequenceTest):
    type2test = testsequence

if __name__ == '__main__':
    unittest.main()
