# encoding: utf-8

from setuptools import setup, find_packages
import os.path

# Package data
# ------------

_name            = 'plonetheme.blacklotus'
_version         = '1.0.0'
_description     = '"Black Lotus" theme for Plone'
_url             = 'http://seankelly.biz/products/plonetheme.blacklotus/'
_downloadURL     = 'http://github.com/tbd'
_author          = 'Sean Kelly'
_authorEmail     = 'kelly@seankelly.biz'
_maintainer      = 'Sean Kelly'
_maintainerEmail = 'kelly@seankelly.biz'
_license         = 'GPL version 2'
_namespaces      = ['plonetheme']
_zipSafe         = False
_keywords        = 'plone zope site website theme'
_testSuite       = 'plonetheme.blacklotus.tests.test_suite'

_extras = {
    'test': ['plone.app.testing'],
}
_entryPoints = {
    'z3c.autoinclude.plugin': ['target=plone'],
}
_requirements = [
    'setuptools',
    'Products.CMFPlone',
    'plonetheme.sunburst',
]
_classifiers = [
    'Development Status :: 4 - Beta',
    'Environment :: Web Environment',
    'Framework :: Plone',
    'License :: OSI Approved :: GNU General Public License (GPL)',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
    'Topic :: Internet :: WWW/HTTP',
    'Topic :: Software Development :: Libraries :: Python Modules',
]

# Setup Metadata
# --------------
#
# Nothing below here should require updating.

def _read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

_header = '*' * len(_name) + '\n' + _name + '\n' + '*' * len(_name)
_longDescription = _header + '\n\n' + _read('README.rst') + '\n\n' + _read('docs', 'INSTALL.rst') + '\n\n' \
    + _read('docs', 'HISTORY.rst') + '\n\n' + _read('docs', 'LICENSE.rst')
open('doc.txt', 'w').write(_longDescription)

setup(
    author=_author,
    author_email=_authorEmail,
    classifiers=_classifiers,
    description=_description,
    download_url=_downloadURL,
    entry_points=_entryPoints,
    extras_require=_extras,
    include_package_data=True,
    install_requires=_requirements,
    keywords=_keywords,
    license=_license,
    long_description=_longDescription,
    maintainer=_maintainer,
    maintainer_email=_maintainerEmail,
    name=_name,
    namespace_packages=_namespaces,
    packages=find_packages('src', exclude=['ez_setup', 'bootstrap']),
    package_dir={'': 'src'},
    test_suite=_testSuite,
    url=_url,
    version=_version,
    zip_safe=_zipSafe,
)
