# encoding: utf-8

u'''"Black Lotus" Plone Theme — setup tests'''

from plonetheme.blacklotus.testing import BLACK_LOTUS_PLONE_THEME_INTEGRATION_TESTING
from Products.CMFCore.utils import getToolByName
import unittest2 as unittest

class SetupTest(unittest.TestCase):
    layer = BLACK_LOTUS_PLONE_THEME_INTEGRATION_TESTING
    def setUp(self):
        super(SetupTest, self).setUp()
        self.portal = self.layer['portal']
    def testThemeActivation(self):
        u'''Ensure "Black Lotus" is active.'''
        skins = getToolByName(self.portal, 'portal_skins')
        self.assertEquals('Black Lotus Theme', skins.getDefaultSkin())
    def testSkinPathOrder(self):
        u'''Check that filesystem directories appear in the right order'''
        skins = getToolByName(self.portal, 'portal_skins')
        paths = skins.getSkinPath('Black Lotus Theme').split(',')
        styles, images = paths.index('blacklotus_styles'), paths.index('blacklotus_images')
        sunburst, index = -1, 0
        for i in paths:
            if i.startswith('sunburst_'):
                sunburst = index
                break
            index += 1
        self.assertTrue(styles < sunburst, u'Sunburst has higher priority than blacklotus_styles')
        self.assertTrue(images < sunburst, u'Sunburst has higher priority than blacklotus_images')

    
def test_suite():
    return unittest.defaultTestLoader.loadTestsFromName(__name__)

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
