#!/usr/bin/env python

import sys
import logging

def parse_lines(log_parsers, fileinp):
    """parse lines from the fileinput and send them to the log_parsers"""
    while 1:
        line = fileinp.readline()
        #print line
        if not line:
            break
        elif not line.rstrip():
            continue  # skip newlines

        for lp in log_parsers:
            if lp.parse(line):
                break
        else:
            # error: none of the logparsers worked on the line
            logger = logging.getLogger('logparser')
            logger.warning(
                #'Could not parse line %s, in file %s >>>%s<<<',
                #fileinp.lineno(), fileinp.filename(), line.rstrip())
                'Could not parse line >>>%s<<<', line.rstrip())


class LogParser(object):
    """holds a reference to the database and the regular expression"""
    def __init__(self, re_compiled, callbacks={}, db=None, tablename='logentries'):
        self.callbacks = callbacks
        self.re = re_compiled
        self.tablename = tablename

        self.db = db
        if db:
            # initialize database
            c = self.db.cursor()
            c.execute('create table ' + tablename + '(' +
                ', '.join(self.re.groupindex.keys() +
                self.callbacks.keys()) + ')')
            c.close()

    def parse(self, line):
        """parse one line and put the results into the database"""
        #print 'entry: ' + line
        match = self.re.match(line)
        if match:
            #print match.groupdict()
            values = match.groupdict()
            cb_values = [self.callbacks[x](**values) for x in self.callbacks]
            if self.db:
                # insert values into the database
                c = self.db.cursor()
                c.execute('insert into ' + self.tablename + '(' +
                    ', '.join(values.keys() + self.callbacks.keys()) +
                    ') values (' + ', '.join(['?'] * (len(values) +
                    len(self.callbacks))) + ')',
                    [] + values.values() + cb_values)
                c.close()
            return True
        else:
            return False  # line did not match, continue with next logparser
