#!/usr/bin/env python

"""
This is the document server for aogaeru plot
"""

import time
import SocketServer
import SimpleHTTPServer
import urlparse
import json
import os
import sys
import logging
import csv

from __init__ import __version__
from datastore import Datastore

here = lambda x: os.path.abspath(os.path.join(os.path.dirname(__file__), x))

SERVER_HOST = '0.0.0.0'
SERVER_APIPREFIX = 'rest'

#TODO: test this!

class RestHandler(SimpleHTTPServer.SimpleHTTPRequestHandler):
    server_version = 'plotserver/' + __version__

    def __init__(self, *args, **kwargs):
        self.datastore = Datastore()
        SimpleHTTPServer.SimpleHTTPRequestHandler.__init__(self, *args, **kwargs)

    def do_HEAD(self, content_type="application/json"):
        self.send_response(200)
        self.send_header("Content-type", content_type)
        self.end_headers()

    def do_GET(self):
        """Respond to a GET request."""
        # Example (using cURL):
        # curl -X GET 'http://localhost:8000/rest/13060317/'
        url = urlparse.urlparse(self.path)
        path_elements = url.path.strip('/').split('/')
        query = {key: value[0] for (key, value) in  urlparse.parse_qs(url.query).iteritems()}
        if path_elements.pop(0) != SERVER_APIPREFIX:
            SimpleHTTPServer.SimpleHTTPRequestHandler.do_GET(self)
        elif len(path_elements) == 1:
            testrun = path_elements[0]
            try:
                result = self.datastore.list_hosts(testrun)
                self.do_HEAD()
                if result:
                    self.wfile.write(json.dumps(result))
            except KeyError:
                self.send_error(404, 'Invalid record id')
        elif len(path_elements) == 2:
            testrun, host = path_elements
            try:
                result = self.datastore.list_metrics(testrun, host)
                self.do_HEAD()
                if result:
                    self.wfile.write(json.dumps(result))
            except KeyError:
                self.send_error(404, 'Invalid record id')
        elif len(path_elements) == 3:
            testrun, host, metric = path_elements
            try:
                result = self.datastore.read(testrun, host, metric, query)
                self.do_HEAD('text/csv')
                if result:
                    writer = csv.writer(self.wfile)
                    for row in result:
                        writer.writerow(row)
            except KeyError:
                self.send_error(404, 'Metric not found')
        else:
            self.send_error(404,
                'Use existing /%s/<testrun>/<host>/<metric> document access'
                    % SERVER_APIPREFIX)

    '''
    def do_POST(self):
        """Respond to a POST request."""
        # Example (using cURL):
        # curl -X POST -d '{"name":"Ferrari Enzo","country":"Italy","top_speed":"218","0-60":"3.4","power":"650","engine":"5998","weight":"1365","description":"The Enzo Ferrari is a 12 cylinder mid-engine berlinetta named after the company\"s founder, Enzo Ferrari.","image":"050.png"}' 'http://localhost:8000/rest/supercars/'

        url = urlparse.urlparse(self.path)
        path_elements = url.path.strip('/').split('/')
        print 'path_elements: %s' % path_elements
        if path_elements[1] != 'supercars':
            self.send_error(404,
                'Use existing /%s/supercars/_id for document access'
                    % SERVER_APIPREFIX)
        elif len(path_elements) == 2:
            api, table = path_elements
            content_len = int(self.headers.getheader('content-length'))
            try:
                data = json.loads(self.rfile.read(content_len))
                if data:
                    oid = self.next_id()
                    data['_id'] = oid
                    self.supercars[oid] = data
                    self.do_HEAD()
                    if oid:
                        self.wfile.write('{"_id": "%s"}' % oid)
                else:
                    self.send_error(400, 'No data received')
            except ValueError:
                self.send_error(400, 'Invalid data')
        else:
            self.send_error(404,
                'Use existing /%s/supercars/ to create documents'
                    % SERVER_APIPREFIX)

    def do_PUT(self):
        """Respond to a PUT request."""
        # Example (using cURL):
        # curl -X PUT -d '{TODO}' 'http://localhost:8000/rest/supercars/4fb8ad99b0ab584586000000'

        url = urlparse.urlparse(self.path)
        path_elements = url.path.strip('/').split('/')
        if path_elements[1] != 'supercars':
            self.send_error(404,
                'Use existing /%s/supercars/_id for document access'
                    % SERVER_APIPREFIX)
        elif len(path_elements) == 3:
            api, table, oid = path_elements
            content_len = int(self.headers.getheader('content-length'))
            try:
                data = json.loads(self.rfile.read(content_len))
                if data:
                    data['_id'] = oid
                    self.supercars[oid] = data
                    self.do_HEAD()
            except ValueError:
                self.send_error(400, 'Invalid data')
        else:
            self.send_error(404,
                'Use existing /%s/supercars/_id/ for updating a document'
                    % SERVER_APIPREFIX)

    def do_DELETE(self):
        """Respond to a DELETE request."""
        # Example (using cURL):
        # curl -X DELETE 'http://localhost:8000/rest/supercars/4fb8a590b0ab582e8e000001'

        url = urlparse.urlparse(self.path)
        path_elements = url.path.strip('/').split('/')
        if path_elements[1] != 'supercars':
            self.send_error(404,
                'Use existing /%s/supercars/_id for document access'
                    % SERVER_APIPREFIX)
        elif len(path_elements) == 3:
            api, table, oid = path_elements
            if oid in self.supercars:
                self.supercars.pop(oid)
                self.do_HEAD()
            else:
                self.send_error(404,
                    'record does not exist')
        else:
            self.send_error(404,
                'Use existing /%s/supercars/_id/ to delete documents'
                    % SERVER_APIPREFIX)
    '''

    def log_message(self, format, *args):
        pass  # shut up!


if __name__ == '__main__':
    if len(sys.argv) == 1:
        print "You need to provide a port number as 1st argument such as 8000!"
    logging.basicConfig(
        filename='plot_error.log',
        level=logging.WARNING,
        format='%(asctime)s %(message)s'
    )
    server_class = SocketServer.TCPServer
    httpd = server_class((SERVER_HOST, int(sys.argv[1])), RestHandler)
    print time.asctime(), "Server Starts - %s:%s" % (SERVER_HOST, sys.argv[1])
    if len(sys.argv) > 2:
        os.chdir(sys.argv[2])
    try:
        httpd.serve_forever()
    except KeyboardInterrupt:
        pass
    httpd.server_close()
    print time.asctime(), "Server Stops - %s:%s" % (SERVER_HOST, sys.argv[1])
