#!/usr/bin/env python
# -*- coding: utf-8 -*-

from plot import __version__
import re
import os
from distutils.core import setup

def find_pattern_files():
    return [os.path.join('patterns', file) for file in os.listdir('patterns')
        if re.match(r'^[\w-]+$', file)]

setup(
    author='Mark Fink',
    author_email='mark@mark-fink.de',
    description='Interactive metric visualizer.',
    long_description=open('README.md').read(),
    url='https://github.com/aogaeru/plot',
    name='plot',
    version=__version__,
    packages=['plot'],
    data_files=[('patterns', find_pattern_files()), 'README.md'],
    install_requires=['korg >= 0.0.2'],
    license='MIT License',
    classifiers=[
        'License :: OSI Approved :: MIT License',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'Development Status :: 3 - Alpha',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Operating System :: OS Independent',
        'Topic :: System :: Systems Administration',
        'Natural Language :: English',
    ],
)
