import sys
import logging
from zope.component import adapter
from zope.component import getUtility, queryUtility

from Acquisition import aq_parent
from zope.app.component.hooks import getSite
from Products.CMFCore.utils import getToolByName
from zope.component import getSiteManager
from Products.CMFCore.interfaces import IActionSucceededEvent
from Products.Archetypes.interfaces import IObjectInitializedEvent, IObjectEditedEvent
from zope.lifecycleevent.interfaces import IObjectAddedEvent

from plumi.content.interfaces.plumivideo import IPlumiVideo
from plone.app.discussion.interfaces import IComment
from plumi.content.interfaces.workflow import IPlumiWorkflow
from plumi.content.metadataextractor import setup_metadata
from plumi.content import plumiMessageFactory as _
from collective.transcode.star.interfaces import ITranscodedEvent, ITranscodeTool
from plone.app.discussion.interfaces import ICommentingTool
from DateTime import DateTime
from urllib2 import urlopen
import socket
from PIL import Image


logger = logging.getLogger('plumi.content.subscribers')

@adapter(IPlumiVideo, ITranscodedEvent)
def notifyTranscodeSucceededPlumiVideo(obj, event):
    if event.profile == 'jpeg':
        imgfield = obj.getField('thumbnailImage') # check if there is already a thumbnail image
        if not imgfield or imgfield.getSize(obj) == (0, 0): # if not use the image returned by the transcoder
            try:
                tt = getUtility(ITranscodeTool)
                entry = tt[obj.UID()]['video_file'][event.profile]                
                url = '%s/%s' % (entry['address'], entry['path'])
                portal = getSiteManager()
                skins_tool = getToolByName(portal, 'portal_skins')
                defaultthumb = skins_tool['plumi_skin_custom_images']['defaultthumb.jpeg']
                try:
                    logger.info("getting thumbnail from %s" % url)
                    socket.setdefaulttimeout(10)
                    f = urlopen(url)
                    #check if the file is actually a jpeg image else use a standard one
                    try:
                        i = Image.open(url)
                        if i.format == 'JPEG':
                            logger.info('setting thumbnail to %s' % entry['path'])                      
                            obj.setThumbnailImage(f.read())
                            #self.reindexObject()
                        else:
                            obj.setThumbnailImage(defaultthumb)
                    except:
                        obj.setThumbnailImage(defaultthumb)
                except:
                    logger.warn("Can't retrieve thumbnail from %s. Most likely due to a XML-RPC deadlock between Twisted and Plone." % url)
                    logger.warn("Plumi will now assume that the thumbnail is accessible through the filesystem in the transcoded directory to facilitate dev builds. If using in production you should always serve the transcoded videos through Apache")
                    try:
                        i = Image.open(url[url.find('transcoded'):])
                        if i.format == 'JPEG':
                            f = open(url[url.find('transcoded'):],'r')  
                            logger.info('setting thumbnail to %s' % entry['path'])                      
                            obj.setThumbnailImage(f.read())
                            #self.reindexObject()
                        else:
                            obj.setThumbnailImage(defaultthumb)
                    except:
                        obj.setThumbnailImage(defaultthumb)         
                f.close()
            except:
                logger.error("cannot set thumbnail for %s. Error %s" % (obj, sys.exc_info()[0]))


@adapter(IPlumiVideo, IActionSucceededEvent)
def notifyActionSucceededPlumiVideo(obj,event):
    """This gets called on IActionSucceededEvent - called whenever the object is transistioned thru workflow states."""
    workflow = getToolByName(obj,'portal_workflow')
    state = workflow.getInfoFor(obj,'review_state','')
    request = getSite().REQUEST 
    wf_action = request.get('workflow_action','')
    log = logging.getLogger('plumi.content.subscribers')
    log.info("notifyActionSuceededPlumiVideo... %s in state (%s) with event %s " % (obj.Title(), state,  event))
    #decide what to do , based on workflow of object
    #PUBLISHED
    log.info(state)
    if wf_action == 'retract':
        log.info('video retracted')
        IPlumiWorkflow(obj).notifyOwnerVideoRetracted()
        IPlumiWorkflow(obj).notifyReviewersVideoRetracted()        
    elif wf_action == 'reject':
        log.info('video rejected')    
        IPlumiWorkflow(obj).notifyOwnerVideoRejected()
        IPlumiWorkflow(obj).notifyReviewersVideoRejected()
    elif state == 'pending' and not request.has_key('form.button.save'):
        log.info('video submitted for review')        
        IPlumiWorkflow(obj).notifyReviewersVideoSubmitted()
        IPlumiWorkflow(obj).notifyOwnerVideoSubmitted()
    elif state == 'published':
        log.info('doing published tasks')

        obj.reindexObject()

        #refresh the catalog
        #XXX make it configurable to run a catalog refresh each time , or not?
        #portal_catalog = getToolByName(obj,'portal_catalog')
        #portal_catalog.refreshCatalog()

        #update the tag cloud
        portal_url = getToolByName(obj, "portal_url")
        portal = portal_url.getPortalObject()
        tc = getattr(portal,'tagcloud',None)
        if tc is not None:
            log.info('FIXME - refresh tag cloud!')
            # XXX re-implement vaporisation compatibility
            #notify(TreeUpdateEvent(tc))
        #emails 
        IPlumiWorkflow(obj).notifyOwnerVideoPublished()

@adapter(IPlumiVideo, IObjectEditedEvent)
def notifyModifiedPlumiVideo(obj ,event):
    """This gets called on IObjectEditedEvent - called whenever the object is edited."""
    workflow = getToolByName(obj,'portal_workflow')
    state = workflow.getInfoFor(obj,'review_state','')
    log = logging.getLogger('plumi.content.subscribers')
    log.info("notifyModifiedPlumiVideo... %s in state (%s) with event %s " % (obj.Title(), state,  event))
    request = getSite().REQUEST    
    #VISIBLE
    if state == 'visible' and request.has_key('form.button.save'):
        #call IPlumiWorkflow API to decide if its ready to publish or needs hiding.
        # The adapter object will implement the logic for various content types
        if IPlumiWorkflow(obj).autoPublishOrHide():
            IPlumiWorkflow(obj).notifyReviewersVideoSubmitted()
            IPlumiWorkflow(obj).notifyOwnerVideoSubmitted()
    #PENDING , other states..
    if request.has_key('video_file_file'): #new video uploaded
        log.info('notifyModifiedPlumiVideo: video replaced;')
        setup_metadata(obj)
        #setup_transcoding(obj)
    #THE END

@adapter(IPlumiVideo, IObjectInitializedEvent)
def notifyInitPlumiVideo(obj ,event):
    """This gets called on IObjectInitializedEvent - which occurs when a new object is created."""
    workflow = getToolByName(obj,'portal_workflow')
    state = workflow.getInfoFor(obj,'review_state','')
    log = logging.getLogger('plumi.content.subscribers')
    log.info("notifyInitPlumiVideo... %s in state (%s) with event %s " % (obj.Title(), state,  event))
    #decide what to do , based on workflow of object
    state = workflow.getInfoFor(obj,'review_state')
    request = getSite().REQUEST    
    #VISIBLE
    if state == 'visible' and request.has_key('form.button.save'):
        #call IPlumiWorkflow API to decide if its ready to publish or needs hiding.
        # The adapter object will implement the logic for various content types
        if IPlumiWorkflow(obj).autoPublishOrHide():
            IPlumiWorkflow(obj).notifyOwnerVideoSubmitted()
            IPlumiWorkflow(obj).notifyReviewersVideoSubmitted()

    setup_metadata(obj)
    #setup_transcoding(obj)
    #THE END

@adapter(IPlumiVideo, IObjectInitializedEvent)
def autoSubmit(obj, event):
    """ Automatically submit news items, events & callouts """
    log = logging.getLogger('plumi.content.subscribers')    
    workflow = getToolByName(obj,'portal_workflow')
    try:
        state = workflow.getInfoFor(obj,'review_state')
        #dont try to resubmit if already published.
        if not state in ['published','pending']:
            workflow.doActionFor(obj, 'submit')
            log.info('autosubmit %s' % obj)
        worked = True
    except WorkflowException:
        worked = False
        log.info('failed to autosubmit %s' % obj)        
        pass

@adapter(IComment, IObjectAddedEvent)
def commentAdded(obj ,event):
    """Reindex added comments and set correct modification date"""
    log = logging.getLogger('plumi.content.subscribers')    
    commenttool = queryUtility(ICommentingTool)
    obj.setModificationDate(DateTime())
    obj.setCreationDate(DateTime())
    commenttool.reindexObject(obj)
                        
def notifyCommentAdded(obj ,event):
    """Notify owner of added comment"""
    log = logging.getLogger('plumi.content.subscribers')
    urltool = getToolByName(obj, 'portal_url')
    portal = urltool.getPortalObject()
    video = aq_parent(aq_parent(obj))
    videoUrl = video.absolute_url()
    
    creator= video.Creator()
    membr_tool = getToolByName(obj,'portal_membership')
    member=membr_tool.getMemberById(creator)
    mTo = member.getProperty('email',None)
    log.info('notifyCommentAdded')
    if mTo:
        mFrom = portal.getProperty('email_from_address')
        mSubj = _('Comment added on: ') + video.Title().decode('utf-8')
        mMsg = _('Hi ') + member.getProperty('fullname', creator)
        mMsg += '\n\n' + _('A comment has been added on ') + videoUrl + '\n\n'
        try:            
	    portal.MailHost.send(mMsg.encode('utf-8', 'ignore'), mTo, mFrom, mSubj.encode('utf-8', 'ignore'))
            log.info('notifyCommentAdded , im %s . sending email to %s from %s ' % (obj, mTo, mFrom) )
        except:
	    log.error('Didnt actually send email to contribution owner! Something amiss with SecureMailHost.')
