#!/usr/bin/python

"""
Copyright (C) 2014 DK

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""

import sys
import os
import time
import getopt
import hashlib
import shutil
import pipes

flags, non_flags = getopt.gnu_getopt(sys.argv[1:], 'ubc:', ['di', 'ci', 'log', 'unidiff', 'ignore-space-change', 'color', 'change-rev=', 'restore'])

op = None
unidiff = False
ignore_space = False
colordiff = False
change_rev = None
restore = True

for name, value in flags:
	if name in ('--di', '--ci', '--log', '--restore'):
		op = name[2:]
	if name in ('-u', '--unidiff'):
		unidiff = True
	if name in ('-b', '--ignore-space-change'):
		ignore_space = True
	if name in ('--color',):
		colordiff = True
	if name in ('-c', '--change-rev'):
		change_rev = int(value)

if not op:
	op = 'di'

def find_version_list(target_filename):
	target_dir = os.path.dirname(target_filename) or '.'
	target_nameonly = os.path.basename(target_filename)
	for sibling_nameonly in os.listdir(target_dir):
		if len(sibling_nameonly) > len(target_nameonly)+2 \
			and sibling_nameonly[:1]=='.' \
			and sibling_nameonly[1:len(target_nameonly)+1]==target_nameonly \
			and sibling_nameonly[1+len(target_nameonly)]=='.' \
			and sibling_nameonly[2+len(target_nameonly):].isdigit() \
			:
			yield os.path.join(target_dir, sibling_nameonly)

for target_filename in non_flags:
	print
	print '#', repr(target_filename)
	assert os.path.exists(target_filename), "ERROR: target doesn't exist: %s" % repr(target_filename)
	target_ts = int(os.path.getmtime(target_filename))
	target_md5 = hashlib.md5(open(target_filename,'rb').read()).hexdigest()
	snapshot_filename = os.path.join( os.path.dirname(target_filename),  '.%s.%s' % (os.path.basename(target_filename), target_ts) )
	snapshot_is_current = False
	if os.path.exists(snapshot_filename):
		snapshot_md5 = hashlib.md5(open(snapshot_filename,'rb').read()).hexdigest()
		assert snapshot_md5==target_md5, "ERROR: snapshot exists but MD5 doesn't match"
		print "# OK", repr(target_filename), "<-", repr(snapshot_filename)
		snapshot_is_current = True
	if False:
		pass
	elif op=='ci' and not snapshot_is_current:
		print "# ci", repr(target_filename), "->", repr(snapshot_filename)
		print "cp -vp", repr(target_filename), repr(snapshot_filename)
		shutil.copy2(target_filename, snapshot_filename)
	elif op=='ci':
		print '# ==', repr(target_filename), '<-', repr(snapshot_filename)
	elif op=='di' and (change_rev or not snapshot_is_current):
		version_list = list(find_version_list(target_filename))
		version_list.sort()
		version_list_ext = version_list + [ target_filename ]
		if change_rev:
			assert change_rev-1 in range(len(version_list_ext))
			rev_filename = version_list_ext[change_rev-1]
			if change_rev > 1:
				last_filename = version_list_ext[change_rev-2]
			else:
				last_filename = '/dev/null'
		else:
			rev_filename = target_filename
			if version_list:
				last_filename = version_list[-1]
			else:
				last_filename = '/dev/null'
		print '# MM', repr(target_filename)
		if version_list:
			print '# diff', pipes.quote(last_filename), pipes.quote(rev_filename)
			sys.stdout.flush()
			diffcmd = 'diff'
			if colordiff:
				diffcmd = 'colordiff'
			if unidiff:
				diffcmd += ' -u'
			if ignore_space:
				diffcmd += ' -b'
			ret = os.system('%s %s %s' % (diffcmd, pipes.quote(last_filename), pipes.quote(rev_filename)))
			sys.exit(ret)
		else:
			print '# ++', repr(target_filename)
	elif op=='di':
		print '# ==', repr(target_filename), '<-', repr(snapshot_filename)
	elif op=='restore':
		version_list = list(find_version_list(target_filename))
		version_list.sort()
		version_list_ext = version_list + [ target_filename ]
		assert change_rev and change_rev-1 in range(len(version_list_ext))
		rev_filename = version_list_ext[change_rev-1]
		print '# restore %s <= %s' % (pipes.quote(target_filename), pipes.quote(rev_filename))
		ret = os.system('cp -vp %s %s' % (pipes.quote(rev_filename), pipes.quote(target_filename)))
		sys.exit(ret)
	elif op=='log':
		version_list = list(find_version_list(target_filename))
		version_list.sort()
		version_list_ext = version_list + [ target_filename ]
		for version_index in range(len(version_list_ext)):
			version_rev = version_index+1
			version_filename = version_list_ext[version_index]
			version_ts = int(os.path.getmtime(version_filename))
			version_tm = time.localtime(version_ts)
			version_time_str = time.strftime('%Y-%m-%d %H:%M:%S', version_tm)
			print '# [r%d] [%s] %s' % (version_rev, version_time_str, version_filename)
	else:
		raise Exception, "ERROR: unexpected op - %s" % repr(op)

