from card import Card

class LookupTables:
    """
    Top level attributes are general, like primes, deck, etc
    """
    primes = [2,3,5,7,11,13,17,19,23,29,31,37,41]
    deck = set((
        Card(2,1), Card(2,2), Card(2,3), Card(2,4),
        Card(3,1), Card(3,2), Card(3,3), Card(3,4),
        Card(4,1), Card(4,2), Card(4,3), Card(4,4),
        Card(5,1), Card(5,2), Card(5,3), Card(5,4),
        Card(6,1), Card(6,2), Card(6,3), Card(6,4),
        Card(7,1), Card(7,2), Card(7,3), Card(7,4),
        Card(8,1), Card(8,2), Card(8,3), Card(8,4),
        Card(9,1), Card(9,2), Card(9,3), Card(9,4),
        Card(10,1), Card(10,2), Card(10,3), Card(10,4),
        Card(11,1), Card(11,2), Card(11,3), Card(11,4),
        Card(12,1), Card(12,2), Card(12,3), Card(12,4),
        Card(13,1), Card(13,2), Card(13,3), Card(13,4),
        Card(14,1), Card(14,2), Card(14,3), Card(14,4)
    ))

    class Two:
        """
        Next 3 lookups are for Zach's pre-flop eval
        TODO: Remove these tables since we precalcuate the percentiles
        """
        preflop_order_matrix = [
            [87,169,168,166,167,165,159,149,135,121,105,86,59],
            [163,66,164,161,162,160,157,144,131,116,98,80,53],
            [158,150,48,153,154,151,148,140,125,111,93,74,49],
            [155,146,136,27,145,141,137,130,122,107,89,69,41],
            [156,147,138,128,17,133,127,120,112,102,81,62,42],
            [152,143,134,124,115,9,117,109,101,92,77,58,36],
            [142,139,129,119,110,100,7,99,91,79,68,51,32],
            [132,126,123,113,103,94,83,6,78,70,56,40,25],
            [118,114,108,106,96,84,73,64,5,57,47,33,19],
            [104,97,95,90,85,75,65,55,45,4,39,26,15],
            [88,82,76,72,67,61,52,43,34,28,3,23,14],
            [71,63,60,54,50,44,37,29,22,20,16,2,12],
            [46,38,35,30,31,24,21,18,13,11,10,8,1]
        ]
        preflop_count_matrix = [
            3,3,3,3,3,3,3,2,3,2,2,6,2,6,6,2,3,2,6,2,
            2,2,6,2,6,6,3,2,2,2,2,6,6,2,2,6,2,2,6,6,
            6,6,2,2,2,2,6,3,6,2,6,2,6,2,2,6,6,6,6,2,
            2,6,2,2,2,3,2,6,6,6,2,2,2,6,2,2,6,6,6,6,
            6,2,2,2,2,6,3,2,6,2,6,6,6,2,2,2,2,6,6,2,
            6,6,2,2,6,2,6,2,6,2,6,6,2,2,2,6,6,2,2,6,
            6,6,2,2,6,2,6,2,2,6,6,2,6,2,6,2,6,2,2,6,
            6,2,2,6,6,2,2,6,6,2,6,2,6,6,2,2,6,2,6,6,
            6,6,2,6,6,6,6,6,6
        ]
        preflop_count_sum = 663.0
        
        # Table for suited 2-card hands
        # The row corresponds to the lower of the two cards
        # TODO: I think this should be a symmetric matrix
        # to remove the sorting requirement
        suited_ranks_to_percentile = [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0.05731523378582204, 0.096530920060331815, 0.11161387631975872, 0.10859728506787325, 0.13273001508295623, 0.19306184012066363, 0.25339366515837103, 0.33785822021116141, 0.42232277526395179, 0.51885369532428349, 0.61387631975867274, 0.76470588235294112, 0],
            [0, 0, 0, 0, 0.14479638009049778, 0.16892911010558065, 0.16591251885369529, 0.19004524886877827, 0.21417797888386125, 0.28959276018099545, 0.36199095022624439, 0.46757164404223228, 0.54449472096530926, 0.65761689291101055, 0.81297134238310709, 0],
            [0, 0, 0, 0, 0, 0.22926093514328805, 0.21719457013574661, 0.24132730015082959, 0.27450980392156865, 0.30467571644042235, 0.39819004524886881, 0.473604826546003, 0.59276018099547512, 0.67269984917043746, 0.82805429864253388, 0],
            [0, 0, 0, 0, 0, 0, 0.27752639517345401, 0.30165912518853699, 0.33484162895927605, 0.36500754147812975, 0.41025641025641024, 0.50678733031674206, 0.61085972850678738, 0.71493212669683259, 0.85520361990950222, 0],
            [0, 0, 0, 0, 0, 0, 0, 0.35897435897435892, 0.38612368024132726, 0.42533936651583715, 0.47058823529411764, 0.53544494720965308, 0.64404223227752633, 0.73906485671191557, 0.85218702865761686, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0.44645550527903466, 0.47662141779788836, 0.53846153846153844, 0.59577677224736048, 0.6696832579185521, 0.77073906485671195, 0.8868778280542986, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0.54147812971342391, 0.60784313725490202, 0.65158371040723984, 0.72699849170437414, 0.81598793363499245, 0.90196078431372551, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.65460030165912519, 0.71191553544494723, 0.77375565610859731, 0.85822021116138769, 0.9170437405731523, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.76772247360482648, 0.83107088989441924, 0.89894419306184015, 0.94570135746606332, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.86123680241327305, 0.90497737556561086, 0.95776772247360487, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.92458521870286581, 0.96078431372549022, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.96832579185520362, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ]
        
        # Table for unsuited 2-card hands
        # For some reason I actually bothered to make this one
        # symmetric and not the other one
        unsuited_ranks_to_percentile = [
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0.52337858220211153, 0.0090497737556560764, 0.018099547511312264, 0.036199095022624417, 0.02714932126696834, 0.045248868778280493, 0.093514328808446456, 0.15384615384615385, 0.23831070889894423, 0.3227752639517345, 0.41930618401206632, 0.53242835595776772, 0.68174962292609353, 0],
            [0, 0, 0.0090497737556560764, 0.64856711915535448, 0.054298642533936681, 0.075414781297134192, 0.066365007541478116, 0.08446455505279038, 0.10558069381598789, 0.18702865761689291, 0.26244343891402711, 0.35595776772247356, 0.46455505279034692, 0.56259426847662142, 0.72398190045248867, 0],
            [0, 0, 0.018099547511312264, 0.054298642533936681, 0.75263951734539969, 0.12971342383107087, 0.1206636500754148, 0.14177978883861242, 0.16289592760180993, 0.21116138763197589, 0.29864253393665163, 0.3831070889894419, 0.48567119155354455, 0.60482654600301666, 0.74811463046757165, 0],
            [0, 0, 0.036199095022624417, 0.075414781297134192, 0.12971342383107087, 0.86576168929110109, 0.17797888386123684, 0.20211161387631971, 0.22624434389140269, 0.27149321266968329, 0.31372549019607843, 0.40723981900452488, 0.51583710407239813, 0.63197586726998489, 0.79185520361990946, 0],
            [0, 0, 0.02714932126696834, 0.066365007541478116, 0.1206636500754148, 0.17797888386123684, 0.92156862745098045, 0.25037707390648567, 0.28657616892911009, 0.33182503770739069, 0.37405731523378583, 0.43438914027149322, 0.55354449472096534, 0.66666666666666674, 0.78280542986425339, 0],
            [0, 0, 0.045248868778280493, 0.08446455505279038, 0.14177978883861242, 0.20211161387631971, 0.25037707390648567, 0.96530920060331826, 0.34690799396681749, 0.39517345399698345, 0.4434389140271493, 0.49472096530920062, 0.58974358974358976, 0.69079939668174961, 0.82503770739064852, 0],
            [0, 0, 0.093514328808446456, 0.10558069381598789, 0.16289592760180993, 0.22624434389140269, 0.28657616892911009, 0.34690799396681749, 0.97285067873303166, 0.45550527903469085, 0.5037707390648567, 0.57164404223227749, 0.64102564102564097, 0.73604826546003022, 0.8491704374057315, 0],
            [0, 0, 0.15384615384615385, 0.18702865761689291, 0.21116138763197589, 0.27149321266968329, 0.33182503770739069, 0.39517345399698345, 0.45550527903469085, 0.9773755656108597, 0.58069381598793357, 0.62292609351432882, 0.70889894419306176, 0.80090497737556565, 0.88386123680241324, 0],
            [0, 0, 0.23831070889894423, 0.26244343891402711, 0.29864253393665163, 0.31372549019607843, 0.37405731523378583, 0.4434389140271493, 0.5037707390648567, 0.58069381598793357, 0.98190045248868774, 0.69984917043740569, 0.76168929110105577, 0.84012066365007543, 0.91402714932126694, 0],
            [0, 0, 0.3227752639517345, 0.35595776772247356, 0.3831070889894419, 0.40723981900452488, 0.43438914027149322, 0.49472096530920062, 0.57164404223227749, 0.62292609351432882, 0.69984917043740569, 0.98642533936651589, 0.80995475113122173, 0.87481146304675717, 0.93363499245852188, 0],
            [0, 0, 0.41930618401206632, 0.46455505279034692, 0.48567119155354455, 0.51583710407239813, 0.55354449472096534, 0.58974358974358976, 0.64102564102564097, 0.70889894419306176, 0.76168929110105577, 0.80995475113122173, 0.99095022624434392, 0.89592760180995479, 0.94268476621417796, 0],
            [0, 0, 0.53242835595776772, 0.56259426847662142, 0.60482654600301666, 0.63197586726998489, 0.66666666666666674, 0.69079939668174961, 0.73604826546003022, 0.80090497737556565, 0.84012066365007543, 0.87481146304675717, 0.89592760180995479, 0.99547511312217196, 0.95475113122171951, 0],
            [0, 0, 0.68174962292609353, 0.72398190045248867, 0.74811463046757165, 0.79185520361990946, 0.78280542986425339, 0.82503770739064852, 0.8491704374057315, 0.88386123680241324, 0.91402714932126694, 0.93363499245852188, 0.94268476621417796, 0.95475113122171951, 1.0, 0]
        ]
        
    
    class Five:
        """
        Lookup tables for 5-card evaluator
        """
        # Map card rank and suit to our binary representation
        # card_to_binary[rank][suit]
        card_to_binary = [[], [],
            [0, 69634, 73730, 81922, 98306], 
            [0, 135427, 139523, 147715, 164099],
            [0, 266757, 270853, 279045, 295429],
            [0, 529159, 533255, 541447, 557831],
            [0, 1053707, 1057803, 1065995, 1082379],
            [0, 2102541, 2106637, 2114829, 2131213],
            [0, 4199953, 4204049, 4212241, 4228625],
            [0, 8394515, 8398611, 8406803, 8423187],
            [0, 16783383, 16787479, 16795671, 16812055],
            [0, 33560861, 33564957, 33573149, 33589533],
            [0, 67115551, 67119647, 67127839, 67144223],
            [0, 134224677, 134228773, 134236965, 134253349],
            [0, 268442665, 268446761, 268454953, 268471337]
        ]
        # Map flush AND value to rank of flushes in 5-card hands
        flushes = [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 1599, 0, 0, 0, 0, 0, 0, 0, 1598, 0, 0, 0, 1597, 0, 1596,
            8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1595, 0, 0, 0,
            0, 0, 0, 0, 1594, 0, 0, 0, 1593, 0, 1592, 1591, 0, 0, 0, 0, 0, 0,
            0,  0,  1590,  0, 0, 0, 1589, 0, 1588, 1587, 0, 0, 0, 0, 1586, 0,
            1585, 1584, 0, 0, 1583, 1582, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 1581, 0, 0, 0, 0, 0, 0, 0, 1580, 0, 0, 0,
            1579, 0, 1578, 1577, 0, 0, 0, 0, 0, 0, 0, 0, 1576, 0, 0, 0, 1575,
            0, 1574, 1573, 0, 0, 0, 0, 1572, 0, 1571, 1570, 0, 0, 1569, 1568,
            0, 1567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1566, 0, 0,  0,  1565,  0,
            1564, 1563, 0, 0, 0, 0, 1562, 0, 1561, 1560, 0, 0, 1559, 1558, 0,
            1557, 0, 0, 0, 0, 0, 0, 1556, 0, 1555, 1554, 0, 0, 1553, 1552, 0,
            1551, 0, 0, 0, 0, 1550, 1549, 0, 1548, 0, 0, 0, 6, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1547, 0, 0, 0,
            0, 0, 0, 0, 1546, 0, 0, 0, 1545, 0, 1544, 1543, 0, 0, 0, 0, 0, 0,
            0, 0, 1542, 0, 0, 0, 1541, 0, 1540, 1539, 0, 0, 0,  0,  1538,  0,
            1537, 1536, 0, 0, 1535, 1534, 0, 1533, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 1532, 0, 0, 0, 1531, 0, 1530, 1529, 0, 0, 0, 0, 1528, 0, 1527,
            1526, 0, 0, 1525, 1524, 0, 1523, 0, 0, 0, 0, 0, 0, 1522, 0, 1521,
            1520, 0, 0, 1519, 1518, 0, 1517, 0, 0, 0, 0, 1516, 1515, 0, 1514,
            0, 0, 0, 1513, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1512, 0,
            0, 0, 1511, 0, 1510, 1509, 0, 0, 0, 0, 1508, 0, 1507, 1506, 0, 0,
            1505, 1504, 0, 1503, 0, 0, 0, 0, 0, 0, 1502, 0, 1501, 1500, 0, 0,
            1499, 1498, 0, 1497, 0, 0, 0, 0, 1496, 1495, 0, 1494,  0,  0,  0,
            1493,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 1492, 0, 1491, 1490, 0, 0,
            1489, 1488, 0, 1487, 0, 0, 0, 0, 1486, 1485, 0, 1484,  0,  0,  0,
            1483, 0, 0, 0, 0, 0, 0, 0, 0, 1482, 1481, 0, 1480, 0, 0, 0, 1479,
            0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1478, 0, 0, 0, 0,
            0, 0, 0, 1477, 0, 0, 0, 1476, 0, 1475, 1474, 0, 0, 0, 0, 0, 0, 0,
            0, 1473, 0, 0, 0, 1472, 0, 1471, 1470, 0, 0, 0, 0, 1469, 0, 1468,
            1467, 0, 0, 1466, 1465, 0, 1464, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,
            1463,  0,  0,  0, 1462, 0, 1461, 1460, 0, 0, 0, 0, 1459, 0, 1458,
            1457, 0, 0, 1456, 1455, 0, 1454, 0, 0, 0, 0, 0, 0, 1453, 0, 1452,
            1451, 0, 0, 1450, 1449, 0, 1448, 0, 0, 0, 0, 1447, 1446, 0, 1445,
            0, 0, 0, 1444, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1443, 0,
            0, 0, 1442, 0, 1441, 1440, 0, 0, 0, 0, 1439, 0, 1438, 1437, 0, 0,
            1436, 1435, 0, 1434, 0, 0, 0, 0, 0, 0, 1433, 0, 1432, 1431, 0, 0,
            1430,  1429,  0,  1428, 0, 0, 0, 0, 1427, 1426, 0, 1425, 0, 0, 0,
            1424, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1423, 0, 1422,  1421,  0,  0,
            1420,  1419,  0,  1418, 0, 0, 0, 0, 1417, 1416, 0, 1415, 0, 0, 0,
            1414, 0, 0, 0, 0, 0, 0, 0, 0, 1413, 1412, 0, 1411, 0, 0, 0, 1410,
            0, 0, 0, 0, 0, 0, 0, 1409, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1408, 0, 0, 0, 1407, 0, 1406, 1405, 0,
            0, 0, 0, 1404, 0, 1403, 1402, 0, 0, 1401, 1400, 0, 1399, 0, 0, 0,
            0, 0, 0, 1398, 0, 1397, 1396, 0, 0, 1395, 1394, 0, 1393, 0, 0, 0,
            0, 1392, 1391, 0, 1390, 0, 0, 0, 1389, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 1388, 0, 1387, 1386, 0, 0, 1385, 1384, 0, 1383, 0,  0,  0,  0,
            1382, 1381, 0, 1380, 0, 0, 0, 1379, 0, 0, 0, 0, 0, 0, 0, 0, 1378,
            1377, 0, 1376, 0, 0, 0, 1375, 0, 0, 0, 0, 0, 0, 0, 1374, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1373, 0, 1372, 1371,
            0, 0, 1370, 1369, 0, 1368, 0, 0, 0, 0, 1367, 1366, 0, 1365, 0, 0,
            0,  1364,  0,  0, 0, 0, 0, 0, 0, 0, 1363, 1362, 0, 1361, 0, 0, 0,
            1360, 0, 0, 0, 0, 0, 0, 0, 1359, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 1358, 1357, 0, 1356, 0, 0, 0, 1355, 0, 0, 0, 0, 0,
            0, 0, 1354, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1353, 0, 0, 0, 0, 0, 0, 0, 1352, 0, 0, 0, 1351, 0, 1350, 1349, 0,
            0, 0, 0, 0, 0, 0, 0, 1348, 0, 0, 0, 1347, 0, 1346, 1345, 0, 0, 0,
            0, 1344, 0, 1343, 1342, 0, 0, 1341, 1340, 0, 1339, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 1338, 0, 0, 0, 1337, 0, 1336, 1335, 0,  0,  0,  0,
            1334, 0, 1333, 1332, 0, 0, 1331, 1330, 0, 1329, 0, 0, 0, 0, 0, 0,
            1328, 0, 1327, 1326, 0, 0, 1325, 1324, 0, 1323, 0, 0, 0, 0, 1322,
            1321, 0, 1320, 0, 0, 0, 1319, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 1318, 0, 0, 0, 1317, 0, 1316, 1315, 0, 0, 0,  0,  1314,  0,
            1313, 1312, 0, 0, 1311, 1310, 0, 1309, 0, 0, 0, 0, 0, 0, 1308, 0,
            1307, 1306, 0, 0, 1305, 1304, 0, 1303, 0, 0, 0, 0, 1302, 1301, 0,
            1300, 0, 0, 0, 1299, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1298, 0, 1297,
            1296, 0, 0, 1295, 1294, 0, 1293, 0, 0, 0, 0, 1292, 1291, 0, 1290,
            0, 0, 0, 1289, 0, 0, 0, 0, 0, 0, 0, 0, 1288, 1287, 0, 1286, 0, 0,
            0, 1285, 0, 0, 0, 0, 0, 0, 0, 1284, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1283, 0, 0, 0, 1282, 0, 1281,
            1280, 0, 0, 0, 0, 1279, 0, 1278, 1277, 0, 0, 1276, 1275, 0, 1274,
            0, 0, 0, 0, 0, 0, 1273, 0, 1272, 1271, 0, 0, 1270, 1269, 0, 1268,
            0, 0, 0, 0, 1267, 1266, 0, 1265, 0, 0, 0, 1264, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1263, 0, 1262, 1261, 0, 0, 1260, 1259, 0, 1258, 0, 0,
            0, 0, 1257, 1256, 0, 1255, 0, 0, 0, 1254, 0, 0, 0, 0, 0, 0, 0, 0,
            1253, 1252, 0, 1251, 0, 0, 0, 1250, 0, 0, 0, 0, 0, 0, 0, 1249, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1248, 0, 1247,
            1246, 0, 0, 1245, 1244, 0, 1243, 0, 0, 0, 0, 1242, 1241, 0, 1240,
            0, 0, 0, 1239, 0, 0, 0, 0, 0, 0, 0, 0, 1238, 1237, 0, 1236, 0, 0,
            0, 1235, 0, 0, 0, 0, 0, 0, 0, 1234, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 1233, 1232, 0, 1231, 0, 0, 0, 1230, 0, 0, 0, 0,
            0, 0, 0, 1229, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1228,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1227, 0, 0, 0,
            1226, 0, 1225, 1224, 0, 0, 0, 0, 1223, 0, 1222, 1221, 0, 0, 1220,
            1219, 0, 1218, 0, 0, 0, 0, 0, 0, 1217, 0, 1216, 1215, 0, 0, 1214,
            1213, 0, 1212, 0, 0, 0, 0, 1211, 1210, 0, 1209, 0, 0, 0, 1208, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1207, 0, 1206, 1205, 0, 0, 1204, 1203,
            0, 1202, 0, 0, 0, 0, 1201, 1200, 0, 1199, 0, 0, 0, 1198, 0, 0, 0,
            0, 0, 0, 0, 0, 1197, 1196, 0, 1195, 0, 0, 0, 1194, 0, 0, 0, 0, 0,
            0, 0, 1193, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1192, 0, 1191, 1190, 0, 0, 1189, 1188, 0, 1187, 0, 0, 0, 0, 1186,
            1185, 0, 1184, 0, 0, 0, 1183, 0, 0, 0, 0, 0, 0, 0, 0, 1182, 1181,
            0, 1180, 0, 0, 0, 1179, 0, 0, 0, 0, 0, 0, 0, 1178, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1177, 1176, 0, 1175,  0,  0,  0,
            1174, 0, 0, 0, 0, 0, 0, 0, 1173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1171, 0,
            1170, 1169, 0, 0, 1168, 1167, 0, 1166, 0, 0, 0, 0, 1165, 1164, 0,
            1163, 0, 0, 0, 1162, 0, 0, 0, 0, 0, 0, 0, 0, 1161, 1160, 0, 1159,
            0, 0, 0, 1158, 0, 0, 0, 0, 0, 0, 0, 1157, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 1156, 1155, 0, 1154, 0, 0, 0, 1153, 0, 0,
            0, 0, 0, 0, 0, 1152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1150, 1149, 0, 1148, 0, 0, 0,
            1147, 0, 0, 0, 0, 0, 0, 0, 1146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 1144, 0, 0, 0, 0, 0, 0, 0, 1143, 0, 0, 0, 1142,
            0, 1141, 1140, 0, 0, 0, 0, 0, 0, 0, 0, 1139, 0, 0,  0,  1138,  0,
            1137, 1136, 0, 0, 0, 0, 1135, 0, 1134, 1133, 0, 0, 1132, 1131, 0,
            1130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1129, 0, 0, 0, 1128, 0, 1127,
            1126, 0, 0, 0, 0, 1125, 0, 1124, 1123, 0, 0, 1122, 1121, 0, 1120,
            0, 0, 0, 0, 0, 0, 1119, 0, 1118, 1117, 0, 0, 1116, 1115, 0, 1114,
            0, 0, 0, 0, 1113, 1112, 0, 1111, 0, 0, 0, 1110, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 1109, 0, 0, 0, 1108, 0, 1107, 1106, 0, 0,
            0, 0, 1105, 0, 1104, 1103, 0, 0, 1102, 1101, 0, 1100, 0, 0, 0, 0,
            0, 0, 1099, 0, 1098, 1097, 0, 0, 1096, 1095, 0, 1094, 0, 0, 0, 0,
            1093, 1092, 0, 1091, 0, 0, 0, 1090, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1089, 0, 1088, 1087, 0, 0, 1086, 1085, 0, 1084, 0, 0, 0, 0, 1083,
            1082, 0, 1081, 0, 0, 0, 1080, 0, 0, 0, 0, 0, 0, 0, 0, 1079, 1078,
            0, 1077, 0, 0, 0, 1076, 0, 0, 0, 0, 0, 0, 0, 1075, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1074, 0, 0, 0,
            1073, 0, 1072, 1071, 0, 0, 0, 0, 1070, 0, 1069, 1068, 0, 0, 1067,
            1066, 0, 1065, 0, 0, 0, 0, 0, 0, 1064, 0, 1063, 1062, 0, 0, 1061,
            1060, 0, 1059, 0, 0, 0, 0, 1058, 1057, 0, 1056, 0, 0, 0, 1055, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1054, 0, 1053, 1052, 0, 0, 1051, 1050,
            0, 1049, 0, 0, 0, 0, 1048, 1047, 0, 1046, 0, 0, 0, 1045, 0, 0, 0,
            0, 0, 0, 0, 0, 1044, 1043, 0, 1042, 0, 0, 0, 1041, 0, 0, 0, 0, 0,
            0, 0, 1040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1039, 0, 1038, 1037, 0, 0, 1036, 1035, 0, 1034, 0, 0, 0, 0, 1033,
            1032, 0, 1031, 0, 0, 0, 1030, 0, 0, 0, 0, 0, 0, 0, 0, 1029, 1028,
            0, 1027, 0, 0, 0, 1026, 0, 0, 0, 0, 0, 0, 0, 1025, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1023, 0, 1022,  0,  0,  0,
            1021, 0, 0, 0, 0, 0, 0, 0, 1020, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1019, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            1018, 0, 0, 0, 1017, 0, 1016, 1015, 0, 0, 0, 0,  1014,  0,  1013,
            1012, 0, 0, 1011, 1010, 0, 1009, 0, 0, 0, 0, 0, 0, 1008, 0, 1007,
            1006, 0, 0, 1005, 1004, 0, 1003, 0, 0, 0, 0, 1002, 1001, 0, 1000,
            0,  0, 0, 999, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 998, 0, 997, 996, 0,
            0, 995, 994, 0, 993, 0, 0, 0, 0, 992, 991, 0, 990, 0, 0, 0,  989,
            0,  0, 0, 0, 0, 0, 0, 0, 988, 987, 0, 986, 0, 0, 0, 985, 0, 0, 0,
            0, 0, 0, 0, 984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0, 983, 0, 982, 981, 0, 0, 980, 979, 0, 978, 0, 0, 0, 0, 977,
            976, 0, 975, 0, 0, 0, 974, 0, 0, 0, 0, 0, 0, 0, 0, 973,  972,  0,
            971, 0, 0, 0, 970, 0, 0, 0, 0, 0, 0, 0, 969, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 968, 967, 0, 966, 0, 0, 0, 965, 0,  0,
            0,  0, 0, 0, 0, 964, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            963, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 962, 0, 961, 960, 0, 0,
            959, 958, 0, 957, 0, 0, 0, 0, 956, 955, 0, 954, 0, 0, 0, 953,  0,
            0,  0, 0, 0, 0, 0, 0, 952, 951, 0, 950, 0, 0, 0, 949, 0, 0, 0, 0,
            0, 0, 0, 948, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,
            947,  946,  0, 945, 0, 0, 0, 944, 0, 0, 0, 0, 0, 0, 0, 943, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 942, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 941, 940, 0, 939, 0, 0, 0, 938, 0, 0, 0,  0,  0,  0,  0,
            937,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 936, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 935, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 934, 0, 0, 0,  933,  0,  932,
            931,  0, 0, 0, 0, 930, 0, 929, 928, 0, 0, 927, 926, 0, 925, 0, 0,
            0, 0, 0, 0, 924, 0, 923, 922, 0, 0, 921, 920, 0, 919, 0, 0, 0, 0,
            918,  917,  0,  916,  0, 0, 0, 915, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            914, 0, 913, 912, 0, 0, 911, 910, 0, 909, 0, 0, 0, 0,  908,  907,
            0,  906,  0, 0, 0, 905, 0, 0, 0, 0, 0, 0, 0, 0, 904, 903, 0, 902,
            0, 0, 0, 901, 0, 0, 0, 0, 0, 0, 0, 900, 0, 0, 0, 0, 0, 0,  0,  0,
            0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 899, 0, 898, 897, 0, 0, 896, 895,
            0, 894, 0, 0, 0, 0, 893, 892, 0, 891, 0, 0, 0, 890, 0, 0,  0,  0,
            0,  0, 0, 0, 889, 888, 0, 887, 0, 0, 0, 886, 0, 0, 0, 0, 0, 0, 0,
            885, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 884, 883, 0,
            882, 0, 0, 0, 881, 0, 0, 0, 0, 0, 0, 0, 880, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 879, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            878, 0, 877, 876, 0, 0, 875, 874, 0, 873, 0, 0, 0, 0,  872,  871,
            0,  870,  0, 0, 0, 869, 0, 0, 0, 0, 0, 0, 0, 0, 868, 867, 0, 866,
            0, 0, 0, 865, 0, 0, 0, 0, 0, 0, 0, 864, 0, 0, 0, 0, 0, 0,  0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 863, 862, 0, 861, 0, 0, 0, 860, 0, 0, 0,
            0, 0, 0, 0, 859, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,
            858,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 857, 856, 0, 855,  0,  0,  0,
            854,  0,  0, 0, 0, 0, 0, 0, 853, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 852, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 851, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 850,  0,  849,
            848,  0, 0, 847, 846, 0, 845, 0, 0, 0, 0, 844, 843, 0, 842, 0, 0,
            0, 841, 0, 0, 0, 0, 0, 0, 0, 0, 840, 839, 0, 838, 0, 0,  0,  837,
            0,  0, 0, 0, 0, 0, 0, 836, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 835, 834, 0, 833, 0, 0, 0, 832, 0, 0, 0,  0,  0,  0,  0,
            831,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 830, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 829, 828, 0, 827, 0, 0, 0, 826, 0, 0, 0, 0,
            0, 0, 0, 825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  824,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 823, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 822, 821, 0, 820, 0, 0, 0, 819, 0, 0,
            0, 0, 0, 0, 0, 818, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            817,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 816, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            10, 0, 0, 0, 0, 0, 0, 0, 815, 0, 0, 0, 814, 0, 813, 812, 0, 0, 0,
            0,  0,  0, 0, 0, 811, 0, 0, 0, 810, 0, 809, 808, 0, 0, 0, 0, 807,
            0, 806, 805, 0, 0, 804, 803, 0, 802, 0, 0, 0, 0, 0, 0, 0,  0,  0,
            0,  801, 0, 0, 0, 800, 0, 799, 798, 0, 0, 0, 0, 797, 0, 796, 795,
            0, 0, 794, 793, 0, 792, 0, 0, 0, 0, 0, 0, 791, 0, 790, 789, 0, 0,
            788,  787, 0, 786, 0, 0, 0, 0, 785, 784, 0, 783, 0, 0, 0, 782, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 781, 0, 0, 0, 780, 0, 779,
            778,  0, 0, 0, 0, 777, 0, 776, 775, 0, 0, 774, 773, 0, 772, 0, 0,
            0, 0, 0, 0, 771, 0, 770, 769, 0, 0, 768, 767, 0, 766, 0, 0, 0, 0,
            765,  764,  0,  763,  0, 0, 0, 762, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            761, 0, 760, 759, 0, 0, 758, 757, 0, 756, 0, 0, 0, 0,  755,  754,
            0,  753,  0, 0, 0, 752, 0, 0, 0, 0, 0, 0, 0, 0, 751, 750, 0, 749,
            0, 0, 0, 748, 0, 0, 0, 0, 0, 0, 0, 747, 0, 0, 0, 0, 0, 0,  0,  0,
            0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 746, 0, 0, 0, 745, 0,
            744, 743, 0, 0, 0, 0, 742, 0, 741, 740, 0, 0, 739, 738,  0,  737,
            0, 0, 0, 0, 0, 0, 736, 0, 735, 734, 0, 0, 733, 732, 0, 731, 0, 0,
            0, 0, 730, 729, 0, 728, 0, 0, 0, 727, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  726,  0,  725,  724, 0, 0, 723, 722, 0, 721, 0, 0, 0, 0, 720,
            719, 0, 718, 0, 0, 0, 717, 0, 0, 0, 0, 0, 0, 0, 0, 716,  715,  0,
            714, 0, 0, 0, 713, 0, 0, 0, 0, 0, 0, 0, 712, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 711, 0, 710,  709,  0,  0,  708,
            707, 0, 706, 0, 0, 0, 0, 705, 704, 0, 703, 0, 0, 0, 702, 0, 0, 0,
            0, 0, 0, 0, 0, 701, 700, 0, 699, 0, 0, 0, 698, 0, 0, 0, 0, 0,  0,
            0, 697, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 696, 695,
            0, 694, 0, 0, 0, 693, 0, 0, 0, 0, 0, 0, 0, 692, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 691, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0, 0, 0, 690, 0, 0, 0, 689, 0, 688, 687, 0, 0, 0, 0, 686,
            0, 685, 684, 0, 0, 683, 682, 0, 681, 0, 0, 0, 0, 0,  0,  680,  0,
            679,  678,  0, 0, 677, 676, 0, 675, 0, 0, 0, 0, 674, 673, 0, 672,
            0, 0, 0, 671, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 670, 0, 669, 668,  0,
            0,  667, 666, 0, 665, 0, 0, 0, 0, 664, 663, 0, 662, 0, 0, 0, 661,
            0, 0, 0, 0, 0, 0, 0, 0, 660, 659, 0, 658, 0, 0, 0, 657, 0, 0,  0,
            0,  0, 0, 0, 656, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 655, 0, 654, 653, 0, 0, 652, 651, 0, 650, 0, 0, 0, 0,  649,
            648,  0,  647, 0, 0, 0, 646, 0, 0, 0, 0, 0, 0, 0, 0, 645, 644, 0,
            643, 0, 0, 0, 642, 0, 0, 0, 0, 0, 0, 0, 641, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 640, 639, 0, 638, 0, 0, 0, 637, 0, 0,
            0, 0, 0, 0, 0, 636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            635,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 634, 0, 633, 632, 0, 0,
            631,  630, 0, 629, 0, 0, 0, 0, 628, 627, 0, 626, 0, 0, 0, 625, 0,
            0, 0, 0, 0, 0, 0, 0, 624, 623, 0, 622, 0, 0, 0, 621, 0, 0, 0,  0,
            0,  0,  0,  620,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            619, 618, 0, 617, 0, 0, 0, 616, 0, 0, 0, 0, 0, 0, 0, 615,  0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 614, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  613,  612, 0, 611, 0, 0, 0, 610, 0, 0, 0, 0, 0, 0, 0,
            609, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 608, 0,  0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 607, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 606, 0, 0, 0, 605, 0, 604,
            603, 0, 0, 0, 0, 602, 0, 601, 600, 0, 0, 599, 598, 0, 597, 0,  0,
            0, 0, 0, 0, 596, 0, 595, 594, 0, 0, 593, 592, 0, 591, 0, 0, 0, 0,
            590, 589, 0, 588, 0, 0, 0, 587, 0, 0, 0, 0, 0, 0,  0,  0,  0,  0,
            586,  0,  585, 584, 0, 0, 583, 582, 0, 581, 0, 0, 0, 0, 580, 579,
            0, 578, 0, 0, 0, 577, 0, 0, 0, 0, 0, 0, 0, 0, 576, 575,  0,  574,
            0,  0,  0, 573, 0, 0, 0, 0, 0, 0, 0, 572, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 571, 0, 570, 569, 0, 0,  568,  567,
            0,  566,  0, 0, 0, 0, 565, 564, 0, 563, 0, 0, 0, 562, 0, 0, 0, 0,
            0, 0, 0, 0, 561, 560, 0, 559, 0, 0, 0, 558, 0, 0, 0, 0, 0, 0,  0,
            557, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 556, 555, 0,
            554, 0, 0, 0, 553, 0, 0, 0, 0, 0, 0, 0, 552, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 551, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            550,  0,  549, 548, 0, 0, 547, 546, 0, 545, 0, 0, 0, 0, 544, 543,
            0, 542, 0, 0, 0, 541, 0, 0, 0, 0, 0, 0, 0, 0, 540, 539,  0,  538,
            0,  0,  0, 537, 0, 0, 0, 0, 0, 0, 0, 536, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 535, 534, 0, 533, 0, 0, 0, 532, 0, 0,  0,
            0,  0,  0,  0,  531, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            530, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 529, 528, 0, 527, 0, 0, 0,
            526, 0, 0, 0, 0, 0, 0, 0, 525, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,
            0,  0, 0, 0, 524, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 523, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 522, 0, 521,
            520, 0, 0, 519, 518, 0, 517, 0, 0, 0, 0, 516, 515, 0, 514, 0,  0,
            0,  513,  0, 0, 0, 0, 0, 0, 0, 0, 512, 511, 0, 510, 0, 0, 0, 509,
            0, 0, 0, 0, 0, 0, 0, 508, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0,  0,  507,  506, 0, 505, 0, 0, 0, 504, 0, 0, 0, 0, 0, 0, 0,
            503, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 502, 0,  0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 501, 500, 0, 499, 0, 0, 0, 498, 0, 0, 0,  0,
            0,  0,  0, 497, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 496,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 495, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 494, 493, 0, 492, 0, 0, 0, 491, 0,  0,
            0,  0, 0, 0, 0, 490, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            489, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 488, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 487, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 486, 0, 0, 0,  485,  0,
            484,  483,  0, 0, 0, 0, 482, 0, 481, 480, 0, 0, 479, 478, 0, 477,
            0, 0, 0, 0, 0, 0, 476, 0, 475, 474, 0, 0, 473, 472, 0, 471, 0, 0,
            0,  0, 470, 469, 0, 468, 0, 0, 0, 467, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 466, 0, 465, 464, 0, 0, 463, 462, 0, 461, 0,  0,  0,  0,  460,
            459,  0,  458, 0, 0, 0, 457, 0, 0, 0, 0, 0, 0, 0, 0, 456, 455, 0,
            454, 0, 0, 0, 453, 0, 0, 0, 0, 0, 0, 0, 452, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 451, 0, 450, 449, 0, 0, 448,
            447, 0, 446, 0, 0, 0, 0, 445, 444, 0, 443, 0, 0, 0, 442, 0, 0, 0,
            0,  0, 0, 0, 0, 441, 440, 0, 439, 0, 0, 0, 438, 0, 0, 0, 0, 0, 0,
            0, 437, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 436, 435,
            0, 434, 0, 0, 0, 433, 0, 0, 0, 0, 0, 0, 0, 432, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 431, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 430, 0, 429, 428, 0, 0, 427, 426, 0, 425, 0,  0,  0,  0,  424,
            423,  0,  422, 0, 0, 0, 421, 0, 0, 0, 0, 0, 0, 0, 0, 420, 419, 0,
            418, 0, 0, 0, 417, 0, 0, 0, 0, 0, 0, 0, 416, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 415, 414, 0, 413, 0, 0, 0, 412, 0, 0,
            0, 0, 0, 0, 0, 411, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            410,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 409, 408, 0, 407,  0,  0,  0,
            406,  0,  0, 0, 0, 0, 0, 0, 405, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 404, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 403, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 402,  0,  401,
            400,  0, 0, 399, 398, 0, 397, 0, 0, 0, 0, 396, 395, 0, 394, 0, 0,
            0, 393, 0, 0, 0, 0, 0, 0, 0, 0, 392, 391, 0, 390, 0, 0,  0,  389,
            0,  0, 0, 0, 0, 0, 0, 388, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 387, 386, 0, 385, 0, 0, 0, 384, 0, 0, 0,  0,  0,  0,  0,
            383,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 382, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 381, 380, 0, 379, 0, 0, 0, 378, 0, 0, 0, 0,
            0, 0, 0, 377, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  376,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 375, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 374, 373, 0, 372, 0, 0, 0, 371, 0, 0,
            0, 0, 0, 0, 0, 370, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            369,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 368, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 367, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 366, 0, 365, 364, 0, 0, 363, 362,
            0, 361, 0, 0, 0, 0, 360, 359, 0, 358, 0, 0, 0, 357, 0, 0,  0,  0,
            0,  0, 0, 0, 356, 355, 0, 354, 0, 0, 0, 353, 0, 0, 0, 0, 0, 0, 0,
            352, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 351, 350, 0,
            349, 0, 0, 0, 348, 0, 0, 0, 0, 0, 0, 0, 347, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 345,
            344, 0, 343, 0, 0, 0, 342, 0, 0, 0, 0, 0, 0, 0, 341, 0, 0, 0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 340, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            339,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            338, 337, 0, 336, 0, 0, 0, 335, 0, 0, 0, 0, 0, 0, 0, 334,  0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 333, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 332, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 331, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            330, 329, 0, 328, 0, 0, 0, 327, 0, 0, 0, 0, 0, 0, 0, 326,  0,  0,
            0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 325, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0, 324, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 323, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]
            # Map binary representation of ranks having popcount of 5 to rank
        unique5 = [
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 1608, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 7462, 0, 0, 0, 0, 0, 0, 0, 7461, 0, 0,  0,  7460,  0,
            7459, 1607, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7458,
            0, 0, 0, 0, 0, 0, 0, 7457, 0, 0, 0, 7456, 0, 7455, 7454, 0, 0, 0,
            0,  0,  0,  0, 0, 7453, 0, 0, 0, 7452, 0, 7451, 7450, 0, 0, 0, 0,
            7449, 0, 7448, 7447, 0, 0, 7446, 7445, 0, 1606, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 7444, 0, 0, 0, 0, 0, 0, 0,
            7443, 0, 0, 0, 7442, 0, 7441, 7440, 0, 0, 0, 0, 0, 0, 0, 0, 7439,
            0, 0, 0, 7438, 0, 7437, 7436, 0, 0, 0, 0, 7435, 0, 7434, 7433, 0,
            0, 7432, 7431, 0, 7430, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7429, 0, 0,
            0,  7428,  0,  7427, 7426, 0, 0, 0, 0, 7425, 0, 7424, 7423, 0, 0,
            7422, 7421, 0, 7420, 0, 0, 0, 0, 0, 0, 7419, 0, 7418, 7417, 0, 0,
            7416,  7415,  0,  7414, 0, 0, 0, 0, 7413, 7412, 0, 7411, 0, 0, 0,
            1605, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  7410,  0, 0, 0, 0, 0, 0, 0, 7409, 0, 0, 0, 7408, 0, 7407,
            7406, 0, 0, 0, 0, 0, 0, 0, 0, 7405, 0, 0, 0, 7404, 0, 7403, 7402,
            0, 0, 0, 0, 7401, 0, 7400, 7399, 0, 0, 7398, 7397, 0, 7396, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 7395, 0, 0, 0, 7394, 0, 7393, 7392, 0, 0,
            0, 0, 7391, 0, 7390, 7389, 0, 0, 7388, 7387, 0, 7386, 0, 0, 0, 0,
            0, 0, 7385, 0, 7384, 7383, 0, 0, 7382, 7381, 0, 7380, 0, 0, 0, 0,
            7379, 7378, 0, 7377, 0, 0, 0, 7376, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 7375, 0, 0, 0, 7374, 0, 7373, 7372, 0, 0, 0, 0, 7371,
            0, 7370, 7369, 0, 0, 7368, 7367, 0, 7366, 0, 0, 0, 0, 0, 0, 7365,
            0, 7364, 7363, 0, 0, 7362, 7361, 0, 7360, 0, 0, 0, 0, 7359, 7358,
            0,  7357,  0,  0, 0, 7356, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7355, 0,
            7354, 7353, 0, 0, 7352, 7351, 0, 7350, 0, 0, 0, 0, 7349, 7348, 0,
            7347, 0, 0, 0, 7346, 0, 0, 0, 0, 0, 0, 0, 0, 7345, 7344, 0, 7343,
            0, 0, 0, 7342, 0, 0, 0, 0, 0, 0, 0, 1604, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            7341, 0, 0, 0, 0, 0, 0, 0, 7340, 0, 0, 0, 7339, 0, 7338, 7337, 0,
            0, 0, 0, 0, 0, 0, 0, 7336, 0, 0, 0, 7335, 0, 7334, 7333, 0, 0, 0,
            0, 7332, 0, 7331, 7330, 0, 0, 7329, 7328, 0, 7327, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 7326, 0, 0, 0, 7325, 0, 7324, 7323, 0, 0, 0, 0,
            7322, 0, 7321, 7320, 0, 0, 7319, 7318, 0, 7317, 0, 0, 0, 0, 0, 0,
            7316, 0, 7315, 7314, 0, 0, 7313, 7312, 0, 7311, 0, 0, 0, 0, 7310,
            7309, 0, 7308, 0, 0, 0, 7307, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  7306,  0, 0, 0, 7305, 0, 7304, 7303, 0, 0, 0, 0, 7302, 0,
            7301, 7300, 0, 0, 7299, 7298, 0, 7297, 0, 0, 0, 0, 0, 0, 7296, 0,
            7295, 7294, 0, 0, 7293, 7292, 0, 7291, 0, 0, 0, 0, 7290, 7289, 0,
            7288, 0, 0, 0, 7287, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7286, 0, 7285,
            7284, 0, 0, 7283, 7282, 0, 7281, 0, 0, 0, 0, 7280, 7279, 0, 7278,
            0, 0, 0, 7277, 0, 0, 0, 0, 0, 0, 0, 0, 7276, 7275, 0, 7274, 0, 0,
            0, 7273, 0, 0, 0, 0, 0, 0, 0, 7272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7271, 0, 0, 0, 7270, 0, 7269,
            7268, 0, 0, 0, 0, 7267, 0, 7266, 7265, 0, 0, 7264, 7263, 0, 7262,
            0, 0, 0, 0, 0, 0, 7261, 0, 7260, 7259, 0, 0, 7258, 7257, 0, 7256,
            0, 0, 0, 0, 7255, 7254, 0, 7253, 0, 0, 0, 7252, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 7251, 0, 7250, 7249, 0, 0, 7248, 7247, 0, 7246, 0, 0,
            0, 0, 7245, 7244, 0, 7243, 0, 0, 0, 7242, 0, 0, 0, 0, 0, 0, 0, 0,
            7241, 7240, 0, 7239, 0, 0, 0, 7238, 0, 0, 0, 0, 0, 0, 0, 7237, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7236, 0, 7235,
            7234, 0, 0, 7233, 7232, 0, 7231, 0, 0, 0, 0, 7230, 7229, 0, 7228,
            0, 0, 0, 7227, 0, 0, 0, 0, 0, 0, 0, 0, 7226, 7225, 0, 7224, 0, 0,
            0, 7223, 0, 0, 0, 0, 0, 0, 0, 7222, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 7221, 7220, 0, 7219, 0, 0, 0, 7218, 0, 0, 0, 0,
            0, 0, 0, 7217, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1603,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  7216,  0, 0, 0, 0, 0, 0, 0, 7215, 0, 0, 0, 7214, 0, 7213,
            7212, 0, 0, 0, 0, 0, 0, 0, 0, 7211, 0, 0, 0, 7210, 0, 7209, 7208,
            0, 0, 0, 0, 7207, 0, 7206, 7205, 0, 0, 7204, 7203, 0, 7202, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 7201, 0, 0, 0, 7200, 0, 7199, 7198, 0, 0,
            0, 0, 7197, 0, 7196, 7195, 0, 0, 7194, 7193, 0, 7192, 0, 0, 0, 0,
            0, 0, 7191, 0, 7190, 7189, 0, 0, 7188, 7187, 0, 7186, 0, 0, 0, 0,
            7185, 7184, 0, 7183, 0, 0, 0, 7182, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 7181, 0, 0, 0, 7180, 0, 7179, 7178, 0, 0, 0, 0, 7177,
            0, 7176, 7175, 0, 0, 7174, 7173, 0, 7172, 0, 0, 0, 0, 0, 0, 7171,
            0, 7170, 7169, 0, 0, 7168, 7167, 0, 7166, 0, 0, 0, 0, 7165, 7164,
            0,  7163,  0,  0, 0, 7162, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7161, 0,
            7160, 7159, 0, 0, 7158, 7157, 0, 7156, 0, 0, 0, 0, 7155, 7154, 0,
            7153, 0, 0, 0, 7152, 0, 0, 0, 0, 0, 0, 0, 0, 7151, 7150, 0, 7149,
            0, 0, 0, 7148, 0, 0, 0, 0, 0, 0, 0, 7147, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7146, 0, 0, 0, 7145, 0,
            7144, 7143, 0, 0, 0, 0, 7142, 0, 7141, 7140, 0, 0, 7139, 7138, 0,
            7137, 0, 0, 0, 0, 0, 0, 7136, 0, 7135, 7134, 0, 0, 7133, 7132, 0,
            7131, 0, 0, 0, 0, 7130, 7129, 0, 7128, 0, 0, 0, 7127, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 7126, 0, 7125, 7124, 0, 0, 7123, 7122, 0, 7121,
            0, 0, 0, 0, 7120, 7119, 0, 7118, 0, 0, 0, 7117, 0, 0, 0, 0, 0, 0,
            0,  0,  7116,  7115, 0, 7114, 0, 0, 0, 7113, 0, 0, 0, 0, 0, 0, 0,
            7112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7111,
            0, 7110, 7109, 0, 0, 7108, 7107, 0, 7106, 0, 0, 0, 0, 7105, 7104,
            0, 7103, 0, 0, 0, 7102, 0, 0, 0, 0, 0, 0, 0, 0,  7101,  7100,  0,
            7099, 0, 0, 0, 7098, 0, 0, 0, 0, 0, 0, 0, 7097, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7096, 7095, 0, 7094, 0, 0, 0, 7093,
            0, 0, 0, 0, 0, 0, 0, 7092, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 7091, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7090,
            0, 0, 0, 7089, 0, 7088, 7087, 0, 0, 0, 0, 7086, 0, 7085, 7084, 0,
            0, 7083, 7082, 0, 7081, 0, 0, 0, 0, 0, 0, 7080, 0, 7079, 7078, 0,
            0, 7077, 7076, 0, 7075, 0, 0, 0, 0, 7074, 7073, 0, 7072, 0, 0, 0,
            7071,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 7070, 0, 7069, 7068, 0, 0,
            7067, 7066, 0, 7065, 0, 0, 0, 0, 7064, 7063, 0, 7062,  0,  0,  0,
            7061, 0, 0, 0, 0, 0, 0, 0, 0, 7060, 7059, 0, 7058, 0, 0, 0, 7057,
            0, 0, 0, 0, 0, 0, 0, 7056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 7055, 0, 7054, 7053, 0, 0, 7052, 7051, 0, 7050, 0,
            0, 0, 0, 7049, 7048, 0, 7047, 0, 0, 0, 7046, 0, 0, 0, 0, 0, 0, 0,
            0, 7045, 7044, 0, 7043, 0, 0, 0, 7042, 0, 0, 0, 0, 0, 0, 0, 7041,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  7040,  7039,  0,
            7038, 0, 0, 0, 7037, 0, 0, 0, 0, 0, 0, 0, 7036, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 7035, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 7034, 0, 7033, 7032, 0, 0, 7031, 7030, 0, 7029, 0,  0,  0,  0,
            7028, 7027, 0, 7026, 0, 0, 0, 7025, 0, 0, 0, 0, 0, 0, 0, 0, 7024,
            7023, 0, 7022, 0, 0, 0, 7021, 0, 0, 0, 0, 0, 0, 0, 7020, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7019, 7018, 0, 7017, 0, 0,
            0, 7016, 0, 0, 0, 0, 0, 0, 0, 7015, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 7014, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7013, 7012, 0,
            7011, 0, 0, 0, 7010, 0, 0, 0, 0, 0, 0, 0, 7009, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 7008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1602,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 7007, 0, 0, 0, 0, 0, 0, 0,
            7006, 0, 0, 0, 7005, 0, 7004, 7003, 0, 0, 0, 0, 0, 0, 0, 0, 7002,
            0, 0, 0, 7001, 0, 7000, 6999, 0, 0, 0, 0, 6998, 0, 6997, 6996, 0,
            0, 6995, 6994, 0, 6993, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6992, 0, 0,
            0,  6991,  0,  6990, 6989, 0, 0, 0, 0, 6988, 0, 6987, 6986, 0, 0,
            6985, 6984, 0, 6983, 0, 0, 0, 0, 0, 0, 6982, 0, 6981, 6980, 0, 0,
            6979,  6978,  0,  6977, 0, 0, 0, 0, 6976, 6975, 0, 6974, 0, 0, 0,
            6973, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6972,  0,  0,  0,
            6971, 0, 6970, 6969, 0, 0, 0, 0, 6968, 0, 6967, 6966, 0, 0, 6965,
            6964, 0, 6963, 0, 0, 0, 0, 0, 0, 6962, 0, 6961, 6960, 0, 0, 6959,
            6958, 0, 6957, 0, 0, 0, 0, 6956, 6955, 0, 6954, 0, 0, 0, 6953, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 6952, 0, 6951, 6950, 0, 0, 6949, 6948,
            0, 6947, 0, 0, 0, 0, 6946, 6945, 0, 6944, 0, 0, 0, 6943, 0, 0, 0,
            0, 0, 0, 0, 0, 6942, 6941, 0, 6940, 0, 0, 0, 6939, 0, 0, 0, 0, 0,
            0, 0, 6938, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6937, 0, 0, 0, 6936, 0, 6935, 6934, 0, 0, 0, 0, 6933,
            0, 6932, 6931, 0, 0, 6930, 6929, 0, 6928, 0, 0, 0, 0, 0, 0, 6927,
            0, 6926, 6925, 0, 0, 6924, 6923, 0, 6922, 0, 0, 0, 0, 6921, 6920,
            0,  6919,  0,  0, 0, 6918, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6917, 0,
            6916, 6915, 0, 0, 6914, 6913, 0, 6912, 0, 0, 0, 0, 6911, 6910, 0,
            6909, 0, 0, 0, 6908, 0, 0, 0, 0, 0, 0, 0, 0, 6907, 6906, 0, 6905,
            0, 0, 0, 6904, 0, 0, 0, 0, 0, 0, 0, 6903, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 6902, 0, 6901, 6900, 0, 0, 6899,
            6898, 0, 6897, 0, 0, 0, 0, 6896, 6895, 0, 6894, 0, 0, 0, 6893, 0,
            0, 0, 0, 0, 0, 0, 0, 6892, 6891, 0, 6890, 0, 0, 0, 6889, 0, 0, 0,
            0, 0, 0, 0, 6888, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6887, 6886, 0, 6885, 0, 0, 0, 6884, 0, 0, 0, 0, 0, 0, 0, 6883, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6882, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6881, 0, 0, 0, 6880, 0, 6879, 6878,
            0, 0, 0, 0, 6877, 0, 6876, 6875, 0, 0, 6874, 6873, 0, 6872, 0, 0,
            0, 0, 0, 0, 6871, 0, 6870, 6869, 0, 0, 6868, 6867, 0, 6866, 0, 0,
            0, 0, 6865, 6864, 0, 6863, 0, 0, 0, 6862, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 6861, 0, 6860, 6859, 0, 0, 6858, 6857, 0, 6856, 0, 0, 0, 0,
            6855, 6854, 0, 6853, 0, 0, 0, 6852, 0, 0, 0, 0, 0, 0, 0, 0, 6851,
            6850, 0, 6849, 0, 0, 0, 6848, 0, 0, 0, 0, 0, 0, 0, 6847, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6846, 0, 6845, 6844,
            0, 0, 6843, 6842, 0, 6841, 0, 0, 0, 0, 6840, 6839, 0, 6838, 0, 0,
            0,  6837,  0,  0, 0, 0, 0, 0, 0, 0, 6836, 6835, 0, 6834, 0, 0, 0,
            6833, 0, 0, 0, 0, 0, 0, 0, 6832, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 6831, 6830, 0, 6829, 0, 0, 0, 6828, 0, 0, 0, 0, 0,
            0, 0, 6827, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6826, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6825, 0, 6824, 6823, 0, 0, 6822,
            6821, 0, 6820, 0, 0, 0, 0, 6819, 6818, 0, 6817, 0, 0, 0, 6816, 0,
            0, 0, 0, 0, 0, 0, 0, 6815, 6814, 0, 6813, 0, 0, 0, 6812, 0, 0, 0,
            0, 0, 0, 0, 6811, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6810, 6809, 0, 6808, 0, 0, 0, 6807, 0, 0, 0, 0, 0, 0, 0, 6806, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6805, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6804, 6803, 0, 6802, 0, 0, 0, 6801, 0, 0, 0, 0, 0, 0,
            0, 6800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6799, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6798, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6797, 0, 0, 0, 6796, 0,
            6795, 6794, 0, 0, 0, 0, 6793, 0, 6792, 6791, 0, 0, 6790, 6789, 0,
            6788, 0, 0, 0, 0, 0, 0, 6787, 0, 6786, 6785, 0, 0, 6784, 6783, 0,
            6782, 0, 0, 0, 0, 6781, 6780, 0, 6779, 0, 0, 0, 6778, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6777, 0, 6776, 6775, 0, 0, 6774, 6773, 0, 6772,
            0, 0, 0, 0, 6771, 6770, 0, 6769, 0, 0, 0, 6768, 0, 0, 0, 0, 0, 0,
            0,  0,  6767,  6766, 0, 6765, 0, 0, 0, 6764, 0, 0, 0, 0, 0, 0, 0,
            6763, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6762,
            0, 6761, 6760, 0, 0, 6759, 6758, 0, 6757, 0, 0, 0, 0, 6756, 6755,
            0, 6754, 0, 0, 0, 6753, 0, 0, 0, 0, 0, 0, 0, 0,  6752,  6751,  0,
            6750, 0, 0, 0, 6749, 0, 0, 0, 0, 0, 0, 0, 6748, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6747, 6746, 0, 6745, 0, 0, 0, 6744,
            0, 0, 0, 0, 0, 0, 0, 6743, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 6742, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6741, 0, 6740,
            6739, 0, 0, 6738, 6737, 0, 6736, 0, 0, 0, 0, 6735, 6734, 0, 6733,
            0, 0, 0, 6732, 0, 0, 0, 0, 0, 0, 0, 0, 6731, 6730, 0, 6729, 0, 0,
            0, 6728, 0, 0, 0, 0, 0, 0, 0, 6727, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6726, 6725, 0, 6724, 0, 0, 0, 6723, 0, 0, 0, 0,
            0, 0, 0, 6722, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6721,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6720, 6719, 0, 6718, 0, 0, 0, 6717,
            0, 0, 0, 0, 0, 0, 0, 6716, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 6715, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6714, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6713, 0, 6712, 6711,
            0, 0, 6710, 6709, 0, 6708, 0, 0, 0, 0, 6707, 6706, 0, 6705, 0, 0,
            0, 6704, 0, 0, 0, 0, 0, 0, 0, 0, 6703, 6702, 0, 6701,  0,  0,  0,
            6700, 0, 0, 0, 0, 0, 0, 0, 6699, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 6698, 6697, 0, 6696, 0, 0, 0, 6695, 0, 0, 0, 0, 0,
            0, 0, 6694, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6693, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 6692, 6691, 0, 6690, 0, 0, 0, 6689, 0,
            0, 0, 0, 0, 0, 0, 6688, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 6687, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6686, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6685, 6684, 0, 6683, 0, 0, 0,
            6682, 0, 0, 0, 0, 0, 0, 0, 6681, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6679, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1601, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 1609, 0, 0, 0, 0, 0, 0, 0, 6678, 0, 0,  0,  6677,  0,
            6676, 6675, 0, 0, 0, 0, 0, 0, 0, 0, 6674, 0, 0, 0, 6673, 0, 6672,
            6671, 0, 0, 0, 0, 6670, 0, 6669, 6668, 0, 0, 6667, 6666, 0, 6665,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6664, 0, 0, 0, 6663, 0, 6662, 6661,
            0, 0, 0, 0, 6660, 0, 6659, 6658, 0, 0, 6657, 6656, 0, 6655, 0, 0,
            0, 0, 0, 0, 6654, 0, 6653, 6652, 0, 0, 6651, 6650, 0, 6649, 0, 0,
            0, 0, 6648, 6647, 0, 6646, 0, 0, 0, 6645, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6644, 0, 0, 0, 6643, 0, 6642, 6641, 0, 0, 0, 0,
            6640, 0, 6639, 6638, 0, 0, 6637, 6636, 0, 6635, 0, 0, 0, 0, 0, 0,
            6634, 0, 6633, 6632, 0, 0, 6631, 6630, 0, 6629, 0, 0, 0, 0, 6628,
            6627, 0, 6626, 0, 0, 0, 6625, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6624,
            0, 6623, 6622, 0, 0, 6621, 6620, 0, 6619, 0, 0, 0, 0, 6618, 6617,
            0, 6616, 0, 0, 0, 6615, 0, 0, 0, 0, 0, 0, 0, 0,  6614,  6613,  0,
            6612, 0, 0, 0, 6611, 0, 0, 0, 0, 0, 0, 0, 6610, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6609,  0,  0,  0,
            6608, 0, 6607, 6606, 0, 0, 0, 0, 6605, 0, 6604, 6603, 0, 0, 6602,
            6601, 0, 6600, 0, 0, 0, 0, 0, 0, 6599, 0, 6598, 6597, 0, 0, 6596,
            6595, 0, 6594, 0, 0, 0, 0, 6593, 6592, 0, 6591, 0, 0, 0, 6590, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 6589, 0, 6588, 6587, 0, 0, 6586, 6585,
            0, 6584, 0, 0, 0, 0, 6583, 6582, 0, 6581, 0, 0, 0, 6580, 0, 0, 0,
            0, 0, 0, 0, 0, 6579, 6578, 0, 6577, 0, 0, 0, 6576, 0, 0, 0, 0, 0,
            0, 0, 6575, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6574, 0, 6573, 6572, 0, 0, 6571, 6570, 0, 6569, 0, 0, 0, 0, 6568,
            6567, 0, 6566, 0, 0, 0, 6565, 0, 0, 0, 0, 0, 0, 0, 0, 6564, 6563,
            0, 6562, 0, 0, 0, 6561, 0, 0, 0, 0, 0, 0, 0, 6560, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 6559, 6558, 0, 6557, 0, 0, 0,
            6556, 0, 0, 0, 0, 0, 0, 0, 6555, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6554, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6553,  0,  0,  0, 6552, 0, 6551, 6550, 0, 0, 0, 0, 6549, 0, 6548,
            6547, 0, 0, 6546, 6545, 0, 6544, 0, 0, 0, 0, 0, 0, 6543, 0, 6542,
            6541, 0, 0, 6540, 6539, 0, 6538, 0, 0, 0, 0, 6537, 6536, 0, 6535,
            0, 0, 0, 6534, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6533, 0, 6532, 6531,
            0, 0, 6530, 6529, 0, 6528, 0, 0, 0, 0, 6527, 6526, 0, 6525, 0, 0,
            0, 6524, 0, 0, 0, 0, 0, 0, 0, 0, 6523, 6522, 0, 6521,  0,  0,  0,
            6520, 0, 0, 0, 0, 0, 0, 0, 6519, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6518, 0, 6517, 6516, 0, 0,  6515,  6514,  0,
            6513, 0, 0, 0, 0, 6512, 6511, 0, 6510, 0, 0, 0, 6509, 0, 0, 0, 0,
            0, 0, 0, 0, 6508, 6507, 0, 6506, 0, 0, 0, 6505, 0, 0, 0, 0, 0, 0,
            0,  6504,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6503,
            6502, 0, 6501, 0, 0, 0, 6500, 0, 0, 0, 0, 0, 0, 0, 6499, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6498, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6497, 0, 6496, 6495, 0, 0, 6494, 6493, 0, 6492, 0, 0,
            0, 0, 6491, 6490, 0, 6489, 0, 0, 0, 6488, 0, 0, 0, 0, 0, 0, 0, 0,
            6487, 6486, 0, 6485, 0, 0, 0, 6484, 0, 0, 0, 0, 0, 0, 0, 6483, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6482, 6481, 0, 6480,
            0, 0, 0, 6479, 0, 0, 0, 0, 0, 0, 0, 6478, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6477, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6476,
            6475, 0, 6474, 0, 0, 0, 6473, 0, 0, 0, 0, 0, 0, 0, 6472, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6471, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 6470, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6469, 0, 0, 0, 6468, 0, 6467, 6466, 0, 0, 0,
            0, 6465, 0, 6464, 6463, 0, 0, 6462, 6461, 0, 6460, 0, 0, 0, 0, 0,
            0, 6459, 0, 6458, 6457, 0, 0, 6456, 6455, 0, 6454, 0,  0,  0,  0,
            6453, 6452, 0, 6451, 0, 0, 0, 6450, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6449, 0, 6448, 6447, 0, 0, 6446, 6445, 0, 6444, 0, 0, 0, 0, 6443,
            6442, 0, 6441, 0, 0, 0, 6440, 0, 0, 0, 0, 0, 0, 0, 0, 6439, 6438,
            0, 6437, 0, 0, 0, 6436, 0, 0, 0, 0, 0, 0, 0, 6435, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6434, 0, 6433, 6432, 0, 0,
            6431, 6430, 0, 6429, 0, 0, 0, 0, 6428, 6427, 0, 6426,  0,  0,  0,
            6425, 0, 0, 0, 0, 0, 0, 0, 0, 6424, 6423, 0, 6422, 0, 0, 0, 6421,
            0, 0, 0, 0, 0, 0, 0, 6420, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 6419, 6418, 0, 6417, 0, 0, 0, 6416, 0, 0, 0, 0, 0, 0, 0,
            6415, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6414, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 6413, 0, 6412, 6411, 0, 0, 6410, 6409,
            0, 6408, 0, 0, 0, 0, 6407, 6406, 0, 6405, 0, 0, 0, 6404, 0, 0, 0,
            0, 0, 0, 0, 0, 6403, 6402, 0, 6401, 0, 0, 0, 6400, 0, 0, 0, 0, 0,
            0, 0, 6399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6398,
            6397, 0, 6396, 0, 0, 0, 6395, 0, 0, 0, 0, 0, 0, 0, 6394, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6393, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  6392,  6391, 0, 6390, 0, 0, 0, 6389, 0, 0, 0, 0, 0, 0, 0,
            6388, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6387, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6386, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 6385, 0, 6384, 6383, 0, 0, 6382, 6381, 0,
            6380, 0, 0, 0, 0, 6379, 6378, 0, 6377, 0, 0, 0, 6376, 0, 0, 0, 0,
            0, 0, 0, 0, 6375, 6374, 0, 6373, 0, 0, 0, 6372, 0, 0, 0, 0, 0, 0,
            0, 6371, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  6370,
            6369, 0, 6368, 0, 0, 0, 6367, 0, 0, 0, 0, 0, 0, 0, 6366, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6365, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 6364, 6363, 0, 6362, 0, 0, 0, 6361, 0, 0, 0, 0,  0,  0,  0,
            6360, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6359, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6358, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6357, 6356, 0, 6355, 0, 0, 0, 6354, 0, 0, 0, 0,
            0, 0, 0, 6353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6352,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 6351, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 6350, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6349, 0, 0, 0, 6348, 0, 6347,
            6346, 0, 0, 0, 0, 6345, 0, 6344, 6343, 0, 0, 6342, 6341, 0, 6340,
            0, 0, 0, 0, 0, 0, 6339, 0, 6338, 6337, 0, 0, 6336, 6335, 0, 6334,
            0, 0, 0, 0, 6333, 6332, 0, 6331, 0, 0, 0, 6330, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6329, 0, 6328, 6327, 0, 0, 6326, 6325, 0, 6324, 0, 0,
            0, 0, 6323, 6322, 0, 6321, 0, 0, 0, 6320, 0, 0, 0, 0, 0, 0, 0, 0,
            6319, 6318, 0, 6317, 0, 0, 0, 6316, 0, 0, 0, 0, 0, 0, 0, 6315, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6314, 0, 6313,
            6312, 0, 0, 6311, 6310, 0, 6309, 0, 0, 0, 0, 6308, 6307, 0, 6306,
            0, 0, 0, 6305, 0, 0, 0, 0, 0, 0, 0, 0, 6304, 6303, 0, 6302, 0, 0,
            0, 6301, 0, 0, 0, 0, 0, 0, 0, 6300, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 6299, 6298, 0, 6297, 0, 0, 0, 6296, 0, 0, 0, 0,
            0, 0, 0, 6295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6294,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6293, 0, 6292,  6291,  0,  0,
            6290,  6289,  0,  6288, 0, 0, 0, 0, 6287, 6286, 0, 6285, 0, 0, 0,
            6284, 0, 0, 0, 0, 0, 0, 0, 0, 6283, 6282, 0, 6281, 0, 0, 0, 6280,
            0, 0, 0, 0, 0, 0, 0, 6279, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 6278, 6277, 0, 6276, 0, 0, 0, 6275, 0, 0, 0, 0, 0, 0, 0,
            6274, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6273, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6272, 6271, 0, 6270, 0, 0, 0, 6269, 0, 0, 0,
            0, 0, 0, 0, 6268, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,
            6267, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6266, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6265, 0, 6264, 6263, 0, 0,
            6262, 6261, 0, 6260, 0, 0, 0, 0, 6259, 6258, 0, 6257,  0,  0,  0,
            6256, 0, 0, 0, 0, 0, 0, 0, 0, 6255, 6254, 0, 6253, 0, 0, 0, 6252,
            0, 0, 0, 0, 0, 0, 0, 6251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 6250, 6249, 0, 6248, 0, 0, 0, 6247, 0, 0, 0, 0, 0, 0, 0,
            6246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6245, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6244, 6243, 0, 6242, 0, 0, 0, 6241, 0, 0, 0,
            0,  0,  0,  0, 6240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            6239, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6238, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6237, 6236, 0, 6235,  0,  0,  0,
            6234, 0, 0, 0, 0, 0, 0, 0, 6233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6231, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6230, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6229, 0, 6228, 6227, 0,
            0, 6226, 6225, 0, 6224, 0, 0, 0, 0, 6223, 6222, 0, 6221, 0, 0, 0,
            6220, 0, 0, 0, 0, 0, 0, 0, 0, 6219, 6218, 0, 6217, 0, 0, 0, 6216,
            0, 0, 0, 0, 0, 0, 0, 6215, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 6214, 6213, 0, 6212, 0, 0, 0, 6211, 0, 0, 0, 0, 0, 0, 0,
            6210, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6209, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 6208, 6207, 0, 6206, 0, 0, 0, 6205, 0, 0, 0,
            0, 0, 0, 0, 6204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0,
            6203, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6202, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 6201, 6200, 0, 6199, 0, 0, 0,
            6198, 0, 0, 0, 0, 0, 0, 0, 6197, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6195, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6194, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6193, 6192, 0, 6191, 0, 0, 0,
            6190, 0, 0, 0, 0, 0, 0, 0, 6189, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 6188, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6187, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6186, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0,  0,  0,  0,  0, 0, 0, 0, 0, 0, 0, 1600]
        # Map products of primes from 5-card hands to hand ranks
        # All of these hands have at least a pair
        pairs = {
            48: 166, 72: 322, 80: 165, 108: 310, 
            112: 164, 120: 2467, 162: 154, 168: 2466, 
            176: 163, 180: 3325, 200: 321, 208: 162, 
            252: 3324, 264: 2464, 270: 2401, 272: 161, 
            280: 2465, 300: 3314, 304: 160, 312: 2461, 
            368: 159, 378: 2400, 392: 320, 396: 3323, 
            405: 153, 408: 2457, 420: 6185, 440: 2463, 
            450: 3303, 456: 2452, 464: 158, 468: 3322, 
            496: 157, 500: 298, 520: 2460, 552: 2446, 
            567: 152, 588: 3292, 592: 156, 594: 2398, 
            612: 3321, 616: 2462, 630: 5965, 656: 155, 
            660: 6184, 675: 309, 680: 2456, 684: 3320, 
            696: 2439, 700: 3313, 702: 2395, 728: 2459, 
            744: 2431, 750: 2335, 760: 2451, 780: 6181, 
            828: 3319, 882: 3281, 888: 2422, 891: 151, 
            918: 2391, 920: 2445, 924: 6183, 945: 2399, 
            952: 2455, 968: 319, 980: 3291, 984: 2412, 
            990: 5964, 1020: 6175, 1026: 2386, 1044: 3318, 
            1050: 5745, 1053: 150, 1064: 2450, 1092: 6180, 
            1100: 3312, 1116: 3317, 1125: 297, 1140: 6165, 
            1144: 2458, 1160: 2438, 1170: 5961, 1240: 2430, 
            1242: 2380, 1250: 142, 1288: 2444, 1300: 3311, 
            1323: 308, 1332: 3316, 1352: 318, 1372: 286, 
            1377: 149, 1380: 6150, 1386: 5963, 1428: 6174, 
            1452: 3259, 1470: 5525, 1476: 3315, 1480: 2421, 
            1485: 2397, 1496: 2454, 1530: 5955, 1539: 148, 
            1540: 6182, 1566: 2373, 1575: 3302, 1596: 6164, 
            1624: 2437, 1638: 5960, 1640: 2411, 1650: 5744, 
            1672: 2449, 1674: 2365, 1700: 3310, 1710: 5945, 
            1716: 6178, 1736: 2429, 1740: 6129, 1750: 2334, 
            1755: 2394, 1768: 2453, 1820: 6179, 1860: 6101, 
            1863: 147, 1875: 141, 1900: 3309, 1932: 6149, 
            1950: 5741, 1976: 2448, 1998: 2356, 2024: 2443, 
            2028: 3215, 2058: 2269, 2070: 5930, 2072: 2420, 
            2079: 2396, 2142: 5954, 2156: 3290, 2178: 3248, 
            2205: 3280, 2214: 2346, 2220: 6065, 2244: 6172, 
            2295: 2390, 2296: 2410, 2300: 3308, 2312: 317, 
            2349: 146, 2380: 6173, 2392: 2442, 2394: 5944, 
            2420: 3258, 2436: 6128, 2450: 3270, 2457: 2393, 
            2460: 6020, 2475: 3301, 2508: 6162, 2511: 145, 
            2548: 3289, 2550: 5735, 2552: 2436, 2565: 2385, 
            2574: 5958, 2584: 2447, 2604: 6100, 2610: 5909, 
            2625: 2333, 2652: 6169, 2660: 6163, 2728: 2428, 
            2750: 2332, 2790: 5881, 2850: 5725, 2860: 6177, 
            2888: 316, 2898: 5929, 2900: 3307, 2925: 3300, 
            2964: 6159, 2997: 144, 3016: 2435, 3036: 6147, 
            3042: 3204, 3087: 285, 3100: 3306, 3105: 2379, 
            3108: 6064, 3128: 2441, 3213: 2389, 3220: 6148, 
            3224: 2427, 3234: 5524, 3250: 2329, 3256: 2419, 
            3267: 307, 3321: 143, 3330: 5845, 3332: 3288, 
            3366: 5952, 3380: 3214, 3388: 3257, 3430: 2268, 
            3444: 6019, 3450: 5710, 3465: 5962, 3468: 3160, 
            3496: 2440, 3588: 6144, 3591: 2384, 3608: 2409, 
            3630: 5305, 3654: 5908, 3675: 3269, 3690: 5800, 
            3700: 3305, 3724: 3287, 3740: 6171, 3762: 5942, 
            3822: 5521, 3825: 3299, 3828: 6126, 3848: 2418, 
            3850: 5743, 3861: 2392, 3876: 6155, 3906: 5880, 
            3915: 2372, 3944: 2434, 3978: 5949, 4004: 6176, 
            4060: 6127, 4092: 6098, 4095: 5959, 4100: 3304, 
            4125: 2331, 4180: 6161, 4185: 2364, 4216: 2426, 
            4232: 315, 4250: 2325, 4264: 2408, 4275: 3298, 
            4332: 3094, 4340: 6099, 4347: 2378, 4350: 5689, 
            4375: 140, 4408: 2433, 4420: 6168, 4446: 5939, 
            4508: 3286, 4524: 6123, 4550: 5740, 4554: 5927, 
            4563: 306, 4650: 5661, 4662: 5844, 4692: 6140, 
            4712: 2425, 4732: 3213, 4750: 2320, 4802: 130, 
            4836: 6095, 4851: 3279, 4875: 2328, 4884: 6062, 
            4940: 6158, 4995: 2355, 4998: 5515, 5032: 2417, 
            5049: 2388, 5060: 6146, 5070: 5085, 5082: 5304, 
            5145: 2267, 5166: 5799, 5175: 3297, 5180: 6063, 
            5202: 3149, 5236: 6170, 5244: 6135, 5324: 274, 
            5336: 2432, 5355: 5953, 5382: 5924, 5390: 5523, 
            5412: 6017, 5445: 3247, 5481: 2371, 5535: 2345, 
            5550: 5625, 5576: 2407, 5586: 5505, 5624: 2416, 
            5643: 2383, 5684: 3285, 5704: 2424, 5733: 3278, 
            5740: 6018, 5742: 5906, 5750: 2314, 5772: 6059, 
            5775: 5742, 5780: 3159, 5814: 5935, 5852: 6160, 
            5859: 2363, 5916: 6119, 5950: 5734, 5967: 2387, 
            5980: 6143, 5985: 5943, 6050: 3237, 6076: 3284, 
            6125: 296, 6138: 5878, 6150: 5580, 6188: 6167, 
            6232: 2406, 6292: 3256, 6324: 6091, 6348: 3017, 
            6370: 5520, 6375: 2324, 6380: 6125, 6396: 6014, 
            6435: 5957, 6460: 6154, 6498: 3083, 6525: 3296, 
            6612: 6114, 6650: 5724, 6669: 2382, 6728: 314, 
            6762: 5490, 6786: 5903, 6808: 2415, 6820: 6097, 
            6825: 5739, 6831: 2377, 6875: 139, 6916: 6157, 
            6975: 3295, 6993: 2354, 7038: 5920, 7068: 6086, 
            7084: 6145, 7098: 5084, 7125: 2319, 7150: 5738, 
            7192: 2423, 7203: 129, 7220: 3093, 7245: 5928, 
            7250: 2307, 7252: 3283, 7254: 5875, 7326: 5842, 
            7436: 3212, 7497: 3277, 7540: 6122, 7544: 2405, 
            7546: 2266, 7548: 6055, 7605: 3203, 7623: 3246, 
            7688: 313, 7749: 2344, 7750: 2299, 7803: 305, 
            7820: 6139, 7866: 5915, 7986: 2203, 8004: 6108, 
            8036: 3282, 8050: 5709, 8060: 6094, 8073: 2376, 
            8085: 5522, 8092: 3158, 8118: 5797, 8125: 138, 
            8140: 6061, 8228: 3255, 8325: 3294, 8330: 5514, 
            8364: 6010, 8372: 6142, 8379: 3276, 8415: 5951, 
            8436: 6050, 8450: 3193, 8470: 5303, 8526: 5469, 
            8556: 6080, 8575: 284, 8584: 2414, 8613: 2370, 
            8625: 2313, 8658: 5839, 8670: 4865, 8721: 2381, 
            8740: 6134, 8788: 262, 8874: 5899, 8918: 2263, 
            8925: 5733, 8932: 6124, 9009: 5956, 9020: 6016, 
            9044: 6153, 9075: 3236, 9114: 5441, 9135: 5907, 
            9176: 2413, 9196: 3254, 9207: 2362, 9225: 3293, 
            9250: 2290, 9310: 5504, 9348: 6005, 9350: 5732, 
            9405: 5941, 9438: 5301, 9486: 5871, 9512: 2404, 
            9522: 3006, 9548: 6096, 9555: 5519, 9594: 5794, 
            9620: 6058, 9625: 2330, 9724: 6166, 9747: 304, 
            9765: 5879, 9860: 6118, 9918: 5894, 9945: 5948, 
            9975: 5723, 10092: 2929, 10108: 3092, 10143: 3275, 
            10150: 5688, 10168: 2403, 10179: 2369, 10212: 6044, 
            10250: 2280, 10450: 5722, 10540: 6090, 10556: 6121, 
            10557: 2375, 10580: 3016, 10602: 5866, 10625: 137, 
            10647: 3202, 10660: 6013, 10725: 5737, 10788: 6073, 
            10830: 4645, 10850: 5660, 10868: 6156, 10875: 2306, 
            10878: 5405, 10881: 2361, 10948: 6138, 10952: 312, 
            10989: 2353, 11020: 6113, 11050: 5729, 11115: 5938, 
            11132: 3253, 11154: 5081, 11270: 5489, 11284: 6093, 
            11316: 5999, 11319: 2265, 11322: 5835, 11375: 2327, 
            11385: 5926, 11396: 6060, 11492: 3211, 11532: 2830, 
            11625: 2298, 11655: 5843, 11662: 2259, 11780: 6085, 
            11781: 5950, 11799: 2374, 11830: 5083, 11858: 3226, 
            11875: 136, 11979: 273, 12005: 128, 12006: 5888, 
            12054: 5360, 12075: 5708, 12136: 2402, 12138: 4864, 
            12177: 2343, 12236: 6133, 12342: 5295, 12350: 5719, 
            12495: 5513, 12546: 5790, 12580: 6054, 12628: 6015, 
            12650: 5707, 12654: 5830, 12675: 3192, 12705: 5302, 
            12716: 3157, 12789: 3274, 12834: 5860, 12844: 3210, 
            12876: 6037, 12915: 5798, 12950: 5624, 12987: 2352, 
            13005: 3148, 13034: 2254, 13156: 6141, 13167: 5940, 
            13182: 2137, 13310: 2202, 13311: 2368, 13340: 6107, 
            13377: 2262, 13448: 311, 13455: 5923, 13468: 6057, 
            13475: 3268, 13671: 3273, 13764: 6029, 13794: 5285, 
            13804: 6117, 13875: 2289, 13923: 5947, 13940: 6009, 
            13965: 5503, 14014: 5518, 14022: 5785, 14025: 5731, 
            14036: 3252, 14060: 6049, 14157: 3245, 14210: 5468, 
            14212: 6152, 14229: 2360, 14260: 6079, 14268: 5992, 
            14283: 303, 14350: 5579, 14355: 5905, 14375: 135, 
            14391: 2342, 14450: 3138, 14535: 5934, 14756: 6089, 
            14812: 3015, 14875: 2323, 14877: 2367, 14924: 6012, 
            14950: 5704, 15004: 3251, 15028: 3156, 15125: 295, 
            15138: 2918, 15162: 4644, 15190: 5440, 15225: 5687, 
            15252: 5984, 15318: 5824, 15345: 5877, 15375: 2279, 
            15428: 6112, 15548: 3209, 15561: 5937, 15580: 6004, 
            15675: 5721, 15730: 5300, 15778: 2248, 15870: 4425, 
            15884: 3091, 15903: 2359, 15925: 3267, 15939: 5925, 
            15950: 5686, 16150: 5715, 16182: 5853, 16245: 3082, 
            16275: 5659, 16317: 3272, 16428: 2720, 16492: 6084, 
            16562: 3182, 16575: 5728, 16588: 6120, 16625: 2318, 
            16698: 5270, 16731: 3201, 16796: 6151, 16820: 2928, 
            16905: 5488, 16965: 5902, 16974: 5779, 16983: 2351, 
            17020: 6043, 17050: 5658, 17204: 6137, 17238: 5075, 
            17298: 2819, 17493: 2258, 17595: 5919, 17612: 6053, 
            17732: 6092, 17745: 5082, 17787: 3225, 17875: 2326, 
            17908: 3250, 17980: 6072, 18009: 2366, 18050: 3072, 
            18081: 3271, 18125: 134, 18130: 5404, 18135: 5874, 
            18204: 5975, 18207: 3147, 18315: 5841, 18326: 5512, 
            18513: 3244, 18525: 5718, 18590: 5080, 18634: 2200, 
            18676: 6106, 18772: 3090, 18819: 2341, 18837: 5922, 
            18850: 5683, 18860: 5998, 18865: 2264, 18975: 5706, 
            18981: 2350, 19074: 4861, 19220: 2829, 19228: 6132, 
            19251: 2358, 19266: 5065, 19314: 5817, 19375: 133, 
            19425: 5623, 19516: 6008, 19550: 5700, 19551: 2253, 
            19604: 3208, 19652: 250, 19665: 5914, 19684: 6048, 
            19773: 261, 19844: 3249, 19894: 2241, 19964: 6078, 
            19965: 2201, 20090: 5359, 20097: 5904, 20125: 2312, 
            20150: 5655, 20172: 2599, 20230: 4863, 20295: 5796, 
            20332: 6136, 20349: 5933, 20350: 5622, 20482: 5502, 
            20570: 5294, 20646: 5809, 20691: 3243, 20825: 3266, 
            20956: 3207, 21021: 5517, 21033: 2340, 21054: 5249, 
            21125: 294, 21164: 6056, 21175: 3235, 21266: 2233, 
            21315: 5467, 21402: 5772, 21460: 6036, 21483: 5876, 
            21525: 5578, 21645: 5838, 21658: 5509, 21675: 3137, 
            21692: 6116, 21812: 6003, 21850: 5695, 21879: 5946, 
            21964: 3155, 21970: 2136, 22022: 5298, 22185: 5898, 
            22218: 4424, 22295: 2261, 22425: 5703, 22506: 5221, 
            22542: 4855, 22550: 5577, 22707: 302, 22724: 6131, 
            22743: 3081, 22785: 5439, 22878: 5764, 22940: 6028, 
            22977: 2349, 22990: 5284, 23125: 132, 23188: 6088, 
            23275: 3265, 23276: 3014, 23322: 5050, 23375: 2322, 
            23452: 6011, 23548: 2927, 23595: 5299, 23667: 2247, 
            23715: 5870, 23751: 5901, 23780: 5991, 23805: 3005, 
            23826: 4641, 23828: 6042, 23925: 5685, 23985: 5793, 
            24050: 5619, 24206: 5499, 24225: 5714, 24244: 6111, 
            24273: 2357, 24453: 5936, 24548: 3089, 24633: 5918, 
            24642: 2709, 24650: 5679, 24794: 5487, 24795: 5893, 
            24843: 3181, 25012: 3206, 25025: 5736, 25047: 3242, 
            25172: 6071, 25230: 4205, 25270: 4643, 25375: 2305, 
            25382: 2224, 25389: 5873, 25420: 5983, 25461: 2339, 
            25575: 5657, 25625: 131, 25636: 6115, 25641: 5840, 
            25857: 3200, 25916: 6083, 25947: 301, 26026: 5078, 
            26125: 2317, 26350: 5651, 26404: 5997, 26411: 127, 
            26450: 2995, 26505: 5865, 26588: 3154, 26650: 5574, 
            26862: 5185, 26908: 2828, 27075: 3071, 27125: 2297, 
            27195: 5403, 27306: 5755, 27380: 2719, 27404: 6087, 
            27436: 238, 27489: 5511, 27508: 3013, 27531: 5913, 
            27550: 5674, 27625: 2321, 27676: 6052, 27716: 3205, 
            27830: 5269, 27885: 5079, 27951: 2199, 28126: 2214, 
            28158: 4635, 28175: 3264, 28275: 5682, 28305: 5834, 
            28322: 3127, 28413: 5795, 28611: 3146, 28652: 6110, 
            28730: 5074, 28798: 5292, 28830: 3985, 28899: 3199, 
            28971: 2348, 29155: 2257, 29282: 118, 29302: 5484, 
            29325: 5699, 29348: 6105, 29406: 5029, 29450: 5646, 
            29478: 2071, 29575: 3191, 29601: 5921, 29645: 3224, 
            29716: 6130, 29766: 5140, 29841: 2240, 30015: 5887, 
            30044: 6035, 30135: 5358, 30225: 5654, 30258: 2588, 
            30303: 5837, 30340: 5974, 30345: 4862, 30525: 5621, 
            30628: 6082, 30668: 6007, 30723: 5501, 30758: 2134, 
            30855: 5293, 30875: 2316, 30932: 6047, 30969: 2347, 
            31059: 5897, 31213: 126, 31262: 5466, 31365: 5789, 
            31372: 6077, 31434: 5001, 31450: 5615, 31581: 3241, 
            31625: 2311, 31635: 5829, 31654: 5495, 31790: 4860, 
            31899: 2232, 31977: 5932, 32085: 5859, 32103: 2338, 
            32110: 5064, 32116: 6027, 32186: 5282, 32375: 2288, 
            32487: 5508, 32585: 2252, 32708: 6051, 32725: 5730, 
            32775: 5694, 32946: 4845, 32955: 2135, 33033: 5297, 
            33201: 5869, 33212: 3088, 33275: 272, 33292: 5990, 
            33327: 3004, 33350: 5668, 33418: 5438, 33524: 3153, 
            33579: 5792, 33620: 2598, 33759: 3240, 33813: 3145, 
            33825: 5576, 34276: 6002, 34317: 2337, 34485: 5283, 
            34606: 2197, 34684: 6104, 34713: 5892, 34850: 5570, 
            34914: 4421, 34983: 3198, 35035: 5516, 35055: 5784, 
            35090: 5248, 35150: 5610, 35322: 4204, 35378: 3061, 
            35525: 3263, 35588: 5982, 35650: 5640, 35739: 3080, 
            35836: 3152, 35875: 2278, 35972: 3012, 36075: 5618, 
            36125: 293, 36244: 6006, 36309: 5498, 36556: 6046, 
            36575: 5720, 36822: 4625, 36946: 5463, 36963: 300, 
            36975: 5678, 37004: 2926, 37030: 4423, 37076: 6076, 
            37107: 5864, 37191: 5486, 37323: 5900, 37375: 2310, 
            37444: 6041, 37468: 6109, 37510: 5220, 37518: 4965, 
            37570: 4854, 37791: 5931, 37845: 2917, 37905: 4642, 
            37975: 3262, 38073: 2223, 38295: 5823, 38318: 5480, 
            38332: 2718, 38675: 5727, 38709: 5917, 38870: 5049, 
            38950: 5565, 38962: 5267, 39039: 5077, 39325: 3234, 
            39445: 2246, 39494: 5435, 39525: 5650, 39556: 6070, 
            39627: 5833, 39675: 2994, 39710: 4640, 39875: 2304, 
            39882: 4830, 39886: 5402, 39897: 5872, 39975: 5573, 
            40052: 6081, 40204: 3011, 40222: 5072, 40293: 3239, 
            40362: 3984, 40375: 2315, 40455: 5852, 40508: 6001, 
            40817: 125, 40898: 3171, 40959: 2336, 41070: 3765, 
            41154: 2005, 41262: 4415, 41325: 5673, 41405: 3180, 
            41492: 5996, 41503: 283, 41574: 4920, 41745: 5268, 
            41876: 3087, 42021: 5886, 42050: 2907, 42189: 2213, 
            42237: 3079, 42284: 2827, 42435: 5778, 42476: 5973, 
            42483: 3126, 42550: 5604, 42625: 2296, 42772: 3151, 
            42826: 5475, 43095: 5073, 43197: 5291, 43225: 5717, 
            43245: 2818, 43263: 5912, 43732: 2925, 43911: 5788, 
            43923: 117, 43953: 5483, 44109: 3197, 44175: 5645, 
            44198: 5357, 44217: 249, 44252: 6040, 44275: 5705, 
            44289: 5828, 44506: 4858, 44649: 3238, 44764: 3086, 
            44770: 5184, 44919: 5858, 44950: 5633, 44954: 5062, 
            45125: 292, 45254: 2193, 45325: 3261, 45356: 6103, 
            45387: 299, 45619: 124, 45747: 5916, 45815: 5510, 
            46137: 2133, 46475: 3190, 46585: 2198, 46748: 6069, 
            46893: 5465, 46930: 4634, 47068: 2597, 47125: 2303, 
            47138: 5399, 47150: 5559, 47151: 3196, 47175: 5614, 
            47212: 6034, 47396: 3150, 47481: 5494, 47619: 5836, 
            47685: 4859, 47804: 6045, 48050: 2808, 48165: 5063, 
            48279: 5281, 48285: 5816, 48314: 5459, 48334: 2131, 
            48484: 6075, 48668: 226, 48807: 5896, 48875: 2309, 
            49010: 5028, 49036: 5995, 49049: 2260, 49077: 5783, 
            49126: 5246, 49130: 2070, 49419: 3144, 49610: 5139, 
            49735: 2239, 49818: 4610, 49972: 2826, 50025: 5667, 
            50127: 5437, 50225: 3260, 50286: 4809, 50375: 2295, 
            50430: 3545, 50468: 6026, 50575: 3136, 50578: 2188, 
            50692: 6102, 50875: 2287, 51129: 5911, 51205: 5500, 
            51425: 3233, 51615: 5808, 51646: 5431, 51842: 2984, 
            51909: 2196, 52173: 5868, 52234: 5354, 52275: 5569, 
            52316: 5989, 52325: 5702, 52371: 3003, 52390: 5000, 
            52514: 5218, 52598: 4852, 52635: 5247, 52725: 5609, 
            52767: 5791, 52972: 6000, 52983: 2916, 53067: 3060, 
            53165: 2231, 53428: 3085, 53475: 5639, 53482: 5289, 
            53505: 5771, 53613: 5822, 53650: 5597, 53754: 4781, 
            53958: 4405, 53998: 5454, 54145: 5507, 54188: 6074, 
            54418: 5047, 54549: 5891, 54625: 2308, 54910: 4844, 
            54925: 260, 55055: 5296, 55223: 123, 55233: 3078, 
            55419: 5462, 55506: 4201, 55545: 4422, 55594: 4638, 
            55796: 6033, 55825: 5684, 55924: 5981, 56265: 5219, 
            56277: 3195, 56355: 4853, 56375: 2277, 56525: 5713, 
            56637: 5851, 57122: 106, 57188: 2924, 57195: 5763, 
            57350: 5589, 57475: 3232, 57477: 5479, 57498: 3764, 
            57681: 5895, 57722: 5426, 57868: 6039, 57967: 282, 
            58190: 4420, 58305: 5048, 58311: 5863, 58425: 5564, 
            58443: 5266, 58870: 4203, 59204: 3084, 59241: 5434, 
            59409: 5777, 59450: 5552, 59565: 4639, 59644: 6025, 
            59675: 5656, 59774: 5279, 59823: 3143, 59829: 5401, 
            60125: 2286, 60236: 2717, 60306: 4390, 60333: 5071, 
            60515: 5497, 60543: 2817, 60775: 5726, 61132: 6068, 
            61226: 2182, 61347: 3170, 61364: 3010, 61370: 4624, 
            61605: 2708, 61625: 2302, 61642: 5395, 61659: 5867, 
            61731: 237, 61828: 5988, 61893: 3002, 61985: 5485, 
            62271: 5832, 62361: 3194, 62530: 4964, 62678: 5182, 
            62814: 4589, 63075: 2906, 63175: 3070, 63206: 5069, 
            63426: 3981, 63455: 2222, 63550: 5544, 63825: 5603, 
            63916: 2923, 64124: 5994, 64141: 2256, 64158: 4745, 
            64239: 5474, 64467: 5890, 64676: 6038, 65065: 5076, 
            65219: 271, 65348: 2825, 65366: 5448, 65596: 3009, 
            65598: 4195, 65702: 4632, 65875: 2294, 65975: 5681, 
            66033: 5885, 66092: 5980, 66125: 291, 66297: 5356, 
            66470: 4829, 66625: 2276, 66748: 5972, 66759: 4857, 
            66861: 5910, 67146: 4561, 67155: 5183, 67270: 3983, 
            67425: 5632, 67431: 5061, 67599: 5815, 67881: 2192, 
            67925: 5716, 68265: 5754, 68306: 5350, 68324: 6067, 
            68425: 5698, 68450: 2698, 68590: 2004, 68614: 5026, 
            68770: 4414, 68782: 2068, 68875: 2301, 68894: 5390, 
            68913: 5862, 69003: 5787, 69290: 4919, 69454: 5137, 
            69575: 3231, 69597: 5827, 69629: 122, 69874: 5420, 
            69938: 3116, 70315: 2212, 70395: 4633, 70525: 5653, 
            70587: 5857, 70602: 3544, 70642: 5059, 70707: 5398, 
            70725: 5558, 70805: 3125, 71094: 4700, 71188: 2716, 
            71225: 5620, 71668: 5993, 71687: 2251, 71825: 3189, 
            71995: 5290, 72075: 2807, 72261: 5807, 72358: 5264, 
            72471: 5458, 72501: 2130, 72964: 6032, 73002: 1939, 
            73036: 2824, 73205: 116, 73255: 5482, 73346: 4998, 
            73515: 5027, 73593: 5831, 73625: 2293, 73689: 5245, 
            73695: 2069, 73964: 2596, 74415: 5138, 74431: 121, 
            74698: 2127, 74727: 3077, 74907: 5770, 74958: 3975, 
            75429: 3142, 75645: 2587, 75803: 2255, 75850: 5535, 
            75867: 2187, 76342: 5345, 76475: 5693, 76874: 4842, 
            76895: 2132, 77077: 3223, 77121: 5782, 77198: 2175, 
            77372: 2922, 77469: 5430, 77763: 2983, 77996: 6024, 
            78039: 5884, 78155: 5464, 78166: 5275, 78292: 3008, 
            78351: 5353, 78585: 4999, 78625: 2285, 78771: 5217, 
            78884: 5971, 78897: 4851, 78925: 5575, 79135: 5493, 
            79475: 3135, 80073: 5762, 80142: 4525, 80223: 5288, 
            80275: 3188, 80465: 5280, 80475: 5596, 80631: 3141, 
            80852: 5987, 80937: 3001, 80997: 5453, 81466: 4418, 
            81548: 6031, 81549: 5786, 81627: 5046, 82225: 5701, 
            82251: 5826, 82365: 4843, 82418: 2896, 82522: 2167, 
            82654: 4849, 82708: 6066, 83030: 4609, 83259: 2915, 
            83375: 2300, 83391: 4637, 83398: 5384, 83421: 5856, 
            83486: 2122, 83545: 5436, 83810: 4808, 84050: 2577, 
            84175: 5617, 84249: 5821, 84303: 5889, 84721: 2250, 
            85514: 5044, 85683: 105, 85782: 4185, 85918: 4622, 
            86025: 5588, 86247: 2707, 86275: 5677, 86428: 5979, 
            86515: 2195, 86583: 5425, 86756: 3007, 86779: 2245, 
            87125: 2275, 87172: 6023, 87285: 4419, 87362: 3050, 
            87412: 2595, 87542: 4962, 87725: 3230, 87875: 2284, 
            88102: 5413, 88305: 4202, 88412: 2823, 88445: 3059, 
            88806: 4480, 88825: 5712, 88837: 120, 89001: 5850, 
            89125: 2292, 89175: 5551, 89590: 4780, 89661: 5278, 
            89930: 4404, 90117: 5861, 90354: 3761, 90364: 5986, 
            90459: 3000, 91091: 3179, 91143: 5781, 91234: 5243, 
            91839: 2181, 92046: 4369, 92055: 4623, 92225: 5649, 
            92365: 5461, 92414: 5339, 92463: 5394, 92510: 4200, 
            92575: 2993, 93058: 4827, 93092: 2715, 93275: 5572, 
            93357: 5776, 93775: 3229, 93795: 4963, 93925: 3134, 
            94017: 5181, 94178: 2797, 94221: 3076, 94622: 5260, 
            94809: 5068, 95139: 2816, 95325: 5543, 95571: 5753, 
            95795: 5478, 95830: 3763, 95874: 4170, 96026: 2002, 
            96237: 3140, 96278: 4412, 96425: 5672, 96596: 5978, 
            97006: 4917, 97175: 3187, 97375: 2274, 97405: 5265, 
            97526: 5215, 97556: 214, 97682: 3105, 98022: 3965, 
            98049: 5447, 98394: 4341, 98397: 2914, 98441: 119, 
            98494: 2158, 98553: 4631, 98716: 6030, 98735: 5433, 
            99127: 281, 99275: 3069, 99567: 5820, 99705: 4828, 
            99715: 5400, 100510: 4389, 100555: 5070, 100719: 3075, 
            100793: 3222, 100905: 3982, 101062: 2116, 102051: 5883, 
            102245: 3169, 102459: 5349, 102487: 115, 102557: 2244, 
            102675: 2697, 102885: 2003, 102921: 5025, 103075: 5644, 
            103155: 4413, 103156: 5970, 103173: 2067, 103246: 4629, 
            103341: 5389, 103675: 5680, 103935: 4918, 104044: 2714, 
            104181: 5136, 104284: 2921, 104690: 4588, 104811: 5419, 
            104907: 3115, 104975: 5711, 105125: 290, 105154: 5377, 
            105183: 5849, 105524: 6022, 105710: 3980, 105754: 5255, 
            105903: 2586, 105963: 5058, 106227: 5814, 106375: 2283, 
            106641: 3139, 106782: 3755, 106930: 4744, 107065: 5473, 
            107525: 5697, 107559: 5825, 107653: 259, 107822: 5023, 
            108086: 2065, 108537: 5263, 109089: 5855, 109142: 2148, 
            109174: 5055, 109330: 4194, 109388: 5985, 109417: 2238, 
            109503: 225, 109554: 3950, 110019: 4997, 110075: 5613, 
            110331: 5775, 110495: 5355, 110789: 2249, 110825: 5652, 
            110946: 3541, 111265: 4856, 111476: 2822, 111910: 4560, 
            111925: 3228, 112047: 2126, 112375: 2291, 112385: 5060, 
            112406: 5369, 112437: 2815, 112651: 3221, 113135: 2191, 
            113553: 5806, 113775: 5534, 114057: 5882, 114308: 2594, 
            114513: 5344, 115258: 4995, 115292: 5969, 115311: 4841, 
            115797: 2174, 116058: 4149, 116242: 4607, 116402: 5179, 
            116522: 5332, 116725: 5666, 116932: 5977, 116963: 2230, 
            117249: 5274, 117325: 3068, 117334: 4806, 117438: 4305, 
            117670: 3543, 117711: 5769, 117845: 5397, 117875: 2273, 
            118490: 4699, 119119: 5506, 119164: 202, 119187: 5780, 
            119306: 5239, 120125: 289, 120175: 5692, 120213: 3074, 
            120785: 5457, 120802: 4839, 120835: 2129, 121121: 2194, 
            121670: 1938, 121923: 5854, 121975: 5568, 122018: 3039, 
            122199: 4417, 122525: 3186, 122815: 5244, 122825: 248, 
            123025: 5608, 123627: 2895, 123783: 2166, 123823: 280, 
            123981: 4848, 124025: 3227, 124468: 2920, 124545: 4608, 
            124558: 5324, 124775: 5638, 124930: 3974, 125097: 5383, 
            125229: 2121, 125426: 4778, 125541: 5813, 125715: 4807, 
            125829: 5761, 125902: 4402, 125948: 2713, 126075: 2576, 
            126445: 2186, 127075: 5696, 127426: 2109, 127534: 5211, 
            127738: 2061, 127756: 2593, 128018: 2973, 128271: 5043, 
            128673: 2913, 128877: 4621, 128986: 5134, 129115: 5429, 
            129311: 2237, 129514: 4198, 129605: 2982, 130134: 4260, 
            130203: 5819, 130585: 5352, 130975: 3185, 131043: 3049, 
            131118: 3535, 131285: 5216, 131313: 4961, 131495: 4850, 
            132153: 5412, 132158: 5040, 132275: 5616, 132618: 3929, 
            133052: 6021, 133133: 5496, 133209: 3073, 133342: 5234, 
            133570: 4524, 133705: 5287, 134113: 2243, 134125: 2282, 
            134162: 2687, 134199: 5805, 134385: 4779, 134895: 4403, 
            134995: 5452, 135014: 4619, 135531: 2706, 135575: 5676, 
            136045: 5045, 136214: 2101, 136325: 5563, 136367: 3220, 
            136851: 5242, 137275: 3133, 137547: 5848, 137566: 4959, 
            137924: 2919, 138069: 2999, 138229: 2229, 138621: 5338, 
            138765: 4199, 138985: 4636, 139113: 5768, 139564: 5968, 
            139587: 4826, 139601: 2221, 139638: 3745, 140714: 4387, 
            140777: 3178, 141267: 2796, 141933: 5259, 142025: 5691, 
            142228: 2821, 142538: 5206, 142766: 4835, 142805: 104, 
            142970: 4184, 143143: 3168, 143375: 2281, 143745: 3762, 
            143811: 2912, 144039: 2001, 144279: 5774, 144305: 5424, 
            144417: 4411, 144925: 5648, 145475: 2992, 145509: 4916, 
            145521: 5818, 146234: 4824, 146289: 5214, 146334: 1873, 
            146523: 3104, 146566: 4586, 146575: 5571, 147033: 2814, 
            147175: 2905, 147436: 5976, 147591: 2998, 147706: 5035, 
            147741: 2157, 147994: 3978, 148010: 4479, 148625: 2272, 
            148666: 5315, 148707: 5760, 148925: 5602, 149435: 5277, 
            149702: 4742, 149891: 2242, 150183: 5752, 150590: 3760, 
            150765: 4388, 150898: 1999, 151294: 4409, 151525: 5671, 
            151593: 2115, 152218: 5175, 152438: 4914, 153062: 4192, 
            153065: 2180, 153410: 4368, 153425: 3067, 153729: 5847, 
            154105: 5393, 154652: 2592, 154693: 2211, 154869: 4628, 
            155771: 3124, 156066: 3730, 156325: 3184, 156426: 4121, 
            156674: 4558, 156695: 5180, 157035: 4587, 157325: 5631, 
            157339: 3177, 157604: 2820, 157731: 5376, 158015: 5067, 
            158389: 2190, 158565: 3979, 158631: 5254, 158804: 2712, 
            158875: 2271, 159562: 4615, 159790: 4169, 160173: 2705, 
            160225: 5675, 160395: 4743, 161161: 5481, 161253: 5773, 
            161414: 5228, 161733: 5022, 161975: 5643, 162129: 2064, 
            162578: 2092, 163370: 3964, 163415: 5446, 163713: 2147, 
            163761: 5054, 163990: 4340, 163995: 4193, 164169: 5812, 
            164255: 4630, 164331: 2813, 164738: 2566, 164983: 2220, 
            165025: 5557, 165886: 4697, 166175: 3132, 166419: 2585, 
            166634: 5019, 167042: 94, 167214: 3901, 167865: 4559, 
            168175: 2806, 168609: 5368, 168674: 5130, 169099: 2236, 
            169169: 2128, 169756: 2711, 170126: 5170, 170338: 1936, 
            170765: 5348, 171125: 288, 171275: 5647, 171462: 3525, 
            171475: 236, 171535: 5024, 171925: 2991, 171941: 3219, 
            171955: 2066, 172235: 5388, 172546: 5200, 172822: 4820, 
            172887: 4994, 172975: 5612, 173225: 3183, 173635: 5135, 
            174087: 2911, 174097: 5492, 174363: 4606, 174603: 5178, 
            174685: 5418, 174783: 5331, 174845: 3114, 174902: 3972, 
            175491: 5804, 175972: 5967, 176001: 4805, 176157: 2997, 
            176505: 3542, 176605: 5057, 177023: 2185, 177489: 5751, 
            177735: 4698, 177970: 3754, 178126: 4991, 178334: 1995, 
            178746: 1807, 178802: 2962, 178959: 5238, 179075: 5670, 
            180154: 2082, 180761: 2228, 180895: 5262, 181203: 4838, 
            181447: 279, 181917: 5767, 182505: 1937, 182590: 3949, 
            182666: 4604, 182819: 2210, 183027: 3038, 183365: 4996, 
            183425: 5665, 183483: 5811, 183799: 3218, 184093: 3123, 
            184382: 4803, 184910: 3540, 185725: 5690, 186093: 5846, 
            186238: 5014, 186694: 2056, 186702: 4085, 186745: 2125, 
            186837: 5323, 186998: 4522, 187187: 5286, 187395: 3973, 
            187775: 5595, 188108: 5966, 188139: 4777, 188518: 5125, 
            188853: 4401, 188922: 3709, 188993: 2235, 189625: 2270, 
            190333: 114, 190463: 3176, 190855: 5343, 191139: 2108, 
            191301: 5210, 191425: 5642, 191607: 2060, 191634: 3510, 
            191675: 5567, 192027: 2972, 192185: 4840, 192995: 2173, 
            193325: 5607, 193430: 4148, 193479: 5133, 194271: 4197, 
            194463: 5759, 194579: 3058, 194996: 2591, 195201: 2996, 
            195415: 5273, 195730: 4304, 196075: 5637, 196137: 5803, 
            196677: 2584, 197098: 4775, 197846: 4399, 198237: 5039, 
            198927: 2812, 199082: 4986, 199927: 103, 200013: 5233, 
            200158: 4182, 200355: 4523, 200725: 5587, 201243: 2686, 
            202027: 2227, 202521: 4618, 202612: 190, 203203: 5460, 
            203319: 5766, 203522: 2885, 203665: 4416, 204321: 2100, 
            204425: 5611, 205751: 5491, 205942: 5164, 206045: 2894, 
            206305: 2165, 206349: 4958, 206635: 4847, 206886: 4040, 
            207214: 4477, 207575: 3066, 208075: 5550, 208444: 2590, 
            208495: 5382, 208658: 3028, 208715: 2120, 209209: 5276, 
            209457: 2704, 209525: 3131, 210125: 287, 210749: 5477, 
            210826: 3758, 211071: 4386, 212602: 4955, 213342: 3865, 
            213785: 5042, 213807: 5205, 214149: 4834, 214225: 5562, 
            214291: 2179, 214455: 4183, 214774: 4366, 214795: 4620, 
            215747: 2219, 215878: 4600, 216775: 5664, 216890: 4259, 
            217217: 5432, 217341: 5758, 217558: 5193, 217906: 4799, 
            218405: 3048, 218530: 3534, 218855: 4960, 219351: 4823, 
            219373: 3217, 219501: 213, 219849: 4585, 220255: 5411, 
            221030: 3928, 221122: 4384, 221221: 5066, 221559: 5034, 
            221991: 3977, 222015: 4478, 222111: 5810, 222425: 5542, 
            222999: 5314, 223706: 4167, 223975: 3130, 224516: 2710, 
            224553: 4741, 224825: 2990, 224939: 270, 225446: 5008, 
            225885: 3759, 225998: 2050, 226347: 1998, 226525: 5566, 
            226941: 4408, 228085: 5241, 228206: 5119, 228327: 5174, 
            228475: 5606, 228657: 4913, 228718: 3962, 228781: 2234, 
            229586: 4338, 229593: 4191, 229957: 3057, 230115: 4367, 
            230318: 4583, 231035: 5337, 231275: 2904, 231725: 5636, 
            231978: 3489, 232101: 5750, 232562: 2786, 232645: 4825, 
            232730: 3744, 232934: 4771, 233206: 1990, 233818: 4395, 
            234025: 5601, 234099: 2703, 234175: 5669, 234639: 2910, 
            235011: 4557, 235246: 4739, 235445: 2795, 235543: 5472, 
            235586: 4910, 236406: 3820, 236555: 5258, 237429: 5802, 
            237614: 4950, 238206: 3681, 239071: 2209, 239343: 4614, 
            239575: 2696, 239685: 4168, 240065: 2000, 240149: 3175, 
            240526: 4189, 240695: 4410, 240737: 247, 240994: 4980, 
            241129: 2218, 242121: 5227, 242515: 4915, 243089: 3216, 
            243815: 5213, 243867: 2091, 243890: 1872, 244205: 3103, 
            244559: 2226, 244783: 3113, 245055: 3963, 245985: 4339, 
            246123: 5765, 246202: 4555, 246235: 2156, 247107: 2565, 
            247225: 5630, 247247: 5056, 248788: 2589, 248829: 4696, 
            248897: 113, 249067: 5476, 249158: 3752, 249951: 5018, 
            250325: 5641, 250563: 93, 250821: 2811, 251275: 2989, 
            252586: 4815, 252655: 2114, 253011: 5129, 253175: 5561, 
            253253: 5261, 254634: 3645, 255189: 5169, 255507: 1935, 
            255626: 3947, 256711: 3174, 257193: 2583, 258115: 4627, 
            258819: 5199, 258874: 3538, 259233: 4819, 259259: 5396, 
            259325: 5556, 259407: 5749, 259666: 5157, 260110: 3729, 
            260642: 82, 260678: 4694, 260710: 4120, 261326: 4380, 
            261443: 2124, 261725: 3065, 262353: 3971, 262885: 5375, 
            263097: 5757, 263302: 4905, 264275: 2805, 264385: 5253, 
            265475: 5533, 265727: 5456, 265837: 258, 266955: 3753, 
            267189: 4990, 267197: 2208, 267325: 3129, 267501: 1994, 
            267674: 1933, 268119: 201, 268203: 2961, 269059: 3122, 
            269555: 5021, 270193: 2172, 270215: 2063, 270231: 2081, 
            270802: 4146, 272194: 4579, 272855: 2146, 272935: 5053, 
            273325: 2903, 273581: 5272, 273885: 3948, 273999: 4603, 
            274022: 4302, 274846: 3969, 275684: 178, 276573: 4802, 
            276575: 5600, 277365: 3539, 277574: 5149, 278018: 4735, 
            278179: 112, 278369: 5471, 278690: 3900, 279357: 5013, 
            279775: 3064, 280041: 2055, 280053: 2909, 280497: 4521, 
            281015: 5367, 282302: 4595, 282777: 5124, 283383: 2702, 
            283475: 5663, 284053: 5428, 284258: 2874, 284954: 2043, 
            285131: 2981, 285770: 3524, 287287: 5351, 287451: 2582, 
            287638: 4944, 287738: 5112, 288145: 4993, 288463: 278, 
            288827: 2164, 289289: 4846, 290145: 4147, 290605: 4605, 
            290966: 4551, 291005: 5177, 291305: 5330, 291893: 2217, 
            292175: 5629, 292201: 2119, 292494: 3461, 293335: 4804, 
            293595: 4303, 293854: 4519, 294151: 2189, 294175: 2575, 
            295075: 5594, 295647: 4774, 296225: 3128, 296769: 4398, 
            296989: 5451, 297910: 1806, 298265: 5237, 298623: 4985, 
            298775: 5605, 299299: 5041, 299367: 5801, 300237: 4181, 
            300713: 3056, 302005: 4837, 303025: 5635, 303646: 4257, 
            303862: 4973, 303918: 1741, 304175: 224, 304606: 2035, 
            305045: 3037, 305283: 2884, 305762: 2951, 305767: 3047, 
            305942: 3532, 306397: 3173, 306475: 5555, 307582: 5104, 
            308074: 4690, 308357: 2225, 308913: 5163, 309442: 3926, 
            310329: 2908, 310821: 4476, 311170: 4084, 311395: 5322, 
            312325: 2804, 312666: 3425, 312987: 3027, 313565: 4776, 
            314019: 5748, 314041: 5455, 314171: 102, 314534: 4179, 
            314755: 4400, 314870: 3708, 315425: 5586, 315514: 1984, 
            316239: 3757, 316342: 1929, 316825: 5662, 317471: 5423, 
            318478: 4794, 318565: 2107, 318734: 4899, 318835: 5209, 
            318903: 4954, 319319: 5240, 319345: 2059, 319390: 3509, 
            320013: 2810, 320045: 2971, 322161: 4365, 322465: 5132, 
            323449: 2207, 323785: 4196, 323817: 4599, 324818: 2775, 
            325335: 4258, 325622: 4474, 325703: 3121, 325822: 3742, 
            326337: 5192, 326859: 4798, 326975: 5549, 327795: 3533, 
            328757: 2184, 329623: 277, 330395: 5038, 331075: 5560, 
            331177: 5257, 331298: 2676, 331545: 3927, 331683: 4383, 
            331731: 5756, 333355: 5232, 333925: 3063, 335405: 2685, 
            335559: 4166, 335699: 5427, 336091: 235, 336743: 111, 
            336774: 3600, 336973: 2980, 337502: 4363, 337535: 4617, 
            338169: 5007, 338675: 5634, 338997: 2049, 339031: 5392, 
            339521: 3172, 340442: 4766, 340535: 2099, 341341: 5212, 
            341446: 1870, 341734: 4375, 341887: 3102, 342309: 5118, 
            343077: 3961, 343915: 4957, 344379: 4337, 344729: 2155, 
            344810: 4039, 345477: 4582, 347282: 4515, 347633: 3167, 
            347967: 2581, 348725: 5593, 348843: 2785, 349095: 3743, 
            349401: 4770, 349525: 5541, 349809: 1989, 350727: 4394, 
            350987: 5450, 351538: 4164, 351785: 4385, 352869: 4738, 
            353379: 4909, 353717: 2113, 354609: 2809, 355570: 3864, 
            355946: 4574, 356345: 5204, 356421: 4949, 356915: 4833, 
            357309: 2701, 357425: 2902, 359414: 3959, 359513: 5445, 
            360778: 4335, 360789: 4188, 361361: 4626, 361491: 4979, 
            361675: 5599, 362674: 4937, 363562: 2026, 364021: 5470, 
            364154: 3727, 364994: 4118, 365585: 4822, 365835: 1871, 
            366415: 4584, 367114: 5095, 368039: 2216, 369265: 5033, 
            369303: 4554, 369985: 3976, 370025: 3062, 370139: 5252, 
            371665: 5313, 371722: 4175, 372775: 5585, 373182: 3380, 
            373737: 3751, 374255: 4740, 375193: 5422, 375683: 5347, 
            376475: 2695, 377245: 1997, 377377: 5020, 378235: 4407, 
            378301: 2062, 378879: 4814, 378917: 5387, 380494: 4546, 
            380545: 5173, 381095: 4912, 381938: 2940, 381951: 2700, 
            381997: 2145, 382075: 5628, 382109: 5052, 382655: 4190, 
            383439: 3946, 383525: 2988, 384307: 5417, 384659: 269, 
            384826: 4470, 385526: 4788, 386425: 5548, 386630: 3488, 
            387686: 4929, 388311: 3537, 388531: 3166, 389499: 5156, 
            390165: 3728, 390166: 3898, 390963: 81, 391017: 4693, 
            391065: 4119, 391534: 3749, 391685: 4556, 391989: 4379, 
            393421: 2215, 394010: 3819, 394953: 4904, 395937: 5747, 
            397010: 3680, 397822: 1977, 397969: 2178, 398866: 4359, 
            398905: 4613, 399475: 2901, 400078: 3522, 400673: 5391, 
            400775: 5554, 401511: 1932, 401698: 3944, 401882: 4892, 
            402866: 2016, 403403: 4992, 403535: 5226, 404225: 5598, 
            406203: 4145, 406334: 4730, 406445: 2090, 406802: 2555, 
            406847: 3055, 407407: 5176, 407827: 2206, 408291: 4578, 
            408425: 2803, 409975: 2987, 410669: 3120, 410839: 2123, 
            411033: 4301, 411845: 2564, 412114: 4760, 412269: 3968, 
            413075: 5540, 413526: 1675, 413678: 1924, 414715: 4695, 
            415454: 4160, 416361: 5148, 416585: 5017, 417027: 4734, 
            417074: 1804, 417175: 5532, 417571: 5236, 417605: 92, 
            418035: 3899, 419881: 5342, 421685: 5128, 422807: 4836, 
            423243: 5746, 423453: 4594, 424390: 3644, 424589: 110, 
            424762: 3955, 424879: 5444, 425258: 1969, 425315: 5168, 
            425546: 4143, 425845: 1934, 426374: 4331, 426387: 2873, 
            427025: 5627, 427063: 3036, 427431: 2042, 428655: 3523, 
            429598: 4884, 429913: 2183, 430606: 4299, 431365: 5198, 
            431457: 4943, 431607: 5111, 432055: 4818, 435638: 4082, 
            435953: 2205, 436449: 4550, 437255: 3970, 438741: 2580, 
            438991: 3119, 440657: 2979, 440781: 4518, 440818: 3706, 
            443989: 5346, 444925: 2694, 445315: 4989, 445835: 1993, 
            445991: 2106, 446369: 5208, 446865: 1805, 447005: 2960, 
            447083: 2058, 447146: 3507, 447811: 5386, 447925: 5553, 
            448063: 2970, 450262: 4685, 450385: 2080, 451451: 5131, 
            453299: 2893, 453871: 109, 454138: 4510, 454181: 5416, 
            454597: 3112, 455469: 4256, 455793: 4972, 455877: 189, 
            456025: 5592, 456475: 2802, 456665: 4602, 456909: 2034, 
            458643: 2950, 458689: 5381, 458913: 3531, 458983: 5449, 
            459173: 2118, 460955: 4801, 461373: 5103, 462111: 4689, 
            462275: 2574, 462346: 1918, 462553: 5037, 462722: 2665, 
            464163: 3925, 465595: 5012, 466697: 5231, 466735: 2054, 
            466755: 4083, 467495: 4520, 468999: 2579, 469567: 276, 
            470327: 3165, 471295: 5123, 471801: 4178, 472305: 3707, 
            472549: 4616, 473271: 1983, 474513: 1928, 474734: 3940, 
            476749: 2098, 477158: 4254, 477717: 4793, 478101: 4898, 
            479085: 3508, 480491: 268, 480766: 3529, 481481: 4956, 
            481574: 4568, 482734: 4037, 483575: 2900, 484561: 5410, 
            485537: 101, 486098: 2863, 486266: 3923, 487227: 2774, 
            487475: 5584, 487490: 3460, 488433: 4473, 488733: 3741, 
            489325: 2986, 490637: 5421, 491878: 4724, 492499: 2978, 
            492745: 4773, 493025: 5531, 494615: 4397, 496223: 5341, 
            496947: 2675, 497705: 4984, 497798: 3862, 498883: 5203, 
            499681: 4832, 500395: 4180, 501787: 2171, 502918: 4139, 
            503234: 4465, 505161: 2699, 505325: 5547, 506253: 4362, 
            506530: 1740, 507566: 1960, 508079: 5271, 508277: 5336, 
            508805: 2883, 508898: 4295, 509675: 5591, 510663: 4765, 
            511819: 4821, 512006: 3739, 512169: 1869, 512601: 4374, 
            512746: 4875, 512981: 3054, 514786: 4540, 514855: 5162, 
            516925: 5626, 516971: 5032, 517215: 4038, 517979: 2794, 
            518035: 4475, 519622: 4753, 520331: 2204, 520421: 2177, 
            520923: 4514, 521110: 3424, 521594: 4354, 521645: 3026, 
            523957: 3118, 527065: 3756, 527307: 4163, 528143: 1996, 
            529529: 4406, 531505: 4953, 532763: 5172, 533355: 3863, 
            533533: 4911, 533919: 4573, 535717: 2892, 536393: 2163, 
            536558: 1867, 536935: 4364, 537251: 3101, 539121: 3958, 
            539695: 4598, 540175: 5539, 541167: 4334, 541282: 3486, 
            541717: 108, 542087: 5380, 542225: 2985, 542659: 100, 
            543286: 4155, 543895: 5191, 544011: 4936, 544765: 4797, 
            544825: 5583, 545054: 4679, 545343: 2025, 546231: 3726, 
            546325: 2573, 547491: 4117, 548359: 3053, 550671: 5094, 
            551614: 3817, 552575: 2801, 552805: 4382, 555458: 2764, 
            555611: 5443, 555814: 3678, 555841: 2112, 557566: 4326, 
            557583: 4174, 558467: 4612, 559265: 4165, 559682: 70, 
            559773: 2578, 561290: 3599, 562438: 1950, 563615: 5006, 
            563914: 4250, 564775: 5546, 564949: 5225, 564995: 2048, 
            567853: 3046, 568178: 2544, 569023: 2089, 570515: 5117, 
            570741: 4545, 571795: 3960, 572242: 3724, 572663: 5409, 
            572907: 2939, 573562: 4115, 573965: 4336, 574678: 3919, 
            575795: 4581, 576583: 275, 577239: 4469, 578289: 4787, 
            578347: 5374, 579945: 3487, 580601: 3117, 581405: 2784, 
            581529: 4928, 581647: 2176, 581825: 2693, 582335: 4769, 
            582958: 4348, 583015: 1988, 583219: 5016, 584545: 4393, 
            584647: 91, 585249: 3897, 585599: 5385, 587301: 3748, 
            588115: 4737, 588965: 4908, 590359: 5127, 591015: 3818, 
            593021: 3164, 593929: 5415, 594035: 4948, 594146: 3642, 
            594473: 246, 595441: 5167, 595515: 3679, 596183: 223, 
            596733: 1976, 598299: 4358, 600117: 3521, 600281: 107, 
            600457: 5051, 600691: 5335, 601315: 4187, 602485: 4978, 
            602547: 3943, 602823: 4891, 603725: 5538, 603911: 5197, 
            604299: 2015, 604877: 4817, 605098: 3735, 607202: 2852, 
            609501: 4729, 609725: 212, 610203: 2554, 612157: 2793, 
            613118: 3895, 614422: 4504, 615043: 5256, 615505: 4553, 
            616975: 5590, 618171: 4759, 618233: 5366, 620194: 4717, 
            620289: 177, 620517: 1923, 620806: 3935, 620977: 5442, 
            621970: 3379, 622895: 3750, 623162: 4320, 623181: 4159, 
            623441: 4988, 624169: 1992, 625611: 1803, 625807: 2959, 
            628694: 3519, 630539: 2079, 631465: 4813, 633919: 3163, 
            634114: 1863, 634933: 257, 636585: 3643, 637143: 3954, 
            637887: 1968, 638319: 4142, 639065: 3945, 639331: 4601, 
            639561: 4330, 640211: 2154, 640871: 5329, 644397: 4883, 
            644725: 5530, 645337: 4800, 645909: 4298, 647185: 3536, 
            648907: 5340, 649078: 4533, 649165: 5155, 650275: 2692, 
            651605: 80, 651695: 4692, 651775: 2899, 651833: 5011, 
            653315: 4378, 653429: 2053, 653457: 4081, 654493: 3052, 
            655402: 1801, 656183: 2170, 656903: 99, 657662: 4134, 
            658255: 4903, 659525: 5582, 659813: 5122, 661227: 3705, 
            662966: 4709, 663803: 5414, 664411: 3111, 665482: 4290, 
            669185: 1931, 670719: 3506, 671099: 3035, 675393: 4684, 
            676286: 3720, 677005: 4144, 677846: 4111, 680485: 4577, 
            680846: 4459, 681207: 4509, 682486: 3458, 683501: 5373, 
            683675: 5545, 684574: 4079, 685055: 4300, 685069: 5321, 
            687115: 3967, 687242: 4672, 687401: 5251, 689210: 1674, 
            689843: 4772, 692461: 4396, 692714: 3703, 693519: 1917, 
            693842: 2753, 693935: 5147, 694083: 2664, 695045: 4733, 
            696725: 2800, 696787: 4983, 700553: 2891, 700843: 2105, 
            701437: 2162, 702559: 2057, 702658: 3504, 704099: 267, 
            705686: 1911, 705755: 4593, 708883: 5379, 709142: 1738, 
            709423: 2144, 709631: 2117, 710645: 2872, 712101: 3939, 
            712327: 2882, 712385: 2041, 714425: 2572, 715737: 4253, 
            719095: 4942, 719345: 5110, 720575: 5529, 720797: 5161, 
            721149: 3528, 722361: 4567, 724101: 4036, 724594: 3891, 
            725249: 3051, 726869: 5036, 727415: 4549, 729147: 2862, 
            729399: 3922, 729554: 3422, 730303: 3025, 730639: 5365, 
            730825: 5537, 731235: 3459, 733381: 2169, 734635: 4517, 
            734638: 4664, 735034: 4128, 737426: 4245, 737817: 4723, 
            737891: 2684, 742577: 3045, 743002: 3515, 743774: 4284, 
            744107: 4952, 744775: 200, 746697: 3861, 748867: 5408, 
            749177: 2097, 751502: 3914, 751709: 2977, 754354: 1903, 
            754377: 4138, 754851: 4464, 755573: 4597, 756613: 3162, 
            757393: 5328, 758582: 4034, 759115: 4255, 759655: 4971, 
            759795: 1739, 761349: 1959, 761453: 5190, 761515: 2033, 
            762671: 4796, 763347: 4294, 764405: 2949, 764855: 3530, 
            768009: 3738, 768955: 5102, 769119: 4874, 770185: 4688, 
            772179: 4539, 773605: 3924, 773927: 4381, 774566: 1797, 
            774706: 4497, 775489: 5235, 777925: 2898, 779433: 4752, 
            781665: 3423, 782254: 3859, 782391: 4353, 782971: 2890, 
            783959: 2161, 785213: 4831, 785519: 5334, 785806: 3597, 
            786335: 4177, 787175: 2691, 788785: 1982, 789061: 5005, 
            790855: 1927, 790993: 2047, 791282: 2654, 792281: 5378, 
            793117: 256, 796195: 4792, 796835: 4897, 798475: 2571, 
            798721: 5116, 800513: 2792, 803551: 2976, 804287: 3110, 
            804837: 1866, 806113: 4580, 809042: 4075, 809627: 5320, 
            811923: 3485, 812045: 2773, 812383: 5031, 813967: 2783, 
            814055: 4472, 814555: 3740, 814929: 4154, 815269: 4768, 
            816221: 1987, 817581: 4678, 817663: 5312, 818363: 4392, 
            818662: 3699, 823361: 4736, 824182: 4239, 824551: 4907, 
            827421: 3816, 828134: 4489, 828245: 2674, 828269: 98, 
            828971: 5207, 829226: 1858, 829939: 234, 830297: 245, 
            830414: 3500, 831575: 5581, 831649: 4947, 832117: 2969, 
            833187: 2763, 833721: 3677, 836349: 4325, 836969: 5407, 
            837199: 2153, 838409: 3161, 839523: 69, 839914: 3908, 
            841841: 4186, 841935: 3598, 843479: 4977, 843657: 1949, 
            843755: 4361, 845871: 4249, 850586: 3483, 851105: 4764, 
            852267: 2543, 853615: 1868, 854335: 4373, 858363: 3723, 
            858458: 4452, 859027: 2111, 860343: 4114, 861707: 4552, 
            862017: 3918, 862025: 2897, 866723: 5230, 866822: 3814, 
            868205: 4513, 870758: 3377, 872053: 2683, 872275: 5528, 
            873422: 3675, 874437: 4347, 876826: 4655, 877591: 4611, 
            877933: 5333, 878845: 4162, 884051: 4812, 884374: 3715, 
            885391: 97, 886414: 4106, 887777: 2168, 888925: 2799, 
            889778: 2841, 889865: 4572, 891219: 3641, 893809: 5372, 
            894179: 2088, 894691: 2791, 896506: 4030, 898535: 3957, 
            898909: 5250, 900358: 1894, 901945: 4333, 906059: 2563, 
            906685: 4935, 907647: 3734, 908831: 5154, 908905: 2024, 
            910385: 3725, 910803: 2851, 912247: 79, 912373: 4691, 
            912485: 4116, 914641: 4377, 916487: 5015, 917662: 4444, 
            917785: 5093, 918731: 90, 919677: 3894, 921475: 5536, 
            921557: 4902, 921633: 4503, 924482: 3855, 926497: 5202, 
            926782: 1852, 927707: 2143, 927979: 3100, 929305: 4173, 
            930291: 4716, 931209: 3934, 932955: 3378, 933658: 3639, 
            934743: 4319, 935693: 2152, 936859: 1930, 943041: 3518, 
            947546: 3886, 947807: 2889, 949003: 2160, 950521: 4816, 
            951142: 4313, 951171: 1862, 951235: 4544, 952679: 4576, 
            954845: 2938, 955451: 5364, 959077: 2975, 960089: 2110, 
            961961: 3966, 962065: 4468, 963815: 4786, 964894: 1672, 
            966329: 5311, 966575: 2570, 969215: 4927, 971509: 5146, 
            971618: 2533, 973063: 4732, 973617: 4532, 975415: 3896, 
            978835: 3747, 979693: 4987, 980837: 1991, 983103: 1800, 
            983411: 2958, 985025: 2798, 986493: 4133, 988057: 4592, 
            988418: 2643, 989417: 5171, 990437: 5327, 990698: 4100, 
            990847: 2078, 992525: 2690, 994449: 4708, 994555: 1975, 
            994903: 2871, 997165: 4357, 997339: 2040, 997694: 1884, 
            998223: 4289, 998963: 5371, 1000195: 3520, 1004245: 3942, 
            1004663: 3044, 1004705: 4890, 1005238: 3479, 1006733: 4941, 
            1007083: 5109, 1007165: 2014, 1012894: 1792, 1013173: 5406, 
            1014101: 3109, 1014429: 3719, 1015835: 4728, 1016738: 2742, 
            1016769: 4110, 1017005: 2553, 1018381: 4548, 1021269: 4458, 
            1023729: 3457, 1024309: 5010, 1024426: 3810, 1026817: 2052, 
            1026861: 4078, 1028489: 4516, 1030285: 4758, 1030863: 4671, 
            1032226: 3671, 1033815: 1673, 1034195: 1922, 1036849: 2142, 
            1037153: 3034, 1038635: 4158, 1039071: 3702, 1040763: 2752, 
            1042685: 1802, 1049191: 5224, 1053987: 3503, 1056757: 96, 
            1057978: 4070, 1058529: 1910, 1058743: 5319, 1059022: 3880, 
            1060975: 2689, 1061905: 3953, 1062761: 2974, 1063145: 1967, 
            1063517: 4970, 1063713: 1737, 1063865: 4141, 1065935: 4329, 
            1066121: 2032, 1067857: 5363, 1070167: 2948, 1070558: 3694, 
            1070797: 2562, 1072478: 3455, 1073995: 4882, 1076515: 4297, 
            1076537: 5101, 1078259: 4687, 1083047: 2790, 1083121: 2104, 
            1084039: 3108, 1085773: 89, 1085926: 3495, 1086891: 3890, 
            1088153: 2968, 1089095: 4080, 1094331: 3421, 1094951: 4982, 
            1095274: 4435, 1096381: 5126, 1099825: 5527, 1100869: 4176, 
            1101957: 4663, 1102045: 3704, 1102551: 4127, 1103414: 3635, 
            1104299: 1981, 1105819: 5166, 1106139: 4244, 1106959: 5326, 
            1107197: 1926, 1114366: 1735, 1114503: 3514, 1114673: 4791, 
            1115569: 4896, 1115661: 4283, 1117865: 3505, 1119371: 266, 
            1121549: 5196, 1121894: 1845, 1123343: 3099, 1125655: 4683, 
            1127253: 3913, 1131531: 1902, 1132058: 1786, 1132681: 2151, 
            1133407: 5229, 1135234: 4277, 1135345: 4508, 1136863: 2772, 
            1137873: 4033, 1139677: 4471, 1140377: 2682, 1146442: 3419, 
            1147619: 3024, 1155865: 1916, 1156805: 2663, 1157819: 2096, 
            1159171: 233, 1159543: 2673, 1161849: 1796, 1162059: 4496, 
            1162213: 255, 1169311: 4951, 1171001: 95, 1172354: 4025, 
            1173381: 3858, 1175675: 5526, 1178709: 3596, 1181257: 4360, 
            1182446: 4064, 1183301: 5318, 1186835: 3938, 1186923: 2653, 
            1187329: 4596, 1191547: 4763, 1192895: 4252, 1195061: 211, 
            1196069: 4372, 1196506: 3688, 1196569: 2159, 1198483: 4795, 
            1199266: 4093, 1201915: 3527, 1203935: 4566, 1206835: 4035, 
            1208938: 3850, 1209271: 5370, 1210547: 2103, 1211573: 5201, 
            1213511: 2051, 1213526: 4269, 1213563: 4074, 1213682: 2522, 
            1215245: 2861, 1215487: 4512, 1215665: 3921, 1216171: 2967, 
            1218725: 2569, 1225367: 5121, 1227993: 3698, 1229695: 4722, 
            1230383: 4161, 1234838: 3594, 1236273: 4238, 1239953: 5004, 
            1242201: 4488, 1242989: 2046, 1243839: 1857, 1244495: 3860, 
            1245621: 3499, 1245811: 4571, 1255133: 2141, 1255501: 5030, 
            1257295: 4137, 1257949: 3956, 1257962: 4232, 1258085: 4463, 
            1259871: 3907, 1262723: 4332, 1263661: 5310, 1266325: 188, 
            1266749: 3043, 1267474: 3451, 1268915: 1958, 1269359: 4934, 
            1272245: 4293, 1272467: 2023, 1274539: 2681, 1275879: 3482, 
            1277479: 2888, 1279091: 265, 1280015: 3737, 1281137: 4767, 
            1281865: 4873, 1281974: 3873, 1282633: 1986, 1284899: 5092, 
            1285999: 4391, 1286965: 4538, 1287687: 4451, 1292669: 5362, 
            1293853: 3107, 1294033: 2095, 1295723: 4906, 1299055: 4751, 
            1300233: 3813, 1301027: 4172, 1302775: 2568, 1303985: 4352, 
            1306137: 3376, 1306877: 4946, 1310133: 3674, 1310278: 4019, 
            1314542: 3474, 1315239: 4654, 1316978: 1731, 1322893: 2881, 
            1325467: 4976, 1326561: 3714, 1329621: 4105, 1331729: 4543, 
            1334667: 2840, 1336783: 2937, 1338623: 5160, 1339634: 3805, 
            1340003: 5325, 1341395: 1865, 1344718: 4224, 1344759: 4029, 
            1346891: 4467, 1349341: 4785, 1349834: 3666, 1350537: 1893, 
            1351166: 3844, 1353205: 3484, 1354111: 3042, 1354886: 3415, 
            1356277: 3023, 1356901: 4926, 1358215: 4153, 1362635: 4677, 
            1365581: 2789, 1368334: 3374, 1370369: 3746, 1370386: 1779, 
            1372019: 5223, 1376493: 4443, 1379035: 3815, 1381913: 2087, 
            1386723: 3854, 1388645: 2762, 1389223: 4811, 1389535: 3676, 
            1390173: 1851, 1392377: 1974, 1393915: 4324, 1396031: 4356, 
            1399205: 68, 1400273: 2561, 1400487: 3638, 1403207: 3033, 
            1403225: 2688, 1405943: 3941, 1406095: 1948, 1406587: 4889, 
            1409785: 4248, 1410031: 2013, 1412327: 5309, 1414127: 5189, 
            1414562: 58, 1416389: 3098, 1420445: 2542, 1421319: 3885, 
            1422169: 4727, 1423807: 2552, 1426713: 4312, 1428163: 2150, 
            1430605: 3722, 1431382: 4057, 1432417: 5317, 1433531: 78, 
            1433729: 3106, 1433905: 4113, 1436695: 3917, 1437293: 4376, 
            1442399: 4757, 1442926: 3630, 1446071: 5165, 1447341: 1671, 
            1447873: 1921, 1448161: 4901, 1448402: 2632, 1454089: 4157, 
            1457395: 4346, 1457427: 2532, 1459354: 3590, 1459759: 199, 
            1465399: 2102, 1466641: 5195, 1468987: 2045, 1469194: 3468, 
            1472207: 222, 1482627: 2642, 1483339: 5115, 1485365: 3640, 
            1486047: 4099, 1486667: 3952, 1488403: 1966, 1489411: 4140, 
            1492309: 4328, 1496541: 1883, 1497067: 4575, 1497238: 3799, 
            1503593: 4881, 1507121: 4296, 1507857: 3478, 1508638: 3660, 
            1511653: 2782, 1512118: 1837, 1512745: 3733, 1514071: 3097, 
            1515839: 1985, 1516262: 1669, 1518005: 2850, 1519341: 1791, 
            1519817: 2957, 1524733: 2887, 1525107: 2741, 1526657: 2149, 
            1529099: 4731, 1531309: 2077, 1532795: 3893, 1533433: 5222, 
            1536055: 4502, 1536639: 3809, 1542863: 2680, 1544491: 2086, 
            1548339: 3670, 1550485: 4715, 1552015: 3933, 1552661: 4591, 
            1554925: 2567, 1557905: 4318, 1563419: 2870, 1565011: 2560, 
            1566461: 2094, 1567247: 2039, 1571735: 3517, 1575917: 4682, 
            1582009: 4940, 1582559: 2140, 1583023: 5009, 1585285: 1861, 
            1586126: 4012, 1586899: 88, 1586967: 4069, 1588533: 3879, 
            1589483: 4507, 1600313: 4547, 1602403: 5120, 1604986: 4215, 
            1605837: 3693, 1608717: 3454, 1612682: 3624, 1616197: 3041, 
            1616402: 2731, 1617122: 3370, 1618211: 1915, 1619527: 2662, 
            1622695: 4531, 1628889: 3494, 1629887: 5361, 1635622: 3837, 
            1638505: 1799, 1639187: 5194, 1641809: 4810, 1642911: 4434, 
            1644155: 4132, 1655121: 3634, 1657415: 4707, 1657466: 3446, 
            1661569: 3937, 1663705: 4288, 1670053: 4251, 1671241: 4969, 
            1671549: 1734, 1675333: 2031, 1681691: 2947, 1682681: 3526, 
            1682841: 1844, 1685509: 4565, 1687829: 5153, 1689569: 2886, 
            1690715: 3718, 1691701: 2139, 1692197: 4981, 1694173: 77, 
            1694407: 4686, 1694615: 4109, 1698087: 1785, 1698619: 2956, 
            1701343: 2860, 1701931: 3920, 1702115: 4457, 1702851: 4276, 
            1706215: 3456, 1709659: 5308, 1711435: 4077, 1711463: 2076, 
            1718105: 4670, 1719663: 3418, 1721573: 4721, 1722202: 1726, 
            1723025: 176, 1727878: 1771, 1729937: 2880, 1731785: 3701, 
            1734605: 2751, 1735327: 1980, 1739881: 1925, 1742293: 2788, 
            1750507: 5159, 1751629: 4790, 1753037: 4895, 1756645: 3502, 
            1758531: 4024, 1760213: 4136, 1761319: 4462, 1764215: 1909, 
            1769261: 3032, 1771774: 3410, 1772855: 1736, 1773593: 244, 
            1773669: 4063, 1776481: 1957, 1778498: 2511, 1781143: 4292, 
            1786499: 2771, 1790921: 3040, 1791946: 1665, 1792021: 3736, 
            1794611: 4872, 1794759: 3687, 1798899: 4092, 1801751: 4537, 
            1804231: 5145, 1804786: 1828, 1806091: 5316, 1807117: 3096, 
            1811485: 3889, 1812446: 3792, 1813407: 3849, 1818677: 4750, 
            1820289: 4268, 1820523: 2521, 1822139: 264, 1823885: 3420, 
            1825579: 4351, 1826246: 3653, 1834963: 4590, 1836595: 4662, 
            1837585: 4126, 1843565: 4243, 1847042: 46, 1847677: 254, 
            1849243: 5188, 1852201: 2038, 1852257: 3593, 1852462: 3440, 
            1856261: 2966, 1857505: 3513, 1859435: 4282, 1869647: 2085, 
            1870297: 5108, 1872431: 4762, 1877953: 1864, 1878755: 3912, 
            1879537: 4371, 1885885: 1901, 1886943: 4231, 1891279: 3031, 
            1894487: 2559, 1896455: 4032, 1901211: 3450, 1901501: 4152, 
            1907689: 4676, 1908386: 3585, 1910051: 4511, 1916291: 5003, 
            1920983: 87, 1922961: 3872, 1924814: 1720, 1929254: 4049, 
            1930649: 2787, 1933459: 2879, 1936415: 1795, 1936765: 4495, 
            1939751: 5114, 1944103: 2761, 1945349: 2679, 1951481: 4323, 
            1952194: 3617, 1955635: 3857, 1956449: 5158, 1957703: 4570, 
            1958887: 67, 1964515: 3595, 1965417: 4018, 1968533: 1947, 
            1971813: 3473, 1973699: 4247, 1975103: 2093, 1975467: 1730, 
            1976777: 2781, 1978205: 2652, 1979939: 2030, 1980218: 3404, 
            1982251: 232, 1984279: 2965, 1987453: 2946, 1988623: 2541, 
            1994707: 4933, 1999283: 5100, 1999591: 2022, 1999898: 1818, 
            2002481: 3095, 2002847: 3721, 2007467: 4112, 2009451: 3804, 
            2011373: 3916, 2017077: 4223, 2019127: 2138, 2019719: 4945, 
            2022605: 4073, 2024751: 3665, 2026749: 3843, 2032329: 3414, 
            2040353: 4345, 2044471: 4171, 2046655: 3697, 2048449: 4975, 
            2050841: 1979, 2052501: 3373, 2055579: 1778, 2056223: 221, 
            2060455: 4237, 2062306: 3829, 2066801: 5187, 2070107: 4789, 
            2070335: 4487, 2071771: 2075, 2073065: 1856, 2076035: 3498, 
            2079511: 2678, 2092717: 4542, 2099785: 3906, 2100659: 2936, 
            2111317: 253, 2114698: 3365, 2116543: 4466, 2117843: 3732, 
            2120393: 4784, 2121843: 57, 2125207: 2849, 2126465: 3481, 
            2132273: 4925, 2132902: 3579, 2137822: 4004, 2141737: 5002, 
            2145913: 3892, 2146145: 4450, 2146981: 2044, 2147073: 4056, 
            2150477: 4501, 2153437: 2672, 2155657: 5307, 2164389: 3629, 
            2167055: 3812, 2167957: 5113, 2170679: 4714, 2172603: 2631, 
            2172821: 3932, 2176895: 3375, 2181067: 4317, 2183555: 3673, 
            2188021: 1973, 2189031: 3589, 2192065: 4653, 2193763: 4355, 
            2200429: 3516, 2203791: 3467, 2204534: 1762, 2207161: 5152, 
            2209339: 2780, 2210351: 4888, 2210935: 3713, 2212873: 4761, 
            2215457: 76, 2215763: 2012, 2216035: 4104, 2219399: 1860, 
            2221271: 4370, 2224445: 2839, 2234837: 4726, 2237411: 263, 
            2238067: 4900, 2241265: 4028, 2242454: 3433, 2245857: 3798, 
            2250895: 1892, 2257333: 3030, 2262957: 3659, 2266627: 4756, 
            2268177: 1836, 2271773: 4530, 2274393: 1668, 2275229: 1920, 
            2284997: 4156, 2285258: 3784, 2289443: 4974, 2293907: 1798, 
            2294155: 4442, 2301817: 4131, 2302658: 2621, 2304323: 5306, 
            2311205: 3853, 2313649: 4569, 2316955: 1850, 2320381: 4706, 
            2329187: 4287, 2330038: 1713, 2334145: 3637, 2336191: 3951, 
            2338919: 1965, 2340503: 2878, 2343314: 1660, 2345057: 4327, 
            2357381: 2084, 2359379: 5144, 2362789: 4880, 2363153: 2021, 
            2363486: 3359, 2367001: 3717, 2368333: 2964, 2368865: 3884, 
            2372461: 4108, 2377855: 4311, 2379189: 4011, 2382961: 4456, 
            2386241: 5091, 2388701: 2558, 2396009: 4076, 2397106: 3397, 
            2399567: 3022, 2405347: 4669, 2407479: 4214, 2412235: 1670, 
            2416193: 2869, 2419023: 3623, 2422109: 86, 2424499: 3700, 
            2424603: 2730, 2425683: 3369, 2428447: 2750, 2429045: 2531, 
            2442862: 1752, 2444923: 4939, 2445773: 5107, 2453433: 3836, 
            2459303: 3501, 2461462: 3609, 2466827: 5151, 2469901: 1908, 
            2471045: 2641, 2473211: 4541, 2476441: 4681, 2476745: 4098, 
            2481997: 187, 2482597: 2935, 2486199: 3445, 2494235: 1882, 
            2497759: 4506, 2501369: 3029, 2501917: 5186, 2505919: 4783, 
            2513095: 3477, 2519959: 2083, 2532235: 1790, 2536079: 3888, 
            2541845: 2740, 2542903: 1914, 2544971: 2661, 2551594: 3995, 
            2553439: 2557, 2561065: 3808, 2571233: 4661, 2572619: 4125, 
            2580565: 3669, 2580991: 4242, 2581934: 3572, 2582827: 4968, 
            2583303: 1725, 2585843: 1972, 2589151: 85, 2591817: 1770, 
            2592629: 2955, 2598977: 243, 2600507: 3512, 2603209: 4281, 
            2611037: 3936, 2612233: 2074, 2614447: 5099, 2618629: 2011, 
            2618998: 1654, 2624369: 2963, 2630257: 3911, 2631218: 2610, 
            2636953: 5143, 2640239: 1900, 2641171: 4725, 2644213: 2551, 
            2644945: 4068, 2647555: 3878, 2648657: 4564, 2655037: 4031, 
            2657661: 3409, 2667747: 2510, 2673539: 2859, 2674463: 2779, 
            2676395: 3692, 2678741: 4755, 2681195: 3453, 2681869: 1978, 
            2687919: 1664, 2688907: 1919, 2700451: 2868, 2705329: 4720, 
            2707063: 2037, 2707179: 1827, 2709239: 4894, 2710981: 1794, 
            2711471: 4494, 2714815: 3493, 2718669: 3791, 2732561: 4938, 
            2733511: 5106, 2737889: 3856, 2738185: 4433, 2739369: 3652, 
            2750321: 2677, 2758535: 3633, 2760953: 2770, 2764177: 1964, 
            2766049: 4135, 2767787: 4461, 2769487: 2651, 2770563: 45, 
            2771431: 2954, 2778693: 3439, 2785915: 1733, 2791613: 1956, 
            2792387: 2073, 2798939: 4291, 2804735: 1843, 2816033: 2671, 
            2820103: 4871, 2827442: 2500, 2830145: 1784, 2831323: 4536, 
            2831647: 4072, 2838085: 4275, 2857921: 4749, 2861062: 3352, 
            2862579: 3584, 2865317: 3696, 2866105: 3417, 2868767: 4350, 
            2884637: 4236, 2886689: 4967, 2887221: 1719, 2893757: 2029, 
            2893881: 4048, 2898469: 4486, 2902291: 1855, 2904739: 2945, 
            2906449: 3497, 2915674: 3775, 2922029: 5098, 2926703: 4680, 
            2928291: 3616, 2930885: 4023, 2937874: 1705, 2939699: 3905, 
            2951069: 210, 2951897: 4505, 2956115: 4062, 2970327: 3403, 
            2977051: 3480, 2986159: 5150, 2988073: 4151, 2991265: 3686, 
            2997383: 75, 2997797: 4675, 2998165: 4091, 2999847: 1817, 
            3004603: 4449, 3005249: 1913, 3007693: 252, 3022345: 3848, 
            3022438: 3389, 3025541: 3021, 3027973: 4893, 3033815: 4267, 
            3033877: 3811, 3034205: 2520, 3047653: 2556, 3055019: 2760, 
            3056977: 3672, 3066613: 4322, 3068891: 4652, 3078251: 66, 
            3082729: 4932, 3085771: 2769, 3087095: 3592, 3090277: 84, 
            3093409: 1946, 3093459: 3828, 3095309: 3712, 3101527: 4246, 
            3102449: 4103, 3114223: 2838, 3120469: 5090, 3124979: 2540, 
            3130231: 4563, 3137771: 4027, 3140486: 1696, 3144905: 4230, 
            3147331: 2670, 3151253: 1891, 3154591: 2877, 3159637: 2858, 
            3160729: 3915, 3168685: 3449, 3170366: 1647, 3172047: 3364, 
            3192101: 5142, 3197207: 4719, 3199353: 3578, 3204935: 3871, 
            3206269: 4344, 3206733: 4003, 3211817: 4441, 3230882: 2489, 
            3234199: 3020, 3235687: 3852, 3243737: 1849, 3246473: 2934, 
            3255482: 3564, 3267803: 3636, 3268967: 2867, 3271021: 4460, 
            3275695: 4017, 3276971: 2036, 3286355: 3472, 3292445: 1729, 
            3295331: 4924, 3299179: 1955, 3306801: 1761, 3307837: 2953, 
            3308987: 5105, 3316411: 3883, 3328039: 3731, 3328997: 4310, 
            3332849: 2072, 3339611: 2848, 3346109: 4535, 3349085: 3803, 
            3361795: 4222, 3363681: 3432, 3372149: 2778, 3374585: 3664, 
            3377129: 175, 3377543: 4748, 3377915: 3842, 3379321: 4500, 
            3381487: 1971, 3387215: 3413, 3390361: 4349, 3400663: 2530, 
            3411067: 4713, 3414433: 3931, 3415997: 4887, 3420835: 3372, 
            3424361: 83, 3425965: 1777, 3427391: 4316, 3427887: 3783, 
            3445403: 4931, 3453839: 2020, 3453987: 2620, 3457817: 2550, 
            3459463: 2640, 3467443: 4097, 3479998: 3555, 3487583: 5089, 
            3487627: 1859, 3491929: 1881, 3494413: 4966, 3495057: 1712, 
            3502969: 2028, 3514971: 1659, 3516263: 220, 3518333: 3476, 
            3531359: 4150, 3536405: 56, 3537193: 5097, 3542851: 4674, 
            3545129: 1789, 3545229: 3358, 3558583: 2739, 3569929: 4529, 
            3578455: 4055, 3585491: 3807, 3595659: 3396, 3604711: 198, 
            3607315: 3628, 3607426: 3344, 3610477: 2759, 3612791: 3668, 
            3614693: 1963, 3617141: 4130, 3621005: 2630, 3624179: 4321, 
            3628411: 231, 3637933: 65, 3646313: 4705, 3648385: 3588, 
            3651583: 4879, 3655847: 1945, 3660151: 4286, 3662497: 4782, 
            3664293: 1751, 3665441: 2952, 3672985: 3466, 3683017: 4923, 
            3692193: 3608, 3693157: 251, 3702923: 4067, 3706577: 3877, 
            3719573: 3716, 3728153: 4107, 3735407: 2768, 3743095: 3797, 
            3744653: 4455, 3746953: 3691, 3748322: 34, 3753673: 3452, 
            3765157: 2876, 3771595: 3658, 3779309: 74, 3779831: 4668, 
            3780295: 1835, 3789227: 4343, 3790655: 1667, 3800741: 3492, 
            3809927: 2669, 3816131: 2749, 3817879: 4886, 3827227: 2010, 
            3827391: 3994, 3833459: 4432, 3856214: 3335, 3860173: 3019, 
            3861949: 3632, 3864619: 2549, 3872901: 3571, 3881273: 1907, 
            3900281: 1732, 3915083: 4754, 3926629: 1842, 3928497: 1653, 
            3929941: 1912, 3933137: 2660, 3946813: 2847, 3946827: 2609, 
            3962203: 1783, 3965315: 4010, 3973319: 4274, 3985267: 3887, 
            3993743: 4499, 3997418: 1639, 4012465: 4213, 4012547: 3416, 
            4024823: 5141, 4031261: 4712, 4031705: 3622, 4035239: 3930, 
            4039951: 73, 4040509: 4660, 4041005: 2729, 4042687: 4124, 
            4042805: 3368, 4050553: 4315, 4055843: 4241, 4081181: 4878, 
            4086511: 3511, 4089055: 3835, 4090757: 4280, 4093379: 4562, 
            4103239: 4022, 4121741: 209, 4131833: 242, 4133261: 3910, 
            4138561: 4061, 4143665: 3444, 4148947: 1899, 4153546: 1686, 
            4170751: 4930, 4172201: 2875, 4180963: 2019, 4187771: 3685, 
            4197431: 4090, 4219007: 4528, 4221811: 5088, 4231283: 3847, 
            4241163: 2499, 4247341: 4266, 4247887: 2519, 4260113: 1793, 
            4260883: 4493, 4273102: 1630, 4274803: 4129, 4277489: 3018, 
            4291593: 3351, 4302397: 2777, 4305505: 1724, 4309279: 4704, 
            4314311: 1954, 4319695: 1769, 4321933: 3591, 4325633: 4285, 
            4352051: 2650, 4358341: 4870, 4373511: 3774, 4375681: 4534, 
            4392287: 219, 4395859: 2659, 4402867: 4229, 4405999: 2866, 
            4406811: 1704, 4416787: 2027, 4425499: 4454, 4429435: 3408, 
            4433549: 2944, 4436159: 3448, 4446245: 2509, 4449731: 4071, 
            4458389: 4922, 4459939: 5096, 4467073: 4667, 4479865: 1663, 
            4486909: 3870, 4502641: 3695, 4509973: 2748, 4511965: 1826, 
            4531115: 3790, 4533001: 4235, 4533657: 3388, 4554737: 4485, 
            4560743: 1854, 4565615: 3651, 4567277: 3496, 4574953: 1970, 
            4585973: 4016, 4586959: 1906, 4600897: 3471, 4602578: 2478, 
            4609423: 1728, 4617605: 44, 4617931: 2857, 4619527: 3904, 
            4621643: 4885, 4631155: 3438, 4632959: 2009, 4672841: 4718, 
            4678223: 2548, 4688719: 3802, 4706513: 4221, 4709861: 2767, 
            4710729: 1695, 4721393: 241, 4721519: 4448, 4724419: 3663, 
            4729081: 3841, 4739311: 2943, 4742101: 3412, 4755549: 1646, 
            4757297: 64, 4767521: 2776, 4770965: 3583, 4775147: 4659, 
            4777721: 4123, 4780723: 1944, 4789169: 3371, 4793269: 4240, 
            4796351: 1776, 4803821: 2668, 4812035: 1718, 4821877: 72, 
            4822543: 4651, 4823135: 4047, 4829513: 2539, 4834531: 4279, 
            4846323: 2488, 4864057: 3711, 4871087: 4869, 4875277: 4102, 
            4880485: 3615, 4883223: 3563, 4884763: 3909, 4890467: 1962, 
            4893779: 2837, 4903301: 1898, 4930783: 4026, 4936409: 4747, 
            4940377: 4877, 4950545: 3402, 4950967: 55, 4951969: 1890, 
            4955143: 4342, 4999745: 1816, 5009837: 4054, 5034679: 197, 
            5035589: 4492, 5047141: 4440, 5050241: 3627, 5069407: 2629, 
            5084651: 3851, 5097301: 1848, 5100154: 1620, 5107739: 3587, 
            5135119: 2667, 5142179: 3465, 5143333: 2649, 5155765: 3827, 
            5161217: 2846, 5178013: 4673, 5211503: 3882, 5219997: 3554, 
            5222587: 4498, 5231281: 4309, 5240333: 3796, 5258773: 2865, 
            5271649: 2018, 5276851: 2758, 5280233: 3657, 5286745: 3363, 
            5292413: 1834, 5296877: 4314, 5306917: 1666, 5316979: 63, 
            5321303: 2658, 5323153: 5087, 5332255: 3577, 5343161: 71, 
            5343899: 2529, 5344555: 4002, 5357183: 4234, 5382871: 4484, 
            5389969: 1853, 5397691: 2538, 5411139: 3343, 5436299: 2639, 
            5448839: 4096, 5459441: 3903, 5487317: 1880, 5511335: 1760, 
            5517163: 4527, 5528809: 3475, 5538101: 2933, 5551441: 4009, 
            5570917: 1788, 5579977: 4447, 5590127: 2856, 5592059: 2738, 
            5606135: 3431, 5617451: 4212, 5621447: 4921, 5622483: 33, 
            5634343: 3806, 5635211: 2017, 5644387: 3621, 5651522: 22, 
            5656597: 2942, 5657407: 2728, 5659927: 3367, 5677243: 3667, 
            5690267: 5086, 5699369: 4650, 5713145: 3782, 5724677: 3834, 
            5748431: 3710, 5756645: 2619, 5761691: 4101, 5768419: 230, 
            5783557: 2836, 5784321: 3334, 5787191: 4453, 5801131: 3443, 
            5818879: 4066, 5824621: 3876, 5825095: 1711, 5827289: 2864, 
            5837009: 1953, 5841557: 2008, 5852327: 1889, 5858285: 1658, 
            5888069: 3690, 5891843: 4711, 5896579: 4868, 5897657: 2747, 
            5898629: 2547, 5908715: 3357, 5920039: 2932, 5964803: 4439, 
            5972593: 3491, 5975653: 4746, 5992765: 3395, 5996127: 1638, 
            5998331: 1905, 6009133: 2766, 6024007: 4431, 6024083: 1847, 
            6027707: 1723, 6047573: 1768, 6068777: 3631, 6107155: 1750, 
            6129013: 186, 6153655: 3607, 6159049: 3881, 6166241: 1961, 
            6170417: 1841, 6182423: 4308, 6201209: 3407, 6224743: 2508, 
            6226319: 1782, 6229171: 4876, 6230319: 1685, 6243787: 4273, 
            6244423: 2007, 6247789: 4122, 6268121: 2941, 6271811: 1662, 
            6298177: 4703, 6305431: 2546, 6315517: 2528, 6316751: 1825, 
            6322079: 4278, 6343561: 3789, 6378985: 3993, 6387767: 2757, 
            6391861: 3650, 6409653: 1629, 6412009: 1897, 6424717: 2638, 
            6439537: 4095, 6447947: 4021, 6454835: 3570, 6464647: 43, 
            6468037: 1943, 6483617: 3437, 6485011: 1879, 6503453: 4060, 
            6528799: 4666, 6534047: 2537, 6547495: 1652, 6578045: 2608, 
            6580783: 3684, 6583811: 1787, 6585001: 4491, 6591499: 229, 
            6595963: 4089, 6608797: 2737, 6649159: 3846, 6658769: 2765, 
            6674393: 4265, 6675251: 2518, 6679351: 3582, 6704017: 1904, 
            6709469: 2657, 6725897: 240, 6736849: 1717, 6752389: 4046, 
            6791609: 2666, 6832679: 3614, 6876857: 4065, 6883643: 3875, 
            6903867: 2477, 6918791: 4228, 6930763: 3401, 6958627: 3689, 
            6971107: 3447, 6979061: 4658, 6982823: 2845, 6999643: 1815, 
            7005547: 4233, 7039139: 4483, 7048421: 208, 7050857: 3869, 
            7058519: 3490, 7065853: 2931, 7068605: 2498, 7119281: 4430, 
            7132231: 4710, 7139269: 3902, 7152655: 3350, 7166363: 1896, 
            7172191: 2656, 7206529: 4015, 7218071: 3826, 7229981: 3470, 
            7243379: 1727, 7289185: 3773, 7292311: 1840, 7296893: 4446, 
            7344685: 1703, 7358377: 1781, 7359707: 1952, 7367987: 3801, 
            7379021: 4272, 7395949: 4220, 7401443: 3362, 7424087: 3662, 
            7431413: 3840, 7434817: 4867, 7451873: 3411, 7453021: 2006, 
            7464397: 4526, 7465157: 3576, 7482377: 4001, 7517179: 2648, 
            7525837: 2545, 7534519: 2855, 7537123: 1775, 7556095: 3387, 
            7563113: 2835, 7620301: 4020, 7624109: 4702, 7650231: 1619, 
            7653043: 1888, 7685899: 4059, 7715869: 1759, 7777289: 3683, 
            7780091: 54, 7795229: 4088, 7800127: 4438, 7829729: 2930, 
            7848589: 3430, 7851215: 1694, 7858097: 3845, 7867273: 1951, 
            7872601: 4053, 7877647: 1846, 7887919: 4264, 7888933: 2517, 
            7903283: 4665, 7925915: 1645, 7936093: 3626, 7947563: 4866, 
            7966211: 2628, 7979183: 2746, 7998403: 3781, 8026447: 3586, 
            8054141: 2756, 8059303: 2618, 8077205: 2487, 8080567: 3464, 
            8084707: 4307, 8115389: 62, 8138705: 3562, 8155133: 1710, 
            8155351: 1942, 8176753: 4227, 8201599: 1657, 8234809: 3795, 
            8238581: 2536, 8258753: 239, 8272201: 3356, 8297509: 3656, 
            8316649: 1833, 8329847: 4649, 8332831: 3868, 8339441: 174, 
            8389871: 3394, 8401553: 2637, 8420933: 4094, 8448337: 4657, 
            8452891: 2834, 8477283: 21, 8480399: 1878, 8516807: 4014, 
            8544523: 3469, 8550017: 1749, 8553401: 1887, 8560357: 185, 
            8609599: 196, 8615117: 3606, 8642273: 2736, 8675071: 61, 
            8699995: 3553, 8707621: 3800, 8717789: 1941, 8723693: 4008, 
            8740667: 4219, 8773921: 3661, 8782579: 3839, 8804429: 207, 
            8806759: 2535, 8827423: 4211, 8869751: 3620, 8890211: 2727, 
            8894171: 3366, 8907509: 1774, 8909119: 4490, 8930579: 3992, 
            8992813: 2854, 8995921: 3833, 9001687: 3874, 9018565: 3342, 
            9035849: 4306, 9036769: 3569, 9099743: 2647, 9116063: 3442, 
            9166493: 1651, 9194653: 53, 9209263: 2607, 9230371: 2527, 
            9303983: 4052, 9309829: 4429, 9370805: 32, 9379019: 3625, 
            9389971: 228, 9411631: 2844, 9414613: 2627, 9472111: 1722, 
            9478093: 1877, 9485801: 2655, 9503329: 1767, 9523541: 4482, 
            9536099: 1839, 9549761: 3463, 9613007: 4701, 9622493: 1780, 
            9640535: 3333, 9649489: 4271, 9659011: 2735, 9732047: 3794, 
            9744757: 3406, 9781739: 2507, 9806147: 3655, 9828767: 1832, 
            9855703: 1661, 9872267: 4445, 9896047: 2497, 9926323: 1824, 
            9965009: 2853, 9968453: 3788, 9993545: 1637, 10013717: 3349, 
            10044353: 3649, 10050791: 4058, 10060709: 2745, 10083499: 4648, 
            10158731: 42, 10170301: 3682, 10188541: 3436, 10193761: 4087, 
            10204859: 3772, 10232447: 218, 10275973: 2755, 10282559: 1702, 
            10309819: 4007, 10314971: 4263, 10316297: 2516, 10354117: 60, 
            10383865: 1684, 10405103: 1940, 10432409: 4210, 10482433: 3619, 
            10496123: 3581, 10506613: 2726, 10511293: 2534, 10553113: 4437, 
            10578533: 3386, 10586477: 1716, 10610897: 4045, 10631543: 3832, 
            10652251: 4656, 10657993: 1838, 10682755: 1628, 10692677: 4226, 
            10737067: 3613, 10754551: 195, 10773529: 3441, 10784723: 4270, 
            10891199: 3400, 10896779: 3867, 10938133: 1895, 10991701: 1693, 
            10999439: 1814, 11096281: 1644, 11137363: 4013, 11173607: 2526, 
            11194313: 1721, 11231207: 1766, 11233237: 2843, 11308087: 2486, 
            11342683: 3825, 11366807: 2636, 11386889: 2754, 11393027: 4086, 
            11394187: 3561, 11430103: 4218, 11473481: 59, 11473589: 2646, 
            11484911: 3838, 11506445: 2476, 11516531: 3405, 11528497: 4262, 
            11529979: 227, 11560237: 2506, 11630839: 3361, 11647649: 173, 
            11648281: 1773, 11692487: 217, 11730961: 3575, 11731109: 1823, 
            11758021: 4000, 11780899: 3787, 11870599: 3648, 11950639: 4225, 
            12005773: 41, 12007943: 4481, 12023777: 52, 12041003: 3435, 
            12124937: 1758, 12166747: 4051, 12178753: 3866, 12179993: 3552, 
            12264871: 2645, 12311417: 2626, 12333497: 3429, 12404509: 3580, 
            12447641: 2842, 12488149: 3462, 12511291: 1715, 12540151: 4044, 
            12568919: 3780, 12595651: 4428, 12625991: 3341, 12664619: 2617, 
            12689261: 3612, 12713977: 4647, 12726523: 3793, 12750385: 1618, 
            12774821: 4217, 12815209: 1709, 12823423: 3654, 12836077: 2744, 
            12853003: 1831, 12871417: 3399, 12888227: 1656, 12901781: 206, 
            12999173: 3355, 12999337: 1813, 13018667: 1772, 13055191: 1886, 
            13119127: 31, 13184083: 3393, 13306099: 4436, 13404989: 3824, 
            13435741: 1748, 13438339: 51, 13482071: 4006, 13496749: 3332, 
            13538041: 3605, 13590803: 4646, 13598129: 4050, 13642381: 4209, 
            13707797: 3618, 13739417: 2725, 13745537: 3360, 13759819: 2625, 
            13791559: 2833, 13863863: 3574, 13895843: 3999, 13902787: 3831, 
            13955549: 1885, 13957343: 2515, 13990963: 1636, 14033767: 3991, 
            14088461: 2525, 14128805: 20, 14200637: 3568, 14223761: 2743, 
            14329471: 1757, 14332061: 2635, 14365121: 1830, 14404489: 1650, 
            14466563: 1876, 14471699: 2606, 14537411: 1683, 14575951: 3428, 
            14638717: 184, 14686963: 1765, 14742701: 2734, 14854177: 3779, 
            14955857: 1627, 14967277: 2616, 15060079: 2524, 15068197: 4005, 
            15117233: 2505, 15145247: 1708, 15231541: 1655, 15247367: 4208, 
            15320479: 2634, 15340681: 1822, 15355819: 2724, 15362659: 3354, 
            15405791: 3786, 15464257: 1875, 15523091: 3647, 15538409: 3830, 
            15550931: 2496, 15581189: 3392, 15699857: 40, 15735841: 3348, 
            15745927: 3434, 15759439: 194, 15878603: 1747, 15881473: 4427, 
            15999503: 3604, 16036207: 3771, 16109023: 2475, 16158307: 1701, 
            16221281: 2644, 16267463: 50, 16360919: 1714, 16398659: 4043, 
            16414841: 1764, 16460893: 2832, 16585361: 3990, 16593649: 3611, 
            16623409: 3385, 16656623: 216, 16782571: 3567, 16831853: 3398, 
            16895731: 2504, 16976747: 4426, 16999133: 1812, 17023487: 1649, 
            17102917: 2605, 17145467: 1821, 17218237: 3785, 17272673: 1692, 
            17349337: 3646, 17389357: 1829, 17437013: 1643, 17529601: 3823, 
            17546899: 39, 17596127: 4261, 17598389: 2514, 17769851: 2485, 
            17850539: 1617, 17905151: 3560, 17974933: 2523, 18129667: 3573, 
            18171487: 3998, 18240449: 2831, 18285733: 183, 18327913: 4042, 
            18378373: 2495, 18457339: 1874, 18545843: 3610, 18588623: 2723, 
            18596903: 3347, 18738539: 1756, 18809653: 2733, 18812071: 2513, 
            18951881: 3770, 18999031: 1811, 19060859: 3427, 19096181: 1700, 
            19139989: 3551, 19424693: 3778, 19498411: 4216, 19572593: 2615, 
            19591907: 3822, 19645847: 3384, 19780327: 19, 19805323: 1707, 
            19840843: 3340, 19870597: 1763, 19918169: 172, 20089631: 3353, 
            20262569: 2633, 20309309: 3997, 20375401: 3391, 20413159: 1691, 
            20452727: 215, 20607379: 1642, 20615771: 30, 20755039: 1820, 
            20764327: 1746, 20843129: 2732, 20922427: 3603, 20943073: 1755, 
            21000733: 2484, 21001829: 2624, 21160633: 3559, 21209177: 3331, 
            21240983: 38, 21303313: 3426, 21688549: 3989, 21709951: 3777, 
            21875251: 2614, 21925711: 49, 21946439: 3566, 21985799: 1635, 
            22135361: 1706, 22186421: 4041, 22261483: 1648, 22365353: 2604, 
            22450231: 2623, 22453117: 2512, 22619987: 3550, 22772507: 3390, 
            22844503: 1682, 22998827: 1810, 23207189: 1745, 23272297: 4207, 
            23383889: 3602, 23437829: 205, 23448269: 3339, 23502061: 1626, 
            23716519: 3821, 24033257: 2494, 24240143: 3988, 24319027: 3346, 
            24364093: 29, 24528373: 3565, 24584953: 3996, 24783229: 3769, 
            24877283: 4206, 24880481: 171, 24971929: 1699, 24996571: 2603, 
            25054231: 193, 25065391: 3330, 25314179: 2474, 25352141: 1754, 
            25690723: 3383, 25788221: 2503, 25983217: 1634, 26169397: 48, 
            26280467: 3776, 26480567: 2613, 26694131: 1690, 26782109: 37, 
            26795437: 182, 26860699: 2493, 26948111: 1641, 26998049: 1681, 
            27180089: 3345, 27462497: 2483, 27566719: 2502, 27671597: 3558, 
            27698903: 3768, 27775163: 1625, 27909803: 1698, 27974183: 1819, 
            28050847: 1616, 28092913: 1744, 28306813: 3601, 28713161: 3382, 
            28998521: 47, 29343331: 3987, 29579983: 3549, 29692241: 2622, 
            29834617: 1689, 29903437: 2722, 29916757: 2473, 30118477: 1640, 
            30259007: 2602, 30663121: 3338, 30693379: 2482, 30927079: 3557, 
            30998419: 1809, 31083371: 18, 31860737: 28, 31965743: 1753, 
            32515583: 2492, 32777819: 3329, 32902213: 2501, 33059981: 3548, 
            33136241: 2721, 33151001: 1615, 33388541: 204, 33530251: 3767, 
            33785551: 1697, 33978053: 1633, 34170277: 36, 34270547: 3337, 
            34758037: 3381, 35305141: 1680, 35421499: 1743, 35609059: 27, 
            35691199: 2612, 36115589: 1688, 36321367: 1624, 36459209: 170, 
            36634033: 3328, 36734893: 17, 36998113: 1808, 37155143: 2481, 
            37438043: 3556, 37864361: 35, 37975471: 1632, 38152661: 2601, 
            39121913: 2472, 39458687: 1679, 39549707: 3986, 40019977: 3547, 
            40594469: 1623, 40783879: 192, 40997909: 203, 41485399: 3336, 
            42277273: 3766, 42599173: 181, 43105703: 26, 43351309: 1614, 
            43724491: 2471, 43825351: 2491, 44346461: 3327, 45192947: 1742, 
            45537047: 1687, 45970307: 1631, 46847789: 2480, 47204489: 2611, 
            47765779: 1678, 48037937: 16, 48451463: 1613, 48677533: 180, 
            49140673: 1622, 50078671: 191, 50459971: 3546, 52307677: 2490, 
            52929647: 2470, 53689459: 15, 53939969: 2600, 54350669: 25, 
            55915103: 3326, 57962561: 169, 58098991: 24, 58651771: 1612, 
            59771317: 2479, 60226417: 1677, 61959979: 1621, 64379963: 1676, 
            64992503: 14, 66233081: 168, 66737381: 2469, 71339959: 2468, 
            73952233: 1611, 76840601: 23, 79052387: 1610, 81947069: 13, 
            85147693: 179, 87598591: 12, 94352849: 167, 104553157: 11
        }
        # Map rank of 5-card hands to percentile against all other 5-card hands.
        # Warning, the shared board is not taken into account.
        rank_to_percentile_5 = [
            0.999998460922831,0.999996921845661,0.999995382768492,0.999993843691323,
            0.999992304614153,0.999990765536984,0.999989226459815,0.999987687382645,
            0.999986148305476,0.999984609228307,0.999983070151137,0.999981531073968,
            0.999979991996799,0.999978452919629,0.99997691384246,0.999975374765291,
            0.999973835688121,0.999972296610952,0.999970757533783,0.999969218456613,
            0.999967679379444,0.999966140302275,0.999964601225105,0.999963062147936,
            0.999961523070767,0.999959983993597,0.999958444916428,0.999956905839259,
            0.999955366762089,0.99995382768492,0.999952288607751,0.999950749530581,
            0.999949210453412,0.999947671376243,0.999946132299073,0.999944593221904,
            0.999943054144735,0.999941515067565,0.999939975990396,0.999938436913227,
            0.999936897836058,0.999935358758888,0.999933819681719,0.99993228060455,
            0.99993074152738,0.999929202450211,0.999927663373042,0.999926124295872,
            0.999924585218703,0.999923046141533,0.999921507064364,0.999919967987195,
            0.999918428910026,0.999916889832856,0.999915350755687,0.999913811678518,
            0.999912272601348,0.999910733524179,0.99990919444701,0.99990765536984,
            0.999906116292671,0.999904577215502,0.999903038138332,0.999901499061163,
            0.999899959983994,0.999898420906824,0.999896881829655,0.999895342752486,
            0.999893803675316,0.999892264598147,0.999890725520978,0.999889186443808,
            0.999887647366639,0.99988610828947,0.9998845692123,0.999883030135131,
            0.999881491057962,0.999879951980792,0.999878412903623,0.999876873826454,
            0.999875334749284,0.999873795672115,0.999872256594946,0.999870717517776,
            0.999869178440607,0.999867639363438,0.999866100286268,0.999864561209099,
            0.99986302213193,0.99986148305476,0.999859943977591,0.999858404900422,
            0.999856865823252,0.999855326746083,0.999853787668914,0.999852248591744,
            0.999850709514575,0.999849170437406,0.999847631360236,0.999846092283067,
            0.999844553205898,0.999843014128728,0.999841475051559,0.99983993597439,
            0.99983839689722,0.999836857820051,0.999835318742882,0.999833779665712,
            0.999832240588543,0.999830701511374,0.999829162434204,0.999827623357035,
            0.999826084279866,0.999824545202696,0.999823006125527,0.999821467048358,
            0.999819927971188,0.999818388894019,0.99981684981685,0.99981531073968,
            0.999813771662511,0.999812232585342,0.999810693508173,0.999809154431003,
            0.999807615353834,0.999806076276665,0.999804537199495,0.999802998122326,
            0.999801459045156,0.999799919967987,0.999798380890818,0.999796841813649,
            0.999795302736479,0.99979376365931,0.999792224582141,0.999790685504971,
            0.999789146427802,0.999787607350633,0.999786068273463,0.999784529196294,
            0.999782990119125,0.999781451041955,0.999779911964786,0.999778372887617,
            0.999776833810447,0.999775294733278,0.999773755656109,0.999772216578939,
            0.99977067750177,0.999769138424601,0.999767599347431,0.999766060270262,
            0.999764521193093,0.999762982115923,0.999761443038754,0.999759903961585,
            0.999758364884415,0.999756825807246,0.999755286730077,0.999753747652907,
            0.999752208575738,0.999750669498569,0.999749130421399,0.99974759134423,
            0.999746052267061,0.999744513189891,0.999735278726875,0.999726044263859,
            0.999716809800843,0.999707575337827,0.999698340874811,0.999689106411796,
            0.999679871948779,0.999670637485764,0.999661403022748,0.999652168559732,
            0.999642934096716,0.9996336996337,0.999624465170684,0.999615230707668,
            0.999605996244652,0.999596761781636,0.99958752731862,0.999578292855604,
            0.999569058392588,0.999559823929572,0.999550589466556,0.99954135500354,
            0.999532120540524,0.999522886077508,0.999513651614492,0.999504417151476,
            0.99949518268846,0.999485948225444,0.999476713762428,0.999467479299412,
            0.999458244836396,0.99944901037338,0.999439775910364,0.999430541447348,
            0.999421306984332,0.999412072521316,0.9994028380583,0.999393603595284,
            0.999384369132268,0.999375134669252,0.999365900206236,0.99935666574322,
            0.999347431280204,0.999338196817188,0.999328962354172,0.999319727891156,
            0.99931049342814,0.999301258965125,0.999292024502109,0.999282790039093,
            0.999273555576077,0.999264321113061,0.999255086650045,0.999245852187029,
            0.999236617724013,0.999227383260997,0.999218148797981,0.999208914334965,
            0.999199679871949,0.999190445408933,0.999181210945917,0.999171976482901,
            0.999162742019885,0.999153507556869,0.999144273093853,0.999135038630837,
            0.999125804167821,0.999116569704805,0.999107335241789,0.999098100778773,
            0.999088866315757,0.999079631852741,0.999070397389725,0.999061162926709,
            0.999051928463693,0.999042694000677,0.999033459537661,0.999024225074645,
            0.999014990611629,0.999005756148613,0.998996521685597,0.998987287222581,
            0.998978052759565,0.998968818296549,0.998959583833533,0.998950349370517,
            0.998941114907501,0.998931880444485,0.99892264598147,0.998913411518454,
            0.998904177055438,0.998894942592422,0.998885708129406,0.99887647366639,
            0.998867239203374,0.998858004740358,0.998848770277342,0.998839535814326,
            0.99883030135131,0.998821066888294,0.998811832425278,0.998802597962262,
            0.998793363499246,0.99878412903623,0.998774894573214,0.998765660110198,
            0.998756425647182,0.998747191184166,0.99873795672115,0.998728722258134,
            0.998719487795118,0.998710253332102,0.998701018869086,0.99869178440607,
            0.998682549943054,0.998673315480038,0.998664081017022,0.998654846554006,
            0.99864561209099,0.998636377627974,0.998627143164958,0.998617908701942,
            0.998608674238926,0.99859943977591,0.998590205312894,0.998580970849878,
            0.998571736386862,0.998562501923846,0.998553267460831,0.998544032997814,
            0.998534798534799,0.998525564071783,0.998516329608767,0.998507095145751,
            0.998497860682735,0.998488626219719,0.998479391756703,0.998470157293687,
            0.998460922830671,0.998451688367655,0.998442453904639,0.998433219441623,
            0.998423984978607,0.998414750515591,0.998405516052575,0.998396281589559,
            0.998387047126543,0.998377812663527,0.998368578200511,0.998359343737495,
            0.998350109274479,0.998340874811463,0.998331640348447,0.998322405885431,
            0.998313171422415,0.998303936959399,0.99830239788223,0.99830085880506,
            0.998299319727891,0.998297780650722,0.998296241573552,0.998294702496383,
            0.998293163419214,0.998291624342045,0.998290085264875,0.998288546187706,
            0.998287007110537,0.998285468033367,0.998283928956198,0.998282389879029,
            0.998280850801859,0.99827931172469,0.998277772647521,0.998276233570351,
            0.998274694493182,0.998273155416013,0.998271616338843,0.998270077261674,
            0.998268538184505,0.998266999107335,0.998265460030166,0.998263920952997,
            0.998262381875827,0.998260842798658,0.998259303721489,0.998257764644319,
            0.99825622556715,0.998254686489981,0.998253147412811,0.998251608335642,
            0.998250069258473,0.998248530181303,0.998246991104134,0.998245452026965,
            0.998243912949795,0.998242373872626,0.998240834795457,0.998239295718287,
            0.998237756641118,0.998236217563949,0.998234678486779,0.99823313940961,
            0.998231600332441,0.998230061255271,0.998228522178102,0.998226983100933,
            0.998225444023763,0.998223904946594,0.998222365869425,0.998220826792255,
            0.998219287715086,0.998217748637917,0.998216209560747,0.998214670483578,
            0.998213131406409,0.998211592329239,0.99821005325207,0.998208514174901,
            0.998206975097731,0.998205436020562,0.998203896943393,0.998202357866223,
            0.998200818789054,0.998199279711885,0.998197740634715,0.998196201557546,
            0.998194662480377,0.998193123403207,0.998191584326038,0.998190045248869,
            0.998188506171699,0.99818696709453,0.998185428017361,0.998183888940191,
            0.998182349863022,0.998180810785853,0.998179271708683,0.998177732631514,
            0.998176193554345,0.998174654477175,0.998173115400006,0.998171576322837,
            0.998170037245668,0.998168498168498,0.998166959091329,0.99816542001416,
            0.99816388093699,0.998162341859821,0.998160802782652,0.998159263705482,
            0.998157724628313,0.998156185551143,0.998154646473974,0.998153107396805,
            0.998151568319636,0.998150029242466,0.998148490165297,0.998146951088128,
            0.998145412010958,0.998143872933789,0.99814233385662,0.99814079477945,
            0.998139255702281,0.998137716625112,0.998136177547942,0.998134638470773,
            0.998133099393604,0.998131560316434,0.998130021239265,0.998128482162096,
            0.998126943084926,0.998125404007757,0.998123864930588,0.998122325853418,
            0.998120786776249,0.99811924769908,0.99811770862191,0.998116169544741,
            0.998114630467572,0.998113091390402,0.998111552313233,0.998110013236064,
            0.998108474158894,0.998106935081725,0.998105396004556,0.998103856927386,
            0.998102317850217,0.998100778773048,0.998099239695878,0.998097700618709,
            0.99809616154154,0.99809462246437,0.998093083387201,0.998091544310032,
            0.998090005232862,0.998088466155693,0.998086927078524,0.998085388001354,
            0.998083848924185,0.998082309847016,0.998080770769846,0.998079231692677,
            0.998077692615508,0.998076153538338,0.998074614461169,0.998073075384,
            0.99807153630683,0.998069997229661,0.998068458152492,0.998066919075322,
            0.998065379998153,0.998063840920984,0.998062301843815,0.998060762766645,
            0.998059223689476,0.998057684612306,0.998056145535137,0.998054606457968,
            0.998053067380798,0.998051528303629,0.99804998922646,0.99804845014929,
            0.998046911072121,0.998045371994952,0.998043832917783,0.998042293840613,
            0.998040754763444,0.998039215686275,0.998037676609105,0.998036137531936,
            0.998034598454766,0.998033059377597,0.998031520300428,0.998029981223259,
            0.998028442146089,0.99802690306892,0.998025363991751,0.998023824914581,
            0.998022285837412,0.998020746760243,0.998019207683073,0.998017668605904,
            0.998016129528735,0.998014590451565,0.998013051374396,0.998011512297227,
            0.998009973220057,0.998008434142888,0.998006895065719,0.998005355988549,
            0.99800381691138,0.998002277834211,0.998000738757041,0.997999199679872,
            0.997997660602703,0.997996121525533,0.997994582448364,0.997993043371195,
            0.997991504294025,0.997989965216856,0.997988426139687,0.997986887062517,
            0.997985347985348,0.997983808908179,0.997982269831009,0.99798073075384,
            0.997979191676671,0.997977652599501,0.997976113522332,0.997974574445163,
            0.997973035367993,0.997971496290824,0.997969957213655,0.997968418136485,
            0.997966879059316,0.997965339982147,0.997963800904977,0.997962261827808,
            0.997960722750639,0.997959183673469,0.9979576445963,0.997956105519131,
            0.997954566441961,0.997953027364792,0.997951488287623,0.997949949210453,
            0.997948410133284,0.997946871056115,0.997945331978945,0.997943792901776,
            0.997942253824607,0.997940714747437,0.997939175670268,0.997937636593099,
            0.997936097515929,0.99793455843876,0.997933019361591,0.997931480284421,
            0.997929941207252,0.997928402130083,0.997926863052913,0.997925323975744,
            0.997923784898575,0.997922245821406,0.997920706744236,0.997919167667067,
            0.997917628589898,0.997916089512728,0.997914550435559,0.99791301135839,
            0.99791147228122,0.997909933204051,0.997908394126881,0.997906855049712,
            0.997905315972543,0.997903776895374,0.997902237818204,0.997900698741035,
            0.997899159663866,0.997897620586696,0.997896081509527,0.997894542432358,
            0.997893003355188,0.997891464278019,0.99788992520085,0.99788838612368,
            0.997886847046511,0.997885307969342,0.997883768892172,0.997882229815003,
            0.997880690737834,0.997879151660664,0.997877612583495,0.997876073506326,
            0.997874534429156,0.997872995351987,0.997871456274818,0.997869917197648,
            0.997868378120479,0.99786683904331,0.99786529996614,0.997863760888971,
            0.997862221811802,0.997860682734632,0.997859143657463,0.997857604580294,
            0.997856065503124,0.997854526425955,0.997852987348786,0.997851448271616,
            0.997849909194447,0.997848370117278,0.997846831040108,0.997845291962939,
            0.99784375288577,0.9978422138086,0.997840674731431,0.997839135654262,
            0.997837596577092,0.997836057499923,0.997834518422754,0.997832979345584,
            0.997831440268415,0.997829901191246,0.997828362114076,0.997826823036907,
            0.997825283959738,0.997823744882568,0.997822205805399,0.99782066672823,
            0.99781912765106,0.997817588573891,0.997816049496722,0.997814510419552,
            0.997812971342383,0.997811432265214,0.997809893188044,0.997808354110875,
            0.997806815033706,0.997805275956536,0.997803736879367,0.997802197802198,
            0.997800658725028,0.997799119647859,0.99779758057069,0.997796041493521,
            0.997794502416351,0.997792963339182,0.997791424262013,0.997789885184843,
            0.997788346107674,0.997786807030504,0.997785267953335,0.997783728876166,
            0.997782189798997,0.997780650721827,0.997779111644658,0.997777572567489,
            0.997776033490319,0.99777449441315,0.997772955335981,0.997771416258811,
            0.997769877181642,0.997768338104473,0.997766799027303,0.997765259950134,
            0.997763720872965,0.997762181795795,0.997760642718626,0.997759103641457,
            0.997757564564287,0.997756025487118,0.997754486409949,0.997752947332779,
            0.99775140825561,0.997749869178441,0.997748330101271,0.997746791024102,
            0.997745251946933,0.997743712869763,0.997742173792594,0.997740634715425,
            0.997739095638255,0.997737556561086,0.997736017483917,0.997734478406747,
            0.997732939329578,0.997731400252409,0.997729861175239,0.99772832209807,
            0.997726783020901,0.997725243943731,0.997723704866562,0.997722165789393,
            0.997720626712223,0.997719087635054,0.997717548557885,0.997716009480715,
            0.997714470403546,0.997712931326377,0.997711392249207,0.997709853172038,
            0.997708314094869,0.997706775017699,0.99770523594053,0.997703696863361,
            0.997702157786191,0.997700618709022,0.997699079631853,0.997697540554683,
            0.997696001477514,0.997694462400345,0.997692923323175,0.997691384246006,
            0.997689845168837,0.997688306091667,0.997686767014498,0.997685227937329,
            0.997683688860159,0.99768214978299,0.997680610705821,0.997679071628651,
            0.997677532551482,0.997675993474313,0.997674454397143,0.997672915319974,
            0.997671376242805,0.997669837165636,0.997668298088466,0.997666759011297,
            0.997665219934127,0.997663680856958,0.997662141779789,0.997660602702619,
            0.99765906362545,0.997657524548281,0.997655985471112,0.997654446393942,
            0.997652907316773,0.997651368239604,0.997649829162434,0.997648290085265,
            0.997646751008096,0.997645211930926,0.997643672853757,0.997642133776588,
            0.997640594699418,0.997639055622249,0.99763751654508,0.99763597746791,
            0.997634438390741,0.997632899313572,0.997631360236402,0.997629821159233,
            0.997628282082064,0.997626743004894,0.997625203927725,0.997623664850556,
            0.997622125773386,0.997620586696217,0.997619047619048,0.997617508541878,
            0.997615969464709,0.99761443038754,0.99761289131037,0.997611352233201,
            0.997609813156032,0.997608274078862,0.997606735001693,0.997605195924524,
            0.997603656847354,0.997602117770185,0.997600578693016,0.997599039615846,
            0.997597500538677,0.997595961461508,0.997594422384338,0.997592883307169,
            0.99759134423,0.99758980515283,0.997588266075661,0.997586726998492,
            0.997585187921322,0.997583648844153,0.997582109766984,0.997580570689814,
            0.997579031612645,0.997577492535476,0.997575953458306,0.997574414381137,
            0.997572875303968,0.997571336226798,0.997569797149629,0.99756825807246,
            0.99756671899529,0.997565179918121,0.997563640840952,0.997562101763782,
            0.997560562686613,0.997559023609444,0.997557484532274,0.997555945455105,
            0.997554406377936,0.997552867300766,0.997551328223597,0.997549789146428,
            0.997548250069259,0.997546710992089,0.99754517191492,0.99754363283775,
            0.997542093760581,0.997540554683412,0.997539015606242,0.997537476529073,
            0.997535937451904,0.997534398374734,0.997532859297565,0.997531320220396,
            0.997529781143227,0.997528242066057,0.997526702988888,0.997525163911719,
            0.997523624834549,0.99752208575738,0.997520546680211,0.997519007603041,
            0.997517468525872,0.997515929448703,0.997514390371533,0.997512851294364,
            0.997511312217195,0.997509773140025,0.997508234062856,0.997506694985687,
            0.997505155908517,0.997503616831348,0.997502077754179,0.997500538677009,
            0.99749899959984,0.997497460522671,0.997495921445501,0.997494382368332,
            0.997492843291163,0.997491304213993,0.997489765136824,0.997488226059655,
            0.997486686982485,0.997485147905316,0.997483608828147,0.997482069750977,
            0.997480530673808,0.997478991596639,0.997477452519469,0.9974759134423,
            0.997474374365131,0.997472835287961,0.997471296210792,0.997469757133623,
            0.997468218056453,0.997466678979284,0.997465139902115,0.997463600824945,
            0.997462061747776,0.997460522670607,0.997458983593437,0.997457444516268,
            0.997455905439099,0.997454366361929,0.99745282728476,0.997451288207591,
            0.997449749130421,0.997448210053252,0.997446670976083,0.997445131898913,
            0.997443592821744,0.997442053744575,0.997440514667405,0.997438975590236,
            0.997437436513067,0.997435897435897,0.997434358358728,0.997432819281559,
            0.997431280204389,0.99742974112722,0.997428202050051,0.997426662972881,
            0.997425123895712,0.997423584818543,0.997422045741373,0.997420506664204,
            0.997418967587035,0.997417428509865,0.997415889432696,0.997414350355527,
            0.997412811278357,0.997411272201188,0.997409733124019,0.99740819404685,
            0.99740665496968,0.997405115892511,0.997403576815342,0.997402037738172,
            0.997400498661003,0.997398959583834,0.997397420506664,0.997395881429495,
            0.997394342352325,0.997392803275156,0.997391264197987,0.997389725120818,
            0.997388186043648,0.997386646966479,0.99738510788931,0.99738356881214,
            0.997382029734971,0.997380490657802,0.997378951580632,0.997377412503463,
            0.997375873426294,0.997374334349124,0.997372795271955,0.997371256194786,
            0.997369717117616,0.997368178040447,0.997366638963278,0.997365099886108,
            0.997363560808939,0.99736202173177,0.9973604826546,0.997358943577431,
            0.997357404500262,0.997355865423092,0.997354326345923,0.997352787268754,
            0.997351248191584,0.997349709114415,0.997348170037246,0.997346630960076,
            0.997345091882907,0.997343552805738,0.997342013728568,0.997340474651399,
            0.99733893557423,0.99733739649706,0.997335857419891,0.997334318342722,
            0.997332779265552,0.997331240188383,0.997329701111214,0.997328162034044,
            0.997326622956875,0.997325083879706,0.997323544802536,0.997322005725367,
            0.997320466648198,0.997318927571028,0.997317388493859,0.99731584941669,
            0.99731431033952,0.997312771262351,0.997311232185182,0.997309693108012,
            0.997308154030843,0.997306614953674,0.997305075876504,0.997303536799335,
            0.997301997722166,0.997300458644997,0.997298919567827,0.997297380490658,
            0.997295841413488,0.997294302336319,0.99729276325915,0.99729122418198,
            0.997289685104811,0.997288146027642,0.997286606950472,0.997285067873303,
            0.997283528796134,0.997281989718965,0.997280450641795,0.997278911564626,
            0.997277372487457,0.997275833410287,0.997274294333118,0.997272755255948,
            0.997271216178779,0.99726967710161,0.997268138024441,0.997266598947271,
            0.997265059870102,0.997263520792933,0.997261981715763,0.997260442638594,
            0.997258903561425,0.997257364484255,0.997255825407086,0.997254286329917,
            0.997252747252747,0.997251208175578,0.997249669098409,0.997248130021239,
            0.99724659094407,0.997245051866901,0.997243512789731,0.997241973712562,
            0.997240434635393,0.997238895558223,0.997237356481054,0.997235817403885,
            0.997234278326715,0.997232739249546,0.997231200172377,0.997229661095207,
            0.997228122018038,0.997226582940869,0.997225043863699,0.99722350478653,
            0.997221965709361,0.997220426632191,0.997218887555022,0.997217348477853,
            0.997215809400683,0.997214270323514,0.997212731246345,0.997211192169175,
            0.997209653092006,0.997208114014837,0.997206574937667,0.997205035860498,
            0.997203496783329,0.997201957706159,0.99720041862899,0.997198879551821,
            0.997197340474651,0.997195801397482,0.997194262320313,0.997192723243143,
            0.997191184165974,0.997189645088805,0.997188106011635,0.997186566934466,
            0.997185027857297,0.997183488780127,0.997181949702958,0.997180410625789,
            0.997178871548619,0.99717733247145,0.997175793394281,0.997174254317111,
            0.997172715239942,0.997171176162773,0.997169637085603,0.997168098008434,
            0.997166558931265,0.997165019854095,0.997163480776926,0.997161941699757,
            0.997160402622588,0.997158863545418,0.997157324468249,0.99715578539108,
            0.99715424631391,0.997152707236741,0.997151168159571,0.997149629082402,
            0.997148090005233,0.997146550928063,0.997145011850894,0.997143472773725,
            0.997141933696556,0.997140394619386,0.997138855542217,0.997137316465048,
            0.997135777387878,0.997134238310709,0.99713269923354,0.99713116015637,
            0.997129621079201,0.997128082002032,0.997126542924862,0.997125003847693,
            0.997123464770524,0.997121925693354,0.997120386616185,0.997118847539016,
            0.997117308461846,0.997115769384677,0.997114230307508,0.997112691230338,
            0.997111152153169,0.997109613076,0.99710807399883,0.997106534921661,
            0.997104995844492,0.997103456767322,0.997101917690153,0.997100378612984,
            0.997098839535814,0.997097300458645,0.997095761381476,0.997094222304306,
            0.997092683227137,0.997091144149968,0.997089605072798,0.997088065995629,
            0.99708652691846,0.99708498784129,0.997083448764121,0.997081909686952,
            0.997080370609782,0.997078831532613,0.997077292455444,0.997075753378274,
            0.997074214301105,0.997072675223936,0.997071136146766,0.997069597069597,
            0.997068057992428,0.997066518915258,0.997064979838089,0.99706344076092,
            0.99706190168375,0.997060362606581,0.997058823529412,0.997057284452242,
            0.997055745375073,0.997054206297904,0.997052667220734,0.997051128143565,
            0.997049589066396,0.997048049989226,0.997046510912057,0.997044971834888,
            0.997043432757718,0.997041893680549,0.99704035460338,0.99703881552621,
            0.997037276449041,0.997035737371872,0.997034198294703,0.997032659217533,
            0.997031120140364,0.997029581063195,0.997028041986025,0.997026502908856,
            0.997024963831686,0.997023424754517,0.997021885677348,0.997020346600179,
            0.997018807523009,0.99701726844584,0.997015729368671,0.997014190291501,
            0.997012651214332,0.997011112137163,0.997009573059993,0.997008033982824,
            0.997006494905655,0.997004955828485,0.997003416751316,0.997001877674147,
            0.997000338596977,0.996998799519808,0.996997260442639,0.996995721365469,
            0.9969941822883,0.996992643211131,0.996991104133961,0.996989565056792,
            0.996988025979623,0.996986486902453,0.996984947825284,0.996983408748115,
            0.996981869670945,0.996980330593776,0.996978791516607,0.996977252439437,
            0.996975713362268,0.996974174285099,0.996972635207929,0.99697109613076,
            0.996969557053591,0.996968017976421,0.996966478899252,0.996964939822083,
            0.996963400744913,0.996961861667744,0.996960322590575,0.996958783513405,
            0.996957244436236,0.996955705359067,0.996954166281897,0.996952627204728,
            0.996951088127559,0.996949549050389,0.99694800997322,0.996946470896051,
            0.996944931818881,0.996943392741712,0.996941853664543,0.996940314587373,
            0.996938775510204,0.996937236433035,0.996935697355865,0.996934158278696,
            0.996932619201527,0.996931080124357,0.996929541047188,0.996928001970019,
            0.996926462892849,0.99692492381568,0.996923384738511,0.996921845661341,
            0.996920306584172,0.996918767507003,0.996917228429833,0.996915689352664,
            0.996914150275495,0.996912611198326,0.996911072121156,0.996909533043987,
            0.996907993966818,0.996906454889648,0.996904915812479,0.996903376735309,
            0.99690183765814,0.996900298580971,0.996898759503801,0.996897220426632,
            0.996895681349463,0.996894142272294,0.996892603195124,0.996891064117955,
            0.996889525040786,0.996887985963616,0.996886446886447,0.996884907809278,
            0.996883368732108,0.996881829654939,0.99688029057777,0.9968787515006,
            0.996877212423431,0.996875673346262,0.996874134269092,0.996872595191923,
            0.996871056114754,0.996869517037584,0.996867977960415,0.996866438883246,
            0.996864899806076,0.996863360728907,0.996861821651738,0.996860282574568,
            0.996858743497399,0.99685720442023,0.99685566534306,0.996854126265891,
            0.996852587188722,0.996851048111552,0.996849509034383,0.996847969957214,
            0.996846430880044,0.996844891802875,0.996843352725706,0.996841813648536,
            0.996840274571367,0.996838735494198,0.996837196417028,0.996835657339859,
            0.99683411826269,0.99683257918552,0.996831040108351,0.996829501031182,
            0.996827961954012,0.996826422876843,0.996824883799674,0.996823344722504,
            0.996821805645335,0.996820266568166,0.996818727490996,0.996817188413827,
            0.996815649336658,0.996814110259488,0.996812571182319,0.99681103210515,
            0.99680949302798,0.996807953950811,0.996806414873642,0.996804875796472,
            0.996803336719303,0.996801797642134,0.996800258564964,0.996798719487795,
            0.996797180410626,0.996795641333456,0.996794102256287,0.996792563179118,
            0.996791024101948,0.996789485024779,0.99678794594761,0.996786406870441,
            0.996784867793271,0.996783328716102,0.996781789638932,0.996780250561763,
            0.996778711484594,0.996777172407424,0.996775633330255,0.996774094253086,
            0.996772555175917,0.996771016098747,0.996769477021578,0.996767937944409,
            0.996766398867239,0.99676485979007,0.996763320712901,0.996761781635731,
            0.996760242558562,0.996758703481393,0.996757164404223,0.996755625327054,
            0.996754086249885,0.996752547172715,0.996751008095546,0.996749469018377,
            0.996747929941207,0.996746390864038,0.996744851786869,0.996743312709699,
            0.99674177363253,0.996740234555361,0.996738695478191,0.996737156401022,
            0.996735617323853,0.996734078246683,0.996732539169514,0.996731000092345,
            0.996729461015175,0.996727921938006,0.996726382860837,0.996724843783667,
            0.996723304706498,0.996721765629329,0.996720226552159,0.99671868747499,
            0.996717148397821,0.996715609320651,0.996714070243482,0.996712531166313,
            0.996710992089143,0.996709453011974,0.996707913934805,0.996706374857635,
            0.996704835780466,0.996703296703297,0.996701757626127,0.996700218548958,
            0.996698679471789,0.996697140394619,0.99669560131745,0.996694062240281,
            0.996692523163111,0.996690984085942,0.996689445008773,0.996687905931603,
            0.996686366854434,0.996684827777265,0.996683288700095,0.996681749622926,
            0.996680210545757,0.996678671468587,0.996677132391418,0.996675593314249,
            0.996674054237079,0.99667251515991,0.996670976082741,0.996669437005571,
            0.996667897928402,0.996666358851233,0.996664819774064,0.996663280696894,
            0.996661741619725,0.996660202542555,0.996658663465386,0.996657124388217,
            0.996655585311047,0.996654046233878,0.996652507156709,0.996650968079539,
            0.99664942900237,0.996647889925201,0.996646350848032,0.996644811770862,
            0.996643272693693,0.996641733616524,0.996640194539354,0.996638655462185,
            0.996637116385016,0.996635577307846,0.996634038230677,0.996632499153508,
            0.996630960076338,0.996629420999169,0.996627881922,0.99662634284483,
            0.996624803767661,0.996623264690492,0.996621725613322,0.996620186536153,
            0.996618647458984,0.996617108381814,0.996615569304645,0.996614030227476,
            0.996612491150306,0.996610952073137,0.996609412995968,0.996607873918798,
            0.996606334841629,0.99660479576446,0.99660325668729,0.996601717610121,
            0.996600178532952,0.996598639455782,0.996597100378613,0.996595561301444,
            0.996594022224274,0.996592483147105,0.996590944069936,0.996589404992766,
            0.996587865915597,0.996586326838428,0.996584787761258,0.996583248684089,
            0.99658170960692,0.99658017052975,0.996578631452581,0.996577092375412,
            0.996575553298242,0.996574014221073,0.996572475143904,0.996570936066734,
            0.996569396989565,0.996567857912396,0.996566318835226,0.996564779758057,
            0.996563240680888,0.996561701603718,0.996560162526549,0.99655862344938,
            0.99655708437221,0.996555545295041,0.996554006217872,0.996552467140702,
            0.996550928063533,0.996549388986364,0.996547849909194,0.996546310832025,
            0.996544771754856,0.996543232677686,0.996541693600517,0.996540154523348,
            0.996538615446178,0.996537076369009,0.99653553729184,0.99653399821467,
            0.996532459137501,0.996530920060332,0.996529380983162,0.996527841905993,
            0.996526302828824,0.996524763751655,0.996523224674485,0.996521685597316,
            0.996520146520147,0.996518607442977,0.996517068365808,0.996515529288639,
            0.996513990211469,0.9965124511343,0.99651091205713,0.996509372979961,
            0.996507833902792,0.996506294825623,0.996504755748453,0.996503216671284,
            0.996501677594115,0.996500138516945,0.996498599439776,0.996497060362607,
            0.996495521285437,0.996493982208268,0.996492443131099,0.996490904053929,
            0.99648936497676,0.996487825899591,0.996486286822421,0.996484747745252,
            0.996483208668083,0.996481669590913,0.996480130513744,0.996478591436575,
            0.996477052359405,0.996475513282236,0.996473974205067,0.996472435127897,
            0.996470896050728,0.996469356973559,0.996467817896389,0.99646627881922,
            0.996464739742051,0.996463200664881,0.996461661587712,0.996460122510543,
            0.996458583433373,0.996457044356204,0.996455505279035,0.996453966201865,
            0.996452427124696,0.996450888047527,0.996449348970357,0.996447809893188,
            0.996446270816019,0.996444731738849,0.99644319266168,0.996441653584511,
            0.996440114507341,0.996438575430172,0.996437036353003,0.996435497275833,
            0.996433958198664,0.996432419121495,0.996430880044325,0.996429340967156,
            0.996427801889987,0.996426262812817,0.996424723735648,0.996423184658479,
            0.996421645581309,0.99642010650414,0.996418567426971,0.996417028349802,
            0.996415489272632,0.996413950195463,0.996412411118293,0.996410872041124,
            0.996409332963955,0.996407793886785,0.996406254809616,0.996404715732447,
            0.996403176655277,0.996401637578108,0.996400098500939,0.99639855942377,
            0.9963970203466,0.996395481269431,0.996393942192262,0.996392403115092,
            0.996390864037923,0.996389324960753,0.996387785883584,0.996386246806415,
            0.996384707729246,0.996383168652076,0.996381629574907,0.996380090497738,
            0.996378551420568,0.996377012343399,0.99637547326623,0.99637393418906,
            0.996372395111891,0.996370856034722,0.996369316957552,0.996367777880383,
            0.996366238803214,0.996364699726044,0.996363160648875,0.996361621571706,
            0.996360082494536,0.996358543417367,0.996357004340198,0.996355465263028,
            0.996353926185859,0.99635238710869,0.99635084803152,0.996349308954351,
            0.996347769877182,0.996346230800012,0.996344691722843,0.996343152645674,
            0.996341613568504,0.996340074491335,0.996338535414166,0.995946070735987,
            0.995553606057808,0.995161141379629,0.99476867670145,0.994376212023271,
            0.993983747345092,0.993591282666913,0.993198817988734,0.992806353310555,
            0.992413888632376,0.992389263397667,0.992364638162958,0.992340012928248,
            0.992315387693539,0.99229076245883,0.99226613722412,0.992241511989411,
            0.992216886754702,0.992192261519993,0.992167636285283,0.992143011050574,
            0.992118385815865,0.992093760581156,0.992069135346446,0.992044510111737,
            0.992019884877028,0.991995259642318,0.991970634407609,0.9919460091729,
            0.991921383938191,0.991896758703481,0.991872133468772,0.991847508234063,
            0.991822882999354,0.991798257764644,0.991773632529935,0.991749007295226,
            0.991724382060516,0.991699756825807,0.991675131591098,0.991650506356389,
            0.991625881121679,0.99160125588697,0.991576630652261,0.991552005417552,
            0.991527380182842,0.991502754948133,0.991478129713424,0.991453504478715,
            0.991428879244005,0.991404254009296,0.991379628774587,0.991355003539877,
            0.991330378305168,0.991305753070459,0.99128112783575,0.99125650260104,
            0.991231877366331,0.991207252131622,0.991182626896913,0.991158001662203,
            0.991133376427494,0.991108751192785,0.991084125958075,0.991059500723366,
            0.991034875488657,0.991010250253948,0.990985625019238,0.990960999784529,
            0.99093637454982,0.990911749315111,0.990887124080401,0.990862498845692,
            0.990837873610983,0.990813248376274,0.990788623141564,0.990763997906855,
            0.990739372672146,0.990714747437436,0.990690122202727,0.990665496968018,
            0.990640871733309,0.990616246498599,0.99059162126389,0.990566996029181,
            0.990542370794472,0.990517745559762,0.990493120325053,0.990468495090344,
            0.990443869855635,0.990419244620925,0.990394619386216,0.990369994151507,
            0.990345368916797,0.990320743682088,0.990296118447379,0.99027149321267,
            0.99024686797796,0.990222242743251,0.990197617508542,0.990172992273833,
            0.990148367039123,0.990123741804414,0.990099116569705,0.990074491334996,
            0.990049866100286,0.990025240865577,0.990000615630868,0.989975990396158,
            0.989951365161449,0.98992673992674,0.989902114692031,0.989877489457321,
            0.989852864222612,0.989828238987903,0.989803613753194,0.989778988518484,
            0.989754363283775,0.989729738049066,0.989705112814356,0.989680487579647,
            0.989655862344938,0.989631237110229,0.989606611875519,0.98958198664081,
            0.989557361406101,0.989532736171392,0.989508110936682,0.989483485701973,
            0.989458860467264,0.989434235232555,0.989409609997845,0.989384984763136,
            0.989360359528427,0.989335734293717,0.989311109059008,0.989286483824299,
            0.98926185858959,0.98923723335488,0.989212608120171,0.989187982885462,
            0.989163357650753,0.989138732416043,0.989114107181334,0.989089481946625,
            0.989064856711916,0.989040231477206,0.989015606242497,0.988990981007788,
            0.988966355773078,0.988941730538369,0.98891710530366,0.988892480068951,
            0.988867854834241,0.988843229599532,0.988818604364823,0.988793979130114,
            0.988769353895404,0.988744728660695,0.988720103425986,0.988695478191276,
            0.988670852956567,0.988646227721858,0.988621602487149,0.988596977252439,
            0.98857235201773,0.988547726783021,0.988523101548312,0.988498476313602,
            0.988473851078893,0.988449225844184,0.988424600609475,0.988399975374765,
            0.988375350140056,0.988350724905347,0.988326099670637,0.988301474435928,
            0.988276849201219,0.98825222396651,0.9882275987318,0.988202973497091,
            0.988178348262382,0.988153723027673,0.988129097792963,0.988104472558254,
            0.988079847323545,0.988055222088836,0.988030596854126,0.988005971619417,
            0.987981346384708,0.987956721149998,0.987932095915289,0.98790747068058,
            0.987882845445871,0.987858220211161,0.987833594976452,0.987808969741743,
            0.987784344507034,0.987759719272324,0.987735094037615,0.987710468802906,
            0.987685843568197,0.987661218333487,0.987636593098778,0.987611967864069,
            0.987587342629359,0.98756271739465,0.987538092159941,0.987513466925232,
            0.987488841690522,0.987464216455813,0.987439591221104,0.987414965986395,
            0.987390340751685,0.987365715516976,0.987341090282267,0.987316465047557,
            0.987291839812848,0.987267214578139,0.98724258934343,0.98721796410872,
            0.987193338874011,0.987168713639302,0.987144088404593,0.987119463169883,
            0.987094837935174,0.987070212700465,0.987045587465756,0.987020962231046,
            0.986996336996337,0.986971711761628,0.986947086526918,0.986922461292209,
            0.9868978360575,0.986873210822791,0.986848585588081,0.986823960353372,
            0.986799335118663,0.986774709883954,0.986750084649244,0.986725459414535,
            0.986700834179826,0.986676208945117,0.986651583710407,0.986626958475698,
            0.986602333240989,0.986577708006279,0.98655308277157,0.986528457536861,
            0.986503832302152,0.986479207067442,0.986454581832733,0.986429956598024,
            0.986405331363315,0.986380706128605,0.986356080893896,0.986331455659187,
            0.986306830424478,0.986282205189768,0.986257579955059,0.98623295472035,
            0.98620832948564,0.986183704250931,0.986159079016222,0.986134453781513,
            0.986109828546803,0.986085203312094,0.986060578077385,0.986035952842676,
            0.986011327607966,0.985986702373257,0.985962077138548,0.985937451903838,
            0.985912826669129,0.98588820143442,0.985863576199711,0.985838950965001,
            0.985814325730292,0.985789700495583,0.985765075260874,0.985740450026164,
            0.985715824791455,0.985691199556746,0.985666574322037,0.985641949087327,
            0.985617323852618,0.985592698617909,0.985568073383199,0.98554344814849,
            0.985518822913781,0.985494197679072,0.985469572444362,0.985444947209653,
            0.985420321974944,0.985395696740235,0.985371071505525,0.985346446270816,
            0.985321821036107,0.985297195801398,0.985272570566688,0.985247945331979,
            0.98522332009727,0.98519869486256,0.985174069627851,0.985149444393142,
            0.985124819158433,0.985100193923723,0.985075568689014,0.985050943454305,
            0.985026318219596,0.985001692984886,0.984977067750177,0.984952442515468,
            0.984927817280759,0.984903192046049,0.98487856681134,0.984853941576631,
            0.984829316341921,0.984804691107212,0.984780065872503,0.984755440637794,
            0.984730815403084,0.984706190168375,0.984681564933666,0.984656939698957,
            0.984632314464247,0.984607689229538,0.984583063994829,0.984558438760119,
            0.98453381352541,0.984509188290701,0.984484563055992,0.984459937821282,
            0.984435312586573,0.984410687351864,0.984386062117155,0.984361436882445,
            0.984336811647736,0.984312186413027,0.984287561178318,0.984262935943608,
            0.984238310708899,0.98421368547419,0.98418906023948,0.984164435004771,
            0.984139809770062,0.984115184535353,0.984090559300643,0.984065934065934,
            0.984041308831225,0.984016683596516,0.983992058361806,0.983967433127097,
            0.983942807892388,0.983918182657678,0.983893557422969,0.98386893218826,
            0.983844306953551,0.983819681718841,0.983795056484132,0.983770431249423,
            0.983745806014714,0.983721180780004,0.983696555545295,0.983671930310586,
            0.983647305075876,0.983622679841167,0.983598054606458,0.983573429371749,
            0.983548804137039,0.98352417890233,0.983499553667621,0.983474928432912,
            0.983450303198202,0.983425677963493,0.983401052728784,0.983376427494075,
            0.983351802259365,0.983327177024656,0.983302551789947,0.983277926555237,
            0.983253301320528,0.983228676085819,0.98320405085111,0.9831794256164,
            0.983154800381691,0.983130175146982,0.983105549912273,0.983080924677563,
            0.983056299442854,0.983031674208145,0.983007048973435,0.982982423738726,
            0.982957798504017,0.982933173269308,0.982908548034598,0.982883922799889,
            0.98285929756518,0.982834672330471,0.982810047095761,0.982785421861052,
            0.982760796626343,0.982736171391634,0.982711546156924,0.982686920922215,
            0.982662295687506,0.982637670452796,0.982613045218087,0.982588419983378,
            0.982563794748669,0.982539169513959,0.98251454427925,0.982489919044541,
            0.982465293809832,0.982440668575122,0.982416043340413,0.982391418105704,
            0.982366792870995,0.982342167636285,0.982317542401576,0.982292917166867,
            0.982268291932157,0.982243666697448,0.982219041462739,0.98219441622803,
            0.98216979099332,0.982145165758611,0.982120540523902,0.982095915289193,
            0.982071290054483,0.982046664819774,0.982022039585065,0.981997414350355,
            0.981972789115646,0.981948163880937,0.981923538646228,0.981898913411518,
            0.981874288176809,0.9818496629421,0.981825037707391,0.981800412472681,
            0.981775787237972,0.981751162003263,0.981726536768554,0.981701911533844,
            0.981677286299135,0.981652661064426,0.981628035829716,0.981603410595007,
            0.981578785360298,0.981554160125589,0.981529534890879,0.98150490965617,
            0.981480284421461,0.981455659186752,0.981431033952042,0.981406408717333,
            0.981381783482624,0.981357158247915,0.981332533013205,0.981307907778496,
            0.981283282543787,0.981258657309077,0.981234032074368,0.981209406839659,
            0.98118478160495,0.98116015637024,0.981135531135531,0.981110905900822,
            0.981086280666113,0.981061655431403,0.981037030196694,0.981012404961985,
            0.980987779727276,0.980963154492566,0.980938529257857,0.980913904023148,
            0.980889278788438,0.980864653553729,0.98084002831902,0.980815403084311,
            0.980790777849601,0.980766152614892,0.980741527380183,0.980716902145474,
            0.980692276910764,0.980667651676055,0.980643026441346,0.980618401206636,
            0.980593775971927,0.980569150737218,0.980544525502509,0.980519900267799,
            0.98049527503309,0.980470649798381,0.980446024563672,0.980421399328962,
            0.980396774094253,0.980372148859544,0.980347523624835,0.980322898390125,
            0.980298273155416,0.980273647920707,0.980249022685997,0.980224397451288,
            0.980199772216579,0.98017514698187,0.98015052174716,0.980125896512451,
            0.980101271277742,0.980076646043033,0.980052020808323,0.980027395573614,
            0.980002770338905,0.979978145104196,0.979953519869486,0.979928894634777,
            0.979904269400068,0.979879644165358,0.979855018930649,0.97983039369594,
            0.979805768461231,0.979781143226521,0.979756517991812,0.979731892757103,
            0.979707267522394,0.979682642287684,0.979658017052975,0.979633391818266,
            0.979608766583556,0.979584141348847,0.979559516114138,0.979534890879429,
            0.979510265644719,0.97948564041001,0.979461015175301,0.979436389940592,
            0.979411764705882,0.979387139471173,0.979362514236464,0.979337889001755,
            0.979313263767045,0.979288638532336,0.979264013297627,0.979239388062917,
            0.979214762828208,0.979190137593499,0.97916551235879,0.97914088712408,
            0.979116261889371,0.979091636654662,0.979067011419953,0.979042386185243,
            0.979017760950534,0.978993135715825,0.978968510481116,0.978943885246406,
            0.978919260011697,0.978894634776988,0.978870009542278,0.978845384307569,
            0.97882075907286,0.978796133838151,0.978771508603441,0.978746883368732,
            0.978722258134023,0.978697632899314,0.978673007664604,0.978648382429895,
            0.978623757195186,0.978599131960477,0.978574506725767,0.978549881491058,
            0.978525256256349,0.978500631021639,0.97847600578693,0.978451380552221,
            0.978426755317512,0.978402130082802,0.978377504848093,0.978352879613384,
            0.978328254378675,0.978303629143965,0.978279003909256,0.978254378674547,
            0.978229753439837,0.978205128205128,0.978180502970419,0.97815587773571,
            0.978131252501,0.978106627266291,0.978082002031582,0.978057376796873,
            0.978032751562163,0.978008126327454,0.977983501092745,0.977958875858036,
            0.977934250623326,0.977909625388617,0.977885000153908,0.977860374919198,
            0.977835749684489,0.97781112444978,0.977786499215071,0.977761873980361,
            0.977737248745652,0.977712623510943,0.977687998276234,0.977663373041524,
            0.977638747806815,0.977614122572106,0.977589497337397,0.977564872102687,
            0.977540246867978,0.977515621633269,0.977490996398559,0.97746637116385,
            0.977441745929141,0.977417120694432,0.977392495459722,0.977367870225013,
            0.977343244990304,0.977318619755595,0.977293994520885,0.977269369286176,
            0.977244744051467,0.977220118816758,0.977195493582048,0.977170868347339,
            0.97714624311263,0.97712161787792,0.977096992643211,0.977072367408502,
            0.977047742173793,0.977023116939083,0.976998491704374,0.976973866469665,
            0.976949241234956,0.976924616000246,0.976899990765537,0.976875365530828,
            0.976850740296118,0.976826115061409,0.9768014898267,0.976776864591991,
            0.976752239357281,0.976727614122572,0.976702988887863,0.976678363653154,
            0.976653738418444,0.976629113183735,0.976604487949026,0.976579862714317,
            0.976555237479607,0.976530612244898,0.976505987010189,0.976481361775479,
            0.97645673654077,0.976432111306061,0.976407486071352,0.976382860836642,
            0.976358235601933,0.976333610367224,0.976308985132515,0.976284359897805,
            0.976259734663096,0.976235109428387,0.976210484193678,0.976185858958968,
            0.976161233724259,0.97613660848955,0.97611198325484,0.976087358020131,
            0.976062732785422,0.976038107550713,0.976013482316003,0.975988857081294,
            0.975964231846585,0.975939606611876,0.975914981377166,0.975890356142457,
            0.975865730907748,0.975841105673039,0.975816480438329,0.97579185520362,
            0.975767229968911,0.975742604734201,0.975717979499492,0.975693354264783,
            0.975668729030074,0.975644103795364,0.975619478560655,0.975594853325946,
            0.975570228091237,0.975545602856527,0.975520977621818,0.975496352387109,
            0.975471727152399,0.97544710191769,0.975422476682981,0.975397851448272,
            0.975373226213562,0.975348600978853,0.975323975744144,0.975299350509435,
            0.975274725274725,0.975250100040016,0.975225474805307,0.975200849570597,
            0.975176224335888,0.975151599101179,0.97512697386647,0.97510234863176,
            0.975077723397051,0.975053098162342,0.975028472927633,0.975003847692923,
            0.974979222458214,0.974954597223505,0.974929971988795,0.974905346754086,
            0.974880721519377,0.974856096284668,0.974831471049958,0.974806845815249,
            0.97478222058054,0.974757595345831,0.974732970111121,0.974708344876412,
            0.974683719641703,0.974659094406994,0.974634469172284,0.974609843937575,
            0.974585218702866,0.974560593468156,0.974535968233447,0.974511342998738,
            0.974486717764029,0.974462092529319,0.97443746729461,0.974412842059901,
            0.974388216825192,0.974363591590482,0.974338966355773,0.974314341121064,
            0.974289715886354,0.974265090651645,0.974240465416936,0.974215840182227,
            0.974191214947517,0.974166589712808,0.974141964478099,0.97411733924339,
            0.97409271400868,0.974068088773971,0.974043463539262,0.974018838304553,
            0.973994213069843,0.973969587835134,0.973944962600425,0.973920337365715,
            0.973895712131006,0.973871086896297,0.973846461661588,0.973821836426878,
            0.973797211192169,0.97377258595746,0.973747960722751,0.973723335488041,
            0.973698710253332,0.973674085018623,0.973649459783914,0.973624834549204,
            0.973600209314495,0.973575584079786,0.973550958845076,0.973526333610367,
            0.973501708375658,0.973477083140949,0.973452457906239,0.97342783267153,
            0.973403207436821,0.973378582202112,0.973353956967402,0.973329331732693,
            0.973304706497984,0.973280081263275,0.973255456028565,0.973230830793856,
            0.973206205559147,0.973181580324437,0.973156955089728,0.973132329855019,
            0.97310770462031,0.9730830793856,0.973058454150891,0.973033828916182,
            0.973009203681473,0.972984578446763,0.972959953212054,0.972935327977345,
            0.972910702742635,0.972886077507926,0.972861452273217,0.972836827038508,
            0.972812201803798,0.972787576569089,0.97276295133438,0.972738326099671,
            0.972713700864961,0.972689075630252,0.972664450395543,0.972639825160834,
            0.972615199926124,0.972590574691415,0.972565949456706,0.972541324221996,
            0.972516698987287,0.972492073752578,0.972467448517869,0.972442823283159,
            0.97241819804845,0.972393572813741,0.972368947579032,0.972344322344322,
            0.972319697109613,0.972295071874904,0.972270446640195,0.972245821405485,
            0.972221196170776,0.972196570936067,0.972171945701357,0.972147320466648,
            0.972122695231939,0.97209806999723,0.97207344476252,0.972048819527811,
            0.972024194293102,0.971999569058393,0.971974943823683,0.971950318588974,
            0.971925693354265,0.971901068119556,0.971876442884846,0.971851817650137,
            0.971827192415428,0.971802567180718,0.971777941946009,0.9717533167113,
            0.971728691476591,0.971704066241881,0.971679441007172,0.971654815772463,
            0.971630190537754,0.971605565303044,0.971580940068335,0.971556314833626,
            0.971531689598916,0.971507064364207,0.971482439129498,0.971457813894789,
            0.971433188660079,0.97140856342537,0.971383938190661,0.971359312955952,
            0.971334687721242,0.971310062486533,0.971285437251824,0.971230030473728,
            0.971174623695632,0.971119216917536,0.97106381013944,0.971008403361345,
            0.970952996583249,0.970897589805153,0.970842183027057,0.970786776248961,
            0.970731369470865,0.970675962692769,0.970620555914674,0.970565149136578,
            0.970509742358482,0.970454335580386,0.97039892880229,0.970343522024194,
            0.970288115246098,0.970232708468003,0.970177301689907,0.970121894911811,
            0.970066488133715,0.970011081355619,0.969955674577523,0.969900267799428,
            0.969844861021332,0.969789454243236,0.96973404746514,0.969678640687044,
            0.969623233908948,0.969567827130852,0.969512420352757,0.969457013574661,
            0.969401606796565,0.969346200018469,0.969290793240373,0.969235386462277,
            0.969179979684181,0.969124572906086,0.96906916612799,0.969013759349894,
            0.968958352571798,0.968902945793702,0.968847539015606,0.96879213223751,
            0.968736725459415,0.968681318681319,0.968625911903223,0.968570505125127,
            0.968515098347031,0.968459691568935,0.968404284790839,0.968348878012744,
            0.968293471234648,0.968238064456552,0.968182657678456,0.96812725090036,
            0.968071844122264,0.968016437344168,0.967961030566073,0.967905623787977,
            0.967850217009881,0.967794810231785,0.967739403453689,0.967683996675593,
            0.967628589897497,0.967573183119402,0.967517776341306,0.96746236956321,
            0.967406962785114,0.967351556007018,0.967296149228922,0.967240742450826,
            0.967185335672731,0.967129928894635,0.967074522116539,0.967019115338443,
            0.966963708560347,0.966908301782251,0.966852895004155,0.96679748822606,
            0.966742081447964,0.966686674669868,0.966631267891772,0.966575861113676,
            0.96652045433558,0.966465047557485,0.966409640779389,0.966354234001293,
            0.966298827223197,0.966243420445101,0.966188013667005,0.966132606888909,
            0.966077200110814,0.966021793332718,0.965966386554622,0.965910979776526,
            0.96585557299843,0.965800166220334,0.965744759442238,0.965689352664143,
            0.965633945886047,0.965578539107951,0.965523132329855,0.965467725551759,
            0.965412318773663,0.965356911995568,0.965301505217472,0.965246098439376,
            0.96519069166128,0.965135284883184,0.965079878105088,0.965024471326992,
            0.964969064548897,0.964913657770801,0.964858250992705,0.964802844214609,
            0.964747437436513,0.964692030658417,0.964636623880321,0.964581217102226,
            0.96452581032413,0.964470403546034,0.964414996767938,0.964359589989842,
            0.964304183211746,0.96424877643365,0.964193369655555,0.964137962877459,
            0.964082556099363,0.964027149321267,0.963971742543171,0.963916335765075,
            0.963860928986979,0.963805522208884,0.963750115430788,0.963694708652692,
            0.963639301874596,0.9635838950965,0.963528488318404,0.963473081540308,
            0.963417674762213,0.963362267984117,0.963306861206021,0.963251454427925,
            0.963196047649829,0.963140640871733,0.963085234093637,0.963029827315542,
            0.962974420537446,0.96291901375935,0.962863606981254,0.962808200203158,
            0.962752793425062,0.962697386646966,0.962641979868871,0.962586573090775,
            0.962531166312679,0.962475759534583,0.962420352756487,0.962364945978391,
            0.962309539200295,0.9622541324222,0.962198725644104,0.962143318866008,
            0.962087912087912,0.962032505309816,0.96197709853172,0.961921691753625,
            0.961866284975529,0.961810878197433,0.961755471419337,0.961700064641241,
            0.961644657863145,0.961589251085049,0.961533844306954,0.961478437528858,
            0.961423030750762,0.961367623972666,0.96131221719457,0.961256810416474,
            0.961201403638378,0.961145996860283,0.961090590082187,0.961035183304091,
            0.960979776525995,0.960924369747899,0.960868962969803,0.960813556191707,
            0.960758149413612,0.960702742635516,0.96064733585742,0.960591929079324,
            0.960536522301228,0.960481115523132,0.960425708745037,0.960370301966941,
            0.960314895188845,0.960259488410749,0.960204081632653,0.960148674854557,
            0.960093268076461,0.960037861298366,0.95998245452027,0.959927047742174,
            0.959871640964078,0.959816234185982,0.959760827407886,0.95970542062979,
            0.959650013851695,0.959594607073599,0.959539200295503,0.959483793517407,
            0.959428386739311,0.959372979961215,0.959317573183119,0.959262166405024,
            0.959206759626928,0.959151352848832,0.959095946070736,0.95904053929264,
            0.958985132514544,0.958929725736448,0.958874318958353,0.958818912180257,
            0.958763505402161,0.958708098624065,0.958652691845969,0.958597285067873,
            0.958541878289777,0.958486471511682,0.958431064733586,0.95837565795549,
            0.958320251177394,0.958264844399298,0.958209437621202,0.958154030843106,
            0.958098624065011,0.958043217286915,0.957987810508819,0.957932403730723,
            0.957876996952627,0.957821590174531,0.957766183396435,0.95771077661834,
            0.957655369840244,0.957599963062148,0.957544556284052,0.957489149505956,
            0.95743374272786,0.957378335949765,0.957322929171669,0.957267522393573,
            0.957212115615477,0.957156708837381,0.957101302059285,0.957045895281189,
            0.956990488503094,0.956935081724998,0.956879674946902,0.956824268168806,
            0.95676886139071,0.956713454612614,0.956658047834518,0.956602641056423,
            0.956547234278327,0.956491827500231,0.956436420722135,0.956381013944039,
            0.956325607165943,0.956270200387847,0.956214793609752,0.956159386831656,
            0.95610398005356,0.956048573275464,0.955993166497368,0.955937759719272,
            0.955882352941177,0.955826946163081,0.955771539384985,0.955716132606889,
            0.955660725828793,0.955605319050697,0.955549912272601,0.955494505494506,
            0.95543909871641,0.955383691938314,0.955328285160218,0.955272878382122,
            0.955217471604026,0.95516206482593,0.955106658047835,0.955051251269739,
            0.954995844491643,0.954940437713547,0.954885030935451,0.954829624157355,
            0.954774217379259,0.954718810601164,0.954663403823068,0.954607997044972,
            0.954552590266876,0.95449718348878,0.954441776710684,0.954386369932588,
            0.954330963154493,0.954275556376397,0.954220149598301,0.954164742820205,
            0.954109336042109,0.954053929264013,0.953998522485917,0.953943115707822,
            0.953887708929726,0.95383230215163,0.953776895373534,0.953721488595438,
            0.953666081817342,0.953610675039246,0.953555268261151,0.953499861483055,
            0.953444454704959,0.953389047926863,0.953333641148767,0.953278234370671,
            0.953222827592575,0.95316742081448,0.953112014036384,0.953056607258288,
            0.953001200480192,0.952945793702096,0.952890386924,0.952834980145905,
            0.952779573367809,0.952724166589713,0.952668759811617,0.952613353033521,
            0.952557946255425,0.952502539477329,0.952447132699234,0.952391725921138,
            0.952336319143042,0.952280912364946,0.95222550558685,0.952170098808754,
            0.952114692030658,0.952059285252563,0.952003878474467,0.951948471696371,
            0.951893064918275,0.951837658140179,0.951782251362083,0.951726844583987,
            0.951671437805892,0.951616031027796,0.9515606242497,0.951505217471604,
            0.951449810693508,0.951394403915412,0.951338997137317,0.951283590359221,
            0.951228183581125,0.951172776803029,0.951117370024933,0.951061963246837,
            0.951006556468741,0.950951149690646,0.95089574291255,0.950840336134454,
            0.950784929356358,0.950729522578262,0.950674115800166,0.95061870902207,
            0.950563302243975,0.950507895465879,0.950452488687783,0.950397081909687,
            0.950341675131591,0.950286268353495,0.950230861575399,0.950175454797304,
            0.950120048019208,0.950064641241112,0.950009234463016,0.94995382768492,
            0.949898420906824,0.949843014128728,0.949787607350633,0.949732200572537,
            0.949676793794441,0.949621387016345,0.949565980238249,0.949510573460153,
            0.949455166682057,0.949399759903962,0.949344353125866,0.94928894634777,
            0.949233539569674,0.949178132791578,0.949122726013482,0.949067319235386,
            0.949011912457291,0.948956505679195,0.948901098901099,0.948845692123003,
            0.948790285344907,0.948734878566811,0.948679471788715,0.94862406501062,
            0.948568658232524,0.948513251454428,0.948457844676332,0.948402437898236,
            0.94834703112014,0.948291624342045,0.948236217563949,0.948180810785853,
            0.948125404007757,0.948069997229661,0.948014590451565,0.947959183673469,
            0.947903776895374,0.947848370117278,0.947792963339182,0.947737556561086,
            0.94768214978299,0.947626743004894,0.947571336226798,0.947515929448703,
            0.947460522670607,0.947405115892511,0.947349709114415,0.947294302336319,
            0.947238895558223,0.947183488780127,0.947128082002032,0.947072675223936,
            0.94701726844584,0.946961861667744,0.946906454889648,0.946851048111552,
            0.946795641333457,0.946740234555361,0.946684827777265,0.946629420999169,
            0.946574014221073,0.946518607442977,0.946463200664881,0.946407793886786,
            0.94635238710869,0.946296980330594,0.946241573552498,0.946186166774402,
            0.946130759996306,0.94607535321821,0.946019946440115,0.945964539662019,
            0.945909132883923,0.945853726105827,0.945798319327731,0.945742912549635,
            0.945687505771539,0.945632098993444,0.945576692215348,0.945521285437252,
            0.945465878659156,0.94541047188106,0.945355065102964,0.945299658324868,
            0.945244251546773,0.945188844768677,0.945133437990581,0.945078031212485,
            0.945022624434389,0.944967217656293,0.944911810878197,0.944856404100102,
            0.944800997322006,0.94474559054391,0.944690183765814,0.944634776987718,
            0.944579370209622,0.944523963431526,0.944468556653431,0.944413149875335,
            0.944357743097239,0.944302336319143,0.944246929541047,0.944191522762951,
            0.944136115984855,0.94408070920676,0.944025302428664,0.943969895650568,
            0.943914488872472,0.943859082094376,0.94380367531628,0.943748268538184,
            0.943692861760089,0.943637454981993,0.943582048203897,0.943526641425801,
            0.943471234647705,0.943415827869609,0.943360421091514,0.943305014313418,
            0.943249607535322,0.943194200757226,0.94313879397913,0.943083387201034,
            0.943027980422938,0.942972573644843,0.942917166866747,0.942861760088651,
            0.942806353310555,0.942750946532459,0.942695539754363,0.942640132976267,
            0.942584726198172,0.942529319420076,0.94247391264198,0.942418505863884,
            0.942363099085788,0.942307692307692,0.942252285529597,0.942196878751501,
            0.942141471973405,0.942086065195309,0.942030658417213,0.941975251639117,
            0.941919844861021,0.941864438082926,0.94180903130483,0.941753624526734,
            0.941698217748638,0.941642810970542,0.941587404192446,0.94153199741435,
            0.941476590636255,0.941421183858159,0.941365777080063,0.941310370301967,
            0.941254963523871,0.941199556745775,0.941144149967679,0.941088743189584,
            0.941033336411488,0.940977929633392,0.940922522855296,0.9408671160772,
            0.940811709299104,0.940756302521008,0.940700895742913,0.940645488964817,
            0.940590082186721,0.940534675408625,0.940479268630529,0.940423861852433,
            0.940368455074337,0.940313048296242,0.940257641518146,0.94020223474005,
            0.940146827961954,0.940091421183858,0.940036014405762,0.939980607627666,
            0.939925200849571,0.939869794071475,0.939814387293379,0.939758980515283,
            0.939703573737187,0.939648166959091,0.939592760180995,0.9395373534029,
            0.939481946624804,0.939426539846708,0.939371133068612,0.939315726290516,
            0.93926031951242,0.939204912734324,0.939149505956229,0.939094099178133,
            0.939038692400037,0.938983285621941,0.938927878843845,0.938872472065749,
            0.938817065287654,0.938761658509558,0.938706251731462,0.938650844953366,
            0.93859543817527,0.938540031397174,0.938484624619078,0.938429217840983,
            0.938373811062887,0.938318404284791,0.938262997506695,0.938207590728599,
            0.938152183950503,0.938096777172407,0.938041370394312,0.937985963616216,
            0.93793055683812,0.937875150060024,0.937819743281928,0.937764336503832,
            0.937708929725736,0.937653522947641,0.937598116169545,0.937542709391449,
            0.937487302613353,0.937431895835257,0.937376489057161,0.937321082279066,
            0.93726567550097,0.937210268722874,0.937154861944778,0.937099455166682,
            0.937044048388586,0.93698864161049,0.936933234832395,0.936877828054299,
            0.936822421276203,0.936767014498107,0.936711607720011,0.936656200941915,
            0.936600794163819,0.936545387385724,0.936489980607628,0.936434573829532,
            0.936379167051436,0.93632376027334,0.936268353495244,0.936212946717148,
            0.936157539939053,0.936102133160957,0.936046726382861,0.935991319604765,
            0.935935912826669,0.935880506048573,0.935825099270477,0.935769692492382,
            0.935714285714286,0.93565887893619,0.935603472158094,0.935548065379998,
            0.935492658601902,0.935437251823806,0.935381845045711,0.935326438267615,
            0.935271031489519,0.935215624711423,0.935160217933327,0.935104811155231,
            0.935049404377135,0.93499399759904,0.934938590820944,0.934883184042848,
            0.934827777264752,0.934772370486656,0.93471696370856,0.934661556930464,
            0.934606150152369,0.934550743374273,0.934495336596177,0.934439929818081,
            0.934384523039985,0.934329116261889,0.934273709483794,0.934218302705698,
            0.934162895927602,0.934107489149506,0.93405208237141,0.933996675593314,
            0.933941268815218,0.933885862037123,0.933830455259027,0.933775048480931,
            0.933719641702835,0.933664234924739,0.933608828146643,0.933553421368547,
            0.933498014590452,0.933442607812356,0.93338720103426,0.933331794256164,
            0.933276387478068,0.933220980699972,0.933165573921876,0.933110167143781,
            0.933054760365685,0.932999353587589,0.932943946809493,0.932888540031397,
            0.932833133253301,0.932777726475206,0.93272231969711,0.932666912919014,
            0.932611506140918,0.932556099362822,0.932500692584726,0.93244528580663,
            0.932389879028535,0.932334472250439,0.932279065472343,0.932223658694247,
            0.932168251916151,0.932112845138055,0.932057438359959,0.932002031581864,
            0.931946624803768,0.931891218025672,0.931835811247576,0.93178040446948,
            0.931724997691384,0.931669590913288,0.931614184135193,0.931558777357097,
            0.931503370579001,0.931447963800905,0.931392557022809,0.931337150244713,
            0.931281743466617,0.931226336688522,0.931170929910426,0.93111552313233,
            0.931060116354234,0.931004709576138,0.930949302798042,0.930893896019946,
            0.930838489241851,0.930783082463755,0.930727675685659,0.930672268907563,
            0.930616862129467,0.930561455351371,0.930506048573275,0.93045064179518,
            0.930395235017084,0.930339828238988,0.930284421460892,0.930229014682796,
            0.9301736079047,0.930118201126604,0.930062794348509,0.930007387570413,
            0.929951980792317,0.929896574014221,0.929841167236125,0.929785760458029,
            0.929730353679934,0.929674946901838,0.929619540123742,0.929564133345646,
            0.92950872656755,0.929453319789454,0.929397913011358,0.929342506233263,
            0.929287099455167,0.929231692677071,0.929176285898975,0.929120879120879,
            0.929065472342783,0.929010065564687,0.928954658786592,0.928899252008496,
            0.9288438452304,0.928788438452304,0.928733031674208,0.928677624896112,
            0.928622218118016,0.928566811339921,0.928511404561825,0.928455997783729,
            0.928400591005633,0.928345184227537,0.928289777449441,0.928234370671346,
            0.92817896389325,0.928123557115154,0.928068150337058,0.928012743558962,
            0.927957336780866,0.92790193000277,0.927846523224675,0.927791116446579,
            0.927735709668483,0.927680302890387,0.927624896112291,0.927569489334195,
            0.927514082556099,0.927458675778004,0.927403268999908,0.927347862221812,
            0.927292455443716,0.92723704866562,0.927181641887524,0.927126235109428,
            0.927070828331333,0.927015421553237,0.926960014775141,0.926904607997045,
            0.926849201218949,0.926793794440853,0.926738387662757,0.926682980884662,
            0.926627574106566,0.92657216732847,0.926516760550374,0.926461353772278,
            0.926405946994182,0.926350540216086,0.926295133437991,0.926239726659895,
            0.926184319881799,0.926128913103703,0.926073506325607,0.926018099547511,
            0.925962692769415,0.92590728599132,0.925851879213224,0.925796472435128,
            0.925741065657032,0.925685658878936,0.92563025210084,0.925574845322744,
            0.925519438544649,0.925464031766553,0.925408624988457,0.925353218210361,
            0.925297811432265,0.925242404654169,0.925186997876074,0.925131591097978,
            0.925076184319882,0.925020777541786,0.92496537076369,0.924909963985594,
            0.924854557207498,0.924799150429403,0.924743743651307,0.924688336873211,
            0.924632930095115,0.924577523317019,0.924522116538923,0.924466709760827,
            0.924411302982732,0.924355896204636,0.92430048942654,0.924245082648444,
            0.924189675870348,0.924134269092252,0.924078862314156,0.924023455536061,
            0.923968048757965,0.923912641979869,0.923857235201773,0.923801828423677,
            0.923746421645581,0.923598670237326,0.92345091882907,0.923303167420815,
            0.923155416012559,0.923007664604303,0.922859913196048,0.922712161787792,
            0.922564410379536,0.922416658971281,0.922268907563025,0.92212115615477,
            0.921973404746514,0.921825653338258,0.921677901930003,0.921530150521747,
            0.921382399113492,0.921234647705236,0.92108689629698,0.920939144888725,
            0.920791393480469,0.920643642072213,0.920495890663958,0.920348139255702,
            0.920200387847447,0.920052636439191,0.919904885030935,0.91975713362268,
            0.919609382214424,0.919461630806169,0.919313879397913,0.919166127989657,
            0.919018376581402,0.918870625173146,0.918722873764891,0.918575122356635,
            0.918427370948379,0.918279619540124,0.918131868131868,0.917984116723613,
            0.917836365315357,0.917688613907101,0.917540862498846,0.91739311109059,
            0.917245359682334,0.917097608274079,0.916949856865823,0.916802105457568,
            0.916654354049312,0.916506602641056,0.916358851232801,0.916211099824545,
            0.91606334841629,0.915915597008034,0.915767845599778,0.915620094191523,
            0.915472342783267,0.915324591375012,0.915176839966756,0.9150290885585,
            0.914881337150245,0.914733585741989,0.914585834333734,0.914438082925478,
            0.914290331517222,0.914142580108967,0.913994828700711,0.913847077292455,
            0.9136993258842,0.913551574475944,0.913403823067689,0.913256071659433,
            0.913108320251177,0.912960568842922,0.912812817434666,0.912665066026411,
            0.912517314618155,0.912369563209899,0.912221811801644,0.912074060393388,
            0.911926308985132,0.911778557576877,0.911630806168621,0.911483054760366,
            0.91133530335211,0.911187551943854,0.911039800535599,0.910892049127343,
            0.910744297719088,0.910596546310832,0.910448794902576,0.910301043494321,
            0.910153292086065,0.91000554067781,0.909857789269554,0.909710037861298,
            0.909562286453043,0.909414535044787,0.909266783636532,0.909119032228276,
            0.90897128082002,0.908823529411765,0.908675778003509,0.908528026595253,
            0.908380275186998,0.908232523778742,0.908084772370487,0.907937020962231,
            0.907789269553975,0.90764151814572,0.907493766737464,0.907346015329209,
            0.907198263920953,0.907050512512697,0.906902761104442,0.906755009696186,
            0.906607258287931,0.906459506879675,0.906311755471419,0.906164004063164,
            0.906016252654908,0.905868501246653,0.905720749838397,0.905572998430141,
            0.905425247021886,0.90527749561363,0.905129744205375,0.904981992797119,
            0.904834241388863,0.904686489980608,0.904538738572352,0.904390987164096,
            0.904243235755841,0.904095484347585,0.90394773293933,0.903799981531074,
            0.903652230122818,0.903504478714563,0.903356727306307,0.903208975898051,
            0.903061224489796,0.90291347308154,0.902765721673285,0.902617970265029,
            0.902470218856773,0.902322467448518,0.902174716040262,0.902026964632007,
            0.901879213223751,0.901731461815495,0.90158371040724,0.901435958998984,
            0.901288207590729,0.901140456182473,0.900992704774217,0.900844953365962,
            0.900697201957706,0.900549450549451,0.900401699141195,0.900253947732939,
            0.900106196324684,0.899958444916428,0.899810693508173,0.899662942099917,
            0.899515190691661,0.899367439283406,0.89921968787515,0.899071936466894,
            0.898924185058639,0.898776433650383,0.898628682242128,0.898480930833872,
            0.898333179425616,0.898185428017361,0.898037676609105,0.89788992520085,
            0.897742173792594,0.897594422384338,0.897446670976083,0.897298919567827,
            0.897151168159572,0.897003416751316,0.89685566534306,0.896707913934805,
            0.896560162526549,0.896412411118294,0.896264659710038,0.896116908301782,
            0.895969156893527,0.895821405485271,0.895673654077015,0.89552590266876,
            0.895378151260504,0.895230399852249,0.895082648443993,0.894934897035737,
            0.894787145627482,0.894639394219226,0.89449164281097,0.894343891402715,
            0.894196139994459,0.894048388586204,0.893900637177948,0.893752885769692,
            0.893605134361437,0.893457382953181,0.893309631544926,0.89316188013667,
            0.893014128728414,0.892866377320159,0.892718625911903,0.892570874503648,
            0.892423123095392,0.892275371687136,0.892127620278881,0.891979868870625,
            0.89183211746237,0.891684366054114,0.891536614645858,0.891388863237603,
            0.891241111829347,0.891093360421092,0.890945609012836,0.89079785760458,
            0.890650106196325,0.890502354788069,0.890354603379813,0.890206851971558,
            0.890059100563302,0.889911349155047,0.889763597746791,0.889615846338535,
            0.88946809493028,0.889320343522024,0.889172592113769,0.889024840705513,
            0.888877089297257,0.888729337889002,0.888581586480746,0.888433835072491,
            0.888286083664235,0.888138332255979,0.887990580847724,0.887842829439468,
            0.887695078031213,0.887547326622957,0.887399575214701,0.887251823806446,
            0.88710407239819,0.886956320989934,0.886808569581679,0.886660818173423,
            0.886513066765168,0.886365315356912,0.886217563948656,0.886069812540401,
            0.885922061132145,0.88577430972389,0.885626558315634,0.885478806907378,
            0.885331055499123,0.885183304090867,0.885035552682611,0.884887801274356,
            0.8847400498661,0.884592298457845,0.884444547049589,0.884296795641333,
            0.884149044233078,0.884001292824822,0.883853541416567,0.883705790008311,
            0.883558038600055,0.8834102871918,0.883262535783544,0.883114784375289,
            0.882967032967033,0.882819281558777,0.882671530150522,0.882523778742266,
            0.882376027334011,0.882228275925755,0.882080524517499,0.881932773109244,
            0.881785021700988,0.881637270292732,0.881489518884477,0.881341767476221,
            0.881194016067966,0.88104626465971,0.880898513251454,0.880750761843199,
            0.880603010434943,0.880455259026688,0.880307507618432,0.880159756210176,
            0.880012004801921,0.879864253393665,0.87971650198541,0.879568750577154,
            0.879420999168898,0.879273247760643,0.879125496352387,0.878977744944132,
            0.878829993535876,0.87868224212762,0.878534490719365,0.878386739311109,
            0.878238987902853,0.878091236494598,0.877943485086342,0.877795733678087,
            0.877647982269831,0.877500230861575,0.87735247945332,0.877204728045064,
            0.877056976636809,0.876909225228553,0.876761473820297,0.876613722412042,
            0.876465971003786,0.87631821959553,0.876170468187275,0.876022716779019,
            0.875874965370764,0.875727213962508,0.875579462554252,0.875431711145997,
            0.875283959737741,0.875136208329486,0.87498845692123,0.874840705512974,
            0.874692954104719,0.874545202696463,0.874397451288208,0.874249699879952,
            0.874101948471696,0.873954197063441,0.873806445655185,0.87365869424693,
            0.873510942838674,0.873363191430418,0.873215440022163,0.873067688613907,
            0.872919937205652,0.872772185797396,0.87262443438914,0.872476682980885,
            0.872328931572629,0.872181180164373,0.872033428756118,0.871885677347862,
            0.871737925939607,0.871590174531351,0.871442423123095,0.87129467171484,
            0.871146920306584,0.870999168898329,0.870851417490073,0.870703666081817,
            0.870555914673562,0.870408163265306,0.87026041185705,0.870112660448795,
            0.869964909040539,0.869817157632284,0.869669406224028,0.869521654815772,
            0.869373903407517,0.869226151999261,0.869078400591006,0.86893064918275,
            0.868782897774494,0.868635146366239,0.868487394957983,0.868339643549728,
            0.868191892141472,0.868044140733216,0.867896389324961,0.867748637916705,
            0.86760088650845,0.867453135100194,0.867305383691938,0.867157632283683,
            0.867009880875427,0.866862129467171,0.866714378058916,0.86656662665066,
            0.866418875242405,0.866271123834149,0.866123372425893,0.865975621017638,
            0.865827869609382,0.865680118201127,0.865532366792871,0.865384615384615,
            0.86523686397636,0.865089112568104,0.864941361159849,0.864793609751593,
            0.864645858343337,0.864498106935082,0.864350355526826,0.864202604118571,
            0.864054852710315,0.863907101302059,0.863759349893804,0.863611598485548,
            0.863463847077292,0.863316095669037,0.863168344260781,0.863020592852526,
            0.86287284144427,0.862725090036014,0.862577338627759,0.862429587219503,
            0.862281835811248,0.862134084402992,0.861986332994736,0.861838581586481,
            0.861690830178225,0.861543078769969,0.861395327361714,0.861247575953458,
            0.861099824545203,0.860952073136947,0.860804321728691,0.860656570320436,
            0.86050881891218,0.860361067503925,0.860213316095669,0.860065564687413,
            0.859917813279158,0.859770061870902,0.859622310462647,0.859474559054391,
            0.859326807646135,0.85917905623788,0.859031304829624,0.858883553421369,
            0.858735802013113,0.858588050604857,0.858440299196602,0.858292547788346,
            0.85814479638009,0.857997044971835,0.857849293563579,0.857701542155324,
            0.857553790747068,0.857406039338812,0.857258287930557,0.857110536522301,
            0.856962785114046,0.85681503370579,0.856667282297534,0.856519530889279,
            0.856371779481023,0.856224028072768,0.856076276664512,0.855928525256256,
            0.855780773848001,0.855633022439745,0.85548527103149,0.855337519623234,
            0.855189768214978,0.855042016806723,0.854894265398467,0.854746513990212,
            0.854598762581956,0.8544510111737,0.854303259765445,0.854155508357189,
            0.854007756948933,0.853860005540678,0.853712254132422,0.853564502724167,
            0.853416751315911,0.853268999907655,0.8531212484994,0.852973497091144,
            0.852825745682888,0.852677994274633,0.852530242866377,0.852382491458122,
            0.852234740049866,0.85208698864161,0.851939237233355,0.851791485825099,
            0.851643734416844,0.851495983008588,0.851348231600332,0.851200480192077,
            0.851052728783821,0.850904977375566,0.85075722596731,0.850609474559054,
            0.850461723150799,0.850313971742543,0.850166220334288,0.850018468926032,
            0.849870717517776,0.849722966109521,0.849575214701265,0.84942746329301,
            0.849279711884754,0.849131960476498,0.848984209068243,0.848836457659987,
            0.848688706251731,0.848540954843476,0.84839320343522,0.848245452026965,
            0.848097700618709,0.847949949210453,0.847802197802198,0.847654446393942,
            0.847506694985687,0.847358943577431,0.847211192169175,0.84706344076092,
            0.846915689352664,0.846767937944409,0.846620186536153,0.846472435127897,
            0.846324683719642,0.846176932311386,0.846029180903131,0.845881429494875,
            0.845733678086619,0.845585926678364,0.845438175270108,0.845290423861852,
            0.845142672453597,0.844994921045341,0.844847169637086,0.84469941822883,
            0.844551666820574,0.844403915412319,0.844256164004063,0.844108412595808,
            0.843960661187552,0.843812909779296,0.843665158371041,0.843517406962785,
            0.843369655554529,0.843221904146274,0.843074152738018,0.842926401329763,
            0.842778649921507,0.842630898513251,0.842483147104996,0.84233539569674,
            0.842187644288485,0.842039892880229,0.841892141471973,0.841744390063718,
            0.841596638655462,0.841448887247207,0.841301135838951,0.841153384430695,
            0.84100563302244,0.840857881614184,0.840710130205929,0.840562378797673,
            0.840414627389417,0.840266875981162,0.840119124572906,0.83997137316465,
            0.839823621756395,0.839675870348139,0.839528118939884,0.839380367531628,
            0.839232616123372,0.839084864715117,0.838937113306861,0.838789361898606,
            0.83864161049035,0.838493859082094,0.838346107673839,0.838198356265583,
            0.838050604857328,0.837902853449072,0.837755102040816,0.837607350632561,
            0.837459599224305,0.83731184781605,0.837164096407794,0.837016344999538,
            0.836868593591283,0.836720842183027,0.836573090774771,0.836425339366516,
            0.83627758795826,0.836129836550005,0.835982085141749,0.835834333733493,
            0.835686582325238,0.835538830916982,0.835391079508727,0.835243328100471,
            0.835095576692215,0.83494782528396,0.834800073875704,0.834652322467448,
            0.834504571059193,0.834356819650937,0.834209068242682,0.834061316834426,
            0.83391356542617,0.833765814017915,0.833618062609659,0.833470311201404,
            0.833322559793148,0.833174808384892,0.833027056976637,0.832879305568381,
            0.832731554160126,0.83258380275187,0.832436051343614,0.832288299935359,
            0.832140548527103,0.831992797118848,0.831845045710592,0.831697294302336,
            0.831549542894081,0.831401791485825,0.83125404007757,0.831106288669314,
            0.830958537261058,0.830810785852803,0.830663034444547,0.830515283036291,
            0.830367531628036,0.83021978021978,0.830072028811525,0.829924277403269,
            0.829776525995013,0.829628774586758,0.829481023178502,0.829333271770247,
            0.829185520361991,0.829037768953735,0.82889001754548,0.828742266137224,
            0.828594514728969,0.828446763320713,0.828299011912457,0.828151260504202,
            0.828003509095946,0.82785575768769,0.827708006279435,0.827560254871179,
            0.827412503462924,0.827264752054668,0.827117000646412,0.826969249238157,
            0.826821497829901,0.826673746421646,0.82652599501339,0.826378243605134,
            0.826230492196879,0.826082740788623,0.825934989380368,0.825787237972112,
            0.825639486563856,0.825491735155601,0.825343983747345,0.825196232339089,
            0.825048480930834,0.824900729522578,0.824752978114323,0.824605226706067,
            0.824457475297811,0.824309723889556,0.8241619724813,0.824014221073045,
            0.823866469664789,0.823718718256533,0.823570966848278,0.823423215440022,
            0.823275464031767,0.823127712623511,0.822979961215255,0.822832209807,
            0.822684458398744,0.822536706990489,0.822388955582233,0.822241204173977,
            0.822093452765722,0.821945701357466,0.82179794994921,0.821650198540955,
            0.821502447132699,0.821354695724444,0.821206944316188,0.821059192907932,
            0.820911441499677,0.820763690091421,0.820615938683166,0.82046818727491,
            0.820320435866654,0.820172684458399,0.820024933050143,0.819877181641887,
            0.819729430233632,0.819581678825376,0.819433927417121,0.819286176008865,
            0.819138424600609,0.818990673192354,0.818842921784098,0.818695170375843,
            0.818547418967587,0.818399667559331,0.818251916151076,0.81810416474282,
            0.817956413334565,0.817808661926309,0.817660910518053,0.817513159109798,
            0.817365407701542,0.817217656293287,0.817069904885031,0.816922153476775,
            0.81677440206852,0.816626650660264,0.816478899252008,0.816331147843753,
            0.816183396435497,0.816035645027242,0.815887893618986,0.81574014221073,
            0.815592390802475,0.815444639394219,0.815296887985964,0.815149136577708,
            0.815001385169452,0.814853633761197,0.814705882352941,0.814558130944686,
            0.81441037953643,0.814262628128174,0.814114876719919,0.813967125311663,
            0.813819373903408,0.813671622495152,0.813523871086896,0.813376119678641,
            0.813228368270385,0.81308061686213,0.812932865453874,0.812785114045618,
            0.812637362637363,0.812489611229107,0.812341859820851,0.812194108412596,
            0.81204635700434,0.811898605596085,0.811750854187829,0.811603102779573,
            0.811455351371318,0.811307599963062,0.811159848554806,0.811012097146551,
            0.810864345738295,0.81071659433004,0.810568842921784,0.810421091513528,
            0.810273340105273,0.810125588697017,0.809977837288762,0.809830085880506,
            0.80968233447225,0.809534583063995,0.809386831655739,0.809239080247484,
            0.809091328839228,0.808943577430972,0.808795826022717,0.808648074614461,
            0.808500323206206,0.80835257179795,0.808204820389694,0.808057068981439,
            0.807909317573183,0.807761566164928,0.807613814756672,0.807466063348416,
            0.807318311940161,0.807170560531905,0.807022809123649,0.806875057715394,
            0.806727306307138,0.806579554898883,0.806431803490627,0.806284052082371,
            0.806136300674116,0.80598854926586,0.805840797857605,0.805693046449349,
            0.805545295041093,0.805397543632838,0.805249792224582,0.805102040816327,
            0.804954289408071,0.804806537999815,0.80465878659156,0.804511035183304,
            0.804363283775049,0.804215532366793,0.804067780958537,0.803920029550282,
            0.803772278142026,0.80362452673377,0.803476775325515,0.803329023917259,
            0.803181272509004,0.803033521100748,0.802885769692492,0.802738018284237,
            0.802590266875981,0.802442515467726,0.80229476405947,0.802147012651214,
            0.801999261242959,0.801851509834703,0.801703758426447,0.801556007018192,
            0.801408255609936,0.801260504201681,0.801112752793425,0.800965001385169,
            0.800817249976914,0.800669498568658,0.800521747160403,0.800373995752147,
            0.800226244343891,0.800078492935636,0.79993074152738,0.799782990119125,
            0.799635238710869,0.799487487302613,0.799339735894358,0.799191984486102,
            0.799044233077847,0.798896481669591,0.798748730261335,0.79860097885308,
            0.798453227444824,0.798305476036568,0.798157724628313,0.798009973220057,
            0.797862221811802,0.797714470403546,0.79756671899529,0.797418967587035,
            0.797271216178779,0.797123464770524,0.796975713362268,0.796827961954012,
            0.796680210545757,0.796532459137501,0.796384707729246,0.79623695632099,
            0.796089204912734,0.795941453504479,0.795793702096223,0.795645950687968,
            0.795498199279712,0.795350447871456,0.795202696463201,0.795054945054945,
            0.794907193646689,0.794759442238434,0.794611690830178,0.794463939421923,
            0.794316188013667,0.794168436605411,0.794020685197156,0.7938729337889,
            0.793725182380645,0.793577430972389,0.793429679564133,0.793281928155878,
            0.793134176747622,0.792986425339366,0.792838673931111,0.792690922522855,
            0.7925431711146,0.792395419706344,0.792247668298088,0.792099916889833,
            0.791952165481577,0.791804414073322,0.791656662665066,0.79150891125681,
            0.791361159848555,0.791213408440299,0.791065657032044,0.790917905623788,
            0.790770154215532,0.790622402807277,0.790474651399021,0.790326899990766,
            0.79017914858251,0.790031397174254,0.789883645765999,0.789735894357743,
            0.789588142949488,0.789440391541232,0.789292640132976,0.789144888724721,
            0.788997137316465,0.788849385908209,0.788701634499954,0.788553883091698,
            0.788406131683443,0.788258380275187,0.788110628866931,0.787962877458676,
            0.78781512605042,0.787667374642165,0.787519623233909,0.787371871825653,
            0.787224120417398,0.787076369009142,0.786928617600887,0.786780866192631,
            0.786633114784375,0.78648536337612,0.786337611967864,0.786189860559608,
            0.786042109151353,0.785894357743097,0.785746606334842,0.785598854926586,
            0.78545110351833,0.785303352110075,0.785155600701819,0.785007849293564,
            0.784860097885308,0.784712346477052,0.784564595068797,0.784416843660541,
            0.784269092252286,0.78412134084403,0.783973589435774,0.783825838027519,
            0.783678086619263,0.783530335211007,0.783382583802752,0.783234832394496,
            0.783087080986241,0.782939329577985,0.782791578169729,0.782643826761474,
            0.782496075353218,0.782348323944963,0.782200572536707,0.782052821128451,
            0.781905069720196,0.78175731831194,0.781609566903685,0.781461815495429,
            0.781314064087173,0.781166312678918,0.781018561270662,0.780870809862407,
            0.780723058454151,0.780575307045895,0.78042755563764,0.780279804229384,
            0.780132052821128,0.779984301412873,0.779836550004617,0.779688798596362,
            0.779541047188106,0.77939329577985,0.779245544371595,0.779097792963339,
            0.778950041555084,0.778802290146828,0.778654538738572,0.778506787330317,
            0.778359035922061,0.778211284513806,0.77806353310555,0.777915781697294,
            0.777768030289039,0.777620278880783,0.777472527472527,0.777324776064272,
            0.777177024656016,0.777029273247761,0.776881521839505,0.776733770431249,
            0.776586019022994,0.776438267614738,0.776290516206483,0.776142764798227,
            0.775995013389971,0.775847261981716,0.77569951057346,0.775551759165205,
            0.775404007756949,0.775256256348693,0.775108504940438,0.774960753532182,
            0.774813002123926,0.774665250715671,0.774517499307415,0.77436974789916,
            0.774221996490904,0.774074245082648,0.773926493674393,0.773778742266137,
            0.773630990857882,0.773483239449626,0.77333548804137,0.773187736633115,
            0.773039985224859,0.772892233816604,0.772744482408348,0.772596731000092,
            0.772448979591837,0.772301228183581,0.772153476775326,0.77200572536707,
            0.771857973958814,0.771710222550559,0.771562471142303,0.771414719734048,
            0.771266968325792,0.771119216917536,0.770971465509281,0.770823714101025,
            0.770675962692769,0.770528211284514,0.770380459876258,0.770232708468003,
            0.770084957059747,0.769937205651491,0.769789454243236,0.76964170283498,
            0.769493951426724,0.769346200018469,0.769198448610213,0.769050697201958,
            0.768902945793702,0.768755194385446,0.768607442977191,0.768459691568935,
            0.76831194016068,0.768164188752424,0.768016437344168,0.767868685935913,
            0.767720934527657,0.767573183119402,0.767425431711146,0.76727768030289,
            0.767129928894635,0.766982177486379,0.766834426078124,0.766686674669868,
            0.766538923261612,0.766391171853357,0.766243420445101,0.766095669036846,
            0.76594791762859,0.765800166220334,0.765652414812079,0.765504663403823,
            0.765356911995567,0.765209160587312,0.765061409179056,0.764913657770801,
            0.764765906362545,0.764618154954289,0.764470403546034,0.764322652137778,
            0.764174900729523,0.764027149321267,0.763879397913011,0.763731646504756,
            0.7635838950965,0.763436143688245,0.763288392279989,0.763140640871733,
            0.762992889463478,0.762845138055222,0.762697386646967,0.762549635238711,
            0.762401883830455,0.7622541324222,0.762106381013944,0.761958629605688,
            0.761810878197433,0.761663126789177,0.761515375380922,0.761367623972666,
            0.76121987256441,0.761072121156155,0.760924369747899,0.760776618339643,
            0.760628866931388,0.760481115523132,0.760333364114877,0.760185612706621,
            0.760037861298365,0.75989010989011,0.759742358481854,0.759594607073599,
            0.759446855665343,0.759299104257087,0.759151352848832,0.759003601440576,
            0.758855850032321,0.758708098624065,0.758560347215809,0.758412595807554,
            0.758264844399298,0.758117092991043,0.757969341582787,0.757821590174531,
            0.757673838766276,0.75752608735802,0.757378335949765,0.757230584541509,
            0.757082833133253,0.756935081724998,0.756787330316742,0.756639578908486,
            0.756491827500231,0.756344076091975,0.75619632468372,0.756048573275464,
            0.755900821867208,0.755753070458953,0.755605319050697,0.755457567642442,
            0.755309816234186,0.75516206482593,0.755014313417675,0.754866562009419,
            0.754718810601164,0.754571059192908,0.754423307784652,0.754275556376397,
            0.754127804968141,0.753980053559886,0.75383230215163,0.753684550743374,
            0.753536799335119,0.753389047926863,0.753241296518607,0.753093545110352,
            0.752945793702096,0.752798042293841,0.752650290885585,0.752502539477329,
            0.752354788069074,0.752207036660818,0.752059285252563,0.751911533844307,
            0.751763782436051,0.751616031027796,0.75146827961954,0.751320528211284,
            0.751172776803029,0.751025025394773,0.750877273986518,0.750729522578262,
            0.750581771170006,0.750434019761751,0.750286268353495,0.75013851694524,
            0.749990765536984,0.749843014128728,0.749695262720473,0.749547511312217,
            0.749399759903962,0.749252008495706,0.74910425708745,0.748956505679195,
            0.748808754270939,0.748661002862684,0.748513251454428,0.748365500046172,
            0.748217748637917,0.748069997229661,0.747922245821406,0.74777449441315,
            0.747626743004894,0.747478991596639,0.747331240188383,0.747183488780127,
            0.747035737371872,0.746887985963616,0.746740234555361,0.746592483147105,
            0.746444731738849,0.746296980330594,0.746149228922338,0.746001477514083,
            0.745853726105827,0.745705974697571,0.745558223289316,0.74541047188106,
            0.745262720472805,0.745114969064549,0.744967217656293,0.744819466248038,
            0.744671714839782,0.744523963431526,0.744376212023271,0.744228460615015,
            0.74408070920676,0.743932957798504,0.743785206390248,0.743637454981993,
            0.743489703573737,0.743341952165482,0.743194200757226,0.74304644934897,
            0.742898697940715,0.742750946532459,0.742603195124203,0.742455443715948,
            0.742307692307692,0.742159940899437,0.742012189491181,0.741864438082925,
            0.74171668667467,0.741568935266414,0.741421183858159,0.741273432449903,
            0.741125681041647,0.740977929633392,0.740830178225136,0.740682426816881,
            0.740534675408625,0.740386924000369,0.740239172592114,0.740091421183858,
            0.739943669775603,0.739795918367347,0.739648166959091,0.739500415550836,
            0.73935266414258,0.739204912734325,0.739057161326069,0.738909409917813,
            0.738761658509558,0.738613907101302,0.738466155693046,0.738318404284791,
            0.738170652876535,0.73802290146828,0.737875150060024,0.737727398651768,
            0.737579647243513,0.737431895835257,0.737284144427002,0.737136393018746,
            0.73698864161049,0.736840890202235,0.736693138793979,0.736545387385724,
            0.736397635977468,0.736249884569212,0.736102133160957,0.735954381752701,
            0.735806630344445,0.73565887893619,0.735511127527934,0.735363376119679,
            0.735215624711423,0.735067873303167,0.734920121894912,0.734772370486656,
            0.734624619078401,0.734476867670145,0.734329116261889,0.734181364853634,
            0.734033613445378,0.733885862037123,0.733738110628867,0.733590359220611,
            0.733442607812356,0.7332948564041,0.733147104995844,0.732999353587589,
            0.732851602179333,0.732703850771078,0.732556099362822,0.732408347954566,
            0.732260596546311,0.732112845138055,0.7319650937298,0.731817342321544,
            0.731669590913288,0.731521839505033,0.731374088096777,0.731226336688522,
            0.731078585280266,0.73093083387201,0.730783082463755,0.730635331055499,
            0.730487579647244,0.730339828238988,0.730192076830732,0.730044325422477,
            0.729896574014221,0.729748822605965,0.72960107119771,0.729453319789454,
            0.729305568381199,0.729157816972943,0.729010065564687,0.728862314156432,
            0.728714562748176,0.728566811339921,0.728419059931665,0.728271308523409,
            0.728123557115154,0.727975805706898,0.727828054298643,0.727680302890387,
            0.727532551482131,0.727384800073876,0.72723704866562,0.727089297257364,
            0.726941545849109,0.726793794440853,0.726646043032598,0.726498291624342,
            0.726350540216086,0.726202788807831,0.726055037399575,0.72590728599132,
            0.725759534583064,0.725611783174808,0.725464031766553,0.725316280358297,
            0.725168528950042,0.725020777541786,0.72487302613353,0.724725274725275,
            0.724577523317019,0.724429771908763,0.724282020500508,0.724134269092252,
            0.723986517683997,0.723838766275741,0.723691014867485,0.72354326345923,
            0.723395512050974,0.723247760642719,0.723100009234463,0.722952257826207,
            0.722804506417952,0.722656755009696,0.722509003601441,0.722361252193185,
            0.722213500784929,0.722065749376674,0.721917997968418,0.721770246560163,
            0.721622495151907,0.721474743743651,0.721326992335396,0.72117924092714,
            0.721031489518885,0.720883738110629,0.720735986702373,0.720588235294118,
            0.720440483885862,0.720292732477606,0.720144981069351,0.719997229661095,
            0.71984947825284,0.719701726844584,0.719553975436328,0.719406224028073,
            0.719258472619817,0.719110721211561,0.718962969803306,0.71881521839505,
            0.718667466986795,0.718519715578539,0.718371964170283,0.718224212762028,
            0.718076461353772,0.717928709945517,0.717780958537261,0.717633207129005,
            0.71748545572075,0.717337704312494,0.717189952904239,0.717042201495983,
            0.716894450087727,0.716746698679472,0.716598947271216,0.716451195862961,
            0.716303444454705,0.716155693046449,0.716007941638194,0.715860190229938,
            0.715712438821683,0.715564687413427,0.715416936005171,0.715269184596916,
            0.71512143318866,0.714973681780404,0.714825930372149,0.714678178963893,
            0.714530427555638,0.714382676147382,0.714234924739126,0.714087173330871,
            0.713939421922615,0.71379167051436,0.713643919106104,0.713496167697848,
            0.713348416289593,0.713200664881337,0.713052913473082,0.712905162064826,
            0.71275741065657,0.712609659248315,0.712461907840059,0.712314156431804,
            0.712166405023548,0.712018653615292,0.711870902207037,0.711723150798781,
            0.711575399390525,0.71142764798227,0.711279896574014,0.711132145165759,
            0.710984393757503,0.710836642349247,0.710688890940992,0.710541139532736,
            0.710393388124481,0.710245636716225,0.710097885307969,0.709950133899714,
            0.709802382491458,0.709654631083202,0.709506879674947,0.709359128266691,
            0.709211376858436,0.70906362545018,0.708915874041924,0.708768122633669,
            0.708620371225413,0.708472619817158,0.708324868408902,0.708177117000646,
            0.708029365592391,0.707881614184135,0.70773386277588,0.707586111367624,
            0.707438359959368,0.707290608551113,0.707142857142857,0.706995105734602,
            0.706847354326346,0.70669960291809,0.706551851509835,0.706404100101579,
            0.706256348693323,0.706108597285068,0.705960845876812,0.705813094468557,
            0.705665343060301,0.705517591652045,0.70536984024379,0.705222088835534,
            0.705074337427279,0.704926586019023,0.704778834610767,0.704631083202512,
            0.704483331794256,0.704335580386001,0.704187828977745,0.704040077569489,
            0.703892326161234,0.703744574752978,0.703596823344723,0.703449071936467,
            0.703301320528211,0.703153569119956,0.7030058177117,0.702858066303444,
            0.702710314895189,0.702562563486933,0.702414812078678,0.702267060670422,
            0.702119309262166,0.701971557853911,0.701823806445655,0.7016760550374,
            0.701528303629144,0.701380552220888,0.701232800812633,0.701085049404377,
            0.700937297996121,0.700789546587866,0.70064179517961,0.700494043771355,
            0.700346292363099,0.700198540954843,0.700050789546588,0.699903038138332,
            0.699755286730077,0.699607535321821,0.699459783913565,0.69931203250531,
            0.699164281097054,0.699016529688799,0.698868778280543,0.698721026872287,
            0.698573275464032,0.698425524055776,0.698277772647521,0.698130021239265,
            0.697982269831009,0.697834518422754,0.697686767014498,0.697539015606243,
            0.697391264197987,0.697243512789731,0.697095761381476,0.69694800997322,
            0.696800258564964,0.696652507156709,0.696504755748453,0.696357004340198,
            0.696209252931942,0.696061501523686,0.695913750115431,0.695765998707175,
            0.69561824729892,0.695470495890664,0.695322744482408,0.695174993074153,
            0.695027241665897,0.694879490257642,0.694731738849386,0.69458398744113,
            0.694436236032875,0.694288484624619,0.694140733216363,0.693992981808108,
            0.693845230399852,0.693697478991597,0.693549727583341,0.693401976175085,
            0.69325422476683,0.693106473358574,0.692958721950319,0.692810970542063,
            0.692663219133807,0.692515467725552,0.692367716317296,0.692219964909041,
            0.692072213500785,0.691924462092529,0.691776710684274,0.691628959276018,
            0.691481207867762,0.691333456459507,0.691185705051251,0.691037953642996,
            0.69089020223474,0.690742450826484,0.690594699418229,0.690446948009973,
            0.690299196601718,0.690151445193462,0.690003693785206,0.689855942376951,
            0.689708190968695,0.68956043956044,0.689412688152184,0.689264936743928,
            0.689117185335673,0.688969433927417,0.688821682519162,0.688673931110906,
            0.68852617970265,0.688378428294395,0.688230676886139,0.688082925477883,
            0.687935174069628,0.687787422661372,0.687639671253117,0.687491919844861,
            0.687344168436605,0.68719641702835,0.687048665620094,0.686900914211839,
            0.686753162803583,0.686605411395327,0.686457659987072,0.686309908578816,
            0.686162157170561,0.686014405762305,0.685866654354049,0.685718902945794,
            0.685571151537538,0.685423400129282,0.685275648721027,0.685127897312771,
            0.684980145904516,0.68483239449626,0.684684643088004,0.684536891679749,
            0.684389140271493,0.684241388863238,0.684093637454982,0.683945886046726,
            0.683798134638471,0.683650383230215,0.68350263182196,0.683354880413704,
            0.683207129005448,0.683059377597193,0.682911626188937,0.682763874780681,
            0.682616123372426,0.68246837196417,0.682320620555915,0.682172869147659,
            0.682025117739403,0.681877366331148,0.681729614922892,0.681581863514637,
            0.681434112106381,0.681286360698125,0.68113860928987,0.680990857881614,
            0.680843106473359,0.680695355065103,0.680547603656847,0.680399852248592,
            0.680252100840336,0.680104349432081,0.679956598023825,0.679808846615569,
            0.679661095207314,0.679513343799058,0.679365592390803,0.679217840982547,
            0.679070089574291,0.678922338166036,0.67877458675778,0.678626835349524,
            0.678479083941269,0.678331332533013,0.678183581124758,0.678035829716502,
            0.677888078308246,0.677740326899991,0.677592575491735,0.67744482408348,
            0.677297072675224,0.677149321266968,0.677001569858713,0.676853818450457,
            0.676706067042201,0.676558315633946,0.67641056422569,0.676262812817435,
            0.676115061409179,0.675967310000923,0.675819558592668,0.675671807184412,
            0.675524055776157,0.675376304367901,0.675228552959645,0.67508080155139,
            0.674933050143134,0.674785298734879,0.674637547326623,0.674489795918367,
            0.674342044510112,0.674194293101856,0.674046541693601,0.673898790285345,
            0.673751038877089,0.673603287468834,0.673455536060578,0.673307784652322,
            0.673160033244067,0.673012281835811,0.672864530427556,0.6727167790193,
            0.672569027611044,0.672421276202789,0.672273524794533,0.672125773386278,
            0.671978021978022,0.671830270569766,0.671682519161511,0.671534767753255,
            0.671387016345,0.671239264936744,0.671091513528488,0.670943762120233,
            0.670796010711977,0.670648259303722,0.670500507895466,0.67035275648721,
            0.670205005078955,0.670057253670699,0.669909502262443,0.669761750854188,
            0.669613999445932,0.669466248037677,0.669318496629421,0.669170745221165,
            0.66902299381291,0.668875242404654,0.668727490996399,0.668579739588143,
            0.668431988179887,0.668284236771632,0.668136485363376,0.66798873395512,
            0.667840982546865,0.667693231138609,0.667545479730354,0.667397728322098,
            0.667249976913842,0.667102225505587,0.666954474097331,0.666806722689076,
            0.66665897128082,0.666511219872564,0.666363468464309,0.666215717056053,
            0.666067965647798,0.665920214239542,0.665772462831286,0.665624711423031,
            0.665476960014775,0.66532920860652,0.665181457198264,0.665033705790008,
            0.664885954381753,0.664738202973497,0.664590451565241,0.664442700156986,
            0.66429494874873,0.664147197340475,0.663999445932219,0.663851694523963,
            0.663703943115708,0.663556191707452,0.663408440299197,0.663260688890941,
            0.663112937482685,0.66296518607443,0.662817434666174,0.662669683257919,
            0.662521931849663,0.662374180441407,0.662226429033152,0.662078677624896,
            0.661930926216641,0.661783174808385,0.661635423400129,0.661487671991874,
            0.661339920583618,0.661192169175362,0.661044417767107,0.660896666358851,
            0.660748914950596,0.66060116354234,0.660453412134084,0.660305660725829,
            0.660157909317573,0.660010157909318,0.659862406501062,0.659714655092806,
            0.659566903684551,0.659419152276295,0.659271400868039,0.659123649459784,
            0.658975898051528,0.658828146643273,0.658680395235017,0.658532643826761,
            0.658384892418506,0.65823714101025,0.658089389601995,0.657941638193739,
            0.657793886785483,0.657646135377228,0.657498383968972,0.657350632560717,
            0.657202881152461,0.657055129744205,0.65690737833595,0.656759626927694,
            0.656611875519439,0.656464124111183,0.656316372702927,0.656168621294672,
            0.656020869886416,0.655873118478161,0.655725367069905,0.655577615661649,
            0.655429864253394,0.655282112845138,0.655134361436882,0.654986610028627,
            0.654838858620371,0.654691107212116,0.65454335580386,0.654395604395604,
            0.654247852987349,0.654100101579093,0.653952350170838,0.653804598762582,
            0.653656847354326,0.653509095946071,0.653361344537815,0.65321359312956,
            0.653065841721304,0.652918090313048,0.652770338904793,0.652622587496537,
            0.652474836088281,0.652327084680026,0.65217933327177,0.652031581863515,
            0.651883830455259,0.651736079047003,0.651588327638748,0.651440576230492,
            0.651292824822237,0.651145073413981,0.650997322005725,0.65084957059747,
            0.650701819189214,0.650554067780959,0.650406316372703,0.650258564964447,
            0.650110813556192,0.649963062147936,0.64981531073968,0.649667559331425,
            0.649519807923169,0.649372056514914,0.649224305106658,0.649076553698402,
            0.648928802290147,0.648781050881891,0.648633299473636,0.64848554806538,
            0.648337796657124,0.648190045248869,0.648042293840613,0.647894542432358,
            0.647746791024102,0.647599039615846,0.647451288207591,0.647303536799335,
            0.64715578539108,0.647008033982824,0.646860282574568,0.646712531166313,
            0.646564779758057,0.646417028349801,0.646269276941546,0.64612152553329,
            0.645973774125035,0.645826022716779,0.645678271308523,0.645530519900268,
            0.645382768492012,0.645235017083757,0.645087265675501,0.644939514267245,
            0.64479176285899,0.644644011450734,0.644496260042479,0.644348508634223,
            0.644200757225967,0.644053005817712,0.643905254409456,0.6437575030012,
            0.643609751592945,0.643462000184689,0.643314248776434,0.643166497368178,
            0.643018745959922,0.642870994551667,0.642723243143411,0.642575491735156,
            0.6424277403269,0.642279988918644,0.642132237510389,0.641984486102133,
            0.641836734693878,0.641688983285622,0.641541231877366,0.641393480469111,
            0.641245729060855,0.641097977652599,0.640950226244344,0.640802474836088,
            0.640654723427833,0.640506972019577,0.640359220611321,0.640211469203066,
            0.64006371779481,0.639915966386555,0.639768214978299,0.639620463570043,
            0.639472712161788,0.639324960753532,0.639177209345277,0.639029457937021,
            0.638881706528765,0.63873395512051,0.638586203712254,0.638438452303999,
            0.638290700895743,0.638142949487487,0.637995198079232,0.637847446670976,
            0.637699695262721,0.637551943854465,0.637404192446209,0.637256441037954,
            0.637108689629698,0.636960938221442,0.636813186813187,0.636665435404931,
            0.636517683996676,0.63636993258842,0.636222181180164,0.636074429771909,
            0.635926678363653,0.635778926955398,0.635631175547142,0.635483424138886,
            0.635335672730631,0.635187921322375,0.635040169914119,0.634892418505864,
            0.634744667097608,0.634596915689353,0.634449164281097,0.634301412872841,
            0.634153661464586,0.63400591005633,0.633858158648075,0.633710407239819,
            0.633562655831563,0.633414904423308,0.633267153015052,0.633119401606797,
            0.632971650198541,0.632823898790285,0.63267614738203,0.632528395973774,
            0.632380644565519,0.632232893157263,0.632085141749007,0.631937390340752,
            0.631789638932496,0.63164188752424,0.631494136115985,0.631346384707729,
            0.631198633299474,0.631050881891218,0.630903130482962,0.630755379074707,
            0.630607627666451,0.630459876258196,0.63031212484994,0.630164373441684,
            0.630016622033429,0.629868870625173,0.629721119216918,0.629573367808662,
            0.629425616400406,0.629277864992151,0.629130113583895,0.62898236217564,
            0.628834610767384,0.628686859359128,0.628539107950873,0.628391356542617,
            0.628243605134361,0.628095853726106,0.62794810231785,0.627800350909595,
            0.627652599501339,0.627504848093083,0.627357096684828,0.627209345276572,
            0.627061593868317,0.626913842460061,0.626766091051805,0.62661833964355,
            0.626470588235294,0.626322836827038,0.626175085418783,0.626027334010527,
            0.625879582602272,0.625731831194016,0.62558407978576,0.625436328377505,
            0.625288576969249,0.625140825560994,0.624993074152738,0.624845322744482,
            0.624697571336227,0.624549819927971,0.624402068519716,0.62425431711146,
            0.624106565703204,0.623958814294949,0.623811062886693,0.623663311478438,
            0.623515560070182,0.623367808661926,0.623220057253671,0.623072305845415,
            0.622924554437159,0.622776803028904,0.622629051620648,0.622481300212393,
            0.622333548804137,0.622185797395881,0.622038045987626,0.62189029457937,
            0.621742543171115,0.621594791762859,0.621447040354603,0.621299288946348,
            0.621151537538092,0.621003786129837,0.620856034721581,0.620708283313325,
            0.62056053190507,0.620412780496814,0.620265029088559,0.620117277680303,
            0.619969526272047,0.619821774863792,0.619674023455536,0.619526272047281,
            0.619378520639025,0.619230769230769,0.619083017822514,0.618935266414258,
            0.618787515006002,0.618639763597747,0.618492012189491,0.618344260781236,
            0.61819650937298,0.618048757964724,0.617901006556469,0.617753255148213,
            0.617605503739957,0.617457752331702,0.617310000923446,0.617162249515191,
            0.617014498106935,0.616866746698679,0.616718995290424,0.616571243882168,
            0.616423492473913,0.616275741065657,0.616127989657401,0.615980238249146,
            0.61583248684089,0.615684735432635,0.615536984024379,0.615389232616123,
            0.615241481207868,0.615093729799612,0.614945978391357,0.614798226983101,
            0.614650475574845,0.61450272416659,0.614354972758334,0.614207221350079,
            0.614059469941823,0.613911718533567,0.613763967125312,0.613616215717056,
            0.6134684643088,0.613320712900545,0.613172961492289,0.613025210084034,
            0.612877458675778,0.612729707267522,0.612581955859267,0.612434204451011,
            0.612286453042756,0.6121387016345,0.611990950226244,0.611843198817989,
            0.611695447409733,0.611547696001478,0.611399944593222,0.611252193184966,
            0.611104441776711,0.610956690368455,0.610808938960199,0.610661187551944,
            0.610513436143688,0.610365684735433,0.610217933327177,0.610070181918921,
            0.609922430510666,0.60977467910241,0.609626927694155,0.609479176285899,
            0.609331424877643,0.609183673469388,0.609035922061132,0.608888170652876,
            0.608740419244621,0.608592667836365,0.60844491642811,0.608297165019854,
            0.608149413611598,0.608001662203343,0.607853910795087,0.607706159386832,
            0.607558407978576,0.60741065657032,0.607262905162065,0.607115153753809,
            0.606967402345554,0.606819650937298,0.606671899529042,0.606524148120787,
            0.606376396712531,0.606228645304276,0.60608089389602,0.605933142487764,
            0.605785391079509,0.605637639671253,0.605489888262998,0.605342136854742,
            0.605194385446486,0.605046634038231,0.604898882629975,0.604751131221719,
            0.604603379813464,0.604455628405208,0.604307876996953,0.604160125588697,
            0.604012374180441,0.603864622772186,0.60371687136393,0.603569119955675,
            0.603421368547419,0.603273617139163,0.603125865730908,0.602978114322652,
            0.602830362914397,0.602682611506141,0.602534860097885,0.60238710868963,
            0.602239357281374,0.602091605873118,0.601943854464863,0.601796103056607,
            0.601648351648352,0.601500600240096,0.60135284883184,0.601205097423585,
            0.601057346015329,0.600909594607074,0.600761843198818,0.600614091790562,
            0.600466340382307,0.600318588974051,0.600170837565796,0.60002308615754,
            0.599875334749284,0.599727583341029,0.599579831932773,0.599432080524517,
            0.599284329116262,0.599136577708006,0.598988826299751,0.598841074891495,
            0.598693323483239,0.598545572074984,0.598397820666728,0.598250069258473,
            0.598102317850217,0.597954566441961,0.597806815033706,0.59765906362545,
            0.597511312217195,0.597363560808939,0.597215809400683,0.597068057992428,
            0.596920306584172,0.596772555175917,0.596624803767661,0.596477052359405,
            0.59632930095115,0.596181549542894,0.596033798134639,0.595886046726383,
            0.595738295318127,0.595590543909872,0.595442792501616,0.59529504109336,
            0.595147289685105,0.594999538276849,0.594851786868594,0.594704035460338,
            0.594556284052082,0.594408532643827,0.594260781235571,0.594113029827316,
            0.59396527841906,0.593817527010804,0.593669775602549,0.593522024194293,
            0.593374272786037,0.593226521377782,0.593078769969526,0.592931018561271,
            0.592783267153015,0.592635515744759,0.592487764336504,0.592340012928248,
            0.592192261519993,0.592044510111737,0.591896758703481,0.591749007295226,
            0.59160125588697,0.591453504478715,0.591305753070459,0.591158001662203,
            0.591010250253948,0.590862498845692,0.590714747437436,0.590566996029181,
            0.590419244620925,0.59027149321267,0.590123741804414,0.589975990396158,
            0.589828238987903,0.589680487579647,0.589532736171392,0.589384984763136,
            0.58923723335488,0.589089481946625,0.588941730538369,0.588793979130114,
            0.588646227721858,0.588498476313602,0.588350724905347,0.588202973497091,
            0.588055222088836,0.58790747068058,0.587759719272324,0.587611967864069,
            0.587464216455813,0.587316465047558,0.587168713639302,0.587020962231046,
            0.586873210822791,0.586725459414535,0.586577708006279,0.586429956598024,
            0.586282205189768,0.586134453781513,0.585986702373257,0.585838950965001,
            0.585691199556746,0.58554344814849,0.585395696740235,0.585247945331979,
            0.585100193923723,0.584952442515468,0.584804691107212,0.584656939698956,
            0.584509188290701,0.584361436882445,0.58421368547419,0.584065934065934,
            0.583918182657678,0.583770431249423,0.583622679841167,0.583474928432912,
            0.583327177024656,0.5831794256164,0.583031674208145,0.582883922799889,
            0.582736171391634,0.582588419983378,0.582440668575122,0.582292917166867,
            0.582145165758611,0.581997414350356,0.5818496629421,0.581701911533844,
            0.581554160125589,0.581406408717333,0.581258657309077,0.581110905900822,
            0.580963154492566,0.580815403084311,0.580667651676055,0.580519900267799,
            0.580372148859544,0.580224397451288,0.580076646043033,0.579928894634777,
            0.579781143226521,0.579633391818266,0.57948564041001,0.579337889001755,
            0.579190137593499,0.579042386185243,0.578894634776988,0.578746883368732,
            0.578599131960477,0.578451380552221,0.578303629143965,0.57815587773571,
            0.578008126327454,0.577860374919198,0.577712623510943,0.577564872102687,
            0.577417120694432,0.577269369286176,0.57712161787792,0.576973866469665,
            0.576826115061409,0.576678363653154,0.576530612244898,0.576382860836642,
            0.576235109428387,0.576087358020131,0.575939606611875,0.57579185520362,
            0.575644103795364,0.575496352387109,0.575348600978853,0.575200849570597,
            0.575053098162342,0.574905346754086,0.574757595345831,0.574609843937575,
            0.574462092529319,0.574314341121064,0.574166589712808,0.574018838304553,
            0.573871086896297,0.573723335488041,0.573575584079786,0.57342783267153,
            0.573280081263275,0.573132329855019,0.572984578446763,0.572836827038508,
            0.572689075630252,0.572541324221996,0.572393572813741,0.572245821405485,
            0.57209806999723,0.571950318588974,0.571802567180718,0.571654815772463,
            0.571507064364207,0.571359312955952,0.571211561547696,0.57106381013944,
            0.570916058731185,0.570768307322929,0.570620555914674,0.570472804506418,
            0.570325053098162,0.570177301689907,0.570029550281651,0.569881798873396,
            0.56973404746514,0.569586296056884,0.569438544648629,0.569290793240373,
            0.569143041832118,0.568995290423862,0.568847539015606,0.568699787607351,
            0.568552036199095,0.568404284790839,0.568256533382584,0.568108781974328,
            0.567961030566073,0.567813279157817,0.567665527749561,0.567517776341306,
            0.56737002493305,0.567222273524794,0.567074522116539,0.566926770708283,
            0.566779019300028,0.566631267891772,0.566483516483516,0.566335765075261,
            0.566188013667005,0.56604026225875,0.565892510850494,0.565744759442238,
            0.565597008033983,0.565449256625727,0.565301505217472,0.565153753809216,
            0.56500600240096,0.564858250992705,0.564710499584449,0.564562748176194,
            0.564414996767938,0.564267245359682,0.564119493951427,0.563971742543171,
            0.563823991134916,0.56367623972666,0.563528488318404,0.563380736910149,
            0.563232985501893,0.563085234093637,0.562937482685382,0.562789731277126,
            0.562641979868871,0.562494228460615,0.562346477052359,0.562198725644104,
            0.562050974235848,0.561903222827593,0.561755471419337,0.561607720011081,
            0.561459968602826,0.56131221719457,0.561164465786315,0.561016714378059,
            0.560868962969803,0.560721211561548,0.560573460153292,0.560425708745036,
            0.560277957336781,0.560130205928525,0.55998245452027,0.559834703112014,
            0.559686951703758,0.559539200295503,0.559391448887247,0.559243697478992,
            0.559095946070736,0.55894819466248,0.558800443254225,0.558652691845969,
            0.558504940437714,0.558357189029458,0.558209437621202,0.558061686212947,
            0.557913934804691,0.557766183396435,0.55761843198818,0.557470680579924,
            0.557322929171669,0.557175177763413,0.557027426355157,0.556879674946902,
            0.556731923538646,0.556584172130391,0.556436420722135,0.556288669313879,
            0.556140917905624,0.555993166497368,0.555845415089113,0.555697663680857,
            0.555549912272601,0.555402160864346,0.55525440945609,0.555106658047835,
            0.554958906639579,0.554811155231323,0.554663403823068,0.554515652414812,
            0.554367901006556,0.554220149598301,0.554072398190045,0.55392464678179,
            0.553776895373534,0.553629143965278,0.553481392557023,0.553333641148767,
            0.553185889740512,0.553038138332256,0.552890386924,0.552742635515745,
            0.552594884107489,0.552447132699234,0.552299381290978,0.552151629882722,
            0.552003878474467,0.551856127066211,0.551708375657955,0.5515606242497,
            0.551412872841444,0.551265121433189,0.551117370024933,0.550969618616677,
            0.550821867208422,0.550674115800166,0.550526364391911,0.550378612983655,
            0.550230861575399,0.550083110167144,0.549935358758888,0.549787607350633,
            0.549639855942377,0.549492104534121,0.549344353125866,0.54919660171761,
            0.549048850309354,0.548901098901099,0.548753347492843,0.548605596084588,
            0.548457844676332,0.548310093268076,0.548162341859821,0.548014590451565,
            0.54786683904331,0.547719087635054,0.547571336226798,0.547423584818543,
            0.547275833410287,0.547128082002032,0.546980330593776,0.54683257918552,
            0.546684827777265,0.546537076369009,0.546389324960754,0.546241573552498,
            0.546093822144242,0.545946070735987,0.545798319327731,0.545650567919476,
            0.54550281651122,0.545355065102964,0.545207313694709,0.545059562286453,
            0.544911810878197,0.544764059469942,0.544616308061686,0.544468556653431,
            0.544320805245175,0.544173053836919,0.544025302428664,0.543877551020408,
            0.543729799612153,0.543582048203897,0.543434296795641,0.543286545387386,
            0.54313879397913,0.542991042570874,0.542843291162619,0.542695539754363,
            0.542547788346108,0.542400036937852,0.542252285529596,0.542104534121341,
            0.541956782713085,0.54180903130483,0.541661279896574,0.541513528488318,
            0.541365777080063,0.541218025671807,0.541070274263552,0.540922522855296,
            0.54077477144704,0.540627020038785,0.540479268630529,0.540331517222274,
            0.540183765814018,0.540036014405762,0.539888262997507,0.539740511589251,
            0.539592760180995,0.53944500877274,0.539297257364484,0.539149505956229,
            0.539001754547973,0.538854003139717,0.538706251731462,0.538558500323206,
            0.538410748914951,0.538262997506695,0.538115246098439,0.537967494690184,
            0.537819743281928,0.537671991873673,0.537524240465417,0.537376489057161,
            0.537228737648906,0.53708098624065,0.536933234832395,0.536785483424139,
            0.536637732015883,0.536489980607628,0.536342229199372,0.536194477791116,
            0.536046726382861,0.535898974974605,0.53575122356635,0.535603472158094,
            0.535455720749838,0.535307969341583,0.535160217933327,0.535012466525072,
            0.534864715116816,0.53471696370856,0.534569212300305,0.534421460892049,
            0.534273709483793,0.534125958075538,0.533978206667282,0.533830455259027,
            0.533682703850771,0.533534952442515,0.53338720103426,0.533239449626004,
            0.533091698217749,0.532943946809493,0.532796195401237,0.532648443992982,
            0.532500692584726,0.532352941176471,0.532205189768215,0.532057438359959,
            0.531909686951704,0.531761935543448,0.531614184135193,0.531466432726937,
            0.531318681318681,0.531170929910426,0.53102317850217,0.530875427093914,
            0.530727675685659,0.530579924277403,0.530432172869148,0.530284421460892,
            0.530136670052636,0.529988918644381,0.529841167236125,0.52969341582787,
            0.529545664419614,0.529397913011358,0.529250161603103,0.529102410194847,
            0.528954658786592,0.528806907378336,0.52865915597008,0.528511404561825,
            0.528363653153569,0.528215901745314,0.528068150337058,0.527920398928802,
            0.527772647520547,0.527624896112291,0.527477144704036,0.52732939329578,
            0.527181641887524,0.527033890479269,0.526886139071013,0.526738387662757,
            0.526590636254502,0.526442884846246,0.526295133437991,0.526147382029735,
            0.525999630621479,0.525851879213224,0.525704127804968,0.525556376396712,
            0.525408624988457,0.525260873580201,0.525113122171946,0.52496537076369,
            0.524817619355434,0.524669867947179,0.524522116538923,0.524374365130668,
            0.524226613722412,0.524078862314156,0.523931110905901,0.523783359497645,
            0.52363560808939,0.523487856681134,0.523340105272878,0.523192353864623,
            0.523044602456367,0.522896851048112,0.522749099639856,0.5226013482316,
            0.522453596823345,0.522305845415089,0.522158094006834,0.522010342598578,
            0.521862591190322,0.521714839782067,0.521567088373811,0.521419336965555,
            0.5212715855573,0.521123834149044,0.520976082740789,0.520828331332533,
            0.520680579924277,0.520532828516022,0.520385077107766,0.520237325699511,
            0.520089574291255,0.519941822882999,0.519794071474744,0.519646320066488,
            0.519498568658233,0.519350817249977,0.519203065841721,0.519055314433466,
            0.51890756302521,0.518759811616955,0.518612060208699,0.518464308800443,
            0.518316557392188,0.518168805983932,0.518021054575676,0.517873303167421,
            0.517725551759165,0.51757780035091,0.517430048942654,0.517282297534398,
            0.517134546126143,0.516986794717887,0.516839043309632,0.516691291901376,
            0.51654354049312,0.516395789084865,0.516248037676609,0.516100286268353,
            0.515952534860098,0.515804783451842,0.515657032043587,0.515509280635331,
            0.515361529227075,0.51521377781882,0.515066026410564,0.514918275002309,
            0.514770523594053,0.514622772185797,0.514475020777542,0.514327269369286,
            0.514179517961031,0.514031766552775,0.513884015144519,0.513736263736264,
            0.513588512328008,0.513440760919753,0.513293009511497,0.513145258103241,
            0.512997506694986,0.51284975528673,0.512702003878474,0.512554252470219,
            0.512406501061963,0.512258749653708,0.512110998245452,0.511963246837196,
            0.511815495428941,0.511667744020685,0.51151999261243,0.511372241204174,
            0.511224489795918,0.511076738387663,0.510928986979407,0.510781235571152,
            0.510633484162896,0.51048573275464,0.510337981346385,0.510190229938129,
            0.510042478529873,0.509894727121618,0.509746975713362,0.509599224305107,
            0.509451472896851,0.509303721488595,0.50915597008034,0.509008218672084,
            0.508860467263829,0.508712715855573,0.508564964447317,0.508417213039062,
            0.508269461630806,0.508121710222551,0.507973958814295,0.507826207406039,
            0.507678455997784,0.507530704589528,0.507382953181272,0.507235201773017,
            0.507087450364761,0.506939698956506,0.50679194754825,0.506644196139994,
            0.506496444731739,0.506348693323483,0.506200941915228,0.506053190506972,
            0.505905439098716,0.505757687690461,0.505609936282205,0.50546218487395,
            0.505314433465694,0.505166682057438,0.505018930649183,0.504871179240927,
            0.504723427832672,0.504575676424416,0.50442792501616,0.504280173607905,
            0.504132422199649,0.503984670791394,0.503836919383138,0.503689167974882,
            0.503541416566627,0.503393665158371,0.503245913750115,0.50309816234186,
            0.502950410933604,0.502802659525349,0.502654908117093,0.502507156708837,
            0.502359405300582,0.502211653892326,0.502063902484071,0.501916151075815,
            0.501768399667559,0.501620648259304,0.501472896851048,0.501325145442792,
            0.501177394034537,0.500784929356358,0.500392464678179,0.5,
            0.499607535321821,0.499215070643642,0.498822605965463,0.498430141287284,
            0.498037676609105,0.497645211930926,0.497252747252747,0.496860282574568,
            0.496467817896389,0.49607535321821,0.495682888540031,0.495290423861852,
            0.494897959183673,0.494505494505495,0.494113029827316,0.493720565149137,
            0.493328100470958,0.492935635792779,0.4925431711146,0.492150706436421,
            0.491758241758242,0.491365777080063,0.490973312401884,0.490580847723705,
            0.490188383045526,0.489795918367347,0.489403453689168,0.489010989010989,
            0.48861852433281,0.488226059654631,0.487833594976452,0.487441130298273,
            0.487048665620094,0.486656200941915,0.486263736263736,0.485871271585557,
            0.485478806907378,0.485086342229199,0.48469387755102,0.484301412872841,
            0.483908948194662,0.483516483516484,0.483124018838305,0.482731554160126,
            0.482339089481947,0.481946624803768,0.481554160125589,0.48116169544741,
            0.480769230769231,0.480376766091052,0.479984301412873,0.479591836734694,
            0.479199372056515,0.478806907378336,0.478414442700157,0.478021978021978,
            0.477629513343799,0.47723704866562,0.476844583987441,0.476452119309262,
            0.476059654631083,0.475667189952904,0.475274725274725,0.474882260596546,
            0.474489795918367,0.474097331240188,0.473704866562009,0.47331240188383,
            0.472919937205652,0.472527472527473,0.472135007849294,0.471742543171115,
            0.471350078492936,0.470957613814757,0.470565149136578,0.470172684458399,
            0.46978021978022,0.469387755102041,0.468995290423862,0.468602825745683,
            0.468210361067504,0.467817896389325,0.467425431711146,0.467032967032967,
            0.466640502354788,0.466248037676609,0.46585557299843,0.465463108320251,
            0.465070643642072,0.464678178963893,0.464285714285714,0.463893249607535,
            0.463500784929356,0.463108320251177,0.462715855572998,0.462323390894819,
            0.461930926216641,0.461538461538462,0.461145996860283,0.460753532182104,
            0.460361067503925,0.459968602825746,0.459576138147567,0.459183673469388,
            0.458791208791209,0.45839874411303,0.458006279434851,0.457613814756672,
            0.457221350078493,0.456828885400314,0.456436420722135,0.456043956043956,
            0.455651491365777,0.455259026687598,0.454866562009419,0.45447409733124,
            0.454081632653061,0.453689167974882,0.453296703296703,0.452904238618524,
            0.452511773940345,0.452119309262166,0.451726844583987,0.451334379905808,
            0.450941915227629,0.450549450549451,0.450156985871272,0.449764521193093,
            0.449372056514914,0.448979591836735,0.448587127158556,0.448194662480377,
            0.447802197802198,0.447409733124019,0.44701726844584,0.446624803767661,
            0.446232339089482,0.445839874411303,0.445447409733124,0.445054945054945,
            0.444662480376766,0.444270015698587,0.443877551020408,0.443485086342229,
            0.44309262166405,0.442700156985871,0.442307692307692,0.441915227629513,
            0.441522762951334,0.441130298273155,0.440737833594976,0.440345368916797,
            0.439952904238619,0.43956043956044,0.439167974882261,0.438775510204082,
            0.438383045525903,0.437990580847724,0.437598116169545,0.437205651491366,
            0.436813186813187,0.436420722135008,0.436028257456829,0.43563579277865,
            0.435243328100471,0.434850863422292,0.434458398744113,0.434065934065934,
            0.433673469387755,0.433281004709576,0.432888540031397,0.432496075353218,
            0.432103610675039,0.43171114599686,0.431318681318681,0.430926216640502,
            0.430533751962323,0.430141287284144,0.429748822605965,0.429356357927786,
            0.428963893249608,0.428571428571429,0.42817896389325,0.427786499215071,
            0.427394034536892,0.427001569858713,0.426609105180534,0.426216640502355,
            0.425824175824176,0.425431711145997,0.425039246467818,0.424646781789639,
            0.42425431711146,0.423861852433281,0.423469387755102,0.423076923076923,
            0.422684458398744,0.422291993720565,0.421899529042386,0.421507064364207,
            0.421114599686028,0.420722135007849,0.42032967032967,0.419937205651491,
            0.419544740973312,0.419152276295133,0.418759811616954,0.418367346938776,
            0.417974882260597,0.417582417582418,0.417189952904239,0.41679748822606,
            0.416405023547881,0.416012558869702,0.415620094191523,0.415227629513344,
            0.414835164835165,0.414442700156986,0.414050235478807,0.413657770800628,
            0.413265306122449,0.41287284144427,0.412480376766091,0.412087912087912,
            0.411695447409733,0.411302982731554,0.410910518053375,0.410518053375196,
            0.410125588697017,0.409733124018838,0.409340659340659,0.40894819466248,
            0.408555729984301,0.408163265306122,0.407770800627943,0.407378335949765,
            0.406985871271586,0.406593406593407,0.406200941915228,0.405808477237049,
            0.40541601255887,0.405023547880691,0.404631083202512,0.404238618524333,
            0.403846153846154,0.403453689167975,0.403061224489796,0.402668759811617,
            0.402276295133438,0.401883830455259,0.40149136577708,0.401098901098901,
            0.400706436420722,0.400313971742543,0.399921507064364,0.399529042386185,
            0.399136577708006,0.398744113029827,0.398351648351648,0.397959183673469,
            0.39756671899529,0.397174254317111,0.396781789638933,0.396389324960754,
            0.395996860282575,0.395604395604396,0.395211930926217,0.394819466248038,
            0.394427001569859,0.39403453689168,0.393642072213501,0.393249607535322,
            0.392857142857143,0.392464678178964,0.392072213500785,0.391679748822606,
            0.391287284144427,0.390894819466248,0.390502354788069,0.39010989010989,
            0.389717425431711,0.389324960753532,0.388932496075353,0.388540031397174,
            0.388147566718995,0.387755102040816,0.387362637362637,0.386970172684458,
            0.386577708006279,0.3861852433281,0.385792778649922,0.385400313971743,
            0.385007849293564,0.384615384615385,0.384222919937206,0.383830455259027,
            0.383437990580848,0.383045525902669,0.38265306122449,0.382260596546311,
            0.381868131868132,0.381475667189953,0.381083202511774,0.380690737833595,
            0.380298273155416,0.379905808477237,0.379513343799058,0.379120879120879,
            0.3787284144427,0.378335949764521,0.377943485086342,0.377551020408163,
            0.377158555729984,0.376766091051805,0.376373626373626,0.375981161695447,
            0.375588697017268,0.375196232339089,0.374803767660911,0.374411302982732,
            0.374018838304553,0.373626373626374,0.373233908948195,0.372841444270016,
            0.372448979591837,0.372056514913658,0.371664050235479,0.3712715855573,
            0.370879120879121,0.370486656200942,0.370094191522763,0.369701726844584,
            0.369309262166405,0.368916797488226,0.368524332810047,0.368131868131868,
            0.367739403453689,0.36734693877551,0.366954474097331,0.366562009419152,
            0.366169544740973,0.365777080062794,0.365384615384615,0.364992150706436,
            0.364599686028257,0.364207221350078,0.3638147566719,0.363422291993721,
            0.363029827315542,0.362637362637363,0.362244897959184,0.361852433281005,
            0.361459968602826,0.361067503924647,0.360675039246468,0.360282574568289,
            0.35989010989011,0.359497645211931,0.359105180533752,0.358712715855573,
            0.358320251177394,0.357927786499215,0.357535321821036,0.357142857142857,
            0.356750392464678,0.356357927786499,0.35596546310832,0.355572998430141,
            0.355180533751962,0.354788069073783,0.354395604395604,0.354003139717425,
            0.353610675039246,0.353218210361067,0.352825745682889,0.35243328100471,
            0.352040816326531,0.351648351648352,0.351255886970173,0.350863422291994,
            0.350470957613815,0.350078492935636,0.349686028257457,0.349293563579278,
            0.348901098901099,0.34850863422292,0.348116169544741,0.347723704866562,
            0.347331240188383,0.346938775510204,0.346546310832025,0.346153846153846,
            0.345761381475667,0.345368916797488,0.344976452119309,0.34458398744113,
            0.344191522762951,0.343799058084772,0.343406593406593,0.343014128728414,
            0.342621664050235,0.342229199372057,0.341836734693878,0.341444270015699,
            0.34105180533752,0.340659340659341,0.340266875981162,0.339874411302983,
            0.339481946624804,0.339089481946625,0.338697017268446,0.338304552590267,
            0.337912087912088,0.337519623233909,0.33712715855573,0.336734693877551,
            0.336342229199372,0.335949764521193,0.335557299843014,0.335164835164835,
            0.334772370486656,0.334379905808477,0.333987441130298,0.333594976452119,
            0.33320251177394,0.332810047095761,0.332417582417582,0.332025117739403,
            0.331632653061224,0.331240188383046,0.330847723704867,0.330455259026688,
            0.330062794348509,0.32967032967033,0.329277864992151,0.328885400313972,
            0.328492935635793,0.328100470957614,0.327708006279435,0.327315541601256,
            0.326923076923077,0.326530612244898,0.326138147566719,0.32574568288854,
            0.325353218210361,0.324960753532182,0.324568288854003,0.324175824175824,
            0.323783359497645,0.323390894819466,0.322998430141287,0.322605965463108,
            0.322213500784929,0.32182103610675,0.321428571428571,0.321036106750392,
            0.320643642072214,0.320251177394035,0.319858712715856,0.319466248037677,
            0.319073783359498,0.318681318681319,0.31828885400314,0.317896389324961,
            0.317503924646782,0.317111459968603,0.316718995290424,0.316326530612245,
            0.315934065934066,0.315541601255887,0.315149136577708,0.314756671899529,
            0.31436420722135,0.313971742543171,0.313579277864992,0.313186813186813,
            0.312794348508634,0.312401883830455,0.312009419152276,0.311616954474097,
            0.311224489795918,0.310832025117739,0.31043956043956,0.310047095761381,
            0.309654631083203,0.309262166405024,0.308869701726845,0.308477237048666,
            0.308084772370487,0.307692307692308,0.307299843014129,0.30690737833595,
            0.306514913657771,0.306122448979592,0.305729984301413,0.305337519623234,
            0.304945054945055,0.304552590266876,0.304160125588697,0.303767660910518,
            0.303375196232339,0.30298273155416,0.302590266875981,0.302197802197802,
            0.301805337519623,0.301412872841444,0.301020408163265,0.300627943485086,
            0.300235478806907,0.299843014128728,0.299450549450549,0.299058084772371,
            0.298665620094192,0.298273155416013,0.297880690737834,0.297488226059655,
            0.297095761381476,0.296703296703297,0.296310832025118,0.295918367346939,
            0.29552590266876,0.295133437990581,0.294740973312402,0.294348508634223,
            0.293956043956044,0.293563579277865,0.293171114599686,0.292778649921507,
            0.292386185243328,0.291993720565149,0.29160125588697,0.291208791208791,
            0.290816326530612,0.290423861852433,0.290031397174254,0.289638932496075,
            0.289246467817896,0.288854003139717,0.288461538461538,0.288069073783359,
            0.287676609105181,0.287284144427002,0.286891679748823,0.286499215070644,
            0.286106750392465,0.285714285714286,0.285321821036107,0.284929356357928,
            0.284536891679749,0.28414442700157,0.283751962323391,0.283359497645212,
            0.282967032967033,0.282574568288854,0.282182103610675,0.281789638932496,
            0.281397174254317,0.281004709576138,0.280612244897959,0.28021978021978,
            0.279827315541601,0.279434850863422,0.279042386185243,0.278649921507064,
            0.278257456828885,0.277864992150706,0.277472527472527,0.277080062794348,
            0.27668759811617,0.276295133437991,0.275902668759812,0.275510204081633,
            0.275117739403454,0.274725274725275,0.274332810047096,0.273940345368917,
            0.273547880690738,0.273155416012559,0.27276295133438,0.272370486656201,
            0.271978021978022,0.271585557299843,0.271193092621664,0.270800627943485,
            0.270408163265306,0.270015698587127,0.269623233908948,0.269230769230769,
            0.26883830455259,0.268445839874411,0.268053375196232,0.267660910518053,
            0.267268445839874,0.266875981161695,0.266483516483516,0.266091051805338,
            0.265698587127159,0.26530612244898,0.264913657770801,0.264521193092622,
            0.264128728414443,0.263736263736264,0.263343799058085,0.262951334379906,
            0.262558869701727,0.262166405023548,0.261773940345369,0.26138147566719,
            0.260989010989011,0.260596546310832,0.260204081632653,0.259811616954474,
            0.259419152276295,0.259026687598116,0.258634222919937,0.258241758241758,
            0.257849293563579,0.2574568288854,0.257064364207221,0.256671899529042,
            0.256279434850863,0.255886970172684,0.255494505494505,0.255102040816327,
            0.254709576138148,0.254317111459969,0.25392464678179,0.253532182103611,
            0.253139717425432,0.252747252747253,0.252354788069074,0.251962323390895,
            0.251569858712716,0.251177394034537,0.250784929356358,0.250392464678179,
            0.25,0.249607535321821,0.249215070643642,0.248822605965463,
            0.248430141287284,0.248037676609105,0.247645211930926,0.247252747252747,
            0.246860282574568,0.246467817896389,0.24607535321821,0.245682888540031,
            0.245290423861852,0.244897959183673,0.244505494505494,0.244113029827316,
            0.243720565149137,0.243328100470958,0.242935635792779,0.2425431711146,
            0.242150706436421,0.241758241758242,0.241365777080063,0.240973312401884,
            0.240580847723705,0.240188383045526,0.239795918367347,0.239403453689168,
            0.239010989010989,0.23861852433281,0.238226059654631,0.237833594976452,
            0.237441130298273,0.237048665620094,0.236656200941915,0.236263736263736,
            0.235871271585557,0.235478806907378,0.235086342229199,0.23469387755102,
            0.234301412872841,0.233908948194662,0.233516483516484,0.233124018838305,
            0.232731554160126,0.232339089481947,0.231946624803768,0.231554160125589,
            0.23116169544741,0.230769230769231,0.230376766091052,0.229984301412873,
            0.229591836734694,0.229199372056515,0.228806907378336,0.228414442700157,
            0.228021978021978,0.227629513343799,0.22723704866562,0.226844583987441,
            0.226452119309262,0.226059654631083,0.225667189952904,0.225274725274725,
            0.224882260596546,0.224489795918367,0.224097331240188,0.223704866562009,
            0.22331240188383,0.222919937205651,0.222527472527473,0.222135007849294,
            0.221742543171115,0.221350078492936,0.220957613814757,0.220565149136578,
            0.220172684458399,0.21978021978022,0.219387755102041,0.218995290423862,
            0.218602825745683,0.218210361067504,0.217817896389325,0.217425431711146,
            0.217032967032967,0.216640502354788,0.216248037676609,0.21585557299843,
            0.215463108320251,0.215070643642072,0.214678178963893,0.214285714285714,
            0.213893249607535,0.213500784929356,0.213108320251177,0.212715855572998,
            0.212323390894819,0.211930926216641,0.211538461538462,0.211145996860283,
            0.210753532182104,0.210361067503925,0.209968602825746,0.209576138147567,
            0.209183673469388,0.208791208791209,0.20839874411303,0.208006279434851,
            0.207613814756672,0.207221350078493,0.206828885400314,0.206436420722135,
            0.206043956043956,0.205651491365777,0.205259026687598,0.204866562009419,
            0.20447409733124,0.204081632653061,0.203689167974882,0.203296703296703,
            0.202904238618524,0.202511773940345,0.202119309262166,0.201726844583987,
            0.201334379905808,0.20094191522763,0.200549450549451,0.200156985871272,
            0.199764521193093,0.199372056514914,0.198979591836735,0.198587127158556,
            0.198194662480377,0.197802197802198,0.197409733124019,0.19701726844584,
            0.196624803767661,0.196232339089482,0.195839874411303,0.195447409733124,
            0.195054945054945,0.194662480376766,0.194270015698587,0.193877551020408,
            0.193485086342229,0.19309262166405,0.192700156985871,0.192307692307692,
            0.191915227629513,0.191522762951334,0.191130298273155,0.190737833594976,
            0.190345368916797,0.189952904238619,0.18956043956044,0.189167974882261,
            0.188775510204082,0.188383045525903,0.187990580847724,0.187598116169545,
            0.187205651491366,0.186813186813187,0.186420722135008,0.186028257456829,
            0.18563579277865,0.185243328100471,0.184850863422292,0.184458398744113,
            0.184065934065934,0.183673469387755,0.183281004709576,0.182888540031397,
            0.182496075353218,0.182103610675039,0.18171114599686,0.181318681318681,
            0.180926216640502,0.180533751962323,0.180141287284144,0.179748822605965,
            0.179356357927787,0.178963893249608,0.178571428571429,0.17817896389325,
            0.177786499215071,0.177394034536892,0.177001569858713,0.176609105180534,
            0.176216640502355,0.175824175824176,0.175431711145997,0.175039246467818,
            0.174646781789639,0.17425431711146,0.173861852433281,0.173469387755102,
            0.173076923076923,0.172684458398744,0.172291993720565,0.171899529042386,
            0.171507064364207,0.171114599686028,0.170722135007849,0.17032967032967,
            0.169937205651491,0.169544740973312,0.169152276295133,0.168759811616954,
            0.168367346938776,0.167974882260597,0.167582417582418,0.167189952904239,
            0.16679748822606,0.166405023547881,0.166012558869702,0.165620094191523,
            0.165227629513344,0.164835164835165,0.164442700156986,0.164050235478807,
            0.163657770800628,0.163265306122449,0.16287284144427,0.162480376766091,
            0.162087912087912,0.161695447409733,0.161302982731554,0.160910518053375,
            0.160518053375196,0.160125588697017,0.159733124018838,0.159340659340659,
            0.15894819466248,0.158555729984301,0.158163265306122,0.157770800627943,
            0.157378335949765,0.156985871271586,0.156593406593407,0.156200941915228,
            0.155808477237049,0.15541601255887,0.155023547880691,0.154631083202512,
            0.154238618524333,0.153846153846154,0.153453689167975,0.153061224489796,
            0.152668759811617,0.152276295133438,0.151883830455259,0.15149136577708,
            0.151098901098901,0.150706436420722,0.150313971742543,0.149921507064364,
            0.149529042386185,0.149136577708006,0.148744113029827,0.148351648351648,
            0.147959183673469,0.14756671899529,0.147174254317111,0.146781789638932,
            0.146389324960754,0.145996860282575,0.145604395604396,0.145211930926217,
            0.144819466248038,0.144427001569859,0.14403453689168,0.143642072213501,
            0.143249607535322,0.142857142857143,0.142464678178964,0.142072213500785,
            0.141679748822606,0.141287284144427,0.140894819466248,0.140502354788069,
            0.14010989010989,0.139717425431711,0.139324960753532,0.138932496075353,
            0.138540031397174,0.138147566718995,0.137755102040816,0.137362637362637,
            0.136970172684458,0.136577708006279,0.1361852433281,0.135792778649922,
            0.135400313971743,0.135007849293564,0.134615384615385,0.134222919937206,
            0.133830455259027,0.133437990580848,0.133045525902669,0.13265306122449,
            0.132260596546311,0.131868131868132,0.131475667189953,0.131083202511774,
            0.130690737833595,0.130298273155416,0.129905808477237,0.129513343799058,
            0.129120879120879,0.1287284144427,0.128335949764521,0.127943485086342,
            0.127551020408163,0.127158555729984,0.126766091051805,0.126373626373626,
            0.125981161695447,0.125588697017268,0.125196232339089,0.124803767660911,
            0.124411302982732,0.124018838304553,0.123626373626374,0.123233908948195,
            0.122841444270016,0.122448979591837,0.122056514913658,0.121664050235479,
            0.1212715855573,0.120879120879121,0.120486656200942,0.120094191522763,
            0.119701726844584,0.119309262166405,0.118916797488226,0.118524332810047,
            0.118131868131868,0.117739403453689,0.11734693877551,0.116954474097331,
            0.116562009419152,0.116169544740973,0.115777080062794,0.115384615384615,
            0.114992150706436,0.114599686028257,0.114207221350078,0.1138147566719,
            0.113422291993721,0.113029827315542,0.112637362637363,0.112244897959184,
            0.111852433281005,0.111459968602826,0.111067503924647,0.110675039246468,
            0.110282574568289,0.10989010989011,0.109497645211931,0.109105180533752,
            0.108712715855573,0.108320251177394,0.107927786499215,0.107535321821036,
            0.107142857142857,0.106750392464678,0.106357927786499,0.10596546310832,
            0.105572998430141,0.105180533751962,0.104788069073783,0.104395604395604,
            0.104003139717425,0.103610675039246,0.103218210361068,0.102825745682889,
            0.10243328100471,0.102040816326531,0.101648351648352,0.101255886970173,
            0.100863422291994,0.100470957613815,0.100078492935636,0.0996860282574568,
            0.0992935635792779,0.0989010989010989,0.0985086342229199,0.098116169544741,
            0.097723704866562,0.097331240188383,0.0969387755102041,0.0965463108320251,
            0.0961538461538462,0.0957613814756672,0.0953689167974882,0.0949764521193093,
            0.0945839874411303,0.0941915227629513,0.0937990580847724,0.0934065934065934,
            0.0930141287284144,0.0926216640502355,0.0922291993720565,0.0918367346938776,
            0.0914442700156986,0.0910518053375196,0.0906593406593407,0.0902668759811617,
            0.0898744113029827,0.0894819466248038,0.0890894819466248,0.0886970172684458,
            0.0883045525902669,0.0879120879120879,0.087519623233909,0.08712715855573,
            0.086734693877551,0.0863422291993721,0.0859497645211931,0.0855572998430141,
            0.0851648351648352,0.0847723704866562,0.0843799058084772,0.0839874411302983,
            0.0835949764521193,0.0832025117739403,0.0828100470957614,0.0824175824175824,
            0.0820251177394034,0.0816326530612245,0.0812401883830455,0.0808477237048666,
            0.0804552590266876,0.0800627943485086,0.0796703296703297,0.0792778649921507,
            0.0788854003139717,0.0784929356357928,0.0781004709576138,0.0777080062794348,
            0.0773155416012559,0.0769230769230769,0.076530612244898,0.076138147566719,
            0.07574568288854,0.0753532182103611,0.0749607535321821,0.0745682888540031,
            0.0741758241758242,0.0737833594976452,0.0733908948194662,0.0729984301412873,
            0.0726059654631083,0.0722135007849294,0.0718210361067504,0.0714285714285714,
            0.0710361067503925,0.0706436420722135,0.0702511773940345,0.0698587127158556,
            0.0694662480376766,0.0690737833594976,0.0686813186813187,0.0682888540031397,
            0.0678963893249608,0.0675039246467818,0.0671114599686028,0.0667189952904239,
            0.0663265306122449,0.0659340659340659,0.065541601255887,0.065149136577708,
            0.064756671899529,0.0643642072213501,0.0639717425431711,0.0635792778649922,
            0.0631868131868132,0.0627943485086342,0.0624018838304553,0.0620094191522763,
            0.0616169544740973,0.0612244897959184,0.0608320251177394,0.0604395604395604,
            0.0600470957613815,0.0596546310832025,0.0592621664050235,0.0588697017268446,
            0.0584772370486656,0.0580847723704867,0.0576923076923077,0.0572998430141287,
            0.0569073783359498,0.0565149136577708,0.0561224489795918,0.0557299843014129,
            0.0553375196232339,0.0549450549450549,0.054552590266876,0.054160125588697,
            0.0537676609105181,0.0533751962323391,0.0529827315541601,0.0525902668759812,
            0.0521978021978022,0.0518053375196232,0.0514128728414443,0.0510204081632653,
            0.0506279434850863,0.0502354788069074,0.0498430141287284,0.0494505494505494,
            0.0490580847723705,0.0486656200941915,0.0482731554160126,0.0478806907378336,
            0.0474882260596546,0.0470957613814757,0.0467032967032967,0.0463108320251177,
            0.0459183673469388,0.0455259026687598,0.0451334379905808,0.0447409733124019,
            0.0443485086342229,0.043956043956044,0.043563579277865,0.043171114599686,
            0.0427786499215071,0.0423861852433281,0.0419937205651491,0.0416012558869702,
            0.0412087912087912,0.0408163265306122,0.0404238618524333,0.0400313971742543,
            0.0396389324960754,0.0392464678178964,0.0388540031397174,0.0384615384615385,
            0.0380690737833595,0.0376766091051805,0.0372841444270016,0.0368916797488226,
            0.0364992150706436,0.0361067503924647,0.0357142857142857,0.0353218210361068,
            0.0349293563579278,0.0345368916797488,0.0341444270015699,0.0337519623233909,
            0.0333594976452119,0.032967032967033,0.032574568288854,0.032182103610675,
            0.0317896389324961,0.0313971742543171,0.0310047095761381,0.0306122448979592,
            0.0302197802197802,0.0298273155416013,0.0294348508634223,0.0290423861852433,
            0.0286499215070644,0.0282574568288854,0.0278649921507064,0.0274725274725275,
            0.0270800627943485,0.0266875981161695,0.0262951334379906,0.0259026687598116,
            0.0255102040816327,0.0251177394034537,0.0247252747252747,0.0243328100470958,
            0.0239403453689168,0.0235478806907378,0.0231554160125589,0.0227629513343799,
            0.0223704866562009,0.021978021978022,0.021585557299843,0.0211930926216641,
            0.0208006279434851,0.0204081632653061,0.0200156985871272,0.0196232339089482,
            0.0192307692307692,0.0188383045525903,0.0184458398744113,0.0180533751962323,
            0.0176609105180534,0.0172684458398744,0.0168759811616954,0.0164835164835165,
            0.0160910518053375,0.0156985871271586,0.0153061224489796,0.0149136577708006,
            0.0145211930926217,0.0141287284144427,0.0137362637362637,0.0133437990580848,
            0.0129513343799058,0.0125588697017268,0.0121664050235479,0.0117739403453689,
            0.01138147566719,0.010989010989011,0.010596546310832,0.0102040816326531,
            0.0098116169544741,0.00941915227629513,0.00902668759811617,0.0086342229199372,
            0.00824175824175824,0.00784929356357928,0.00745682888540031,0.00706436420722135,
            0.00667189952904239,0.00627943485086342,0.00588697017268446,0.00549450549450549,
            0.00510204081632653,0.00470957613814757,0.0043171114599686,0.00392464678178964,
            0.00353218210361068,0.00313971742543171,0.00274725274725275,0.00235478806907378,
            0.00196232339089482,0.00156985871271586,0.00117739403453689,0.000784929356357928,
            0.000392464678178964,0.0
        ]
        rank_to_percentile_6 = [
            0.999990765536984,0.999981727551905,0.999972689566825,0.999963651581746,
            0.999954613596666,0.999945575611587,0.999936537626507,0.999927499641428,
            0.999918461656348,0.999909423671269,0.999900483925158,0.999892330090792,
            0.999884962168173,0.9998783801573,0.999872584058173,0.999867573870792,
            0.999863349595157,0.999859911231268,0.999857258779125,0.999855392238729,
            0.999854311610078,0.999854016893173,0.999845077147062,0.999836923312697,
            0.999829555390077,0.999822973379204,0.999817177280077,0.999812167092696,
            0.999807942817061,0.999804504453172,0.99980185200103,0.999799985460633,
            0.999798904831982,0.999798610115077,0.999789670368966,0.999781516534601,
            0.999774148611982,0.999767566601109,0.999761770501981,0.9997567603146,
            0.999752536038966,0.999749097675077,0.999746445222934,0.999744578682537,
            0.999743498053886,0.999743203336981,0.99973426359087,0.999726109756505,
            0.999718741833886,0.999712159823013,0.999706363723886,0.999701353536505,
            0.99969712926087,0.999693690896981,0.999691038444838,0.999689171904441,
            0.99968809127579,0.999687796558885,0.999678856812774,0.999670702978409,
            0.99966333505579,0.999656753044917,0.99965095694579,0.999645946758409,
            0.999641722482774,0.999638284118885,0.999635631666742,0.999633765126345,
            0.999632684497694,0.99963238978079,0.999623450034678,0.999615296200313,
            0.999607928277694,0.999601346266821,0.999595550167694,0.999590539980313,
            0.999586315704678,0.999582877340789,0.999580224888646,0.999578358348249,
            0.999577277719598,0.999576983002694,0.999568043256583,0.999559889422217,
            0.999552521499598,0.999545939488725,0.999540143389598,0.999535133202217,
            0.999530908926582,0.999527470562693,0.99952481811055,0.999522951570153,
            0.999521870941503,0.999521576224598,0.999512636478487,0.999504482644122,
            0.999497114721502,0.999490532710629,0.999484736611502,0.999479726424121,
            0.999475502148486,0.999472063784597,0.999469411332454,0.999467544792058,
            0.999466464163407,0.999466169446502,0.999457229700391,0.999449075866026,
            0.999441707943406,0.999435125932533,0.999429329833406,0.999424319646025,
            0.99942009537039,0.999416657006502,0.999414004554359,0.999412138013962,
            0.999411057385311,0.999410762668406,0.999401822922295,0.99939366908793,
            0.999386301165311,0.999379719154438,0.99937392305531,0.99936891286793,
            0.999364688592295,0.999361250228406,0.999358597776263,0.999356731235866,
            0.999355650607215,0.99935535589031,0.999346416144199,0.999338262309834,
            0.999330894387215,0.999324312376342,0.999318516277215,0.999313506089834,
            0.999309281814199,0.99930584345031,0.999303190998167,0.99930132445777,
            0.999300243829119,0.999299949112214,0.999291009366103,0.999282855531738,
            0.999275487609119,0.999268905598246,0.999263109499119,0.999258099311738,
            0.999253875036103,0.999250436672214,0.999247784220071,0.999245917679674,
            0.999244837051023,0.999244542334119,0.999235602588007,0.999227448753642,
            0.999220080831023,0.99921349882015,0.999207702721023,0.999202692533642,
            0.999198468258007,0.999195029894118,0.999192377441975,0.999190510901578,
            0.999189430272928,0.999189135556023,0.999136479469038,0.999083823382053,
            0.999031167295069,0.998978511208084,0.998925855121099,0.998873199034114,
            0.99882054294713,0.998767886860145,0.99871523077316,0.998662574686176,
            0.998609918599191,0.998557262512206,0.998505392336968,0.998452736249983,
            0.998400080162998,0.998347424076013,0.998294767989029,0.998242111902044,
            0.998189455815059,0.998136799728075,0.99808414364109,0.998031487554105,
            0.99797883146712,0.997926175380136,0.997874305204897,0.997822435029658,
            0.997769778942674,0.997717122855689,0.997664466768704,0.997611810681719,
            0.997559154594735,0.99750649850775,0.997453842420765,0.997401186333781,
            0.997348530246796,0.997295874159811,0.997244003984573,0.997192133809334,
            0.997140263634095,0.99708760754711,0.997034951460126,0.996982295373141,
            0.996929639286156,0.996876983199172,0.996824327112187,0.996771671025202,
            0.996719014938217,0.996666358851233,0.996614488675994,0.996562618500755,
            0.996510748325517,0.996458878150278,0.996406222063293,0.996353565976309,
            0.996300909889324,0.996248253802339,0.996195597715355,0.99614294162837,
            0.996090285541385,0.9960376294544,0.995985759279162,0.995933889103923,
            0.995882018928684,0.995830148753446,0.995778278578207,0.995725622491222,
            0.995672966404238,0.995620310317253,0.995567654230268,0.995514998143283,
            0.995462342056299,0.995409685969314,0.995357815794075,0.995305945618837,
            0.995254075443598,0.995202205268359,0.995150335093121,0.995098464917882,
            0.995045808830897,0.994993152743913,0.994940496656928,0.994887840569943,
            0.994835184482958,0.994782528395974,0.994730658220735,0.994678788045496,
            0.994626917870258,0.994575047695019,0.99452317751978,0.994471307344542,
            0.994419437169303,0.994366781082318,0.994314124995334,0.994261468908349,
            0.994208812821364,0.99415615673438,0.994104286559141,0.994052416383902,
            0.994000546208664,0.993948676033425,0.993896805858186,0.993844935682948,
            0.993793065507709,0.99374119533247,0.993688539245485,0.993635883158501,
            0.993583227071516,0.993530570984531,0.993478700809293,0.993426830634054,
            0.993374960458815,0.993323090283577,0.993271220108338,0.993219349933099,
            0.993167479757861,0.993115609582622,0.993063739407383,0.993011083320399,
            0.992958427233414,0.992905771146429,0.99285390097119,0.992802030795952,
            0.992750160620713,0.992698290445474,0.992646420270236,0.992594550094997,
            0.992542679919758,0.99249080974452,0.992438939569281,0.992387069394042,
            0.992334413307058,0.992281757220073,0.992229887044834,0.992178016869596,
            0.992126146694357,0.992074276519118,0.99202240634388,0.991970536168641,
            0.991918665993402,0.991866795818164,0.991814925642925,0.991763055467686,
            0.991711185292448,0.991658529205463,0.991606659030224,0.991554788854985,
            0.991502918679747,0.991451048504508,0.991399178329269,0.991347308154031,
            0.991295437978792,0.991243567803553,0.991191697628315,0.991139827453076,
            0.991087957277837,0.991036087102599,0.991027049117519,0.991018207610376,
            0.99100956258117,0.9910011140299,0.990992861956567,0.99098480636117,
            0.990976947243709,0.990969284604185,0.990960246619106,0.990951405111963,
            0.990942760082757,0.990934311531487,0.990926059458153,0.990918003862756,
            0.990910144745296,0.990902482105772,0.990893640598629,0.990884995569423,
            0.990876547018153,0.990868294944819,0.990860239349422,0.990852380231962,
            0.990844717592438,0.990836072563231,0.990827624011962,0.990819371938628,
            0.990811316343231,0.990803457225771,0.990795794586247,0.990787346034977,
            0.990779093961644,0.990771038366247,0.990763179248786,0.990755516609262,
            0.990747264535929,0.990739208940532,0.990731349823072,0.990723687183548,
            0.990715631588151,0.99070777247069,0.990700109831167,0.990692250713706,
            0.990684588074182,0.990676925434658,0.990667887449579,0.990659045942436,
            0.990650400913229,0.99064195236196,0.990633700288626,0.990625644693229,
            0.990617785575769,0.990610122936245,0.990601281429102,0.990592636399895,
            0.990584187848626,0.990575935775292,0.990567880179895,0.990560021062435,
            0.990552358422911,0.990543713393705,0.990535264842434,0.990527012769101,
            0.990518957173704,0.990511098056244,0.99050343541672,0.99049498686545,
            0.990486734792117,0.99047867919672,0.990470820079259,0.990463157439735,
            0.990454905366402,0.990446849771005,0.990438990653545,0.990431328014021,
            0.990423272418624,0.990415413301163,0.990407750661639,0.990399891544179,
            0.990392228904655,0.990384566265131,0.990375724757988,0.990367079728782,
            0.990358631177512,0.990350379104178,0.990342323508782,0.990334464391321,
            0.990326801751797,0.990318156722591,0.990309708171321,0.990301456097987,
            0.990293400502591,0.99028554138513,0.990277878745606,0.990269430194336,
            0.990261178121003,0.990253122525606,0.990245263408146,0.990237600768622,
            0.990229348695288,0.990221293099891,0.990213433982431,0.990205771342907,
            0.99019771574751,0.99018985663005,0.990182193990526,0.990174334873065,
            0.990166672233541,0.990159009594018,0.990150364564811,0.990141916013541,
            0.990133663940208,0.990125608344811,0.990117749227351,0.990110086587827,
            0.990101638036557,0.990093385963223,0.990085330367826,0.990077471250366,
            0.990069808610842,0.990061556537509,0.990053500942112,0.990045641824651,
            0.990037979185127,0.990029923589731,0.99002206447227,0.990014401832746,
            0.990006542715286,0.989998880075762,0.989991217436238,0.989982768884968,
            0.989974516811635,0.989966461216238,0.989958602098777,0.989950939459253,
            0.98994268738592,0.989934631790523,0.989926772673063,0.989919110033539,
            0.989911054438142,0.989903195320681,0.989895532681158,0.989887673563697,
            0.989880010924173,0.989872348284649,0.989864096211316,0.989856040615919,
            0.989848181498459,0.989840518858935,0.989832463263538,0.989824604146077,
            0.989816941506554,0.989809082389093,0.989801419749569,0.989793757110045,
            0.989785701514648,0.989777842397188,0.989770179757664,0.989762320640204,
            0.98975465800068,0.989746995361156,0.989739332721632,0.989731670082108,
            0.989724007442584,0.98971634480306,0.989707503295917,0.989698661788774,
            0.989690016759568,0.989681568208298,0.989673316134965,0.989665260539568,
            0.989657401422107,0.989649738782583,0.98964089727544,0.989632252246234,
            0.989623803694964,0.989615551621631,0.989607496026234,0.989599636908773,
            0.989591974269249,0.989583329240043,0.989574880688773,0.98956662861544,
            0.989558573020043,0.989550713902582,0.989543051263058,0.989534602711789,
            0.989526350638455,0.989518295043058,0.989510435925598,0.989502773286074,
            0.98949452121274,0.989486465617344,0.989478606499883,0.989470943860359,
            0.989462888264962,0.989455029147502,0.989447366507978,0.989439507390518,
            0.989431844750994,0.98942418211147,0.989415340604327,0.98940669557512,
            0.98939824702385,0.989389994950517,0.98938193935512,0.98937408023766,
            0.989366417598136,0.989357772568929,0.989349324017659,0.989341071944326,
            0.989333016348929,0.989325157231469,0.989317494591945,0.989309046040675,
            0.989300793967341,0.989292738371945,0.989284879254484,0.98927721661496,
            0.989268964541627,0.98926090894623,0.989253049828769,0.989245387189246,
            0.989237331593849,0.989229472476388,0.989221809836864,0.989213950719404,
            0.98920628807988,0.989198625440356,0.98918998041115,0.98918153185988,
            0.989173279786546,0.989165224191149,0.989157365073689,0.989149702434165,
            0.989141253882895,0.989133001809562,0.989124946214165,0.989117087096704,
            0.989109424457181,0.989101172383847,0.98909311678845,0.98908525767099,
            0.989077595031466,0.989069539436069,0.989061680318609,0.989054017679085,
            0.989046158561624,0.9890384959221,0.989030833282577,0.989022384731307,
            0.989014132657973,0.989006077062576,0.988998217945116,0.988990555305592,
            0.988982303232259,0.988974247636862,0.988966388519401,0.988958725879877,
            0.98895067028448,0.98894281116702,0.988935148527496,0.988927289410036,
            0.988919626770512,0.988911964130988,0.988903712057654,0.988895656462258,
            0.988887797344797,0.988880134705273,0.988872079109876,0.988864219992416,
            0.988856557352892,0.988848698235432,0.988841035595908,0.988833372956384,
            0.988825317360987,0.988817458243527,0.988809795604003,0.988801936486542,
            0.988794273847018,0.988786611207494,0.988778948567971,0.988771285928447,
            0.988763623288923,0.988755960649399,0.988747315620192,0.988738670590986,
            0.988730222039716,0.988721969966383,0.988713914370986,0.988706055253525,
            0.988698392614001,0.988689747584795,0.988681299033525,0.988673046960192,
            0.988664991364795,0.988657132247334,0.98864946960781,0.988641021056541,
            0.988632768983207,0.98862471338781,0.98861685427035,0.988609191630826,
            0.988600939557492,0.988592883962095,0.988585024844635,0.988577362205111,
            0.988569306609714,0.988561447492254,0.98855378485273,0.98854592573527,
            0.988538263095746,0.988530600456222,0.988521955427015,0.988513506875745,
            0.988505254802412,0.988497199207015,0.988489340089555,0.988481677450031,
            0.988473228898761,0.988464976825427,0.98845692123003,0.98844906211257,
            0.988441399473046,0.988433147399713,0.988425091804316,0.988417232686855,
            0.988409570047332,0.988401514451935,0.988393655334474,0.98838599269495,
            0.98837813357749,0.988370470937966,0.988362808298442,0.988354359747172,
            0.988346107673839,0.988338052078442,0.988330192960981,0.988322530321458,
            0.988314278248124,0.988306222652727,0.988298363535267,0.988290700895743,
            0.988282645300346,0.988274786182886,0.988267123543362,0.988259264425901,
            0.988251601786377,0.988243939146853,0.98823568707352,0.988227631478123,
            0.988219772360663,0.988212109721139,0.988204054125742,0.988196195008282,
            0.988188532368758,0.988180673251297,0.988173010611773,0.988165347972249,
            0.988157292376853,0.988149433259392,0.988141770619868,0.988133911502408,
            0.988126248862884,0.98811858622336,0.988110923583836,0.988103260944312,
            0.988095598304788,0.988087935665264,0.988079487113995,0.988071038562725,
            0.988062786489391,0.988054730893994,0.988046871776534,0.98803920913701,
            0.98803076058574,0.988022508512407,0.98801445291701,0.988006593799549,
            0.987998931160025,0.987990679086692,0.987982623491295,0.987974764373835,
            0.987967101734311,0.987959046138914,0.987951187021453,0.98794352438193,
            0.987935665264469,0.987928002624945,0.987920339985421,0.987911891434151,
            0.987903639360818,0.987895583765421,0.987887724647961,0.987880062008437,
            0.987871809935103,0.987863754339706,0.987855895222246,0.987848232582722,
            0.987840176987325,0.987832317869865,0.987824655230341,0.987816796112881,
            0.987809133473357,0.987801470833833,0.987793218760499,0.987785163165102,
            0.987777304047642,0.987769641408118,0.987761585812721,0.987753726695261,
            0.987746064055737,0.987738204938276,0.987730542298753,0.987722879659229,
            0.987714824063832,0.987706964946371,0.987699302306847,0.987691443189387,
            0.987683780549863,0.987676117910339,0.987668455270815,0.987660792631291,
            0.987653129991768,0.987645467352244,0.98763721527891,0.987628963205577,
            0.98762090761018,0.987613048492719,0.987605385853196,0.987597133779862,
            0.987589078184465,0.987581219067005,0.987573556427481,0.987565500832084,
            0.987557641714624,0.9875499790751,0.987542119957639,0.987534457318116,
            0.987526794678592,0.987518542605258,0.987510487009861,0.987502627892401,
            0.987494965252877,0.98748690965748,0.98747905054002,0.987471387900496,
            0.987463528783035,0.987455866143511,0.987448203503988,0.987440147908591,
            0.98743228879113,0.987424626151606,0.987416767034146,0.987409104394622,
            0.987401441755098,0.987393779115574,0.98738611647605,0.987378453836526,
            0.987370791197003,0.987362735601606,0.987354680006209,0.987346820888748,
            0.987339158249224,0.987331102653828,0.987323243536367,0.987315580896843,
            0.987307721779383,0.987300059139859,0.987292396500335,0.987284340904938,
            0.987276481787478,0.987268819147954,0.987260960030493,0.987253297390969,
            0.987245634751446,0.987237972111922,0.987230309472398,0.987222646832874,
            0.98721498419335,0.98720712507589,0.987199265958429,0.987191603318905,
            0.987183744201445,0.987176081561921,0.987168418922397,0.987160756282873,
            0.987153093643349,0.987145431003825,0.987137768364302,0.987130105724778,
            0.987122443085254,0.98711478044573,0.987107117806206,0.987098276299063,
            0.987089631269857,0.987081182718587,0.987072930645253,0.987064875049856,
            0.987057015932396,0.987049353292872,0.987040511785729,0.987031866756523,
            0.987023418205253,0.987015166131919,0.987007110536522,0.986999251419062,
            0.986991588779538,0.986982943750332,0.986974495199062,0.986966243125728,
            0.986958187530331,0.986950328412871,0.986942665773347,0.986934217222077,
            0.986925965148744,0.986917909553347,0.986910050435886,0.986902387796362,
            0.986894135723029,0.986886080127632,0.986878221010172,0.986870558370648,
            0.986862502775251,0.98685464365779,0.986846981018267,0.986839121900806,
            0.986831459261282,0.986823796621758,0.986814955114615,0.986806310085409,
            0.986797861534139,0.986789609460806,0.986781553865409,0.986773694747948,
            0.986766032108424,0.986757387079218,0.986748938527948,0.986740686454615,
            0.986732630859218,0.986724771741757,0.986717109102233,0.986708660550963,
            0.98670040847763,0.986692352882233,0.986684493764773,0.986676831125249,
            0.986668579051915,0.986660523456518,0.986652664339058,0.986645001699534,
            0.986636946104137,0.986629086986677,0.986621424347153,0.986613565229693,
            0.986605902590169,0.986598239950645,0.986589594921438,0.986581146370168,
            0.986572894296835,0.986564838701438,0.986556979583978,0.986549316944454,
            0.986540868393184,0.98653261631985,0.986524560724453,0.986516701606993,
            0.986509038967469,0.986500786894136,0.986492731298739,0.986484872181278,
            0.986477209541755,0.986469153946358,0.986461294828897,0.986453632189373,
            0.986445773071913,0.986438110432389,0.986430447792865,0.986421999241595,
            0.986413747168262,0.986405691572865,0.986397832455404,0.986390169815881,
            0.986381917742547,0.98637386214715,0.98636600302969,0.986358340390166,
            0.986350284794769,0.986342425677309,0.986334763037785,0.986326903920324,
            0.9863192412808,0.986311578641276,0.986303326567943,0.986295270972546,
            0.986287411855086,0.986279749215562,0.986271693620165,0.986263834502704,
            0.986256171863181,0.98624831274572,0.986240650106196,0.986232987466672,
            0.986224931871275,0.986217072753815,0.986209410114291,0.986201550996831,
            0.986193888357307,0.986186225717783,0.986178366600323,0.986170703960799,
            0.986163041321275,0.986155378681751,0.986146733652544,0.986138088623338,
            0.986129640072068,0.986121387998735,0.986113332403338,0.986105473285877,
            0.986097810646353,0.986089165617147,0.986080717065877,0.986072464992544,
            0.986064409397147,0.986056550279686,0.986048887640162,0.986040439088892,
            0.986032187015559,0.986024131420162,0.986016272302702,0.986008609663178,
            0.986000357589845,0.985992301994448,0.985984442876987,0.985976780237463,
            0.985968724642066,0.985960865524606,0.985953202885082,0.985945343767622,
            0.985937681128098,0.985930018488574,0.985921373459367,0.985912924908097,
            0.985904672834764,0.985896617239367,0.985888758121907,0.985881095482383,
            0.985872646931113,0.985864394857779,0.985856339262383,0.985848480144922,
            0.985840817505398,0.985832565432065,0.985824509836668,0.985816650719207,
            0.985808988079684,0.985800932484287,0.985793073366826,0.985785410727302,
            0.985777551609842,0.985769888970318,0.985762226330794,0.985753777779524,
            0.985745525706191,0.985737470110794,0.985729610993333,0.98572194835381,
            0.985713696280476,0.985705640685079,0.985697781567619,0.985690118928095,
            0.985682063332698,0.985674204215238,0.985666541575714,0.985658682458253,
            0.985651019818729,0.985643357179206,0.985635105105872,0.985627049510475,
            0.985619190393015,0.985611527753491,0.985603472158094,0.985595613040634,
            0.98558795040111,0.985580091283649,0.985572428644125,0.985564766004602,
            0.985556710409205,0.985548851291744,0.98554118865222,0.98553332953476,
            0.985525666895236,0.985518004255712,0.985510145138252,0.985502482498728,
            0.985494819859204,0.98548715721968,0.98547870866841,0.98547026011714,
            0.985462008043807,0.98545395244841,0.985446093330949,0.985438430691426,
            0.985429982140156,0.985421730066822,0.985413674471425,0.985405815353965,
            0.985398152714441,0.985389900641108,0.985381845045711,0.98537398592825,
            0.985366323288726,0.985358267693329,0.985350408575869,0.985342745936345,
            0.985334886818885,0.985327224179361,0.985319561539837,0.985311112988567,
            0.985302860915234,0.985294805319837,0.985286946202376,0.985279283562852,
            0.985271031489519,0.985262975894122,0.985255116776662,0.985247454137138,
            0.985239398541741,0.98523153942428,0.985223876784756,0.985216017667296,
            0.985208355027772,0.985200692388248,0.985192440314915,0.985184384719518,
            0.985176525602057,0.985168862962534,0.985160807367137,0.985152948249676,
            0.985145285610152,0.985137426492692,0.985129763853168,0.985122101213644,
            0.985114045618247,0.985106186500787,0.985098523861263,0.985090664743803,
            0.985083002104279,0.985075339464755,0.985067480347294,0.985059817707771,
            0.985052155068247,0.985044492428723,0.985036240355389,0.985027988282056,
            0.985019932686659,0.985012073569199,0.985004410929675,0.984996158856341,
            0.984988103260944,0.984980244143484,0.98497258150396,0.984964525908563,
            0.984956666791103,0.984949004151579,0.984941145034118,0.984933482394595,
            0.984925819755071,0.984917567681737,0.98490951208634,0.98490165296888,
            0.984893990329356,0.984885934733959,0.984878075616499,0.984870412976975,
            0.984862553859514,0.98485489121999,0.984847228580467,0.98483917298507,
            0.984831313867609,0.984823651228085,0.984815792110625,0.984808129471101,
            0.984800466831577,0.984792607714117,0.984784945074593,0.984777282435069,
            0.984769619795545,0.984761564200148,0.984753508604751,0.984745649487291,
            0.984737986847767,0.98472993125237,0.98472207213491,0.984714409495386,
            0.984706550377925,0.984698887738401,0.984691225098878,0.984683169503481,
            0.98467531038602,0.984667647746496,0.984659788629036,0.984652125989512,
            0.984644463349988,0.984636604232528,0.984628941593004,0.98462127895348,
            0.984613616313956,0.984605757196496,0.984597898079035,0.984590235439511,
            0.984582376322051,0.984574713682527,0.984567051043003,0.984559191925543,
            0.984551529286019,0.984543866646495,0.984536204006971,0.984528541367447,
            0.984520878727923,0.984513216088399,0.984505553448875,0.984497890809352,
            0.984489245780145,0.984480797228875,0.984472545155542,0.984464489560145,
            0.984456630442684,0.98444896780316,0.984440322773954,0.984431874222684,
            0.984423622149351,0.984415566553954,0.984407707436493,0.98440004479697,
            0.9843915962457,0.984383344172366,0.984375288576969,0.984367429459509,
            0.984359766819985,0.984351514746652,0.984343459151255,0.984335600033794,
            0.98432793739427,0.984319881798873,0.984312022681413,0.984304360041889,
            0.984296500924429,0.984288838284905,0.984281175645381,0.984272530616174,
            0.984264082064905,0.984255829991571,0.984247774396174,0.984239915278714,
            0.98423225263919,0.98422380408792,0.984215552014587,0.98420749641919,
            0.984199637301729,0.984191974662205,0.984183722588872,0.984175666993475,
            0.984167807876015,0.984160145236491,0.984152089641094,0.984144230523633,
            0.984136567884109,0.984128708766649,0.984121046127125,0.984113383487601,
            0.984104934936331,0.984096682862998,0.984088627267601,0.984080768150141,
            0.984073105510617,0.984064853437283,0.984056797841886,0.984048938724426,
            0.984041276084902,0.984033220489505,0.984025361372045,0.984017698732521,
            0.98400983961506,0.984002176975536,0.983994514336013,0.983986262262679,
            0.983978206667282,0.983970347549822,0.983962684910298,0.983954629314901,
            0.983946770197441,0.983939107557917,0.983931248440456,0.983923585800933,
            0.983915923161409,0.983907867566012,0.983900008448551,0.983892345809027,
            0.983884486691567,0.983876824052043,0.983869161412519,0.983861302295059,
            0.983853639655535,0.983845977016011,0.983838314376487,0.983829865825217,
            0.983821417273947,0.983813165200614,0.983805109605217,0.983797250487756,
            0.983789587848233,0.983781139296963,0.983772887223629,0.983764831628232,
            0.983756972510772,0.983749309871248,0.983741057797915,0.983733002202518,
            0.983725143085057,0.983717480445533,0.983709424850136,0.983701565732676,
            0.983693903093152,0.983686043975692,0.983678381336168,0.983670718696644,
            0.983662270145374,0.983654018072041,0.983645962476644,0.983638103359183,
            0.983630440719659,0.983622188646326,0.983614133050929,0.983606273933469,
            0.983598611293945,0.983590555698548,0.983582696581087,0.983575033941564,
            0.983567174824103,0.983559512184579,0.983551849545055,0.983543597471722,
            0.983535541876325,0.983527682758865,0.983520020119341,0.983511964523944,
            0.983504105406483,0.983496442766959,0.983488583649499,0.983480921009975,
            0.983473258370451,0.983465202775054,0.983457343657594,0.98344968101807,
            0.98344182190061,0.983434159261086,0.983426496621562,0.983418637504102,
            0.983410974864578,0.983403312225054,0.98339564958553,0.983387397512196,
            0.983379145438863,0.983371089843466,0.983363230726006,0.983355568086482,
            0.983347316013148,0.983339260417751,0.983331401300291,0.983323738660767,
            0.98331568306537,0.98330782394791,0.983300161308386,0.983292302190925,
            0.983284639551402,0.983276976911878,0.983268724838544,0.983260669243147,
            0.983252810125687,0.983245147486163,0.983237091890766,0.983229232773306,
            0.983221570133782,0.983213711016321,0.983206048376797,0.983198385737274,
            0.983190330141877,0.983182471024416,0.983174808384892,0.983166949267432,
            0.983159286627908,0.983151623988384,0.983143764870924,0.9831361022314,
            0.983128439591876,0.983120776952352,0.983112721356955,0.983104665761558,
            0.983096806644098,0.983089144004574,0.983081088409177,0.983073229291717,
            0.983065566652193,0.983057707534732,0.983050044895209,0.983042382255685,
            0.983034326660288,0.983026467542827,0.983018804903303,0.983010945785843,
            0.983003283146319,0.982995620506795,0.982987761389335,0.982980098749811,
            0.982972436110287,0.982964773470763,0.982956914353303,0.982949055235842,
            0.982941392596318,0.982933533478858,0.982925870839334,0.98291820819981,
            0.98291034908235,0.982902686442826,0.982895023803302,0.982887361163778,
            0.982879698524254,0.98287203588473,0.982864373245206,0.982856710605683,
            0.982849047966159,0.982840599414889,0.982832347341555,0.982824291746158,
            0.982816432628698,0.982808769989174,0.982800321437904,0.982792069364571,
            0.982784013769174,0.982776154651713,0.98276849201219,0.982760239938856,
            0.982752184343459,0.982744325225999,0.982736662586475,0.982728606991078,
            0.982720747873618,0.982713085234094,0.982705226116633,0.982697563477109,
            0.982689900837585,0.982681452286316,0.982673200212982,0.982665144617585,
            0.982657285500125,0.982649622860601,0.982641370787267,0.982633315191871,
            0.98262545607441,0.982617793434886,0.982609737839489,0.982601878722029,
            0.982594216082505,0.982586356965045,0.982578694325521,0.982571031685997,
            0.982562779612663,0.982554724017267,0.982546864899806,0.982539202260282,
            0.982531146664885,0.982523287547425,0.982515624907901,0.982507765790441,
            0.982500103150917,0.982492440511393,0.982484384915996,0.982476525798536,
            0.982468863159012,0.982461004041551,0.982453341402027,0.982445678762503,
            0.982437819645043,0.982430157005519,0.982422494365995,0.982414831726471,
            0.982406579653138,0.982398327579804,0.982390271984408,0.982382412866947,
            0.982374750227423,0.98236649815409,0.982358442558693,0.982350583441232,
            0.982342920801709,0.982334865206312,0.982327006088851,0.982319343449327,
            0.982311484331867,0.982303821692343,0.982296159052819,0.982287906979486,
            0.982279851384089,0.982271992266628,0.982264329627105,0.982256274031708,
            0.982248414914247,0.982240752274723,0.982232893157263,0.982225230517739,
            0.982217567878215,0.982209512282818,0.982201653165358,0.982193990525834,
            0.982186131408374,0.98217846876885,0.982170806129326,0.982162947011865,
            0.982155284372341,0.982147621732818,0.982139959093294,0.982131903497897,
            0.9821238479025,0.982115988785039,0.982108326145515,0.982100270550119,
            0.982092411432658,0.982084748793134,0.982076889675674,0.98206922703615,
            0.982061564396626,0.982053508801229,0.982045649683769,0.982037987044245,
            0.982030127926784,0.982022465287261,0.982014802647737,0.982006943530276,
            0.981999280890752,0.981991618251228,0.981983955611705,0.981976096494244,
            0.981968237376784,0.98196057473726,0.981952715619799,0.981945052980276,
            0.981937390340752,0.981929531223291,0.981921868583767,0.981914205944244,
            0.98190654330472,0.981898880665196,0.981891218025672,0.981883555386148,
            0.981875892746624,0.9818682301071,0.981859978033767,0.98185192243837,
            0.981844063320909,0.981836400681385,0.981828148608052,0.981820093012655,
            0.981812233895195,0.981804571255671,0.981796515660274,0.981788656542814,
            0.98178099390329,0.981773134785829,0.981765472146305,0.981757809506781,
            0.981749557433448,0.981741501838051,0.981733642720591,0.981725980081067,
            0.98171792448567,0.981710065368209,0.981702402728686,0.981694543611225,
            0.981686880971701,0.981679218332177,0.98167116273678,0.98166330361932,
            0.981655640979796,0.981647781862336,0.981640119222812,0.981632456583288,
            0.981624597465828,0.981616934826304,0.98160927218678,0.981601609547256,
            0.981593553951859,0.981585498356462,0.981577639239002,0.981569976599478,
            0.981561921004081,0.98155406188662,0.981546399247097,0.981538540129636,
            0.981530877490112,0.981523214850588,0.981515159255191,0.981507300137731,
            0.981499637498207,0.981491778380747,0.981484115741223,0.981476453101699,
            0.981468593984239,0.981460931344715,0.981453268705191,0.981445606065667,
            0.981437746948206,0.981429887830746,0.981422225191222,0.981414366073762,
            0.981406703434238,0.981399040794714,0.981391181677254,0.98138351903773,
            0.981375856398206,0.981368193758682,0.981360531119158,0.981352868479634,
            0.98134520584011,0.981337543200586,0.981329880561062,0.981321824965665,
            0.981313965848205,0.981306303208681,0.981298247613284,0.981290388495824,
            0.9812827258563,0.98127486673884,0.981267204099316,0.981259541459792,
            0.981251485864395,0.981243626746934,0.981235964107411,0.98122810498995,
            0.981220442350426,0.981212779710902,0.981204920593442,0.981197257953918,
            0.981189595314394,0.98118193267487,0.98117407355741,0.981166214439949,
            0.981158551800426,0.981150692682965,0.981143030043441,0.981135367403917,
            0.981127508286457,0.981119845646933,0.981112183007409,0.981104520367885,
            0.981096857728361,0.981089195088838,0.981081532449314,0.98107386980979,
            0.981066207170266,0.981058348052805,0.981050685413282,0.981042826295821,
            0.981035163656297,0.981027501016773,0.981019641899313,0.981011979259789,
            0.981004316620265,0.980996653980741,0.980988991341217,0.980981328701693,
            0.98097366606217,0.980966003422646,0.980958340783122,0.980950678143598,
            0.980943015504074,0.98093535286455,0.980927690225026,0.978973717146433,
            0.977217204394033,0.975460691641632,0.973704178889232,0.971947666136831,
            0.970191153384431,0.96843464063203,0.96667812787963,0.964921615127229,
            0.963165102374829,0.963039356495462,0.962926185204033,0.962825588500539,
            0.962737566384983,0.962662118857363,0.96259924591768,0.962548947565933,
            0.962511223802123,0.96248607462625,0.962473500038313,0.962473500038313,
            0.962360328746883,0.96225973204339,0.962171709927834,0.962096262400214,
            0.962033389460531,0.961983091108784,0.961945367344974,0.961920218169101,
            0.961907643581164,0.961907643581164,0.961807046877671,0.961719024762114,
            0.961643577234494,0.961580704294811,0.961530405943065,0.961492682179255,
            0.961467533003381,0.961454958415445,0.961454958415445,0.961366936299888,
            0.961291488772268,0.961228615832585,0.961178317480838,0.961140593717029,
            0.961115444541155,0.961102869953219,0.961102869953219,0.961027422425599,
            0.960964549485915,0.960914251134169,0.960876527370359,0.960851378194486,
            0.960838803606549,0.960838803606549,0.960775930666866,0.960725632315119,
            0.960687908551309,0.960662759375436,0.960650184787499,0.960650184787499,
            0.960599886435753,0.960562162671943,0.960537013496069,0.960524438908133,
            0.960524438908133,0.960486715144323,0.96046156596845,0.960448991380513,
            0.960448991380513,0.96042384220464,0.960411267616703,0.960411267616703,
            0.960398693028766,0.960398693028766,0.960398693028766,0.9602729471494,
            0.96015977585797,0.960059179154477,0.95997115703892,0.9598957095113,
            0.959832836571617,0.959782538219871,0.959744814456061,0.959719665280187,
            0.959707090692251,0.959707090692251,0.959593919400821,0.959493322697328,
            0.959405300581771,0.959329853054151,0.959266980114468,0.959216681762721,
            0.959178957998912,0.959153808823038,0.959141234235102,0.959141234235102,
            0.959040637531608,0.958952615416052,0.958877167888432,0.958814294948749,
            0.958763996597002,0.958726272833192,0.958701123657319,0.958688549069382,
            0.958688549069382,0.958600526953826,0.958525079426206,0.958462206486523,
            0.958411908134776,0.958374184370966,0.958349035195093,0.958336460607156,
            0.958336460607156,0.958261013079536,0.958198140139853,0.958147841788106,
            0.958110118024296,0.958084968848423,0.958072394260487,0.958072394260487,
            0.958009521320803,0.957959222969057,0.957921499205247,0.957896350029373,
            0.957883775441437,0.957883775441437,0.95783347708969,0.95779575332588,
            0.957770604150007,0.95775802956207,0.95775802956207,0.95772030579826,
            0.957695156622387,0.95768258203445,0.95768258203445,0.957657432858577,
            0.95764485827064,0.95764485827064,0.957632283682704,0.957632283682704,
            0.957632283682704,0.957506537803337,0.957393366511908,0.957292769808414,
            0.957204747692858,0.957129300165238,0.957066427225555,0.957016128873808,
            0.956978405109998,0.956953255934125,0.956940681346188,0.956940681346188,
            0.956827510054758,0.956726913351265,0.956638891235709,0.956563443708089,
            0.956500570768406,0.956450272416659,0.956412548652849,0.956387399476976,
            0.956374824889039,0.956374824889039,0.956274228185546,0.956186206069989,
            0.956110758542369,0.956047885602686,0.95599758725094,0.95595986348713,
            0.955934714311256,0.95592213972332,0.95592213972332,0.955834117607763,
            0.955758670080143,0.95569579714046,0.955645498788714,0.955607775024904,
            0.95558262584903,0.955570051261094,0.955570051261094,0.955494603733474,
            0.955431730793791,0.955381432442044,0.955343708678234,0.955318559502361,
            0.955305984914424,0.955305984914424,0.955243111974741,0.955192813622994,
            0.955155089859184,0.955129940683311,0.955117366095374,0.955117366095374,
            0.955067067743628,0.955029343979818,0.955004194803944,0.954991620216008,
            0.954991620216008,0.954953896452198,0.954928747276325,0.954916172688388,
            0.954916172688388,0.954891023512515,0.954878448924578,0.954878448924578,
            0.954865874336641,0.954865874336641,0.954865874336641,0.954740128457275,
            0.954626957165845,0.954526360462352,0.954438338346795,0.954362890819175,
            0.954300017879492,0.954249719527746,0.954211995763936,0.954186846588062,
            0.954174272000126,0.954174272000126,0.954061100708696,0.953960504005203,
            0.953872481889646,0.953797034362026,0.953734161422343,0.953683863070596,
            0.953646139306787,0.953620990130913,0.953608415542977,0.953608415542977,
            0.953507818839483,0.953419796723927,0.953344349196307,0.953281476256624,
            0.953231177904877,0.953193454141067,0.953168304965194,0.953155730377257,
            0.953155730377257,0.953067708261701,0.952992260734081,0.952929387794398,
            0.952879089442651,0.952841365678841,0.952816216502968,0.952803641915031,
            0.952803641915031,0.952728194387411,0.952665321447728,0.952615023095981,
            0.952577299332172,0.952552150156298,0.952539575568362,0.952539575568362,
            0.952476702628678,0.952426404276932,0.952388680513122,0.952363531337248,
            0.952350956749312,0.952350956749312,0.952300658397565,0.952262934633755,
            0.952237785457882,0.952225210869945,0.952225210869945,0.952187487106135,
            0.952162337930262,0.952149763342325,0.952149763342325,0.952124614166452,
            0.952112039578516,0.952112039578516,0.952099464990579,0.952099464990579,
            0.952099464990579,0.951973719111212,0.951860547819783,0.951759951116289,
            0.951671929000733,0.951596481473113,0.95153360853343,0.951483310181683,
            0.951445586417873,0.951420437242,0.951407862654063,0.951407862654063,
            0.951294691362633,0.95119409465914,0.951106072543584,0.951030625015964,
            0.950967752076281,0.950917453724534,0.950879729960724,0.950854580784851,
            0.950842006196914,0.950842006196914,0.950741409493421,0.950653387377864,
            0.950577939850245,0.950515066910561,0.950464768558815,0.950427044795005,
            0.950401895619131,0.950389321031195,0.950389321031195,0.950301298915638,
            0.950225851388018,0.950162978448335,0.950112680096589,0.950074956332779,
            0.950049807156905,0.950037232568969,0.950037232568969,0.949961785041349,
            0.949898912101666,0.949848613749919,0.949810889986109,0.949785740810236,
            0.949773166222299,0.949773166222299,0.949710293282616,0.949659994930869,
            0.949622271167059,0.949597121991186,0.949584547403249,0.949584547403249,
            0.949534249051503,0.949496525287693,0.94947137611182,0.949458801523883,
            0.949458801523883,0.949421077760073,0.9493959285842,0.949383353996263,
            0.949383353996263,0.94935820482039,0.949345630232453,0.949345630232453,
            0.949333055644516,0.949333055644516,0.949333055644516,0.94920730976515,
            0.94909413847372,0.948993541770227,0.94890551965467,0.948830072127051,
            0.948767199187367,0.948716900835621,0.948679177071811,0.948654027895937,
            0.948641453308001,0.948641453308001,0.948528282016571,0.948427685313078,
            0.948339663197521,0.948264215669901,0.948201342730218,0.948151044378472,
            0.948113320614662,0.948088171438788,0.948075596850852,0.948075596850852,
            0.947975000147358,0.947886978031802,0.947811530504182,0.947748657564499,
            0.947698359212752,0.947660635448942,0.947635486273069,0.947622911685132,
            0.947622911685132,0.947534889569576,0.947459442041956,0.947396569102273,
            0.947346270750526,0.947308546986716,0.947283397810843,0.947270823222906,
            0.947270823222906,0.947195375695286,0.947132502755603,0.947082204403856,
            0.947044480640047,0.947019331464173,0.947006756876237,0.947006756876237,
            0.946943883936553,0.946893585584807,0.946855861820997,0.946830712645124,
            0.946818138057187,0.946818138057187,0.94676783970544,0.94673011594163,
            0.946704966765757,0.94669239217782,0.94669239217782,0.94665466841401,
            0.946629519238137,0.946616944650201,0.946616944650201,0.946591795474327,
            0.946579220886391,0.946579220886391,0.946566646298454,0.946566646298454,
            0.946566646298454,0.946440900419087,0.946327729127658,0.946227132424164,
            0.946139110308608,0.946063662780988,0.946000789841305,0.945950491489558,
            0.945912767725748,0.945887618549875,0.945875043961938,0.945875043961938,
            0.945761872670508,0.945661275967015,0.945573253851459,0.945497806323839,
            0.945434933384156,0.945384635032409,0.945346911268599,0.945321762092726,
            0.945309187504789,0.945309187504789,0.945208590801296,0.945120568685739,
            0.94504512115812,0.944982248218436,0.94493194986669,0.94489422610288,
            0.944869076927007,0.94485650233907,0.94485650233907,0.944768480223513,
            0.944693032695893,0.94463015975621,0.944579861404464,0.944542137640654,
            0.94451698846478,0.944504413876844,0.944504413876844,0.944428966349224,
            0.944366093409541,0.944315795057794,0.944278071293984,0.944252922118111,
            0.944240347530174,0.944240347530174,0.944177474590491,0.944127176238744,
            0.944089452474934,0.944064303299061,0.944051728711124,0.944051728711124,
            0.944001430359378,0.943963706595568,0.943938557419695,0.943925982831758,
            0.943925982831758,0.943888259067948,0.943863109892075,0.943850535304138,
            0.943850535304138,0.943825386128265,0.943812811540328,0.943812811540328,
            0.943800236952391,0.943800236952391,0.943800236952391,0.943674491073025,
            0.943561319781595,0.943460723078102,0.943372700962545,0.943297253434926,
            0.943234380495242,0.943184082143496,0.943146358379686,0.943121209203812,
            0.943108634615876,0.943108634615876,0.942995463324446,0.942894866620953,
            0.942806844505396,0.942731396977776,0.942668524038093,0.942618225686347,
            0.942580501922537,0.942555352746663,0.942542778158727,0.942542778158727,
            0.942442181455234,0.942354159339677,0.942278711812057,0.942215838872374,
            0.942165540520627,0.942127816756817,0.942102667580944,0.942090092993007,
            0.942090092993007,0.942002070877451,0.941926623349831,0.941863750410148,
            0.941813452058401,0.941775728294591,0.941750579118718,0.941738004530781,
            0.941738004530781,0.941662557003161,0.941599684063478,0.941549385711732,
            0.941511661947922,0.941486512772048,0.941473938184112,0.941473938184112,
            0.941411065244428,0.941360766892682,0.941323043128872,0.941297893952999,
            0.941285319365062,0.941285319365062,0.941235021013315,0.941197297249505,
            0.941172148073632,0.941159573485695,0.941159573485695,0.941121849721886,
            0.941096700546012,0.941084125958076,0.941084125958076,0.941058976782202,
            0.941046402194266,0.941046402194266,0.941033827606329,0.941033827606329,
            0.941033827606329,0.940908081726962,0.940794910435533,0.940694313732039,
            0.940606291616483,0.940530844088863,0.94046797114918,0.940417672797433,
            0.940379949033623,0.94035479985775,0.940342225269813,0.940342225269813,
            0.940229053978384,0.94012845727489,0.940040435159334,0.939964987631714,
            0.939902114692031,0.939851816340284,0.939814092576474,0.939788943400601,
            0.939776368812664,0.939776368812664,0.939675772109171,0.939587749993614,
            0.939512302465995,0.939449429526311,0.939399131174565,0.939361407410755,
            0.939336258234882,0.939323683646945,0.939323683646945,0.939235661531388,
            0.939160214003768,0.939097341064085,0.939047042712339,0.939009318948529,
            0.938984169772655,0.938971595184719,0.938971595184719,0.938896147657099,
            0.938833274717416,0.938782976365669,0.938745252601859,0.938720103425986,
            0.938707528838049,0.938707528838049,0.938644655898366,0.938594357546619,
            0.938556633782809,0.938531484606936,0.938518910018999,0.938518910018999,
            0.938468611667253,0.938430887903443,0.93840573872757,0.938393164139633,
            0.938393164139633,0.938355440375823,0.93833029119995,0.938317716612013,
            0.938317716612013,0.93829256743614,0.938279992848203,0.938279992848203,
            0.938267418260266,0.938267418260266,0.938267418260266,0.9381416723809,
            0.93802850108947,0.937927904385977,0.93783988227042,0.937764434742801,
            0.937701561803117,0.937651263451371,0.937613539687561,0.937588390511688,
            0.937575815923751,0.937575815923751,0.937462644632321,0.937362047928828,
            0.937274025813271,0.937198578285651,0.937135705345968,0.937085406994222,
            0.937047683230412,0.937022534054538,0.937009959466602,0.937009959466602,
            0.936909362763109,0.936821340647552,0.936745893119932,0.936683020180249,
            0.936632721828502,0.936594998064692,0.936569848888819,0.936557274300882,
            0.936557274300882,0.936469252185326,0.936393804657706,0.936330931718023,
            0.936280633366276,0.936242909602466,0.936217760426593,0.936205185838656,
            0.936205185838656,0.936129738311036,0.936066865371353,0.936016567019607,
            0.935978843255797,0.935953694079923,0.935941119491987,0.935941119491987,
            0.935878246552303,0.935827948200557,0.935790224436747,0.935765075260874,
            0.935752500672937,0.935752500672937,0.93570220232119,0.93566447855738,
            0.935639329381507,0.93562675479357,0.93562675479357,0.935589031029761,
            0.935563881853887,0.935551307265951,0.935551307265951,0.935526158090077,
            0.935513583502141,0.935513583502141,0.935501008914204,0.935501008914204,
            0.935501008914204,0.935375263034838,0.935262091743408,0.935161495039915,
            0.935073472924358,0.934998025396738,0.934935152457055,0.934884854105308,
            0.934847130341498,0.934821981165625,0.934809406577688,0.934809406577688,
            0.934696235286259,0.934595638582765,0.934507616467209,0.934432168939589,
            0.934369295999906,0.934318997648159,0.934281273884349,0.934256124708476,
            0.934243550120539,0.934243550120539,0.934142953417046,0.93405493130149,
            0.93397948377387,0.933916610834186,0.93386631248244,0.93382858871863,
            0.933803439542757,0.93379086495482,0.93379086495482,0.933702842839263,
            0.933627395311644,0.93356452237196,0.933514224020214,0.933476500256404,
            0.93345135108053,0.933438776492594,0.933438776492594,0.933363328964974,
            0.933300456025291,0.933250157673544,0.933212433909734,0.933187284733861,
            0.933174710145924,0.933174710145924,0.933111837206241,0.933061538854494,
            0.933023815090684,0.932998665914811,0.932986091326874,0.932986091326874,
            0.932935792975128,0.932898069211318,0.932872920035445,0.932860345447508,
            0.932860345447508,0.932822621683698,0.932797472507825,0.932784897919888,
            0.932784897919888,0.932759748744015,0.932747174156078,0.932747174156078,
            0.932734599568142,0.932734599568142,0.932734599568142,0.932608853688775,
            0.932495682397345,0.932395085693852,0.932307063578296,0.932231616050676,
            0.932168743110992,0.932118444759246,0.932080720995436,0.932055571819563,
            0.932042997231626,0.932042997231626,0.931929825940196,0.931829229236703,
            0.931741207121146,0.931665759593526,0.931602886653843,0.931552588302097,
            0.931514864538287,0.931489715362413,0.931477140774477,0.931477140774477,
            0.931376544070984,0.931288521955427,0.931213074427807,0.931150201488124,
            0.931099903136377,0.931062179372567,0.931037030196694,0.931024455608757,
            0.931024455608757,0.930936433493201,0.930860985965581,0.930798113025898,
            0.930747814674151,0.930710090910341,0.930684941734468,0.930672367146531,
            0.930672367146531,0.930596919618911,0.930534046679228,0.930483748327482,
            0.930446024563672,0.930420875387798,0.930408300799862,0.930408300799862,
            0.930345427860178,0.930295129508432,0.930257405744622,0.930232256568749,
            0.930219681980812,0.930219681980812,0.930169383629065,0.930131659865255,
            0.930106510689382,0.930093936101446,0.930093936101446,0.930056212337636,
            0.930031063161762,0.930018488573826,0.930018488573826,0.929993339397952,
            0.929980764810016,0.929980764810016,0.929968190222079,0.929968190222079,
            0.929968190222079,0.929842444342713,0.929729273051283,0.92962867634779,
            0.929540654232233,0.929465206704613,0.92940233376493,0.929352035413183,
            0.929314311649373,0.9292891624735,0.929276587885563,0.929276587885563,
            0.929163416594134,0.92906281989064,0.928974797775084,0.928899350247464,
            0.928836477307781,0.928786178956034,0.928748455192224,0.928723306016351,
            0.928710731428414,0.928710731428414,0.928610134724921,0.928522112609365,
            0.928446665081745,0.928383792142061,0.928333493790315,0.928295770026505,
            0.928270620850632,0.928258046262695,0.928258046262695,0.928170024147138,
            0.928094576619519,0.928031703679835,0.927981405328089,0.927943681564279,
            0.927918532388405,0.927905957800469,0.927905957800469,0.927830510272849,
            0.927767637333166,0.927717338981419,0.927679615217609,0.927654466041736,
            0.927641891453799,0.927641891453799,0.927579018514116,0.927528720162369,
            0.927490996398559,0.927465847222686,0.92745327263475,0.92745327263475,
            0.927402974283003,0.927365250519193,0.92734010134332,0.927327526755383,
            0.927327526755383,0.927289802991573,0.9272646538157,0.927252079227763,
            0.927252079227763,0.92722693005189,0.927214355463953,0.927214355463953,
            0.927201780876017,0.927201780876017,0.927201780876017,0.92690824283887,
            0.926642997624582,0.926406045233151,0.926197385664577,0.92601701891886,
            0.925864944996002,0.925741163896,0.925645675618856,0.92557848016457,
            0.925539577533141,0.925528967724569,0.925246039495995,0.924980794281706,
            0.924743841890275,0.924535182321701,0.924354815575985,0.924202741653126,
            0.924078960553125,0.923983472275981,0.923916276821694,0.923877374190265,
            0.923866764381694,0.923583836153119,0.923329200747402,0.923092248355971,
            0.922883588787397,0.922703222041681,0.922551148118822,0.922427367018821,
            0.922331878741677,0.92226468328739,0.922225780655961,0.92221517084739,
            0.921932242618815,0.921677607213098,0.921451264630238,0.921242605061665,
            0.921062238315948,0.920910164393089,0.920786383293088,0.920690895015944,
            0.920623699561658,0.920584796930229,0.920574187121657,0.920291258893083,
            0.920036623487365,0.919810280904506,0.919612231144504,0.919431864398787,
            0.919279790475929,0.919156009375927,0.919060521098783,0.918993325644497,
            0.918954423013068,0.918943813204496,0.918660884975922,0.918406249570205,
            0.918179906987345,0.917981857227343,0.917812100290198,0.917660026367339,
            0.917536245267338,0.917440756990194,0.917373561535907,0.917334658904478,
            0.917324049095907,0.917041120867332,0.916786485461615,0.916560142878755,
            0.916362093118753,0.916192336181608,0.916050872067321,0.91592709096732,
            0.915831602690176,0.915764407235889,0.91572550460446,0.915714894795889,
            0.915431966567314,0.915177331161597,0.914950988578738,0.914752938818735,
            0.914583181881591,0.914441717767303,0.914328546475873,0.91423305819873,
            0.914165862744443,0.914126960113014,0.914116350304443,0.913833422075868,
            0.913578786670151,0.913352444087291,0.913154394327289,0.912984637390144,
            0.912843173275857,0.912730001984427,0.912645123515855,0.912577928061568,
            0.912539025430139,0.912528415621568,0.912245487392993,0.911990851987276,
            0.911764509404416,0.911566459644414,0.911396702707269,0.911255238592982,
            0.911142067301552,0.91105718883298,0.911000603187265,0.910961700555836,
            0.910951090747265,0.91066816251869,0.910413527112973,0.910187184530113,
            0.909989134770111,0.909819377832966,0.909677913718679,0.909564742427249,
            0.909479863958677,0.909423278312962,0.909394985490104,0.909384375681533,
            0.909101447452958,0.908846812047241,0.908620469464381,0.908422419704379,
            0.908252662767235,0.908111198652947,0.907998027361517,0.907913148892945,
            0.90785656324723,0.907828270424373,0.907828270424373,0.907545342195798,
            0.907280096981509,0.907043144590078,0.906834485021505,0.906654118275788,
            0.906502044352929,0.906378263252928,0.906282774975784,0.906215579521498,
            0.906176676890069,0.906166067081497,0.905883138852922,0.905628503447205,
            0.905391551055774,0.9051828914872,0.905002524741484,0.904850450818625,
            0.904726669718624,0.90463118144148,0.904563985987194,0.904525083355765,
            0.904514473547193,0.904231545318618,0.903976909912901,0.903750567330042,
            0.903541907761468,0.903361541015752,0.903209467092893,0.903085685992891,
            0.902990197715748,0.902923002261461,0.902884099630032,0.902873489821461,
            0.902590561592886,0.902335926187169,0.902109583604309,0.901911533844307,
            0.901731167098591,0.901579093175732,0.90145531207573,0.901359823798587,
            0.9012926283443,0.901253725712871,0.9012431159043,0.900960187675725,
            0.900705552270008,0.900479209687148,0.900281159927146,0.900111402990001,
            0.899959329067142,0.899835547967141,0.899740059689997,0.899672864235711,
            0.899633961604282,0.89962335179571,0.899340423567136,0.899085788161418,
            0.898859445578559,0.898661395818557,0.898491638881412,0.898350174767125,
            0.898226393667123,0.898130905389979,0.898063709935693,0.898024807304264,
            0.898014197495692,0.897731269267118,0.897476633861401,0.897250291278541,
            0.897052241518539,0.896882484581394,0.896741020467107,0.896627849175677,
            0.896532360898533,0.896465165444246,0.896426262812817,0.896415653004246,
            0.896132724775671,0.895878089369954,0.895651746787095,0.895453697027092,
            0.895283940089948,0.89514247597566,0.89502930468423,0.894944426215658,
            0.894877230761372,0.894838328129943,0.894827718321371,0.894544790092797,
            0.894290154687079,0.89406381210422,0.893865762344218,0.893696005407073,
            0.893554541292786,0.893441370001356,0.893356491532783,0.893299905887068,
            0.893261003255639,0.893250393447068,0.892967465218493,0.892712829812776,
            0.892486487229917,0.892288437469914,0.89211868053277,0.891977216418482,
            0.891864045127052,0.89177916665848,0.891722581012765,0.891694288189908,
            0.891683678381336,0.891400750152762,0.891146114747045,0.890919772164185,
            0.890721722404183,0.890551965467038,0.890410501352751,0.890297330061321,
            0.890212451592748,0.890155865947033,0.890127573124176,0.890127573124176,
            0.889844644895601,0.889590009489884,0.889353057098453,0.889144397529879,
            0.888964030784163,0.888811956861304,0.888688175761303,0.888592687484159,
            0.888525492029873,0.888486589398443,0.888475979589872,0.888193051361297,
            0.88793841595558,0.887712073372721,0.887503413804147,0.887323047058431,
            0.887170973135572,0.88704719203557,0.886951703758426,0.88688450830414,
            0.886845605672711,0.886834995864139,0.886552067635565,0.886297432229848,
            0.886071089646988,0.885873039886986,0.88569267314127,0.885540599218411,
            0.885416818118409,0.885321329841265,0.885254134386979,0.88521523175555,
            0.885204621946978,0.884921693718404,0.884667058312687,0.884440715729827,
            0.884242665969825,0.88407290903268,0.883920835109821,0.88379705400982,
            0.883701565732676,0.88363437027839,0.883595467646961,0.883584857838389,
            0.883301929609814,0.883047294204097,0.882820951621238,0.882622901861235,
            0.882453144924091,0.882311680809803,0.882187899709802,0.882092411432658,
            0.882025215978372,0.881986313346943,0.881975703538371,0.881692775309797,
            0.881438139904079,0.88121179732122,0.881013747561218,0.880843990624073,
            0.880702526509786,0.880589355218356,0.880493866941212,0.880426671486925,
            0.880387768855496,0.880377159046925,0.88009423081835,0.879839595412633,
            0.879613252829773,0.879415203069771,0.879245446132627,0.879103982018339,
            0.878990810726909,0.878905932258337,0.878838736804051,0.878799834172622,
            0.87878922436405,0.878506296135475,0.878251660729758,0.878025318146899,
            0.877827268386897,0.877657511449752,0.877516047335465,0.877402876044035,
            0.877317997575462,0.877261411929747,0.877222509298318,0.877211899489747,
            0.876928971261172,0.876674335855455,0.876447993272595,0.876249943512593,
            0.876080186575449,0.875938722461161,0.875825551169731,0.875740672701159,
            0.875684087055444,0.875655794232587,0.875645184424015,0.875362256195441,
            0.875107620789723,0.874881278206864,0.874683228446862,0.874513471509717,
            0.87437200739543,0.874258836104,0.874173957635427,0.874117371989712,
            0.874089079166855,0.874089079166855,0.87380615093828,0.873551515532563,
            0.873325172949704,0.87311651338113,0.872936146635414,0.872784072712555,
            0.872660291612553,0.872564803335409,0.872497607881123,0.872458705249694,
            0.872448095441122,0.872165167212548,0.871910531806831,0.871684189223971,
            0.871486139463969,0.871305772718253,0.871153698795394,0.871029917695392,
            0.870934429418249,0.870867233963962,0.870828331332533,0.870817721523961,
            0.870534793295387,0.87028015788967,0.87005381530681,0.869855765546808,
            0.869686008609663,0.869533934686804,0.869410153586803,0.869314665309659,
            0.869247469855373,0.869208567223944,0.869197957415372,0.868915029186797,
            0.86866039378108,0.868434051198221,0.868236001438218,0.868066244501074,
            0.867924780386786,0.867800999286785,0.867705511009641,0.867638315555355,
            0.867599412923926,0.867588803115354,0.86730587488678,0.867051239481062,
            0.866824896898203,0.866626847138201,0.866457090201056,0.866315626086769,
            0.866202454795339,0.866106966518195,0.866039771063908,0.866000868432479,
            0.865990258623908,0.865707330395333,0.865452694989616,0.865226352406756,
            0.865028302646754,0.86485854570961,0.864717081595322,0.864603910303892,
            0.86451903183532,0.864451836381034,0.864412933749605,0.864402323941033,
            0.864119395712458,0.863864760306741,0.863638417723882,0.863440367963879,
            0.863270611026735,0.863129146912447,0.863015975621018,0.862931097152445,
            0.86287451150673,0.862835608875301,0.86282499906673,0.862542070838155,
            0.862287435432438,0.862061092849578,0.861863043089576,0.861693286152431,
            0.861551822038144,0.861438650746714,0.861353772278142,0.861297186632427,
            0.86126889380957,0.861258284000998,0.860975355772424,0.860720720366706,
            0.860494377783847,0.860296328023845,0.8601265710867,0.859985106972412,
            0.859871935680983,0.85978705721241,0.859730471566695,0.859702178743838,
            0.859702178743838,0.859419250515263,0.859164615109546,0.858938272526687,
            0.858740222766684,0.858559856020968,0.858407782098109,0.858284000998108,
            0.858188512720964,0.858121317266678,0.858082414635248,0.858071804826677,
            0.857788876598102,0.857534241192385,0.857307898609526,0.857109848849523,
            0.856940091912379,0.85678801798952,0.856664236889519,0.856568748612375,
            0.856501553158088,0.856462650526659,0.856452040718088,0.856169112489513,
            0.855914477083796,0.855688134500936,0.855490084740934,0.855320327803789,
            0.855178863689502,0.855055082589501,0.854959594312357,0.85489239885807,
            0.854853496226641,0.85484288641807,0.854559958189495,0.854305322783778,
            0.854078980200918,0.853880930440916,0.853711173503771,0.853569709389484,
            0.853456538098054,0.85336104982091,0.853293854366624,0.853254951735195,
            0.853244341926623,0.852961413698049,0.852706778292332,0.852480435709472,
            0.85228238594947,0.852112629012325,0.851971164898038,0.851857993606608,
            0.851773115138036,0.851705919683749,0.85166701705232,0.851656407243749,
            0.851373479015174,0.851118843609457,0.850892501026597,0.850694451266595,
            0.85052469432945,0.850383230215163,0.850270058923733,0.850185180455161,
            0.850128594809446,0.850089692178017,0.850079082369445,0.849796154140871,
            0.849541518735154,0.849315176152294,0.849117126392292,0.848947369455147,
            0.84880590534086,0.84869273404943,0.848607855580857,0.848551269935143,
            0.848522977112285,0.848512367303714,0.848229439075139,0.847974803669422,
            0.847748461086562,0.84755041132656,0.847380654389415,0.847239190275128,
            0.847126018983698,0.847041140515126,0.846984554869411,0.846956262046553,
            0.846956262046553,0.846673333817979,0.846418698412262,0.846192355829402,
            0.8459943060694,0.845824549132255,0.845672475209396,0.845548694109395,
            0.845453205832251,0.845386010377965,0.845347107746536,0.845336497937964,
            0.845053569709389,0.844798934303672,0.844572591720813,0.844374541960811,
            0.844204785023666,0.844063320909379,0.843939539809377,0.843844051532233,
            0.843776856077947,0.843737953446518,0.843727343637946,0.843444415409372,
            0.843189780003655,0.842963437420795,0.842765387660793,0.842595630723648,
            0.842454166609361,0.842340995317931,0.842245507040787,0.8421783115865,
            0.842139408955071,0.8421287991465,0.841845870917925,0.841591235512208,
            0.841364892929348,0.841166843169346,0.840997086232202,0.840855622117914,
            0.840742450826484,0.840657572357912,0.840590376903626,0.840551474272197,
            0.840540864463625,0.840257936235051,0.840003300829333,0.839776958246474,
            0.839578908486472,0.839409151549327,0.839267687435039,0.83915451614361,
            0.839069637675037,0.839013052029322,0.838974149397893,0.838963539589322,
            0.838680611360747,0.83842597595503,0.838199633372171,0.838001583612168,
            0.837831826675024,0.837690362560736,0.837577191269306,0.837492312800734,
            0.837435727155019,0.837407434332162,0.83739682452359,0.837113896295016,
            0.836859260889298,0.836632918306439,0.836434868546437,0.836265111609292,
            0.836123647495005,0.836010476203575,0.835925597735002,0.835869012089287,
            0.83584071926643,0.83584071926643,0.835557791037855,0.835303155632138,
            0.835076813049279,0.834878763289276,0.834709006352132,0.834567542237844,
            0.834443761137843,0.834348272860699,0.834281077406413,0.834242174774984,
            0.834231564966412,0.833948636737837,0.83369400133212,0.833467658749261,
            0.833269608989259,0.833099852052114,0.832958387937827,0.832845216646397,
            0.832749728369253,0.832682532914966,0.832643630283537,0.832633020474966,
            0.832350092246391,0.832095456840674,0.831869114257814,0.831671064497812,
            0.831501307560667,0.83135984344638,0.83124667215495,0.831161793686378,
            0.831094598232092,0.831055695600663,0.831045085792091,0.830762157563516,
            0.830507522157799,0.83028117957494,0.830083129814937,0.829913372877793,
            0.829771908763505,0.829658737472076,0.829573859003503,0.829517273357788,
            0.829478370726359,0.829467760917788,0.829184832689213,0.828930197283496,
            0.828703854700636,0.828505804940634,0.828336048003489,0.828194583889202,
            0.828081412597772,0.8279965341292,0.827939948483485,0.827911655660628,
            0.827901045852056,0.827618117623481,0.827363482217764,0.827137139634905,
            0.826939089874902,0.826769332937758,0.826627868823471,0.826514697532041,
            0.826429819063468,0.826373233417753,0.826344940594896,0.826344940594896,
            0.826062012366321,0.825807376960604,0.825581034377745,0.825382984617742,
            0.825213227680598,0.82507176356631,0.82495859227488,0.824863103997737,
            0.82479590854345,0.824757005912021,0.82474639610345,0.824463467874875,
            0.824208832469158,0.823982489886298,0.823784440126296,0.823614683189151,
            0.823473219074864,0.823360047783434,0.823275169314862,0.823207973860575,
            0.823169071229146,0.823158461420575,0.822875533192,0.822620897786283,
            0.822394555203423,0.822196505443421,0.822026748506276,0.821885284391989,
            0.821772113100559,0.821687234631987,0.821630648986272,0.821591746354843,
            0.821581136546272,0.821298208317697,0.82104357291198,0.82081723032912,
            0.820619180569118,0.820449423631973,0.820307959517686,0.820194788226256,
            0.820109909757684,0.820053324111969,0.820025031289111,0.82001442148054,
            0.819731493251965,0.819476857846248,0.819250515263389,0.819052465503386,
            0.818882708566242,0.818741244451954,0.818628073160524,0.818543194691952,
            0.818486609046237,0.81845831622338,0.81845831622338,0.818175387994805,
            0.817920752589088,0.817694410006228,0.817496360246226,0.817326603309081,
            0.817185139194794,0.817071967903364,0.816987089434792,0.816919893980505,
            0.816880991349076,0.816870381540505,0.81658745331193,0.816332817906213,
            0.816106475323354,0.815908425563351,0.815738668626207,0.815597204511919,
            0.815484033220489,0.815399154751917,0.815342569106202,0.815303666474773,
            0.815293056666202,0.815010128437627,0.81475549303191,0.81452915044905,
            0.814331100689048,0.814161343751903,0.814019879637616,0.813906708346186,
            0.813821829877614,0.813765244231899,0.813736951409042,0.81372634160047,
            0.813443413371895,0.813188777966178,0.812962435383319,0.812764385623316,
            0.812594628686172,0.812453164571884,0.812339993280455,0.812255114811882,
            0.812198529166167,0.81217023634331,0.81217023634331,0.811887308114735,
            0.811632672709018,0.811406330126158,0.811208280366156,0.811038523429012,
            0.810897059314724,0.810783888023294,0.810699009554722,0.810642423909007,
            0.810603521277578,0.810592911469007,0.810309983240432,0.810055347834715,
            0.809829005251855,0.809630955491853,0.809461198554708,0.809319734440421,
            0.809206563148991,0.809121684680419,0.809065099034704,0.809036806211846,
            0.809026196403275,0.8087432681747,0.808488632768983,0.808262290186123,
            0.808064240426121,0.807894483488977,0.807753019374689,0.80763984808326,
            0.807554969614687,0.807498383968972,0.807470091146115,0.807470091146115,
            0.80718716291754,0.806932527511823,0.806706184928963,0.806508135168961,
            0.806338378231816,0.806196914117529,0.806083742826099,0.805998864357527,
            0.805942278711812,0.805913985888955,0.805903376080383,0.805620447851809,
            0.805365812446091,0.805139469863232,0.80494142010323,0.804771663166085,
            0.804630199051797,0.804517027760368,0.804432149291795,0.80437556364608,
            0.804347270823223,0.804347270823223,0.804064342594648,0.803809707188931,
            0.803583364606072,0.803385314846069,0.803215557908925,0.803074093794637,
            0.802960922503207,0.802876044034635,0.80281945838892,0.802791165566063,
            0.802791165566063,0.80219230081558,0.801593436065097,0.801069429408425,
            0.800620280845562,0.800245990376511,0.799946558001269,0.799721983719838,
            0.799572267532217,0.799497409438407,0.799497409438407,0.798898544687924,
            0.798374538031252,0.79792538946839,0.797551098999338,0.797251666624096,
            0.797027092342665,0.796877376155045,0.796802518061234,0.796802518061234,
            0.796278511404562,0.7958293628417,0.795455072372648,0.795155639997406,
            0.794931065715975,0.794781349528355,0.794706491434544,0.794706491434544,
            0.794257342871682,0.79388305240263,0.793583620027389,0.793359045745958,
            0.793209329558337,0.793134471464527,0.793134471464527,0.792760180995475,
            0.792460748620234,0.792236174338803,0.792086458151182,0.792011600057372,
            0.792011600057372,0.79171216768213,0.791487593400699,0.791337877213078,
            0.791263019119268,0.791263019119268,0.791038444837837,0.790888728650216,
            0.790813870556406,0.790813870556406,0.790664154368785,0.790589296274975,
            0.790589296274975,0.790514438181164,0.790514438181164,0.790514438181164,
            0.789915573430682,0.789391566774009,0.788942418211147,0.788568127742095,
            0.788268695366854,0.788044121085423,0.787894404897802,0.787819546803992,
            0.787819546803992,0.787295540147319,0.786846391584457,0.786472101115405,
            0.786172668740164,0.785948094458733,0.785798378271112,0.785723520177302,
            0.785723520177302,0.78527437161444,0.784900081145388,0.784600648770146,
            0.784376074488715,0.784226358301095,0.784151500207284,0.784151500207284,
            0.783777209738232,0.783477777362991,0.78325320308156,0.783103486893939,
            0.783028628800129,0.783028628800129,0.782729196424887,0.782504622143456,
            0.782354905955836,0.782280047862025,0.782280047862025,0.782055473580594,
            0.781905757392974,0.781830899299163,0.781830899299163,0.781681183111542,
            0.781606325017732,0.781606325017732,0.781531466923922,0.781531466923922,
            0.781531466923922,0.781007460267249,0.780558311704387,0.780184021235335,
            0.779884588860094,0.779660014578663,0.779510298391042,0.779435440297232,
            0.779435440297232,0.77898629173437,0.778612001265318,0.778312568890076,
            0.778087994608645,0.777938278421025,0.777863420327214,0.777863420327214,
            0.777489129858163,0.777189697482921,0.77696512320149,0.776815407013869,
            0.776740548920059,0.776740548920059,0.776441116544818,0.776216542263387,
            0.776066826075766,0.775991967981955,0.775991967981955,0.775767393700524,
            0.775617677512904,0.775542819419093,0.775542819419093,0.775393103231473,
            0.775318245137662,0.775318245137662,0.775243387043852,0.775243387043852,
            0.775243387043852,0.77479423848099,0.774419948011938,0.774120515636697,
            0.773895941355266,0.773746225167645,0.773671367073834,0.773671367073834,
            0.773297076604783,0.772997644229541,0.77277306994811,0.77262335376049,
            0.772548495666679,0.772548495666679,0.772249063291438,0.772024489010007,
            0.771874772822386,0.771799914728576,0.771799914728576,0.771575340447144,
            0.771425624259524,0.771350766165713,0.771350766165713,0.771201049978093,
            0.771126191884282,0.771126191884282,0.771051333790472,0.771051333790472,
            0.771051333790472,0.77067704332142,0.770377610946179,0.770153036664748,
            0.770003320477127,0.769928462383317,0.769928462383317,0.769629030008075,
            0.769404455726644,0.769254739539023,0.769179881445213,0.769179881445213,
            0.768955307163782,0.768805590976161,0.768730732882351,0.768730732882351,
            0.76858101669473,0.76850615860092,0.76850615860092,0.76843130050711,
            0.76843130050711,0.76843130050711,0.768131868131868,0.767907293850437,
            0.767757577662816,0.767682719569006,0.767682719569006,0.767458145287575,
            0.767308429099954,0.767233571006144,0.767233571006144,0.767083854818523,
            0.767008996724713,0.767008996724713,0.766934138630902,0.766934138630902,
            0.766934138630902,0.766709564349471,0.766559848161851,0.76648499006804,
            0.76648499006804,0.76633527388042,0.766260415786609,0.766260415786609,
            0.766185557692799,0.766185557692799,0.766185557692799,0.766035841505178,
            0.765960983411368,0.765960983411368,0.765886125317558,0.765886125317558,
            0.765886125317558,0.765886125317558,0.765886125317558,0.765886125317558,
            0.765886125317558,0.765287260567075,0.764688395816592,0.764164389159919,
            0.763715240597057,0.763340950128005,0.763041517752764,0.762816943471333,
            0.762667227283712,0.762592369189902,0.762592369189902,0.761993504439419,
            0.761469497782747,0.761020349219884,0.760646058750833,0.760346626375591,
            0.76012205209416,0.759972335906539,0.759897477812729,0.759897477812729,
            0.759373471156057,0.758924322593194,0.758550032124143,0.758250599748901,
            0.75802602546747,0.757876309279849,0.757801451186039,0.757801451186039,
            0.757352302623177,0.756978012154125,0.756678579778884,0.756454005497453,
            0.756304289309832,0.756229431216022,0.756229431216022,0.75585514074697,
            0.755555708371728,0.755331134090297,0.755181417902677,0.755106559808866,
            0.755106559808866,0.754807127433625,0.754582553152194,0.754432836964573,
            0.754357978870763,0.754357978870763,0.754133404589332,0.753983688401711,
            0.753908830307901,0.753908830307901,0.75375911412028,0.753684256026469,
            0.753684256026469,0.753609397932659,0.753609397932659,0.753609397932659,
            0.753085391275987,0.752561384619314,0.752112236056452,0.7517379455874,
            0.751438513212159,0.751213938930728,0.751064222743107,0.750989364649297,
            0.750989364649297,0.750465357992624,0.750016209429762,0.74964191896071,
            0.749342486585469,0.749117912304038,0.748968196116417,0.748893338022607,
            0.748893338022607,0.748444189459745,0.748069898990693,0.747770466615451,
            0.74754589233402,0.7473961761464,0.747321318052589,0.747321318052589,
            0.746947027583537,0.746647595208296,0.746423020926865,0.746273304739244,
            0.746198446645434,0.746198446645434,0.745899014270193,0.745674439988761,
            0.745524723801141,0.74544986570733,0.74544986570733,0.745225291425899,
            0.745075575238279,0.745000717144468,0.745000717144468,0.744851000956848,
            0.744776142863037,0.744776142863037,0.744701284769227,0.744701284769227,
            0.744701284769227,0.744177278112554,0.743728129549692,0.74335383908064,
            0.743054406705399,0.742829832423968,0.742680116236347,0.742605258142537,
            0.742605258142537,0.742156109579675,0.741781819110623,0.741482386735382,
            0.741257812453951,0.74110809626633,0.741033238172519,0.741033238172519,
            0.740658947703468,0.740359515328226,0.740134941046795,0.739985224859174,
            0.739910366765364,0.739910366765364,0.739610934390123,0.739386360108692,
            0.739236643921071,0.739161785827261,0.739161785827261,0.738937211545829,
            0.738787495358209,0.738712637264398,0.738712637264398,0.738562921076778,
            0.738488062982967,0.738488062982967,0.738413204889157,0.738413204889157,
            0.738413204889157,0.737964056326295,0.737589765857243,0.737290333482002,
            0.737065759200571,0.73691604301295,0.73684118491914,0.73684118491914,
            0.736466894450088,0.736167462074846,0.735942887793415,0.735793171605794,
            0.735718313511984,0.735718313511984,0.735418881136743,0.735194306855312,
            0.735044590667691,0.734969732573881,0.734969732573881,0.73474515829245,
            0.734595442104829,0.734520584011018,0.734520584011018,0.734370867823398,
            0.734296009729587,0.734296009729587,0.734221151635777,0.734221151635777,
            0.734221151635777,0.733846861166725,0.733547428791484,0.733322854510053,
            0.733173138322432,0.733098280228622,0.733098280228622,0.73279884785338,
            0.732574273571949,0.732424557384329,0.732349699290518,0.732349699290518,
            0.732125125009087,0.731975408821466,0.731900550727656,0.731900550727656,
            0.731750834540035,0.731675976446225,0.731675976446225,0.731601118352415,
            0.731601118352415,0.731601118352415,0.731301685977173,0.731077111695742,
            0.730927395508121,0.730852537414311,0.730852537414311,0.73062796313288,
            0.730478246945259,0.730403388851449,0.730403388851449,0.730253672663828,
            0.730178814570018,0.730178814570018,0.730103956476208,0.730103956476208,
            0.730103956476208,0.729879382194776,0.729729666007156,0.729654807913345,
            0.729654807913345,0.729505091725725,0.729430233631914,0.729430233631914,
            0.729355375538104,0.729355375538104,0.729355375538104,0.729205659350483,
            0.729130801256673,0.729130801256673,0.729055943162862,0.729055943162862,
            0.729055943162862,0.728981085069052,0.728981085069052,0.728981085069052,
            0.728981085069052,0.728382220318569,0.727783355568086,0.727259348911414,
            0.726810200348552,0.7264359098795,0.726136477504259,0.725911903222828,
            0.725762187035207,0.725687328941397,0.725687328941397,0.725088464190914,
            0.724564457534241,0.724115308971379,0.723741018502327,0.723441586127086,
            0.723217011845655,0.723067295658034,0.722992437564224,0.722992437564224,
            0.722468430907551,0.722019282344689,0.721644991875637,0.721345559500396,
            0.721120985218965,0.720971269031344,0.720896410937534,0.720896410937534,
            0.720447262374672,0.72007297190562,0.719773539530378,0.719548965248947,
            0.719399249061327,0.719324390967516,0.719324390967516,0.718950100498465,
            0.718650668123223,0.718426093841792,0.718276377654171,0.718201519560361,
            0.718201519560361,0.717902087185119,0.717677512903689,0.717527796716068,
            0.717452938622257,0.717452938622257,0.717228364340826,0.717078648153206,
            0.717003790059395,0.717003790059395,0.716854073871775,0.716779215777964,
            0.716779215777964,0.716704357684154,0.716704357684154,0.716704357684154,
            0.716180351027481,0.715656344370809,0.715207195807947,0.714832905338895,
            0.714533472963654,0.714308898682222,0.714159182494602,0.714084324400791,
            0.714084324400791,0.713560317744119,0.713111169181257,0.712736878712205,
            0.712437446336964,0.712212872055533,0.712063155867912,0.711988297774101,
            0.711988297774101,0.711539149211239,0.711164858742188,0.710865426366946,
            0.710640852085515,0.710491135897894,0.710416277804084,0.710416277804084,
            0.710041987335032,0.709742554959791,0.70951798067836,0.709368264490739,
            0.709293406396929,0.709293406396929,0.708993974021687,0.708769399740256,
            0.708619683552635,0.708544825458825,0.708544825458825,0.708320251177394,
            0.708170534989773,0.708095676895963,0.708095676895963,0.707945960708342,
            0.707871102614532,0.707871102614532,0.707796244520722,0.707796244520722,
            0.707796244520722,0.707347095957859,0.706897947394997,0.706523656925946,
            0.706224224550704,0.705999650269273,0.705849934081652,0.705775075987842,
            0.705775075987842,0.70532592742498,0.704951636955928,0.704652204580687,
            0.704427630299256,0.704277914111635,0.704203056017825,0.704203056017825,
            0.703828765548773,0.703529333173531,0.7033047588921,0.703155042704479,
            0.703080184610669,0.703080184610669,0.702780752235428,0.702556177953997,
            0.702406461766376,0.702331603672566,0.702331603672566,0.702107029391135,
            0.701957313203514,0.701882455109703,0.701882455109703,0.701732738922083,
            0.701657880828272,0.701657880828272,0.701583022734462,0.701583022734462,
            0.701583022734462,0.7011338741716,0.700759583702548,0.700460151327307,
            0.700235577045876,0.700085860858255,0.700011002764445,0.700011002764445,
            0.699636712295393,0.699337279920151,0.69911270563872,0.6989629894511,
            0.698888131357289,0.698888131357289,0.698588698982048,0.698364124700617,
            0.698214408512996,0.698139550419186,0.698139550419186,0.697914976137755,
            0.697765259950134,0.697690401856324,0.697690401856324,0.697540685668703,
            0.697465827574893,0.697465827574893,0.697390969481082,0.697390969481082,
            0.697390969481082,0.69701667901203,0.696717246636789,0.696492672355358,
            0.696342956167737,0.696268098073927,0.696268098073927,0.695968665698685,
            0.695744091417254,0.695594375229634,0.695519517135823,0.695519517135823,
            0.695294942854392,0.695145226666771,0.695070368572961,0.695070368572961,
            0.69492065238534,0.69484579429153,0.69484579429153,0.69477093619772,
            0.69477093619772,0.69477093619772,0.694471503822478,0.694246929541047,
            0.694097213353426,0.694022355259616,0.694022355259616,0.693797780978185,
            0.693648064790564,0.693573206696754,0.693573206696754,0.693423490509133,
            0.693348632415323,0.693348632415323,0.693273774321513,0.693273774321513,
            0.693273774321513,0.693049200040082,0.692899483852461,0.69282462575865,
            0.69282462575865,0.69267490957103,0.692600051477219,0.692600051477219,
            0.692525193383409,0.692525193383409,0.692525193383409,0.692375477195788,
            0.692300619101978,0.692300619101978,0.692225761008168,0.692225761008168,
            0.692225761008168,0.692150902914357,0.692150902914357,0.692150902914357,
            0.692150902914357,0.691552038163874,0.690953173413392,0.690429166756719,
            0.689980018193857,0.689605727724805,0.689306295349564,0.689081721068133,
            0.688932004880512,0.688857146786702,0.688857146786702,0.688258282036219,
            0.687734275379546,0.687285126816684,0.686910836347632,0.686611403972391,
            0.68638682969096,0.686237113503339,0.686162255409529,0.686162255409529,
            0.685638248752856,0.685189100189994,0.684814809720942,0.684515377345701,
            0.68429080306427,0.684141086876649,0.684066228782839,0.684066228782839,
            0.683617080219977,0.683242789750925,0.682943357375683,0.682718783094252,
            0.682569066906632,0.682494208812821,0.682494208812821,0.68211991834377,
            0.681820485968528,0.681595911687097,0.681446195499476,0.681371337405666,
            0.681371337405666,0.681071905030425,0.680847330748994,0.680697614561373,
            0.680622756467562,0.680622756467562,0.680398182186131,0.680248465998511,
            0.6801736079047,0.6801736079047,0.68002389171708,0.679949033623269,
            0.679949033623269,0.679874175529459,0.679874175529459,0.679874175529459,
            0.679350168872786,0.678826162216114,0.678377013653252,0.6780027231842,
            0.677703290808959,0.677478716527528,0.677329000339907,0.677254142246096,
            0.677254142246096,0.676730135589424,0.676280987026562,0.67590669655751,
            0.675607264182269,0.675382689900838,0.675232973713217,0.675158115619407,
            0.675158115619407,0.674708967056544,0.674334676587493,0.674035244212251,
            0.67381066993082,0.673660953743199,0.673586095649389,0.673586095649389,
            0.673211805180337,0.672912372805096,0.672687798523665,0.672538082336044,
            0.672463224242234,0.672463224242234,0.672163791866992,0.671939217585561,
            0.67178950139794,0.67171464330413,0.67171464330413,0.671490069022699,
            0.671340352835078,0.671265494741268,0.671265494741268,0.671115778553647,
            0.671040920459837,0.671040920459837,0.670966062366027,0.670966062366027,
            0.670966062366027,0.670516913803164,0.670067765240302,0.669693474771251,
            0.669394042396009,0.669169468114578,0.669019751926957,0.668944893833147,
            0.668944893833147,0.668495745270285,0.668121454801233,0.667822022425992,
            0.667597448144561,0.66744773195694,0.667372873863129,0.667372873863129,
            0.666998583394078,0.666699151018836,0.666474576737405,0.666324860549785,
            0.666250002455974,0.666250002455974,0.665950570080733,0.665725995799302,
            0.665576279611681,0.665501421517871,0.665501421517871,0.66527684723644,
            0.665127131048819,0.665052272955009,0.665052272955009,0.664902556767388,
            0.664827698673577,0.664827698673577,0.664752840579767,0.664752840579767,
            0.664752840579767,0.664378550110715,0.664004259641664,0.663704827266422,
            0.663480252984991,0.66333053679737,0.66325567870356,0.66325567870356,
            0.662881388234508,0.662581955859267,0.662357381577836,0.662207665390215,
            0.662132807296405,0.662132807296405,0.661833374921163,0.661608800639732,
            0.661459084452111,0.661384226358301,0.661384226358301,0.66115965207687,
            0.661009935889249,0.660935077795439,0.660935077795439,0.660785361607818,
            0.660710503514008,0.660710503514008,0.660635645420198,0.660635645420198,
            0.660635645420198,0.660261354951146,0.659961922575904,0.659737348294473,
            0.659587632106853,0.659512774013042,0.659512774013042,0.659213341637801,
            0.65898876735637,0.658839051168749,0.658764193074939,0.658764193074939,
            0.658539618793508,0.658389902605887,0.658315044512077,0.658315044512077,
            0.658165328324456,0.658090470230645,0.658090470230645,0.658015612136835,
            0.658015612136835,0.658015612136835,0.657716179761594,0.657491605480163,
            0.657341889292542,0.657267031198732,0.657267031198732,0.6570424569173,
            0.65689274072968,0.656817882635869,0.656817882635869,0.656668166448249,
            0.656593308354438,0.656593308354438,0.656518450260628,0.656518450260628,
            0.656518450260628,0.656293875979197,0.656144159791576,0.656069301697766,
            0.656069301697766,0.655919585510145,0.655844727416335,0.655844727416335,
            0.655769869322524,0.655769869322524,0.655769869322524,0.655620153134904,
            0.655545295041093,0.655545295041093,0.655470436947283,0.655470436947283,
            0.655470436947283,0.655395578853473,0.655395578853473,0.655395578853473,
            0.655395578853473,0.65479671410299,0.654197849352507,0.653673842695835,
            0.653224694132972,0.652850403663921,0.652550971288679,0.652326397007248,
            0.652176680819627,0.652101822725817,0.652101822725817,0.651502957975334,
            0.650978951318662,0.6505298027558,0.650155512286748,0.649856079911506,
            0.649631505630075,0.649481789442455,0.649406931348644,0.649406931348644,
            0.648882924691972,0.64843377612911,0.648059485660058,0.647760053284816,
            0.647535479003385,0.647385762815765,0.647310904721954,0.647310904721954,
            0.646861756159092,0.64648746569004,0.646188033314799,0.645963459033368,
            0.645813742845747,0.645738884751937,0.645738884751937,0.645364594282885,
            0.645065161907644,0.644840587626213,0.644690871438592,0.644616013344781,
            0.644616013344781,0.64431658096954,0.644092006688109,0.643942290500488,
            0.643867432406678,0.643867432406678,0.643642858125247,0.643493141937626,
            0.643418283843816,0.643418283843816,0.643268567656195,0.643193709562385,
            0.643193709562385,0.643118851468574,0.643118851468574,0.643118851468574,
            0.642594844811902,0.642070838155229,0.641621689592367,0.641247399123315,
            0.640947966748074,0.640723392466643,0.640573676279022,0.640498818185212,
            0.640498818185212,0.639974811528539,0.639525662965677,0.639151372496625,
            0.638851940121384,0.638627365839953,0.638477649652332,0.638402791558522,
            0.638402791558522,0.63795364299566,0.637579352526608,0.637279920151367,
            0.637055345869936,0.636905629682315,0.636830771588504,0.636830771588504,
            0.636456481119453,0.636157048744211,0.63593247446278,0.63578275827516,
            0.635707900181349,0.635707900181349,0.635408467806108,0.635183893524677,
            0.635034177337056,0.634959319243246,0.634959319243246,0.634734744961814,
            0.634585028774194,0.634510170680383,0.634510170680383,0.634360454492763,
            0.634285596398952,0.634285596398952,0.634210738305142,0.634210738305142,
            0.634210738305142,0.63376158974228,0.633312441179418,0.632938150710366,
            0.632638718335125,0.632414144053693,0.632264427866073,0.632189569772262,
            0.632189569772262,0.6317404212094,0.631366130740349,0.631066698365107,
            0.630842124083676,0.630692407896055,0.630617549802245,0.630617549802245,
            0.630243259333193,0.629943826957952,0.629719252676521,0.6295695364889,
            0.62949467839509,0.62949467839509,0.629195246019848,0.628970671738417,
            0.628820955550796,0.628746097456986,0.628746097456986,0.628521523175555,
            0.628371806987934,0.628296948894124,0.628296948894124,0.628147232706503,
            0.628072374612693,0.628072374612693,0.627997516518882,0.627997516518882,
            0.627997516518882,0.627623226049831,0.627248935580779,0.626949503205538,
            0.626724928924106,0.626575212736486,0.626500354642675,0.626500354642675,
            0.626126064173624,0.625826631798382,0.625602057516951,0.62545234132933,
            0.62537748323552,0.62537748323552,0.625078050860279,0.624853476578848,
            0.624703760391227,0.624628902297417,0.624628902297417,0.624404328015985,
            0.624254611828365,0.624179753734554,0.624179753734554,0.624030037546934,
            0.623955179453123,0.623955179453123,0.623880321359313,0.623880321359313,
            0.623880321359313,0.623580888984071,0.62328145660883,0.623056882327399,
            0.622907166139778,0.622832308045968,0.622832308045968,0.622532875670727,
            0.622308301389295,0.622158585201675,0.622083727107864,0.622083727107864,
            0.621859152826433,0.621709436638813,0.621634578545002,0.621634578545002,
            0.621484862357382,0.621410004263571,0.621410004263571,0.621335146169761,
            0.621335146169761,0.621335146169761,0.621035713794519,0.620811139513088,
            0.620661423325468,0.620586565231657,0.620586565231657,0.620361990950226,
            0.620212274762606,0.620137416668795,0.620137416668795,0.619987700481174,
            0.619912842387364,0.619912842387364,0.619837984293554,0.619837984293554,
            0.619837984293554,0.619613410012123,0.619463693824502,0.619388835730692,
            0.619388835730692,0.619239119543071,0.619164261449261,0.619164261449261,
            0.61908940335545,0.61908940335545,0.61908940335545,0.618939687167829,
            0.618864829074019,0.618864829074019,0.618789970980209,0.618789970980209,
            0.618789970980209,0.618715112886398,0.618715112886398,0.618715112886398,
            0.618715112886398,0.618041390042105,0.617442525291622,0.61691851863495,
            0.616469370072088,0.616095079603036,0.615795647227795,0.615571072946363,
            0.615421356758743,0.615346498664932,0.615346498664932,0.61474763391445,
            0.614223627257777,0.613774478694915,0.613400188225863,0.613100755850622,
            0.612876181569191,0.61272646538157,0.61265160728776,0.61265160728776,
            0.612127600631087,0.611678452068225,0.611304161599173,0.611004729223932,
            0.610780154942501,0.61063043875488,0.61055558066107,0.61055558066107,
            0.610106432098208,0.609732141629156,0.609432709253914,0.609208134972483,
            0.609058418784863,0.608983560691052,0.608983560691052,0.608609270222,
            0.608309837846759,0.608085263565328,0.607935547377707,0.607860689283897,
            0.607860689283897,0.607561256908655,0.607336682627224,0.607186966439604,
            0.607112108345793,0.607112108345793,0.606887534064362,0.606737817876742,
            0.606662959782931,0.606662959782931,0.60651324359531,0.6064383855015,
            0.6064383855015,0.60636352740769,0.60636352740769,0.60636352740769,
            0.605839520751017,0.605315514094345,0.604866365531483,0.604492075062431,
            0.604192642687189,0.603968068405758,0.603818352218138,0.603743494124327,
            0.603743494124327,0.603219487467655,0.602770338904793,0.602396048435741,
            0.602096616060499,0.601872041779068,0.601722325591448,0.601647467497637,
            0.601647467497637,0.601198318934775,0.600824028465723,0.600524596090482,
            0.600300021809051,0.60015030562143,0.60007544752762,0.60007544752762,
            0.599701157058568,0.599401724683327,0.599177150401896,0.599027434214275,
            0.598952576120465,0.598952576120465,0.598653143745223,0.598428569463792,
            0.598278853276171,0.598203995182361,0.598203995182361,0.59797942090093,
            0.597829704713309,0.597754846619499,0.597754846619499,0.597605130431878,
            0.597530272338068,0.597530272338068,0.597455414244257,0.597455414244257,
            0.597455414244257,0.597006265681395,0.596557117118533,0.596182826649481,
            0.59588339427424,0.595658819992809,0.595509103805188,0.595434245711378,
            0.595434245711378,0.594985097148516,0.594610806679464,0.594311374304223,
            0.594086800022791,0.593937083835171,0.59386222574136,0.59386222574136,
            0.593487935272309,0.593188502897067,0.592963928615636,0.592814212428015,
            0.592739354334205,0.592739354334205,0.592439921958964,0.592215347677533,
            0.592065631489912,0.591990773396102,0.591990773396102,0.59176619911467,
            0.59161648292705,0.591541624833239,0.591541624833239,0.591391908645619,
            0.591317050551808,0.591317050551808,0.591242192457998,0.591242192457998,
            0.591242192457998,0.590867901988946,0.590493611519894,0.590194179144653,
            0.589969604863222,0.589819888675601,0.589745030581791,0.589745030581791,
            0.589370740112739,0.589071307737498,0.588846733456067,0.588697017268446,
            0.588622159174635,0.588622159174635,0.588322726799394,0.588098152517963,
            0.587948436330342,0.587873578236532,0.587873578236532,0.587649003955101,
            0.58749928776748,0.58742442967367,0.58742442967367,0.587274713486049,
            0.587199855392239,0.587199855392239,0.587124997298428,0.587124997298428,
            0.587124997298428,0.586825564923187,0.586526132547946,0.586301558266514,
            0.586151842078894,0.586076983985083,0.586076983985083,0.585777551609842,
            0.585552977328411,0.58540326114079,0.58532840304698,0.58532840304698,
            0.585103828765549,0.584954112577928,0.584879254484118,0.584879254484118,
            0.584729538296497,0.584654680202687,0.584654680202687,0.584579822108876,
            0.584579822108876,0.584579822108876,0.584355247827445,0.584130673546014,
            0.583980957358393,0.583906099264583,0.583906099264583,0.583681524983152,
            0.583531808795531,0.583456950701721,0.583456950701721,0.5833072345141,
            0.58323237642029,0.58323237642029,0.58315751832648,0.58315751832648,
            0.58315751832648,0.582932944045048,0.582783227857428,0.582708369763617,
            0.582708369763617,0.582558653575997,0.582483795482186,0.582483795482186,
            0.582408937388376,0.582408937388376,0.582408937388376,0.582259221200755,
            0.582184363106945,0.582184363106945,0.582109505013135,0.582109505013135,
            0.582109505013135,0.582034646919324,0.582034646919324,0.582034646919324,
            0.582034646919324,0.581360924075031,0.580762059324548,0.580238052667876,
            0.579788904105013,0.579414613635962,0.57911518126072,0.578890606979289,
            0.578740890791669,0.578666032697858,0.578666032697858,0.578067167947375,
            0.577543161290703,0.577094012727841,0.576719722258789,0.576420289883548,
            0.576195715602116,0.576045999414496,0.575971141320685,0.575971141320685,
            0.575447134664013,0.574997986101151,0.574623695632099,0.574324263256858,
            0.574099688975427,0.573949972787806,0.573875114693995,0.573875114693995,
            0.573425966131133,0.573051675662081,0.57275224328684,0.572527669005409,
            0.572377952817788,0.572303094723978,0.572303094723978,0.571928804254926,
            0.571629371879685,0.571404797598254,0.571255081410633,0.571180223316823,
            0.571180223316823,0.570880790941581,0.57065621666015,0.570506500472529,
            0.570431642378719,0.570431642378719,0.570207068097288,0.570057351909667,
            0.569982493815857,0.569982493815857,0.569832777628236,0.569757919534426,
            0.569757919534426,0.569683061440616,0.569683061440616,0.569683061440616,
            0.569084196690133,0.56856019003346,0.568111041470598,0.567736751001546,
            0.567437318626305,0.567212744344874,0.567063028157253,0.566988170063443,
            0.566988170063443,0.56646416340677,0.566015014843908,0.565640724374856,
            0.565341291999615,0.565116717718184,0.564967001530563,0.564892143436753,
            0.564892143436753,0.564442994873891,0.564068704404839,0.563769272029597,
            0.563544697748166,0.563394981560546,0.563320123466735,0.563320123466735,
            0.562945832997684,0.562646400622442,0.562421826341011,0.56227211015339,
            0.56219725205958,0.56219725205958,0.561897819684338,0.561673245402908,
            0.561523529215287,0.561448671121476,0.561448671121476,0.561224096840045,
            0.561074380652425,0.560999522558614,0.560999522558614,0.560849806370994,
            0.560774948277183,0.560774948277183,0.560700090183373,0.560700090183373,
            0.560700090183373,0.560250941620511,0.559801793057649,0.559427502588597,
            0.559128070213355,0.558903495931924,0.558753779744304,0.558678921650493,
            0.558678921650493,0.558229773087631,0.557855482618579,0.557556050243338,
            0.557331475961907,0.557181759774286,0.557106901680476,0.557106901680476,
            0.556732611211424,0.556433178836183,0.556208604554752,0.556058888367131,
            0.55598403027332,0.55598403027332,0.555684597898079,0.555460023616648,
            0.555310307429027,0.555235449335217,0.555235449335217,0.555010875053786,
            0.554861158866165,0.554786300772355,0.554786300772355,0.554636584584734,
            0.554561726490924,0.554561726490924,0.554486868397113,0.554486868397113,
            0.554486868397113,0.554112577928062,0.55373828745901,0.553438855083768,
            0.553214280802337,0.553064564614717,0.552989706520906,0.552989706520906,
            0.552615416051854,0.552315983676613,0.552091409395182,0.551941693207561,
            0.551866835113751,0.551866835113751,0.551567402738509,0.551342828457078,
            0.551193112269458,0.551118254175647,0.551118254175647,0.550893679894216,
            0.550743963706596,0.550669105612785,0.550669105612785,0.550519389425165,
            0.550444531331354,0.550444531331354,0.550369673237544,0.550369673237544,
            0.550369673237544,0.550070240862302,0.549770808487061,0.54954623420563,
            0.549396518018009,0.549321659924199,0.549321659924199,0.549022227548957,
            0.548797653267526,0.548647937079906,0.548573078986095,0.548573078986095,
            0.548348504704664,0.548198788517044,0.548123930423233,0.548123930423233,
            0.547974214235612,0.547899356141802,0.547899356141802,0.547824498047992,
            0.547824498047992,0.547824498047992,0.547599923766561,0.54737534948513,
            0.547225633297509,0.547150775203698,0.547150775203698,0.546926200922267,
            0.546776484734647,0.546701626640836,0.546701626640836,0.546551910453216,
            0.546477052359405,0.546477052359405,0.546402194265595,0.546402194265595,
            0.546402194265595,0.546252478077974,0.546102761890354,0.546027903796543,
            0.546027903796543,0.545878187608922,0.545803329515112,0.545803329515112,
            0.545728471421302,0.545728471421302,0.545728471421302,0.545578755233681,
            0.545503897139871,0.545503897139871,0.54542903904606,0.54542903904606,
            0.54542903904606,0.54535418095225,0.54535418095225,0.54535418095225,
            0.54535418095225,0.544680458107957,0.544081593357474,0.543557586700801,
            0.543108438137939,0.542734147668888,0.542434715293646,0.542210141012215,
            0.542060424824594,0.541985566730784,0.541985566730784,0.541386701980301,
            0.540862695323629,0.540413546760766,0.540039256291715,0.539739823916473,
            0.539515249635042,0.539365533447422,0.539290675353611,0.539290675353611,
            0.538766668696939,0.538317520134077,0.537943229665025,0.537643797289783,
            0.537419223008352,0.537269506820732,0.537194648726921,0.537194648726921,
            0.536745500164059,0.536371209695007,0.536071777319766,0.535847203038335,
            0.535697486850714,0.535622628756904,0.535622628756904,0.535248338287852,
            0.534948905912611,0.534724331631179,0.534574615443559,0.534499757349748,
            0.534499757349748,0.534200324974507,0.533975750693076,0.533826034505455,
            0.533751176411645,0.533751176411645,0.533526602130214,0.533376885942593,
            0.533302027848783,0.533302027848783,0.533152311661162,0.533077453567352,
            0.533077453567352,0.533002595473541,0.533002595473541,0.533002595473541,
            0.532403730723058,0.531879724066386,0.531430575503524,0.531056285034472,
            0.530756852659231,0.5305322783778,0.530382562190179,0.530307704096369,
            0.530307704096369,0.529783697439696,0.529334548876834,0.528960258407782,
            0.528660826032541,0.52843625175111,0.528286535563489,0.528211677469679,
            0.528211677469679,0.527762528906816,0.527388238437765,0.527088806062523,
            0.526864231781092,0.526714515593471,0.526639657499661,0.526639657499661,
            0.526265367030609,0.525965934655368,0.525741360373937,0.525591644186316,
            0.525516786092506,0.525516786092506,0.525217353717264,0.524992779435833,
            0.524843063248213,0.524768205154402,0.524768205154402,0.524543630872971,
            0.52439391468535,0.52431905659154,0.52431905659154,0.524169340403919,
            0.524094482310109,0.524094482310109,0.524019624216299,0.524019624216299,
            0.524019624216299,0.523495617559626,0.523046468996764,0.522672178527712,
            0.522372746152471,0.52214817187104,0.521998455683419,0.521923597589609,
            0.521923597589609,0.521474449026747,0.521100158557695,0.520800726182453,
            0.520576151901022,0.520426435713402,0.520351577619591,0.520351577619591,
            0.519977287150539,0.519677854775298,0.519453280493867,0.519303564306246,
            0.519228706212436,0.519228706212436,0.518929273837194,0.518704699555763,
            0.518554983368143,0.518480125274332,0.518480125274332,0.518255550992901,
            0.51810583480528,0.51803097671147,0.51803097671147,0.51788126052385,
            0.517806402430039,0.517806402430039,0.517731544336229,0.517731544336229,
            0.517731544336229,0.517357253867177,0.516982963398125,0.516683531022884,
            0.516458956741453,0.516309240553832,0.516234382460022,0.516234382460022,
            0.51586009199097,0.515560659615729,0.515336085334297,0.515186369146677,
            0.515111511052866,0.515111511052866,0.514812078677625,0.514587504396194,
            0.514437788208573,0.514362930114763,0.514362930114763,0.514138355833332,
            0.513988639645711,0.513913781551901,0.513913781551901,0.51376406536428,
            0.51368920727047,0.51368920727047,0.513614349176659,0.513614349176659,
            0.513614349176659,0.513314916801418,0.513015484426176,0.512790910144745,
            0.512641193957125,0.512566335863314,0.512566335863314,0.512266903488073,
            0.512042329206642,0.511892613019021,0.511817754925211,0.511817754925211,
            0.51159318064378,0.511443464456159,0.511368606362348,0.511368606362348,
            0.511218890174728,0.511144032080918,0.511144032080918,0.511069173987107,
            0.511069173987107,0.511069173987107,0.510844599705676,0.510620025424245,
            0.510470309236624,0.510395451142814,0.510395451142814,0.510170876861383,
            0.510021160673762,0.509946302579952,0.509946302579952,0.509796586392331,
            0.509721728298521,0.509721728298521,0.50964687020471,0.50964687020471,
            0.50964687020471,0.50949715401709,0.509347437829469,0.509272579735659,
            0.509272579735659,0.509122863548038,0.509048005454228,0.509048005454228,
            0.508973147360417,0.508973147360417,0.508973147360417,0.508898289266607,
            0.508823431172796,0.508823431172796,0.508748573078986,0.508748573078986,
            0.508748573078986,0.508673714985176,0.508673714985176,0.508673714985176,
            0.508673714985176,0.507999992140883,0.5074011273904,0.506877120733727,
            0.506427972170865,0.506053681701813,0.505754249326572,0.505529675045141,
            0.50537995885752,0.50530510076371,0.50530510076371,0.504706236013227,
            0.504182229356554,0.503733080793692,0.50335879032464,0.503059357949399,
            0.502834783667968,0.502685067480347,0.502610209386537,0.502610209386537,
            0.502086202729864,0.501637054167002,0.501262763697951,0.500963331322709,
            0.500738757041278,0.500589040853657,0.500514182759847,0.500514182759847,
            0.500065034196985,0.499690743727933,0.499391311352692,0.499166737071261,
            0.49901702088364,0.49894216278983,0.49894216278983,0.498567872320778,
            0.498268439945536,0.498043865664105,0.497894149476485,0.497819291382674,
            0.497819291382674,0.497519859007433,0.497295284726002,0.497145568538381,
            0.497070710444571,0.497070710444571,0.49684613616314,0.496696419975519,
            0.496621561881708,0.496621561881708,0.496471845694088,0.496396987600277,
            0.496396987600277,0.496322129506467,0.496322129506467,0.496322129506467,
            0.495723264755984,0.495199258099312,0.49475010953645,0.494375819067398,
            0.494076386692156,0.493851812410725,0.493702096223105,0.493627238129294,
            0.493627238129294,0.493103231472622,0.49265408290976,0.492279792440708,
            0.491980360065466,0.491755785784035,0.491606069596415,0.491531211502604,
            0.491531211502604,0.491082062939742,0.49070777247069,0.490408340095449,
            0.490183765814018,0.490034049626397,0.489959191532587,0.489959191532587,
            0.489584901063535,0.489285468688294,0.489060894406863,0.488911178219242,
            0.488836320125431,0.488836320125431,0.48853688775019,0.488312313468759,
            0.488162597281138,0.488087739187328,0.488087739187328,0.487863164905897,
            0.487713448718276,0.487638590624466,0.487638590624466,0.487488874436845,
            0.487414016343035,0.487414016343035,0.487339158249224,0.487339158249224,
            0.487339158249224,0.486815151592552,0.48636600302969,0.485991712560638,
            0.485692280185397,0.485467705903966,0.485317989716345,0.485243131622534,
            0.485243131622534,0.484793983059672,0.484419692590621,0.484120260215379,
            0.483895685933948,0.483745969746327,0.483671111652517,0.483671111652517,
            0.483296821183465,0.482997388808224,0.482772814526793,0.482623098339172,
            0.482548240245362,0.482548240245362,0.48224880787012,0.482024233588689,
            0.481874517401068,0.481799659307258,0.481799659307258,0.481575085025827,
            0.481425368838206,0.481350510744396,0.481350510744396,0.481200794556775,
            0.481125936462965,0.481125936462965,0.481051078369155,0.481051078369155,
            0.481051078369155,0.480601929806292,0.480227639337241,0.479928206961999,
            0.479703632680568,0.479553916492947,0.479479058399137,0.479479058399137,
            0.479104767930085,0.478805335554844,0.478580761273413,0.478431045085792,
            0.478356186991982,0.478356186991982,0.47805675461674,0.477832180335309,
            0.477682464147689,0.477607606053878,0.477607606053878,0.477383031772447,
            0.477233315584826,0.477158457491016,0.477158457491016,0.477008741303395,
            0.476933883209585,0.476933883209585,0.476859025115775,0.476859025115775,
            0.476859025115775,0.476559592740533,0.476260160365292,0.476035586083861,
            0.47588586989624,0.47581101180243,0.47581101180243,0.475511579427188,
            0.475287005145757,0.475137288958136,0.475062430864326,0.475062430864326,
            0.474837856582895,0.474688140395274,0.474613282301464,0.474613282301464,
            0.474463566113843,0.474388708020033,0.474388708020033,0.474313849926223,
            0.474313849926223,0.474313849926223,0.474089275644791,0.47386470136336,
            0.47371498517574,0.473640127081929,0.473640127081929,0.473415552800498,
            0.473265836612878,0.473190978519067,0.473190978519067,0.473041262331446,
            0.472966404237636,0.472966404237636,0.472891546143826,0.472891546143826,
            0.472891546143826,0.472741829956205,0.472592113768584,0.472517255674774,
            0.472517255674774,0.472367539487153,0.472292681393343,0.472292681393343,
            0.472217823299533,0.472217823299533,0.472217823299533,0.472142965205722,
            0.472068107111912,0.472068107111912,0.471993249018102,0.471993249018102,
            0.471993249018102,0.471993249018102,0.471993249018102,0.471993249018102,
            0.471993249018102,0.471319526173808,0.470720661423325,0.470196654766653,
            0.469747506203791,0.469373215734739,0.469073783359498,0.468849209078067,
            0.468699492890446,0.468624634796636,0.468624634796636,0.468025770046153,
            0.46750176338948,0.467052614826618,0.466678324357566,0.466378891982325,
            0.466154317700894,0.466004601513273,0.465929743419463,0.465929743419463,
            0.46540573676279,0.464956588199928,0.464582297730876,0.464282865355635,
            0.464058291074204,0.463908574886583,0.463833716792773,0.463833716792773,
            0.463384568229911,0.463010277760859,0.462710845385617,0.462486271104186,
            0.462336554916566,0.462261696822755,0.462261696822755,0.461887406353704,
            0.461587973978462,0.461363399697031,0.46121368350941,0.4611388254156,
            0.4611388254156,0.460839393040359,0.460614818758927,0.460465102571307,
            0.460390244477496,0.460390244477496,0.460165670196065,0.460015954008445,
            0.459941095914634,0.459941095914634,0.459791379727014,0.459716521633203,
            0.459716521633203,0.459716521633203,0.459716521633203,0.459716521633203,
            0.45911765688272,0.458593650226048,0.458144501663186,0.457770211194134,
            0.457470778818893,0.457246204537461,0.457096488349841,0.45702163025603,
            0.45702163025603,0.456497623599358,0.456048475036496,0.455674184567444,
            0.455374752192203,0.455150177910772,0.455000461723151,0.45492560362934,
            0.45492560362934,0.454476455066478,0.454102164597427,0.453802732222185,
            0.453578157940754,0.453428441753133,0.453353583659323,0.453353583659323,
            0.452979293190271,0.45267986081503,0.452455286533599,0.452305570345978,
            0.452230712252168,0.452230712252168,0.451931279876926,0.451706705595495,
            0.451556989407874,0.451482131314064,0.451482131314064,0.451257557032633,
            0.451107840845012,0.451032982751202,0.451032982751202,0.450883266563581,
            0.450808408469771,0.450808408469771,0.450733550375961,0.450733550375961,
            0.450733550375961,0.450209543719288,0.449760395156426,0.449386104687374,
            0.449086672312133,0.448862098030702,0.448712381843081,0.448637523749271,
            0.448637523749271,0.448188375186408,0.447814084717357,0.447514652342115,
            0.447290078060684,0.447140361873063,0.447065503779253,0.447065503779253,
            0.446691213310201,0.44639178093496,0.446167206653529,0.446017490465908,
            0.445942632372098,0.445942632372098,0.445643199996856,0.445418625715425,
            0.445268909527805,0.445194051433994,0.445194051433994,0.444969477152563,
            0.444819760964942,0.444744902871132,0.444744902871132,0.444595186683511,
            0.444520328589701,0.444520328589701,0.444445470495891,0.444445470495891,
            0.444445470495891,0.443996321933029,0.443622031463977,0.443322599088735,
            0.443098024807304,0.442948308619684,0.442873450525873,0.442873450525873,
            0.442499160056821,0.44219972768158,0.441975153400149,0.441825437212528,
            0.441750579118718,0.441750579118718,0.441451146743476,0.441226572462045,
            0.441076856274425,0.441001998180614,0.441001998180614,0.440777423899183,
            0.440627707711563,0.440552849617752,0.440552849617752,0.440403133430131,
            0.440328275336321,0.440328275336321,0.440253417242511,0.440253417242511,
            0.440253417242511,0.439879126773459,0.439579694398218,0.439355120116787,
            0.439205403929166,0.439130545835355,0.439130545835355,0.438831113460114,
            0.438606539178683,0.438456822991062,0.438381964897252,0.438381964897252,
            0.438157390615821,0.4380076744282,0.43793281633439,0.43793281633439,
            0.437783100146769,0.437708242052959,0.437708242052959,0.437633383959148,
            0.437633383959148,0.437633383959148,0.437408809677717,0.437184235396286,
            0.437034519208665,0.436959661114855,0.436959661114855,0.436735086833424,
            0.436585370645803,0.436510512551993,0.436510512551993,0.436360796364372,
            0.436285938270562,0.436285938270562,0.436211080176752,0.436211080176752,
            0.436211080176752,0.436061363989131,0.43591164780151,0.4358367897077,
            0.4358367897077,0.435687073520079,0.435612215426269,0.435612215426269,
            0.435537357332458,0.435537357332458,0.435537357332458,0.435462499238648,
            0.435387641144838,0.435387641144838,0.435312783051027,0.435312783051027,
            0.435312783051027,0.435312783051027,0.435312783051027,0.435312783051027,
            0.435312783051027,0.434639060206734,0.434040195456251,0.433516188799579,
            0.433067040236717,0.432692749767665,0.432393317392423,0.432168743110992,
            0.432019026923372,0.431944168829561,0.431944168829561,0.431345304079078,
            0.430821297422406,0.430372148859544,0.429997858390492,0.429698426015251,
            0.42947385173382,0.429324135546199,0.429249277452389,0.429249277452389,
            0.428725270795716,0.428276122232854,0.427901831763802,0.427602399388561,
            0.42737782510713,0.427228108919509,0.427153250825699,0.427153250825699,
            0.426704102262836,0.426329811793785,0.426030379418543,0.425805805137112,
            0.425656088949491,0.425581230855681,0.425581230855681,0.425206940386629,
            0.424907508011388,0.424682933729957,0.424533217542336,0.424458359448526,
            0.424458359448526,0.424158927073284,0.423934352791853,0.423784636604233,
            0.423709778510422,0.423709778510422,0.423485204228991,0.42333548804137,
            0.42326062994756,0.42326062994756,0.423110913759939,0.423036055666129,
            0.423036055666129,0.423036055666129,0.423036055666129,0.423036055666129,
            0.422437190915646,0.421913184258974,0.421464035696112,0.42108974522706,
            0.420790312851818,0.420565738570387,0.420416022382767,0.420341164288956,
            0.420341164288956,0.419817157632284,0.419368009069422,0.41899371860037,
            0.418694286225128,0.418469711943697,0.418319995756077,0.418245137662266,
            0.418245137662266,0.417795989099404,0.417421698630352,0.417122266255111,
            0.41689769197368,0.416747975786059,0.416673117692249,0.416673117692249,
            0.416298827223197,0.415999394847956,0.415774820566524,0.415625104378904,
            0.415550246285093,0.415550246285093,0.415250813909852,0.415026239628421,
            0.4148765234408,0.41480166534699,0.41480166534699,0.414577091065559,
            0.414427374877938,0.414352516784128,0.414352516784128,0.414202800596507,
            0.414127942502697,0.414127942502697,0.414053084408886,0.414053084408886,
            0.414053084408886,0.413529077752214,0.413079929189352,0.4127056387203,
            0.412406206345058,0.412181632063627,0.412031915876007,0.411957057782196,
            0.411957057782196,0.411507909219334,0.411133618750282,0.410834186375041,
            0.41060961209361,0.410459895905989,0.410385037812179,0.410385037812179,
            0.410010747343127,0.409711314967886,0.409486740686455,0.409337024498834,
            0.409262166405024,0.409262166405024,0.408962734029782,0.408738159748351,
            0.40858844356073,0.40851358546692,0.40851358546692,0.408289011185489,
            0.408139294997868,0.408064436904058,0.408064436904058,0.407914720716437,
            0.407839862622627,0.407839862622627,0.407765004528816,0.407765004528816,
            0.407765004528816,0.407315855965954,0.406941565496903,0.406642133121661,
            0.40641755884023,0.406267842652609,0.406192984558799,0.406192984558799,
            0.405818694089747,0.405519261714506,0.405294687433075,0.405144971245454,
            0.405070113151644,0.405070113151644,0.404770680776402,0.404546106494971,
            0.40439639030735,0.40432153221354,0.40432153221354,0.404096957932109,
            0.403947241744488,0.403872383650678,0.403872383650678,0.403722667463057,
            0.403647809369247,0.403647809369247,0.403572951275437,0.403572951275437,
            0.403572951275437,0.403198660806385,0.402899228431143,0.402674654149712,
            0.402524937962092,0.402450079868281,0.402450079868281,0.40215064749304,
            0.401926073211609,0.401776357023988,0.401701498930178,0.401701498930178,
            0.401476924648747,0.401327208461126,0.401252350367315,0.401252350367315,
            0.401102634179695,0.401027776085884,0.401027776085884,0.400952917992074,
            0.400952917992074,0.400952917992074,0.400653485616833,0.400428911335402,
            0.400279195147781,0.400204337053971,0.400204337053971,0.399979762772539,
            0.399830046584919,0.399755188491108,0.399755188491108,0.399605472303488,
            0.399530614209677,0.399530614209677,0.399455756115867,0.399455756115867,
            0.399455756115867,0.399306039928246,0.399156323740626,0.399081465646815,
            0.399081465646815,0.398931749459194,0.398856891365384,0.398856891365384,
            0.398782033271574,0.398782033271574,0.398782033271574,0.398707175177763,
            0.398632317083953,0.398632317083953,0.398557458990143,0.398557458990143,
            0.398557458990143,0.398557458990143,0.398557458990143,0.398557458990143,
            0.398557458990143,0.397883736145849,0.397284871395367,0.396760864738694,
            0.396311716175832,0.39593742570678,0.395637993331539,0.395413419050108,
            0.395263702862487,0.395188844768677,0.395188844768677,0.394589980018194,
            0.394065973361521,0.393616824798659,0.393242534329607,0.392943101954366,
            0.392718527672935,0.392568811485314,0.392493953391504,0.392493953391504,
            0.391969946734831,0.391520798171969,0.391146507702917,0.390847075327676,
            0.390622501046245,0.390472784858624,0.390397926764814,0.390397926764814,
            0.389948778201952,0.3895744877329,0.389275055357659,0.389050481076228,
            0.388900764888607,0.388825906794797,0.388825906794797,0.388451616325745,
            0.388152183950503,0.387927609669072,0.387777893481451,0.387703035387641,
            0.387703035387641,0.3874036030124,0.387179028730969,0.387029312543348,
            0.386954454449538,0.386954454449538,0.386729880168106,0.386580163980486,
            0.386505305886675,0.386505305886675,0.386355589699055,0.386280731605244,
            0.386280731605244,0.386280731605244,0.386280731605244,0.386280731605244,
            0.385681866854762,0.385157860198089,0.384708711635227,0.384334421166175,
            0.384034988790934,0.383810414509503,0.383660698321882,0.383585840228072,
            0.383585840228072,0.383061833571399,0.382612685008537,0.382238394539485,
            0.381938962164244,0.381714387882813,0.381564671695192,0.381489813601382,
            0.381489813601382,0.38104066503852,0.380666374569468,0.380366942194226,
            0.380142367912795,0.379992651725175,0.379917793631364,0.379917793631364,
            0.379543503162312,0.379244070787071,0.37901949650564,0.378869780318019,
            0.378794922224209,0.378794922224209,0.378495489848967,0.378270915567536,
            0.378121199379916,0.378046341286105,0.378046341286105,0.377821767004674,
            0.377672050817054,0.377597192723243,0.377597192723243,0.377447476535622,
            0.377372618441812,0.377372618441812,0.377297760348002,0.377297760348002,
            0.377297760348002,0.376773753691329,0.376324605128467,0.375950314659415,
            0.375650882284174,0.375426308002743,0.375276591815122,0.375201733721312,
            0.375201733721312,0.37475258515845,0.374378294689398,0.374078862314156,
            0.373854288032725,0.373704571845105,0.373629713751294,0.373629713751294,
            0.373255423282243,0.372955990907001,0.37273141662557,0.372581700437949,
            0.372506842344139,0.372506842344139,0.372207409968898,0.371982835687466,
            0.371833119499846,0.371758261406035,0.371758261406035,0.371533687124604,
            0.371383970936984,0.371309112843173,0.371309112843173,0.371159396655553,
            0.371084538561742,0.371084538561742,0.371009680467932,0.371009680467932,
            0.371009680467932,0.37056053190507,0.370186241436018,0.369886809060777,
            0.369662234779345,0.369512518591725,0.369437660497914,0.369437660497914,
            0.369063370028863,0.368763937653621,0.36853936337219,0.368389647184569,
            0.368314789090759,0.368314789090759,0.368015356715518,0.367790782434087,
            0.367641066246466,0.367566208152656,0.367566208152656,0.367341633871224,
            0.367191917683604,0.367117059589793,0.367117059589793,0.366967343402173,
            0.366892485308362,0.366892485308362,0.366817627214552,0.366817627214552,
            0.366817627214552,0.3664433367455,0.366143904370259,0.365919330088828,
            0.365769613901207,0.365694755807397,0.365694755807397,0.365395323432155,
            0.365170749150724,0.365021032963103,0.364946174869293,0.364946174869293,
            0.364721600587862,0.364571884400241,0.364497026306431,0.364497026306431,
            0.36434731011881,0.364272452025,0.364272452025,0.36419759393119,
            0.36419759393119,0.36419759393119,0.363898161555948,0.363673587274517,
            0.363523871086896,0.363449012993086,0.363449012993086,0.363224438711655,
            0.363074722524034,0.362999864430224,0.362999864430224,0.362850148242603,
            0.362775290148793,0.362775290148793,0.362700432054982,0.362700432054982,
            0.362700432054982,0.362475857773551,0.362326141585931,0.36225128349212,
            0.36225128349212,0.3621015673045,0.362026709210689,0.362026709210689,
            0.361951851116879,0.361951851116879,0.361951851116879,0.361876993023068,
            0.361802134929258,0.361802134929258,0.361727276835448,0.361727276835448,
            0.361727276835448,0.361727276835448,0.361727276835448,0.361727276835448,
            0.361727276835448,0.361053553991155,0.360454689240672,0.359930682583999,
            0.359481534021137,0.359107243552085,0.358807811176844,0.358583236895413,
            0.358433520707792,0.358358662613982,0.358358662613982,0.357759797863499,
            0.357235791206826,0.356786642643964,0.356412352174913,0.356112919799671,
            0.35588834551824,0.355738629330619,0.355663771236809,0.355663771236809,
            0.355139764580136,0.354690616017274,0.354316325548223,0.354016893172981,
            0.35379231889155,0.353642602703929,0.353567744610119,0.353567744610119,
            0.353118596047257,0.352744305578205,0.352444873202964,0.352220298921533,
            0.352070582733912,0.351995724640102,0.351995724640102,0.35162143417105,
            0.351322001795808,0.351097427514377,0.350947711326757,0.350872853232946,
            0.350872853232946,0.350573420857705,0.350348846576274,0.350199130388653,
            0.350124272294843,0.350124272294843,0.349899698013412,0.349749981825791,
            0.349675123731981,0.349675123731981,0.34952540754436,0.349450549450549,
            0.349450549450549,0.349450549450549,0.349450549450549,0.349450549450549,
            0.348851684700067,0.348327678043394,0.347878529480532,0.34750423901148,
            0.347204806636239,0.346980232354808,0.346830516167187,0.346755658073377,
            0.346755658073377,0.346231651416704,0.345782502853842,0.34540821238479,
            0.345108780009549,0.344884205728118,0.344734489540497,0.344659631446687,
            0.344659631446687,0.344210482883825,0.343836192414773,0.343536760039531,
            0.3433121857581,0.34316246957048,0.343087611476669,0.343087611476669,
            0.342713321007617,0.342413888632376,0.342189314350945,0.342039598163324,
            0.341964740069514,0.341964740069514,0.341665307694272,0.341440733412841,
            0.341291017225221,0.34121615913141,0.34121615913141,0.340991584849979,
            0.340841868662359,0.340767010568548,0.340767010568548,0.340617294380927,
            0.340542436287117,0.340542436287117,0.340467578193307,0.340467578193307,
            0.340467578193307,0.339943571536634,0.339494422973772,0.33912013250472,
            0.338820700129479,0.338596125848048,0.338446409660427,0.338371551566617,
            0.338371551566617,0.337922403003755,0.337548112534703,0.337248680159461,
            0.33702410587803,0.33687438969041,0.336799531596599,0.336799531596599,
            0.336425241127548,0.336125808752306,0.335901234470875,0.335751518283254,
            0.335676660189444,0.335676660189444,0.335377227814203,0.335152653532772,
            0.335002937345151,0.33492807925134,0.33492807925134,0.334703504969909,
            0.334553788782289,0.334478930688478,0.334478930688478,0.334329214500858,
            0.334254356407047,0.334254356407047,0.334179498313237,0.334179498313237,
            0.334179498313237,0.333730349750375,0.333356059281323,0.333056626906082,
            0.33283205262465,0.33268233643703,0.332607478343219,0.332607478343219,
            0.332233187874168,0.331933755498926,0.331709181217495,0.331559465029874,
            0.331484606936064,0.331484606936064,0.331185174560823,0.330960600279392,
            0.330810884091771,0.330736025997961,0.330736025997961,0.33051145171653,
            0.330361735528909,0.330286877435098,0.330286877435098,0.330137161247478,
            0.330062303153667,0.330062303153667,0.329987445059857,0.329987445059857,
            0.329987445059857,0.329613154590805,0.329313722215564,0.329089147934133,
            0.328939431746512,0.328864573652702,0.328864573652702,0.32856514127746,
            0.328340566996029,0.328190850808408,0.328115992714598,0.328115992714598,
            0.327891418433167,0.327741702245546,0.327666844151736,0.327666844151736,
            0.327517127964115,0.327442269870305,0.327442269870305,0.327367411776495,
            0.327367411776495,0.327367411776495,0.327067979401253,0.326843405119822,
            0.326693688932201,0.326618830838391,0.326618830838391,0.32639425655696,
            0.326244540369339,0.326169682275529,0.326169682275529,0.326019966087908,
            0.325945107994098,0.325945107994098,0.325870249900287,0.325870249900287,
            0.325870249900287,0.325645675618856,0.325495959431236,0.325421101337425,
            0.325421101337425,0.325271385149805,0.325196527055994,0.325196527055994,
            0.325121668962184,0.325121668962184,0.325121668962184,0.324971952774563,
            0.324897094680753,0.324897094680753,0.324822236586942,0.324822236586942,
            0.324822236586942,0.324822236586942,0.324822236586942,0.324822236586942,
            0.324822236586942,0.323440014303594,0.322255252346438,0.321267950715474,
            0.320478109410704,0.319885728432126,0.31949080777974,0.319293347453548,
            0.319293347453548,0.317911125170199,0.316726363213043,0.31573906158208,
            0.314949220277309,0.314356839298731,0.313961918646346,0.313764458320153,
            0.313764458320153,0.312579696362997,0.311592394732034,0.310802553427263,
            0.310210172448685,0.3098152517963,0.309617791470107,0.309617791470107,
            0.308630489839144,0.307840648534373,0.307248267555795,0.306853346903409,
            0.306655886577217,0.306655886577217,0.305866045272446,0.305273664293868,
            0.304878743641483,0.30468128331529,0.30468128331529,0.304088902336712,
            0.303693981684327,0.303496521358134,0.303496521358134,0.303101600705749,
            0.302904140379556,0.302904140379556,0.302706680053363,0.302706680053363,
            0.302706680053363,0.301324457770015,0.300139695812859,0.299152394181895,
            0.298362552877125,0.297770171898547,0.297375251246161,0.297177790919969,
            0.297177790919969,0.295993028962813,0.295005727331849,0.294215886027079,
            0.293623505048501,0.293228584396115,0.293031124069923,0.293031124069923,
            0.292043822438959,0.291253981134189,0.290661600155611,0.290266679503225,
            0.290069219177032,0.290069219177032,0.289279377872262,0.288686996893684,
            0.288292076241298,0.288094615915106,0.288094615915106,0.287502234936528,
            0.287107314284142,0.28690985395795,0.28690985395795,0.286514933305564,
            0.286317472979372,0.286317472979372,0.286120012653179,0.286120012653179,
            0.286120012653179,0.284935250696023,0.28394794906506,0.283158107760289,
            0.282565726781711,0.282170806129326,0.281973345803133,0.281973345803133,
            0.28098604417217,0.280196202867399,0.279603821888821,0.279208901236436,
            0.279011440910243,0.279011440910243,0.278221599605472,0.277629218626894,
            0.277234297974509,0.277036837648316,0.277036837648316,0.276444456669738,
            0.276049536017353,0.27585207569116,0.27585207569116,0.275457155038775,
            0.275259694712582,0.275259694712582,0.27506223438639,0.27506223438639,
            0.27506223438639,0.274074932755426,0.273285091450656,0.272692710472078,
            0.272297789819692,0.2721003294935,0.2721003294935,0.271310488188729,
            0.270718107210151,0.270323186557765,0.270125726231573,0.270125726231573,
            0.269533345252995,0.269138424600609,0.268940964274417,0.268940964274417,
            0.268546043622031,0.268348583295839,0.268348583295839,0.268151122969646,
            0.268151122969646,0.268151122969646,0.267361281664875,0.266768900686297,
            0.266373980033912,0.266176519707719,0.266176519707719,0.265584138729141,
            0.265189218076756,0.264991757750563,0.264991757750563,0.264596837098178,
            0.264399376771985,0.264399376771985,0.264201916445793,0.264201916445793,
            0.264201916445793,0.263609535467215,0.263214614814829,0.263017154488637,
            0.263017154488637,0.262622233836251,0.262424773510059,0.262424773510059,
            0.262227313183866,0.262227313183866,0.262227313183866,0.261832392531481,
            0.261634932205288,0.261634932205288,0.261437471879095,0.261437471879095,
            0.261437471879095,0.261437471879095,0.261437471879095,0.261437471879095,
            0.261437471879095,0.260252709921939,0.259067947964783,0.25808064633382,
            0.257290805029049,0.256698424050471,0.256303503398086,0.256106043071893,
            0.256106043071893,0.254921281114737,0.253933979483774,0.253144138179003,
            0.252551757200425,0.25215683654804,0.251959376221847,0.251959376221847,
            0.250972074590884,0.250182233286113,0.249589852307535,0.24919493165515,
            0.248997471328957,0.248997471328957,0.248207630024186,0.247615249045608,
            0.247220328393223,0.24702286806703,0.24702286806703,0.246430487088452,
            0.246035566436067,0.245838106109874,0.245838106109874,0.245443185457489,
            0.245245725131296,0.245245725131296,0.245048264805104,0.245048264805104,
            0.245048264805104,0.243863502847948,0.242876201216984,0.242086359912214,
            0.241493978933636,0.24109905828125,0.240901597955058,0.240901597955058,
            0.239914296324094,0.239124455019324,0.238532074040746,0.23813715338836,
            0.237939693062168,0.237939693062168,0.237149851757397,0.236557470778819,
            0.236162550126434,0.235965089800241,0.235965089800241,0.235372708821663,
            0.234977788169278,0.234780327843085,0.234780327843085,0.2343854071907,
            0.234187946864507,0.234187946864507,0.233990486538314,0.233990486538314,
            0.233990486538314,0.233003184907351,0.23221334360258,0.231620962624002,
            0.231226041971617,0.231028581645424,0.231028581645424,0.230238740340653,
            0.229646359362075,0.22925143870969,0.229053978383497,0.229053978383497,
            0.228461597404919,0.228066676752534,0.227869216426341,0.227869216426341,
            0.227474295773956,0.227276835447763,0.227276835447763,0.227079375121571,
            0.227079375121571,0.227079375121571,0.2262895338168,0.225697152838222,
            0.225302232185837,0.225104771859644,0.225104771859644,0.224512390881066,
            0.224117470228681,0.223920009902488,0.223920009902488,0.223525089250103,
            0.22332762892391,0.22332762892391,0.223130168597717,0.223130168597717,
            0.223130168597717,0.222537787619139,0.222142866966754,0.221945406640561,
            0.221945406640561,0.221550485988176,0.221353025661983,0.221353025661983,
            0.221155565335791,0.221155565335791,0.221155565335791,0.220760644683405,
            0.220563184357213,0.220563184357213,0.22036572403102,0.22036572403102,
            0.22036572403102,0.22036572403102,0.22036572403102,0.22036572403102,
            0.22036572403102,0.219378422400057,0.218391120769093,0.217601279464323,
            0.217008898485745,0.216613977833359,0.216416517507167,0.216416517507167,
            0.215429215876203,0.214639374571433,0.214046993592854,0.213652072940469,
            0.213454612614276,0.213454612614276,0.212664771309506,0.212072390330928,
            0.211677469678542,0.21148000935235,0.21148000935235,0.210887628373772,
            0.210492707721386,0.210295247395194,0.210295247395194,0.209900326742808,
            0.209702866416616,0.209702866416616,0.209505406090423,0.209505406090423,
            0.209505406090423,0.20851810445946,0.207728263154689,0.207135882176111,
            0.206740961523726,0.206543501197533,0.206543501197533,0.205753659892762,
            0.205161278914184,0.204766358261799,0.204568897935606,0.204568897935606,
            0.203976516957028,0.203581596304643,0.20338413597845,0.20338413597845,
            0.202989215326065,0.202791754999872,0.202791754999872,0.20259429467368,
            0.20259429467368,0.20259429467368,0.201804453368909,0.201212072390331,
            0.200817151737946,0.200619691411753,0.200619691411753,0.200027310433175,
            0.19963238978079,0.199434929454597,0.199434929454597,0.199040008802212,
            0.198842548476019,0.198842548476019,0.198645088149826,0.198645088149826,
            0.198645088149826,0.198052707171248,0.197657786518863,0.19746032619267,
            0.19746032619267,0.197065405540285,0.196867945214092,0.196867945214092,
            0.1966704848879,0.1966704848879,0.1966704848879,0.196275564235514,
            0.196078103909322,0.196078103909322,0.195880643583129,0.195880643583129,
            0.195880643583129,0.195880643583129,0.195880643583129,0.195880643583129,
            0.195880643583129,0.195090802278358,0.194300960973587,0.193708579995009,
            0.193313659342624,0.193116199016431,0.193116199016431,0.192326357711661,
            0.191733976733083,0.191339056080697,0.191141595754505,0.191141595754505,
            0.190549214775927,0.190154294123541,0.189956833797349,0.189956833797349,
            0.189561913144963,0.189364452818771,0.189364452818771,0.189166992492578,
            0.189166992492578,0.189166992492578,0.188377151187807,0.187784770209229,
            0.187389849556844,0.187192389230651,0.187192389230651,0.186600008252073,
            0.186205087599688,0.186007627273495,0.186007627273495,0.18561270662111,
            0.185415246294917,0.185415246294917,0.185217785968725,0.185217785968725,
            0.185217785968725,0.184625404990147,0.184230484337761,0.184033024011569,
            0.184033024011569,0.183638103359183,0.183440643032991,0.183440643032991,
            0.183243182706798,0.183243182706798,0.183243182706798,0.182848262054413,
            0.18265080172822,0.18265080172822,0.182453341402027,0.182453341402027,
            0.182453341402027,0.182453341402027,0.182453341402027,0.182453341402027,
            0.182453341402027,0.181860960423449,0.181268579444871,0.180873658792486,
            0.180676198466293,0.180676198466293,0.180083817487715,0.17968889683533,
            0.179491436509137,0.179491436509137,0.179096515856752,0.178899055530559,
            0.178899055530559,0.178701595204367,0.178701595204367,0.178701595204367,
            0.178109214225789,0.177714293573403,0.177516833247211,0.177516833247211,
            0.177121912594825,0.176924452268632,0.176924452268632,0.17672699194244,
            0.17672699194244,0.17672699194244,0.176332071290054,0.176134610963862,
            0.176134610963862,0.175937150637669,0.175937150637669,0.175937150637669,
            0.175937150637669,0.175937150637669,0.175937150637669,0.175937150637669,
            0.175542229985284,0.175147309332898,0.174949849006706,0.174949849006706,
            0.17455492835432,0.174357468028128,0.174357468028128,0.174160007701935,
            0.174160007701935,0.174160007701935,0.17376508704955,0.173567626723357,
            0.173567626723357,0.173370166397164,0.173370166397164,0.173370166397164,
            0.173370166397164,0.173370166397164,0.173370166397164,0.173370166397164,
            0.173172706070972,0.172975245744779,0.172975245744779,0.172777785418586,
            0.172777785418586,0.172777785418586,0.172777785418586,0.172777785418586,
            0.172777785418586,0.172777785418586,0.172777785418586,0.172777785418586,
            0.172777785418586,0.172777785418586,0.17159302346143,0.170605721830467,
            0.169815880525696,0.169223499547118,0.168828578894733,0.16863111856854,
            0.16863111856854,0.167446356611384,0.166459054980421,0.16566921367565,
            0.165076832697072,0.164681912044687,0.164484451718494,0.164484451718494,
            0.163497150087531,0.16270730878276,0.162114927804182,0.161720007151797,
            0.161522546825604,0.161522546825604,0.160732705520834,0.160140324542256,
            0.15974540388987,0.159547943563678,0.159547943563678,0.1589555625851,
            0.158560641932714,0.158363181606521,0.158363181606521,0.157968260954136,
            0.157770800627943,0.157770800627943,0.157573340301751,0.157573340301751,
            0.157573340301751,0.156388578344595,0.155401276713631,0.154611435408861,
            0.154019054430283,0.153624133777897,0.153426673451705,0.153426673451705,
            0.152439371820741,0.151649530515971,0.151057149537393,0.150662228885007,
            0.150464768558815,0.150464768558815,0.149674927254044,0.149082546275466,
            0.148687625623081,0.148490165296888,0.148490165296888,0.14789778431831,
            0.147502863665925,0.147305403339732,0.147305403339732,0.146910482687347,
            0.146713022361154,0.146713022361154,0.146515562034961,0.146515562034961,
            0.146515562034961,0.145528260403998,0.144738419099227,0.144146038120649,
            0.143751117468264,0.143553657142071,0.143553657142071,0.142763815837301,
            0.142171434858723,0.141776514206337,0.141579053880145,0.141579053880145,
            0.140986672901567,0.140591752249181,0.140394291922988,0.140394291922988,
            0.139999371270603,0.13980191094441,0.13980191094441,0.139604450618218,
            0.139604450618218,0.139604450618218,0.138814609313447,0.138222228334869,
            0.137827307682484,0.137629847356291,0.137629847356291,0.137037466377713,
            0.136642545725328,0.136445085399135,0.136445085399135,0.13605016474675,
            0.135852704420557,0.135852704420557,0.135655244094364,0.135655244094364,
            0.135655244094364,0.135062863115786,0.134667942463401,0.134470482137208,
            0.134470482137208,0.134075561484823,0.13387810115863,0.13387810115863,
            0.133680640832438,0.133680640832438,0.133680640832438,0.133285720180052,
            0.13308825985386,0.13308825985386,0.132890799527667,0.132890799527667,
            0.132890799527667,0.132693339201474,0.132693339201474,0.132693339201474,
            0.132693339201474,0.131706037570511,0.130718735939548,0.129928894634777,
            0.129336513656199,0.128941593003814,0.128744132677621,0.128744132677621,
            0.127756831046658,0.126966989741887,0.126374608763309,0.125979688110924,
            0.125782227784731,0.125782227784731,0.12499238647996,0.124400005501382,
            0.124005084848997,0.123807624522804,0.123807624522804,0.123215243544226,
            0.122820322891841,0.122622862565648,0.122622862565648,0.122227941913263,
            0.12203048158707,0.12203048158707,0.121833021260878,0.121833021260878,
            0.121833021260878,0.120845719629914,0.120055878325143,0.119463497346565,
            0.11906857669418,0.118871116367987,0.118871116367987,0.118081275063217,
            0.117488894084639,0.117093973432253,0.116896513106061,0.116896513106061,
            0.116304132127483,0.115909211475097,0.115711751148905,0.115711751148905,
            0.115316830496519,0.115119370170327,0.115119370170327,0.114921909844134,
            0.114921909844134,0.114921909844134,0.114132068539363,0.113539687560785,
            0.1131447669084,0.112947306582207,0.112947306582207,0.112354925603629,
            0.111960004951244,0.111762544625051,0.111762544625051,0.111367623972666,
            0.111170163646473,0.111170163646473,0.110972703320281,0.110972703320281,
            0.110972703320281,0.110380322341703,0.109985401689317,0.109787941363125,
            0.109787941363125,0.109393020710739,0.109195560384547,0.109195560384547,
            0.108998100058354,0.108998100058354,0.108998100058354,0.108603179405969,
            0.108405719079776,0.108405719079776,0.108208258753583,0.108208258753583,
            0.108208258753583,0.108010798427391,0.108010798427391,0.108010798427391,
            0.108010798427391,0.10722095712262,0.106431115817849,0.105838734839271,
            0.105443814186886,0.105246353860693,0.105246353860693,0.104456512555923,
            0.103864131577345,0.103469210924959,0.103271750598767,0.103271750598767,
            0.102679369620189,0.102284448967803,0.10208698864161,0.10208698864161,
            0.101692067989225,0.101494607663032,0.101494607663032,0.10129714733684,
            0.10129714733684,0.10129714733684,0.100507306032069,0.0999149250534911,
            0.0995200044011058,0.0993225440749131,0.0993225440749131,0.0987301630963351,
            0.0983352424439498,0.0981377821177571,0.0981377821177571,0.0977428614653717,
            0.0975454011391791,0.0975454011391791,0.0973479408129864,0.0973479408129864,
            0.0973479408129864,0.0967555598344084,0.0963606391820231,0.0961631788558304,
            0.0961631788558304,0.095768258203445,0.0955707978772524,0.0955707978772524,
            0.0953733375510597,0.0953733375510597,0.0953733375510597,0.0949784168986744,
            0.0947809565724817,0.0947809565724817,0.094583496246289,0.094583496246289,
            0.094583496246289,0.0943860359200964,0.0943860359200964,0.0943860359200964,
            0.0943860359200964,0.0937936549415183,0.0932012739629403,0.092806353310555,
            0.0926088929843623,0.0926088929843623,0.0920165120057843,0.091621591353399,
            0.0914241310272063,0.0914241310272063,0.091029210374821,0.0908317500486283,
            0.0908317500486283,0.0906342897224356,0.0906342897224356,0.0906342897224356,
            0.0900419087438576,0.0896469880914723,0.0894495277652796,0.0894495277652796,
            0.0890546071128943,0.0888571467867016,0.0888571467867016,0.0886596864605089,
            0.0886596864605089,0.0886596864605089,0.0882647658081236,0.0880673054819309,
            0.0880673054819309,0.0878698451557382,0.0878698451557382,0.0878698451557382,
            0.0876723848295456,0.0876723848295456,0.0876723848295456,0.0876723848295456,
            0.0872774641771602,0.0868825435247749,0.0866850831985822,0.0866850831985822,
            0.0862901625461969,0.0860927022200042,0.0860927022200042,0.0858952418938115,
            0.0858952418938115,0.0858952418938115,0.0855003212414262,0.0853028609152335,
            0.0853028609152335,0.0851054005890409,0.0851054005890409,0.0851054005890409,
            0.0849079402628482,0.0849079402628482,0.0849079402628482,0.0849079402628482,
            0.0847104799366555,0.0845130196104628,0.0845130196104628,0.0843155592842702,
            0.0843155592842702,0.0843155592842702,0.0841180989580775,0.0841180989580775,
            0.0841180989580775,0.0841180989580775,0.0841180989580775,0.0841180989580775,
            0.0841180989580775,0.0841180989580775,0.0841180989580775,0.0831307973271141,
            0.0823409560223435,0.0817485750437655,0.0813536543913801,0.0811561940651875,
            0.0811561940651875,0.0801688924342241,0.0793790511294534,0.0787866701508754,
            0.0783917494984901,0.0781942891722974,0.0781942891722974,0.0774044478675267,
            0.0768120668889487,0.0764171462365634,0.0762196859103707,0.0762196859103707,
            0.0756273049317927,0.0752323842794073,0.0750349239532147,0.0750349239532147,
            0.0746400033008293,0.0744425429746367,0.0744425429746367,0.074245082648444,
            0.074245082648444,0.074245082648444,0.0732577810174806,0.07246793971271,
            0.071875558734132,0.0714806380817466,0.0712831777555539,0.0712831777555539,
            0.0704933364507833,0.0699009554722052,0.0695060348198199,0.0693085744936272,
            0.0693085744936272,0.0687161935150492,0.0683212728626639,0.0681238125364712,
            0.0681238125364712,0.0677288918840859,0.0675314315578932,0.0675314315578932,
            0.0673339712317005,0.0673339712317005,0.0673339712317005,0.0665441299269299,
            0.0659517489483518,0.0655568282959665,0.0653593679697738,0.0653593679697738,
            0.0647669869911958,0.0643720663388105,0.0641746060126178,0.0641746060126178,
            0.0637796853602325,0.0635822250340398,0.0635822250340398,0.0633847647078471,
            0.0633847647078471,0.0633847647078471,0.0627923837292691,0.0623974630768838,
            0.0622000027506911,0.0622000027506911,0.0618050820983058,0.0616076217721131,
            0.0616076217721131,0.0614101614459204,0.0614101614459204,0.0614101614459204,
            0.0610152407935351,0.0608177804673424,0.0608177804673424,0.0606203201411497,
            0.0606203201411497,0.0606203201411497,0.0604228598149571,0.0604228598149571,
            0.0604228598149571,0.0604228598149571,0.0596330185101864,0.0588431772054157,
            0.0582507962268377,0.0578558755744524,0.0576584152482597,0.0576584152482597,
            0.056868573943489,0.056276192964911,0.0558812723125257,0.055683811986333,
            0.055683811986333,0.055091431007755,0.0546965103553696,0.054499050029177,
            0.054499050029177,0.0541041293767916,0.053906669050599,0.053906669050599,
            0.0537092087244063,0.0537092087244063,0.0537092087244063,0.0529193674196356,
            0.0523269864410576,0.0519320657886723,0.0517346054624796,0.0517346054624796,
            0.0511422244839016,0.0507473038315162,0.0505498435053236,0.0505498435053236,
            0.0501549228529382,0.0499574625267456,0.0499574625267456,0.0497600022005529,
            0.0497600022005529,0.0497600022005529,0.0491676212219749,0.0487727005695895,
            0.0485752402433969,0.0485752402433969,0.0481803195910115,0.0479828592648189,
            0.0479828592648189,0.0477853989386262,0.0477853989386262,0.0477853989386262,
            0.0473904782862408,0.0471930179600482,0.0471930179600482,0.0469955576338555,
            0.0469955576338555,0.0469955576338555,0.0467980973076628,0.0467980973076628,
            0.0467980973076628,0.0467980973076628,0.0462057163290848,0.0456133353505068,
            0.0452184146981215,0.0450209543719288,0.0450209543719288,0.0444285733933508,
            0.0440336527409655,0.0438361924147728,0.0438361924147728,0.0434412717623874,
            0.0432438114361948,0.0432438114361948,0.0430463511100021,0.0430463511100021,
            0.0430463511100021,0.0424539701314241,0.0420590494790388,0.0418615891528461,
            0.0418615891528461,0.0414666685004607,0.0412692081742681,0.0412692081742681,
            0.0410717478480754,0.0410717478480754,0.0410717478480754,0.0406768271956901,
            0.0404793668694974,0.0404793668694974,0.0402819065433047,0.0402819065433047,
            0.0402819065433047,0.040084446217112,0.040084446217112,0.040084446217112,
            0.040084446217112,0.0396895255647267,0.0392946049123414,0.0390971445861487,
            0.0390971445861487,0.0387022239337634,0.0385047636075707,0.0385047636075707,
            0.038307303281378,0.038307303281378,0.038307303281378,0.0379123826289927,
            0.0377149223028,0.0377149223028,0.0375174619766073,0.0375174619766073,
            0.0375174619766073,0.0373200016504147,0.0373200016504147,0.0373200016504147,
            0.0373200016504147,0.037122541324222,0.0369250809980293,0.0369250809980293,
            0.0367276206718367,0.0367276206718367,0.0367276206718367,0.036530160345644,
            0.036530160345644,0.036530160345644,0.036530160345644,0.036530160345644,
            0.036530160345644,0.036530160345644,0.036530160345644,0.036530160345644,
            0.0357403190408733,0.0351479380622953,0.03475301740991,0.0345555570837173,
            0.0345555570837173,0.0337657157789466,0.0331733348003686,0.0327784141479832,
            0.0325809538217906,0.0325809538217906,0.0319885728432126,0.0315936521908272,
            0.0313961918646346,0.0313961918646346,0.0310012712122492,0.0308038108860566,
            0.0308038108860566,0.0306063505598639,0.0306063505598639,0.0306063505598639,
            0.0298165092550932,0.0292241282765152,0.0288292076241298,0.0286317472979372,
            0.0286317472979372,0.0280393663193592,0.0276444456669738,0.0274469853407812,
            0.0274469853407812,0.0270520646883958,0.0268546043622031,0.0268546043622031,
            0.0266571440360105,0.0266571440360105,0.0266571440360105,0.0260647630574325,
            0.0256698424050471,0.0254723820788545,0.0254723820788545,0.0250774614264691,
            0.0248800011002764,0.0248800011002764,0.0246825407740838,0.0246825407740838,
            0.0246825407740838,0.0242876201216984,0.0240901597955058,0.0240901597955058,
            0.0238926994693131,0.0238926994693131,0.0238926994693131,0.0236952391431204,
            0.0236952391431204,0.0236952391431204,0.0236952391431204,0.0231028581645424,
            0.0225104771859644,0.0221155565335791,0.0219180962073864,0.0219180962073864,
            0.0213257152288084,0.020930794576423,0.0207333342502304,0.0207333342502304,
            0.020338413597845,0.0201409532716524,0.0201409532716524,0.0199434929454597,
            0.0199434929454597,0.0199434929454597,0.0193511119668817,0.0189561913144963,
            0.0187587309883037,0.0187587309883037,0.0183638103359183,0.0181663500097257,
            0.0181663500097257,0.017968889683533,0.017968889683533,0.017968889683533,
            0.0175739690311476,0.017376508704955,0.017376508704955,0.0171790483787623,
            0.0171790483787623,0.0171790483787623,0.0169815880525696,0.0169815880525696,
            0.0169815880525696,0.0169815880525696,0.0165866674001843,0.016191746747799,
            0.0159942864216063,0.0159942864216063,0.0155993657692209,0.0154019054430283,
            0.0154019054430283,0.0152044451168356,0.0152044451168356,0.0152044451168356,
            0.0148095244644503,0.0146120641382576,0.0146120641382576,0.0144146038120649,
            0.0144146038120649,0.0144146038120649,0.0142171434858723,0.0142171434858723,
            0.0142171434858723,0.0142171434858723,0.0140196831596796,0.0138222228334869,
            0.0138222228334869,0.0136247625072942,0.0136247625072942,0.0136247625072942,
            0.0134273021811016,0.0134273021811016,0.0134273021811016,0.0134273021811016,
            0.0134273021811016,0.0134273021811016,0.0134273021811016,0.0134273021811016,
            0.0134273021811016,0.0128349212025236,0.0124400005501382,0.0122425402239456,
            0.0122425402239456,0.0116501592453675,0.0112552385929822,0.0110577782667895,
            0.0110577782667895,0.0106628576144042,0.0104653972882115,0.0104653972882115,
            0.0102679369620189,0.0102679369620189,0.0102679369620189,0.00967555598344084,
            0.0092806353310555,0.00908317500486283,0.00908317500486283,0.00868825435247749,
            0.00849079402628482,0.00849079402628482,0.00829333370009215,0.00829333370009215,
            0.00829333370009215,0.00789841304770681,0.00770095272151414,0.00770095272151414,
            0.00750349239532147,0.00750349239532147,0.00750349239532147,0.0073060320691288,
            0.0073060320691288,0.0073060320691288,0.0073060320691288,0.00691111141674346,
            0.00651619076435812,0.00631873043816545,0.00631873043816545,0.00592380978578011,
            0.00572634945958744,0.00572634945958744,0.00552888913339477,0.00552888913339477,
            0.00552888913339477,0.00513396848100943,0.00493650815481675,0.00493650815481675,
            0.00473904782862408,0.00473904782862408,0.00473904782862408,0.00454158750243141,
            0.00454158750243141,0.00454158750243141,0.00454158750243141,0.00434412717623874,
            0.00414666685004607,0.00414666685004607,0.0039492065238534,0.0039492065238534,
            0.0039492065238534,0.00375174619766073,0.00375174619766073,0.00375174619766073,
            0.00375174619766073,0.00375174619766073,0.00375174619766073,0.00375174619766073,
            0.00375174619766073,0.00375174619766073,0.00335682554527539,0.00315936521908272,
            0.00315936521908272,0.00276444456669738,0.00256698424050471,0.00256698424050471,
            0.00236952391431204,0.00236952391431204,0.00236952391431204,0.0019746032619267,
            0.00177714293573403,0.00177714293573403,0.00157968260954136,0.00157968260954136,
            0.00157968260954136,0.00138222228334869,0.00138222228334869,0.00138222228334869,
            0.00138222228334869,0.00118476195715602,0.000987301630963351,0.000987301630963351,
            0.000789841304770681,0.000789841304770681,0.000789841304770681,0.000592380978578011,
            0.000592380978578011,0.000592380978578011,0.000592380978578011,0.000592380978578011,
            0.000592380978578011,0.000592380978578011,0.000592380978578011,0.000592380978578011,
            0.00039492065238534,0.00039492065238534,0.00019746032619267,0.00019746032619267,
            0.00019746032619267,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0
        ]
        rank_to_percentile_7 = [
            0.999967679379444,0.999936734104444,0.999905788829443,0.999874843554443,
            0.999843898279443,0.999812953004442,0.999782007729442,0.999751062454442,
            0.999720117179441,0.999689171904441,0.999658884403402,0.999633739498788,
            0.999613258809537,0.999596963954585,0.99958437655287,0.999575018223329,
            0.999568410584899,0.999564075256517,0.999561533857121,0.999560308005647,
            0.999559919321034,0.999559889422217,0.999529601921178,0.999504457016565,
            0.999483976327313,0.999467681472361,0.999455094070646,0.999445735741105,
            0.999439128102675,0.999434792774293,0.999432251374897,0.999431025523424,
            0.99943063683881,0.999430606939994,0.999400319438955,0.999375174534341,
            0.999354693845089,0.999338398990138,0.999325811588422,0.999316453258881,
            0.999309845620451,0.99930551029207,0.999302968892673,0.9993017430412,
            0.999301354356586,0.99930132445777,0.999271036956731,0.999245892052117,
            0.999225411362866,0.999209116507914,0.999196529106199,0.999187170776658,
            0.999180563138228,0.999176227809846,0.99917368641045,0.999172460558976,
            0.999172071874363,0.999172041975546,0.999141754474507,0.999116609569894,
            0.999096128880642,0.99907983402569,0.999067246623975,0.999057888294434,
            0.999051280656004,0.999046945327622,0.999044403928226,0.999043178076753,
            0.999042789392139,0.999042759493323,0.999012471992284,0.99898732708767,
            0.998966846398418,0.998950551543467,0.998937964141752,0.99892860581221,
            0.99892199817378,0.998917662845399,0.998915121446002,0.998913895594529,
            0.998913506909915,0.998913477011099,0.99888318951006,0.998858044605446,
            0.998837563916195,0.998821269061243,0.998808681659528,0.998799323329987,
            0.998792715691557,0.998788380363175,0.998785838963779,0.998784613112305,
            0.998784224427692,0.998784194528875,0.998753907027836,0.998728762123223,
            0.998708281433971,0.998691986579019,0.998679399177304,0.998670040847763,
            0.998663433209333,0.998659097880951,0.998656556481555,0.998655330630082,
            0.998654941945468,0.998654912046652,0.998624624545613,0.998599479640999,
            0.998578998951748,0.998562704096796,0.998550116695081,0.998540758365539,
            0.998534150727109,0.998529815398728,0.998527273999331,0.998526048147858,
            0.998525659463244,0.998525629564428,0.998495342063389,0.998470197158775,
            0.998449716469524,0.998433421614572,0.998420834212857,0.998411475883316,
            0.998404868244886,0.998400532916504,0.998397991517108,0.998396765665634,
            0.998396376981021,0.998396347082204,0.998366059581165,0.998340914676552,
            0.9983204339873,0.998304139132348,0.998291551730633,0.998282193401092,
            0.998275585762662,0.99827125043428,0.998268709034884,0.998267483183411,
            0.998267094498797,0.998267064599981,0.998236777098942,0.998211632194328,
            0.998191151505077,0.998174856650125,0.99816226924841,0.998152910918868,
            0.998146303280438,0.998141967952057,0.998139426552661,0.998138200701187,
            0.998137812016573,0.998137782117757,0.998107494616718,0.998082349712104,
            0.998061869022853,0.998045574167901,0.998032986766186,0.998023628436645,
            0.998017020798215,0.998012685469833,0.998010144070437,0.998008918218963,
            0.99800852953435,0.998008499635533,0.997833531761812,0.997659640245481,
            0.997486825086542,0.997315086284994,0.997144423840838,0.996974837754073,
            0.996806328024699,0.996638894652716,0.996472537638125,0.996307256980925,
            0.996143052681117,0.995979924738699,0.995810219056668,0.995636327540338,
            0.995463512381399,0.995291773579851,0.995121111135695,0.994951525048929,
            0.994783015319556,0.994615581947573,0.994449224932982,0.994283944275782,
            0.994119739975973,0.993956612033556,0.993786906351525,0.993618277026886,
            0.993445461867946,0.993273723066399,0.993103060622242,0.992933474535477,
            0.992764964806103,0.992597531434121,0.992431174419529,0.99226589376233,
            0.992101689462521,0.991938561520104,0.991768855838073,0.991600226513433,
            0.991432673546185,0.991260934744637,0.991090272300481,0.990920686213716,
            0.990752176484342,0.990584743112359,0.990418386097768,0.990253105440568,
            0.990088901140759,0.989925773198342,0.989756067516311,0.989587438191672,
            0.989419885224423,0.989253408614567,0.98908274617041,0.988913160083645,
            0.988744650354271,0.988577216982289,0.988410859967697,0.988245579310497,
            0.988081375010689,0.987918247068272,0.987748541386241,0.987579912061601,
            0.987412359094353,0.987245882484496,0.98708048223203,0.986910896145265,
            0.986742386415891,0.986574953043909,0.986408596029318,0.986243315372118,
            0.986079111072309,0.985915983129892,0.985746277447861,0.985577648123221,
            0.985410095155973,0.985243618546116,0.985078218293651,0.984913894398576,
            0.984745384669202,0.98457795129722,0.984411594282629,0.984246313625429,
            0.98408210932562,0.983918981383203,0.983749275701172,0.983580646376533,
            0.983413093409284,0.983246616799427,0.983081216546962,0.982916892651888,
            0.982753645114204,0.982586211742222,0.982419854727631,0.982254574070431,
            0.982090369770622,0.981927241828205,0.981757536146174,0.981588906821535,
            0.981421353854286,0.981254877244429,0.981089476991964,0.98092515309689,
            0.980761905559207,0.980599734378915,0.980433377364324,0.980268096707124,
            0.980103892407315,0.979940764464898,0.979771058782867,0.979602429458228,
            0.979434876490979,0.979268399881122,0.979102999628657,0.978938675733582,
            0.978775428195899,0.978613257015608,0.978452162192707,0.978286881535508,
            0.978122677235699,0.977959549293282,0.977789843611251,0.977621214286611,
            0.977453661319363,0.977287184709506,0.97712178445704,0.976957460561966,
            0.976794213024283,0.976632041843992,0.976470947021091,0.976310928555582,
            0.976146724255774,0.975983596313356,0.975813890631326,0.975645261306686,
            0.975477708339438,0.975311231729581,0.975145831477115,0.974981507582041,
            0.974818260044358,0.974656088864066,0.974494994041166,0.974334975575657,
            0.974176033467539,0.974012905525122,0.973843199843091,0.973674570518451,
            0.973507017551203,0.973340540941346,0.973175140688881,0.973010816793806,
            0.972847569256123,0.972685398075832,0.972524303252931,0.972364284787422,
            0.972205342679305,0.972047476928578,0.972016531653578,0.971986931825317,
            0.971958647544978,0.971931648913746,0.971905906032804,0.971881389003335,
            0.971858067926523,0.971835912903552,0.971804967628552,0.97177536780029,
            0.971747083519952,0.97172008488872,0.971694342007777,0.971669824978308,
            0.971646503901497,0.971624348878525,0.971594749050264,0.971566464769926,
            0.971539466138693,0.971513723257751,0.971489206228282,0.97146588515147,
            0.971443730128499,0.971415445848161,0.971388447216929,0.971362704335986,
            0.971338187306517,0.971314866229705,0.971292711206734,0.971265712575502,
            0.97123996969456,0.971215452665091,0.971192131588279,0.971169976565308,
            0.971144233684365,0.971119716654896,0.971096395578085,0.971074240555113,
            0.971049753424461,0.971026432347649,0.971004277324678,0.970980956247866,
            0.970958801224895,0.970936646201923,0.970905730825739,0.970876130997478,
            0.97084784671714,0.970820848085908,0.970795105204965,0.970770588175496,
            0.970747267098685,0.970725112075713,0.970695512247452,0.970667227967114,
            0.970640229335881,0.970614486454939,0.97058996942547,0.970566648348658,
            0.970544493325687,0.970516209045349,0.970489210414117,0.970463467533174,
            0.970438950503705,0.970415629426894,0.970393474403922,0.97036647577269,
            0.970340732891748,0.970316215862279,0.970292894785467,0.970270739762496,
            0.970244996881553,0.970220479852085,0.970197158775273,0.970175003752301,
            0.970150516621649,0.970127195544837,0.970105040521866,0.970081719445054,
            0.970059564422083,0.970037409399112,0.970007839469667,0.969979555189328,
            0.969952556558096,0.969926813677154,0.969902296647685,0.969878975570873,
            0.969856820547902,0.969828536267563,0.969801537636331,0.969775794755389,
            0.96975127772592,0.969727956649108,0.969705801626137,0.969678802994905,
            0.969653060113962,0.969628543084493,0.969605222007682,0.96958306698471,
            0.969557324103768,0.969532807074299,0.969509485997487,0.969487330974516,
            0.969462843843864,0.969439522767052,0.96941736774408,0.969394046667269,
            0.969371891644297,0.969349736621326,0.969321482239804,0.969294483608572,
            0.96926874072763,0.969244223698161,0.969220902621349,0.969198747598378,
            0.969171748967145,0.969146006086203,0.969121489056734,0.969098167979922,
            0.969076012956951,0.969050270076009,0.96902575304654,0.969002431969728,
            0.968980276946757,0.968955789816104,0.968932468739293,0.968910313716321,
            0.968886992639509,0.968864837616538,0.968842682593567,0.968815713861151,
            0.968789970980209,0.96876545395074,0.968742132873928,0.968719977850957,
            0.968694234970015,0.968669717940546,0.968646396863734,0.968624241840762,
            0.96859975471011,0.968576433633298,0.968554278610327,0.968530957533515,
            0.968508802510544,0.968486647487573,0.968460934505447,0.968436417475978,
            0.968413096399166,0.968390941376195,0.968366454245542,0.96834313316873,
            0.968320978145759,0.968297657068947,0.968275502045976,0.968253347023005,
            0.968228859892352,0.968205538815541,0.968183383792569,0.968160062715757,
            0.968137907692786,0.968115752669815,0.968093597646844,0.968071442623872,
            0.968049287600901,0.96802713257793,0.967997532749669,0.967967932921407,
            0.967939648641069,0.967912650009837,0.967886907128894,0.967862390099426,
            0.967839069022614,0.967816913999642,0.967787314171381,0.967759029891043,
            0.967732031259811,0.967706288378868,0.967681771349399,0.967658450272587,
            0.967636295249616,0.967608010969278,0.967581012338046,0.967555269457103,
            0.967530752427634,0.967507431350823,0.967485276327851,0.967458277696619,
            0.967432534815677,0.967408017786208,0.967384696709396,0.967362541686425,
            0.967336798805483,0.967312281776014,0.967288960699202,0.96726680567623,
            0.967242318545578,0.967218997468766,0.967196842445795,0.967173521368983,
            0.967151366346012,0.967129211323041,0.967099641393596,0.967071357113257,
            0.967044358482025,0.967018615601083,0.966994098571614,0.966970777494802,
            0.966948622471831,0.966920338191492,0.96689333956026,0.966867596679318,
            0.966843079649849,0.966819758573037,0.966797603550066,0.966770604918834,
            0.966744862037891,0.966720345008423,0.966697023931611,0.966674868908639,
            0.966649126027697,0.966624608998228,0.966601287921416,0.966579132898445,
            0.966554645767793,0.966531324690981,0.966509169668009,0.966485848591198,
            0.966463693568226,0.966441538545255,0.966413284163733,0.966386285532501,
            0.966360542651559,0.96633602562209,0.966312704545278,0.966290549522307,
            0.966263550891074,0.966237808010132,0.966213290980663,0.966189969903851,
            0.96616781488088,0.966142071999938,0.966117554970469,0.966094233893657,
            0.966072078870686,0.966047591740033,0.966024270663221,0.96600211564025,
            0.965978794563438,0.965956639540467,0.965934484517496,0.96590751578508,
            0.965881772904138,0.965857255874669,0.965833934797857,0.965811779774886,
            0.965786036893943,0.965761519864475,0.965738198787663,0.965716043764692,
            0.965691556634039,0.965668235557227,0.965646080534256,0.965622759457444,
            0.965600604434473,0.965578449411502,0.965552736429376,0.965528219399907,
            0.965504898323095,0.965482743300124,0.965458256169471,0.965434935092659,
            0.965412780069688,0.965389458992876,0.965367303969905,0.965345148946934,
            0.965320661816281,0.965297340739469,0.965275185716498,0.965251864639686,
            0.965229709616715,0.965207554593744,0.965185399570773,0.965163244547801,
            0.96514108952483,0.965118934501859,0.96509065022152,0.965062365941182,
            0.96503536730995,0.965009624429007,0.964985107399538,0.964961786322727,
            0.964939631299755,0.964911347019417,0.964884348388185,0.964858605507242,
            0.964834088477774,0.964810767400962,0.96478861237799,0.964761613746758,
            0.964735870865816,0.964711353836347,0.964688032759535,0.964665877736564,
            0.964640134855622,0.964615617826153,0.964592296749341,0.96457014172637,
            0.964545654595717,0.964522333518905,0.964500178495934,0.964476857419122,
            0.964454702396151,0.96443254737318,0.964404292991658,0.964377294360425,
            0.964351551479483,0.964327034450014,0.964303713373202,0.964281558350231,
            0.964254559718999,0.964228816838057,0.964204299808588,0.964180978731776,
            0.964158823708805,0.964133080827862,0.964108563798393,0.964085242721582,
            0.96406308769861,0.964038600567958,0.964015279491146,0.963993124468175,
            0.963969803391363,0.963947648368392,0.96392549334542,0.963898524613005,
            0.963872781732062,0.963848264702593,0.963824943625782,0.96380278860281,
            0.963777045721868,0.963752528692399,0.963729207615587,0.963707052592616,
            0.963682565461964,0.963659244385152,0.963637089362181,0.963613768285369,
            0.963591613262397,0.963569458239426,0.9635437452573,0.963519228227831,
            0.96349590715102,0.963473752128048,0.963449264997396,0.963425943920584,
            0.963403788897613,0.963380467820801,0.96335831279783,0.963336157774858,
            0.963311670644206,0.963288349567394,0.963266194544423,0.963242873467611,
            0.96322071844464,0.963198563421668,0.963176408398697,0.963154253375726,
            0.963132098352755,0.963109943329783,0.963082944698551,0.963055946067319,
            0.963030203186377,0.963005686156908,0.962982365080096,0.962960210057125,
            0.962933211425892,0.96290746854495,0.962882951515481,0.962859630438669,
            0.962837475415698,0.962811732534756,0.962787215505287,0.962763894428475,
            0.962741739405504,0.962717252274851,0.96269393119804,0.962671776175068,
            0.962648455098256,0.962626300075285,0.962604145052314,0.962577176319898,
            0.962551433438956,0.962526916409487,0.962503595332675,0.962481440309704,
            0.962455697428762,0.962431180399293,0.962407859322481,0.96238570429951,
            0.962361217168857,0.962337896092045,0.962315741069074,0.962292419992262,
            0.962270264969291,0.96224810994632,0.962222396964194,0.962197879934725,
            0.962174558857913,0.962152403834942,0.962127916704289,0.962104595627478,
            0.962082440604506,0.962059119527694,0.962036964504723,0.962014809481752,
            0.961990322351099,0.961967001274288,0.961944846251316,0.961921525174504,
            0.961899370151533,0.961877215128562,0.961855060105591,0.961832905082619,
            0.961810750059648,0.961788595036677,0.961762852155735,0.961737109274792,
            0.961712592245323,0.961689271168512,0.96166711614554,0.961641373264598,
            0.961616856235129,0.961593535158317,0.961571380135346,0.961546893004694,
            0.961523571927882,0.96150141690491,0.961478095828099,0.961455940805127,
            0.961433785782156,0.96140807280003,0.961383555770561,0.961360234693749,
            0.961338079670778,0.961313592540126,0.961290271463314,0.961268116440343,
            0.961244795363531,0.961222640340559,0.961200485317588,0.961175998186936,
            0.961152677110124,0.961130522087153,0.961107201010341,0.96108504598737,
            0.961062890964398,0.961040735941427,0.961018580918456,0.960996425895485,
            0.960974270872513,0.960949753843044,0.960925236813575,0.960901915736764,
            0.960879760713792,0.96085527358314,0.960831952506328,0.960809797483357,
            0.960786476406545,0.960764321383574,0.960742166360603,0.96071767922995,
            0.960694358153138,0.960672203130167,0.960648882053355,0.960626727030384,
            0.960604572007413,0.960582416984441,0.96056026196147,0.960538106938499,
            0.960515951915528,0.960492630838716,0.960469309761904,0.960447154738932,
            0.960423833662121,0.960401678639149,0.960379523616178,0.960357368593207,
            0.960335213570236,0.960313058547264,0.960290903524293,0.960268748501322,
            0.960246593478351,0.960224438455379,0.960202283432408,0.960172683604147,
            0.960144399323808,0.960117400692576,0.960091657811634,0.960067140782165,
            0.960043819705353,0.960021664682382,0.959992064854121,0.959963780573782,
            0.95993678194255,0.959911039061608,0.959886522032139,0.959863200955327,
            0.959841045932356,0.959812761652017,0.959785763020785,0.959760020139843,
            0.959735503110374,0.959712182033562,0.959690027010591,0.959663028379359,
            0.959637285498416,0.959612768468947,0.959589447392136,0.959567292369164,
            0.959541549488222,0.959517032458753,0.959493711381941,0.95947155635897,
            0.959447039329501,0.959423718252689,0.959401563229718,0.959378242152906,
            0.959356087129935,0.959333932106964,0.959304362177519,0.95927607789718,
            0.959249079265948,0.959223336385006,0.959198819355537,0.959175498278725,
            0.959153343255754,0.959125058975415,0.959098060344183,0.959072317463241,
            0.959047800433772,0.95902447935696,0.959002324333989,0.958975325702757,
            0.958949582821814,0.958925065792346,0.958901744715534,0.958879589692562,
            0.95885384681162,0.958829329782151,0.958806008705339,0.958783853682368,
            0.958759336652899,0.958736015576087,0.958713860553116,0.958690539476304,
            0.958668384453333,0.958646229430362,0.95861797504884,0.958590976417607,
            0.958565233536665,0.958540716507196,0.958517395430385,0.958495240407413,
            0.958468241776181,0.958442498895239,0.95841798186577,0.958394660788958,
            0.958372505765987,0.958346762885044,0.958322245855576,0.958298924778764,
            0.958276769755792,0.958252252726324,0.958228931649512,0.95820677662654,
            0.958183455549729,0.958161300526757,0.958139145503786,0.95811217677137,
            0.958086433890428,0.958061916860959,0.958038595784147,0.958016440761176,
            0.957990697880234,0.957966180850765,0.957942859773953,0.957920704750982,
            0.957896187721513,0.957872866644701,0.95785071162173,0.957827390544918,
            0.957805235521947,0.957783080498975,0.957757367516849,0.957732850487381,
            0.957709529410569,0.957687374387598,0.957662857358129,0.957639536281317,
            0.957617381258346,0.957594060181534,0.957571905158562,0.957549750135591,
            0.957525263004939,0.957501941928127,0.957479786905156,0.957456465828344,
            0.957434310805372,0.957412155782401,0.957388834705589,0.957366679682618,
            0.957344524659647,0.957322369636676,0.957294085356337,0.957265801075999,
            0.957238802444766,0.957213059563824,0.957188542534355,0.957165221457543,
            0.957143066434572,0.957114782154234,0.957087783523002,0.957062040642059,
            0.95703752361259,0.957014202535778,0.956992047512807,0.956965048881575,
            0.956939306000633,0.956914788971164,0.956891467894352,0.956869312871381,
            0.956843569990438,0.956819052960969,0.956795731884158,0.956773576861186,
            0.956749059831718,0.956725738754906,0.956703583731934,0.956680262655123,
            0.956658107632151,0.95663595260918,0.956607698227658,0.956580699596426,
            0.956554956715483,0.956530439686015,0.956507118609203,0.956484963586231,
            0.956457964954999,0.956432222074057,0.956407705044588,0.956384383967776,
            0.956362228944805,0.956336486063863,0.956311969034394,0.956288647957582,
            0.956266492934611,0.956241975905142,0.95621865482833,0.956196499805359,
            0.956173178728547,0.956151023705576,0.956128868682604,0.956101899950189,
            0.956076157069246,0.956051640039777,0.956028318962966,0.956006163939994,
            0.955980421059052,0.955955904029583,0.955932582952771,0.9559104279298,
            0.955885910900331,0.955862589823519,0.955840434800548,0.955817113723736,
            0.955794958700765,0.955772803677794,0.955747090695668,0.955722573666199,
            0.955699252589387,0.955677097566416,0.955652580536947,0.955629259460135,
            0.955607104437164,0.955583783360352,0.955561628337381,0.955539473314409,
            0.955514986183757,0.955491665106945,0.955469510083974,0.955446189007162,
            0.955424033984191,0.955401878961219,0.955378557884408,0.955356402861436,
            0.955334247838465,0.955312092815494,0.955285094184262,0.955258095553029,
            0.955232352672087,0.955207835642618,0.955184514565806,0.955162359542835,
            0.955135360911603,0.955109618030661,0.955085101001192,0.95506177992438,
            0.955039624901409,0.955013882020466,0.954989364990998,0.954966043914186,
            0.954943888891214,0.954919371861745,0.954896050784934,0.954873895761962,
            0.954850574685151,0.954828419662179,0.954806264639208,0.954779295906792,
            0.95475355302585,0.954729035996381,0.954705714919569,0.954683559896598,
            0.954657817015656,0.954633299986187,0.954609978909375,0.954587823886404,
            0.954563306856935,0.954539985780123,0.954517830757152,0.95449450968034,
            0.954472354657369,0.954450199634397,0.954424486652271,0.954399969622802,
            0.954376648545991,0.954354493523019,0.954329976493551,0.954306655416739,
            0.954284500393767,0.954261179316956,0.954239024293984,0.954216869271013,
            0.954192382140361,0.954169061063549,0.954146906040578,0.954123584963766,
            0.954101429940794,0.954079274917823,0.954055953841011,0.95403379881804,
            0.954011643795069,0.953989488772097,0.953963745891155,0.953938003010213,
            0.953913485980744,0.953890164903932,0.953868009880961,0.953842267000019,
            0.95381774997055,0.953794428893738,0.953772273870767,0.953747756841298,
            0.953724435764486,0.953702280741515,0.953678959664703,0.953656804641731,
            0.95363464961876,0.953608936636634,0.953584419607165,0.953561098530354,
            0.953538943507382,0.953514426477913,0.953491105401102,0.95346895037813,
            0.953445629301318,0.953423474278347,0.953401319255376,0.953376832124723,
            0.953353511047912,0.95333135602494,0.953308034948129,0.953285879925157,
            0.953263724902186,0.953240403825374,0.953218248802403,0.953196093779432,
            0.95317393875646,0.953149421726991,0.953124904697523,0.953101583620711,
            0.95307942859774,0.953054911568271,0.953031590491459,0.953009435468488,
            0.952986114391676,0.952963959368704,0.952941804345733,0.952917317215081,
            0.952893996138269,0.952871841115298,0.952848520038486,0.952826365015515,
            0.952804209992543,0.952780888915731,0.95275873389276,0.952736578869789,
            0.952714423846818,0.952691102770006,0.952667781693194,0.952645626670223,
            0.952622305593411,0.95260015057044,0.952577995547468,0.952554674470656,
            0.952532519447685,0.952510364424714,0.952488209401743,0.952466054378771,
            0.9524438993558,0.952421744332829,0.952399589309858,0.952377434286886,
            0.952349150006548,0.952322151375316,0.952296408494373,0.952271891464904,
            0.952248570388093,0.952226415365121,0.952198131084783,0.952171132453551,
            0.952145389572608,0.952120872543139,0.952097551466328,0.952075396443356,
            0.952048397812124,0.952022654931182,0.951998137901713,0.951974816824901,
            0.95195266180193,0.951926918920988,0.951902401891519,0.951879080814707,
            0.951856925791736,0.951832408762267,0.951809087685455,0.951786932662484,
            0.951763611585672,0.9517414565627,0.951719301539729,0.951691047158207,
            0.951664048526975,0.951638305646033,0.951613788616564,0.951590467539752,
            0.951568312516781,0.951541313885549,0.951515571004606,0.951491053975137,
            0.951467732898326,0.951445577875354,0.951419834994412,0.951395317964943,
            0.951371996888131,0.95134984186516,0.951325324835691,0.951302003758879,
            0.951279848735908,0.951256527659096,0.951234372636125,0.951212217613154,
            0.951185248880738,0.951159505999795,0.951134988970327,0.951111667893515,
            0.951089512870544,0.951063769989601,0.951039252960132,0.95101593188332,
            0.950993776860349,0.95096925983088,0.950945938754069,0.950923783731097,
            0.950900462654285,0.950878307631314,0.950856152608343,0.950830439626217,
            0.950805922596748,0.950782601519936,0.950760446496965,0.950735929467496,
            0.950712608390684,0.950690453367713,0.950667132290901,0.95064497726793,
            0.950622822244959,0.950598335114306,0.950575014037494,0.950552859014523,
            0.950529537937711,0.95050738291474,0.950485227891769,0.950461906814957,
            0.950439751791986,0.950417596769014,0.950395441746043,0.950368443114811,
            0.950341444483579,0.950315701602636,0.950291184573168,0.950267863496356,
            0.950245708473384,0.950218709842152,0.95019296696121,0.950168449931741,
            0.950145128854929,0.950122973831958,0.950097230951016,0.950072713921547,
            0.950049392844735,0.950027237821764,0.950002720792295,0.949979399715483,
            0.949957244692512,0.9499339236157,0.949911768592729,0.949889613569757,
            0.949862644837342,0.949836901956399,0.94981238492693,0.949789063850118,
            0.949766908827147,0.949741165946205,0.949716648916736,0.949693327839924,
            0.949671172816953,0.949646655787484,0.949623334710672,0.949601179687701,
            0.949577858610889,0.949555703587918,0.949533548564947,0.949507835582821,
            0.949483318553352,0.94945999747654,0.949437842453569,0.9494133254241,
            0.949390004347288,0.949367849324317,0.949344528247505,0.949322373224534,
            0.949300218201562,0.94927573107091,0.949252409994098,0.949230254971127,
            0.949206933894315,0.949184778871344,0.949162623848372,0.94913930277156,
            0.949117147748589,0.949094992725618,0.949072837702647,0.949047094821704,
            0.949021351940762,0.948996834911293,0.948973513834481,0.94895135881151,
            0.948925615930568,0.948901098901099,0.948877777824287,0.948855622801316,
            0.948831105771847,0.948807784695035,0.948785629672064,0.948762308595252,
            0.948740153572281,0.948717998549309,0.948692285567184,0.948667768537715,
            0.948644447460903,0.948622292437932,0.948597775408463,0.948574454331651,
            0.94855229930868,0.948528978231868,0.948506823208896,0.948484668185925,
            0.948460181055273,0.948436859978461,0.94841470495549,0.948391383878678,
            0.948369228855707,0.948347073832735,0.948323752755923,0.948301597732952,
            0.948279442709981,0.94825728768701,0.948232770657541,0.948208253628072,
            0.94818493255126,0.948162777528289,0.94813826049882,0.948114939422008,
            0.948092784399037,0.948069463322225,0.948047308299254,0.948025153276282,
            0.94800066614563,0.947977345068818,0.947955190045847,0.947931868969035,
            0.947909713946064,0.947887558923093,0.947864237846281,0.947842082823309,
            0.947819927800338,0.947797772777367,0.947774451700555,0.947751130623743,
            0.947728975600772,0.94770565452396,0.947683499500989,0.947661344478018,
            0.947638023401206,0.947615868378234,0.947593713355263,0.947571558332292,
            0.947549403309321,0.947527248286349,0.947505093263378,0.947482938240407,
            0.947460783217436,0.947433784586203,0.947408041705261,0.947383524675792,
            0.94736020359898,0.947338048576009,0.947311049944777,0.947285307063835,
            0.947260790034366,0.947237468957554,0.947215313934583,0.94718957105364,
            0.947165054024171,0.94714173294736,0.947119577924388,0.947095060894919,
            0.947071739818108,0.947049584795136,0.947026263718324,0.947004108695353,
            0.946981953672382,0.946954984939966,0.946929242059024,0.946904725029555,
            0.946881403952743,0.946859248929772,0.94683350604883,0.946808989019361,
            0.946785667942549,0.946763512919578,0.946738995890109,0.946715674813297,
            0.946693519790326,0.946670198713514,0.946648043690542,0.946625888667571,
            0.946600175685445,0.946575658655976,0.946552337579165,0.946530182556193,
            0.946505665526724,0.946482344449913,0.946460189426941,0.94643686835013,
            0.946414713327158,0.946392558304187,0.946368071173534,0.946344750096723,
            0.946322595073751,0.94629927399694,0.946277118973968,0.946254963950997,
            0.946231642874185,0.946209487851214,0.946187332828243,0.946165177805271,
            0.946139434924329,0.946113692043387,0.946089175013918,0.946065853937106,
            0.946043698914135,0.946017956033192,0.945993439003724,0.945970117926912,
            0.94594796290394,0.945923445874472,0.94590012479766,0.945877969774689,
            0.945854648697877,0.945832493674905,0.945810338651934,0.945784625669808,
            0.945760108640339,0.945736787563528,0.945714632540556,0.945690115511087,
            0.945666794434275,0.945644639411304,0.945621318334492,0.945599163311521,
            0.94557700828855,0.945552521157897,0.945529200081086,0.945507045058114,
            0.945483723981302,0.945461568958331,0.94543941393536,0.945416092858548,
            0.945393937835577,0.945371782812606,0.945349627789634,0.945325110760165,
            0.945300593730697,0.945277272653885,0.945255117630913,0.945230600601445,
            0.945207279524633,0.945185124501661,0.94516180342485,0.945139648401878,
            0.945117493378907,0.945093006248255,0.945069685171443,0.945047530148472,
            0.94502420907166,0.945002054048688,0.944979899025717,0.944956577948905,
            0.944934422925934,0.944912267902963,0.944890112879992,0.94486679180318,
            0.944843470726368,0.944821315703397,0.944797994626585,0.944775839603613,
            0.944753684580642,0.94473036350383,0.944708208480859,0.944686053457888,
            0.944663898434917,0.944641743411945,0.944619588388974,0.944597433366003,
            0.944575278343032,0.94455312332006,0.944527380439118,0.944502863409649,
            0.944479542332837,0.944457387309866,0.944431644428924,0.944407127399455,
            0.944383806322643,0.944361651299672,0.944337134270203,0.944313813193391,
            0.94429165817042,0.944268337093608,0.944246182070637,0.944224027047665,
            0.944198314065539,0.944173797036071,0.944150475959259,0.944128320936287,
            0.944103803906819,0.944080482830007,0.944058327807035,0.944035006730224,
            0.944012851707252,0.943990696684281,0.943966209553629,0.943942888476817,
            0.943920733453846,0.943897412377034,0.943875257354062,0.943853102331091,
            0.943829781254279,0.943807626231308,0.943785471208337,0.943763316185365,
            0.943738799155897,0.943714282126428,0.943690961049616,0.943668806026645,
            0.943644288997176,0.943620967920364,0.943598812897393,0.943575491820581,
            0.94355333679761,0.943531181774638,0.943506694643986,0.943483373567174,
            0.943461218544203,0.943437897467391,0.94341574244442,0.943393587421448,
            0.943370266344636,0.943348111321665,0.943325956298694,0.943303801275723,
            0.943280480198911,0.943257159122099,0.943235004099128,0.943211683022316,
            0.943189527999345,0.943167372976373,0.943144051899562,0.94312189687659,
            0.943099741853619,0.943077586830648,0.943055431807676,0.943033276784705,
            0.943011121761734,0.942988966738763,0.942966811715791,0.942942294686323,
            0.942918973609511,0.942896818586539,0.942872301557071,0.942848980480259,
            0.942826825457287,0.942803504380476,0.942781349357504,0.942759194334533,
            0.942734707203881,0.942711386127069,0.942689231104098,0.942665910027286,
            0.942643755004314,0.942621599981343,0.942598278904531,0.94257612388156,
            0.942553968858589,0.942531813835617,0.942508492758806,0.942485171681994,
            0.942463016659023,0.942439695582211,0.942417540559239,0.942395385536268,
            0.942372064459456,0.942349909436485,0.942327754413514,0.942305599390542,
            0.942283444367571,0.9422612893446,0.942239134321629,0.942216979298657,
            0.942194824275686,0.942171503198874,0.942149348175903,0.942126027099091,
            0.94210387207612,0.942081717053149,0.942058395976337,0.942036240953366,
            0.942014085930394,0.941991930907423,0.941969775884452,0.941947620861481,
            0.941925465838509,0.941903310815538,0.941881155792567,0.941859000769596,
            0.941836845746624,0.941814690723653,0.941792535700682,0.936201606523204,
            0.931690174112768,0.927178741702331,0.922667309291894,0.918155876881458,
            0.913644444471021,0.909133012060585,0.904621579650148,0.900110147239711,
            0.895598714829275,0.895265881204827,0.894993562784824,0.894781759569266,
            0.894622907157597,0.894509441149263,0.894433797143706,0.894388410740372,
            0.894365717538706,0.89435815313815,0.89435815313815,0.89435815313815,
            0.894085834718147,0.893874031502589,0.89371517909092,0.893601713082586,
            0.893526069077029,0.893480682673696,0.893457989472029,0.893450425071473,
            0.893450425071473,0.893450425071473,0.893238621855915,0.893079769444247,
            0.892966303435912,0.892890659430356,0.892845273027022,0.892822579825355,
            0.892815015424799,0.892815015424799,0.892815015424799,0.892656163013131,
            0.892542697004796,0.89246705299924,0.892421666595906,0.892398973394239,
            0.892391408993684,0.892391408993684,0.892391408993684,0.892277942985349,
            0.892202298979793,0.892156912576459,0.892134219374792,0.892126654974236,
            0.892126654974236,0.892126654974236,0.89205101096868,0.892005624565346,
            0.891982931363679,0.891975366963123,0.891975366963123,0.891975366963123,
            0.89192998055979,0.891907287358123,0.891899722957567,0.891899722957567,
            0.891899722957567,0.8918770297559,0.891869465355344,0.891869465355344,
            0.891869465355344,0.891869465355344,0.891869465355344,0.891869465355344,
            0.891869465355344,0.891869465355344,0.891869465355344,0.891536631730896,
            0.891264313310893,0.891052510095335,0.890893657683667,0.890780191675332,
            0.890704547669776,0.890659161266442,0.890636468064775,0.89062890366422,
            0.89062890366422,0.89062890366422,0.890364149644772,0.890152346429214,
            0.889993494017546,0.889880028009211,0.889804384003655,0.889758997600321,
            0.889736304398654,0.889728739998098,0.889728739998098,0.889728739998098,
            0.889516936782541,0.889358084370872,0.889244618362538,0.889168974356981,
            0.889123587953647,0.88910089475198,0.889093330351425,0.889093330351425,
            0.889093330351425,0.888934477939756,0.888821011931422,0.888745367925865,
            0.888699981522531,0.888677288320865,0.888669723920309,0.888669723920309,
            0.888669723920309,0.888556257911974,0.888480613906418,0.888435227503084,
            0.888412534301417,0.888404969900861,0.888404969900861,0.888404969900861,
            0.888329325895305,0.888283939491971,0.888261246290304,0.888253681889749,
            0.888253681889749,0.888253681889749,0.888208295486415,0.888185602284748,
            0.888178037884192,0.888178037884192,0.888178037884192,0.888155344682525,
            0.88814778028197,0.88814778028197,0.88814778028197,0.888140215881414,
            0.888140215881414,0.888140215881414,0.888140215881414,0.888140215881414,
            0.888140215881414,0.887807382256966,0.887535063836963,0.887323260621405,
            0.887164408209737,0.887050942201402,0.886975298195846,0.886929911792512,
            0.886907218590845,0.886899654190289,0.886899654190289,0.886899654190289,
            0.886634900170842,0.886423096955284,0.886264244543616,0.886150778535281,
            0.886075134529725,0.886029748126391,0.886007054924724,0.885999490524168,
            0.885999490524168,0.885999490524168,0.885795251709166,0.885636399297497,
            0.885522933289163,0.885447289283606,0.885401902880273,0.885379209678606,
            0.88537164527805,0.88537164527805,0.88537164527805,0.885212792866382,
            0.885099326858047,0.885023682852491,0.884978296449157,0.88495560324749,
            0.884948038846934,0.884948038846934,0.884948038846934,0.8848345728386,
            0.884758928833043,0.884713542429709,0.884690849228042,0.884683284827487,
            0.884683284827487,0.884683284827487,0.88460764082193,0.884562254418597,
            0.88453956121693,0.884531996816374,0.884531996816374,0.884531996816374,
            0.88448661041304,0.884463917211373,0.884456352810818,0.884456352810818,
            0.884456352810818,0.884433659609151,0.884426095208595,0.884426095208595,
            0.884426095208595,0.884418530808039,0.884418530808039,0.884418530808039,
            0.884418530808039,0.884418530808039,0.884418530808039,0.884085697183591,
            0.883813378763588,0.88360157554803,0.883442723136362,0.883329257128027,
            0.883253613122471,0.883208226719137,0.88318553351747,0.883177969116914,
            0.883177969116914,0.883177969116914,0.882913215097467,0.882701411881909,
            0.882542559470241,0.882429093461906,0.88235344945635,0.882308063053016,
            0.882285369851349,0.882277805450793,0.882277805450793,0.882277805450793,
            0.882073566635791,0.881914714224123,0.881801248215788,0.881725604210232,
            0.881680217806898,0.881657524605231,0.881649960204675,0.881649960204675,
            0.881649960204675,0.881498672193563,0.881385206185228,0.881309562179672,
            0.881264175776338,0.881241482574671,0.881233918174115,0.881233918174115,
            0.881233918174115,0.881120452165781,0.881044808160224,0.88099942175689,
            0.880976728555223,0.880969164154668,0.880969164154668,0.880969164154668,
            0.880893520149111,0.880848133745778,0.880825440544111,0.880817876143555,
            0.880817876143555,0.880817876143555,0.880772489740221,0.880749796538554,
            0.880742232137999,0.880742232137999,0.880742232137999,0.880719538936332,
            0.880711974535776,0.880711974535776,0.880711974535776,0.88070441013522,
            0.88070441013522,0.88070441013522,0.88070441013522,0.88070441013522,
            0.88070441013522,0.880371576510772,0.880099258090769,0.879887454875211,
            0.879728602463543,0.879615136455208,0.879539492449652,0.879494106046318,
            0.879471412844651,0.879463848444096,0.879463848444096,0.879463848444096,
            0.879199094424648,0.87898729120909,0.878828438797422,0.878714972789087,
            0.878639328783531,0.878593942380197,0.87857124917853,0.878563684777974,
            0.878563684777974,0.878563684777974,0.878359445962972,0.878200593551304,
            0.878087127542969,0.878011483537413,0.877966097134079,0.877943403932412,
            0.877935839531856,0.877935839531856,0.877935839531856,0.877784551520744,
            0.877671085512409,0.877595441506853,0.877550055103519,0.877527361901852,
            0.877519797501296,0.877519797501296,0.877519797501296,0.877413895893517,
            0.877338251887961,0.877292865484627,0.87727017228296,0.877262607882404,
            0.877262607882404,0.877262607882404,0.877186963876848,0.877141577473514,
            0.877118884271847,0.877111319871292,0.877111319871292,0.877111319871292,
            0.877065933467958,0.877043240266291,0.877035675865735,0.877035675865735,
            0.877035675865735,0.877012982664068,0.877005418263513,0.877005418263513,
            0.877005418263513,0.876997853862957,0.876997853862957,0.876997853862957,
            0.876997853862957,0.876997853862957,0.876997853862957,0.876657455837953,
            0.87638513741795,0.876173334202392,0.876014481790724,0.875901015782389,
            0.875825371776833,0.875779985373499,0.875757292171832,0.875749727771276,
            0.875749727771276,0.875749727771276,0.875484973751829,0.875273170536271,
            0.875114318124603,0.875000852116268,0.874925208110712,0.874879821707378,
            0.874857128505711,0.874849564105155,0.874849564105155,0.874849564105155,
            0.874645325290153,0.874486472878485,0.87437300687015,0.874297362864594,
            0.87425197646126,0.874229283259593,0.874221718859037,0.874221718859037,
            0.874221718859037,0.874070430847924,0.87395696483959,0.873881320834033,
            0.8738359344307,0.873813241229033,0.873805676828477,0.873805676828477,
            0.873805676828477,0.873699775220698,0.873624131215142,0.873578744811808,
            0.873556051610141,0.873548487209585,0.873548487209585,0.873548487209585,
            0.873480407604585,0.873435021201251,0.873412327999584,0.873404763599028,
            0.873404763599028,0.873404763599028,0.873359377195694,0.873336683994027,
            0.873329119593472,0.873329119593472,0.873329119593472,0.873306426391805,
            0.873298861991249,0.873298861991249,0.873298861991249,0.873291297590694,
            0.873291297590694,0.873291297590694,0.873291297590694,0.873291297590694,
            0.873291297590694,0.87295089956569,0.872678581145687,0.872466777930129,
            0.87230792551846,0.872194459510126,0.872118815504569,0.872073429101236,
            0.872050735899569,0.872043171499013,0.872043171499013,0.872043171499013,
            0.87177085307901,0.871559049863452,0.871400197451784,0.871286731443449,
            0.871211087437893,0.871165701034559,0.871143007832892,0.871135443432336,
            0.871135443432336,0.871135443432336,0.870931204617334,0.870772352205666,
            0.870658886197331,0.870583242191775,0.870537855788441,0.870515162586774,
            0.870507598186218,0.870507598186218,0.870507598186218,0.870356310175105,
            0.870242844166771,0.870167200161214,0.870121813757881,0.870099120556214,
            0.870091556155658,0.870091556155658,0.870091556155658,0.869985654547879,
            0.869910010542323,0.869864624138989,0.869841930937322,0.869834366536766,
            0.869834366536766,0.869834366536766,0.869766286931765,0.869720900528432,
            0.869698207326765,0.869690642926209,0.869690642926209,0.869690642926209,
            0.869652820923431,0.869630127721764,0.869622563321208,0.869622563321208,
            0.869622563321208,0.869599870119541,0.869592305718986,0.869592305718986,
            0.869592305718986,0.86958474131843,0.86958474131843,0.86958474131843,
            0.86958474131843,0.86958474131843,0.86958474131843,0.869244343293426,
            0.868972024873423,0.868760221657865,0.868601369246197,0.868487903237862,
            0.868412259232306,0.868366872828972,0.868344179627305,0.86833661522675,
            0.86833661522675,0.86833661522675,0.868064296806747,0.867852493591189,
            0.86769364117952,0.867580175171186,0.867504531165629,0.867459144762295,
            0.867436451560629,0.867428887160073,0.867428887160073,0.867428887160073,
            0.867217083944515,0.867058231532847,0.866944765524512,0.866869121518956,
            0.866823735115622,0.866801041913955,0.866793477513399,0.866793477513399,
            0.866793477513399,0.866642189502286,0.866528723493952,0.866453079488395,
            0.866407693085061,0.866384999883395,0.866377435482839,0.866377435482839,
            0.866377435482839,0.86627153387506,0.866195889869504,0.86615050346617,
            0.866127810264503,0.866120245863947,0.866120245863947,0.866120245863947,
            0.866052166258946,0.866006779855613,0.865984086653946,0.86597652225339,
            0.86597652225339,0.86597652225339,0.865938700250612,0.865916007048945,
            0.865908442648389,0.865908442648389,0.865908442648389,0.865893313847278,
            0.865885749446722,0.865885749446722,0.865885749446722,0.865878185046167,
            0.865878185046167,0.865878185046167,0.865878185046167,0.865878185046167,
            0.865878185046167,0.865537787021163,0.86526546860116,0.865053665385602,
            0.864894812973934,0.864781346965599,0.864705702960043,0.864660316556709,
            0.864637623355042,0.864630058954486,0.864630058954486,0.864630058954486,
            0.864357740534483,0.864145937318925,0.863987084907257,0.863873618898922,
            0.863797974893366,0.863752588490032,0.863729895288365,0.863722330887809,
            0.863722330887809,0.863722330887809,0.863510527672252,0.863351675260583,
            0.863238209252249,0.863162565246692,0.863117178843358,0.863094485641691,
            0.863086921241136,0.863086921241136,0.863086921241136,0.862928068829467,
            0.862814602821133,0.862738958815576,0.862693572412243,0.862670879210576,
            0.86266331481002,0.86266331481002,0.86266331481002,0.862557413202241,
            0.862481769196685,0.862436382793351,0.862413689591684,0.862406125191128,
            0.862406125191128,0.862406125191128,0.862338045586127,0.862292659182794,
            0.862269965981127,0.862262401580571,0.862262401580571,0.862262401580571,
            0.862224579577793,0.862201886376126,0.86219432197557,0.86219432197557,
            0.86219432197557,0.862179193174459,0.862171628773903,0.862171628773903,
            0.862171628773903,0.862171628773903,0.862171628773903,0.862171628773903,
            0.862171628773903,0.862171628773903,0.862171628773903,0.8618312307489,
            0.861558912328897,0.861347109113339,0.86118825670167,0.861074790693336,
            0.860999146687779,0.860953760284445,0.860931067082778,0.860931067082778,
            0.860931067082778,0.860931067082778,0.860658748662775,0.860446945447218,
            0.860288093035549,0.860174627027214,0.860098983021658,0.860053596618324,
            0.860030903416657,0.860023339016102,0.860023339016102,0.860023339016102,
            0.859811535800544,0.859652683388875,0.859539217380541,0.859463573374984,
            0.859418186971651,0.859395493769984,0.859387929369428,0.859387929369428,
            0.859387929369428,0.85922907695776,0.859115610949425,0.859039966943869,
            0.858994580540535,0.858971887338868,0.858964322938312,0.858964322938312,
            0.858964322938312,0.858850856929978,0.858775212924421,0.858729826521087,
            0.85870713331942,0.858699568918865,0.858699568918865,0.858699568918865,
            0.858631489313864,0.85858610291053,0.858563409708863,0.858555845308308,
            0.858555845308308,0.858555845308308,0.858518023305529,0.858495330103862,
            0.858487765703307,0.858487765703307,0.858487765703307,0.858472636902196,
            0.85846507250164,0.85846507250164,0.85846507250164,0.85846507250164,
            0.85846507250164,0.85846507250164,0.85846507250164,0.85846507250164,
            0.85846507250164,0.858124674476636,0.857852356056633,0.857640552841075,
            0.857481700429407,0.857368234421072,0.857292590415516,0.857247204012182,
            0.857224510810515,0.857224510810515,0.857224510810515,0.857224510810515,
            0.856952192390512,0.856740389174954,0.856581536763286,0.856468070754951,
            0.856392426749395,0.856347040346061,0.856324347144394,0.856316782743838,
            0.856316782743838,0.856316782743838,0.85610497952828,0.855946127116612,
            0.855832661108277,0.855757017102721,0.855711630699387,0.85568893749772,
            0.855681373097165,0.855681373097165,0.855681373097165,0.855522520685496,
            0.855409054677162,0.855333410671605,0.855288024268271,0.855265331066604,
            0.855257766666049,0.855257766666049,0.855257766666049,0.855144300657714,
            0.855068656652158,0.855023270248824,0.855000577047157,0.854993012646601,
            0.854993012646601,0.854993012646601,0.854917368641045,0.854871982237711,
            0.854849289036044,0.854841724635489,0.854841724635489,0.854841724635489,
            0.85480390263271,0.854781209431043,0.854773645030488,0.854773645030488,
            0.854773645030488,0.854758516229377,0.854750951828821,0.854750951828821,
            0.854750951828821,0.854750951828821,0.854750951828821,0.854750951828821,
            0.854750951828821,0.854750951828821,0.854750951828821,0.854410553803817,
            0.854138235383814,0.853926432168256,0.853767579756588,0.853654113748253,
            0.853578469742697,0.853533083339363,0.853510390137696,0.853510390137696,
            0.853510390137696,0.853510390137696,0.853238071717693,0.853026268502135,
            0.852867416090467,0.852753950082132,0.852678306076576,0.852632919673242,
            0.852610226471575,0.852602662071019,0.852602662071019,0.852602662071019,
            0.852390858855461,0.852232006443793,0.852118540435458,0.852042896429902,
            0.851997510026568,0.851974816824901,0.851967252424346,0.851967252424346,
            0.851967252424346,0.851808400012677,0.851694934004342,0.851619289998786,
            0.851573903595452,0.851551210393785,0.85154364599323,0.85154364599323,
            0.85154364599323,0.851430179984895,0.851354535979339,0.851309149576005,
            0.851286456374338,0.851278891973782,0.851278891973782,0.851278891973782,
            0.851203247968226,0.851157861564892,0.851135168363225,0.85112760396267,
            0.85112760396267,0.85112760396267,0.851082217559336,0.851059524357669,
            0.851051959957113,0.851051959957113,0.851051959957113,0.851036831156002,
            0.851029266755446,0.851029266755446,0.851029266755446,0.851029266755446,
            0.851029266755446,0.851029266755446,0.851029266755446,0.851029266755446,
            0.851029266755446,0.850688868730442,0.850416550310439,0.850204747094881,
            0.850045894683213,0.849932428674879,0.849856784669322,0.849811398265988,
            0.849788705064321,0.849788705064321,0.849788705064321,0.849788705064321,
            0.849516386644318,0.84930458342876,0.849145731017092,0.849032265008757,
            0.848956621003201,0.848911234599867,0.8488885413982,0.848880976997645,
            0.848880976997645,0.848880976997645,0.848669173782087,0.848510321370418,
            0.848396855362084,0.848321211356527,0.848275824953193,0.848253131751527,
            0.848245567350971,0.848245567350971,0.848245567350971,0.848086714939302,
            0.847973248930968,0.847897604925411,0.847852218522078,0.847829525320411,
            0.847821960919855,0.847821960919855,0.847821960919855,0.84770849491152,
            0.847632850905964,0.84758746450263,0.847564771300963,0.847557206900408,
            0.847557206900408,0.847557206900408,0.847481562894851,0.847436176491517,
            0.84741348328985,0.847405918889295,0.847405918889295,0.847405918889295,
            0.847360532485961,0.847337839284294,0.847330274883738,0.847330274883738,
            0.847330274883738,0.847307581682072,0.847300017281516,0.847300017281516,
            0.847300017281516,0.847300017281516,0.847300017281516,0.847300017281516,
            0.847300017281516,0.847300017281516,0.847300017281516,0.846424938722376,
            0.845698397483237,0.8451203935641,0.844673974336052,0.844342187170179,
            0.844108079437567,0.843954698509305,0.843865091756478,0.843822306550173,
            0.843809390261477,0.843809390261477,0.842998893145816,0.842272351906677,
            0.841694347987541,0.841247928759492,0.840916141593619,0.840682033861008,
            0.840528652932745,0.840439046179918,0.840396260973613,0.840383344684917,
            0.840383344684917,0.839579305713604,0.838910887773597,0.83833288385446,
            0.837886464626411,0.837554677460538,0.837320569727927,0.837167188799664,
            0.837077582046837,0.837034796840532,0.837021880551836,0.837021880551836,
            0.836224299724871,0.835562339929212,0.835036001164858,0.834589581936809,
            0.834257794770936,0.834023687038325,0.833870306110062,0.833780699357235,
            0.83373791415093,0.833724997862235,0.833724997862235,0.832916922550704,
            0.832261420899392,0.831741540279387,0.831340328061773,0.8310085408959,
            0.830774433163289,0.830621052235026,0.830531445482199,0.830488660275894,
            0.830475743987198,0.830475743987198,0.829674126820016,0.829025083313052,
            0.828511660837394,0.828116906764129,0.827823868464343,0.827589760731732,
            0.827436379803469,0.827346773050642,0.827303987844337,0.827291071555641,
            0.827291071555641,0.826495912532807,0.825853327170191,0.825346362838881,
            0.824958066909963,0.824671486754525,0.824469669743654,0.824316288815391,
            0.824226682062564,0.824183896856259,0.824170980567563,0.824170980567563,
            0.823382279689076,0.822746152470808,0.822245646283846,0.821863808499277,
            0.821583686488187,0.821388327621663,0.821260779270792,0.821171172517965,
            0.82112838731166,0.821115471022964,0.821115471022964,0.820333228288825,
            0.819703559214905,0.819209511172291,0.818834131532069,0.818560467665327,
            0.818371566943151,0.818250476736628,0.818180244416845,0.818154411839453,
            0.818141495550757,0.818141495550757,0.817365710960966,0.816742500031394,
            0.816254910133127,0.815885988637254,0.81561878291486,0.815436340337031,
            0.815321708274856,0.815257934099421,0.815245017810725,0.815232101522029,
            0.815232101522029,0.814462775076586,0.813846022291362,0.813364890537443,
            0.813002427185917,0.812741679607871,0.812565695174391,0.812457521256564,
            0.812400205225476,0.812393747081128,0.81238728893678,0.81238728893678,
            0.811624420635685,0.811014125994808,0.810539452385238,0.81018344717806,
            0.809929157744362,0.809759631455229,0.80965791568175,0.80960705779501,
            0.80960705779501,0.80960705779501,0.80960705779501,0.808796560679349,
            0.808086972069124,0.807508968149987,0.807062548921938,0.806730761756065,
            0.806496654023454,0.806343273095191,0.806253666342364,0.806210881136059,
            0.806197964847364,0.806197964847364,0.80539392587605,0.804742460564956,
            0.804164456645819,0.803718037417771,0.803386250251898,0.803152142519286,
            0.802998761591024,0.802909154838197,0.802866369631892,0.802853453343196,
            0.802853453343196,0.802055872516231,0.801410865349484,0.800884526585131,
            0.800438107357082,0.800106320191209,0.799872212458598,0.799718831530335,
            0.799629224777508,0.799586439571203,0.799573523282507,0.799573523282507,
            0.798765447970977,0.798126898948578,0.797607018328572,0.797205806110959,
            0.796874018945086,0.796639911212475,0.796486530284212,0.796396923531385,
            0.79635413832508,0.796341222036384,0.796341222036384,0.795539604869202,
            0.794890561362238,0.79437713888658,0.793982384813315,0.793689346513529,
            0.793455238780918,0.793301857852655,0.793212251099828,0.793169465893523,
            0.793156549604827,0.793156549604827,0.792361390581992,0.791718805219377,
            0.791211840888067,0.790823544959149,0.790536964803711,0.790335147792839,
            0.790181766864577,0.79009216011175,0.790049374905445,0.790036458616749,
            0.790036458616749,0.789247757738262,0.788611630519994,0.788111124333032,
            0.787729286548463,0.787449164537373,0.787253805670849,0.787126257319978,
            0.787036650567151,0.786993865360846,0.78698094907215,0.78698094907215,
            0.786198706338011,0.785569037264091,0.785074989221477,0.784699609581255,
            0.784425945714513,0.784237044992337,0.784115954785814,0.78404572246603,
            0.784002937259726,0.78399002097103,0.78399002097103,0.783214236381239,
            0.782591025451666,0.7821034355534,0.781734514057526,0.781467308335132,
            0.781284865757304,0.781170233695129,0.781106459519693,0.781076590602084,
            0.781063674313389,0.781063674313389,0.780294347867945,0.779677595082721,
            0.779196463328803,0.778833999977277,0.77857325239923,0.77839726796575,
            0.778289094047923,0.778231778016835,0.778208367243574,0.778201909099226,
            0.778201909099226,0.777439040798131,0.776828746157255,0.776354072547684,
            0.775998067340506,0.775743777906808,0.775574251617675,0.775472535844196,
            0.775421677957456,0.775404725328543,0.775404725328543,0.775404725328543,
            0.77460068635723,0.773949221046136,0.773388169755912,0.772941750527864,
            0.77260996336199,0.772375855629379,0.772222474701116,0.772132867948289,
            0.772090082741985,0.772077166453289,0.772077166453289,0.771279585626323,
            0.770634578459577,0.770125192324137,0.769678773096088,0.769346985930215,
            0.769112878197604,0.768959497269341,0.768869890516514,0.768827105310209,
            0.768814189021513,0.768814189021513,0.768006113709983,0.767367564687584,
            0.766864636696492,0.766463424478879,0.766131637313005,0.765897529580394,
            0.765744148652131,0.765654541899304,0.765611756693,0.765598840404304,
            0.765598840404304,0.764797223237121,0.764148179730157,0.763651709883413,
            0.763256955810147,0.762963917510361,0.76272980977775,0.762576428849488,
            0.762486822096661,0.762444036890356,0.76243112060166,0.76243112060166,
            0.761635961578825,0.760993376216209,0.760486411884899,0.760098115955982,
            0.759811535800544,0.759609718789672,0.759456337861409,0.759366731108582,
            0.759323945902277,0.759311029613582,0.759311029613582,0.758522328735095,
            0.757886201516827,0.757385695329865,0.757003857545295,0.756723735534205,
            0.756528376667681,0.75640082831681,0.756311221563983,0.756268436357678,
            0.756255520068983,0.756255520068983,0.755473277334843,0.754843608260923,
            0.754349560218309,0.753974180578088,0.753700516711345,0.753511615989169,
            0.753390525782646,0.753320293462863,0.753277508256558,0.753264591967862,
            0.753264591967862,0.752488807378071,0.751865596448499,0.751378006550233,
            0.751009085054359,0.750741879331965,0.750559436754137,0.750444804691962,
            0.750381030516526,0.750351161598917,0.750338245310221,0.750338245310221,
            0.749568918864778,0.748952166079554,0.748471034325635,0.748108570974109,
            0.747847823396063,0.747671838962583,0.747563665044756,0.747506349013668,
            0.747482938240407,0.747476480096059,0.747476480096059,0.746713611794964,
            0.746103317154087,0.745628643544517,0.745272638337339,0.74501834890364,
            0.744848822614508,0.744747106841029,0.744696248954289,0.744679296325376,
            0.744679296325376,0.744679296325376,0.74388171549841,0.743236708331664,
            0.742727322196224,0.742297855597088,0.741966068431215,0.741731960698604,
            0.741578579770341,0.741488973017514,0.741446187811209,0.741433271522513,
            0.741433271522513,0.740625196210983,0.739986647188584,0.739483719197492,
            0.739099459608792,0.738767672442919,0.738533564710307,0.738380183782045,
            0.738290577029218,0.738247791822913,0.738234875534217,0.738234875534217,
            0.737433258367034,0.736784214860071,0.736287745013326,0.735909943568974,
            0.735616905269188,0.735382797536577,0.735229416608314,0.735139809855487,
            0.735097024649182,0.735084108360486,0.735084108360486,0.734288949337652,
            0.733646363975036,0.733139399643726,0.732768056343722,0.732481476188284,
            0.732279659177412,0.732126278249149,0.732036671496322,0.731993886290017,
            0.731980970001322,0.731980970001322,0.731192269122835,0.730556141904567,
            0.730055635717604,0.729673797933035,0.729393675921945,0.729198317055421,
            0.72907076870455,0.728981161951723,0.728938376745418,0.728925460456722,
            0.728925460456722,0.728143217722583,0.727513548648663,0.727019500606049,
            0.726644120965827,0.726370457099085,0.726181556376909,0.726060466170386,
            0.725990233850603,0.725947448644298,0.725934532355602,0.725934532355602,
            0.725158747765811,0.724535536836239,0.724047946937972,0.723679025442099,
            0.723411819719705,0.723229377141877,0.723114745079701,0.723050970904266,
            0.723021101986657,0.723008185697961,0.723008185697961,0.722238859252518,
            0.721622106467293,0.721140974713375,0.720778511361849,0.720517763783803,
            0.720341779350323,0.720233605432495,0.720176289401408,0.720152878628147,
            0.720146420483799,0.720146420483799,0.719383552182703,0.718773257541827,
            0.718298583932256,0.717942578725079,0.71768828929138,0.717518763002248,
            0.717417047228768,0.717366189342029,0.717349236713115,0.717349236713115,
            0.717349236713115,0.716541161401585,0.715902612379186,0.715399684388094,
            0.715015424799394,0.714700590262434,0.714466482529823,0.71431310160156,
            0.714223494848733,0.714180709642428,0.714167793353732,0.714167793353732,
            0.71336617618655,0.712717132679586,0.712220662832841,0.711842861388489,
            0.711566775717616,0.711332667985005,0.711179287056743,0.711089680303916,
            0.711046895097611,0.711033978808915,0.711033978808915,0.71023881978608,
            0.709596234423464,0.709089270092154,0.70871792679215,0.708448299265625,
            0.708246482254754,0.708093101326491,0.708003494573664,0.707960709367359,
            0.707947793078663,0.707947793078663,0.707159092200176,0.706522964981908,
            0.706022458794946,0.705640621010377,0.7053774516282,0.705182092761676,
            0.705054544410805,0.704964937657978,0.704922152451673,0.704909236162977,
            0.704909236162977,0.704126993428838,0.703497324354918,0.703003276312304,
            0.702627896672082,0.70235423280534,0.702165332083164,0.702044241876641,
            0.701974009556858,0.701931224350553,0.701918308061857,0.701918308061857,
            0.701142523472066,0.700519312542494,0.700031722644227,0.699662801148354,
            0.699395595425959,0.699213152848131,0.699098520785956,0.699034746610521,
            0.699004877692912,0.698991961404216,0.698991961404216,0.698222634958773,
            0.697605882173548,0.69712475041963,0.696762287068104,0.696501539490058,
            0.696325555056578,0.69621738113875,0.696160065107663,0.696136654334402,
            0.696130196190054,0.696130196190054,0.695367327888958,0.694757033248082,
            0.694282359638511,0.693926354431333,0.693672064997635,0.693502538708503,
            0.693400822935023,0.693349965048284,0.69333301241937,0.69333301241937,
            0.69333301241937,0.692531395252188,0.691882351745224,0.691385881898479,
            0.691008080454127,0.690731994783255,0.690514839679556,0.690361458751294,
            0.690271851998467,0.690229066792162,0.690216150503466,0.690216150503466,
            0.689420991480631,0.688778406118015,0.688271441786705,0.687900098486701,
            0.687630470960177,0.687445606578218,0.687292225649955,0.687202618897128,
            0.687159833690824,0.687146917402128,0.687146917402128,0.686358216523641,
            0.685722089305373,0.685221583118411,0.684839745333841,0.684576575951664,
            0.684398169714054,0.684270621363183,0.684181014610356,0.684138229404051,
            0.684125313115355,0.684125313115355,0.683343070381216,0.682713401307296,
            0.682219353264682,0.68184397362446,0.681570309757718,0.681398361664455,
            0.681277271457932,0.681207039138149,0.681164253931844,0.681151337643148,
            0.681151337643148,0.680375553053357,0.679752342123785,0.679264752225518,
            0.678895830729645,0.67862862500725,0.678446182429422,0.678331550367247,
            0.678267776191812,0.678237907274203,0.678224990985507,0.678224990985507,
            0.677455664540064,0.676838911754839,0.676357780000921,0.675995316649395,
            0.675734569071349,0.675558584637869,0.675450410720041,0.675393094688954,
            0.675369683915693,0.675363225771345,0.675363225771345,0.674600357470249,
            0.673990062829373,0.673515389219802,0.673159384012624,0.672905094578926,
            0.672735568289794,0.672633852516314,0.672582994629575,0.672566042000661,
            0.672566042000661,0.672566042000661,0.671770882977826,0.671128297615211,
            0.670621333283901,0.670249989983897,0.669980362457372,0.669795498075413,
            0.669659069776064,0.669569463023237,0.669526677816932,0.669513761528236,
            0.669513761528236,0.668725060649749,0.668088933431481,0.667588427244519,
            0.66720658945995,0.666943420077773,0.666765013840162,0.666654418118204,
            0.666564811365377,0.666522026159072,0.666509109870377,0.666509109870377,
            0.665726867136238,0.665097198062317,0.664603150019703,0.664227770379482,
            0.66395410651274,0.663782158419477,0.663678020841867,0.663607788522084,
            0.663565003315779,0.663552087027083,0.663552087027083,0.662776302437292,
            0.66215309150772,0.661665501609453,0.66129658011358,0.661029374391185,
            0.660846931813357,0.660749252380095,0.66068547820466,0.660655609287051,
            0.660642692998355,0.660642692998355,0.659873366552912,0.659256613767687,
            0.658775482013769,0.658413018662243,0.658152271084197,0.657976286650717,
            0.657868112732889,0.657810796701802,0.657787385928541,0.657780927784193,
            0.657780927784193,0.657018059483097,0.656407764842221,0.65593309123265,
            0.655577086025473,0.655322796591774,0.655153270302642,0.655051554529162,
            0.655000696642423,0.654983744013509,0.654983744013509,0.654983744013509,
            0.654195043135022,0.653558915916755,0.653058409729792,0.652676571945223,
            0.652413402563046,0.652234996325435,0.652124400603478,0.652051746479564,
            0.652008961273259,0.651996044984563,0.651996044984563,0.651213802250424,
            0.650584133176504,0.65009008513389,0.649714705493668,0.649441041626926,
            0.649269093533663,0.649164955956054,0.649111676265183,0.649068891058879,
            0.649055974770183,0.649055974770183,0.648280190180392,0.647656979250819,
            0.647169389352553,0.646800467856679,0.646533262134285,0.646350819556457,
            0.646253140123195,0.646206318576673,0.646176449659064,0.646163533370368,
            0.646163533370368,0.645394206924925,0.6447774541397,0.644296322385782,
            0.643933859034256,0.64367311145621,0.64349712702273,0.643388953104902,
            0.643348589702728,0.643325178929467,0.643318720785119,0.643318720785119,
            0.642555852484024,0.641945557843147,0.641470884233577,0.641114879026399,
            0.6408605895927,0.640691063303568,0.640589347530089,0.640538489643349,
            0.640521537014436,0.640521537014436,0.640521537014436,0.639739294280297,
            0.639109625206377,0.638615577163762,0.638240197523541,0.637966533656799,
            0.637794585563536,0.637690447985926,0.637637168295056,0.637611335717664,
            0.637598419428968,0.637598419428968,0.636822634839177,0.636199423909605,
            0.635711834011339,0.635342912515465,0.635075706793071,0.634893264215243,
            0.634795584781981,0.634748763235459,0.634735846946763,0.634722930658067,
            0.634722930658067,0.633953604212624,0.633336851427399,0.632855719673481,
            0.632493256321955,0.632232508743909,0.632056524310429,0.631948350392601,
            0.631907986990427,0.631901528846079,0.631895070701731,0.631895070701731,
            0.631132202400636,0.630521907759759,0.630047234150189,0.629691228943011,
            0.629436939509313,0.62926741322018,0.629165697446701,0.629114839559961,
            0.629114839559961,0.629114839559961,0.629114839559961,0.628356007599083,
            0.627732796669511,0.627245206771245,0.626876285275371,0.626609079552977,
            0.626426636975149,0.626328957541887,0.626282135995365,0.626269219706669,
            0.626256303417973,0.626256303417973,0.625503929601443,0.624887176816219,
            0.6244060450623,0.624043581710774,0.623782834132728,0.623606849699248,
            0.62349867578142,0.623458312379246,0.623451854234898,0.62344539609055,
            0.62344539609055,0.622699480418368,0.622089185777492,0.621614512167921,
            0.621258506960743,0.621004217527045,0.620834691237913,0.620732975464433,
            0.620682117577694,0.620682117577694,0.620682117577694,0.620682117577694,
            0.619929743761163,0.619312990975939,0.618831859222021,0.618469395870495,
            0.618208648292449,0.618032663858968,0.617924489941141,0.617884126538967,
            0.617877668394619,0.617871210250271,0.617871210250271,0.617125294578089,
            0.616514999937212,0.616040326327642,0.615684321120464,0.615430031686766,
            0.615260505397633,0.615158789624154,0.615107931737414,0.615107931737414,
            0.615107931737414,0.615107931737414,0.614362016065232,0.613751721424356,
            0.613277047814785,0.612921042607607,0.612666753173909,0.612497226884777,
            0.612395511111297,0.612344653224557,0.612344653224557,0.612344653224557,
            0.612344653224557,0.611101460437587,0.609858267650617,0.608925873060389,
            0.608259876924512,0.607815879500594,0.607549481046243,0.607416281819068,
            0.607371882076676,0.607371882076676,0.607371882076676,0.606128689289706,
            0.605196294699478,0.604530298563601,0.604086301139683,0.603819902685332,
            0.603686703458157,0.603642303715765,0.603642303715765,0.603642303715765,
            0.602709909125537,0.60204391298966,0.601599915565742,0.601333517111392,
            0.601200317884216,0.601155918141824,0.601155918141824,0.601155918141824,
            0.600489922005947,0.60004592458203,0.599779526127679,0.599646326900503,
            0.599601927158112,0.599601927158112,0.599601927158112,0.599157929734194,
            0.598891531279843,0.598758332052667,0.598713932310276,0.598713932310276,
            0.598713932310276,0.598447533855925,0.598314334628749,0.598269934886358,
            0.598269934886358,0.598269934886358,0.598136735659182,0.59809233591679,
            0.59809233591679,0.59809233591679,0.59809233591679,0.59809233591679,
            0.59809233591679,0.59809233591679,0.59809233591679,0.59809233591679,
            0.596893542872212,0.595961148281984,0.595295152146107,0.594851154722189,
            0.594584756267838,0.594451557040663,0.594407157298271,0.594407157298271,
            0.594407157298271,0.593474762708043,0.592808766572167,0.592364769148249,
            0.592098370693898,0.591965171466722,0.591920771724331,0.591920771724331,
            0.591920771724331,0.591254775588454,0.590810778164536,0.590544379710185,
            0.590411180483009,0.590366780740618,0.590366780740618,0.590366780740618,
            0.5899227833167,0.589656384862349,0.589523185635173,0.589478785892782,
            0.589478785892782,0.589478785892782,0.589212387438431,0.589079188211255,
            0.589034788468864,0.589034788468864,0.589034788468864,0.588901589241688,
            0.588857189499296,0.588857189499296,0.588857189499296,0.588857189499296,
            0.588857189499296,0.588857189499296,0.588857189499296,0.588857189499296,
            0.588857189499296,0.587969194651461,0.587303198515584,0.586859201091666,
            0.586592802637315,0.586459603410139,0.586415203667748,0.586415203667748,
            0.586415203667748,0.585749207531871,0.585305210107953,0.585038811653602,
            0.584905612426426,0.584861212684035,0.584861212684035,0.584861212684035,
            0.584417215260117,0.584150816805766,0.58401761757859,0.583973217836199,
            0.583973217836199,0.583973217836199,0.583706819381848,0.583573620154673,
            0.583529220412281,0.583529220412281,0.583529220412281,0.583396021185105,
            0.583351621442714,0.583351621442714,0.583351621442714,0.583351621442714,
            0.583351621442714,0.583351621442714,0.583351621442714,0.583351621442714,
            0.583351621442714,0.582730025049228,0.58228602762531,0.58201962917096,
            0.581886429943784,0.581842030201392,0.581842030201392,0.581842030201392,
            0.581398032777474,0.581131634323124,0.580998435095948,0.580954035353556,
            0.580954035353556,0.580954035353556,0.580687636899206,0.58055443767203,
            0.580510037929639,0.580510037929639,0.580510037929639,0.580376838702463,
            0.580332438960071,0.580332438960071,0.580332438960071,0.580332438960071,
            0.580332438960071,0.580332438960071,0.580332438960071,0.580332438960071,
            0.580332438960071,0.579932841278545,0.579666442824194,0.579533243597019,
            0.579488843854627,0.579488843854627,0.579488843854627,0.579222445400276,
            0.579089246173101,0.579044846430709,0.579044846430709,0.579044846430709,
            0.578911647203534,0.578867247461142,0.578867247461142,0.578867247461142,
            0.578867247461142,0.578867247461142,0.578867247461142,0.578867247461142,
            0.578867247461142,0.578867247461142,0.578645248749183,0.578512049522008,
            0.578467649779616,0.578467649779616,0.578467649779616,0.57833445055244,
            0.578290050810049,0.578290050810049,0.578290050810049,0.578290050810049,
            0.578290050810049,0.578290050810049,0.578290050810049,0.578290050810049,
            0.578290050810049,0.578201251325265,0.578156851582873,0.578156851582873,
            0.578156851582873,0.578156851582873,0.578156851582873,0.578156851582873,
            0.578156851582873,0.578156851582873,0.578156851582873,0.578156851582873,
            0.578156851582873,0.578156851582873,0.578156851582873,0.578156851582873,
            0.578156851582873,0.578156851582873,0.578156851582873,0.578156851582873,
            0.578156851582873,0.576913658795903,0.575670466008933,0.574738071418705,
            0.574072075282828,0.57362807785891,0.573361679404559,0.573228480177384,
            0.573184080434992,0.573184080434992,0.573184080434992,0.571940887648022,
            0.571008493057794,0.570342496921917,0.569898499497999,0.569632101043648,
            0.569498901816473,0.569454502074081,0.569454502074081,0.569454502074081,
            0.568522107483853,0.567856111347976,0.567412113924058,0.567145715469707,
            0.567012516242532,0.56696811650014,0.56696811650014,0.56696811650014,
            0.566302120364263,0.565858122940345,0.565591724485994,0.565458525258819,
            0.565414125516427,0.565414125516427,0.565414125516427,0.564970128092509,
            0.564703729638159,0.564570530410983,0.564526130668591,0.564526130668591,
            0.564526130668591,0.564259732214241,0.564126532987065,0.564082133244673,
            0.564082133244673,0.564082133244673,0.563948934017498,0.563904534275106,
            0.563904534275106,0.563904534275106,0.563904534275106,0.563904534275106,
            0.563904534275106,0.563904534275106,0.563904534275106,0.563904534275106,
            0.562972139684878,0.562039745094651,0.561373748958774,0.560929751534856,
            0.560663353080505,0.56053015385333,0.560485754110938,0.560485754110938,
            0.560485754110938,0.55955335952071,0.558887363384833,0.558443365960915,
            0.558176967506564,0.558043768279389,0.557999368536997,0.557999368536997,
            0.557999368536997,0.55733337240112,0.556889374977202,0.556622976522851,
            0.556489777295676,0.556445377553284,0.556445377553284,0.556445377553284,
            0.556001380129366,0.555734981675015,0.55560178244784,0.555557382705448,
            0.555557382705448,0.555557382705448,0.555290984251097,0.555157785023922,
            0.55511338528153,0.55511338528153,0.55511338528153,0.554980186054355,
            0.554935786311963,0.554935786311963,0.554935786311963,0.554891386569571,
            0.554891386569571,0.554891386569571,0.554891386569571,0.554891386569571,
            0.554891386569571,0.554003391721735,0.553337395585858,0.55289339816194,
            0.55262699970759,0.552493800480414,0.552449400738022,0.552449400738022,
            0.552449400738022,0.551783404602145,0.551339407178227,0.551073008723877,
            0.550939809496701,0.55089540975431,0.55089540975431,0.55089540975431,
            0.550451412330392,0.550185013876041,0.550051814648865,0.550007414906474,
            0.550007414906474,0.550007414906474,0.549741016452123,0.549607817224947,
            0.549563417482556,0.549563417482556,0.549563417482556,0.54943021825538,
            0.549385818512988,0.549385818512988,0.549385818512988,0.549341418770597,
            0.549341418770597,0.549341418770597,0.549341418770597,0.549341418770597,
            0.549341418770597,0.548719822377111,0.548275824953193,0.548009426498843,
            0.547876227271667,0.547831827529275,0.547831827529275,0.547831827529275,
            0.547387830105357,0.547121431651007,0.546988232423831,0.546943832681439,
            0.546943832681439,0.546943832681439,0.546677434227089,0.546544234999913,
            0.546499835257522,0.546499835257522,0.546499835257522,0.546366636030346,
            0.546322236287954,0.546322236287954,0.546322236287954,0.546277836545563,
            0.546277836545563,0.546277836545563,0.546277836545563,0.546277836545563,
            0.546277836545563,0.545878238864036,0.545611840409686,0.54547864118251,
            0.545434241440118,0.545434241440118,0.545434241440118,0.545167842985768,
            0.545034643758592,0.5449902440162,0.5449902440162,0.5449902440162,
            0.544857044789025,0.544812645046633,0.544812645046633,0.544812645046633,
            0.544768245304241,0.544768245304241,0.544768245304241,0.544768245304241,
            0.544768245304241,0.544768245304241,0.544546246592282,0.544413047365107,
            0.544368647622715,0.544368647622715,0.544368647622715,0.54423544839554,
            0.544191048653148,0.544191048653148,0.544191048653148,0.544146648910756,
            0.544146648910756,0.544146648910756,0.544146648910756,0.544146648910756,
            0.544146648910756,0.544057849425973,0.544013449683581,0.544013449683581,
            0.544013449683581,0.543969049941189,0.543969049941189,0.543969049941189,
            0.543969049941189,0.543969049941189,0.543969049941189,0.543969049941189,
            0.543969049941189,0.543969049941189,0.543969049941189,0.543969049941189,
            0.543969049941189,0.543969049941189,0.543969049941189,0.543969049941189,
            0.543969049941189,0.542725857154219,0.541482664367248,0.540550269777021,
            0.539884273641144,0.539440276217226,0.539173877762875,0.539040678535699,
            0.538996278793308,0.538996278793308,0.538996278793308,0.537797485748729,
            0.536865091158501,0.536199095022624,0.535755097598706,0.535488699144356,
            0.53535549991718,0.535311100174788,0.535311100174788,0.535311100174788,
            0.534378705584561,0.533712709448684,0.533268712024766,0.533002313570415,
            0.53286911434324,0.532824714600848,0.532824714600848,0.532824714600848,
            0.532158718464971,0.531714721041053,0.531448322586702,0.531315123359527,
            0.531270723617135,0.531270723617135,0.531270723617135,0.530826726193217,
            0.530560327738866,0.530427128511691,0.530382728769299,0.530382728769299,
            0.530382728769299,0.530116330314948,0.529983131087773,0.529938731345381,
            0.529938731345381,0.529938731345381,0.529805532118206,0.529761132375814,
            0.529761132375814,0.529761132375814,0.529761132375814,0.529761132375814,
            0.529761132375814,0.529761132375814,0.529761132375814,0.529761132375814,
            0.528828737785586,0.527896343195358,0.527230347059481,0.526786349635563,
            0.526519951181213,0.526386751954037,0.526342352211645,0.526342352211645,
            0.526342352211645,0.525409957621418,0.524743961485541,0.524299964061623,
            0.524033565607272,0.523900366380097,0.523855966637705,0.523855966637705,
            0.523855966637705,0.523189970501828,0.52274597307791,0.522479574623559,
            0.522346375396384,0.522301975653992,0.522301975653992,0.522301975653992,
            0.521857978230074,0.521591579775723,0.521458380548548,0.521413980806156,
            0.521413980806156,0.521413980806156,0.521147582351805,0.52101438312463,
            0.520969983382238,0.520969983382238,0.520969983382238,0.520836784155062,
            0.520792384412671,0.520792384412671,0.520792384412671,0.520747984670279,
            0.520747984670279,0.520747984670279,0.520747984670279,0.520747984670279,
            0.520747984670279,0.520081988534402,0.519415992398525,0.518971994974607,
            0.518705596520256,0.518572397293081,0.518527997550689,0.518527997550689,
            0.518527997550689,0.517862001414812,0.517418003990894,0.517151605536543,
            0.517018406309368,0.516974006566976,0.516974006566976,0.516974006566976,
            0.516530009143058,0.516263610688707,0.516130411461532,0.51608601171914,
            0.51608601171914,0.51608601171914,0.515819613264789,0.515686414037614,
            0.515642014295222,0.515642014295222,0.515642014295222,0.515508815068047,
            0.515464415325655,0.515464415325655,0.515464415325655,0.515420015583263,
            0.515420015583263,0.515420015583263,0.515420015583263,0.515420015583263,
            0.515420015583263,0.514798419189778,0.51435442176586,0.514088023311509,
            0.513954824084334,0.513910424341942,0.513910424341942,0.513910424341942,
            0.513466426918024,0.513200028463673,0.513066829236498,0.513022429494106,
            0.513022429494106,0.513022429494106,0.512756031039755,0.51262283181258,
            0.512578432070188,0.512578432070188,0.512578432070188,0.512445232843013,
            0.512400833100621,0.512400833100621,0.512400833100621,0.512356433358229,
            0.512356433358229,0.512356433358229,0.512356433358229,0.512356433358229,
            0.512356433358229,0.511956835676703,0.511690437222352,0.511557237995177,
            0.511512838252785,0.511512838252785,0.511512838252785,0.511246439798434,
            0.511113240571259,0.511068840828867,0.511068840828867,0.511068840828867,
            0.510935641601692,0.5108912418593,0.5108912418593,0.5108912418593,
            0.510846842116908,0.510846842116908,0.510846842116908,0.510846842116908,
            0.510846842116908,0.510846842116908,0.510624843404949,0.510491644177774,
            0.510447244435382,0.510447244435382,0.510447244435382,0.510314045208206,
            0.510269645465815,0.510269645465815,0.510269645465815,0.510225245723423,
            0.510225245723423,0.510225245723423,0.510225245723423,0.510225245723423,
            0.510225245723423,0.510136446238639,0.510092046496247,0.510092046496247,
            0.510092046496247,0.510047646753856,0.510047646753856,0.510047646753856,
            0.510047646753856,0.510047646753856,0.510047646753856,0.510047646753856,
            0.510047646753856,0.510047646753856,0.510047646753856,0.510047646753856,
            0.510047646753856,0.510047646753856,0.510047646753856,0.510047646753856,
            0.510047646753856,0.508804453966885,0.507561261179915,0.506628866589687,
            0.50596287045381,0.505518873029892,0.505252474575541,0.505119275348366,
            0.505074875605974,0.505074875605974,0.505074875605974,0.503876082561396,
            0.502943687971168,0.502277691835291,0.501833694411373,0.501567295957022,
            0.501434096729847,0.501389696987455,0.501389696987455,0.501389696987455,
            0.500501702139619,0.499835706003742,0.499391708579824,0.499125310125473,
            0.498992110898298,0.498947711155906,0.498947711155906,0.498947711155906,
            0.498281715020029,0.497837717596111,0.49757131914176,0.497438119914585,
            0.497393720172193,0.497393720172193,0.497393720172193,0.496949722748275,
            0.496683324293924,0.496550125066749,0.496505725324357,0.496505725324357,
            0.496505725324357,0.496239326870007,0.496106127642831,0.496061727900439,
            0.496061727900439,0.496061727900439,0.495928528673264,0.495884128930872,
            0.495884128930872,0.495884128930872,0.495884128930872,0.495884128930872,
            0.495884128930872,0.495884128930872,0.495884128930872,0.495884128930872,
            0.494951734340644,0.494019339750417,0.49335334361454,0.492909346190622,
            0.492642947736271,0.492509748509096,0.492465348766704,0.492465348766704,
            0.492465348766704,0.491577353918868,0.490911357782991,0.490467360359073,
            0.490200961904722,0.490067762677547,0.490023362935155,0.490023362935155,
            0.490023362935155,0.489357366799278,0.48891336937536,0.488646970921009,
            0.488513771693834,0.488469371951442,0.488469371951442,0.488469371951442,
            0.488025374527524,0.487758976073173,0.487625776845998,0.487581377103606,
            0.487581377103606,0.487581377103606,0.487314978649255,0.48718177942208,
            0.487137379679688,0.487137379679688,0.487137379679688,0.487004180452513,
            0.486959780710121,0.486959780710121,0.486959780710121,0.486915380967729,
            0.486915380967729,0.486915380967729,0.486915380967729,0.486915380967729,
            0.486915380967729,0.486249384831852,0.485583388695975,0.485139391272057,
            0.484872992817706,0.484739793590531,0.484695393848139,0.484695393848139,
            0.484695393848139,0.484029397712262,0.483585400288344,0.483319001833993,
            0.483185802606818,0.483141402864426,0.483141402864426,0.483141402864426,
            0.482697405440508,0.482431006986157,0.482297807758982,0.48225340801659,
            0.48225340801659,0.48225340801659,0.481987009562239,0.481853810335064,
            0.481809410592672,0.481809410592672,0.481809410592672,0.481676211365497,
            0.481631811623105,0.481631811623105,0.481631811623105,0.481587411880713,
            0.481587411880713,0.481587411880713,0.481587411880713,0.481587411880713,
            0.481587411880713,0.481143414456795,0.480699417032877,0.480433018578527,
            0.480299819351351,0.480255419608959,0.480255419608959,0.480255419608959,
            0.479811422185041,0.479545023730691,0.479411824503515,0.479367424761123,
            0.479367424761123,0.479367424761123,0.479101026306773,0.478967827079597,
            0.478923427337205,0.478923427337205,0.478923427337205,0.47879022811003,
            0.478745828367638,0.478745828367638,0.478745828367638,0.478701428625246,
            0.478701428625246,0.478701428625246,0.478701428625246,0.478701428625246,
            0.478701428625246,0.47830183094372,0.478035432489369,0.477902233262194,
            0.477857833519802,0.477857833519802,0.477857833519802,0.477591435065451,
            0.477458235838276,0.477413836095884,0.477413836095884,0.477413836095884,
            0.477280636868709,0.477236237126317,0.477236237126317,0.477236237126317,
            0.477191837383925,0.477191837383925,0.477191837383925,0.477191837383925,
            0.477191837383925,0.477191837383925,0.476969838671966,0.476836639444791,
            0.476792239702399,0.476792239702399,0.476792239702399,0.476659040475224,
            0.476614640732832,0.476614640732832,0.476614640732832,0.47657024099044,
            0.47657024099044,0.47657024099044,0.47657024099044,0.47657024099044,
            0.47657024099044,0.476481441505657,0.476437041763265,0.476437041763265,
            0.476437041763265,0.476392642020873,0.476392642020873,0.476392642020873,
            0.476392642020873,0.476392642020873,0.476392642020873,0.476392642020873,
            0.476392642020873,0.476392642020873,0.476392642020873,0.476392642020873,
            0.476392642020873,0.476392642020873,0.476392642020873,0.476392642020873,
            0.476392642020873,0.475149449233903,0.473906256446932,0.472973861856705,
            0.472307865720828,0.47186386829691,0.471597469842559,0.471464270615383,
            0.471419870872992,0.471419870872992,0.471419870872992,0.470221077828413,
            0.469288683238185,0.468622687102308,0.46817868967839,0.46791229122404,
            0.467779091996864,0.467734692254472,0.467734692254472,0.467734692254472,
            0.466846697406636,0.46618070127076,0.465736703846842,0.465470305392491,
            0.465337106165315,0.465292706422924,0.465292706422924,0.465292706422924,
            0.464671110029438,0.46422711260552,0.46396071415117,0.463827514923994,
            0.463783115181602,0.463783115181602,0.463783115181602,0.463339117757684,
            0.463072719303334,0.462939520076158,0.462895120333766,0.462895120333766,
            0.462895120333766,0.462628721879416,0.46249552265224,0.462451122909848,
            0.462451122909848,0.462451122909848,0.462317923682673,0.462273523940281,
            0.462273523940281,0.462273523940281,0.462273523940281,0.462273523940281,
            0.462273523940281,0.462273523940281,0.462273523940281,0.462273523940281,
            0.461341129350054,0.460408734759826,0.459742738623949,0.459298741200031,
            0.45903234274568,0.458899143518505,0.458854743776113,0.458854743776113,
            0.458854743776113,0.457966748928277,0.4573007527924,0.456856755368482,
            0.456590356914131,0.456457157686956,0.456412757944564,0.456412757944564,
            0.456412757944564,0.455791161551079,0.455347164127161,0.45508076567281,
            0.454947566445635,0.454903166703243,0.454903166703243,0.454903166703243,
            0.454459169279325,0.454192770824974,0.454059571597799,0.454015171855407,
            0.454015171855407,0.454015171855407,0.453748773401056,0.453615574173881,
            0.453571174431489,0.453571174431489,0.453571174431489,0.453437975204314,
            0.453393575461922,0.453393575461922,0.453393575461922,0.45334917571953,
            0.45334917571953,0.45334917571953,0.45334917571953,0.45334917571953,
            0.45334917571953,0.452683179583653,0.452017183447776,0.451573186023858,
            0.451306787569507,0.451173588342332,0.45112918859994,0.45112918859994,
            0.45112918859994,0.450507592206455,0.450063594782537,0.449797196328186,
            0.449663997101011,0.449619597358619,0.449619597358619,0.449619597358619,
            0.449175599934701,0.44890920148035,0.448776002253175,0.448731602510783,
            0.448731602510783,0.448731602510783,0.448465204056432,0.448332004829257,
            0.448287605086865,0.448287605086865,0.448287605086865,0.44815440585969,
            0.448110006117298,0.448110006117298,0.448110006117298,0.448065606374906,
            0.448065606374906,0.448065606374906,0.448065606374906,0.448065606374906,
            0.448065606374906,0.447621608950988,0.44717761152707,0.446911213072719,
            0.446778013845544,0.446733614103152,0.446733614103152,0.446733614103152,
            0.446289616679234,0.446023218224883,0.445890018997708,0.445845619255316,
            0.445845619255316,0.445845619255316,0.445579220800965,0.44544602157379,
            0.445401621831398,0.445401621831398,0.445401621831398,0.445268422604223,
            0.445224022861831,0.445224022861831,0.445224022861831,0.445179623119439,
            0.445179623119439,0.445179623119439,0.445179623119439,0.445179623119439,
            0.445179623119439,0.444913224665088,0.444646826210738,0.444513626983562,
            0.44446922724117,0.44446922724117,0.44446922724117,0.44420282878682,
            0.444069629559644,0.444025229817252,0.444025229817252,0.444025229817252,
            0.443892030590077,0.443847630847685,0.443847630847685,0.443847630847685,
            0.443803231105293,0.443803231105293,0.443803231105293,0.443803231105293,
            0.443803231105293,0.443803231105293,0.443581232393334,0.443448033166159,
            0.443403633423767,0.443403633423767,0.443403633423767,0.443270434196592,
            0.4432260344542,0.4432260344542,0.4432260344542,0.443181634711808,
            0.443181634711808,0.443181634711808,0.443181634711808,0.443181634711808,
            0.443181634711808,0.443092835227025,0.443048435484633,0.443048435484633,
            0.443048435484633,0.443004035742241,0.443004035742241,0.443004035742241,
            0.443004035742241,0.443004035742241,0.443004035742241,0.443004035742241,
            0.443004035742241,0.443004035742241,0.443004035742241,0.443004035742241,
            0.443004035742241,0.443004035742241,0.443004035742241,0.443004035742241,
            0.443004035742241,0.441450044758528,0.440206851971558,0.43927445738133,
            0.438608461245453,0.438164463821535,0.437898065367184,0.437764866140009,
            0.437720466397617,0.437720466397617,0.437720466397617,0.436521673353039,
            0.435589278762811,0.434923282626934,0.434479285203016,0.434212886748665,
            0.43407968752149,0.434035287779098,0.434035287779098,0.434035287779098,
            0.433147292931262,0.432481296795385,0.432037299371467,0.431770900917116,
            0.431637701689941,0.431593301947549,0.431593301947549,0.431593301947549,
            0.430971705554064,0.430527708130146,0.430261309675795,0.43012811044862,
            0.430083710706228,0.430083710706228,0.430083710706228,0.429684113024702,
            0.429417714570351,0.429284515343176,0.429240115600784,0.429240115600784,
            0.429240115600784,0.428973717146433,0.428840517919258,0.428796118176866,
            0.428796118176866,0.428796118176866,0.42866291894969,0.428618519207299,
            0.428618519207299,0.428618519207299,0.428618519207299,0.428618519207299,
            0.428618519207299,0.428618519207299,0.428618519207299,0.428618519207299,
            0.427686124617071,0.426753730026843,0.426087733890966,0.425643736467048,
            0.425377338012697,0.425244138785522,0.42519973904313,0.42519973904313,
            0.42519973904313,0.424311744195294,0.423645748059417,0.423201750635499,
            0.422935352181149,0.422802152953973,0.422757753211581,0.422757753211581,
            0.422757753211581,0.422136156818096,0.421692159394178,0.421425760939827,
            0.421292561712652,0.42124816197026,0.42124816197026,0.42124816197026,
            0.420848564288734,0.420582165834383,0.420448966607208,0.420404566864816,
            0.420404566864816,0.420404566864816,0.420138168410465,0.42000496918329,
            0.419960569440898,0.419960569440898,0.419960569440898,0.419827370213723,
            0.419782970471331,0.419782970471331,0.419782970471331,0.419738570728939,
            0.419738570728939,0.419738570728939,0.419738570728939,0.419738570728939,
            0.419738570728939,0.419072574593062,0.418406578457185,0.417962581033267,
            0.417696182578916,0.417562983351741,0.417518583609349,0.417518583609349,
            0.417518583609349,0.416896987215864,0.416452989791946,0.416186591337595,
            0.41605339211042,0.416008992368028,0.416008992368028,0.416008992368028,
            0.415609394686502,0.415342996232151,0.415209797004976,0.415165397262584,
            0.415165397262584,0.415165397262584,0.414898998808233,0.414765799581058,
            0.414721399838666,0.414721399838666,0.414721399838666,0.414588200611491,
            0.414543800869099,0.414543800869099,0.414543800869099,0.414499401126707,
            0.414499401126707,0.414499401126707,0.414499401126707,0.414499401126707,
            0.414499401126707,0.414055403702789,0.413611406278871,0.41334500782452,
            0.413211808597345,0.413167408854953,0.413167408854953,0.413167408854953,
            0.412767811173427,0.412501412719076,0.412368213491901,0.412323813749509,
            0.412323813749509,0.412323813749509,0.412057415295158,0.411924216067983,
            0.411879816325591,0.411879816325591,0.411879816325591,0.411746617098416,
            0.411702217356024,0.411702217356024,0.411702217356024,0.411657817613632,
            0.411657817613632,0.411657817613632,0.411657817613632,0.411657817613632,
            0.411657817613632,0.411391419159281,0.41112502070493,0.410991821477755,
            0.410947421735363,0.410947421735363,0.410947421735363,0.410681023281012,
            0.410547824053837,0.410503424311445,0.410503424311445,0.410503424311445,
            0.41037022508427,0.410325825341878,0.410325825341878,0.410325825341878,
            0.410281425599486,0.410281425599486,0.410281425599486,0.410281425599486,
            0.410281425599486,0.410281425599486,0.410148226372311,0.410015027145135,
            0.409970627402744,0.409970627402744,0.409970627402744,0.409837428175568,
            0.409793028433176,0.409793028433176,0.409793028433176,0.409748628690785,
            0.409748628690785,0.409748628690785,0.409748628690785,0.409748628690785,
            0.409748628690785,0.409659829206001,0.409615429463609,0.409615429463609,
            0.409615429463609,0.409571029721217,0.409571029721217,0.409571029721217,
            0.409571029721217,0.409571029721217,0.409571029721217,0.409571029721217,
            0.409571029721217,0.409571029721217,0.409571029721217,0.409571029721217,
            0.409571029721217,0.409571029721217,0.409571029721217,0.409571029721217,
            0.409571029721217,0.408017038737505,0.406773845950534,0.405841451360306,
            0.405175455224429,0.404731457800512,0.404465059346161,0.404331860118985,
            0.404287460376594,0.404287460376594,0.404287460376594,0.403088667332015,
            0.402156272741787,0.40149027660591,0.401046279181992,0.400779880727642,
            0.400646681500466,0.400602281758074,0.400602281758074,0.400602281758074,
            0.399714286910238,0.399048290774361,0.398604293350443,0.398337894896093,
            0.398204695668917,0.398160295926525,0.398160295926525,0.398160295926525,
            0.39753869953304,0.397094702109122,0.396828303654772,0.396695104427596,
            0.396650704685204,0.396650704685204,0.396650704685204,0.396251107003678,
            0.395984708549327,0.395851509322152,0.39580710957976,0.39580710957976,
            0.39580710957976,0.395585110867801,0.395451911640626,0.395407511898234,
            0.395407511898234,0.395407511898234,0.395274312671059,0.395229912928667,
            0.395229912928667,0.395229912928667,0.395229912928667,0.395229912928667,
            0.395229912928667,0.395229912928667,0.395229912928667,0.395229912928667,
            0.394031119884088,0.393098725293861,0.392432729157984,0.391988731734066,
            0.391722333279715,0.391589134052539,0.391544734310148,0.391544734310148,
            0.391544734310148,0.390656739462312,0.389990743326435,0.389546745902517,
            0.389280347448166,0.389147148220991,0.389102748478599,0.389102748478599,
            0.389102748478599,0.388481152085114,0.388037154661196,0.387770756206845,
            0.387637556979669,0.387593157237278,0.387593157237278,0.387593157237278,
            0.387193559555751,0.386927161101401,0.386793961874225,0.386749562131833,
            0.386749562131833,0.386749562131833,0.386527563419874,0.386394364192699,
            0.386349964450307,0.386349964450307,0.386349964450307,0.386216765223132,
            0.38617236548074,0.38617236548074,0.38617236548074,0.386127965738348,
            0.386127965738348,0.386127965738348,0.386127965738348,0.386127965738348,
            0.386127965738348,0.385461969602471,0.384795973466594,0.384351976042676,
            0.384085577588326,0.38395237836115,0.383907978618758,0.383907978618758,
            0.383907978618758,0.383286382225273,0.382842384801355,0.382575986347004,
            0.382442787119829,0.382398387377437,0.382398387377437,0.382398387377437,
            0.381998789695911,0.38173239124156,0.381599192014385,0.381554792271993,
            0.381554792271993,0.381554792271993,0.381332793560034,0.381199594332859,
            0.381155194590467,0.381155194590467,0.381155194590467,0.381021995363292,
            0.3809775956209,0.3809775956209,0.3809775956209,0.380933195878508,
            0.380933195878508,0.380933195878508,0.380933195878508,0.380933195878508,
            0.380933195878508,0.38048919845459,0.380045201030672,0.379778802576321,
            0.379645603349146,0.379601203606754,0.379601203606754,0.379601203606754,
            0.379201605925228,0.378935207470877,0.378802008243702,0.37875760850131,
            0.37875760850131,0.37875760850131,0.378535609789351,0.378402410562175,
            0.378358010819784,0.378358010819784,0.378358010819784,0.378224811592608,
            0.378180411850217,0.378180411850217,0.378180411850217,0.378136012107825,
            0.378136012107825,0.378136012107825,0.378136012107825,0.378136012107825,
            0.378136012107825,0.377869613653474,0.377603215199123,0.377470015971948,
            0.377425616229556,0.377425616229556,0.377425616229556,0.377203617517597,
            0.377070418290422,0.37702601854803,0.37702601854803,0.37702601854803,
            0.376892819320854,0.376848419578463,0.376848419578463,0.376848419578463,
            0.376804019836071,0.376804019836071,0.376804019836071,0.376804019836071,
            0.376804019836071,0.376804019836071,0.376670820608895,0.37653762138172,
            0.376493221639328,0.376493221639328,0.376493221639328,0.376360022412153,
            0.376315622669761,0.376315622669761,0.376315622669761,0.376271222927369,
            0.376271222927369,0.376271222927369,0.376271222927369,0.376271222927369,
            0.376271222927369,0.376226823184977,0.376182423442586,0.376182423442586,
            0.376182423442586,0.376138023700194,0.376138023700194,0.376138023700194,
            0.376138023700194,0.376138023700194,0.376138023700194,0.376138023700194,
            0.376138023700194,0.376138023700194,0.376138023700194,0.376138023700194,
            0.376138023700194,0.376138023700194,0.376138023700194,0.376138023700194,
            0.376138023700194,0.374584032716481,0.373340839929511,0.372408445339283,
            0.371742449203406,0.371298451779488,0.371032053325137,0.370898854097962,
            0.37085445435557,0.37085445435557,0.37085445435557,0.3696112615686,
            0.368678866978372,0.368012870842495,0.367568873418577,0.367302474964226,
            0.367169275737051,0.367124875994659,0.367124875994659,0.367124875994659,
            0.366236881146823,0.365570885010946,0.365126887587028,0.364860489132677,
            0.364727289905502,0.36468289016311,0.36468289016311,0.36468289016311,
            0.364061293769625,0.363617296345707,0.363350897891356,0.363217698664181,
            0.363173298921789,0.363173298921789,0.363173298921789,0.362773701240263,
            0.362507302785912,0.362374103558737,0.362329703816345,0.362329703816345,
            0.362329703816345,0.362107705104386,0.36197450587721,0.361930106134819,
            0.361930106134819,0.361930106134819,0.361841306650035,0.361796906907643,
            0.361796906907643,0.361796906907643,0.361796906907643,0.361796906907643,
            0.361796906907643,0.361796906907643,0.361796906907643,0.361796906907643,
            0.360598113863065,0.359665719272837,0.35899972313696,0.358555725713042,
            0.358289327258691,0.358156128031516,0.358111728289124,0.358111728289124,
            0.358111728289124,0.357223733441288,0.356557737305411,0.356113739881493,
            0.355847341427142,0.355714142199967,0.355669742457575,0.355669742457575,
            0.355669742457575,0.35504814606409,0.354604148640172,0.354337750185821,
            0.354204550958646,0.354160151216254,0.354160151216254,0.354160151216254,
            0.353760553534728,0.353494155080377,0.353360955853202,0.35331655611081,
            0.35331655611081,0.35331655611081,0.353094557398851,0.352961358171675,
            0.352916958429284,0.352916958429284,0.352916958429284,0.3528281589445,
            0.352783759202108,0.352783759202108,0.352783759202108,0.352739359459716,
            0.352739359459716,0.352739359459716,0.352739359459716,0.352739359459716,
            0.352739359459716,0.35185136461188,0.351185368476004,0.350741371052086,
            0.350474972597735,0.350341773370559,0.350297373628168,0.350297373628168,
            0.350297373628168,0.349675777234682,0.349231779810764,0.348965381356414,
            0.348832182129238,0.348787782386846,0.348787782386846,0.348787782386846,
            0.34838818470532,0.348121786250969,0.347988587023794,0.347944187281402,
            0.347944187281402,0.347944187281402,0.347722188569443,0.347588989342268,
            0.347544589599876,0.347544589599876,0.347544589599876,0.347455790115092,
            0.347411390372701,0.347411390372701,0.347411390372701,0.347366990630309,
            0.347366990630309,0.347366990630309,0.347366990630309,0.347366990630309,
            0.347366990630309,0.346922993206391,0.346478995782473,0.346212597328122,
            0.346079398100947,0.346034998358555,0.346034998358555,0.346034998358555,
            0.345635400677029,0.345369002222678,0.345235802995503,0.345191403253111,
            0.345191403253111,0.345191403253111,0.344969404541152,0.344836205313976,
            0.344791805571585,0.344791805571585,0.344791805571585,0.344703006086801,
            0.344658606344409,0.344658606344409,0.344658606344409,0.344614206602017,
            0.344614206602017,0.344614206602017,0.344614206602017,0.344614206602017,
            0.344614206602017,0.344347808147667,0.344081409693316,0.34394821046614,
            0.343903810723749,0.343903810723749,0.343903810723749,0.34368181201179,
            0.343548612784614,0.343504213042223,0.343504213042223,0.343504213042223,
            0.343415413557439,0.343371013815047,0.343371013815047,0.343371013815047,
            0.343326614072655,0.343326614072655,0.343326614072655,0.343326614072655,
            0.343326614072655,0.343326614072655,0.34319341484548,0.343060215618305,
            0.343015815875913,0.343015815875913,0.343015815875913,0.342927016391129,
            0.342882616648737,0.342882616648737,0.342882616648737,0.342838216906346,
            0.342838216906346,0.342838216906346,0.342838216906346,0.342838216906346,
            0.342838216906346,0.342793817163954,0.342749417421562,0.342749417421562,
            0.342749417421562,0.34270501767917,0.34270501767917,0.34270501767917,
            0.34270501767917,0.34270501767917,0.34270501767917,0.34270501767917,
            0.34270501767917,0.34270501767917,0.34270501767917,0.34270501767917,
            0.34270501767917,0.34270501767917,0.34270501767917,0.34270501767917,
            0.34270501767917,0.341151026695457,0.339907833908487,0.338975439318259,
            0.338309443182382,0.337865445758464,0.337599047304113,0.337465848076938,
            0.337421448334546,0.337421448334546,0.337421448334546,0.336178255547576,
            0.335245860957348,0.334579864821471,0.334135867397553,0.333869468943202,
            0.333736269716027,0.333691869973635,0.333691869973635,0.333691869973635,
            0.332759475383407,0.332093479247531,0.331649481823613,0.331383083369262,
            0.331249884142086,0.331205484399695,0.331205484399695,0.331205484399695,
            0.330583888006209,0.330139890582291,0.329873492127941,0.329740292900765,
            0.329695893158373,0.329695893158373,0.329695893158373,0.329296295476847,
            0.329029897022496,0.328896697795321,0.328852298052929,0.328852298052929,
            0.328852298052929,0.32863029934097,0.328497100113795,0.328452700371403,
            0.328452700371403,0.328452700371403,0.328363900886619,0.328319501144228,
            0.328319501144228,0.328319501144228,0.328319501144228,0.328319501144228,
            0.328319501144228,0.328319501144228,0.328319501144228,0.328319501144228,
            0.327120708099649,0.326188313509421,0.325522317373544,0.325078319949626,
            0.324811921495276,0.3246787222681,0.324634322525709,0.324634322525709,
            0.324634322525709,0.323701927935481,0.323035931799604,0.322591934375686,
            0.322325535921335,0.32219233669416,0.322147936951768,0.322147936951768,
            0.322147936951768,0.321526340558283,0.321082343134365,0.320815944680014,
            0.320682745452838,0.320638345710447,0.320638345710447,0.320638345710447,
            0.320238748028921,0.31997234957457,0.319839150347394,0.319794750605003,
            0.319794750605003,0.319794750605003,0.319572751893044,0.319439552665868,
            0.319395152923476,0.319395152923476,0.319395152923476,0.319306353438693,
            0.319261953696301,0.319261953696301,0.319261953696301,0.319261953696301,
            0.319261953696301,0.319261953696301,0.319261953696301,0.319261953696301,
            0.319261953696301,0.318373958848465,0.317707962712588,0.31726396528867,
            0.316997566834319,0.316864367607144,0.316819967864752,0.316819967864752,
            0.316819967864752,0.316198371471267,0.315754374047349,0.315487975592998,
            0.315354776365823,0.315310376623431,0.315310376623431,0.315310376623431,
            0.314910778941905,0.314644380487554,0.314511181260379,0.314466781517987,
            0.314466781517987,0.314466781517987,0.314244782806028,0.314111583578852,
            0.314067183836461,0.314067183836461,0.314067183836461,0.313978384351677,
            0.313933984609285,0.313933984609285,0.313933984609285,0.313933984609285,
            0.313933984609285,0.313933984609285,0.313933984609285,0.313933984609285,
            0.313933984609285,0.3133123882158,0.312868390791882,0.312601992337531,
            0.312468793110356,0.312424393367964,0.312424393367964,0.312424393367964,
            0.312024795686438,0.311758397232087,0.311625198004912,0.31158079826252,
            0.31158079826252,0.31158079826252,0.311358799550561,0.311225600323386,
            0.311181200580994,0.311181200580994,0.311181200580994,0.31109240109621,
            0.311048001353818,0.311048001353818,0.311048001353818,0.311048001353818,
            0.311048001353818,0.311048001353818,0.311048001353818,0.311048001353818,
            0.311048001353818,0.310781602899468,0.310515204445117,0.310382005217941,
            0.31033760547555,0.31033760547555,0.31033760547555,0.310115606763591,
            0.309982407536415,0.309938007794023,0.309938007794023,0.309938007794023,
            0.30984920830924,0.309804808566848,0.309804808566848,0.309804808566848,
            0.309804808566848,0.309804808566848,0.309804808566848,0.309804808566848,
            0.309804808566848,0.309804808566848,0.309671609339673,0.309538410112497,
            0.309494010370105,0.309494010370105,0.309494010370105,0.309405210885322,
            0.30936081114293,0.30936081114293,0.30936081114293,0.30936081114293,
            0.30936081114293,0.30936081114293,0.30936081114293,0.30936081114293,
            0.30936081114293,0.309316411400538,0.309272011658146,0.309272011658146,
            0.309272011658146,0.309272011658146,0.309272011658146,0.309272011658146,
            0.309272011658146,0.309272011658146,0.309272011658146,0.309272011658146,
            0.309272011658146,0.309272011658146,0.309272011658146,0.309272011658146,
            0.309272011658146,0.309272011658146,0.309272011658146,0.309272011658146,
            0.309272011658146,0.307718020674434,0.306474827887463,0.305542433297236,
            0.304876437161359,0.304432439737441,0.30416604128309,0.304032842055914,
            0.304032842055914,0.304032842055914,0.304032842055914,0.302789649268944,
            0.301857254678716,0.301191258542839,0.300747261118921,0.300480862664571,
            0.300347663437395,0.300347663437395,0.300347663437395,0.300347663437395,
            0.299415268847167,0.29874927271129,0.298305275287372,0.298038876833022,
            0.297905677605846,0.297905677605846,0.297905677605846,0.297905677605846,
            0.297239681469969,0.296795684046051,0.296529285591701,0.296396086364525,
            0.296396086364525,0.296396086364525,0.296396086364525,0.295996488682999,
            0.295730090228648,0.295596891001473,0.295596891001473,0.295596891001473,
            0.295596891001473,0.295374892289514,0.295241693062338,0.295241693062338,
            0.295241693062338,0.295241693062338,0.295152893577555,0.295152893577555,
            0.295152893577555,0.295152893577555,0.295152893577555,0.295152893577555,
            0.295152893577555,0.295152893577555,0.295152893577555,0.295152893577555,
            0.293954100532976,0.293021705942749,0.292355709806872,0.291911712382954,
            0.291645313928603,0.291512114701427,0.291467714959036,0.291467714959036,
            0.291467714959036,0.290535320368808,0.289869324232931,0.289425326809013,
            0.289158928354662,0.289025729127487,0.288981329385095,0.288981329385095,
            0.288981329385095,0.288315333249218,0.2878713358253,0.287604937370949,
            0.287471738143774,0.287427338401382,0.287427338401382,0.287427338401382,
            0.287027740719856,0.286761342265505,0.28662814303833,0.286583743295938,
            0.286583743295938,0.286583743295938,0.286361744583979,0.286228545356804,
            0.286184145614412,0.286184145614412,0.286184145614412,0.286095346129628,
            0.286050946387236,0.286050946387236,0.286050946387236,0.286050946387236,
            0.286050946387236,0.286050946387236,0.286050946387236,0.286050946387236,
            0.286050946387236,0.2851629515394,0.284496955403523,0.284052957979605,
            0.283786559525255,0.283653360298079,0.283608960555687,0.283608960555687,
            0.283608960555687,0.28294296441981,0.282498966995892,0.282232568541542,
            0.282099369314366,0.282054969571975,0.282054969571975,0.282054969571975,
            0.281655371890448,0.281388973436098,0.281255774208922,0.28121137446653,
            0.28121137446653,0.28121137446653,0.280989375754571,0.280856176527396,
            0.280811776785004,0.280811776785004,0.280811776785004,0.280722977300221,
            0.280678577557829,0.280678577557829,0.280678577557829,0.280678577557829,
            0.280678577557829,0.280678577557829,0.280678577557829,0.280678577557829,
            0.280678577557829,0.280056981164344,0.279612983740426,0.279346585286075,
            0.279213386058899,0.279168986316508,0.279168986316508,0.279168986316508,
            0.278769388634982,0.278502990180631,0.278369790953455,0.278325391211064,
            0.278325391211064,0.278325391211064,0.278103392499105,0.277970193271929,
            0.277925793529537,0.277925793529537,0.277925793529537,0.277836994044754,
            0.277792594302362,0.277792594302362,0.277792594302362,0.277792594302362,
            0.277792594302362,0.277792594302362,0.277792594302362,0.277792594302362,
            0.277792594302362,0.277392996620836,0.277126598166485,0.27699339893931,
            0.276948999196918,0.276948999196918,0.276948999196918,0.276727000484959,
            0.276593801257783,0.276549401515392,0.276549401515392,0.276549401515392,
            0.276460602030608,0.276416202288216,0.276416202288216,0.276416202288216,
            0.276416202288216,0.276416202288216,0.276416202288216,0.276416202288216,
            0.276416202288216,0.276416202288216,0.276283003061041,0.276149803833865,
            0.276105404091474,0.276105404091474,0.276105404091474,0.27601660460669,
            0.275972204864298,0.275972204864298,0.275972204864298,0.275972204864298,
            0.275972204864298,0.275972204864298,0.275972204864298,0.275972204864298,
            0.275972204864298,0.275927805121906,0.275883405379515,0.275883405379515,
            0.275883405379515,0.275883405379515,0.275883405379515,0.275883405379515,
            0.275883405379515,0.275883405379515,0.275883405379515,0.275883405379515,
            0.275883405379515,0.275883405379515,0.275883405379515,0.275883405379515,
            0.275883405379515,0.275883405379515,0.275883405379515,0.275883405379515,
            0.275883405379515,0.274329414395802,0.273086221608831,0.272153827018604,
            0.271487830882727,0.271043833458809,0.270777435004458,0.270644235777283,
            0.270644235777283,0.270644235777283,0.270644235777283,0.269401042990312,
            0.268468648400084,0.267802652264207,0.267358654840289,0.267092256385939,
            0.266959057158763,0.266959057158763,0.266959057158763,0.266959057158763,
            0.266026662568536,0.265360666432659,0.264916669008741,0.26465027055439,
            0.264517071327214,0.264517071327214,0.264517071327214,0.264517071327214,
            0.263851075191337,0.26340707776742,0.263140679313069,0.263007480085893,
            0.263007480085893,0.263007480085893,0.263007480085893,0.262563482661975,
            0.262297084207625,0.262163884980449,0.262163884980449,0.262163884980449,
            0.262163884980449,0.26194188626849,0.261808687041315,0.261808687041315,
            0.261808687041315,0.261808687041315,0.261719887556531,0.261719887556531,
            0.261719887556531,0.261719887556531,0.261719887556531,0.261719887556531,
            0.261719887556531,0.261719887556531,0.261719887556531,0.261719887556531,
            0.260521094511953,0.259588699921725,0.258922703785848,0.25847870636193,
            0.258212307907579,0.258079108680404,0.258034708938012,0.258034708938012,
            0.258034708938012,0.257102314347784,0.256436318211907,0.255992320787989,
            0.255725922333639,0.255592723106463,0.255548323364071,0.255548323364071,
            0.255548323364071,0.254882327228194,0.254438329804276,0.254171931349926,
            0.25403873212275,0.253994332380358,0.253994332380358,0.253994332380358,
            0.25355033495644,0.25328393650209,0.253150737274914,0.253106337532522,
            0.253106337532522,0.253106337532522,0.252884338820563,0.252751139593388,
            0.252706739850996,0.252706739850996,0.252706739850996,0.252617940366213,
            0.252573540623821,0.252573540623821,0.252573540623821,0.252573540623821,
            0.252573540623821,0.252573540623821,0.252573540623821,0.252573540623821,
            0.252573540623821,0.251685545775985,0.251019549640108,0.25057555221619,
            0.250309153761839,0.250175954534664,0.250131554792272,0.250131554792272,
            0.250131554792272,0.249465558656395,0.249021561232477,0.248755162778126,
            0.248621963550951,0.248577563808559,0.248577563808559,0.248577563808559,
            0.248133566384641,0.24786716793029,0.247733968703115,0.247689568960723,
            0.247689568960723,0.247689568960723,0.247467570248764,0.247334371021589,
            0.247289971279197,0.247289971279197,0.247289971279197,0.247201171794413,
            0.247156772052022,0.247156772052022,0.247156772052022,0.247156772052022,
            0.247156772052022,0.247156772052022,0.247156772052022,0.247156772052022,
            0.247156772052022,0.246535175658536,0.246091178234618,0.245824779780268,
            0.245691580553092,0.2456471808107,0.2456471808107,0.2456471808107,
            0.245203183386782,0.244936784932432,0.244803585705256,0.244759185962864,
            0.244759185962864,0.244759185962864,0.244537187250905,0.24440398802373,
            0.244359588281338,0.244359588281338,0.244359588281338,0.244270788796555,
            0.244226389054163,0.244226389054163,0.244226389054163,0.244226389054163,
            0.244226389054163,0.244226389054163,0.244226389054163,0.244226389054163,
            0.244226389054163,0.243826791372637,0.243560392918286,0.243427193691111,
            0.243382793948719,0.243382793948719,0.243382793948719,0.24316079523676,
            0.243027596009584,0.242983196267193,0.242983196267193,0.242983196267193,
            0.242894396782409,0.242849997040017,0.242849997040017,0.242849997040017,
            0.242849997040017,0.242849997040017,0.242849997040017,0.242849997040017,
            0.242849997040017,0.242849997040017,0.242627998328058,0.242494799100883,
            0.242450399358491,0.242450399358491,0.242450399358491,0.242361599873707,
            0.242317200131316,0.242317200131316,0.242317200131316,0.242317200131316,
            0.242317200131316,0.242317200131316,0.242317200131316,0.242317200131316,
            0.242317200131316,0.242272800388924,0.242228400646532,0.242228400646532,
            0.242228400646532,0.242228400646532,0.242228400646532,0.242228400646532,
            0.242228400646532,0.242228400646532,0.242228400646532,0.242228400646532,
            0.242228400646532,0.242228400646532,0.242228400646532,0.242228400646532,
            0.242228400646532,0.242228400646532,0.242228400646532,0.242228400646532,
            0.242228400646532,0.240674409662819,0.239431216875849,0.238498822285621,
            0.237832826149744,0.237388828725826,0.237122430271475,0.2369892310443,
            0.2369892310443,0.2369892310443,0.2369892310443,0.23574603825733,
            0.234813643667102,0.234147647531225,0.233703650107307,0.233437251652956,
            0.233304052425781,0.233304052425781,0.233304052425781,0.233304052425781,
            0.232371657835553,0.231705661699676,0.231261664275758,0.230995265821407,
            0.230862066594232,0.230862066594232,0.230862066594232,0.230862066594232,
            0.230196070458355,0.229752073034437,0.229485674580086,0.229352475352911,
            0.229352475352911,0.229352475352911,0.229352475352911,0.228908477928993,
            0.228642079474642,0.228508880247467,0.228508880247467,0.228508880247467,
            0.228508880247467,0.228242481793116,0.22810928256594,0.22810928256594,
            0.22810928256594,0.22810928256594,0.228020483081157,0.228020483081157,
            0.228020483081157,0.228020483081157,0.228020483081157,0.228020483081157,
            0.228020483081157,0.228020483081157,0.228020483081157,0.228020483081157,
            0.226821690036578,0.22588929544635,0.225223299310473,0.224779301886556,
            0.224512903432205,0.224379704205029,0.224335304462638,0.224335304462638,
            0.224335304462638,0.22340290987241,0.222736913736533,0.222292916312615,
            0.222026517858264,0.221893318631089,0.221848918888697,0.221848918888697,
            0.221848918888697,0.22118292275282,0.220738925328902,0.220472526874551,
            0.220339327647376,0.220294927904984,0.220294927904984,0.220294927904984,
            0.219850930481066,0.219584532026715,0.21945133279954,0.219406933057148,
            0.219406933057148,0.219406933057148,0.219140534602797,0.219007335375622,
            0.21896293563323,0.21896293563323,0.21896293563323,0.218874136148446,
            0.218829736406055,0.218829736406055,0.218829736406055,0.218829736406055,
            0.218829736406055,0.218829736406055,0.218829736406055,0.218829736406055,
            0.218829736406055,0.217941741558219,0.217275745422342,0.216831747998424,
            0.216565349544073,0.216432150316898,0.216387750574506,0.216387750574506,
            0.216387750574506,0.215721754438629,0.215277757014711,0.21501135856036,
            0.214878159333185,0.214833759590793,0.214833759590793,0.214833759590793,
            0.214389762166875,0.214123363712524,0.213990164485349,0.213945764742957,
            0.213945764742957,0.213945764742957,0.213679366288606,0.213546167061431,
            0.213501767319039,0.213501767319039,0.213501767319039,0.213412967834255,
            0.213368568091864,0.213368568091864,0.213368568091864,0.213368568091864,
            0.213368568091864,0.213368568091864,0.213368568091864,0.213368568091864,
            0.213368568091864,0.212746971698378,0.21230297427446,0.21203657582011,
            0.211903376592934,0.211858976850542,0.211858976850542,0.211858976850542,
            0.211414979426624,0.211148580972274,0.211015381745098,0.210970982002706,
            0.210970982002706,0.210970982002706,0.210704583548356,0.21057138432118,
            0.210526984578788,0.210526984578788,0.210526984578788,0.210438185094005,
            0.210393785351613,0.210393785351613,0.210393785351613,0.210393785351613,
            0.210393785351613,0.210393785351613,0.210393785351613,0.210393785351613,
            0.210393785351613,0.209994187670087,0.209727789215736,0.209594589988561,
            0.209550190246169,0.209550190246169,0.209550190246169,0.209283791791818,
            0.209150592564643,0.209106192822251,0.209106192822251,0.209106192822251,
            0.209017393337467,0.208972993595076,0.208972993595076,0.208972993595076,
            0.208972993595076,0.208972993595076,0.208972993595076,0.208972993595076,
            0.208972993595076,0.208972993595076,0.208750994883117,0.208617795655941,
            0.208573395913549,0.208573395913549,0.208573395913549,0.208484596428766,
            0.208440196686374,0.208440196686374,0.208440196686374,0.208440196686374,
            0.208440196686374,0.208440196686374,0.208440196686374,0.208440196686374,
            0.208440196686374,0.20835139720159,0.208306997459199,0.208306997459199,
            0.208306997459199,0.208306997459199,0.208306997459199,0.208306997459199,
            0.208306997459199,0.208306997459199,0.208306997459199,0.208306997459199,
            0.208306997459199,0.208306997459199,0.208306997459199,0.208306997459199,
            0.208306997459199,0.208306997459199,0.208306997459199,0.208306997459199,
            0.208306997459199,0.206753006475486,0.205509813688515,0.204577419098288,
            0.203911422962411,0.203467425538493,0.203201027084142,0.203067827856966,
            0.203067827856966,0.203067827856966,0.203067827856966,0.201824635069996,
            0.200892240479768,0.200226244343891,0.199782246919973,0.199515848465623,
            0.199382649238447,0.199382649238447,0.199382649238447,0.199382649238447,
            0.198450254648219,0.197784258512343,0.197340261088425,0.197073862634074,
            0.196940663406898,0.196940663406898,0.196940663406898,0.196940663406898,
            0.196274667271021,0.195830669847103,0.195564271392753,0.195431072165577,
            0.195431072165577,0.195431072165577,0.195431072165577,0.194987074741659,
            0.194720676287308,0.194587477060133,0.194587477060133,0.194587477060133,
            0.194587477060133,0.194321078605782,0.194187879378607,0.194187879378607,
            0.194187879378607,0.194187879378607,0.194054680151432,0.194054680151432,
            0.194054680151432,0.194054680151432,0.194054680151432,0.194054680151432,
            0.194054680151432,0.194054680151432,0.194054680151432,0.194054680151432,
            0.192855887106853,0.191923492516625,0.191257496380748,0.19081349895683,
            0.190547100502479,0.190413901275304,0.190369501532912,0.190369501532912,
            0.190369501532912,0.189437106942685,0.188771110806808,0.18832711338289,
            0.188060714928539,0.187927515701363,0.187883115958972,0.187883115958972,
            0.187883115958972,0.187217119823095,0.186773122399177,0.186506723944826,
            0.186373524717651,0.186329124975259,0.186329124975259,0.186329124975259,
            0.185885127551341,0.18561872909699,0.185485529869815,0.185441130127423,
            0.185441130127423,0.185441130127423,0.185174731673072,0.185041532445897,
            0.184997132703505,0.184997132703505,0.184997132703505,0.184863933476329,
            0.184819533733938,0.184819533733938,0.184819533733938,0.184819533733938,
            0.184819533733938,0.184819533733938,0.184819533733938,0.184819533733938,
            0.184819533733938,0.183931538886102,0.183265542750225,0.182821545326307,
            0.182555146871956,0.182421947644781,0.182377547902389,0.182377547902389,
            0.182377547902389,0.181711551766512,0.181267554342594,0.181001155888243,
            0.180867956661068,0.180823556918676,0.180823556918676,0.180823556918676,
            0.180379559494758,0.180113161040407,0.179979961813232,0.17993556207084,
            0.17993556207084,0.17993556207084,0.179669163616489,0.179535964389314,
            0.179491564646922,0.179491564646922,0.179491564646922,0.179358365419747,
            0.179313965677355,0.179313965677355,0.179313965677355,0.179313965677355,
            0.179313965677355,0.179313965677355,0.179313965677355,0.179313965677355,
            0.179313965677355,0.17869236928387,0.178248371859952,0.177981973405601,
            0.177848774178425,0.177804374436034,0.177804374436034,0.177804374436034,
            0.177360377012116,0.177093978557765,0.176960779330589,0.176916379588198,
            0.176916379588198,0.176916379588198,0.176649981133847,0.176516781906671,
            0.17647238216428,0.17647238216428,0.17647238216428,0.176339182937104,
            0.176294783194712,0.176294783194712,0.176294783194712,0.176294783194712,
            0.176294783194712,0.176294783194712,0.176294783194712,0.176294783194712,
            0.176294783194712,0.175895185513186,0.175628787058836,0.17549558783166,
            0.175451188089268,0.175451188089268,0.175451188089268,0.175184789634918,
            0.175051590407742,0.17500719066535,0.17500719066535,0.17500719066535,
            0.174873991438175,0.174829591695783,0.174829591695783,0.174829591695783,
            0.174829591695783,0.174829591695783,0.174829591695783,0.174829591695783,
            0.174829591695783,0.174829591695783,0.174607592983824,0.174474393756649,
            0.174429994014257,0.174429994014257,0.174429994014257,0.174296794787082,
            0.17425239504469,0.17425239504469,0.17425239504469,0.17425239504469,
            0.17425239504469,0.17425239504469,0.17425239504469,0.17425239504469,
            0.17425239504469,0.174163595559906,0.174119195817514,0.174119195817514,
            0.174119195817514,0.174119195817514,0.174119195817514,0.174119195817514,
            0.174119195817514,0.174119195817514,0.174119195817514,0.174119195817514,
            0.174119195817514,0.174119195817514,0.174119195817514,0.174119195817514,
            0.174119195817514,0.174119195817514,0.174119195817514,0.174119195817514,
            0.174119195817514,0.171679900879444,0.169937547352251,0.168775978334122,
            0.168079036923244,0.167730566217806,0.167614409315993,0.167614409315993,
            0.167614409315993,0.165175114377922,0.163432760850729,0.1622711918326,
            0.161574250421723,0.161225779716284,0.161109622814471,0.161109622814471,
            0.161109622814471,0.159367269287278,0.158205700269149,0.157508758858272,
            0.157160288152833,0.15704413125102,0.15704413125102,0.15704413125102,
            0.155882562232891,0.155185620822014,0.154837150116575,0.154720993214763,
            0.154720993214763,0.154720993214763,0.154024051803885,0.153675581098447,
            0.153559424196634,0.153559424196634,0.153559424196634,0.153210953491195,
            0.153094796589382,0.153094796589382,0.153094796589382,0.153094796589382,
            0.153094796589382,0.153094796589382,0.153094796589382,0.153094796589382,
            0.153094796589382,0.150771658553125,0.149029305025931,0.147867736007802,
            0.147170794596925,0.146822323891486,0.146706166989674,0.146706166989674,
            0.146706166989674,0.14496381346248,0.143802244444351,0.143105303033474,
            0.142756832328035,0.142640675426223,0.142640675426223,0.142640675426223,
            0.141479106408094,0.140782164997216,0.140433694291778,0.140317537389965,
            0.140317537389965,0.140317537389965,0.139620595979088,0.139272125273649,
            0.139155968371836,0.139155968371836,0.139155968371836,0.138807497666397,
            0.138691340764585,0.138691340764585,0.138691340764585,0.138691340764585,
            0.138691340764585,0.138691340764585,0.138691340764585,0.138691340764585,
            0.138691340764585,0.137065144139204,0.135903575121075,0.135206633710198,
            0.134858163004759,0.134742006102946,0.134742006102946,0.134742006102946,
            0.133580437084818,0.13288349567394,0.132535024968502,0.132418868066689,
            0.132418868066689,0.132418868066689,0.131721926655811,0.131373455950373,
            0.13125729904856,0.13125729904856,0.13125729904856,0.130908828343121,
            0.130792671441308,0.130792671441308,0.130792671441308,0.130792671441308,
            0.130792671441308,0.130792671441308,0.130792671441308,0.130792671441308,
            0.130792671441308,0.129747259324992,0.129050317914115,0.128701847208676,
            0.128585690306864,0.128585690306864,0.128585690306864,0.127888748895986,
            0.127540278190548,0.127424121288735,0.127424121288735,0.127424121288735,
            0.127075650583296,0.126959493681483,0.126959493681483,0.126959493681483,
            0.126959493681483,0.126959493681483,0.126959493681483,0.126959493681483,
            0.126959493681483,0.126959493681483,0.126378709172419,0.12603023846698,
            0.125914081565167,0.125914081565167,0.125914081565167,0.125565610859729,
            0.125449453957916,0.125449453957916,0.125449453957916,0.125449453957916,
            0.125449453957916,0.125449453957916,0.125449453957916,0.125449453957916,
            0.125449453957916,0.12521714015429,0.125100983252477,0.125100983252477,
            0.125100983252477,0.125100983252477,0.125100983252477,0.125100983252477,
            0.125100983252477,0.125100983252477,0.125100983252477,0.125100983252477,
            0.125100983252477,0.125100983252477,0.125100983252477,0.125100983252477,
            0.125100983252477,0.125100983252477,0.125100983252477,0.125100983252477,
            0.125100983252477,0.123358629725284,0.12161627619809,0.120454707179962,
            0.119757765769084,0.119409295063646,0.119293138161833,0.119293138161833,
            0.119293138161833,0.117550784634639,0.116389215616511,0.115692274205633,
            0.115343803500195,0.115227646598382,0.115227646598382,0.115227646598382,
            0.114066077580253,0.113369136169376,0.113020665463937,0.112904508562124,
            0.112904508562124,0.112904508562124,0.112207567151247,0.111859096445808,
            0.111742939543995,0.111742939543995,0.111742939543995,0.111394468838557,
            0.111278311936744,0.111278311936744,0.111278311936744,0.111278311936744,
            0.111278311936744,0.111278311936744,0.111278311936744,0.111278311936744,
            0.111278311936744,0.109652115311363,0.108490546293234,0.107793604882357,
            0.107445134176918,0.107328977275106,0.107328977275106,0.107328977275106,
            0.106167408256977,0.105470466846099,0.105121996140661,0.105005839238848,
            0.105005839238848,0.105005839238848,0.104308897827971,0.103960427122532,
            0.103844270220719,0.103844270220719,0.103844270220719,0.10349579951528,
            0.103379642613468,0.103379642613468,0.103379642613468,0.103379642613468,
            0.103379642613468,0.103379642613468,0.103379642613468,0.103379642613468,
            0.103379642613468,0.102334230497152,0.101637289086274,0.101288818380836,
            0.101172661479023,0.101172661479023,0.101172661479023,0.100475720068145,
            0.100127249362707,0.100011092460894,0.100011092460894,0.100011092460894,
            0.0996626217554552,0.0995464648536423,0.0995464648536423,0.0995464648536423,
            0.0995464648536423,0.0995464648536423,0.0995464648536423,0.0995464648536423,
            0.0995464648536423,0.0995464648536423,0.0989656803445779,0.0986172096391392,
            0.0985010527373263,0.0985010527373263,0.0985010527373263,0.0981525820318877,
            0.0980364251300748,0.0980364251300748,0.0980364251300748,0.0980364251300748,
            0.0980364251300748,0.0980364251300748,0.0980364251300748,0.0980364251300748,
            0.0980364251300748,0.097804111326449,0.0976879544246362,0.0976879544246362,
            0.0976879544246362,0.0976879544246362,0.0976879544246362,0.0976879544246362,
            0.0976879544246362,0.0976879544246362,0.0976879544246362,0.0976879544246362,
            0.0976879544246362,0.0976879544246362,0.0976879544246362,0.0976879544246362,
            0.0976879544246362,0.0976879544246362,0.0976879544246362,0.0976879544246362,
            0.0976879544246362,0.0965263854065073,0.0953648163883784,0.0946678749775011,
            0.0943194042720625,0.0942032473702496,0.0942032473702496,0.0942032473702496,
            0.0930416783521208,0.0923447369412434,0.0919962662358048,0.0918801093339919,
            0.0918801093339919,0.0918801093339919,0.0911831679231146,0.0908346972176759,
            0.0907185403158631,0.0907185403158631,0.0907185403158631,0.0903700696104244,
            0.0902539127086115,0.0902539127086115,0.0902539127086115,0.0902539127086115,
            0.0902539127086115,0.0902539127086115,0.0902539127086115,0.0902539127086115,
            0.0902539127086115,0.0892085005922956,0.0885115591814182,0.0881630884759796,
            0.0880469315741667,0.0880469315741667,0.0880469315741667,0.0873499901632894,
            0.0870015194578507,0.0868853625560379,0.0868853625560379,0.0868853625560379,
            0.0865368918505992,0.0864207349487863,0.0864207349487863,0.0864207349487863,
            0.0864207349487863,0.0864207349487863,0.0864207349487863,0.0864207349487863,
            0.0864207349487863,0.0864207349487863,0.0858399504397219,0.0854914797342832,
            0.0853753228324704,0.0853753228324704,0.0853753228324704,0.0850268521270317,
            0.0849106952252188,0.0849106952252188,0.0849106952252188,0.0849106952252188,
            0.0849106952252188,0.0849106952252188,0.0849106952252188,0.0849106952252188,
            0.0849106952252188,0.084678381421593,0.0845622245197802,0.0845622245197802,
            0.0845622245197802,0.0845622245197802,0.0845622245197802,0.0845622245197802,
            0.0845622245197802,0.0845622245197802,0.0845622245197802,0.0845622245197802,
            0.0845622245197802,0.0845622245197802,0.0845622245197802,0.0845622245197802,
            0.0845622245197802,0.0845622245197802,0.0845622245197802,0.0845622245197802,
            0.0845622245197802,0.0838652831089029,0.0831683416980255,0.0828198709925869,
            0.082703714090774,0.082703714090774,0.082703714090774,0.0820067726798967,
            0.081658301974458,0.0815421450726452,0.0815421450726452,0.0815421450726452,
            0.0811936743672065,0.0810775174653936,0.0810775174653936,0.0810775174653936,
            0.0810775174653936,0.0810775174653936,0.0810775174653936,0.0810775174653936,
            0.0810775174653936,0.0810775174653936,0.0804967329563292,0.0801482622508905,
            0.0800321053490776,0.0800321053490776,0.0800321053490776,0.079683634643639,
            0.0795674777418261,0.0795674777418261,0.0795674777418261,0.0795674777418261,
            0.0795674777418261,0.0795674777418261,0.0795674777418261,0.0795674777418261,
            0.0795674777418261,0.0793351639382003,0.0792190070363875,0.0792190070363875,
            0.0792190070363875,0.0792190070363875,0.0792190070363875,0.0792190070363875,
            0.0792190070363875,0.0792190070363875,0.0792190070363875,0.0792190070363875,
            0.0792190070363875,0.0792190070363875,0.0792190070363875,0.0792190070363875,
            0.0792190070363875,0.0792190070363875,0.0792190070363875,0.0792190070363875,
            0.0792190070363875,0.0788705363309488,0.0785220656255101,0.0784059087236973,
            0.0784059087236973,0.0784059087236973,0.0780574380182586,0.0779412811164457,
            0.0779412811164457,0.0779412811164457,0.0779412811164457,0.0779412811164457,
            0.0779412811164457,0.0779412811164457,0.0779412811164457,0.0779412811164457,
            0.07770896731282,0.0775928104110071,0.0775928104110071,0.0775928104110071,
            0.0775928104110071,0.0775928104110071,0.0775928104110071,0.0775928104110071,
            0.0775928104110071,0.0775928104110071,0.0775928104110071,0.0775928104110071,
            0.0775928104110071,0.0775928104110071,0.0775928104110071,0.0775928104110071,
            0.0775928104110071,0.0775928104110071,0.0775928104110071,0.0775928104110071,
            0.0774766535091942,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.0773604966073813,0.0773604966073813,
            0.0773604966073813,0.0773604966073813,0.075618143080188,0.0744565740620592,
            0.0737596326511819,0.0734111619457432,0.0732950050439303,0.0732950050439303,
            0.0732950050439303,0.0715526515167371,0.0703910824986082,0.0696941410877309,
            0.0693456703822923,0.0692295134804794,0.0692295134804794,0.0692295134804794,
            0.0680679444623505,0.0673710030514732,0.0670225323460345,0.0669063754442217,
            0.0669063754442217,0.0669063754442217,0.0662094340333444,0.0658609633279057,
            0.0657448064260928,0.0657448064260928,0.0657448064260928,0.0653963357206542,
            0.0652801788188413,0.0652801788188413,0.0652801788188413,0.0651640219170284,
            0.0651640219170284,0.0651640219170284,0.0651640219170284,0.0651640219170284,
            0.0651640219170284,0.063537825291648,0.0623762562735192,0.0616793148626418,
            0.0613308441572032,0.0612146872553903,0.0612146872553903,0.0612146872553903,
            0.0600531182372615,0.0593561768263842,0.0590077061209455,0.0588915492191326,
            0.0588915492191326,0.0588915492191326,0.0581946078082553,0.0578461371028166,
            0.0577299802010038,0.0577299802010038,0.0577299802010038,0.0573815094955651,
            0.0572653525937522,0.0572653525937522,0.0572653525937522,0.0571491956919393,
            0.0571491956919393,0.0571491956919393,0.0571491956919393,0.0571491956919393,
            0.0571491956919393,0.0561037835756234,0.0554068421647461,0.0550583714593074,
            0.0549422145574945,0.0549422145574945,0.0549422145574945,0.0542452731466172,
            0.0538968024411786,0.0537806455393657,0.0537806455393657,0.0537806455393657,
            0.053432174833927,0.0533160179321141,0.0533160179321141,0.0533160179321141,
            0.0531998610303013,0.0531998610303013,0.0531998610303013,0.0531998610303013,
            0.0531998610303013,0.0531998610303013,0.0526190765212368,0.0522706058157982,
            0.0521544489139853,0.0521544489139853,0.0521544489139853,0.0518059782085466,
            0.0516898213067338,0.0516898213067338,0.0516898213067338,0.0515736644049209,
            0.0515736644049209,0.0515736644049209,0.0515736644049209,0.0515736644049209,
            0.0515736644049209,0.0513413506012951,0.0512251936994822,0.0512251936994822,
            0.0512251936994822,0.0511090367976693,0.0511090367976693,0.0511090367976693,
            0.0511090367976693,0.0511090367976693,0.0511090367976693,0.0511090367976693,
            0.0511090367976693,0.0511090367976693,0.0511090367976693,0.0511090367976693,
            0.0511090367976693,0.0511090367976693,0.0511090367976693,0.0511090367976693,
            0.0511090367976693,0.0499474677795405,0.0487858987614116,0.0480889573505343,
            0.0477404866450957,0.0476243297432828,0.0476243297432828,0.0476243297432828,
            0.0464627607251539,0.0457658193142766,0.045417348608838,0.0453011917070251,
            0.0453011917070251,0.0453011917070251,0.0446042502961478,0.0442557795907091,
            0.0441396226888962,0.0441396226888962,0.0441396226888962,0.0437911519834576,
            0.0436749950816447,0.0436749950816447,0.0436749950816447,0.0435588381798318,
            0.0435588381798318,0.0435588381798318,0.0435588381798318,0.0435588381798318,
            0.0435588381798318,0.0425134260635159,0.0418164846526385,0.0414680139471999,
            0.041351857045387,0.041351857045387,0.041351857045387,0.0406549156345097,
            0.040306444929071,0.0401902880272582,0.0401902880272582,0.0401902880272582,
            0.0398418173218195,0.0397256604200066,0.0397256604200066,0.0397256604200066,
            0.0396095035181937,0.0396095035181937,0.0396095035181937,0.0396095035181937,
            0.0396095035181937,0.0396095035181937,0.0390287190091293,0.0386802483036906,
            0.0385640914018778,0.0385640914018778,0.0385640914018778,0.0382156206964391,
            0.0380994637946262,0.0380994637946262,0.0380994637946262,0.0379833068928133,
            0.0379833068928133,0.0379833068928133,0.0379833068928133,0.0379833068928133,
            0.0379833068928133,0.0377509930891876,0.0376348361873747,0.0376348361873747,
            0.0376348361873747,0.0375186792855618,0.0375186792855618,0.0375186792855618,
            0.0375186792855618,0.0375186792855618,0.0375186792855618,0.0375186792855618,
            0.0375186792855618,0.0375186792855618,0.0375186792855618,0.0375186792855618,
            0.0375186792855618,0.0375186792855618,0.0375186792855618,0.0375186792855618,
            0.0375186792855618,0.0368217378746845,0.0361247964638072,0.0357763257583685,
            0.0356601688565556,0.0356601688565556,0.0356601688565556,0.0349632274456783,
            0.0346147567402397,0.0344985998384268,0.0344985998384268,0.0344985998384268,
            0.0341501291329881,0.0340339722311753,0.0340339722311753,0.0340339722311753,
            0.0339178153293624,0.0339178153293624,0.0339178153293624,0.0339178153293624,
            0.0339178153293624,0.0339178153293624,0.0333370308202979,0.0329885601148593,
            0.0328724032130464,0.0328724032130464,0.0328724032130464,0.0325239325076078,
            0.0324077756057949,0.0324077756057949,0.0324077756057949,0.032291618703982,
            0.032291618703982,0.032291618703982,0.032291618703982,0.032291618703982,
            0.032291618703982,0.0320593049003562,0.0319431479985433,0.0319431479985433,
            0.0319431479985433,0.0318269910967304,0.0318269910967304,0.0318269910967304,
            0.0318269910967304,0.0318269910967304,0.0318269910967304,0.0318269910967304,
            0.0318269910967304,0.0318269910967304,0.0318269910967304,0.0318269910967304,
            0.0318269910967304,0.0318269910967304,0.0318269910967304,0.0318269910967304,
            0.0318269910967304,0.0314785203912918,0.0311300496858531,0.0310138927840403,
            0.0310138927840403,0.0310138927840403,0.0306654220786016,0.0305492651767887,
            0.0305492651767887,0.0305492651767887,0.0304331082749758,0.0304331082749758,
            0.0304331082749758,0.0304331082749758,0.0304331082749758,0.0304331082749758,
            0.0302007944713501,0.0300846375695372,0.0300846375695372,0.0300846375695372,
            0.0299684806677243,0.0299684806677243,0.0299684806677243,0.0299684806677243,
            0.0299684806677243,0.0299684806677243,0.0299684806677243,0.0299684806677243,
            0.0299684806677243,0.0299684806677243,0.0299684806677243,0.0299684806677243,
            0.0299684806677243,0.0299684806677243,0.0299684806677243,0.0299684806677243,
            0.0298523237659114,0.0297361668640985,0.0297361668640985,0.0297361668640985,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0296200099622856,
            0.0296200099622856,0.0296200099622856,0.0296200099622856,0.0284584409441568,
            0.0277614995332795,0.0274130288278408,0.0272968719260279,0.0272968719260279,
            0.0272968719260279,0.0261353029078991,0.0254383614970218,0.0250898907915831,
            0.0249737338897702,0.0249737338897702,0.0249737338897702,0.0242767924788929,
            0.0239283217734543,0.0238121648716414,0.0238121648716414,0.0238121648716414,
            0.0234636941662027,0.0233475372643899,0.0233475372643899,0.0233475372643899,
            0.023231380362577,0.023231380362577,0.023231380362577,0.023231380362577,
            0.023231380362577,0.023231380362577,0.022185968246261,0.0214890268353837,
            0.021140556129945,0.0210243992281322,0.0210243992281322,0.0210243992281322,
            0.0203274578172548,0.0199789871118162,0.0198628302100033,0.0198628302100033,
            0.0198628302100033,0.0195143595045647,0.0193982026027518,0.0193982026027518,
            0.0193982026027518,0.0192820457009389,0.0192820457009389,0.0192820457009389,
            0.0192820457009389,0.0192820457009389,0.0192820457009389,0.0187012611918745,
            0.0183527904864358,0.0182366335846229,0.0182366335846229,0.0182366335846229,
            0.0178881628791843,0.0177720059773714,0.0177720059773714,0.0177720059773714,
            0.0176558490755585,0.0176558490755585,0.0176558490755585,0.0176558490755585,
            0.0176558490755585,0.0176558490755585,0.0174235352719327,0.0173073783701198,
            0.0173073783701198,0.0173073783701198,0.017191221468307,0.017191221468307,
            0.017191221468307,0.017191221468307,0.017191221468307,0.017191221468307,
            0.017191221468307,0.017191221468307,0.017191221468307,0.017191221468307,
            0.017191221468307,0.017191221468307,0.017191221468307,0.017191221468307,
            0.017191221468307,0.017191221468307,0.0164942800574296,0.0157973386465523,
            0.0154488679411137,0.0153327110393008,0.0153327110393008,0.0153327110393008,
            0.0146357696284235,0.0142872989229848,0.0141711420211719,0.0141711420211719,
            0.0141711420211719,0.0138226713157333,0.0137065144139204,0.0137065144139204,
            0.0137065144139204,0.0135903575121075,0.0135903575121075,0.0135903575121075,
            0.0135903575121075,0.0135903575121075,0.0135903575121075,0.0130095730030431,
            0.0126611022976044,0.0125449453957916,0.0125449453957916,0.0125449453957916,
            0.0121964746903529,0.01208031778854,0.01208031778854,0.01208031778854,
            0.0119641608867271,0.0119641608867271,0.0119641608867271,0.0119641608867271,
            0.0119641608867271,0.0119641608867271,0.0117318470831014,0.0116156901812885,
            0.0116156901812885,0.0116156901812885,0.0114995332794756,0.0114995332794756,
            0.0114995332794756,0.0114995332794756,0.0114995332794756,0.0114995332794756,
            0.0114995332794756,0.0114995332794756,0.0114995332794756,0.0114995332794756,
            0.0114995332794756,0.0114995332794756,0.0114995332794756,0.0114995332794756,
            0.0114995332794756,0.0114995332794756,0.0111510625740369,0.0108025918685983,
            0.0106864349667854,0.0106864349667854,0.0106864349667854,0.0103379642613467,
            0.0102218073595339,0.0102218073595339,0.0102218073595339,0.010105650457721,
            0.010105650457721,0.010105650457721,0.010105650457721,0.010105650457721,
            0.010105650457721,0.00987333665409521,0.00975717975228233,0.00975717975228233,
            0.00975717975228233,0.00964102285046944,0.00964102285046944,0.00964102285046944,
            0.00964102285046944,0.00964102285046944,0.00964102285046944,0.00964102285046944,
            0.00964102285046944,0.00964102285046944,0.00964102285046944,0.00964102285046944,
            0.00964102285046944,0.00964102285046944,0.00964102285046944,0.00964102285046944,
            0.00964102285046944,0.00952486594865656,0.00940870904684367,0.00940870904684367,
            0.00940870904684367,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00929255214503079,0.00929255214503079,0.00929255214503079,0.00929255214503079,
            0.00859561073415348,0.00824714002871482,0.00813098312690194,0.00813098312690194,
            0.00813098312690194,0.00743404171602463,0.00708557101058597,0.00696941410877309,
            0.00696941410877309,0.00696941410877309,0.00662094340333444,0.00650478650152155,
            0.00650478650152155,0.00650478650152155,0.00638862959970867,0.00638862959970867,
            0.00638862959970867,0.00638862959970867,0.00638862959970867,0.00638862959970867,
            0.00580784509064424,0.00545937438520559,0.0053432174833927,0.0053432174833927,
            0.0053432174833927,0.00499474677795405,0.00487858987614116,0.00487858987614116,
            0.00487858987614116,0.00476243297432828,0.00476243297432828,0.00476243297432828,
            0.00476243297432828,0.00476243297432828,0.00476243297432828,0.00453011917070251,
            0.00441396226888962,0.00441396226888962,0.00441396226888962,0.00429780536707674,
            0.00429780536707674,0.00429780536707674,0.00429780536707674,0.00429780536707674,
            0.00429780536707674,0.00429780536707674,0.00429780536707674,0.00429780536707674,
            0.00429780536707674,0.00429780536707674,0.00429780536707674,0.00429780536707674,
            0.00429780536707674,0.00429780536707674,0.00429780536707674,0.00394933466163808,
            0.00360086395619943,0.00348470705438655,0.00348470705438655,0.00348470705438655,
            0.00313623634894789,0.00302007944713501,0.00302007944713501,0.00302007944713501,
            0.00290392254532212,0.00290392254532212,0.00290392254532212,0.00290392254532212,
            0.00290392254532212,0.00290392254532212,0.00267160874169635,0.00255545183988347,
            0.00255545183988347,0.00255545183988347,0.00243929493807058,0.00243929493807058,
            0.00243929493807058,0.00243929493807058,0.00243929493807058,0.00243929493807058,
            0.00243929493807058,0.00243929493807058,0.00243929493807058,0.00243929493807058,
            0.00243929493807058,0.00243929493807058,0.00243929493807058,0.00243929493807058,
            0.00243929493807058,0.00243929493807058,0.0023231380362577,0.00220698113444481,
            0.00220698113444481,0.00220698113444481,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00209082423263193,0.00209082423263193,0.00209082423263193,
            0.00209082423263193,0.00174235352719327,0.00162619662538039,0.00162619662538039,
            0.00162619662538039,0.00127772591994173,0.00116156901812885,0.00116156901812885,
            0.00116156901812885,0.00104541211631596,0.00104541211631596,0.00104541211631596,
            0.00104541211631596,0.00104541211631596,0.00104541211631596,0.000813098312690194,
            0.000696941410877309,0.000696941410877309,0.000696941410877309,0.000580784509064424,
            0.000580784509064424,0.000580784509064424,0.000580784509064424,0.000580784509064424,
            0.000580784509064424,0.000580784509064424,0.000580784509064424,0.000580784509064424,
            0.000580784509064424,0.000580784509064424,0.000580784509064424,0.000580784509064424,
            0.000580784509064424,0.000580784509064424,0.000580784509064424,0.000464627607251539,
            0.000348470705438655,0.000348470705438655,0.000348470705438655,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.00023231380362577,0.00023231380362577,
            0.00023231380362577,0.00023231380362577,0.000116156901812885,0.000116156901812885,
            0.000116156901812885,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0,0.0,0.0,
            0.0,0.0
        ]
    
    class Six:
        # Convert to binary representation for six-card evaluator
        # card_to_binary[rank][suit]
        card_to_binary = [[], [],
            [0, 73730, 77826, 86018, 94210],
            [0, 139523, 143619, 151811, 160003],
            [0, 270853, 274949, 283141, 291333],
            [0, 533255, 537351, 545543, 553735],
            [0, 1057803, 1061899, 1070091, 1078283],
            [0, 2106637, 2110733, 2118925, 2127117],
            [0, 4204049, 4208145, 4216337, 4224529],
            [0, 8398611, 8402707, 8410899, 8419091],
            [0, 16787479, 16791575, 16799767, 16807959],
            [0, 33564957, 33569053, 33577245, 33585437],
            [0, 67119647, 67123743, 67131935, 67140127],
            [0, 134228773, 134232869, 134241061, 134249253],
            [0, 268446761, 268450857, 268459049, 268467241]
        ]
        
        # Given the product of prime values of suits (2,3,5,7) corresponding to
        # (s,h,d,c) in a 6-card hand, if the value is in this set you have a flush.
        prime_products_to_flush = {
            # spades
            64:2, 96:2, 160:2, 224:2,
            # hearts
            486:3, 729:3, 1215:3, 1701:3,
            # diamonds
            6250:5, 9375:5, 15625:5, 21875:5,
            # clubs
            33614:7, 50421:7, 84035:7, 117649:7
        }
        
        flush_rank_bits_to_rank = {
            31: 9, 47: 1599, 55: 1598, 59: 1597,
            61: 1596, 62: 8, 63: 8, 79: 1595,
            87: 1594, 91: 1593, 93: 1592, 94: 1591,
            95: 9, 103: 1590, 107: 1589, 109: 1588,
            110: 1587, 111: 1587, 115: 1586, 117: 1585,
            118: 1584, 119: 1584, 121: 1583, 122: 1582,
            123: 1582, 124: 7, 125: 7, 126: 7,
            143: 1581, 151: 1580, 155: 1579, 157: 1578,
            158: 1577, 159: 9, 167: 1576, 171: 1575,
            173: 1574, 174: 1573, 175: 1573, 179: 1572,
            181: 1571, 182: 1570, 183: 1570, 185: 1569,
            186: 1568, 187: 1568, 188: 1567, 189: 1567,
            190: 8, 199: 1566, 203: 1565, 205: 1564,
            206: 1563, 207: 1563, 211: 1562, 213: 1561,
            214: 1560, 215: 1560, 217: 1559, 218: 1558,
            219: 1558, 220: 1557, 221: 1557, 222: 1557,
            227: 1556, 229: 1555, 230: 1554, 231: 1554,
            233: 1553, 234: 1552, 235: 1552, 236: 1551,
            237: 1551, 238: 1551, 241: 1550, 242: 1549,
            243: 1549, 244: 1548, 245: 1548, 246: 1548,
            248: 6, 249: 6, 250: 6, 252: 6,
            271: 1547, 279: 1546, 283: 1545, 285: 1544,
            286: 1543, 287: 9, 295: 1542, 299: 1541,
            301: 1540, 302: 1539, 303: 1539, 307: 1538,
            309: 1537, 310: 1536, 311: 1536, 313: 1535,
            314: 1534, 315: 1534, 316: 1533, 317: 1533,
            318: 8, 327: 1532, 331: 1531, 333: 1530,
            334: 1529, 335: 1529, 339: 1528, 341: 1527,
            342: 1526, 343: 1526, 345: 1525, 346: 1524,
            347: 1524, 348: 1523, 349: 1523, 350: 1523,
            355: 1522, 357: 1521, 358: 1520, 359: 1520,
            361: 1519, 362: 1518, 363: 1518, 364: 1517,
            365: 1517, 366: 1517, 369: 1516, 370: 1515,
            371: 1515, 372: 1514, 373: 1514, 374: 1514,
            376: 1513, 377: 1513, 378: 1513, 380: 7,
            391: 1512, 395: 1511, 397: 1510, 398: 1509,
            399: 1509, 403: 1508, 405: 1507, 406: 1506,
            407: 1506, 409: 1505, 410: 1504, 411: 1504,
            412: 1503, 413: 1503, 414: 1503, 419: 1502,
            421: 1501, 422: 1500, 423: 1500, 425: 1499,
            426: 1498, 427: 1498, 428: 1497, 429: 1497,
            430: 1497, 433: 1496, 434: 1495, 435: 1495,
            436: 1494, 437: 1494, 438: 1494, 440: 1493,
            441: 1493, 442: 1493, 444: 1493, 451: 1492,
            453: 1491, 454: 1490, 455: 1490, 457: 1489,
            458: 1488, 459: 1488, 460: 1487, 461: 1487,
            462: 1487, 465: 1486, 466: 1485, 467: 1485,
            468: 1484, 469: 1484, 470: 1484, 472: 1483,
            473: 1483, 474: 1483, 476: 1483, 481: 1482,
            482: 1481, 483: 1481, 484: 1480, 485: 1480,
            486: 1480, 488: 1479, 489: 1479, 490: 1479,
            492: 1479, 496: 5, 497: 5, 498: 5,
            500: 5, 504: 5, 527: 1478, 535: 1477,
            539: 1476, 541: 1475, 542: 1474, 543: 9,
            551: 1473, 555: 1472, 557: 1471, 558: 1470,
            559: 1470, 563: 1469, 565: 1468, 566: 1467,
            567: 1467, 569: 1466, 570: 1465, 571: 1465,
            572: 1464, 573: 1464, 574: 8, 583: 1463,
            587: 1462, 589: 1461, 590: 1460, 591: 1460,
            595: 1459, 597: 1458, 598: 1457, 599: 1457,
            601: 1456, 602: 1455, 603: 1455, 604: 1454,
            605: 1454, 606: 1454, 611: 1453, 613: 1452,
            614: 1451, 615: 1451, 617: 1450, 618: 1449,
            619: 1449, 620: 1448, 621: 1448, 622: 1448,
            625: 1447, 626: 1446, 627: 1446, 628: 1445,
            629: 1445, 630: 1445, 632: 1444, 633: 1444,
            634: 1444, 636: 7, 647: 1443, 651: 1442,
            653: 1441, 654: 1440, 655: 1440, 659: 1439,
            661: 1438, 662: 1437, 663: 1437, 665: 1436,
            666: 1435, 667: 1435, 668: 1434, 669: 1434,
            670: 1434, 675: 1433, 677: 1432, 678: 1431,
            679: 1431, 681: 1430, 682: 1429, 683: 1429,
            684: 1428, 685: 1428, 686: 1428, 689: 1427,
            690: 1426, 691: 1426, 692: 1425, 693: 1425,
            694: 1425, 696: 1424, 697: 1424, 698: 1424,
            700: 1424, 707: 1423, 709: 1422, 710: 1421,
            711: 1421, 713: 1420, 714: 1419, 715: 1419,
            716: 1418, 717: 1418, 718: 1418, 721: 1417,
            722: 1416, 723: 1416, 724: 1415, 725: 1415,
            726: 1415, 728: 1414, 729: 1414, 730: 1414,
            732: 1414, 737: 1413, 738: 1412, 739: 1412,
            740: 1411, 741: 1411, 742: 1411, 744: 1410,
            745: 1410, 746: 1410, 748: 1410, 752: 1409,
            753: 1409, 754: 1409, 756: 1409, 760: 6,
            775: 1408, 779: 1407, 781: 1406, 782: 1405,
            783: 1405, 787: 1404, 789: 1403, 790: 1402,
            791: 1402, 793: 1401, 794: 1400, 795: 1400,
            796: 1399, 797: 1399, 798: 1399, 803: 1398,
            805: 1397, 806: 1396, 807: 1396, 809: 1395,
            810: 1394, 811: 1394, 812: 1393, 813: 1393,
            814: 1393, 817: 1392, 818: 1391, 819: 1391,
            820: 1390, 821: 1390, 822: 1390, 824: 1389,
            825: 1389, 826: 1389, 828: 1389, 835: 1388,
            837: 1387, 838: 1386, 839: 1386, 841: 1385,
            842: 1384, 843: 1384, 844: 1383, 845: 1383,
            846: 1383, 849: 1382, 850: 1381, 851: 1381,
            852: 1380, 853: 1380, 854: 1380, 856: 1379,
            857: 1379, 858: 1379, 860: 1379, 865: 1378,
            866: 1377, 867: 1377, 868: 1376, 869: 1376,
            870: 1376, 872: 1375, 873: 1375, 874: 1375,
            876: 1375, 880: 1374, 881: 1374, 882: 1374,
            884: 1374, 888: 1374, 899: 1373, 901: 1372,
            902: 1371, 903: 1371, 905: 1370, 906: 1369,
            907: 1369, 908: 1368, 909: 1368, 910: 1368,
            913: 1367, 914: 1366, 915: 1366, 916: 1365,
            917: 1365, 918: 1365, 920: 1364, 921: 1364,
            922: 1364, 924: 1364, 929: 1363, 930: 1362,
            931: 1362, 932: 1361, 933: 1361, 934: 1361,
            936: 1360, 937: 1360, 938: 1360, 940: 1360,
            944: 1359, 945: 1359, 946: 1359, 948: 1359,
            952: 1359, 961: 1358, 962: 1357, 963: 1357,
            964: 1356, 965: 1356, 966: 1356, 968: 1355,
            969: 1355, 970: 1355, 972: 1355, 976: 1354,
            977: 1354, 978: 1354, 980: 1354, 984: 1354,
            992: 4, 993: 4, 994: 4, 996: 4,
            1000: 4, 1008: 4, 1039: 1353, 1047: 1352,
            1051: 1351, 1053: 1350, 1054: 1349, 1055: 9,
            1063: 1348, 1067: 1347, 1069: 1346, 1070: 1345,
            1071: 1345, 1075: 1344, 1077: 1343, 1078: 1342,
            1079: 1342, 1081: 1341, 1082: 1340, 1083: 1340,
            1084: 1339, 1085: 1339, 1086: 8, 1095: 1338,
            1099: 1337, 1101: 1336, 1102: 1335, 1103: 1335,
            1107: 1334, 1109: 1333, 1110: 1332, 1111: 1332,
            1113: 1331, 1114: 1330, 1115: 1330, 1116: 1329,
            1117: 1329, 1118: 1329, 1123: 1328, 1125: 1327,
            1126: 1326, 1127: 1326, 1129: 1325, 1130: 1324,
            1131: 1324, 1132: 1323, 1133: 1323, 1134: 1323,
            1137: 1322, 1138: 1321, 1139: 1321, 1140: 1320,
            1141: 1320, 1142: 1320, 1144: 1319, 1145: 1319,
            1146: 1319, 1148: 7, 1159: 1318, 1163: 1317,
            1165: 1316, 1166: 1315, 1167: 1315, 1171: 1314,
            1173: 1313, 1174: 1312, 1175: 1312, 1177: 1311,
            1178: 1310, 1179: 1310, 1180: 1309, 1181: 1309,
            1182: 1309, 1187: 1308, 1189: 1307, 1190: 1306,
            1191: 1306, 1193: 1305, 1194: 1304, 1195: 1304,
            1196: 1303, 1197: 1303, 1198: 1303, 1201: 1302,
            1202: 1301, 1203: 1301, 1204: 1300, 1205: 1300,
            1206: 1300, 1208: 1299, 1209: 1299, 1210: 1299,
            1212: 1299, 1219: 1298, 1221: 1297, 1222: 1296,
            1223: 1296, 1225: 1295, 1226: 1294, 1227: 1294,
            1228: 1293, 1229: 1293, 1230: 1293, 1233: 1292,
            1234: 1291, 1235: 1291, 1236: 1290, 1237: 1290,
            1238: 1290, 1240: 1289, 1241: 1289, 1242: 1289,
            1244: 1289, 1249: 1288, 1250: 1287, 1251: 1287,
            1252: 1286, 1253: 1286, 1254: 1286, 1256: 1285,
            1257: 1285, 1258: 1285, 1260: 1285, 1264: 1284,
            1265: 1284, 1266: 1284, 1268: 1284, 1272: 6,
            1287: 1283, 1291: 1282, 1293: 1281, 1294: 1280,
            1295: 1280, 1299: 1279, 1301: 1278, 1302: 1277,
            1303: 1277, 1305: 1276, 1306: 1275, 1307: 1275,
            1308: 1274, 1309: 1274, 1310: 1274, 1315: 1273,
            1317: 1272, 1318: 1271, 1319: 1271, 1321: 1270,
            1322: 1269, 1323: 1269, 1324: 1268, 1325: 1268,
            1326: 1268, 1329: 1267, 1330: 1266, 1331: 1266,
            1332: 1265, 1333: 1265, 1334: 1265, 1336: 1264,
            1337: 1264, 1338: 1264, 1340: 1264, 1347: 1263,
            1349: 1262, 1350: 1261, 1351: 1261, 1353: 1260,
            1354: 1259, 1355: 1259, 1356: 1258, 1357: 1258,
            1358: 1258, 1361: 1257, 1362: 1256, 1363: 1256,
            1364: 1255, 1365: 1255, 1366: 1255, 1368: 1254,
            1369: 1254, 1370: 1254, 1372: 1254, 1377: 1253,
            1378: 1252, 1379: 1252, 1380: 1251, 1381: 1251,
            1382: 1251, 1384: 1250, 1385: 1250, 1386: 1250,
            1388: 1250, 1392: 1249, 1393: 1249, 1394: 1249,
            1396: 1249, 1400: 1249, 1411: 1248, 1413: 1247,
            1414: 1246, 1415: 1246, 1417: 1245, 1418: 1244,
            1419: 1244, 1420: 1243, 1421: 1243, 1422: 1243,
            1425: 1242, 1426: 1241, 1427: 1241, 1428: 1240,
            1429: 1240, 1430: 1240, 1432: 1239, 1433: 1239,
            1434: 1239, 1436: 1239, 1441: 1238, 1442: 1237,
            1443: 1237, 1444: 1236, 1445: 1236, 1446: 1236,
            1448: 1235, 1449: 1235, 1450: 1235, 1452: 1235,
            1456: 1234, 1457: 1234, 1458: 1234, 1460: 1234,
            1464: 1234, 1473: 1233, 1474: 1232, 1475: 1232,
            1476: 1231, 1477: 1231, 1478: 1231, 1480: 1230,
            1481: 1230, 1482: 1230, 1484: 1230, 1488: 1229,
            1489: 1229, 1490: 1229, 1492: 1229, 1496: 1229,
            1504: 1228, 1505: 1228, 1506: 1228, 1508: 1228,
            1512: 1228, 1520: 5, 1543: 1227, 1547: 1226,
            1549: 1225, 1550: 1224, 1551: 1224, 1555: 1223,
            1557: 1222, 1558: 1221, 1559: 1221, 1561: 1220,
            1562: 1219, 1563: 1219, 1564: 1218, 1565: 1218,
            1566: 1218, 1571: 1217, 1573: 1216, 1574: 1215,
            1575: 1215, 1577: 1214, 1578: 1213, 1579: 1213,
            1580: 1212, 1581: 1212, 1582: 1212, 1585: 1211,
            1586: 1210, 1587: 1210, 1588: 1209, 1589: 1209,
            1590: 1209, 1592: 1208, 1593: 1208, 1594: 1208,
            1596: 1208, 1603: 1207, 1605: 1206, 1606: 1205,
            1607: 1205, 1609: 1204, 1610: 1203, 1611: 1203,
            1612: 1202, 1613: 1202, 1614: 1202, 1617: 1201,
            1618: 1200, 1619: 1200, 1620: 1199, 1621: 1199,
            1622: 1199, 1624: 1198, 1625: 1198, 1626: 1198,
            1628: 1198, 1633: 1197, 1634: 1196, 1635: 1196,
            1636: 1195, 1637: 1195, 1638: 1195, 1640: 1194,
            1641: 1194, 1642: 1194, 1644: 1194, 1648: 1193,
            1649: 1193, 1650: 1193, 1652: 1193, 1656: 1193,
            1667: 1192, 1669: 1191, 1670: 1190, 1671: 1190,
            1673: 1189, 1674: 1188, 1675: 1188, 1676: 1187,
            1677: 1187, 1678: 1187, 1681: 1186, 1682: 1185,
            1683: 1185, 1684: 1184, 1685: 1184, 1686: 1184,
            1688: 1183, 1689: 1183, 1690: 1183, 1692: 1183,
            1697: 1182, 1698: 1181, 1699: 1181, 1700: 1180,
            1701: 1180, 1702: 1180, 1704: 1179, 1705: 1179,
            1706: 1179, 1708: 1179, 1712: 1178, 1713: 1178,
            1714: 1178, 1716: 1178, 1720: 1178, 1729: 1177,
            1730: 1176, 1731: 1176, 1732: 1175, 1733: 1175,
            1734: 1175, 1736: 1174, 1737: 1174, 1738: 1174,
            1740: 1174, 1744: 1173, 1745: 1173, 1746: 1173,
            1748: 1173, 1752: 1173, 1760: 1172, 1761: 1172,
            1762: 1172, 1764: 1172, 1768: 1172, 1776: 1172,
            1795: 1171, 1797: 1170, 1798: 1169, 1799: 1169,
            1801: 1168, 1802: 1167, 1803: 1167, 1804: 1166,
            1805: 1166, 1806: 1166, 1809: 1165, 1810: 1164,
            1811: 1164, 1812: 1163, 1813: 1163, 1814: 1163,
            1816: 1162, 1817: 1162, 1818: 1162, 1820: 1162,
            1825: 1161, 1826: 1160, 1827: 1160, 1828: 1159,
            1829: 1159, 1830: 1159, 1832: 1158, 1833: 1158,
            1834: 1158, 1836: 1158, 1840: 1157, 1841: 1157,
            1842: 1157, 1844: 1157, 1848: 1157, 1857: 1156,
            1858: 1155, 1859: 1155, 1860: 1154, 1861: 1154,
            1862: 1154, 1864: 1153, 1865: 1153, 1866: 1153,
            1868: 1153, 1872: 1152, 1873: 1152, 1874: 1152,
            1876: 1152, 1880: 1152, 1888: 1151, 1889: 1151,
            1890: 1151, 1892: 1151, 1896: 1151, 1904: 1151,
            1921: 1150, 1922: 1149, 1923: 1149, 1924: 1148,
            1925: 1148, 1926: 1148, 1928: 1147, 1929: 1147,
            1930: 1147, 1932: 1147, 1936: 1146, 1937: 1146,
            1938: 1146, 1940: 1146, 1944: 1146, 1952: 1145,
            1953: 1145, 1954: 1145, 1956: 1145, 1960: 1145,
            1968: 1145, 1984: 3, 1985: 3, 1986: 3,
            1988: 3, 1992: 3, 2000: 3, 2016: 3,
            2063: 1144, 2071: 1143, 2075: 1142, 2077: 1141,
            2078: 1140, 2079: 9, 2087: 1139, 2091: 1138,
            2093: 1137, 2094: 1136, 2095: 1136, 2099: 1135,
            2101: 1134, 2102: 1133, 2103: 1133, 2105: 1132,
            2106: 1131, 2107: 1131, 2108: 1130, 2109: 1130,
            2110: 8, 2119: 1129, 2123: 1128, 2125: 1127,
            2126: 1126, 2127: 1126, 2131: 1125, 2133: 1124,
            2134: 1123, 2135: 1123, 2137: 1122, 2138: 1121,
            2139: 1121, 2140: 1120, 2141: 1120, 2142: 1120,
            2147: 1119, 2149: 1118, 2150: 1117, 2151: 1117,
            2153: 1116, 2154: 1115, 2155: 1115, 2156: 1114,
            2157: 1114, 2158: 1114, 2161: 1113, 2162: 1112,
            2163: 1112, 2164: 1111, 2165: 1111, 2166: 1111,
            2168: 1110, 2169: 1110, 2170: 1110, 2172: 7,
            2183: 1109, 2187: 1108, 2189: 1107, 2190: 1106,
            2191: 1106, 2195: 1105, 2197: 1104, 2198: 1103,
            2199: 1103, 2201: 1102, 2202: 1101, 2203: 1101,
            2204: 1100, 2205: 1100, 2206: 1100, 2211: 1099,
            2213: 1098, 2214: 1097, 2215: 1097, 2217: 1096,
            2218: 1095, 2219: 1095, 2220: 1094, 2221: 1094,
            2222: 1094, 2225: 1093, 2226: 1092, 2227: 1092,
            2228: 1091, 2229: 1091, 2230: 1091, 2232: 1090,
            2233: 1090, 2234: 1090, 2236: 1090, 2243: 1089,
            2245: 1088, 2246: 1087, 2247: 1087, 2249: 1086,
            2250: 1085, 2251: 1085, 2252: 1084, 2253: 1084,
            2254: 1084, 2257: 1083, 2258: 1082, 2259: 1082,
            2260: 1081, 2261: 1081, 2262: 1081, 2264: 1080,
            2265: 1080, 2266: 1080, 2268: 1080, 2273: 1079,
            2274: 1078, 2275: 1078, 2276: 1077, 2277: 1077,
            2278: 1077, 2280: 1076, 2281: 1076, 2282: 1076,
            2284: 1076, 2288: 1075, 2289: 1075, 2290: 1075,
            2292: 1075, 2296: 6, 2311: 1074, 2315: 1073,
            2317: 1072, 2318: 1071, 2319: 1071, 2323: 1070,
            2325: 1069, 2326: 1068, 2327: 1068, 2329: 1067,
            2330: 1066, 2331: 1066, 2332: 1065, 2333: 1065,
            2334: 1065, 2339: 1064, 2341: 1063, 2342: 1062,
            2343: 1062, 2345: 1061, 2346: 1060, 2347: 1060,
            2348: 1059, 2349: 1059, 2350: 1059, 2353: 1058,
            2354: 1057, 2355: 1057, 2356: 1056, 2357: 1056,
            2358: 1056, 2360: 1055, 2361: 1055, 2362: 1055,
            2364: 1055, 2371: 1054, 2373: 1053, 2374: 1052,
            2375: 1052, 2377: 1051, 2378: 1050, 2379: 1050,
            2380: 1049, 2381: 1049, 2382: 1049, 2385: 1048,
            2386: 1047, 2387: 1047, 2388: 1046, 2389: 1046,
            2390: 1046, 2392: 1045, 2393: 1045, 2394: 1045,
            2396: 1045, 2401: 1044, 2402: 1043, 2403: 1043,
            2404: 1042, 2405: 1042, 2406: 1042, 2408: 1041,
            2409: 1041, 2410: 1041, 2412: 1041, 2416: 1040,
            2417: 1040, 2418: 1040, 2420: 1040, 2424: 1040,
            2435: 1039, 2437: 1038, 2438: 1037, 2439: 1037,
            2441: 1036, 2442: 1035, 2443: 1035, 2444: 1034,
            2445: 1034, 2446: 1034, 2449: 1033, 2450: 1032,
            2451: 1032, 2452: 1031, 2453: 1031, 2454: 1031,
            2456: 1030, 2457: 1030, 2458: 1030, 2460: 1030,
            2465: 1029, 2466: 1028, 2467: 1028, 2468: 1027,
            2469: 1027, 2470: 1027, 2472: 1026, 2473: 1026,
            2474: 1026, 2476: 1026, 2480: 1025, 2481: 1025,
            2482: 1025, 2484: 1025, 2488: 1025, 2497: 1024,
            2498: 1023, 2499: 1023, 2500: 1022, 2501: 1022,
            2502: 1022, 2504: 1021, 2505: 1021, 2506: 1021,
            2508: 1021, 2512: 1020, 2513: 1020, 2514: 1020,
            2516: 1020, 2520: 1020, 2528: 1019, 2529: 1019,
            2530: 1019, 2532: 1019, 2536: 1019, 2544: 5,
            2567: 1018, 2571: 1017, 2573: 1016, 2574: 1015,
            2575: 1015, 2579: 1014, 2581: 1013, 2582: 1012,
            2583: 1012, 2585: 1011, 2586: 1010, 2587: 1010,
            2588: 1009, 2589: 1009, 2590: 1009, 2595: 1008,
            2597: 1007, 2598: 1006, 2599: 1006, 2601: 1005,
            2602: 1004, 2603: 1004, 2604: 1003, 2605: 1003,
            2606: 1003, 2609: 1002, 2610: 1001, 2611: 1001,
            2612: 1000, 2613: 1000, 2614: 1000, 2616: 999,
            2617: 999, 2618: 999, 2620: 999, 2627: 998,
            2629: 997, 2630: 996, 2631: 996, 2633: 995,
            2634: 994, 2635: 994, 2636: 993, 2637: 993,
            2638: 993, 2641: 992, 2642: 991, 2643: 991,
            2644: 990, 2645: 990, 2646: 990, 2648: 989,
            2649: 989, 2650: 989, 2652: 989, 2657: 988,
            2658: 987, 2659: 987, 2660: 986, 2661: 986,
            2662: 986, 2664: 985, 2665: 985, 2666: 985,
            2668: 985, 2672: 984, 2673: 984, 2674: 984,
            2676: 984, 2680: 984, 2691: 983, 2693: 982,
            2694: 981, 2695: 981, 2697: 980, 2698: 979,
            2699: 979, 2700: 978, 2701: 978, 2702: 978,
            2705: 977, 2706: 976, 2707: 976, 2708: 975,
            2709: 975, 2710: 975, 2712: 974, 2713: 974,
            2714: 974, 2716: 974, 2721: 973, 2722: 972,
            2723: 972, 2724: 971, 2725: 971, 2726: 971,
            2728: 970, 2729: 970, 2730: 970, 2732: 970,
            2736: 969, 2737: 969, 2738: 969, 2740: 969,
            2744: 969, 2753: 968, 2754: 967, 2755: 967,
            2756: 966, 2757: 966, 2758: 966, 2760: 965,
            2761: 965, 2762: 965, 2764: 965, 2768: 964,
            2769: 964, 2770: 964, 2772: 964, 2776: 964,
            2784: 963, 2785: 963, 2786: 963, 2788: 963,
            2792: 963, 2800: 963, 2819: 962, 2821: 961,
            2822: 960, 2823: 960, 2825: 959, 2826: 958,
            2827: 958, 2828: 957, 2829: 957, 2830: 957,
            2833: 956, 2834: 955, 2835: 955, 2836: 954,
            2837: 954, 2838: 954, 2840: 953, 2841: 953,
            2842: 953, 2844: 953, 2849: 952, 2850: 951,
            2851: 951, 2852: 950, 2853: 950, 2854: 950,
            2856: 949, 2857: 949, 2858: 949, 2860: 949,
            2864: 948, 2865: 948, 2866: 948, 2868: 948,
            2872: 948, 2881: 947, 2882: 946, 2883: 946,
            2884: 945, 2885: 945, 2886: 945, 2888: 944,
            2889: 944, 2890: 944, 2892: 944, 2896: 943,
            2897: 943, 2898: 943, 2900: 943, 2904: 943,
            2912: 942, 2913: 942, 2914: 942, 2916: 942,
            2920: 942, 2928: 942, 2945: 941, 2946: 940,
            2947: 940, 2948: 939, 2949: 939, 2950: 939,
            2952: 938, 2953: 938, 2954: 938, 2956: 938,
            2960: 937, 2961: 937, 2962: 937, 2964: 937,
            2968: 937, 2976: 936, 2977: 936, 2978: 936,
            2980: 936, 2984: 936, 2992: 936, 3008: 935,
            3009: 935, 3010: 935, 3012: 935, 3016: 935,
            3024: 935, 3040: 4, 3079: 934, 3083: 933,
            3085: 932, 3086: 931, 3087: 931, 3091: 930,
            3093: 929, 3094: 928, 3095: 928, 3097: 927,
            3098: 926, 3099: 926, 3100: 925, 3101: 925,
            3102: 925, 3107: 924, 3109: 923, 3110: 922,
            3111: 922, 3113: 921, 3114: 920, 3115: 920,
            3116: 919, 3117: 919, 3118: 919, 3121: 918,
            3122: 917, 3123: 917, 3124: 916, 3125: 916,
            3126: 916, 3128: 915, 3129: 915, 3130: 915,
            3132: 915, 3139: 914, 3141: 913, 3142: 912,
            3143: 912, 3145: 911, 3146: 910, 3147: 910,
            3148: 909, 3149: 909, 3150: 909, 3153: 908,
            3154: 907, 3155: 907, 3156: 906, 3157: 906,
            3158: 906, 3160: 905, 3161: 905, 3162: 905,
            3164: 905, 3169: 904, 3170: 903, 3171: 903,
            3172: 902, 3173: 902, 3174: 902, 3176: 901,
            3177: 901, 3178: 901, 3180: 901, 3184: 900,
            3185: 900, 3186: 900, 3188: 900, 3192: 900,
            3203: 899, 3205: 898, 3206: 897, 3207: 897,
            3209: 896, 3210: 895, 3211: 895, 3212: 894,
            3213: 894, 3214: 894, 3217: 893, 3218: 892,
            3219: 892, 3220: 891, 3221: 891, 3222: 891,
            3224: 890, 3225: 890, 3226: 890, 3228: 890,
            3233: 889, 3234: 888, 3235: 888, 3236: 887,
            3237: 887, 3238: 887, 3240: 886, 3241: 886,
            3242: 886, 3244: 886, 3248: 885, 3249: 885,
            3250: 885, 3252: 885, 3256: 885, 3265: 884,
            3266: 883, 3267: 883, 3268: 882, 3269: 882,
            3270: 882, 3272: 881, 3273: 881, 3274: 881,
            3276: 881, 3280: 880, 3281: 880, 3282: 880,
            3284: 880, 3288: 880, 3296: 879, 3297: 879,
            3298: 879, 3300: 879, 3304: 879, 3312: 879,
            3331: 878, 3333: 877, 3334: 876, 3335: 876,
            3337: 875, 3338: 874, 3339: 874, 3340: 873,
            3341: 873, 3342: 873, 3345: 872, 3346: 871,
            3347: 871, 3348: 870, 3349: 870, 3350: 870,
            3352: 869, 3353: 869, 3354: 869, 3356: 869,
            3361: 868, 3362: 867, 3363: 867, 3364: 866,
            3365: 866, 3366: 866, 3368: 865, 3369: 865,
            3370: 865, 3372: 865, 3376: 864, 3377: 864,
            3378: 864, 3380: 864, 3384: 864, 3393: 863,
            3394: 862, 3395: 862, 3396: 861, 3397: 861,
            3398: 861, 3400: 860, 3401: 860, 3402: 860,
            3404: 860, 3408: 859, 3409: 859, 3410: 859,
            3412: 859, 3416: 859, 3424: 858, 3425: 858,
            3426: 858, 3428: 858, 3432: 858, 3440: 858,
            3457: 857, 3458: 856, 3459: 856, 3460: 855,
            3461: 855, 3462: 855, 3464: 854, 3465: 854,
            3466: 854, 3468: 854, 3472: 853, 3473: 853,
            3474: 853, 3476: 853, 3480: 853, 3488: 852,
            3489: 852, 3490: 852, 3492: 852, 3496: 852,
            3504: 852, 3520: 851, 3521: 851, 3522: 851,
            3524: 851, 3528: 851, 3536: 851, 3552: 851,
            3587: 850, 3589: 849, 3590: 848, 3591: 848,
            3593: 847, 3594: 846, 3595: 846, 3596: 845,
            3597: 845, 3598: 845, 3601: 844, 3602: 843,
            3603: 843, 3604: 842, 3605: 842, 3606: 842,
            3608: 841, 3609: 841, 3610: 841, 3612: 841,
            3617: 840, 3618: 839, 3619: 839, 3620: 838,
            3621: 838, 3622: 838, 3624: 837, 3625: 837,
            3626: 837, 3628: 837, 3632: 836, 3633: 836,
            3634: 836, 3636: 836, 3640: 836, 3649: 835,
            3650: 834, 3651: 834, 3652: 833, 3653: 833,
            3654: 833, 3656: 832, 3657: 832, 3658: 832,
            3660: 832, 3664: 831, 3665: 831, 3666: 831,
            3668: 831, 3672: 831, 3680: 830, 3681: 830,
            3682: 830, 3684: 830, 3688: 830, 3696: 830,
            3713: 829, 3714: 828, 3715: 828, 3716: 827,
            3717: 827, 3718: 827, 3720: 826, 3721: 826,
            3722: 826, 3724: 826, 3728: 825, 3729: 825,
            3730: 825, 3732: 825, 3736: 825, 3744: 824,
            3745: 824, 3746: 824, 3748: 824, 3752: 824,
            3760: 824, 3776: 823, 3777: 823, 3778: 823,
            3780: 823, 3784: 823, 3792: 823, 3808: 823,
            3841: 822, 3842: 821, 3843: 821, 3844: 820,
            3845: 820, 3846: 820, 3848: 819, 3849: 819,
            3850: 819, 3852: 819, 3856: 818, 3857: 818,
            3858: 818, 3860: 818, 3864: 818, 3872: 817,
            3873: 817, 3874: 817, 3876: 817, 3880: 817,
            3888: 817, 3904: 816, 3905: 816, 3906: 816,
            3908: 816, 3912: 816, 3920: 816, 3936: 816,
            3968: 2, 3969: 2, 3970: 2, 3972: 2,
            3976: 2, 3984: 2, 4000: 2, 4032: 2,
            4111: 10, 4119: 815, 4123: 814, 4125: 813,
            4126: 812, 4127: 9, 4135: 811, 4139: 810,
            4141: 809, 4142: 808, 4143: 10, 4147: 807,
            4149: 806, 4150: 805, 4151: 805, 4153: 804,
            4154: 803, 4155: 803, 4156: 802, 4157: 802,
            4158: 8, 4167: 801, 4171: 800, 4173: 799,
            4174: 798, 4175: 10, 4179: 797, 4181: 796,
            4182: 795, 4183: 795, 4185: 794, 4186: 793,
            4187: 793, 4188: 792, 4189: 792, 4190: 792,
            4195: 791, 4197: 790, 4198: 789, 4199: 789,
            4201: 788, 4202: 787, 4203: 787, 4204: 786,
            4205: 786, 4206: 786, 4209: 785, 4210: 784,
            4211: 784, 4212: 783, 4213: 783, 4214: 783,
            4216: 782, 4217: 782, 4218: 782, 4220: 7,
            4231: 781, 4235: 780, 4237: 779, 4238: 778,
            4239: 10, 4243: 777, 4245: 776, 4246: 775,
            4247: 775, 4249: 774, 4250: 773, 4251: 773,
            4252: 772, 4253: 772, 4254: 772, 4259: 771,
            4261: 770, 4262: 769, 4263: 769, 4265: 768,
            4266: 767, 4267: 767, 4268: 766, 4269: 766,
            4270: 766, 4273: 765, 4274: 764, 4275: 764,
            4276: 763, 4277: 763, 4278: 763, 4280: 762,
            4281: 762, 4282: 762, 4284: 762, 4291: 761,
            4293: 760, 4294: 759, 4295: 759, 4297: 758,
            4298: 757, 4299: 757, 4300: 756, 4301: 756,
            4302: 756, 4305: 755, 4306: 754, 4307: 754,
            4308: 753, 4309: 753, 4310: 753, 4312: 752,
            4313: 752, 4314: 752, 4316: 752, 4321: 751,
            4322: 750, 4323: 750, 4324: 749, 4325: 749,
            4326: 749, 4328: 748, 4329: 748, 4330: 748,
            4332: 748, 4336: 747, 4337: 747, 4338: 747,
            4340: 747, 4344: 6, 4359: 746, 4363: 745,
            4365: 744, 4366: 743, 4367: 10, 4371: 742,
            4373: 741, 4374: 740, 4375: 740, 4377: 739,
            4378: 738, 4379: 738, 4380: 737, 4381: 737,
            4382: 737, 4387: 736, 4389: 735, 4390: 734,
            4391: 734, 4393: 733, 4394: 732, 4395: 732,
            4396: 731, 4397: 731, 4398: 731, 4401: 730,
            4402: 729, 4403: 729, 4404: 728, 4405: 728,
            4406: 728, 4408: 727, 4409: 727, 4410: 727,
            4412: 727, 4419: 726, 4421: 725, 4422: 724,
            4423: 724, 4425: 723, 4426: 722, 4427: 722,
            4428: 721, 4429: 721, 4430: 721, 4433: 720,
            4434: 719, 4435: 719, 4436: 718, 4437: 718,
            4438: 718, 4440: 717, 4441: 717, 4442: 717,
            4444: 717, 4449: 716, 4450: 715, 4451: 715,
            4452: 714, 4453: 714, 4454: 714, 4456: 713,
            4457: 713, 4458: 713, 4460: 713, 4464: 712,
            4465: 712, 4466: 712, 4468: 712, 4472: 712,
            4483: 711, 4485: 710, 4486: 709, 4487: 709,
            4489: 708, 4490: 707, 4491: 707, 4492: 706,
            4493: 706, 4494: 706, 4497: 705, 4498: 704,
            4499: 704, 4500: 703, 4501: 703, 4502: 703,
            4504: 702, 4505: 702, 4506: 702, 4508: 702,
            4513: 701, 4514: 700, 4515: 700, 4516: 699,
            4517: 699, 4518: 699, 4520: 698, 4521: 698,
            4522: 698, 4524: 698, 4528: 697, 4529: 697,
            4530: 697, 4532: 697, 4536: 697, 4545: 696,
            4546: 695, 4547: 695, 4548: 694, 4549: 694,
            4550: 694, 4552: 693, 4553: 693, 4554: 693,
            4556: 693, 4560: 692, 4561: 692, 4562: 692,
            4564: 692, 4568: 692, 4576: 691, 4577: 691,
            4578: 691, 4580: 691, 4584: 691, 4592: 5,
            4615: 690, 4619: 689, 4621: 688, 4622: 687,
            4623: 10, 4627: 686, 4629: 685, 4630: 684,
            4631: 684, 4633: 683, 4634: 682, 4635: 682,
            4636: 681, 4637: 681, 4638: 681, 4643: 680,
            4645: 679, 4646: 678, 4647: 678, 4649: 677,
            4650: 676, 4651: 676, 4652: 675, 4653: 675,
            4654: 675, 4657: 674, 4658: 673, 4659: 673,
            4660: 672, 4661: 672, 4662: 672, 4664: 671,
            4665: 671, 4666: 671, 4668: 671, 4675: 670,
            4677: 669, 4678: 668, 4679: 668, 4681: 667,
            4682: 666, 4683: 666, 4684: 665, 4685: 665,
            4686: 665, 4689: 664, 4690: 663, 4691: 663,
            4692: 662, 4693: 662, 4694: 662, 4696: 661,
            4697: 661, 4698: 661, 4700: 661, 4705: 660,
            4706: 659, 4707: 659, 4708: 658, 4709: 658,
            4710: 658, 4712: 657, 4713: 657, 4714: 657,
            4716: 657, 4720: 656, 4721: 656, 4722: 656,
            4724: 656, 4728: 656, 4739: 655, 4741: 654,
            4742: 653, 4743: 653, 4745: 652, 4746: 651,
            4747: 651, 4748: 650, 4749: 650, 4750: 650,
            4753: 649, 4754: 648, 4755: 648, 4756: 647,
            4757: 647, 4758: 647, 4760: 646, 4761: 646,
            4762: 646, 4764: 646, 4769: 645, 4770: 644,
            4771: 644, 4772: 643, 4773: 643, 4774: 643,
            4776: 642, 4777: 642, 4778: 642, 4780: 642,
            4784: 641, 4785: 641, 4786: 641, 4788: 641,
            4792: 641, 4801: 640, 4802: 639, 4803: 639,
            4804: 638, 4805: 638, 4806: 638, 4808: 637,
            4809: 637, 4810: 637, 4812: 637, 4816: 636,
            4817: 636, 4818: 636, 4820: 636, 4824: 636,
            4832: 635, 4833: 635, 4834: 635, 4836: 635,
            4840: 635, 4848: 635, 4867: 634, 4869: 633,
            4870: 632, 4871: 632, 4873: 631, 4874: 630,
            4875: 630, 4876: 629, 4877: 629, 4878: 629,
            4881: 628, 4882: 627, 4883: 627, 4884: 626,
            4885: 626, 4886: 626, 4888: 625, 4889: 625,
            4890: 625, 4892: 625, 4897: 624, 4898: 623,
            4899: 623, 4900: 622, 4901: 622, 4902: 622,
            4904: 621, 4905: 621, 4906: 621, 4908: 621,
            4912: 620, 4913: 620, 4914: 620, 4916: 620,
            4920: 620, 4929: 619, 4930: 618, 4931: 618,
            4932: 617, 4933: 617, 4934: 617, 4936: 616,
            4937: 616, 4938: 616, 4940: 616, 4944: 615,
            4945: 615, 4946: 615, 4948: 615, 4952: 615,
            4960: 614, 4961: 614, 4962: 614, 4964: 614,
            4968: 614, 4976: 614, 4993: 613, 4994: 612,
            4995: 612, 4996: 611, 4997: 611, 4998: 611,
            5000: 610, 5001: 610, 5002: 610, 5004: 610,
            5008: 609, 5009: 609, 5010: 609, 5012: 609,
            5016: 609, 5024: 608, 5025: 608, 5026: 608,
            5028: 608, 5032: 608, 5040: 608, 5056: 607,
            5057: 607, 5058: 607, 5060: 607, 5064: 607,
            5072: 607, 5088: 4, 5127: 606, 5131: 605,
            5133: 604, 5134: 603, 5135: 10, 5139: 602,
            5141: 601, 5142: 600, 5143: 600, 5145: 599,
            5146: 598, 5147: 598, 5148: 597, 5149: 597,
            5150: 597, 5155: 596, 5157: 595, 5158: 594,
            5159: 594, 5161: 593, 5162: 592, 5163: 592,
            5164: 591, 5165: 591, 5166: 591, 5169: 590,
            5170: 589, 5171: 589, 5172: 588, 5173: 588,
            5174: 588, 5176: 587, 5177: 587, 5178: 587,
            5180: 587, 5187: 586, 5189: 585, 5190: 584,
            5191: 584, 5193: 583, 5194: 582, 5195: 582,
            5196: 581, 5197: 581, 5198: 581, 5201: 580,
            5202: 579, 5203: 579, 5204: 578, 5205: 578,
            5206: 578, 5208: 577, 5209: 577, 5210: 577,
            5212: 577, 5217: 576, 5218: 575, 5219: 575,
            5220: 574, 5221: 574, 5222: 574, 5224: 573,
            5225: 573, 5226: 573, 5228: 573, 5232: 572,
            5233: 572, 5234: 572, 5236: 572, 5240: 572,
            5251: 571, 5253: 570, 5254: 569, 5255: 569,
            5257: 568, 5258: 567, 5259: 567, 5260: 566,
            5261: 566, 5262: 566, 5265: 565, 5266: 564,
            5267: 564, 5268: 563, 5269: 563, 5270: 563,
            5272: 562, 5273: 562, 5274: 562, 5276: 562,
            5281: 561, 5282: 560, 5283: 560, 5284: 559,
            5285: 559, 5286: 559, 5288: 558, 5289: 558,
            5290: 558, 5292: 558, 5296: 557, 5297: 557,
            5298: 557, 5300: 557, 5304: 557, 5313: 556,
            5314: 555, 5315: 555, 5316: 554, 5317: 554,
            5318: 554, 5320: 553, 5321: 553, 5322: 553,
            5324: 553, 5328: 552, 5329: 552, 5330: 552,
            5332: 552, 5336: 552, 5344: 551, 5345: 551,
            5346: 551, 5348: 551, 5352: 551, 5360: 551,
            5379: 550, 5381: 549, 5382: 548, 5383: 548,
            5385: 547, 5386: 546, 5387: 546, 5388: 545,
            5389: 545, 5390: 545, 5393: 544, 5394: 543,
            5395: 543, 5396: 542, 5397: 542, 5398: 542,
            5400: 541, 5401: 541, 5402: 541, 5404: 541,
            5409: 540, 5410: 539, 5411: 539, 5412: 538,
            5413: 538, 5414: 538, 5416: 537, 5417: 537,
            5418: 537, 5420: 537, 5424: 536, 5425: 536,
            5426: 536, 5428: 536, 5432: 536, 5441: 535,
            5442: 534, 5443: 534, 5444: 533, 5445: 533,
            5446: 533, 5448: 532, 5449: 532, 5450: 532,
            5452: 532, 5456: 531, 5457: 531, 5458: 531,
            5460: 531, 5464: 531, 5472: 530, 5473: 530,
            5474: 530, 5476: 530, 5480: 530, 5488: 530,
            5505: 529, 5506: 528, 5507: 528, 5508: 527,
            5509: 527, 5510: 527, 5512: 526, 5513: 526,
            5514: 526, 5516: 526, 5520: 525, 5521: 525,
            5522: 525, 5524: 525, 5528: 525, 5536: 524,
            5537: 524, 5538: 524, 5540: 524, 5544: 524,
            5552: 524, 5568: 523, 5569: 523, 5570: 523,
            5572: 523, 5576: 523, 5584: 523, 5600: 523,
            5635: 522, 5637: 521, 5638: 520, 5639: 520,
            5641: 519, 5642: 518, 5643: 518, 5644: 517,
            5645: 517, 5646: 517, 5649: 516, 5650: 515,
            5651: 515, 5652: 514, 5653: 514, 5654: 514,
            5656: 513, 5657: 513, 5658: 513, 5660: 513,
            5665: 512, 5666: 511, 5667: 511, 5668: 510,
            5669: 510, 5670: 510, 5672: 509, 5673: 509,
            5674: 509, 5676: 509, 5680: 508, 5681: 508,
            5682: 508, 5684: 508, 5688: 508, 5697: 507,
            5698: 506, 5699: 506, 5700: 505, 5701: 505,
            5702: 505, 5704: 504, 5705: 504, 5706: 504,
            5708: 504, 5712: 503, 5713: 503, 5714: 503,
            5716: 503, 5720: 503, 5728: 502, 5729: 502,
            5730: 502, 5732: 502, 5736: 502, 5744: 502,
            5761: 501, 5762: 500, 5763: 500, 5764: 499,
            5765: 499, 5766: 499, 5768: 498, 5769: 498,
            5770: 498, 5772: 498, 5776: 497, 5777: 497,
            5778: 497, 5780: 497, 5784: 497, 5792: 496,
            5793: 496, 5794: 496, 5796: 496, 5800: 496,
            5808: 496, 5824: 495, 5825: 495, 5826: 495,
            5828: 495, 5832: 495, 5840: 495, 5856: 495,
            5889: 494, 5890: 493, 5891: 493, 5892: 492,
            5893: 492, 5894: 492, 5896: 491, 5897: 491,
            5898: 491, 5900: 491, 5904: 490, 5905: 490,
            5906: 490, 5908: 490, 5912: 490, 5920: 489,
            5921: 489, 5922: 489, 5924: 489, 5928: 489,
            5936: 489, 5952: 488, 5953: 488, 5954: 488,
            5956: 488, 5960: 488, 5968: 488, 5984: 488,
            6016: 487, 6017: 487, 6018: 487, 6020: 487,
            6024: 487, 6032: 487, 6048: 487, 6080: 3,
            6151: 486, 6155: 485, 6157: 484, 6158: 483,
            6159: 10, 6163: 482, 6165: 481, 6166: 480,
            6167: 480, 6169: 479, 6170: 478, 6171: 478,
            6172: 477, 6173: 477, 6174: 477, 6179: 476,
            6181: 475, 6182: 474, 6183: 474, 6185: 473,
            6186: 472, 6187: 472, 6188: 471, 6189: 471,
            6190: 471, 6193: 470, 6194: 469, 6195: 469,
            6196: 468, 6197: 468, 6198: 468, 6200: 467,
            6201: 467, 6202: 467, 6204: 467, 6211: 466,
            6213: 465, 6214: 464, 6215: 464, 6217: 463,
            6218: 462, 6219: 462, 6220: 461, 6221: 461,
            6222: 461, 6225: 460, 6226: 459, 6227: 459,
            6228: 458, 6229: 458, 6230: 458, 6232: 457,
            6233: 457, 6234: 457, 6236: 457, 6241: 456,
            6242: 455, 6243: 455, 6244: 454, 6245: 454,
            6246: 454, 6248: 453, 6249: 453, 6250: 453,
            6252: 453, 6256: 452, 6257: 452, 6258: 452,
            6260: 452, 6264: 452, 6275: 451, 6277: 450,
            6278: 449, 6279: 449, 6281: 448, 6282: 447,
            6283: 447, 6284: 446, 6285: 446, 6286: 446,
            6289: 445, 6290: 444, 6291: 444, 6292: 443,
            6293: 443, 6294: 443, 6296: 442, 6297: 442,
            6298: 442, 6300: 442, 6305: 441, 6306: 440,
            6307: 440, 6308: 439, 6309: 439, 6310: 439,
            6312: 438, 6313: 438, 6314: 438, 6316: 438,
            6320: 437, 6321: 437, 6322: 437, 6324: 437,
            6328: 437, 6337: 436, 6338: 435, 6339: 435,
            6340: 434, 6341: 434, 6342: 434, 6344: 433,
            6345: 433, 6346: 433, 6348: 433, 6352: 432,
            6353: 432, 6354: 432, 6356: 432, 6360: 432,
            6368: 431, 6369: 431, 6370: 431, 6372: 431,
            6376: 431, 6384: 431, 6403: 430, 6405: 429,
            6406: 428, 6407: 428, 6409: 427, 6410: 426,
            6411: 426, 6412: 425, 6413: 425, 6414: 425,
            6417: 424, 6418: 423, 6419: 423, 6420: 422,
            6421: 422, 6422: 422, 6424: 421, 6425: 421,
            6426: 421, 6428: 421, 6433: 420, 6434: 419,
            6435: 419, 6436: 418, 6437: 418, 6438: 418,
            6440: 417, 6441: 417, 6442: 417, 6444: 417,
            6448: 416, 6449: 416, 6450: 416, 6452: 416,
            6456: 416, 6465: 415, 6466: 414, 6467: 414,
            6468: 413, 6469: 413, 6470: 413, 6472: 412,
            6473: 412, 6474: 412, 6476: 412, 6480: 411,
            6481: 411, 6482: 411, 6484: 411, 6488: 411,
            6496: 410, 6497: 410, 6498: 410, 6500: 410,
            6504: 410, 6512: 410, 6529: 409, 6530: 408,
            6531: 408, 6532: 407, 6533: 407, 6534: 407,
            6536: 406, 6537: 406, 6538: 406, 6540: 406,
            6544: 405, 6545: 405, 6546: 405, 6548: 405,
            6552: 405, 6560: 404, 6561: 404, 6562: 404,
            6564: 404, 6568: 404, 6576: 404, 6592: 403,
            6593: 403, 6594: 403, 6596: 403, 6600: 403,
            6608: 403, 6624: 403, 6659: 402, 6661: 401,
            6662: 400, 6663: 400, 6665: 399, 6666: 398,
            6667: 398, 6668: 397, 6669: 397, 6670: 397,
            6673: 396, 6674: 395, 6675: 395, 6676: 394,
            6677: 394, 6678: 394, 6680: 393, 6681: 393,
            6682: 393, 6684: 393, 6689: 392, 6690: 391,
            6691: 391, 6692: 390, 6693: 390, 6694: 390,
            6696: 389, 6697: 389, 6698: 389, 6700: 389,
            6704: 388, 6705: 388, 6706: 388, 6708: 388,
            6712: 388, 6721: 387, 6722: 386, 6723: 386,
            6724: 385, 6725: 385, 6726: 385, 6728: 384,
            6729: 384, 6730: 384, 6732: 384, 6736: 383,
            6737: 383, 6738: 383, 6740: 383, 6744: 383,
            6752: 382, 6753: 382, 6754: 382, 6756: 382,
            6760: 382, 6768: 382, 6785: 381, 6786: 380,
            6787: 380, 6788: 379, 6789: 379, 6790: 379,
            6792: 378, 6793: 378, 6794: 378, 6796: 378,
            6800: 377, 6801: 377, 6802: 377, 6804: 377,
            6808: 377, 6816: 376, 6817: 376, 6818: 376,
            6820: 376, 6824: 376, 6832: 376, 6848: 375,
            6849: 375, 6850: 375, 6852: 375, 6856: 375,
            6864: 375, 6880: 375, 6913: 374, 6914: 373,
            6915: 373, 6916: 372, 6917: 372, 6918: 372,
            6920: 371, 6921: 371, 6922: 371, 6924: 371,
            6928: 370, 6929: 370, 6930: 370, 6932: 370,
            6936: 370, 6944: 369, 6945: 369, 6946: 369,
            6948: 369, 6952: 369, 6960: 369, 6976: 368,
            6977: 368, 6978: 368, 6980: 368, 6984: 368,
            6992: 368, 7008: 368, 7040: 367, 7041: 367,
            7042: 367, 7044: 367, 7048: 367, 7056: 367,
            7072: 367, 7104: 367, 7171: 366, 7173: 365,
            7174: 364, 7175: 364, 7177: 363, 7178: 362,
            7179: 362, 7180: 361, 7181: 361, 7182: 361,
            7185: 360, 7186: 359, 7187: 359, 7188: 358,
            7189: 358, 7190: 358, 7192: 357, 7193: 357,
            7194: 357, 7196: 357, 7201: 356, 7202: 355,
            7203: 355, 7204: 354, 7205: 354, 7206: 354,
            7208: 353, 7209: 353, 7210: 353, 7212: 353,
            7216: 352, 7217: 352, 7218: 352, 7220: 352,
            7224: 352, 7233: 351, 7234: 350, 7235: 350,
            7236: 349, 7237: 349, 7238: 349, 7240: 348,
            7241: 348, 7242: 348, 7244: 348, 7248: 347,
            7249: 347, 7250: 347, 7252: 347, 7256: 347,
            7264: 346, 7265: 346, 7266: 346, 7268: 346,
            7272: 346, 7280: 346, 7297: 345, 7298: 344,
            7299: 344, 7300: 343, 7301: 343, 7302: 343,
            7304: 342, 7305: 342, 7306: 342, 7308: 342,
            7312: 341, 7313: 341, 7314: 341, 7316: 341,
            7320: 341, 7328: 340, 7329: 340, 7330: 340,
            7332: 340, 7336: 340, 7344: 340, 7360: 339,
            7361: 339, 7362: 339, 7364: 339, 7368: 339,
            7376: 339, 7392: 339, 7425: 338, 7426: 337,
            7427: 337, 7428: 336, 7429: 336, 7430: 336,
            7432: 335, 7433: 335, 7434: 335, 7436: 335,
            7440: 334, 7441: 334, 7442: 334, 7444: 334,
            7448: 334, 7456: 333, 7457: 333, 7458: 333,
            7460: 333, 7464: 333, 7472: 333, 7488: 332,
            7489: 332, 7490: 332, 7492: 332, 7496: 332,
            7504: 332, 7520: 332, 7552: 331, 7553: 331,
            7554: 331, 7556: 331, 7560: 331, 7568: 331,
            7584: 331, 7616: 331, 7681: 330, 7682: 329,
            7683: 329, 7684: 328, 7685: 328, 7686: 328,
            7688: 327, 7689: 327, 7690: 327, 7692: 327,
            7696: 326, 7697: 326, 7698: 326, 7700: 326,
            7704: 326, 7712: 325, 7713: 325, 7714: 325,
            7716: 325, 7720: 325, 7728: 325, 7744: 324,
            7745: 324, 7746: 324, 7748: 324, 7752: 324,
            7760: 324, 7776: 324, 7808: 323, 7809: 323,
            7810: 323, 7812: 323, 7816: 323, 7824: 323,
            7840: 323, 7872: 323, 7936: 1, 7937: 1,
            7938: 1, 7940: 1, 7944: 1, 7952: 1,
            7968: 1, 8000: 1, 8064: 1
        }
        
        prime_products_to_rank = {
            279052297: 1764, 39256075: 188, 196625: 295, 208502807: 240,
            210829339: 1640, 40173601: 84, 163875: 2308, 120018269: 1821,
            3473457: 2096, 45711419: 220, 36798535: 1952, 31359055: 1662,
            775523: 124, 1310804: 202, 32856: 312, 170295386: 179,
            96075874: 16, 65637: 2387, 83918953: 2027, 131192: 315,
            144310397: 30, 1966206: 1800, 144: 166, 144113811: 16,
            3473561: 2208, 13828269: 1728, 728563891: 168, 62783669: 251,
            53936311: 1898, 255328441: 51, 2949309: 201, 360639: 304,
            786625: 2291, 32967: 144, 203030729: 1874, 42401995: 1878,
            590031: 299, 3277010: 1799, 135266339: 1940, 40075477: 2084,
            6935929: 2078, 32984: 2425, 54460637: 54, 268927201: 61,
            240: 165, 420571859: 183, 240189685: 16, 3080451: 2052,
            5603591: 277, 196882: 119, 295191: 302, 2856326: 2150,
            4587814: 1798, 1177239601: 1621, 4915515: 1799, 324: 154,
            645169481: 1612, 23462218: 1823, 336: 164, 6553942: 2036,
            336265559: 16, 641925469: 1697, 360: 322, 50168173: 210,
            65910: 2135, 885115: 2185, 196988: 274, 400: 165,
            4489623: 225, 33176: 2435, 99352985: 1763, 786842: 2215,
            295323: 119, 3572125: 287, 6881721: 1798, 459195: 2180,
            17269195: 2020, 7209422: 198, 53772755: 195, 59474389: 1970,
            33250: 2318, 382375: 2308, 35193327: 1823, 578985: 2173,
            504: 322, 2228732: 190, 9830913: 2036, 18481673: 223,
            2490891: 245, 8192525: 200, 528: 163, 12714515: 1914,
            528417307: 16, 540: 310, 8520226: 1793, 15467045: 1946,
            1027681031: 1610, 560: 164, 98865: 261, 6259253: 2088,
            295482: 2157, 328251: 2238, 33345: 2382, 221938247: 1886,
            524875: 2315, 600: 321, 448463453: 1875, 2032225: 260,
            1180263: 2215, 197225: 284, 10191467: 2161, 624: 162,
            434045557: 1679, 624493181: 16, 41583245: 1833, 3965585: 256,
            131733: 2341, 131750: 2294, 1475243: 2243, 492205: 119,
            10814133: 198, 131769: 117, 134251207: 231, 11141834: 1788,
            94995155: 1811, 11469535: 1798, 7832305: 2094, 756: 310,
            10584826: 1834, 3179267: 2226, 21365510: 1628, 784: 164,
            792: 322, 21978: 2353, 12452638: 1782, 158104774: 1610,
            4686628: 178, 810: 153, 24068231: 234, 1475375: 2282,
            816: 161, 12780339: 1793, 197432: 2414, 58655545: 1823,
            754490: 1997, 816644929: 16, 278135623: 184, 840: 2465,
            90833737: 71, 918346: 2118, 9442786: 241, 1049427: 237,
            16384855: 2036, 24019801: 98, 33640: 314, 54690665: 1895,
            880: 163, 60228467: 2009, 66424: 316, 912: 160,
            25953169: 2149, 912720803: 15, 164775: 260, 936: 322,
            32998317: 1814, 990938033: 36, 45450163: 242, 21726133: 2093,
            492470: 2156, 2229175: 236, 5178302: 85, 15074246: 1775,
            4064207: 281, 132055: 127, 492507: 2348, 7439327: 279,
            20579299: 2103, 3507185: 2162, 62292981: 1746, 66550: 272,
            1020099721: 15, 197625: 2294, 66555: 2368, 34046974: 1649,
            1967105: 2215, 16057349: 199, 7411201: 2205, 1040: 162,
            66584: 2404, 244876313: 1648, 156075049: 41, 16712751: 1788,
            2393138: 2159, 75950942: 1632, 481690679: 1754, 372737087: 49,
            39912521: 231, 39388235: 1846, 26051663: 267, 1104: 159,
            73984867: 240, 132184: 2403, 63931486: 1753, 1104872551: 14,
            1134: 152, 5014647: 189, 44270722: 1706, 82117763: 1823,
            32048265: 1628, 111150221: 1747, 99470: 2239, 85689487: 229,
            54808: 2426, 1176: 320, 37618841: 2029, 132250: 291,
            1016991: 249, 113968289: 1904, 1188: 310, 33957: 285,
            9110695: 264, 11337927: 74, 18678957: 1782, 33966: 2351,
            165044: 274, 230584: 2402, 19236027: 1897, 19006658: 1767,
            19072198: 1839, 558279: 2357, 1224: 322, 24413389: 1859,
            1232: 163, 132327: 306, 7308521: 269, 128124139: 173,
            6848722: 83, 1377519: 2118, 104826097: 1961, 5571830: 1733,
            50955511: 75, 34040: 2415, 15051647: 97, 623875: 2292,
            532972817: 203, 99603: 2360, 20317462: 42, 230685: 2132,
            1770782: 97, 722211: 247, 1320: 2463, 689458: 2155,
            1037875: 292, 220988729: 1812, 97355066: 180, 66885: 2261,
            1350: 309, 4293962: 2044, 15926603: 1920, 34125: 2327,
            5244239: 2097, 1360: 161, 21300565: 1793, 1368: 322,
            7275866: 65, 1508708: 226, 9209189: 108, 141919591: 206,
            34155: 2377, 1392: 158, 293635441: 1690, 1400: 321,
            1404: 310, 10257793: 2102, 52168071: 1829, 719422859: 35,
            1393100173: 13, 2753947: 120, 450659741: 1676, 28588747: 243,
            174163367: 171, 22611369: 1775, 9110959: 98, 1456: 162,
            11371965: 1667, 492993: 301, 263625: 2284, 26248651: 2138,
            3999182: 2022, 1488: 157, 198099: 2366, 1500: 298,
            686196191: 1688, 1082851: 119, 67048: 317, 1489176047: 12,
            1520: 160, 99825: 272, 824915: 2220, 620955127: 1678,
            85198346: 181, 24249874: 1758, 1560: 2460, 12060191: 2143,
            768280099: 1742, 165416: 2423, 291472939: 1821, 198772279: 217,
            9897537: 1955, 21333571: 275, 1256375: 291, 25232977: 198,
            3704402: 2038, 419530327: 218, 445318751: 205, 34408: 2441,
            1312366: 2170, 294749807: 182, 28444273: 1972, 1656: 322,
            57411193: 175, 477365897: 206, 99981: 303, 1541785: 2225,
            329375: 133, 46991009: 1963, 11077285: 76, 67240: 311,
            1574573: 270, 530286257: 183, 99026615: 1707, 26871482: 1748,
            73434815: 1765, 2229955: 2106, 186746573: 1830, 200509147: 1941,
            198375: 291, 1776: 156, 2983665: 1975, 7800562: 1732,
            1279733: 119, 1782: 151, 27854585: 1788, 6981373: 247,
            84084481: 1943, 132867: 2350, 1902342: 1862, 693889: 125,
            309799895: 1621, 1777403669: 11, 129042199: 1823, 28509987: 1767,
            165669: 123, 60360487: 222, 28608297: 1839, 1836: 310,
            67375: 296, 1840: 159, 28804919: 2011, 1848: 2462,
            165699: 304, 75728722: 35, 36046681: 2036, 5375838: 1664,
            1890: 2399, 596033851: 179, 76056423: 1754, 1904: 161,
            8357745: 1733, 17106802: 1887, 29820791: 1793, 4910059: 2162,
            53413775: 176, 1936: 163, 218776: 2404, 30476193: 42,
            1035044771: 204, 1960: 320, 2656173: 97, 1968: 155,
            231363: 2340, 18896545: 74, 31131595: 1782, 2820062: 2013,
            2025: 153, 2040: 2456, 441714689: 1633, 2052: 310,
            10913799: 65, 362505: 2129, 414189581: 28, 2263062: 1902,
            11405339: 107, 923961373: 25, 5900323: 109, 2088: 322,
            1083434: 108, 33753139: 72, 3999796: 214, 2295865: 2118,
            2106: 150, 34875: 297, 99453003: 1615, 788557: 283,
            2128: 160, 13535315: 2037, 152504417: 209, 657514: 2184,
            296978539: 1681, 1378420: 178, 48728186: 29, 133250: 2276,
            19138691: 222, 2184: 2459, 526473: 2347, 2427022: 2051,
            329875: 2303, 34965: 2354, 2200: 321, 266897569: 40,
            27675: 309, 231594: 2174, 94800043: 209, 42600623: 2036,
            8292531: 1964, 5998773: 2022, 2232: 322, 32737475: 176,
            2250: 297, 5048523: 213, 4327631: 2215, 324962515: 14,
            221317339: 1772, 80709853: 227, 114526433: 1714, 4784507: 2216,
            8882405: 1957, 2558182: 265, 26413287: 207, 2280: 2451,
            329966: 2220, 2288: 162, 591981611: 1687, 127797519: 181,
            2320: 158, 100625: 135, 2132242: 2032, 11077913: 2140,
            36374811: 1758, 297250: 2272, 1444135: 2164, 1411372: 226,
            461125: 2294, 36571466: 183, 180947279: 1951, 12945755: 85,
            985439: 282, 180625: 137, 37685615: 1775, 133496: 2402,
            428415: 104, 100737: 2342, 16517506: 239, 461187: 2357,
            362894: 279, 3528430: 1909, 1837462: 90, 35224: 2417,
            1968549: 2170, 1280422: 2154, 6752685: 1892, 821678: 2123,
            2480: 157, 84183473: 1888, 2484: 310, 723387: 2218,
            316475837: 216, 38996419: 1788, 2500: 142, 324635077: 1699,
            11536838: 230, 629869019: 1613, 239503837: 239, 20810206: 1940,
            4295135: 2111, 1083875: 2300, 550865381: 191, 3107923: 2209,
            12061175: 176, 613190137: 12, 56658433: 2072, 559625: 295,
            35343: 2388, 2576: 159, 71076371: 84, 40307223: 1748,
            68121: 146, 20744735: 1899, 428582: 2179, 2600: 321,
            1870379: 119, 160991789: 1810, 80874049: 64, 35397: 147,
            426609223: 227, 100936: 2413, 3391927: 2225, 76941907: 187,
            2646: 308, 116197982: 24, 254249569: 1624, 2664: 322,
            5114473: 2215, 11700843: 1732, 28808978: 1650, 1988371: 2228,
            68229: 304, 35464: 2427, 2853513: 213, 22874765: 1970,
            827518061: 180, 2704: 162, 74779285: 1627, 13535895: 1826,
            4917913: 2057, 126063: 2366, 15108769: 99, 348340681: 182,
            8784574: 219, 469502657: 1688, 2754: 149, 350325443: 1641,
            2760: 2445, 13961935: 2073, 35523293: 2085, 553366709: 1610,
            76923: 2353, 12048166: 1847, 43584233: 1782, 12258026: 186,
            199428853: 1822, 26643199: 86, 8063757: 177, 2198287: 2236,
            2835: 152, 901417759: 13, 101156: 274, 2427685: 101,
            2856: 2455, 35625: 136, 789291: 2337, 91130669: 1772,
            14584622: 1840, 143297337: 1678, 133947: 307, 56101694: 1616,
            649235263: 36, 33786701: 243, 854862: 2042, 1510229: 120,
            11409209: 2215, 2904: 319, 55708507: 86, 166750: 2300,
            363363: 2194, 756602: 2062, 330625: 135, 3214211: 2118,
            2952: 322, 2128893: 2117, 128617357: 217, 2960: 156,
            2970: 2397, 101277: 307, 35750: 2326, 247950493: 1743,
            2992: 161, 232375: 294, 17435578: 1941, 46861243: 198,
            39357381: 31, 68552: 2406, 1411648457: 180, 2785783: 2178,
            4230093: 2013, 560082: 2055, 47516645: 1767, 35816: 319,
            16321513: 2110, 47680495: 1839, 3078: 148, 101384: 2432,
            1313806: 99, 10095635: 2138, 68634: 2337, 2264116: 202,
            166972: 262, 1707069: 2089, 222891071: 1821, 1442315: 278,
            46140493: 229, 5999694: 1817, 2264143: 119, 1248338: 1992,
            11340885: 1835, 2919518: 199, 2690149: 2226, 13929575: 188,
            560235: 2125, 6720623: 2110, 12881011: 95, 3192: 2450,
            27135097: 2150, 286985363: 203, 593047: 124, 953498: 2098,
            1674398: 2153, 11078815: 2012, 2067630: 1673, 36015: 128,
            3248: 158, 62262449: 2036, 36018: 2366, 50793655: 42,
            66784449: 1648, 199875: 2276, 4558023: 201, 4426955: 97,
            3280: 155, 21499089: 1896, 3640533: 2051, 4885724: 202,
            1707230: 1868, 93162719: 1896, 14486758: 1727, 164826349: 61,
            4197615: 68, 330993: 2339, 3312897: 1981, 5541126: 45,
            3344: 160, 208088: 312, 3348: 310, 471764245: 167,
            18124057: 85, 52759861: 1775, 68931: 144, 3400: 321,
            3837273: 265, 6851930: 1777, 18189665: 65, 494949: 2220,
            15306086: 1888, 3432: 2458, 113872241: 50, 101750: 2287,
            100306297: 1757, 3771770: 1901, 258936197: 172, 425921927: 193,
            10292623: 108, 3472: 157, 5082519: 77, 3480: 2438,
            36250: 134, 6688157: 2215, 67571102: 1697, 2526625: 2272,
            242257315: 1613, 106827177: 27, 3500: 298, 14355887: 1979,
            3510: 2394, 8490435: 1784, 3536: 161, 77532631: 208,
            1609179: 2163, 232925: 272, 626145: 2120, 2166242: 2104,
            24972779: 87, 54857199: 183, 11996662: 1905, 968267689: 48,
            69954815: 1636, 2450623997: 168, 398443093: 205, 3345925: 224,
            1871386: 2152, 42839303: 2083, 141823543: 1961, 3640: 2459,
            61378109: 241, 24776259: 239, 682921543: 216, 855625: 132,
            201035341: 1875, 69212: 274, 25398877: 231, 7442015: 1966,
            159911521: 1682, 134757: 2358, 69176939: 252, 243601007: 1756,
            539070067: 205, 83922549: 1819, 3935875: 288, 417730181: 1632,
            3720: 2430, 1775554: 2168, 3726: 147, 724625: 2294,
            2199197: 102, 3739294: 2085, 401051299: 170, 17239717: 246,
            3750: 141, 198020777: 196, 12095146: 1768, 9899695: 2030,
            15535793: 211, 36531: 143, 3444404: 190, 7016125: 288,
            298701: 2349, 269815507: 1820, 3800: 321, 1146941503: 1808,
            147904466: 1611, 106204915: 38, 69368: 2432, 69375: 132,
            4361375: 2270, 90312467: 206, 5377814: 1919, 3864: 2444,
            212995865: 181, 18779942: 228, 25431849: 21, 60624685: 1758,
            659246: 277, 11079471: 251, 180563251: 1764, 7474999: 2215,
            5902138: 210, 666965983: 47, 14389053: 1776, 51089233: 1912,
            14716754: 1781, 907235: 279, 61280087: 198, 73469786: 17,
            75370333: 243, 161025887: 184, 194416493: 218, 670797679: 1679,
            3952: 160, 10686322: 71, 266104: 2413, 53055353: 2073,
            1049237: 123, 3018625: 2271, 2854789: 119, 1085318: 100,
            200583: 2374, 174296973: 24, 3996: 310, 252809123: 1688,
            2068390: 1922, 237244333: 1885, 677875: 2302, 218501051: 208,
            107384767: 1822, 1609674: 1866, 4593655: 90, 1183693: 122,
            4048: 159, 6950865: 1850, 6754258: 175, 1039437781: 1742,
            4056: 318, 1609699: 280, 57085931: 187, 217583597: 18,
            38998011: 1813, 406979243: 1808, 3477513: 233, 8785931: 2141,
            495635: 281, 4116: 286, 462875: 291, 13176861: 219,
            30707743: 234, 12750881: 233, 203919395: 192, 7409703: 1908,
            63576071: 1962, 430125: 2281, 70069597: 209, 4144: 156,
            6262837: 277, 18321465: 1750, 4158: 2396, 397375: 293,
            167546951: 1655, 313659471: 11, 4231249: 113, 1917625: 291,
            530190427: 192, 18387039: 186, 18976867: 199, 27842581: 2102,
            462917767: 27, 16158857: 2045, 12488846: 2007, 27168911: 1907,
            3051671: 119, 136646809: 251, 1904799: 257, 117510305: 1626,
            1577125: 2281, 66523303: 1767, 288985261: 208, 409735345: 13,
            6983858: 1881, 66752693: 1839, 9801911: 275, 3201055: 2154,
            100831423: 1650, 954569: 283, 1182732491: 192, 757965: 2114,
            135375: 292, 67178705: 1748, 9998547: 2072, 4312: 320,
            84152541: 1616, 18944222: 1722, 58462435: 217, 244207057: 1830,
            1282293: 249, 46928119: 1904, 130846985: 48, 21598475: 200,
            266511: 120, 2265362: 2151, 120879: 307, 2724125: 2281,
            68489509: 198, 7016757: 1965, 20418871: 267, 6558013: 223,
            4428: 310, 7311694: 1945, 4440: 2421, 307007833: 1698,
            19501405: 1732, 4455: 151, 116035945: 1745, 73996226: 1808,
            4488: 2454, 176525705: 1680, 52171147: 2006, 4755855: 1861,
            488542609: 38, 37268: 274, 26153367: 1941, 57367405: 59,
            30151081: 88, 163582381: 196, 1184183: 259, 9015747: 1913,
            233926: 2230, 405737927: 169, 135625: 133, 71111117: 42,
            365010: 1937, 697962967: 15, 3343098: 1734, 37352: 2432,
            6197737: 97, 70125: 2322, 4590: 2390, 4592: 155,
            4600: 321, 66556411: 2028, 10883587: 2153, 4624: 161,
            1970709: 99, 5050903: 258, 7934495: 88, 72421921: 1787,
            5804582: 1855, 102951: 143, 3838513: 280, 149155253: 59,
            332730949: 59, 6984263: 257, 7836235: 2039, 332367: 2249,
            135762: 2192, 43192919: 1841, 4698: 146, 1577570: 1982,
            13439595: 1663, 334369391: 227, 4725: 309, 1872507: 1992,
            234117: 2366, 4760: 2455, 42767005: 1887, 36901543: 2018,
            37544: 316, 4784: 159, 21992113: 2139, 47157943: 187,
            873435833: 1631, 25465531: 65, 605605: 2194, 325763873: 207,
            1218679: 2249, 561875: 133, 12784343: 255, 21172954: 1716,
            38965979: 75, 5280478: 1900, 1603998433: 167, 4954235: 2078,
            38900455: 54, 4840: 319, 69359741: 263, 3512509: 2171,
            496375: 292, 267003: 2357, 8557315: 2076, 7803653: 107,
            299782: 2242, 4872: 2437, 76157705: 1655, 103318319: 2072,
            486875: 131, 7344935: 2045, 3937066: 1947, 2626351: 2227,
            4914: 2393, 29266741: 2019, 4920: 2411, 1158625: 2292,
            2560845: 1868, 103289681: 228, 37720: 2405, 21730137: 1727,
            95032159: 242, 37730: 2264, 819008357: 26, 4854633: 1915,
            168831: 306, 8197007: 95, 31757206: 1747, 5016: 2449,
            5022: 145, 2448663: 1987, 2003875: 2273, 138875815: 1625,
            7050155: 2013, 21631939: 84, 3642317: 119, 24613841: 220,
            176886751: 1940, 136161: 143, 3609572: 214, 5096: 320,
            12063727: 257, 5104: 158, 14779219: 253, 19633145: 1842,
            363664379: 1819, 101761877: 187, 72717313: 244, 5130: 2385,
            443223: 273, 1022125: 2285, 7836699: 2074, 216536099: 216,
            1414189: 121, 870880303: 35, 5168: 160, 47879221: 2083,
            49131017: 74, 55481405: 1644, 1840195: 2216, 365638: 2210,
            37962: 2350, 597857359: 25, 13997137: 2022, 166597717: 1708,
            5208: 2429, 101356653: 1697, 267375: 2292, 5543031: 254,
            13898877: 2009, 9999490: 1816, 1119364: 70, 455295853: 37,
            5265: 150, 628967921: 1808, 28480661: 85, 147821729: 51,
            169125: 2277, 36017319: 41, 10556585: 253, 21337261: 2141,
            193139889: 1676, 101586101: 2027, 5304: 2453, 82908353: 198,
            5320: 2450, 365769: 2358, 464079: 2211, 3249363: 2104,
            174691541: 241, 6362335: 2023, 17994993: 1905, 95425781: 61,
            5982845: 2159, 2102529: 2105, 1643785: 2184, 431375: 2302,
            44590: 2261, 3446050: 176, 298194211: 181, 955695: 2107,
            49943858: 1699, 84874559: 1758, 43095363: 1830, 333125: 131,
            431433: 302, 19404111: 1943, 5456: 157, 11832: 2434,
            71001: 285, 5969249: 100, 6067555: 2051, 102471019: 184,
            5500: 298, 1316223: 299, 431494: 2219, 7745089: 111,
            791945: 2190, 103818: 2196, 202124: 262, 83137939: 1962,
            11244966: 33, 17438135: 1859, 8623549: 109, 9835969: 258,
            1742279: 113, 136648: 2423, 366025: 116, 1333138903: 169,
            38367: 308, 57087457: 1942, 169442: 2250, 71145: 2360,
            5608941: 2085, 2736741: 79, 4036081: 119, 102274549: 1951,
            5625: 141, 49059329: 2139, 2692613: 269, 71176: 2403,
            11376145: 1920, 3806745: 1958, 38440: 313, 20256299: 2029,
            80844333: 1641, 4101682: 1979, 38456: 2440, 6395455: 265,
            65275955: 1886, 3642947: 2177, 13145671: 211, 64165451: 175,
            547085: 2238, 300625: 132, 1684870739: 24, 71253: 2369,
            5720: 2458, 221856699: 1611, 38502: 2358, 45832465: 1651,
            126567: 285, 156309101: 52, 628342: 102, 4593281: 2170,
            1119875: 293, 5776: 160, 628371: 300, 136857: 124,
            8066721: 1919, 1021605: 2099, 508860071: 37, 5800: 321,
            195368621: 1698, 2939167: 2208, 104125: 296, 2823875: 2272,
            988869: 277, 44537545: 1774, 104139: 2367, 25630418: 1709,
            62166742: 18, 8853207: 210, 26903503: 2140, 1535611: 283,
            105223919: 231, 6440: 2444, 71415: 303, 6493949: 2143,
            3053314: 2149, 110204679: 17, 265885451: 215, 15734546: 1951,
            22058771: 223, 99489559: 1888, 62265117: 1820, 654875: 294,
            48011041: 95, 13408034: 1904, 12916515: 1724, 825125: 2273,
            1385207591: 1677, 5928: 2448, 16029483: 71, 1873718: 1930,
            91428665: 183, 2065375: 2271, 25302851: 1963, 4986695: 2040,
            38745: 2344, 38750: 133, 5994: 144, 595820: 202,
            9901934: 55, 178820989: 230, 661375: 2286, 94050187: 1748,
            6032: 158, 1251222: 1803, 24516505: 1898, 13473698: 1717,
            44439461: 73, 497576: 311, 62592937: 2138, 47650733: 255,
            94705589: 196, 169911: 2357, 6072: 2443, 10131387: 175,
            268226: 2243, 41293765: 239, 8361926: 2019, 4413773: 259,
            125238481: 73, 388601813: 215, 434051033: 204, 268250: 2282,
            8132943: 1794, 137180: 238, 1796839391: 169, 957125: 2293,
            8821075: 224, 432117: 237, 1808375: 2283, 71672: 317,
            4222634: 253, 5609470: 1843, 223025159: 28, 19546709: 2073,
            732796951: 26, 137241: 2375, 73078811: 2083, 6174: 285,
            202797: 2348, 50108462: 193, 38961: 144, 6200: 321,
            3872830: 1795, 6210: 2379, 71750: 2278, 6216: 2420,
            64362571: 53, 27301967: 187, 11960: 2442, 33658963: 85,
            727124: 250, 6237: 151, 39015: 305, 235625: 134,
            28842095: 230, 6256: 159, 10885233: 231, 8067191: 110,
            39032: 2407, 1258428539: 168, 59630467: 221, 497794: 113,
            97982599: 1774, 1153166: 275, 40966289: 1889, 5183634: 1770,
            6658197: 1860, 350689441: 1874, 2736232621: 167, 121247927: 2018,
            104632: 2404, 530621: 125, 39102: 2253, 38705343: 206,
            19050187: 98, 6166737: 201, 3479762: 1925, 12196051: 277,
            235750: 2273, 590584049: 15, 60725497: 61, 334084: 94,
            80386311: 182, 71944: 315, 399627: 304, 71955: 2342,
            6426: 2389, 39208: 318, 1251625: 2293, 361522: 2228,
            6448: 157, 18389306: 53, 540547403: 1622, 28416333: 1722,
            11704654: 1889, 727375: 291, 4561235: 79, 3807575: 248,
            137564: 250, 235875: 2285, 6500: 298, 634034537: 215,
            6512: 156, 18285631: 2074, 361077119: 173, 643406209: 1819,
            6534: 307, 1310595463: 1742, 1561625: 289, 15702430: 1694,
            11541101: 2168, 19700131: 268, 1481125: 293, 54958505: 1693,
            2021789: 271, 109189553: 210, 181606835: 1624, 14719414: 1952,
            432575: 272, 18192839: 243, 39368: 2416, 18815433: 1662,
            14096842: 208, 32971213: 75, 6615: 308, 2924938319: 167,
            30120415: 1847, 374151649: 50, 290494955: 24, 399854: 103,
            6642: 143, 104949: 306, 563567017: 1614, 51517949: 1952,
            6664: 320, 319923: 305, 59873807: 1887, 1516922633: 203,
            104536619: 198, 756750899: 215, 274864697: 1876, 72250: 293,
            110994339: 1808, 104897089: 1839, 151427653: 1773, 39501: 2383,
            1863875: 2281, 81533543: 173, 6760: 318, 480975469: 1808,
            5085806: 1914, 186813: 2351, 373758583: 1633, 6776: 319,
            42801785: 185, 39546: 261, 133470655: 1690, 531069: 2185,
            105847423: 1780, 125115019: 1952, 59611791: 1763, 29006483: 2149,
            168991381: 209, 3561925: 248, 3513003: 95, 10361517: 2020,
            9673391: 2087, 3021495: 2014, 60267193: 196, 432837: 2339,
            15877239: 1834, 6860: 286, 105165: 2340, 21961435: 219,
            9280227: 1946, 301796: 238, 6885: 149, 6888: 2410,
            5184245: 2142, 144251653: 1642, 26876678: 51, 1219335: 2090,
            39688: 319, 1743625: 2282, 68688653: 2007, 2824975: 248,
            18023555: 198, 891670: 1993, 6936: 317, 3512795: 2057,
            72488: 2407, 850956599: 1808, 273685291: 171, 596781: 301,
            3152695: 2079, 2726715: 2024, 2715556321: 12, 30645065: 186,
            40115023: 253, 6992: 159, 134355811: 2008, 12819306: 1629,
            4660076: 190, 3644278: 264, 43916151: 184, 1219450: 212,
            203643: 273, 9870217: 247, 138125: 137, 2366355: 1982,
            53713829: 242, 801125: 2302, 12164009: 2152, 1153977: 269,
            163421119: 2017, 127376323: 219, 38411219: 1880, 27499479: 1651,
            81337315: 50, 2333675: 248, 7805941: 2117, 2104311: 2162,
            39928: 2424, 111746041: 42, 39930: 2201, 39933: 146,
            1359191041: 11, 204872707: 194, 7176: 2442, 7182: 2384,
            22938797: 2036, 924692: 226, 2235415: 2058, 140254235: 1616,
            9739301: 97, 23632941: 1846, 7216: 155, 13327303: 2161,
            13409345: 1978, 4430914: 76, 2137155: 2041, 31759431: 1716,
            302157: 304, 891982: 2106, 25500770: 1618, 907549801: 1678,
            5774442: 1719, 72819: 145, 90217589: 1656, 11967613: 2204,
            121365: 2357, 17800321: 1914, 137750: 2301, 5315725: 236,
            777067673: 182, 161127581: 1877, 138411: 261, 3251375: 288,
            13999286: 1815, 202972345: 1623, 5905599: 1947, 40131: 285,
            32316614: 1701, 7371: 150, 531674: 258, 2311375: 287,
            533765347: 1744, 7400: 321, 5414126: 2037, 24452335: 1962,
            348167417: 37, 26025213: 61, 7425: 309, 15768841: 78,
            6823179: 177, 7448: 320, 5762949: 87, 204085: 125,
            7480: 2454, 40250: 2312, 15525: 309, 43588945: 1941,
            94095: 2341, 2039135: 2206, 2465125: 2270, 171366: 105,
            123215209: 1877, 40017263: 65, 2301299: 2184, 925071: 2225,
            105875: 295, 4824470: 1670, 73112: 2416, 378445211: 172,
            118300061: 195, 14556577: 276, 531875: 132, 8297894: 1899,
            40365: 2376, 197696957: 71, 258317761: 1763, 466375: 2276,
            1252815: 92, 9149906: 1970, 5414358: 1827, 105944: 2406,
            99229153: 1953, 81272291: 232, 7445991: 187, 7656: 2436,
            859625: 291, 1273767: 110, 466412: 238, 182296045: 170,
            4201967: 107, 46439921: 2138, 1351155: 2080, 368125: 133,
            7695: 148, 7696: 156, 10034717: 78, 1056286: 1996,
            4726306: 2021, 3284515: 99, 213392933: 1764, 53388262: 1690,
            7722: 2392, 245931571: 1876, 4988470: 1882, 499257: 299,
            43327037: 95, 177741377: 186, 44899907: 2020, 1366625: 290,
            7752: 2447, 958035: 2059, 572251063: 171, 630375: 287,
            39100009: 96, 4038254: 2138, 1515125: 2292, 3868466809: 11,
            859775: 248, 17408149: 107, 10508907: 2028, 39165573: 1886,
            116596361: 216, 1743469: 2243, 3545710: 1736, 7830: 2372,
            2530971: 237, 43851422: 49, 2104991: 280, 4431526: 2012,
            827052: 178, 859826: 2183, 30645953: 96, 34545346: 1692,
            7875: 297, 1679046: 69, 3120845: 1992, 7888: 158,
            37265105: 2006, 40664: 2441, 82784207: 263, 194977509: 14,
            433895: 2245, 123543277: 1766, 356032241: 1755, 47390465: 1877,
            794375: 131, 96902926: 1613, 84942611: 251, 31399714: 40,
            8953637: 265, 1711913: 121, 40214317: 1945, 4300593: 78,
            403578677: 38, 8724287: 256, 1154881: 120, 9903938: 1890,
            17964869: 96, 8008: 2458, 66264913: 1847, 525625: 134,
            106330: 2231, 368475: 248, 22388626: 1721, 136611141: 1687,
            4593927: 2077, 24911783: 2102, 3841966: 87, 33693621: 1766,
            8120: 2437, 64265015: 1831, 5283785: 96, 170106827: 1875,
            1679319: 299, 1515483: 300, 827356: 226, 401375: 294,
            1187811: 2336, 1094459371: 1676, 21995501: 246, 5545967: 2217,
            532467: 2336, 8184: 2428, 139258: 122, 204795: 2336,
            8200: 321, 81567758: 192, 270351: 2359, 128131091: 1773,
            12754973: 264, 43163687: 1961, 4268075: 212, 1744941: 2176,
            3547186: 244, 41013: 308, 8250: 2331, 179970109: 1714,
            36216895: 1727, 303186: 2115, 6168669: 221, 20324447: 254,
            4071529: 2176, 3383402: 2139, 50962549: 2009, 540386: 2172,
            271753345: 25, 128000131: 183, 3350666: 2031, 137961613: 62,
            2629781: 2209, 3447493: 279, 6398117: 111, 951665: 114,
            8360: 2449, 73899: 2375, 204974: 115, 1801068721: 24,
            8370: 2364, 979780979: 181, 9380021: 2206, 9511098: 1646,
            73926: 300, 2972365: 246, 14164179: 241, 16130261: 2204,
            14393561: 221, 8432: 157, 457023731: 194, 631028: 238,
            394625: 2277, 336141: 261, 132063503: 41, 8464: 159,
            15737111: 98, 74008: 314, 11051293: 268, 37662769: 76,
            216756545: 1614, 8500: 298, 73343287: 232, 205114: 2244,
            365207869: 1744, 57811271: 239, 8528: 155, 1024338: 1869,
            2923235: 91, 22618453: 221, 10789207: 234, 1501995353: 1610,
            5480797: 278, 1818204901: 1610, 133374307: 198, 106856: 316,
            283058547: 167, 55550326: 1625, 560374139: 26, 6385729: 79,
            6431117: 90, 7774625: 287, 11674018: 1953, 74152: 2424,
            565675: 272, 13672879: 246, 22192562: 1644, 1286593: 283,
            41886146: 1755, 18031057: 2160, 785916371: 36, 8664: 316,
            79438297: 2019, 8680: 2429, 139755: 2198, 963584501: 12,
            8694: 2378, 57418231: 2027, 53551617: 1617, 2007555: 1931,
            600187397: 184, 168927755: 1697, 8750: 140, 40378933: 230,
            4465209: 1966, 38445627: 1709, 8775: 309, 39068237: 221,
            3088982: 2086, 33301079: 64, 7709273: 258, 12460638: 1685,
            357429349: 227, 5939817: 2030, 8816: 158, 122069623: 228,
            74375: 137, 8840: 2453, 1581710: 1927, 74385: 2367,
            41625: 297, 2171546: 89, 23601819: 1951, 23324: 286,
            34874026: 1643, 8921773: 276, 5415605: 2104, 99590845: 172,
            149889727: 227, 245703365: 1622, 47293129: 65, 107217: 304,
            416588509: 49, 33465061: 1944, 476625: 2271, 303875: 2321,
            9806602: 1898, 3121937: 259, 483042067: 216, 93692695: 1756,
            893730: 1805, 14852901: 55, 41769: 2387, 9016: 320,
            8135491: 255, 187474763: 37, 1549132: 202, 48112465: 1780,
            9048: 2435, 1090397: 281, 1876833: 201, 71148407: 1943,
            49193869: 85, 95658901: 197, 8168347: 268, 2349893: 2228,
            1581986: 2047, 2663331: 2168, 9126: 306, 41912: 318,
            5075103: 2139, 63742913: 221, 252747: 2349, 402375: 2282,
            205770: 2003, 31925201: 1854, 9118681: 2162, 14132187: 189,
            771579: 299, 173030: 2195, 12395499: 242, 53289965: 1838,
            173043: 2368, 3548155: 2117, 795644: 238, 74750: 2310,
            16720907: 275, 271377: 303, 105915423: 1680, 1418284: 190,
            328180787: 1689, 337781821: 173, 39363649: 2075, 1680455: 235,
            406692937: 24, 42066: 2340, 360981589: 207, 14689370: 1703,
            5809245: 1795, 1523360863: 168, 2073698: 2142, 9315: 147,
            107625: 2278, 276210809: 1679, 48997501: 211, 1090686: 2025,
            24370027: 76, 74888: 2415, 39788: 286, 9348235: 2085,
            424518797: 59, 29500559: 1978, 2565266: 1986, 1343890579: 1610,
            60236954: 1640, 47326367: 265, 402597: 2347, 23409: 149,
            9384: 2441, 124953773: 175, 41231542: 30, 74936: 2433,
            102409411: 1846, 29762759: 2094, 54011083: 199, 9424: 157,
            123315413: 252, 894166: 2058, 7775451: 201, 1909985: 2145,
            337125: 2291, 333391081: 39, 692724971: 170, 23340273: 54,
            10200308: 178, 9464: 318, 147793151: 198, 42250: 294,
            183185779: 48, 80979223: 2073, 9500: 298, 1114383649: 1612,
            795938: 2178, 58238245: 173, 2532650: 188, 33629485: 240,
            805479727: 1621, 6104371: 276, 5219643: 1925, 18949441: 2037,
            369761165: 1611, 5134085: 2052, 140630: 2212, 42328: 2418,
            531509477: 1819, 3024236: 214, 10069358: 197, 25745533: 266,
            9604: 130, 75141: 307, 501126: 93, 15771019: 269,
            72918418: 170, 196650391: 1744, 30746009: 219, 337311: 301,
            632225: 272, 5809573: 234, 9639: 149, 435625: 131,
            476030389: 193, 13444535: 1919, 25994683: 2021, 3589707: 2159,
            173512: 315, 39560654: 19, 10560979: 2110, 42471: 307,
            206312: 2402, 272309159: 228, 1648115: 277, 173558: 2245,
            6333951: 253, 206346: 2067, 1130235479: 170, 14755345: 210,
            9750: 2328, 5285401: 112, 42532: 286, 960039: 301,
            9768: 2419, 27436585: 1880, 474162733: 26, 42903091: 186,
            61449781: 232, 7579195: 1985, 10135111: 223, 9801: 151,
            140875: 296, 1418846: 2144, 183674465: 17, 1910375: 2291,
            99944: 313, 136160897: 219, 207824527: 1895, 1681043: 282,
            698005: 2221, 9880: 2448, 108701338: 25, 16844399: 2077,
            26715805: 71, 10462881: 1859, 296429221: 1641, 132261547: 52,
            21145263: 208, 42687: 145, 566979: 2235, 4925125: 289,
            453800227: 184, 17475285: 1711, 6825687: 1920, 599781: 103,
            9643754: 72, 9990: 2355, 68364049: 254, 1124125: 291,
            206625: 2301, 375826213: 15, 26584895: 63, 553789249: 181,
            61750: 2316, 173901: 282, 10064: 156, 108375: 293,
            108376: 2424, 196355929: 1616, 171419483: 2006, 57288543: 1700,
            42849: 147, 75625: 139, 632684: 226, 10098: 2388,
            157624181: 1757, 534394: 2208, 98281346: 1622, 34042177: 245,
            10120: 2443, 468875: 295, 16885645: 175, 2992017: 2040,
            206739: 2359, 91629473: 208, 5318565: 1736, 42920: 2414,
            40576945: 62, 2404722611: 11, 3286969: 120, 19244986: 1780,
            298297283: 39, 29042629: 1899, 57485279: 232, 21571555: 1954,
            3483625: 289, 1419262: 2117, 83729409: 1698, 541632529: 28,
            13182998: 229, 43001881: 255, 5875748: 190, 81995818: 203,
            272428: 262, 501809: 124, 10290: 2267, 43065: 2370,
            141375: 2303, 30716257: 2073, 24520783: 2028, 763994: 2145,
            3745885: 2097, 32024671: 1970, 241182821: 49, 18950253: 1825,
            165755005: 1615, 161556593: 1765, 43125: 135, 10360: 2420,
            2762875: 289, 29567109: 1661, 40315017: 51, 1222795: 2226,
            141453: 306, 440936591: 195, 862353: 299, 162113683: 208,
            321792149: 1631, 50997399: 1812, 10395: 2396, 1648801: 2242,
            43173: 143, 174250: 2275, 45689006: 1682, 11841907: 2139,
            4729043: 112, 6564063: 1973, 10472: 2454, 94087411: 1887,
            10488: 2440, 32975103: 1693, 108964101: 1624, 3418375: 2272,
            174344: 2413, 72231178: 1688, 61024523: 1941, 2042125: 289,
            30681362: 1822, 2238742: 266, 681559769: 1621, 2107677: 2057,
            24815903: 199, 17639713: 2083, 6990114: 1712, 4204837: 2207,
            189999403: 186, 10955077: 275, 436563: 2349, 347023703: 1690,
            76125: 2305, 444213601: 36, 1144301923: 1677, 30976363: 264,
            80161133: 1961, 76146: 2223, 43384: 2434, 16230778: 62,
            24586627: 256, 76167: 2361, 10365325: 212, 8628622: 1954,
            895375: 2301, 1321375: 289, 1812897: 249, 338338: 2128,
            717213: 2209, 10672: 158, 8530379: 2170, 731601: 261,
            960982: 268, 42510809: 263, 535002: 1994, 550971899: 47,
            8464897: 2216, 679041: 237, 252815881: 1941, 1124876: 238,
            228305429: 1820, 731670: 1871, 117189145: 205, 1387038: 1917,
            159132193: 1876, 1098066469: 35, 47360555: 1722, 4598321: 99,
            138553909: 1838, 10824: 2409, 45276259: 1943, 43605: 2381,
            404054: 2227, 587508311: 1742, 240219: 2337, 76383: 143,
            43624: 2406, 469625: 293, 240250: 289, 14133889: 2138,
            233864: 2403, 472177771: 1624, 38251155: 1618, 371349: 273,
            207515: 283, 8661663: 189, 45427369: 2093, 3189435: 1967,
            4008641: 2225, 109250: 2308, 291089101: 228, 416888: 311,
            10962: 2371, 666333: 2348, 273125: 135, 57649895: 227,
            174824: 311, 40905454: 215, 9153287: 267, 59550473: 85,
            371469: 280, 257469199: 1707, 8104733: 2096, 9218846: 1728,
            4369183: 235, 1995778853: 180, 48474921: 1701, 6302506: 1891,
            600875: 2308, 535348: 226, 449673: 2242, 1223481: 2206,
            172698427: 40, 11070: 2345, 14232383: 269, 2829124: 58,
            15510341: 2012, 797511: 258, 174933: 2359, 2894682: 1671,
            173353829: 194, 928625: 2308, 76664: 312, 5811065: 255,
            13806463: 107, 11152: 155, 44407961: 2074, 43928: 317,
            81177499: 2007, 43940: 262, 76655527: 2072, 11643819: 1907,
            81537967: 1773, 781495219: 1631, 5876661: 67, 184990565: 1808,
            174664633: 1747, 2993082: 1883, 16133051: 2160, 17574855: 1658,
            23047115: 1728, 306130: 2180, 114994135: 1810, 676572121: 27,
            21998561: 2095, 306153: 2366, 54471659: 222, 11248: 156,
            1584125: 2300, 273429: 2340, 11286: 2383, 22359063: 2006,
            1891505: 2062, 142376: 312, 2763826: 2087, 35105863: 254,
            76875: 131, 44182609: 87, 4795483: 2205, 11368: 320,
            88026221: 2009, 33959029: 95, 51162235: 218, 13479037: 2142,
            45395077: 1879, 2239625: 2273, 11408: 157, 38579345: 1759,
            33860761: 66, 35892389: 253, 339160241: 1613, 11475: 309,
            11480: 2410, 45591773: 232, 699618: 1989, 29207785: 2008,
            1852910827: 191, 11500: 298, 1989845: 2178, 2292519223: 1610,
            7187719: 2052, 5975305: 211, 127773971: 209, 109599961: 74,
            11544: 2418, 109850: 260, 21998878: 1814, 50703653: 1727,
            11560: 317, 19541291: 1956, 1584429: 1996, 7089459: 2021,
            11583: 150, 28257610: 20, 41528654: 1746, 7482705: 1882,
            29241: 148, 181185881: 1838, 1617245: 2207, 317205857: 218,
            1634875: 2272, 2043251: 120, 87436661: 240, 228109687: 39,
            383102329: 60, 61844861: 64, 765325: 272, 830875: 293,
            12365223: 209, 287863367: 48, 25931191: 2084, 11704: 2449,
            372155: 121, 12332482: 1961, 11718: 2363, 339405: 2191,
            12824018: 1897, 11745: 146, 90385894: 1742, 65777133: 49,
            3943925: 236, 3889277: 2234, 142857: 2352, 1289739: 2183,
            51818019: 1692, 568875: 2270, 91074094: 1687, 339512: 312,
            268447295: 15, 869576257: 1610, 97688843: 1885, 3616327: 112,
            208842319: 1689, 44625: 2323, 44631: 146, 34778714: 1829,
            9514594: 64, 9023079: 252, 2731625: 287, 690105973: 1623,
            7581310: 1667, 78360191: 1721, 619115: 280, 175750: 2284,
            23670409: 1971, 5713547: 235, 7581329: 277, 11934: 2387,
            14986915: 75, 32517797: 256, 339625: 2316, 34998215: 1815,
            536238: 201, 47099571: 40, 1032662711: 25, 208568: 314,
            65062859: 83, 1891617: 2079, 732875: 2276, 9121486: 1854,
            6598358: 1955, 331165405: 168, 13446881: 87, 14855907: 1890,
            92286695: 1874, 169717483: 1886, 14724853: 2151, 3321591: 1926,
            78917374: 1679, 836939519: 1676, 77571: 306, 13348621: 2051,
            67874587: 210, 52932385: 1716, 13250361: 2027, 1350965: 2172,
            9449297: 2111, 410562397: 1612, 49753951: 2010, 19029307: 266,
            3485547: 201, 110446: 123, 5812079: 245, 12152: 320,
            995193: 2337, 5779325: 224, 2011009: 2210, 2895746: 1921,
            301739921: 26, 3583892: 178, 208791: 2350, 50704282: 1754,
            80791535: 1701, 174698407: 51, 236498857: 1697, 1027223471: 193,
            13316017: 2103, 1322951: 122, 6643021: 2160, 106016729: 1708,
            12250: 296, 765919: 122, 34942947: 173, 305573861: 239,
            1519590: 1739, 143336: 2405, 9842665: 1947, 40775665: 1710,
            208887: 122, 12285: 2393, 241670: 2129, 1050625: 131,
            181088267: 2007, 143374: 2251, 77841: 145, 1867018927: 1676,
            285487153: 192, 66302002: 1615, 19705907: 233, 1749045: 1988,
            59289659: 1853, 3223625: 2270, 5320779: 244, 193015889: 39,
            7090258: 1789, 12375: 297, 12376: 2453, 111194213: 1887,
            47526011: 233, 129609853: 2017, 1382875: 2283, 16461951: 1880,
            844902539: 14, 7581847: 2104, 17608858: 207, 16822429: 97,
            938029217: 192, 12464: 155, 148686881: 38, 54997195: 1814,
            5025999: 2031, 964975: 272, 1264300249: 36, 41988317: 1905,
            2633956: 190, 241893: 305, 102510831: 36, 14070001: 109,
            2437375: 2281, 1683715: 111, 307461: 115, 405769: 126,
            12555: 145, 19509523: 244, 14266647: 177, 1814813: 2220,
            4501790: 1892, 1061151: 2113, 4141345: 98, 12584: 319,
            110889: 144, 133673267: 1700, 45375: 295, 103821635: 1746,
            289812805: 169, 535452863: 180, 11022670: 1760, 272937299: 207,
            33993047: 84, 438625: 295, 3191139: 189, 45414: 302,
            12648: 2426, 38678893: 220, 512962931: 1679, 239317369: 1940,
            5583226: 1956, 58241405: 1773, 45448: 2440, 16462225: 188,
            12696: 315, 114340249: 84, 51130781: 252, 122892703: 71,
            1320574363: 181, 226287: 305, 1192366: 223, 12661175: 200,
            9023930: 1826, 59415969: 1707, 12750: 2324, 1351075: 248,
            307671: 2244, 12760: 2436, 6762974: 1971, 130101731: 220,
            26358245: 2018, 1132625: 2275, 733677: 2226, 635375: 2309,
            12792: 2408, 37526957: 2093, 101265941: 1876, 12825: 309,
            2508935: 2171, 95531558: 1678, 78375: 2317, 569908: 250,
            766521: 225, 30290494: 1708, 242242: 2194, 11481681: 2010,
            285815387: 1634, 5878375: 2270, 864875: 2285, 25828797: 196,
            17511027: 1953, 12920: 2447, 1023849089: 1677, 373388: 250,
            32060045: 1897, 62829219: 1755, 18100901: 1972, 340659: 2347,
            2601655: 2204, 176824: 313, 30847677: 1702, 340676: 226,
            219099859: 172, 69120727: 63, 111321: 2359, 439002: 213,
            72687055: 1683, 13041: 147, 373490: 2125, 18428663: 246,
            14234363: 2095, 39629575: 176, 492974857: 47, 250393355: 191,
            201143063: 183, 235346281: 62, 18330403: 2011, 22950693: 177,
            13087529: 2085, 379015: 2255, 14332726: 1896, 45880: 2413,
            1913661: 237, 13125: 140, 2798410: 68, 753513293: 169,
            12459491: 108, 724185941: 181, 2208598: 1981, 149173085: 1689,
            6992741: 2216, 11187055: 263, 227685235: 1687, 4633473: 2086,
            45954: 2349, 1520519: 2229, 18690957: 189, 206123929: 1756,
            308125: 134, 8494577: 2051, 13224: 2433, 44217257: 211,
            25441197: 1878, 3486639: 255, 3388346: 77, 71218118: 27,
            46035: 2362, 2372565: 1927, 1335985: 2208, 86946785: 1829,
            3257319: 89, 111592: 2414, 21509102: 195, 42333011: 199,
            34986: 2258, 52311039: 1643, 858665993: 1742, 118993931: 1812,
            537625: 2309, 13338: 2382, 424522793: 184, 78890: 2246,
            46125: 297, 40776755: 1942, 473969717: 170, 1586234: 256,
            18953275: 176, 275517: 273, 139834433: 72, 215528515: 26,
            90846283: 239, 55948366: 1819, 439375: 132, 1422421: 2237,
            23147607: 1759, 865389: 278, 2602105: 2177, 242811: 303,
            13456: 158, 767125: 292, 3585183: 211, 46250: 132,
            930987: 302, 5596855: 266, 19406365: 1907, 111475: 284,
            4928693: 267, 10106041: 90, 24949947: 1833, 601896131: 48,
            16954566: 21, 7386314: 251, 18822349: 1919, 213431503: 230,
            93238483: 252, 56997093: 1811, 111848: 2403, 68531437: 2018,
            4699383: 2094, 124859645: 1699, 79112: 2423, 127875: 2296,
            16495895: 1955, 194426141: 1625, 31831327: 2029, 2307361: 121,
            46376: 2426, 61682987: 231, 25769263: 232, 13616: 156,
            4633910: 1850, 32814399: 1895, 110245187: 1878, 13640: 2428,
            210250: 290, 20657483: 210, 25998674: 1813, 161068377: 15,
            13662: 2377, 111969: 2369, 2372979: 2047, 13689: 150,
            27735421: 199, 70169983: 251, 79233: 127, 171585: 2337,
            275848: 314, 209106314: 11, 16954763: 86, 8992149: 75,
            187568059: 182, 33704177: 255, 308655: 237, 13750: 139,
            257144251: 17, 75281857: 195, 270251459: 229, 144855: 2348,
            46552: 315, 177625: 296, 505310: 2114, 2045407: 259,
            6665698: 2072, 29373926: 1765, 46020071: 86, 77673967: 175,
            810579: 2172, 37729783: 1853, 1193466: 1976, 112125: 2310,
            127792043: 240, 123919958: 1621, 13832: 2448, 177674: 120,
            37402127: 71, 75085379: 85, 2700875: 2271, 46683: 2382,
            15709793: 108, 10204777: 107, 145002: 2130, 52442731: 265,
            1947253: 112, 570999: 114, 1783419: 246, 6010498: 1913,
            22034055: 1703, 243340: 226, 276115: 123, 1673497: 119,
            538265: 259, 79515: 2359, 46750: 2322, 13986: 2354,
            32323235: 43, 11155111: 269, 3258025: 80, 4273841: 270,
            23606965: 241, 218576567: 1763, 1128127: 2244, 3552962: 1957,
            309081797: 50, 776681161: 37, 5551819: 256, 13617443: 276,
            355677911: 59, 21804761: 232, 34420443: 59, 219330277: 206,
            90355431: 1640, 62556455: 1715, 8959730: 1663, 8375983: 2159,
            126760705: 1754, 79625: 296, 29094871: 2076, 6764303: 2204,
            61847313: 30, 2701074: 1893, 98901635: 19, 3666905: 2169,
            512014109: 1640, 37992229: 2020, 1718054: 2111, 13514543: 277,
            14136: 2425, 68989921: 1661, 34944843: 1773, 866125: 294,
            933672787: 1622, 9877335: 1729, 14168: 2443, 702297: 300,
            73359: 2382, 188986343: 1681, 17459645: 1881, 810645: 2063,
            32847749: 2150, 5584774: 2073, 1151809433: 191, 15775643: 245,
            66346651: 1877, 14250: 2319, 1193907: 2178, 9058231: 2095,
            13934239: 268, 265828297: 1632, 1480739149: 1676, 15906781: 2152,
            283162591: 216, 276458: 2229, 34027499: 234, 3520495: 267,
            7092211: 2225, 47096: 314, 210945: 2212, 196009643: 227,
            350468107: 28, 604175: 260, 5224466: 2074, 4536354: 1836,
            120993829: 210, 14384: 157, 178227: 2339, 309304: 311,
            6523231: 270, 14406: 129, 178250: 2292, 931931: 2250,
            211048: 2413, 89503851: 1689, 342125: 2309, 112750: 2277,
            4470895: 2088, 19642485: 1652, 128759926: 1676, 26032253: 257,
            3750019: 278, 309386: 2211, 342171: 2366, 90388643: 63,
            14500: 298, 14504: 320, 866481: 2164, 1423539: 225,
            637130: 2107, 2078923: 2235, 9746639: 235, 26949845: 1853,
            14553: 308, 87734495: 39, 47334: 2247, 80104: 2425,
            342250: 288, 129317109: 26, 64207099: 1953, 639088901: 24,
            1882375: 288, 64076045: 1709, 188600137: 1821, 309519: 249,
            14625: 297, 833833: 2255, 228407597: 1746, 42481966: 38,
            1390895: 112, 898101: 2347, 4962625: 288, 20199755: 73,
            69777745: 1885, 100750: 2295, 809384287: 181, 9222499: 270,
            2144614757: 169, 2537830: 1958, 182827367: 195, 145775: 284,
            44022145: 207, 406593: 300, 6015386: 252, 78313079: 209,
            39336365: 1951, 4143542: 2075, 47560: 2404, 866761: 124,
            108116437: 1832, 94163927: 185, 16628183: 265, 47004122: 1626,
            51919325: 188, 297381: 281, 1456611: 101, 3258875: 290,
            80263681: 85, 145928: 2414, 43399689: 1876, 2144779: 282,
            22559251: 1979, 46086677: 1787, 14872: 318, 47656: 2415,
            46414378: 1745, 123969287: 1839, 13875757: 232, 304691777: 205,
            22946962: 59, 13220433: 189, 146004: 226, 47709: 145,
            14465631: 72, 834148: 202, 233650813: 38, 735875: 290,
            14985: 144, 246987403: 1811, 1489550: 200, 24754835: 55,
            18142719: 1768, 146072: 313, 34323107: 1898, 379335: 2186,
            637637: 282, 47817: 2377, 11254475: 224, 3422926: 2076,
            20363993: 97, 320977627: 60, 6961885: 1974, 387850021: 1689,
            124402405: 171, 15080: 2435, 706558697: 25, 106019563: 1942,
            15088: 155, 15092: 286, 7256822: 231, 3128055: 1802,
            15096: 2417, 152877821: 242, 210057991: 1700, 66304777: 1722,
            441099: 301, 3455756: 202, 1850125: 292, 4438798: 1860,
            48315157: 219, 2112297: 267, 25803562: 206, 15147: 149,
            211761: 2358, 4111158: 1778, 801591: 2208, 736078: 2216,
            1995917: 279, 13712209: 67, 53590874: 182, 4438885: 2168,
            80750: 2315, 5094261: 201, 41007995: 1657, 21744547: 265,
            113535: 302, 375687: 261, 3455881: 102, 5421962: 1794,
            539539: 283, 1226587037: 167, 670625: 132, 342950: 236,
            1948583: 2242, 16169907: 1853, 52640697: 39, 9911255: 232,
            20659165: 242, 7715807: 109, 78618449: 1766, 834537: 112,
            146410: 116, 13482989: 256, 295619069: 1829, 146421: 2368,
            48125: 139, 70532099: 1897, 991431169: 26, 1522698: 1959,
            15376: 157, 142195729: 1895, 19774497: 229, 997080107: 1612,
            15316147: 1973, 122993727: 203, 408642: 2100, 15435: 285,
            22559825: 212, 357561: 2340, 237714529: 183, 572177509: 1874,
            7748713: 2206, 319125: 2283, 2342002: 95, 3882099: 2095,
            81016: 2406, 2014330: 2014, 15498: 2344, 15500: 298,
            38909123: 2139, 6634649: 278, 9682075: 200, 1986509983: 11,
            219069601: 71, 86654117: 1846, 179375: 131, 146625: 2309,
            2243788: 214, 1817810: 2024, 16989401: 2086, 85727335: 1821,
            12313081: 110, 4177131: 1974, 10992879: 201, 15606: 305,
            29277434: 184, 1981694: 2078, 68533509: 1682, 394345741: 1820,
            433719853: 1621, 1883413: 281, 15640: 2441, 615988507: 37,
            769318: 269, 343343: 126, 258986791: 1808, 3557939: 2207,
            245841207: 13, 18332986: 1651, 4185995: 2153, 136920397: 241,
            35077461: 217, 55819606: 1698, 7912795: 2140, 238828895: 1678,
            1031525: 272, 48488: 2433, 22789481: 2075, 12959085: 1769,
            107101553: 251, 77774201: 1970, 23903615: 1944, 5946753: 232,
            1424770: 2041, 59850119: 199, 108346767: 1688, 45894211: 266,
            376216: 2402, 341917081: 18, 46022043: 1822, 3849628: 190,
            3358113: 266, 48546: 2357, 186858917: 1690, 703917: 302,
            265371067: 185, 617463239: 172, 17120714: 185, 107363789: 239,
            308559317: 174, 81375: 2297, 958375: 2275, 1920759349: 168,
            437992955: 12, 500907517: 1687, 17350142: 61, 195051013: 240,
            1129990: 2048, 8699405: 1925, 284161283: 1623, 1261078: 2079,
            114219: 285, 4701741: 2039, 258522671: 174, 7397299: 96,
            22934795: 1906, 114244: 106, 241843789: 174, 11943503: 89,
            107069009: 2017, 933470: 2054, 48735: 304, 15972: 274,
            4832875: 287, 749715053: 183, 90045: 2366, 507507: 2128,
            7462847: 247, 448987: 125, 16008: 2432, 835210: 92,
            16793227: 108, 4963994: 187, 849178: 110, 45694623: 1655,
            900770: 2080, 191807143: 174, 4406961: 2045, 16065: 2389,
            74915787: 1699, 9780934: 1962, 802503: 237, 114376: 314,
            147147: 2260, 65093335: 1772, 81634: 125, 158449379: 174,
            69484261: 1824, 191282927: 1829, 19349239: 1964, 16120: 2427,
            141770497: 174, 212750: 2283, 1687314: 1949, 147231: 2340,
            1097505: 213, 3170271: 96, 2080557: 225, 540462: 2081,
            376623: 2348, 147250: 2293, 8240947: 258, 48951: 308,
            16184: 317, 73744187: 1904, 108412733: 174, 47169343: 231,
            5261963: 279, 145407817: 1887, 206421839: 197, 300269393: 60,
            7257943: 2142, 933725: 260, 237846371: 1633, 343910: 2066,
            2867062: 78, 16250: 138, 186990463: 1812, 606081: 2227,
            110903171: 72, 74989447: 230, 12337039: 2160, 245650: 248,
            58376087: 174, 16280: 2419, 18956186: 1877, 696303: 2336,
            3241147867: 11, 12435367: 235, 10305449: 222, 44867571: 1627,
            41697205: 174, 3817401: 2023, 4800445: 2110, 147390: 2069,
            15089599: 2204, 25739207: 245, 49096: 316, 22462414: 1766,
            16335: 307, 25018323: 174, 28852187: 209, 966625: 2284,
            63324131: 2072, 255279079: 1745, 573417: 261, 2113514: 96,
            580894709: 36, 81918: 2336, 35831815: 1896, 1163294: 2176,
            475167: 2190, 436977713: 1810, 6996025: 68, 16443: 146,
            4112446: 221, 16456: 319, 814694477: 1743, 5521495: 1981,
            61358181: 215, 2280125: 2282, 133021811: 218, 35242105: 208,
            71647355: 1757, 6340732: 178, 95895679: 1941, 213125: 133,
            255443079: 179, 7266327: 86, 167723153: 206, 2279921: 281,
            180375: 2286, 193577113: 241, 397918387: 195, 36028603: 255,
            9453759: 1891, 159629507: 228, 114885: 2349, 638828749: 1622,
            803022: 1932, 999635: 103, 199375: 134, 16605: 143,
            26722527: 1774, 425738465: 179, 4243686: 57, 3129581: 247,
            6013189: 2111, 4342023: 177, 1327375: 2270, 7749909: 189,
            352993559: 196, 344375: 134, 10273083: 83, 8470865: 77,
            35701078: 1617, 16728: 2407, 2474329: 114, 17514845: 2028,
            1687903: 120, 16744: 2442, 178045295: 27, 82308: 238,
            229851535: 1631, 75940241: 2008, 21315986: 1838, 8307092: 190,
            442773: 303, 36290969: 1955, 21053851: 252, 147875: 294,
            672182: 235, 4284489: 2150, 19907017: 95, 147928: 311,
            155727: 273, 141607399: 2006, 16872: 2416, 3654125: 2271,
            936624623: 179, 12599795: 2083, 180728: 2404, 217858553: 1707,
            74105339: 1716, 17121805: 83, 13451794: 240, 8864275: 188,
            16929: 148, 1494827569: 14, 125092409: 1780, 183222853: 216,
            1106920009: 179, 4145739: 2087, 7225933: 99, 1655375: 2274,
            6275665: 2141, 279125: 2304, 279128: 2402, 14551823: 266,
            5292645: 1909, 52338794: 48, 3031678: 1985, 63452609: 230,
            377487: 2337, 9421458: 1695, 1195355: 2209, 82593: 2374,
            279202: 2221, 34325159: 2138, 2179765: 2205, 18072249: 1847,
            45990593: 2019, 139870915: 1819, 108249799: 1875, 49875: 2318,
            17112: 2424, 1078735: 2219, 23970527: 83, 251577059: 61,
            10633958: 63, 390609: 2349, 7750379: 223, 1447510781: 179,
            17150: 284, 35242753: 197, 25660203: 1887, 17168: 156,
            13779731: 235, 259545: 2195, 148257: 305, 17199: 308,
            17226: 2370, 27509587: 1912, 1753941: 91, 1617806167: 179,
            1368930181: 204, 17250: 2313, 755286883: 24, 3847899: 1986,
            50024: 318, 18826093: 2076, 255214463: 170, 30917509: 2027,
            67191695: 51, 917125: 2300, 967603: 121, 82875: 2321,
            6865859: 1991, 2376647: 282, 4146130: 1856, 114903887: 1764,
            30720989: 245, 316350629: 1742, 246753: 2350, 23224487: 253,
            42386415: 20, 9225203: 100, 30852085: 1841, 18465785: 251,
            8700923: 2046, 9997141: 2150, 2269355: 109, 46875658: 205,
            1958396939: 179, 705551: 283, 50193: 306, 19252247: 276,
            115736: 2415, 133743641: 1951, 318555163: 196, 122828293: 39,
            17442: 2381, 43959331: 1971, 8045607: 1978, 82984: 2405,
            83006: 283, 738369: 2338, 17480: 2440, 138462289: 19,
            72332815: 1876, 32425055: 1879, 4310125: 290, 3072937: 281,
            121783407: 1623, 267895927: 173, 851337407: 191, 377986: 2235,
            37667971: 83, 11650190: 1711, 61228193: 253, 18498723: 1961,
            646136999: 194, 50344: 2423, 17577: 145, 83125: 136,
            7029942: 1659, 782943421: 1677, 126829769: 227, 60081359: 2074,
            19088597: 234, 1131735: 1997, 135578841: 1742, 607453: 123,
            115934: 282, 34620641: 264, 1405092427: 1611, 38192362: 1700,
            1787125: 290, 15451385: 84, 275596541: 193, 20464894: 218,
            17581315: 220, 11584775: 212, 1459465: 2217, 2469283097: 179,
            9270831: 84, 376980773: 47, 11683114: 2008, 276546871: 50,
            95798587: 84, 143607101: 1886, 191153471: 229, 64996685: 1813,
            44516693: 83, 574821: 249, 2639578483: 179, 109004153: 220,
            181629: 301, 148862: 121, 738705: 2156, 14271891: 64,
            12633502: 1825, 116127: 2375, 6413165: 1986, 17836: 286,
            19711406: 1661, 3212881: 2235, 33998266: 1812, 17864: 2436,
            3032524: 178, 278873551: 1754, 4081105: 1987, 57099731: 219,
            522765785: 11, 4376042: 1973, 17901: 149, 132466162: 168,
            411125: 2310, 36914678: 1874, 17778167: 268, 6145531: 2207,
            51070461: 1649, 280071: 2339, 91833889: 31, 17955: 2384,
            4048429: 2216, 16119389: 2102, 29345329: 256, 2311730: 1916,
            13682229: 1854, 50750: 2305, 2373217: 2219, 4965961: 2144,
            542283: 2228, 50764: 286, 24060175: 188, 607836: 190,
            1188939361: 47, 293258855: 1612, 3165118: 2140, 18040: 2409,
            118376061: 1679, 3950206: 2093, 3150464641: 23, 811251307: 48,
            95897229: 1753, 196888211: 185, 116375: 296, 50840: 2403,
            714917533: 14, 861030053: 168, 18088: 2447, 1263275: 260,
            14468785: 2029, 16664245: 2072, 691145: 2229, 162514619: 219,
            239945407: 1874, 66406083: 1706, 9389765: 1864, 7030475: 236,
            1361613: 109, 673486: 111, 50895: 2369, 149205: 2239,
            252987097: 1810, 1656538: 98, 444125: 2315, 27521087: 2159,
            50922: 2339, 4409068: 202, 79677169: 186, 63751925: 176,
            285034243: 49, 50949: 144, 14436105: 1718, 6342413: 275,
            247566: 2166, 5064470: 1790, 444185: 120, 380454683: 25,
            84166439: 52, 83752: 316, 458966833: 1680, 1197875: 288,
            3983161: 259, 4343619: 1921, 4638535: 2143, 468590903: 181,
            2049875: 291, 247646: 280, 2804711: 2219, 1400981357: 35,
            26462065: 1834, 18073465: 1963, 239191939: 36, 5588869: 2183,
            83853: 273, 149396: 262, 100157342: 191, 18352: 156,
            767936443: 204, 4474822: 263, 18375: 296, 1034187: 2155,
            3917774: 67, 146032599: 180, 18392: 319, 2279385: 189,
            11716570: 1658, 8978431: 1986, 233719787: 204, 224544749: 1691,
            18414: 2362, 6440943: 2044, 2476019: 259, 823674871: 1613,
            159303685: 28, 59754507: 172, 1886225: 236, 215061: 2251,
            13377881: 267, 1329185: 258, 3080: 2462, 51250: 131,
            181422137: 1885, 423605: 2250, 56215617: 1756, 18500: 298,
            15026245: 1913, 51272: 2434, 3032041553: 11, 236505179: 230,
            608350: 224, 155830381: 1648, 14895221: 268, 10635387: 1789,
            1853564: 214, 1362053: 280, 774129799: 1687, 116875: 137,
            35113111: 2149, 1270129: 123, 20629687: 88, 12929215: 1972,
            8263666: 242, 19494: 304, 1296625: 2273, 477579521: 1744,
            18696: 2406, 215306: 259, 39761623: 1963, 12929294: 43,
            364661011: 1615, 195049177: 59, 13093145: 2011, 8243482: 209,
            126208291: 59, 221578: 2249, 12994885: 243, 1231175: 272,
            31410509: 254, 331303247: 1640, 3950934: 1730, 474466651: 1698,
            22399325: 176, 3132: 310, 78760303: 83, 379250: 2270,
            10439033: 109, 5556603: 2038, 84378: 2213, 134990245: 1681,
            24278771: 2150, 294603199: 37, 432622019: 217, 1788358: 2088,
            156065: 126, 226773481: 30, 15092209: 2168, 16534005: 1760,
            2214394: 1926, 85117435: 1649, 14502397: 2075, 154192391: 62,
            8079902: 73, 249678371: 196, 8833574: 2027, 9429425: 224,
            110316073: 194, 174803503: 1699, 702964147: 1808, 8374839: 1956,
            6933059: 2206, 343984711: 1622, 19024: 155, 84568: 313,
            182875: 2317, 204098141: 40, 37046891: 211, 173951599: 218,
            275761777: 240, 6214945: 2046, 51832: 2425, 164514427: 1626,
            903805: 2228, 1788549: 223, 1460875: 2291, 19096: 2428,
            19125: 297, 51894: 301, 26790589: 2010, 101141183: 53,
            49760962: 171, 81971909: 72, 19811015: 1783, 10144461: 1971,
            1166030: 1988, 12110545: 86, 3590867: 280, 4099193: 2218,
            371641061: 1697, 159828715: 1753, 21547757: 66, 113593083: 35,
            16403198: 1657, 3754751: 2163, 67357451: 1780, 1461005: 2119,
            1053319643: 1621, 19240: 2418, 64375597: 1889, 64441135: 1656,
            19250: 2330, 4574003: 247, 110676805: 1706, 68340554: 36,
            2640715: 1996, 96848719: 207, 46904: 2408, 11815765: 2021,
            45435741: 1708, 673008481: 1743, 248675: 284, 805732: 250,
            19305: 2392, 707434: 2113, 2247531: 2097, 1493875: 2284,
            12471175: 224, 70241161: 86, 162450323: 1745, 23088025: 44,
            16501667: 2084, 10800041: 276, 32721838: 1714, 84915: 2351,
            71977913: 187, 986271: 2184, 609212: 250, 478142: 2209,
            412610: 2165, 6114251: 258, 632807929: 180, 84952: 2402,
            412641: 2357, 99306469: 83, 18566119: 2150, 19448: 2453,
            4967417: 2117, 175197182: 12, 674817: 270, 260337: 2245,
            52250: 2317, 3394593: 225, 511014: 1935, 13061165: 2074,
            7654454: 2010, 113331257: 1941, 4377659: 111, 216125: 2316,
            1625151: 108, 73092279: 29, 26037334: 1772, 190303321: 184,
            11914331: 2104, 248936: 314, 14108963: 234, 189877355: 1632,
            216172: 250, 19575: 309, 20565118: 1702, 109628555: 49,
            33049751: 241, 83283115: 216, 1920178: 2110, 106155191: 83,
            445625: 133, 2149565: 2183, 65981641: 1905, 8473829: 2103,
            10254205: 1979, 34589937: 227, 85239: 2343, 1723645: 2155,
            28658942: 1757, 52479: 285, 85250: 2296, 19720: 2434,
            243387665: 180, 7326995: 2102, 16960798: 1878, 4962181: 2217,
            79750: 2304, 321899815: 1676, 10734905: 2044, 2673979: 271,
            96652621: 2072, 773465: 2211, 309022043: 1744, 86363365: 1692,
            80956777: 1952, 5000567: 269, 183678: 2181, 68996481: 1810,
            4607375: 2271, 105500057: 62, 3198363: 2032, 576926: 278,
            123462: 237, 5213425: 200, 445875: 2272, 2510266: 2141,
            2117058: 1910, 11980241: 2076, 16633298: 1833, 78499285: 40,
            662490587: 1677, 736972253: 172, 871906: 2205, 2540359139: 12,
            32263653: 195, 59362793: 1878, 37998062: 1811, 151604477: 229,
            1592825: 260, 3132922: 2094, 347391: 273, 32919055: 1787,
            109956629: 1943, 56086043: 1954, 24759845: 1890, 20007: 148,
            85544: 317, 21876266: 1895, 52842031: 264, 52785: 2375,
            318983731: 47, 33574457: 199, 1101373: 282, 118335: 2246,
            52808: 2405, 609875: 2275, 1658452: 214, 544341: 279,
            52822: 127, 2379351: 256, 12340834: 1841, 17682025: 56,
            970347: 2207, 281875: 131, 1920633: 2154, 1232517: 2123,
            118408: 316, 117158579: 73, 181882519: 1634, 609957: 2338,
            446121: 2337, 362827439: 1698, 6180554: 84, 31215309: 1940,
            7032526: 220, 216783: 2347, 20184: 314, 37093639: 265,
            347875: 295, 2357201: 111, 147476207: 61, 310857461: 183,
            20216: 316, 380666: 114, 301747987: 1940, 126701357: 83,
            642873: 2179, 103036895: 1642, 145526069: 185, 315208: 313,
            223760201: 1753, 27447121: 97, 57959057: 2083, 20336: 155,
            10899317: 258, 5787514: 2029, 144166783: 220, 3755906: 1864,
            20358: 2369, 4542349: 2208, 2576273: 120, 395261935: 1610,
            2019241: 122, 249777: 302, 3919795: 2161, 1855414: 2143,
            53176: 317, 507188489: 1689, 154947527: 1706, 20424: 2415,
            7229386: 1963, 9261005: 2038, 905177: 122, 89706463: 1709,
            89706467: 241, 178409449: 72, 315375: 290, 348145: 122,
            24465399: 1710, 1037881339: 167, 282625: 2315, 63721474: 28,
            20493: 147, 133910545: 37, 20500: 298, 8114197: 233,
            282663: 304, 1003574: 2171, 26660933: 233, 13094990: 1652,
            17289307: 223, 35934301: 233, 58216543: 1833, 118881: 2351,
            20566117: 2085, 1003625: 2281, 25022582: 1715, 693325943: 192,
            8867965: 244, 1406997: 299, 5197954: 243, 42750085: 1749,
            6256663: 2216, 20625: 139, 315549: 2357, 645583007: 1632,
            5165237: 276, 151734: 2187, 55070911: 1951, 132993217: 1811,
            173887683: 169, 21876933: 1840, 140398801: 83, 961379029: 1611,
            1265875: 2274, 44060889: 1765, 602165483: 1743, 1790199: 237,
            185879937: 1621, 250125: 2300, 19255577: 2151, 1672139039: 192,
            15814947: 2018, 298375: 2296, 1364275: 272, 1134903: 2062,
            971074: 101, 23056709: 244, 25776454: 1656, 3297625: 2281,
            27971933: 222, 96162149: 243, 15508199: 76, 30200177: 1954,
            4444531: 257, 53625: 2326, 49631615: 1824, 651022723: 191,
            139809163: 195, 76566931: 1895, 250263: 2358, 217503: 261,
            1560993: 2204, 44273053: 2149, 1200562: 107, 512435: 115,
            140464565: 1744, 751689: 93, 840123: 249, 20925: 309,
            4149695: 234, 23777745: 1645, 169890265: 1633, 33313246: 216,
            840159: 302, 315875: 292, 112480741: 231, 227409: 2255,
            712963637: 1809, 184815: 300, 20979: 144, 119288: 2413,
            2085370: 1802, 414207: 303, 34656769: 55, 3504215: 2105,
            45339151: 209, 813474563: 1611, 5329443: 1957, 2740772: 202,
            184875: 2302, 2413103: 271, 53816: 313, 340742731: 180,
            189321805: 35, 3396174: 1785, 21080: 2426, 250458: 2121,
            3363437: 268, 14440: 316, 8999541: 213, 21112: 2435,
            21114: 2375, 15028867: 2044, 24466053: 1942, 29086343: 263,
            1125962377: 168, 4170519: 213, 4379277: 199, 184977: 2360,
            2930798: 2102, 4051611: 225, 21160: 315, 86697: 306,
            313774763: 1874, 1561263: 2177, 2577081: 2111, 637588171: 169,
            16372433: 1965, 51434197: 244, 377541343: 1763, 1430247: 2098,
            2511597: 2153, 455522429: 182, 112775923: 61, 29577977: 1919,
            458117887: 172, 21250: 137, 3101445: 177, 54027: 146,
            73257743: 2017, 1047352081: 1687, 98063123: 230, 62149399: 1944,
            6214439: 2168, 55381469: 197, 53564218: 37, 2347835: 276,
            548457: 2210, 21320: 2408, 119625: 2304, 7328586: 1751,
            172856: 2403, 942951907: 203, 68801369: 1832, 18142055: 231,
            10310521: 100, 163894138: 13, 938875: 2282, 3625853: 277,
            21375: 297, 86913: 144, 480130: 2000, 444879749: 48,
            2282375: 289, 8311689: 45, 119691: 2361, 23384974: 217,
            65622941: 244, 8639390: 1769, 11096995: 1860, 545710: 2146,
            4903871: 278, 158016331: 1830, 28922831: 242, 525423569: 1678,
            26455163: 74, 545751: 2338, 414687: 2229, 56185826: 1744,
            54243: 308, 1659878: 234, 187573073: 1942, 64508905: 206,
            54250: 2297, 21827069: 267, 54219763: 2084, 1954815: 80,
            10277895: 1777, 29185045: 1953, 5624857: 279, 42193949: 187,
            3134494: 2039, 37533873: 1715, 57988139: 2018, 7218013: 110,
            152625: 2287, 6804531: 213, 5657655: 1901, 77321285: 1875,
            21576: 2423, 92918873: 73, 7656545: 2077, 104715365: 1755,
            54375: 134, 21609: 129, 30463082: 1655, 1332331: 114,
            404083823: 17, 2937974: 2045, 939134: 276, 54405: 2361,
            2382058631: 23, 24302729: 265, 25852099: 251, 430986397: 1754,
            19649705: 1912, 49632427: 2074, 218284: 274, 61822137: 1642,
            112055483: 229, 14603459: 257, 7853258: 1842, 33084623: 252,
            1101288659: 169, 3134677: 2218, 13554905: 1794, 21735: 2378,
            21736: 2448, 58774771: 71, 251125: 296, 21750: 2306,
            4904185: 1991, 21762: 2361, 480519: 300, 399955211: 206,
            11785491: 177, 7982639: 276, 2446625: 291, 2544934: 2023,
            2807079: 2152, 247354673: 195, 382278: 2108, 185679: 303,
            36408: 2402, 54621: 305, 513375: 288, 5133667: 2169,
            696964453: 203, 316778: 2190, 470412721: 59, 2315638: 2096,
            141383033: 1831, 21896: 2441, 19846541: 2149, 21904: 156,
            41866647: 1885, 196728223: 60, 5789095: 2096, 87464: 314,
            87465: 2257, 120250: 2286, 63722949: 38, 2170115527: 167,
            402339: 2243, 7722455: 2086, 7558618: 74, 54760: 312,
            17815018: 1774, 31151595: 1684, 710125: 2308, 187258357: 1649,
            12542889: 2019, 5723641: 2204, 151125: 2295, 2053634: 2052,
            53040647: 72, 12736009: 2096, 5166606: 1725, 576247313: 193,
            22040: 2433, 12965407: 2038, 153900593: 1635, 111924787: 196,
            265825: 284, 87152221: 1904, 3954275: 224, 322983527: 1811,
            19682923: 257, 5428865: 89, 6215313: 2075, 120472: 312,
            54945: 2353, 58310: 2257, 87185065: 1643, 5330605: 2032,
            1660594: 245, 1452281459: 191, 28169913: 228, 1693375: 2292,
            70506183: 1626, 26629837: 2094, 218834: 2238, 743125: 131,
            12179167: 1925, 55016: 315, 32265961: 187, 1824494: 79,
            5519657: 110, 22264: 319, 22075131: 1781, 37148419: 175,
            2021125: 2283, 20043529: 108, 6280972: 190, 13162259: 109,
            143205337: 1772, 5855005: 95, 6706975: 212, 26256347: 2086,
            87846: 117, 284456: 313, 153387: 2374, 33576751: 2093,
            5035825: 248, 100161331: 2018, 69621567: 1745, 186184: 312,
            1627977: 100, 386019: 302, 2228377429: 23, 317275: 284,
            8845627: 2204, 60118885: 52, 3102585: 1922, 219006: 225,
            1169294: 91, 2414511: 213, 48584657: 2027, 55250: 2321,
            22491: 308, 251875: 133, 166942705: 204, 47470579: 2073,
            11327477: 223, 17305257: 230, 251896: 312, 1333241: 282,
            10194602: 1848, 351623173: 1753, 4544525: 248, 1071125: 2274,
            14342169: 1944, 5363738: 1978, 1265327: 121, 987682847: 24,
            22568: 2427, 41572399: 74, 2054195: 2123, 5134389: 2076,
            55352: 2417, 162646783: 185, 59922499: 185, 81188938: 1623,
            352835663: 1820, 1398875: 292, 51460453: 263, 1223219297: 1676,
            185948261: 1895, 22632: 2405, 677994: 2049, 22638: 2265,
            73193585: 184, 1072945277: 47, 439212163: 1697, 6246383: 268,
            55432: 318, 18241691: 256, 317608: 312, 52025515: 1940,
            1552438801: 35, 89269279: 62, 4151485: 245, 153790: 2132,
            481474: 247, 243488971: 1706, 18733269: 2007, 22750: 2327,
            1923295: 269, 383214: 2060, 322558193: 1940, 55539: 307,
            1104117: 2216, 1556994311: 13, 22792: 2419, 11294987: 246,
            317709: 299, 612625: 294, 3954965: 2047, 198254: 281,
            22815: 306, 121125: 2315, 317750: 2271, 89708861: 1942,
            53795137: 1962, 89971021: 1831, 226625: 296, 22869: 307,
            139549015: 1698, 3823963: 270, 1071455: 2179, 88434: 249,
            514425: 236, 78797195: 194, 55971565: 1721, 3398043: 2151,
            87579037: 1715, 265050527: 35, 78829993: 1896, 88504: 2415,
            64248253: 74, 222157253: 217, 388356551: 1680, 22984: 318,
            293820883: 1875, 5724631: 111, 3889625: 290, 2972123: 110,
            907742: 109, 219615: 116, 1188946: 246, 221305331: 173,
            10967541: 1945, 1989110: 1975, 61987321: 2017, 186875: 135,
            230373803: 1755, 1268228: 214, 9624070: 1718, 449032: 312,
            2284047: 237, 176019989: 60, 15391255: 66, 23064: 313,
            228451763: 51, 14080573: 98, 49338947: 208, 3267145: 2053,
            9886289: 2204, 156916307: 239, 12147289: 1980, 82074205: 1764,
            55902: 2199, 13261409: 275, 612963: 261, 12933739: 254,
            32430713: 2009, 54352519: 2019, 137910921: 1631, 679697041: 49,
            11786905: 2084, 75881117: 1953, 350889: 2230, 39836338: 172,
            547515: 225, 77978303: 1905, 1399489: 103, 7559877: 2083,
            187083: 306, 1170125: 2283, 23247: 143, 23250: 2298,
            37477078: 1756, 4760697: 88, 84040411: 41, 36723425: 188,
            88803: 2376, 285417: 301, 43375355: 61, 154375: 136,
            17455889: 88, 154396: 274, 5528354: 1964, 149478187: 72,
            3365682: 1844, 9604915: 87, 1071927: 300, 8706873: 1855,
            15555397: 2159, 86924107: 74, 482125: 2301, 74668879: 219,
            771294911: 171, 217996139: 59, 272259949: 1755, 51436401: 1821,
            11969683: 267, 2972541: 2078, 6052735: 2103, 150592385: 1640,
            809875: 2293, 285610: 104, 4905901: 2105, 34233269: 1962,
            85833: 305, 2234325: 200, 56252: 286, 103078855: 30,
            252875: 293, 482258: 2218, 252890: 2186, 10673131: 278,
            252909: 2367, 36461555: 1840, 25486505: 1848, 460479487: 1743,
            2284545: 2033, 9533953: 2169, 23560: 2425, 1891351: 271,
            9559067: 277, 23598: 2374, 180083767: 219, 19455033: 1879,
            43047995: 196, 100555847: 1830, 7920717: 1900, 142892113: 1691,
            2088025: 92, 415554659: 1753, 3398759: 101, 416875: 134,
            9875515: 2093, 154744: 314, 72506489: 229, 18635903: 77,
            12409985: 187, 2122945: 110, 56457: 143, 80408: 315,
            3792019: 108, 2251925: 260, 7767453: 85, 1236125: 2291,
            875679: 2217, 25681071: 185, 744625: 2283, 129916085: 1634,
            56511: 2376, 391699649: 27, 517665631: 1611, 104193221: 186,
            23750: 136, 85581001: 54, 9133267: 245, 613965013: 1688,
            757625: 2301, 318681: 2348, 154845: 2347, 450976999: 203,
            1498354: 2097, 2417875: 290, 6344575: 236, 3969: 152,
            1694985: 2048, 56595: 2264, 23616791: 2044, 260791577: 208,
            149675293: 207, 89375: 138, 38559009: 1831, 45538597: 2028,
            325705003: 193, 26238254: 31, 515375: 2293, 1596725: 248,
            2874683: 281, 118644037: 2007, 287759693: 1706, 30068621: 2140,
            449878: 270, 351575: 284, 47635809: 1747, 16218685: 1849,
            175955313: 1612, 1138046: 2089, 1203587: 283, 1400205: 2054,
            7560590: 1835, 23958: 273, 122264: 2423, 646555: 2237,
            597613991: 1631, 170548651: 29, 4218285: 1948, 89523: 285,
            89528: 316, 1170875: 2301, 24010: 128, 104259023: 1877,
            44522966: 1648, 3038682: 1791, 384475: 260, 1203685: 247,
            76996073: 1814, 23059958: 227, 3694084: 46, 375873047: 36,
            14671401: 1962, 56875: 138, 417339: 2338, 122451: 125,
            122452: 274, 2711125: 291, 45997654: 1810, 190930519: 1765,
            712287: 2347, 1700901359: 1611, 10719163: 2077, 188636777: 1641,
            220779: 2351, 56943: 144, 51935323: 241, 5660290: 1784,
            1156375: 290, 145350289: 1746, 1072786: 2163, 94068373: 51,
            417430: 2120, 15291903: 1848, 1065311897: 13, 24219: 147,
            7167655: 78, 32759467: 96, 146005691: 197, 14999235: 1816,
            810693: 261, 3890887: 2112, 351944: 2402, 220875: 2293,
            7835597: 266, 24272: 155, 7757529: 1972, 835391441: 1622,
            7298795: 199, 646898: 2207, 24305411: 96, 7855887: 2011,
            515865: 2066, 152002331: 217, 29777693: 2037, 24354: 2343,
            20078383: 96, 3001405: 107, 24375: 138, 3235661: 113,
            80994147: 1681, 28434279: 1877, 122728: 315, 9592702: 1776,
            2383745: 2098, 56156035: 1766, 11624327: 96, 244375: 135,
            476864399: 1614, 9920403: 201, 24472: 2440, 7495579: 275,
            221085: 249, 307716013: 1819, 5169075: 176, 251289533: 186,
            1767333823: 23, 57304: 2433, 1073116: 214, 80568287: 243,
            1269729: 2336, 566857723: 183, 3177097: 109, 942057: 2336,
            778221: 2336, 154951669: 71, 1040375: 2272, 286713: 2336,
            16310266: 1710, 122877: 143, 2318342: 233, 11886609: 1783,
            421584919: 1677, 504291353: 49, 4939802: 1908, 49143835: 1832,
            286750: 2281, 12214310: 1750, 876603: 2119, 647241: 2219,
            2908235: 2176, 202989647: 47, 143169089: 215, 44884063: 1897,
            1269866: 257, 3280915: 2170, 16867449: 33, 115925122: 169,
            90250: 292, 13852815: 44, 145285273: 1820, 10281115: 221,
            30138535: 1723, 221375: 2311, 10543298: 2018, 7561411: 2176,
            1057317061: 170, 4677838: 1965, 254163: 2250, 4972775: 236,
            14115049: 89, 9887999: 2176, 3170570: 1861, 113926413: 1632,
            38363413: 2138, 1040662: 2204, 29074822: 1683, 113373: 2381,
            1204533: 225, 15851830: 1645, 151606: 2255, 24109385: 72,
            6152523: 1979, 226681169: 1642, 22024249: 77, 155992: 2413,
            17129825: 200, 352625: 2295, 123250: 2302, 38265215: 1888,
            389636489: 1743, 1466762: 2169, 446539159: 1623, 90508: 274,
            24975: 309, 57753: 145, 245245: 2260, 318759329: 1687,
            254375: 132, 10358855: 2075, 16310702: 1942, 483759: 2339,
            942513: 102, 2548147: 2242, 21268049: 266, 397271479: 1688,
            52519363: 73, 4481477: 2154, 2974153: 2234, 1040842: 2177,
            1532375: 2273, 390980059: 1810, 2875873: 2123, 168747491: 1822,
            289399279: 1648, 1860089: 2236, 19751433: 1787, 528471: 303,
            34955791: 221, 38035987: 263, 211477019: 50, 109928995: 1635,
            21520939: 2151, 25137: 308, 114222515: 1682, 121725499: 1829,
            10609215: 56, 93250113: 18, 3236422: 1915, 25160: 2417,
            57942: 2348, 40624727: 251, 90712: 2432, 31973979: 1838,
            27910753: 2044, 23847527: 2141, 28279657: 73, 1103880829: 24,
            4579971: 2149, 72835721: 1940, 287375: 295, 1008273: 235,
            90774: 299, 2548375: 2282, 43213467: 1650, 25245: 2388,
            25256: 2409, 1303210: 80, 4285099: 277, 9672: 2427,
            20112051: 1904, 26534585: 1666, 20374211: 2038, 577654: 2164,
            2810577: 1930, 615125: 2284, 237157161: 1610, 38363897: 210,
            3695354: 254, 9265918: 2009, 134603521: 60, 2351877: 2161,
            123656: 2404, 58125: 133, 45638417: 222, 577626901: 172,
            24011546: 41, 20177691: 240, 90909: 2352, 41214758: 1642,
            42099497: 2010, 10686599: 2149, 46949855: 228, 4678465: 2152,
            1401686: 2105, 89252695: 1617, 25432: 317, 7856994: 1653,
            156519: 2360, 583099243: 194, 353133: 2338, 20210547: 1717,
            78504827: 242, 28730242: 1830, 25650051: 1749, 254852: 262,
            1500037: 271, 12936074: 1943, 147422019: 1622, 156584: 315,
            20341673: 2159, 148202413: 1941, 27911098: 1885, 4547517: 1985,
            25027519: 222, 7496644: 34, 2909125: 288, 385990: 2173,
            477553609: 17, 13820885: 1964, 8283107: 2205, 56070311: 210,
            23094253: 1955, 20767730: 1684, 418803: 2221, 119530489: 53,
            8414205: 1843, 50324483: 1970, 29778969: 1824, 3062618: 2077,
            53896222: 1641, 573629483: 13, 29991655: 1905, 32957495: 229,
            75162693: 193, 64884919: 263, 6470165: 2095, 101934159: 1633,
            25688: 318, 15950937: 63, 670565: 2243, 69461093: 71,
            91238: 124, 204989545: 203, 4416621: 222, 681070: 2099,
            81847409: 217, 76080251: 221, 25725: 284, 153511039: 1885,
            25752: 2414, 1200325: 236, 30237865: 1768, 33592: 2447,
            198010033: 173, 113108149: 1701, 41510078: 1820, 320705: 2256,
            8611010: 1724, 746691: 113, 58564: 118, 6513875: 287,
            1729749: 275, 188065319: 1876, 25839: 146, 84305143: 221,
            1860859: 258, 19096831: 245, 25875: 297, 8676635: 1980,
            58653: 285, 543417631: 1753, 714025: 104, 1336625: 293,
            830658547: 182, 142992707: 1813, 58696: 2432, 288078: 2001,
            353625: 2273, 1459971419: 23, 97936741: 175, 9561446: 1944,
            1063827: 301, 25974: 2352, 74605951: 1838, 10965227: 2094,
            1205645: 2218, 243885463: 229, 1172889: 81, 451996: 250,
            189875: 296, 157113: 303, 6219195: 1856, 46392771: 1875,
            6765473: 2177, 26068: 286, 27583959: 53, 5858783: 2225,
            550375: 2285, 244647: 2341, 323446253: 171, 255476: 250,
            17556981: 1889, 5301751: 2206, 11789823: 1912, 361096711: 38,
            404710921: 1885, 70313487: 205, 255512: 311, 2942511: 1991,
            550449: 2348, 26163: 148, 8458505: 2139, 157250: 2285,
            3728967: 2046, 58956: 250, 36791885: 1781, 376301137: 1706,
            29419093: 265, 110989583: 2008, 124509: 283, 10970729: 2039,
            23553645: 1694, 2516591: 2234, 58995: 2374, 1150084727: 11,
            269936251: 1746, 102065795: 1691, 12543622: 1662, 22079121: 1952,
            180577945: 1688, 177464987: 1754, 76703405: 1822, 3794609: 2217,
            6973109: 270, 845495: 2236, 26312: 2442, 11167351: 99,
            41909197: 264, 43902677: 175, 105625: 138, 583389: 2337,
            222952: 313, 7005938: 2028, 26364: 262, 354046: 2185,
            56807723: 62, 920577797: 171, 91940614: 1631, 36398857: 2140,
            39741194: 1763, 10544913: 177, 6907678: 2020, 95676191: 1952,
            51046177: 1840, 5039918: 2083, 4745015: 2160, 47081279: 240,
            6186818: 1946, 856375: 2294, 812890: 2090, 22210397: 107,
            106620787: 1655, 113895287: 60, 4024185: 1865, 30697341: 218,
            681625: 2274, 8546204: 178, 190365: 2222, 36071331: 52,
            7628709: 1914, 169273261: 1952, 116451247: 186, 17524671: 2008,
            634382279: 204, 583625: 2300, 39446477: 2017, 3434459: 2227,
            50456549: 1906, 721533949: 171, 100165623: 204, 1402874: 2162,
            26620: 274, 26622: 2368, 845845: 2128, 8376665: 2031,
            15755294: 1846, 93284389: 1878, 12970022: 1879, 59432: 2440,
            1306290217: 23, 2648107: 247, 26680: 2432, 223293: 121,
            416507971: 35, 2779205: 2112, 157768: 2402, 4581451: 280,
            452694: 1998, 36661339: 2072, 583786: 2217, 92274: 2133,
            1239161: 271, 26754: 2262, 24373393: 246, 1337505: 1993,
            139094179: 1763, 232057007: 1615, 4548786: 1668, 10610873: 1985,
            1632442: 1987, 27486403: 211, 125125: 2326, 2222297: 2227,
            2713295: 100, 518375: 2303, 24176873: 2020, 198699243: 168,
            47278317: 194, 55372017: 1874, 65595635: 31, 5499125: 2270,
            117303542: 1612, 616714: 2225, 26896: 155, 24078613: 245,
            39610646: 1707, 2812190: 1948, 19228959: 177, 59682: 2240,
            4646621: 2226, 5466417: 264, 301132085: 1677, 1829175: 212,
            26936: 2418, 2025788: 202, 9234753: 66, 3467595: 1916,
            12642637: 2205, 144992605: 47, 1960287: 2053, 31222115: 2007,
            21653863: 1946, 3697001: 235, 49244523: 1764, 16542071: 2021,
            607349117: 1753, 911754: 189, 7072143: 2084, 27027: 2392,
            420250: 287, 56486309: 264, 32142319: 2139, 158125: 135,
            26110382: 1886, 47457421: 1954, 195657: 271, 96889273: 2006,
            2845115: 2089, 5925309: 2093, 92625: 2316, 83356117: 1897,
            1010135: 2227, 18901475: 212, 5171686: 1972, 2014767593: 12,
            129985006: 14, 485875: 294, 59895: 273, 8907269: 247,
            5237258: 2011, 3631641: 2103, 61631003: 207, 37218853: 63,
            1010229: 111, 5498633: 2207, 762473023: 1612, 53996098: 1681,
            812018243: 1678, 5487713: 2161, 158301: 2342, 6613602: 1761,
            6646371: 76, 1370727: 249, 1337973: 2106, 60025: 128,
            35220107: 2075, 111307415: 1648, 7596705: 1790, 29911714: 1627,
            5663405: 2151, 7924406: 1783, 60088: 2414, 867199673: 205,
            4844218: 86, 5170975: 224, 532966093: 1613, 584402: 2119,
            77949651: 1634, 169405153: 242, 3173093: 278, 4444625: 289,
            92907: 144, 1108723: 271, 9235210: 44, 27405: 2371,
            20998929: 1815, 153479977: 49, 2059057: 2189, 3992375: 287,
            87223097: 252, 18279235: 1945, 944965: 2235, 262892369: 1875,
            102263635: 215, 303459163: 1614, 387933: 2237, 224094: 2126,
            29125475: 188, 8121189: 2037, 150236013: 191, 3009391: 2183,
            1796977: 282, 60291: 2370, 27528: 2413, 23329943: 2072,
            682892: 214, 1664373229: 12, 17874073: 275, 188705698: 167,
            120908711: 1692, 6712233: 263, 224181: 304, 399535037: 1624,
            33057739: 1913, 337800149: 1763, 60375: 2312, 27608: 2434,
            102808741: 1765, 27621: 145, 15756265: 1891, 212691947: 1714,
            93170: 2198, 486387: 249, 248048629: 1886, 93177: 2368,
            1338370: 1931, 91483139: 210, 13167622: 1787, 420875: 2286,
            7728149: 246, 257049: 105, 3337243: 259, 224979997: 215,
            2976806: 1966, 5860393: 2153, 7072810: 56, 289835: 282,
            7361035: 222, 14150725: 200, 3959878: 2030, 95480905: 1700,
            20573267: 2140, 7236705: 1670, 257125: 295, 27750: 2289,
            55143529: 1846, 2681965: 2163, 584815: 2230, 322677: 2350,
            1043575: 260, 12446841: 1899, 58715263: 84, 912525: 224,
            208989341: 1811, 66808997: 220, 1567918: 2161, 298984751: 1810,
            62352563: 1774, 2780346: 1851, 13724859: 1970, 8121537: 213,
            1830101: 259, 29486301: 1832, 17231071: 2094, 158949: 302,
            347696359: 215, 27880: 2407, 5237996: 178, 36498677: 87,
            109898999: 40, 34700501: 266, 17100034: 1749, 75754757: 254,
            60680: 2402, 528973021: 206, 18083121: 1723, 93496: 2423,
            781625: 294, 226061641: 1829, 189951319: 239, 14511455: 1855,
            19852646: 1824, 34663783: 1890, 70610282: 1680, 67956106: 1633,
            322959: 259, 19393941: 43, 2944414: 222, 37196357: 1971,
            123137443: 1721, 6057381: 2138, 3173798: 88, 28072: 319,
            10282909: 2045, 52587953: 1944, 16674229: 1985, 1043901: 299,
            3084875: 2282, 998927813: 23, 93639: 126, 224721: 2338,
            60885: 2343, 28120: 2416, 2200143: 2169, 299429341: 194,
            120319463: 1895, 391540201: 1640, 224750: 2291, 1138781683: 12,
            15560182: 54, 6647289: 2012, 5926401: 189, 1240578: 177,
            31583755: 1825, 65957397: 1635, 10475787: 1881, 1861551: 225,
            164064803: 205, 20981681: 75, 2518569: 69, 49278515: 1661,
            192052: 238, 215969333: 228, 28215: 2383, 21130813: 87,
            179469: 305, 84995665: 1812, 1234857557: 14, 394522213: 1745,
            781926: 81, 1142375: 2284, 15920751: 1666, 115797617: 197,
            61047: 2381, 593129083: 215, 6909565: 2087, 12467477: 2169,
            30928514: 1875, 9048683: 2215, 1270935179: 203, 3547115: 2144,
            145354389: 1613, 268005023: 29, 526973123: 1809, 2682537: 2088,
            7859882: 1912, 288711: 305, 28176055: 2017, 23981755: 1776,
            10940105: 1973, 1961674: 1991, 290521: 127, 2485978: 2046,
            53571301: 1888, 202501867: 207, 126711: 304, 159495: 2231,
            28424: 2447, 6975254: 1859, 356125: 2287, 22734811: 2159,
            28458: 2360, 13201195: 1900, 12119853: 73, 81804595: 1714,
            4550458: 1920, 367273951: 204, 61256: 2425, 33582939: 1721,
            165637991: 71, 28520: 2424, 28536: 2404, 585603: 303,
            334360453: 1678, 46854025: 32, 749455: 2242, 492236693: 35,
            28566: 303, 61336: 2407, 126875: 134, 2158499: 121,
            2682790: 1865, 192423: 2256, 1994678: 2040, 94136: 311,
            1576169401: 25, 1601467: 122, 126910: 2222, 24047554: 52,
            1241034: 1923, 138637261: 1707, 5205981: 1980, 847847: 271,
            58486769: 63, 66777082: 204, 1523030: 2033, 5795855: 233,
            122351637: 192, 68939809: 75, 74641443: 171, 340202161: 48,
            94250: 2303, 169242671: 1772, 2584625: 2291, 3731517: 213,
            4157503: 2226, 12349505: 1908, 716875: 132, 61516: 262,
            448622669: 192, 28750: 135, 25676339: 97, 33615959: 233,
            30535775: 200, 72478819: 60, 132673637: 230, 28782: 2342,
            42889327: 233, 94325: 284, 454779: 261, 24604797: 1657,
            774893701: 192, 178942093: 50, 845246611: 23, 43229351: 1912,
            31518878: 194, 78508191: 48, 32108713: 1906, 21983402: 1693,
            72642734: 1624, 12415151: 244, 61239477: 1691, 1405118: 2057,
            6713539: 279, 86563997: 253, 28875: 2330, 6156502: 66,
            94424: 2414, 479391967: 217, 1306858: 2053, 32829682: 1764,
            79393015: 1747, 311881979: 195, 42168581: 1847, 3174665: 257,
            4714762: 2084, 1208598: 2015, 2847009: 2160, 1470755: 2189,
            487734: 2091, 70644025: 20, 356668: 238, 1098612917: 182,
            127305: 2339, 225625: 136, 6549851: 2152, 5173597: 270,
            487780: 214, 2421094: 2103, 946542: 1983, 71627129: 218,
            6365529: 57, 49082757: 1714, 32534926: 50, 913818: 2034,
            1470875: 287, 4747677: 2140, 618915: 2165, 924873127: 180,
            61864: 2416, 4157875: 2281, 1667523: 2112, 507297: 2236,
            2126290: 1967, 44790239: 2084, 91386337: 1886, 51966434: 1634,
            11727331: 2031, 2224625: 288, 61938: 2347, 1536507: 213,
            262795773: 12, 22082047: 255, 11694595: 1965, 245133839: 206,
            40890899: 2008, 94743: 307, 37638: 2341, 815654: 2206,
            177107495: 1743, 5304875: 288, 951494749: 191, 83325489: 1625,
            735212089: 1753, 42496571: 254, 1929788: 178, 258622: 2237,
            40792639: 244, 231043651: 2006, 18608711: 107, 94792: 317,
            1307215: 2124, 180679251: 1677, 717409: 115, 30831205: 1961,
            512785: 2244, 106558057: 243, 86995563: 47, 49967725: 176,
            29295: 2363, 4092529: 91, 7762546: 1907, 62073: 307,
            1995388: 226, 23687807: 264, 39056001: 1772, 12481157: 99,
            33288843: 1644, 7926425: 212, 94875: 2311, 324258: 2064,
            193192: 2403, 350974637: 185, 914095: 2210, 8254129: 101,
            258741: 300, 94905: 2350, 14906042: 2006, 225964735: 1742,
            454947521: 14, 960950989: 205, 938791: 123, 74707699: 264,
            652023: 2337, 160515: 2338, 54981383: 244, 2880267: 2110,
            8942353: 278, 15201043: 2087, 97755: 2252, 128086823: 242,
            50164541: 1896, 19657534: 1832, 24998725: 212, 29512: 2426,
            121828171: 1896, 35681107: 1848, 127832: 314, 193375: 2321,
            265155431: 1885, 389992: 311, 12055414: 1723, 193401: 2367,
            42988413: 1757, 586625: 292, 9794435: 67, 2402455: 268,
            29291425: 176, 898954151: 47, 276132779: 38, 7730093: 235,
            8377161: 2073, 29624: 315, 574354367: 1697, 207009: 2341,
            11924429: 269, 4486097: 2206, 117237923: 1838, 509113303: 182,
            553945: 2249, 62426: 126, 226270: 2191, 497218543: 48,
            23786485: 64, 43971598: 1635, 29750: 2323, 29754: 2367,
            256021343: 239, 521284: 82, 160839: 2349, 10613834: 1666,
            717899: 123, 985363537: 169, 18773083: 1978, 1143905: 2234,
            28734563: 2074, 186283123: 197, 357492: 202, 25706006: 1831,
            29835: 2387, 554125: 2295, 14709903: 1898, 274691219: 1699,
            3765399: 2141, 29848: 2408, 41972889: 1636, 3175587: 225,
            1340595: 201, 2847929: 280, 463631567: 168, 1307859: 2205,
            51770585: 60, 129201373: 1874, 516355313: 216, 2323698: 1796,
            128248: 2405, 133919999: 208, 22803715: 1854, 65729797: 228,
            21779329: 2030, 11859211: 77, 7042321: 108, 62744: 2424,
            128282: 2256, 292125: 2274, 28758917: 2139, 2708585: 108,
            249263413: 27, 104690999: 175, 30008: 319, 30405947: 1964,
            4519229: 258, 3470654: 1980, 17626433: 2142, 23295298: 173,
            1013060: 190, 23000393: 256, 167089039: 1831, 30056: 317,
            329577833: 1754, 36301031: 95, 42694003: 222, 95608: 2416,
            197293435: 1679, 2487678: 1857, 18511251: 1841, 980375: 2292,
            51508639: 1781, 16905633: 2017, 119164409: 1649, 10974634: 1880,
            3210823: 2217, 8091055: 1915, 40859063: 1953, 31487417: 86,
            450549: 2336, 40826318: 1691, 7140815: 2150, 95697: 285,
            80082393: 1690, 204404209: 52, 68679167: 73, 18413057: 257,
            1898006: 2160, 28112415: 32, 325156: 262, 146601511: 1755,
            30250: 295, 537884207: 23, 38532659: 2028, 10548789: 220,
            257816119: 205, 2127426: 1737, 114456133: 1940, 3798613: 100,
            620125: 295, 535262831: 1874, 89618033: 84, 226935: 299,
            63099: 143, 1111682: 2112, 338198: 2236, 708179593: 1676,
            384988811: 228, 3110547: 2142, 489118: 2226, 505673377: 1631,
            101971627: 220, 865203893: 1687, 13825721: 2093, 95931: 2381,
            1636029: 249, 20608705: 209, 7239365: 1921, 30429: 308,
            120452834: 1677, 57997042: 47, 3667699: 281, 17219198: 196,
            1701623: 283, 81983231: 2006, 5076743: 280, 4346839: 2234,
            1348990733: 170, 195819281: 1819, 63250: 2311, 491139: 273,
            882453: 2189, 316733209: 29, 26933023: 95, 11826983: 278,
            30504: 2403, 8681271: 2029, 1336276793: 24, 292668: 214,
            1341249: 2058, 5633859: 1864, 30537: 146, 977207: 120,
            15300462: 1619, 9238385: 254, 23164795: 2009, 27719549: 2083,
            1275774: 1968, 63375: 294, 2783121: 2143, 948125: 131,
            30625: 140, 161704: 2404, 23492521: 257, 28800941: 76,
            10844079: 1963, 106264497: 1743, 2085875: 2270, 3798975: 188,
            60028865: 41, 784329: 2124, 2324426: 255, 567605197: 204,
            154695631: 240, 1308625: 292, 9997955: 2022, 29980635: 1637,
            588969961: 1809, 22706159: 211, 5797883: 98, 96255: 2358,
            15038465: 252, 95582211: 28, 305526793: 1625, 1124695: 270,
            605354003: 27, 522261: 302, 41416727: 266, 30750: 2279,
            358435: 2251, 15104037: 197, 1570855: 102, 25173395: 197,
            10811437: 2086, 96309: 143, 15431738: 1759, 1112125: 2271,
            43612233: 1683, 1505361: 2171, 161875: 132, 330397783: 1829,
            109377627: 170, 27981926: 1636, 2390122: 211, 11303044: 22,
            30856: 2433, 265189517: 227, 22959129: 1888, 48560291: 253,
            16072: 320, 148764851: 231, 59340981: 19, 660469943: 167,
            194750: 2274, 7796931: 243, 71825605: 1830, 17725645: 1789,
            32340185: 1943, 850149: 300, 107378918: 15, 5535985: 1926,
            384203005: 23, 2652419: 2218, 686343: 2234, 5994766: 75,
            227601: 273, 11270422: 2017, 155416855: 18, 7600411: 89,
            686375: 293, 63798: 2232, 16316729: 2141, 58554683: 2138,
            430963013: 173, 129352: 2415, 638690: 2059, 31062351: 60,
            122059091: 1643, 22083935: 2027, 18741610: 32, 13760877: 1906,
            31096: 318, 7633285: 2149, 2128269: 2144, 80942147: 1781,
            96668: 262, 72022445: 1650, 31160: 2406, 3602875: 2270,
            326095: 271, 33520085: 1904, 493681123: 1632, 163052007: 25,
            38664681: 1656, 43710961: 2007, 1669625: 292, 2135125: 2291,
            1440257: 2249, 4684295: 1930, 1800716: 226, 588302: 2189,
            301693457: 1745, 86702618: 1614, 23296562: 1773, 19757621: 255,
            6584890: 1729, 5667389: 2205, 1997375: 290, 133977185: 182,
            134740555: 1641, 130053927: 1614, 850516: 238, 540430: 2063,
            2376465001: 13, 16146: 2376, 24443503: 223, 70842998: 1743,
            402979447: 1809, 35960: 2423, 588411: 2347, 114487867: 251,
            10418821: 235, 522886: 2124, 137624201: 1715, 1800843: 107,
            25728109: 234, 19987090: 1637, 90995359: 1813, 350550697: 191,
            1288651: 281, 129735: 301, 96968: 2424, 49969869: 216,
            64206: 2338, 359125: 294, 64232: 2413, 59669234: 1689,
            13859573: 2030, 129789: 2374, 228095: 124, 2915075: 236,
            5250: 2333, 1702675: 260, 33684245: 1717, 11779887: 1842,
            17988381: 177, 949026: 1928, 15661877: 263, 57146167: 252,
            6093625: 287, 27556675: 200, 31556: 286, 86211406: 26,
            752463: 301, 340982609: 1809, 457562: 2234, 1932125: 2272,
            731872099: 11, 97125: 2288, 20904815: 2019, 422968177: 171,
            201875: 136, 112556917: 218, 101022601: 63, 20708234: 60,
            339082123: 217, 28867479: 1780, 9173918: 1906, 108592039: 241,
            67828651: 1961, 13958065: 1956, 31671: 147, 7928767: 2151,
            64449: 2362, 175379617: 193, 101439: 305, 230521803: 23,
            1746566093: 181, 103775195: 1820, 4396197: 2102, 21527525: 188,
            114457577: 207, 1250065387: 25, 14023675: 212, 1145853: 300,
            840875: 289, 28933126: 1876, 35191819: 2037, 31768: 316,
            1119583259: 180, 2980915: 223, 8813622: 1704, 170851385: 36,
            31806: 2359, 31783999: 2085, 1047625: 293, 378600539: 218,
            64257127: 2008, 162925: 284, 497122417: 1742, 125271155: 193,
            10773: 148, 31875: 137, 1145991: 2145, 1768585: 2113,
            9731211: 1849, 25590929: 1945, 34290934: 1821, 475561111: 1819,
            34864297: 1978, 16907435: 1971, 5536951: 247, 11992254: 1638,
            40344: 311, 31941: 306, 1408198: 267, 71335121: 1879,
            49380563: 243, 5242069: 2225, 80346327: 37, 1425079517: 1621,
            1419813: 237, 64750: 2288, 62684401: 72, 261375: 2275,
            3084599: 279, 216988933: 1809, 228616: 311, 163096: 2414,
            10779938: 1853, 35093798: 39, 600625: 133, 153681202: 23,
            336690491: 184, 267910463: 194, 720195: 2000, 1244485: 113,
            556358: 112, 2129225: 224, 2456909: 2235, 1015132: 238,
            2882915: 275, 139427183: 172, 80215421: 1840, 140967299: 186,
            818565: 2146, 130438: 271, 778960271: 203, 75726235: 1708,
            2588066: 2095, 64935: 2352, 2484807: 98, 6487474: 1849,
            10485171: 189, 84278739: 1744, 7994836: 178, 97750: 2309,
            2489817: 234, 28868059: 267, 154992095: 1809, 527728097: 1623,
            131169773: 1756, 2784754: 1974, 261625: 2310, 9765547: 110,
            48802389: 50, 16867763: 2168, 228150917: 1951, 2358811: 279,
            57277987: 254, 85589543: 197, 818741: 121, 24346167: 62,
            643694137: 35, 22249019: 95, 589375: 131, 130625: 136,
            138640967: 1942, 12942933: 1954, 3964502: 232, 1277535: 1934,
            143621729: 2007, 327267: 2358, 1792704131: 167, 64224901: 2073,
            19136135: 2010, 130696: 313, 65170: 2252, 8322743: 270,
            92995257: 1809, 1408701: 276, 1441473: 268, 21036743: 1913,
            1257187961: 1611, 86540003: 1951, 851690: 1934, 5340907: 101,
            247135987: 1680, 24611521: 107, 327426: 2147, 45973265: 53,
            98072: 2405, 52330267: 64, 4161311: 246, 61996838: 1809,
            121820465: 29, 163625: 2322, 98098: 2260, 8847157: 269,
            51412795: 1702, 163647: 2367, 29261635: 1889, 78118729: 253,
            927006547: 193, 619806553: 170, 32625: 297, 360308: 262,
            32643: 145, 20316037: 211, 65416: 2417, 216137609: 2006,
            393125: 132, 10026919: 2205, 1417375: 2300, 45252529: 43,
            360375: 289, 11108293: 88, 98260: 250, 2756193: 90,
            294872: 2403, 16678882: 174, 248250353: 185, 1747625: 2271,
            1884782587: 13, 80314367: 59
        }
        
        odd_xors_to_rank = {
            3: 310, 5: 298, 6: 297, 9: 286,
            10: 285, 12: 284, 17: 274, 18: 273,
            20: 272, 24: 271, 33: 262, 34: 261,
            36: 260, 40: 259, 48: 258, 63: 1607,
            65: 250, 66: 249, 68: 248, 72: 247,
            80: 246, 95: 1608, 96: 245, 111: 7450,
            119: 7447, 123: 7445, 125: 1606, 126: 1606,
            129: 238, 130: 237, 132: 236, 136: 235,
            144: 234, 159: 1608, 160: 233, 175: 7436,
            183: 7433, 187: 7431, 189: 7430, 190: 1607,
            192: 232, 207: 7426, 215: 7423, 219: 7421,
            221: 7420, 222: 7420, 231: 7417, 235: 7415,
            237: 7414, 238: 7414, 243: 7412, 245: 7411,
            246: 7411, 249: 1605, 250: 1605, 252: 1605,
            257: 226, 258: 225, 260: 224, 264: 223,
            272: 222, 287: 1608, 288: 221, 303: 7402,
            311: 7399, 315: 7397, 317: 7396, 318: 1607,
            320: 220, 335: 7392, 343: 7389, 347: 7387,
            349: 7386, 350: 7386, 359: 7383, 363: 7381,
            365: 7380, 366: 7380, 371: 7378, 373: 7377,
            374: 7377, 377: 7376, 378: 7376, 380: 1606,
            384: 219, 399: 7372, 407: 7369, 411: 7367,
            413: 7366, 414: 7366, 423: 7363, 427: 7361,
            429: 7360, 430: 7360, 435: 7358, 437: 7357,
            438: 7357, 441: 7356, 442: 7356, 444: 7356,
            455: 7353, 459: 7351, 461: 7350, 462: 7350,
            467: 7348, 469: 7347, 470: 7347, 473: 7346,
            474: 7346, 476: 7346, 483: 7344, 485: 7343,
            486: 7343, 489: 7342, 490: 7342, 492: 7342,
            497: 1604, 498: 1604, 500: 1604, 504: 1604,
            513: 214, 514: 213, 516: 212, 520: 211,
            528: 210, 543: 1608, 544: 209, 559: 7333,
            567: 7330, 571: 7328, 573: 7327, 574: 1607,
            576: 208, 591: 7323, 599: 7320, 603: 7318,
            605: 7317, 606: 7317, 615: 7314, 619: 7312,
            621: 7311, 622: 7311, 627: 7309, 629: 7308,
            630: 7308, 633: 7307, 634: 7307, 636: 1606,
            640: 207, 655: 7303, 663: 7300, 667: 7298,
            669: 7297, 670: 7297, 679: 7294, 683: 7292,
            685: 7291, 686: 7291, 691: 7289, 693: 7288,
            694: 7288, 697: 7287, 698: 7287, 700: 7287,
            711: 7284, 715: 7282, 717: 7281, 718: 7281,
            723: 7279, 725: 7278, 726: 7278, 729: 7277,
            730: 7277, 732: 7277, 739: 7275, 741: 7274,
            742: 7274, 745: 7273, 746: 7273, 748: 7273,
            753: 7272, 754: 7272, 756: 7272, 760: 1605,
            768: 206, 783: 7268, 791: 7265, 795: 7263,
            797: 7262, 798: 7262, 807: 7259, 811: 7257,
            813: 7256, 814: 7256, 819: 7254, 821: 7253,
            822: 7253, 825: 7252, 826: 7252, 828: 7252,
            839: 7249, 843: 7247, 845: 7246, 846: 7246,
            851: 7244, 853: 7243, 854: 7243, 857: 7242,
            858: 7242, 860: 7242, 867: 7240, 869: 7239,
            870: 7239, 873: 7238, 874: 7238, 876: 7238,
            881: 7237, 882: 7237, 884: 7237, 888: 7237,
            903: 7234, 907: 7232, 909: 7231, 910: 7231,
            915: 7229, 917: 7228, 918: 7228, 921: 7227,
            922: 7227, 924: 7227, 931: 7225, 933: 7224,
            934: 7224, 937: 7223, 938: 7223, 940: 7223,
            945: 7222, 946: 7222, 948: 7222, 952: 7222,
            963: 7220, 965: 7219, 966: 7219, 969: 7218,
            970: 7218, 972: 7218, 977: 7217, 978: 7217,
            980: 7217, 984: 7217, 993: 1603, 994: 1603,
            996: 1603, 1000: 1603, 1008: 1603, 1025: 202,
            1026: 201, 1028: 200, 1032: 199, 1040: 198,
            1055: 1608, 1056: 197, 1071: 7208, 1079: 7205,
            1083: 7203, 1085: 7202, 1086: 1607, 1088: 196,
            1103: 7198, 1111: 7195, 1115: 7193, 1117: 7192,
            1118: 7192, 1127: 7189, 1131: 7187, 1133: 7186,
            1134: 7186, 1139: 7184, 1141: 7183, 1142: 7183,
            1145: 7182, 1146: 7182, 1148: 1606, 1152: 195,
            1167: 7178, 1175: 7175, 1179: 7173, 1181: 7172,
            1182: 7172, 1191: 7169, 1195: 7167, 1197: 7166,
            1198: 7166, 1203: 7164, 1205: 7163, 1206: 7163,
            1209: 7162, 1210: 7162, 1212: 7162, 1223: 7159,
            1227: 7157, 1229: 7156, 1230: 7156, 1235: 7154,
            1237: 7153, 1238: 7153, 1241: 7152, 1242: 7152,
            1244: 7152, 1251: 7150, 1253: 7149, 1254: 7149,
            1257: 7148, 1258: 7148, 1260: 7148, 1265: 7147,
            1266: 7147, 1268: 7147, 1272: 1605, 1280: 194,
            1295: 7143, 1303: 7140, 1307: 7138, 1309: 7137,
            1310: 7137, 1319: 7134, 1323: 7132, 1325: 7131,
            1326: 7131, 1331: 7129, 1333: 7128, 1334: 7128,
            1337: 7127, 1338: 7127, 1340: 7127, 1351: 7124,
            1355: 7122, 1357: 7121, 1358: 7121, 1363: 7119,
            1365: 7118, 1366: 7118, 1369: 7117, 1370: 7117,
            1372: 7117, 1379: 7115, 1381: 7114, 1382: 7114,
            1385: 7113, 1386: 7113, 1388: 7113, 1393: 7112,
            1394: 7112, 1396: 7112, 1400: 7112, 1415: 7109,
            1419: 7107, 1421: 7106, 1422: 7106, 1427: 7104,
            1429: 7103, 1430: 7103, 1433: 7102, 1434: 7102,
            1436: 7102, 1443: 7100, 1445: 7099, 1446: 7099,
            1449: 7098, 1450: 7098, 1452: 7098, 1457: 7097,
            1458: 7097, 1460: 7097, 1464: 7097, 1475: 7095,
            1477: 7094, 1478: 7094, 1481: 7093, 1482: 7093,
            1484: 7093, 1489: 7092, 1490: 7092, 1492: 7092,
            1496: 7092, 1505: 7091, 1506: 7091, 1508: 7091,
            1512: 7091, 1520: 1604, 1536: 193, 1551: 7087,
            1559: 7084, 1563: 7082, 1565: 7081, 1566: 7081,
            1575: 7078, 1579: 7076, 1581: 7075, 1582: 7075,
            1587: 7073, 1589: 7072, 1590: 7072, 1593: 7071,
            1594: 7071, 1596: 7071, 1607: 7068, 1611: 7066,
            1613: 7065, 1614: 7065, 1619: 7063, 1621: 7062,
            1622: 7062, 1625: 7061, 1626: 7061, 1628: 7061,
            1635: 7059, 1637: 7058, 1638: 7058, 1641: 7057,
            1642: 7057, 1644: 7057, 1649: 7056, 1650: 7056,
            1652: 7056, 1656: 7056, 1671: 7053, 1675: 7051,
            1677: 7050, 1678: 7050, 1683: 7048, 1685: 7047,
            1686: 7047, 1689: 7046, 1690: 7046, 1692: 7046,
            1699: 7044, 1701: 7043, 1702: 7043, 1705: 7042,
            1706: 7042, 1708: 7042, 1713: 7041, 1714: 7041,
            1716: 7041, 1720: 7041, 1731: 7039, 1733: 7038,
            1734: 7038, 1737: 7037, 1738: 7037, 1740: 7037,
            1745: 7036, 1746: 7036, 1748: 7036, 1752: 7036,
            1761: 7035, 1762: 7035, 1764: 7035, 1768: 7035,
            1776: 7035, 1799: 7032, 1803: 7030, 1805: 7029,
            1806: 7029, 1811: 7027, 1813: 7026, 1814: 7026,
            1817: 7025, 1818: 7025, 1820: 7025, 1827: 7023,
            1829: 7022, 1830: 7022, 1833: 7021, 1834: 7021,
            1836: 7021, 1841: 7020, 1842: 7020, 1844: 7020,
            1848: 7020, 1859: 7018, 1861: 7017, 1862: 7017,
            1865: 7016, 1866: 7016, 1868: 7016, 1873: 7015,
            1874: 7015, 1876: 7015, 1880: 7015, 1889: 7014,
            1890: 7014, 1892: 7014, 1896: 7014, 1904: 7014,
            1923: 7012, 1925: 7011, 1926: 7011, 1929: 7010,
            1930: 7010, 1932: 7010, 1937: 7009, 1938: 7009,
            1940: 7009, 1944: 7009, 1953: 7008, 1954: 7008,
            1956: 7008, 1960: 7008, 1968: 7008, 1985: 1602,
            1986: 1602, 1988: 1602, 1992: 1602, 2000: 1602,
            2016: 1602, 2049: 190, 2050: 189, 2052: 188,
            2056: 187, 2064: 186, 2079: 1608, 2080: 185,
            2095: 6999, 2103: 6996, 2107: 6994, 2109: 6993,
            2110: 1607, 2112: 184, 2127: 6989, 2135: 6986,
            2139: 6984, 2141: 6983, 2142: 6983, 2151: 6980,
            2155: 6978, 2157: 6977, 2158: 6977, 2163: 6975,
            2165: 6974, 2166: 6974, 2169: 6973, 2170: 6973,
            2172: 1606, 2176: 183, 2191: 6969, 2199: 6966,
            2203: 6964, 2205: 6963, 2206: 6963, 2215: 6960,
            2219: 6958, 2221: 6957, 2222: 6957, 2227: 6955,
            2229: 6954, 2230: 6954, 2233: 6953, 2234: 6953,
            2236: 6953, 2247: 6950, 2251: 6948, 2253: 6947,
            2254: 6947, 2259: 6945, 2261: 6944, 2262: 6944,
            2265: 6943, 2266: 6943, 2268: 6943, 2275: 6941,
            2277: 6940, 2278: 6940, 2281: 6939, 2282: 6939,
            2284: 6939, 2289: 6938, 2290: 6938, 2292: 6938,
            2296: 1605, 2304: 182, 2319: 6934, 2327: 6931,
            2331: 6929, 2333: 6928, 2334: 6928, 2343: 6925,
            2347: 6923, 2349: 6922, 2350: 6922, 2355: 6920,
            2357: 6919, 2358: 6919, 2361: 6918, 2362: 6918,
            2364: 6918, 2375: 6915, 2379: 6913, 2381: 6912,
            2382: 6912, 2387: 6910, 2389: 6909, 2390: 6909,
            2393: 6908, 2394: 6908, 2396: 6908, 2403: 6906,
            2405: 6905, 2406: 6905, 2409: 6904, 2410: 6904,
            2412: 6904, 2417: 6903, 2418: 6903, 2420: 6903,
            2424: 6903, 2439: 6900, 2443: 6898, 2445: 6897,
            2446: 6897, 2451: 6895, 2453: 6894, 2454: 6894,
            2457: 6893, 2458: 6893, 2460: 6893, 2467: 6891,
            2469: 6890, 2470: 6890, 2473: 6889, 2474: 6889,
            2476: 6889, 2481: 6888, 2482: 6888, 2484: 6888,
            2488: 6888, 2499: 6886, 2501: 6885, 2502: 6885,
            2505: 6884, 2506: 6884, 2508: 6884, 2513: 6883,
            2514: 6883, 2516: 6883, 2520: 6883, 2529: 6882,
            2530: 6882, 2532: 6882, 2536: 6882, 2544: 1604,
            2560: 181, 2575: 6878, 2583: 6875, 2587: 6873,
            2589: 6872, 2590: 6872, 2599: 6869, 2603: 6867,
            2605: 6866, 2606: 6866, 2611: 6864, 2613: 6863,
            2614: 6863, 2617: 6862, 2618: 6862, 2620: 6862,
            2631: 6859, 2635: 6857, 2637: 6856, 2638: 6856,
            2643: 6854, 2645: 6853, 2646: 6853, 2649: 6852,
            2650: 6852, 2652: 6852, 2659: 6850, 2661: 6849,
            2662: 6849, 2665: 6848, 2666: 6848, 2668: 6848,
            2673: 6847, 2674: 6847, 2676: 6847, 2680: 6847,
            2695: 6844, 2699: 6842, 2701: 6841, 2702: 6841,
            2707: 6839, 2709: 6838, 2710: 6838, 2713: 6837,
            2714: 6837, 2716: 6837, 2723: 6835, 2725: 6834,
            2726: 6834, 2729: 6833, 2730: 6833, 2732: 6833,
            2737: 6832, 2738: 6832, 2740: 6832, 2744: 6832,
            2755: 6830, 2757: 6829, 2758: 6829, 2761: 6828,
            2762: 6828, 2764: 6828, 2769: 6827, 2770: 6827,
            2772: 6827, 2776: 6827, 2785: 6826, 2786: 6826,
            2788: 6826, 2792: 6826, 2800: 6826, 2823: 6823,
            2827: 6821, 2829: 6820, 2830: 6820, 2835: 6818,
            2837: 6817, 2838: 6817, 2841: 6816, 2842: 6816,
            2844: 6816, 2851: 6814, 2853: 6813, 2854: 6813,
            2857: 6812, 2858: 6812, 2860: 6812, 2865: 6811,
            2866: 6811, 2868: 6811, 2872: 6811, 2883: 6809,
            2885: 6808, 2886: 6808, 2889: 6807, 2890: 6807,
            2892: 6807, 2897: 6806, 2898: 6806, 2900: 6806,
            2904: 6806, 2913: 6805, 2914: 6805, 2916: 6805,
            2920: 6805, 2928: 6805, 2947: 6803, 2949: 6802,
            2950: 6802, 2953: 6801, 2954: 6801, 2956: 6801,
            2961: 6800, 2962: 6800, 2964: 6800, 2968: 6800,
            2977: 6799, 2978: 6799, 2980: 6799, 2984: 6799,
            2992: 6799, 3009: 6798, 3010: 6798, 3012: 6798,
            3016: 6798, 3024: 6798, 3040: 1603, 3072: 180,
            3087: 6794, 3095: 6791, 3099: 6789, 3101: 6788,
            3102: 6788, 3111: 6785, 3115: 6783, 3117: 6782,
            3118: 6782, 3123: 6780, 3125: 6779, 3126: 6779,
            3129: 6778, 3130: 6778, 3132: 6778, 3143: 6775,
            3147: 6773, 3149: 6772, 3150: 6772, 3155: 6770,
            3157: 6769, 3158: 6769, 3161: 6768, 3162: 6768,
            3164: 6768, 3171: 6766, 3173: 6765, 3174: 6765,
            3177: 6764, 3178: 6764, 3180: 6764, 3185: 6763,
            3186: 6763, 3188: 6763, 3192: 6763, 3207: 6760,
            3211: 6758, 3213: 6757, 3214: 6757, 3219: 6755,
            3221: 6754, 3222: 6754, 3225: 6753, 3226: 6753,
            3228: 6753, 3235: 6751, 3237: 6750, 3238: 6750,
            3241: 6749, 3242: 6749, 3244: 6749, 3249: 6748,
            3250: 6748, 3252: 6748, 3256: 6748, 3267: 6746,
            3269: 6745, 3270: 6745, 3273: 6744, 3274: 6744,
            3276: 6744, 3281: 6743, 3282: 6743, 3284: 6743,
            3288: 6743, 3297: 6742, 3298: 6742, 3300: 6742,
            3304: 6742, 3312: 6742, 3335: 6739, 3339: 6737,
            3341: 6736, 3342: 6736, 3347: 6734, 3349: 6733,
            3350: 6733, 3353: 6732, 3354: 6732, 3356: 6732,
            3363: 6730, 3365: 6729, 3366: 6729, 3369: 6728,
            3370: 6728, 3372: 6728, 3377: 6727, 3378: 6727,
            3380: 6727, 3384: 6727, 3395: 6725, 3397: 6724,
            3398: 6724, 3401: 6723, 3402: 6723, 3404: 6723,
            3409: 6722, 3410: 6722, 3412: 6722, 3416: 6722,
            3425: 6721, 3426: 6721, 3428: 6721, 3432: 6721,
            3440: 6721, 3459: 6719, 3461: 6718, 3462: 6718,
            3465: 6717, 3466: 6717, 3468: 6717, 3473: 6716,
            3474: 6716, 3476: 6716, 3480: 6716, 3489: 6715,
            3490: 6715, 3492: 6715, 3496: 6715, 3504: 6715,
            3521: 6714, 3522: 6714, 3524: 6714, 3528: 6714,
            3536: 6714, 3552: 6714, 3591: 6711, 3595: 6709,
            3597: 6708, 3598: 6708, 3603: 6706, 3605: 6705,
            3606: 6705, 3609: 6704, 3610: 6704, 3612: 6704,
            3619: 6702, 3621: 6701, 3622: 6701, 3625: 6700,
            3626: 6700, 3628: 6700, 3633: 6699, 3634: 6699,
            3636: 6699, 3640: 6699, 3651: 6697, 3653: 6696,
            3654: 6696, 3657: 6695, 3658: 6695, 3660: 6695,
            3665: 6694, 3666: 6694, 3668: 6694, 3672: 6694,
            3681: 6693, 3682: 6693, 3684: 6693, 3688: 6693,
            3696: 6693, 3715: 6691, 3717: 6690, 3718: 6690,
            3721: 6689, 3722: 6689, 3724: 6689, 3729: 6688,
            3730: 6688, 3732: 6688, 3736: 6688, 3745: 6687,
            3746: 6687, 3748: 6687, 3752: 6687, 3760: 6687,
            3777: 6686, 3778: 6686, 3780: 6686, 3784: 6686,
            3792: 6686, 3808: 6686, 3843: 6684, 3845: 6683,
            3846: 6683, 3849: 6682, 3850: 6682, 3852: 6682,
            3857: 6681, 3858: 6681, 3860: 6681, 3864: 6681,
            3873: 6680, 3874: 6680, 3876: 6680, 3880: 6680,
            3888: 6680, 3905: 6679, 3906: 6679, 3908: 6679,
            3912: 6679, 3920: 6679, 3936: 6679, 3969: 1601,
            3970: 1601, 3972: 1601, 3976: 1601, 3984: 1601,
            4000: 1601, 4032: 1601, 4097: 178, 4098: 177,
            4100: 176, 4104: 175, 4112: 174, 4127: 1608,
            4128: 173, 4143: 1609, 4151: 6668, 4155: 6666,
            4157: 6665, 4158: 1607, 4160: 172, 4175: 1609,
            4183: 6658, 4187: 6656, 4189: 6655, 4190: 6655,
            4199: 6652, 4203: 6650, 4205: 6649, 4206: 6649,
            4211: 6647, 4213: 6646, 4214: 6646, 4217: 6645,
            4218: 6645, 4220: 1606, 4224: 171, 4239: 1609,
            4247: 6638, 4251: 6636, 4253: 6635, 4254: 6635,
            4263: 6632, 4267: 6630, 4269: 6629, 4270: 6629,
            4275: 6627, 4277: 6626, 4278: 6626, 4281: 6625,
            4282: 6625, 4284: 6625, 4295: 6622, 4299: 6620,
            4301: 6619, 4302: 6619, 4307: 6617, 4309: 6616,
            4310: 6616, 4313: 6615, 4314: 6615, 4316: 6615,
            4323: 6613, 4325: 6612, 4326: 6612, 4329: 6611,
            4330: 6611, 4332: 6611, 4337: 6610, 4338: 6610,
            4340: 6610, 4344: 1605, 4352: 170, 4367: 1609,
            4375: 6603, 4379: 6601, 4381: 6600, 4382: 6600,
            4391: 6597, 4395: 6595, 4397: 6594, 4398: 6594,
            4403: 6592, 4405: 6591, 4406: 6591, 4409: 6590,
            4410: 6590, 4412: 6590, 4423: 6587, 4427: 6585,
            4429: 6584, 4430: 6584, 4435: 6582, 4437: 6581,
            4438: 6581, 4441: 6580, 4442: 6580, 4444: 6580,
            4451: 6578, 4453: 6577, 4454: 6577, 4457: 6576,
            4458: 6576, 4460: 6576, 4465: 6575, 4466: 6575,
            4468: 6575, 4472: 6575, 4487: 6572, 4491: 6570,
            4493: 6569, 4494: 6569, 4499: 6567, 4501: 6566,
            4502: 6566, 4505: 6565, 4506: 6565, 4508: 6565,
            4515: 6563, 4517: 6562, 4518: 6562, 4521: 6561,
            4522: 6561, 4524: 6561, 4529: 6560, 4530: 6560,
            4532: 6560, 4536: 6560, 4547: 6558, 4549: 6557,
            4550: 6557, 4553: 6556, 4554: 6556, 4556: 6556,
            4561: 6555, 4562: 6555, 4564: 6555, 4568: 6555,
            4577: 6554, 4578: 6554, 4580: 6554, 4584: 6554,
            4592: 1604, 4608: 169, 4623: 1609, 4631: 6547,
            4635: 6545, 4637: 6544, 4638: 6544, 4647: 6541,
            4651: 6539, 4653: 6538, 4654: 6538, 4659: 6536,
            4661: 6535, 4662: 6535, 4665: 6534, 4666: 6534,
            4668: 6534, 4679: 6531, 4683: 6529, 4685: 6528,
            4686: 6528, 4691: 6526, 4693: 6525, 4694: 6525,
            4697: 6524, 4698: 6524, 4700: 6524, 4707: 6522,
            4709: 6521, 4710: 6521, 4713: 6520, 4714: 6520,
            4716: 6520, 4721: 6519, 4722: 6519, 4724: 6519,
            4728: 6519, 4743: 6516, 4747: 6514, 4749: 6513,
            4750: 6513, 4755: 6511, 4757: 6510, 4758: 6510,
            4761: 6509, 4762: 6509, 4764: 6509, 4771: 6507,
            4773: 6506, 4774: 6506, 4777: 6505, 4778: 6505,
            4780: 6505, 4785: 6504, 4786: 6504, 4788: 6504,
            4792: 6504, 4803: 6502, 4805: 6501, 4806: 6501,
            4809: 6500, 4810: 6500, 4812: 6500, 4817: 6499,
            4818: 6499, 4820: 6499, 4824: 6499, 4833: 6498,
            4834: 6498, 4836: 6498, 4840: 6498, 4848: 6498,
            4871: 6495, 4875: 6493, 4877: 6492, 4878: 6492,
            4883: 6490, 4885: 6489, 4886: 6489, 4889: 6488,
            4890: 6488, 4892: 6488, 4899: 6486, 4901: 6485,
            4902: 6485, 4905: 6484, 4906: 6484, 4908: 6484,
            4913: 6483, 4914: 6483, 4916: 6483, 4920: 6483,
            4931: 6481, 4933: 6480, 4934: 6480, 4937: 6479,
            4938: 6479, 4940: 6479, 4945: 6478, 4946: 6478,
            4948: 6478, 4952: 6478, 4961: 6477, 4962: 6477,
            4964: 6477, 4968: 6477, 4976: 6477, 4995: 6475,
            4997: 6474, 4998: 6474, 5001: 6473, 5002: 6473,
            5004: 6473, 5009: 6472, 5010: 6472, 5012: 6472,
            5016: 6472, 5025: 6471, 5026: 6471, 5028: 6471,
            5032: 6471, 5040: 6471, 5057: 6470, 5058: 6470,
            5060: 6470, 5064: 6470, 5072: 6470, 5088: 1603,
            5120: 168, 5135: 1609, 5143: 6463, 5147: 6461,
            5149: 6460, 5150: 6460, 5159: 6457, 5163: 6455,
            5165: 6454, 5166: 6454, 5171: 6452, 5173: 6451,
            5174: 6451, 5177: 6450, 5178: 6450, 5180: 6450,
            5191: 6447, 5195: 6445, 5197: 6444, 5198: 6444,
            5203: 6442, 5205: 6441, 5206: 6441, 5209: 6440,
            5210: 6440, 5212: 6440, 5219: 6438, 5221: 6437,
            5222: 6437, 5225: 6436, 5226: 6436, 5228: 6436,
            5233: 6435, 5234: 6435, 5236: 6435, 5240: 6435,
            5255: 6432, 5259: 6430, 5261: 6429, 5262: 6429,
            5267: 6427, 5269: 6426, 5270: 6426, 5273: 6425,
            5274: 6425, 5276: 6425, 5283: 6423, 5285: 6422,
            5286: 6422, 5289: 6421, 5290: 6421, 5292: 6421,
            5297: 6420, 5298: 6420, 5300: 6420, 5304: 6420,
            5315: 6418, 5317: 6417, 5318: 6417, 5321: 6416,
            5322: 6416, 5324: 6416, 5329: 6415, 5330: 6415,
            5332: 6415, 5336: 6415, 5345: 6414, 5346: 6414,
            5348: 6414, 5352: 6414, 5360: 6414, 5383: 6411,
            5387: 6409, 5389: 6408, 5390: 6408, 5395: 6406,
            5397: 6405, 5398: 6405, 5401: 6404, 5402: 6404,
            5404: 6404, 5411: 6402, 5413: 6401, 5414: 6401,
            5417: 6400, 5418: 6400, 5420: 6400, 5425: 6399,
            5426: 6399, 5428: 6399, 5432: 6399, 5443: 6397,
            5445: 6396, 5446: 6396, 5449: 6395, 5450: 6395,
            5452: 6395, 5457: 6394, 5458: 6394, 5460: 6394,
            5464: 6394, 5473: 6393, 5474: 6393, 5476: 6393,
            5480: 6393, 5488: 6393, 5507: 6391, 5509: 6390,
            5510: 6390, 5513: 6389, 5514: 6389, 5516: 6389,
            5521: 6388, 5522: 6388, 5524: 6388, 5528: 6388,
            5537: 6387, 5538: 6387, 5540: 6387, 5544: 6387,
            5552: 6387, 5569: 6386, 5570: 6386, 5572: 6386,
            5576: 6386, 5584: 6386, 5600: 6386, 5639: 6383,
            5643: 6381, 5645: 6380, 5646: 6380, 5651: 6378,
            5653: 6377, 5654: 6377, 5657: 6376, 5658: 6376,
            5660: 6376, 5667: 6374, 5669: 6373, 5670: 6373,
            5673: 6372, 5674: 6372, 5676: 6372, 5681: 6371,
            5682: 6371, 5684: 6371, 5688: 6371, 5699: 6369,
            5701: 6368, 5702: 6368, 5705: 6367, 5706: 6367,
            5708: 6367, 5713: 6366, 5714: 6366, 5716: 6366,
            5720: 6366, 5729: 6365, 5730: 6365, 5732: 6365,
            5736: 6365, 5744: 6365, 5763: 6363, 5765: 6362,
            5766: 6362, 5769: 6361, 5770: 6361, 5772: 6361,
            5777: 6360, 5778: 6360, 5780: 6360, 5784: 6360,
            5793: 6359, 5794: 6359, 5796: 6359, 5800: 6359,
            5808: 6359, 5825: 6358, 5826: 6358, 5828: 6358,
            5832: 6358, 5840: 6358, 5856: 6358, 5891: 6356,
            5893: 6355, 5894: 6355, 5897: 6354, 5898: 6354,
            5900: 6354, 5905: 6353, 5906: 6353, 5908: 6353,
            5912: 6353, 5921: 6352, 5922: 6352, 5924: 6352,
            5928: 6352, 5936: 6352, 5953: 6351, 5954: 6351,
            5956: 6351, 5960: 6351, 5968: 6351, 5984: 6351,
            6017: 6350, 6018: 6350, 6020: 6350, 6024: 6350,
            6032: 6350, 6048: 6350, 6080: 1602, 6144: 167,
            6159: 1609, 6167: 6343, 6171: 6341, 6173: 6340,
            6174: 6340, 6183: 6337, 6187: 6335, 6189: 6334,
            6190: 6334, 6195: 6332, 6197: 6331, 6198: 6331,
            6201: 6330, 6202: 6330, 6204: 6330, 6215: 6327,
            6219: 6325, 6221: 6324, 6222: 6324, 6227: 6322,
            6229: 6321, 6230: 6321, 6233: 6320, 6234: 6320,
            6236: 6320, 6243: 6318, 6245: 6317, 6246: 6317,
            6249: 6316, 6250: 6316, 6252: 6316, 6257: 6315,
            6258: 6315, 6260: 6315, 6264: 6315, 6279: 6312,
            6283: 6310, 6285: 6309, 6286: 6309, 6291: 6307,
            6293: 6306, 6294: 6306, 6297: 6305, 6298: 6305,
            6300: 6305, 6307: 6303, 6309: 6302, 6310: 6302,
            6313: 6301, 6314: 6301, 6316: 6301, 6321: 6300,
            6322: 6300, 6324: 6300, 6328: 6300, 6339: 6298,
            6341: 6297, 6342: 6297, 6345: 6296, 6346: 6296,
            6348: 6296, 6353: 6295, 6354: 6295, 6356: 6295,
            6360: 6295, 6369: 6294, 6370: 6294, 6372: 6294,
            6376: 6294, 6384: 6294, 6407: 6291, 6411: 6289,
            6413: 6288, 6414: 6288, 6419: 6286, 6421: 6285,
            6422: 6285, 6425: 6284, 6426: 6284, 6428: 6284,
            6435: 6282, 6437: 6281, 6438: 6281, 6441: 6280,
            6442: 6280, 6444: 6280, 6449: 6279, 6450: 6279,
            6452: 6279, 6456: 6279, 6467: 6277, 6469: 6276,
            6470: 6276, 6473: 6275, 6474: 6275, 6476: 6275,
            6481: 6274, 6482: 6274, 6484: 6274, 6488: 6274,
            6497: 6273, 6498: 6273, 6500: 6273, 6504: 6273,
            6512: 6273, 6531: 6271, 6533: 6270, 6534: 6270,
            6537: 6269, 6538: 6269, 6540: 6269, 6545: 6268,
            6546: 6268, 6548: 6268, 6552: 6268, 6561: 6267,
            6562: 6267, 6564: 6267, 6568: 6267, 6576: 6267,
            6593: 6266, 6594: 6266, 6596: 6266, 6600: 6266,
            6608: 6266, 6624: 6266, 6663: 6263, 6667: 6261,
            6669: 6260, 6670: 6260, 6675: 6258, 6677: 6257,
            6678: 6257, 6681: 6256, 6682: 6256, 6684: 6256,
            6691: 6254, 6693: 6253, 6694: 6253, 6697: 6252,
            6698: 6252, 6700: 6252, 6705: 6251, 6706: 6251,
            6708: 6251, 6712: 6251, 6723: 6249, 6725: 6248,
            6726: 6248, 6729: 6247, 6730: 6247, 6732: 6247,
            6737: 6246, 6738: 6246, 6740: 6246, 6744: 6246,
            6753: 6245, 6754: 6245, 6756: 6245, 6760: 6245,
            6768: 6245, 6787: 6243, 6789: 6242, 6790: 6242,
            6793: 6241, 6794: 6241, 6796: 6241, 6801: 6240,
            6802: 6240, 6804: 6240, 6808: 6240, 6817: 6239,
            6818: 6239, 6820: 6239, 6824: 6239, 6832: 6239,
            6849: 6238, 6850: 6238, 6852: 6238, 6856: 6238,
            6864: 6238, 6880: 6238, 6915: 6236, 6917: 6235,
            6918: 6235, 6921: 6234, 6922: 6234, 6924: 6234,
            6929: 6233, 6930: 6233, 6932: 6233, 6936: 6233,
            6945: 6232, 6946: 6232, 6948: 6232, 6952: 6232,
            6960: 6232, 6977: 6231, 6978: 6231, 6980: 6231,
            6984: 6231, 6992: 6231, 7008: 6231, 7041: 6230,
            7042: 6230, 7044: 6230, 7048: 6230, 7056: 6230,
            7072: 6230, 7104: 6230, 7175: 6227, 7179: 6225,
            7181: 6224, 7182: 6224, 7187: 6222, 7189: 6221,
            7190: 6221, 7193: 6220, 7194: 6220, 7196: 6220,
            7203: 6218, 7205: 6217, 7206: 6217, 7209: 6216,
            7210: 6216, 7212: 6216, 7217: 6215, 7218: 6215,
            7220: 6215, 7224: 6215, 7235: 6213, 7237: 6212,
            7238: 6212, 7241: 6211, 7242: 6211, 7244: 6211,
            7249: 6210, 7250: 6210, 7252: 6210, 7256: 6210,
            7265: 6209, 7266: 6209, 7268: 6209, 7272: 6209,
            7280: 6209, 7299: 6207, 7301: 6206, 7302: 6206,
            7305: 6205, 7306: 6205, 7308: 6205, 7313: 6204,
            7314: 6204, 7316: 6204, 7320: 6204, 7329: 6203,
            7330: 6203, 7332: 6203, 7336: 6203, 7344: 6203,
            7361: 6202, 7362: 6202, 7364: 6202, 7368: 6202,
            7376: 6202, 7392: 6202, 7427: 6200, 7429: 6199,
            7430: 6199, 7433: 6198, 7434: 6198, 7436: 6198,
            7441: 6197, 7442: 6197, 7444: 6197, 7448: 6197,
            7457: 6196, 7458: 6196, 7460: 6196, 7464: 6196,
            7472: 6196, 7489: 6195, 7490: 6195, 7492: 6195,
            7496: 6195, 7504: 6195, 7520: 6195, 7553: 6194,
            7554: 6194, 7556: 6194, 7560: 6194, 7568: 6194,
            7584: 6194, 7616: 6194, 7683: 6192, 7685: 6191,
            7686: 6191, 7689: 6190, 7690: 6190, 7692: 6190,
            7697: 6189, 7698: 6189, 7700: 6189, 7704: 6189,
            7713: 6188, 7714: 6188, 7716: 6188, 7720: 6188,
            7728: 6188, 7745: 6187, 7746: 6187, 7748: 6187,
            7752: 6187, 7760: 6187, 7776: 6187, 7809: 6186,
            7810: 6186, 7812: 6186, 7816: 6186, 7824: 6186,
            7840: 6186, 7872: 6186, 7937: 1600, 7938: 1600,
            7940: 1600, 7944: 1600, 7952: 1600, 7968: 1600,
            8000: 1600, 8064: 1600
        }
        
        even_xors_to_rank = {
            3584: 2601, 3073: 2610, 1538: 2730, 1027: 2819,
            2114: 2653, 4101: 2577, 4102: 2576, 7: 3303,
            1544: 2728, 4105: 2566, 4106: 2565, 11: 3281,
            524: 2894, 13: 3270, 14: 3269, 4228: 2520,
            1552: 2727, 4113: 2555, 530: 2884, 2051: 2709,
            529: 2885, 21: 3237, 22: 3236, 2592: 2616,
            536: 2882, 25: 3226, 26: 3225, 28: 3224,
            517: 2907, 1092: 2762, 1057: 2775, 546: 2873,
            35: 3204, 548: 2872, 37: 3193, 38: 3192,
            4144: 2540, 552: 2871, 41: 3182, 42: 3181,
            44: 3180, 2320: 2628, 560: 2870, 49: 3171,
            50: 3170, 52: 3169, 2576: 2617, 521: 2896,
            56: 3168, 2312: 2629, 2184: 2640, 769: 2841,
            522: 2895, 2116: 2652, 577: 2863, 578: 2862,
            67: 3149, 2065: 2676, 69: 3138, 70: 3137,
            584: 2860, 73: 3127, 74: 3126, 76: 3125,
            98: 3104, 2336: 2627, 4384: 2506, 592: 2859,
            81: 3116, 82: 3115, 1537: 2731, 4416: 2505,
            4640: 2495, 88: 3113, 3076: 2608, 2816: 2613,
            608: 2858, 97: 3105, 2066: 2675, 100: 3103,
            4129: 2544, 1041: 2786, 104: 3102, 1282: 2741,
            2305: 2632, 1042: 2785, 4368: 2507, 515: 2918,
            19: 3248, 2561: 2621, 4624: 2496, 6400: 2470,
            532: 2883, 4232: 2519, 4672: 2494, 1044: 2784,
            2084: 2663, 4164: 2531, 4225: 2522, 642: 2851,
            131: 3083, 644: 2850, 133: 3072, 134: 3071,
            6176: 2473, 648: 2849, 137: 3061, 138: 3060,
            140: 3059, 656: 2848, 145: 3050, 146: 3049,
            4130: 2543, 152: 3047, 196: 3026, 2082: 2664,
            2432: 2625, 2068: 2674, 672: 2847, 161: 3039,
            4114: 2554, 164: 3037, 1284: 2740, 168: 3036,
            4353: 2511, 1540: 2729, 176: 3035, 3080: 2607,
            4120: 2552, 4609: 2500, 2306: 2631, 5632: 2480,
            2120: 2651, 1029: 2808, 4132: 2542, 704: 2846,
            193: 3028, 194: 3027, 5121: 2489, 2308: 2630,
            2081: 2665, 200: 3025, 518: 2906, 2240: 2637,
            1058: 2774, 2564: 2619, 1096: 2761, 208: 3024,
            4610: 2499, 3328: 2602, 6656: 2469, 1060: 2773,
            1030: 2807, 2053: 2698, 2562: 2620, 4116: 2553,
            4099: 2588, 5122: 2488, 4226: 2521, 6145: 2478,
            7168: 2468, 5152: 2484, 1064: 2772, 1048: 2783,
            2088: 2662, 4168: 2530, 2054: 2697, 1792: 2723,
            1281: 2742, 770: 2840, 259: 3006, 772: 2839,
            261: 2995, 262: 2994, 641: 2852, 776: 2838,
            265: 2984, 266: 2983, 2208: 2638, 268: 2982,
            1154: 2752, 4612: 2498, 1120: 2759, 784: 2837,
            273: 2973, 274: 2972, 276: 2971, 2072: 2673,
            280: 2970, 1156: 2751, 4864: 2492, 5124: 2487,
            800: 2836, 289: 2962, 290: 2961, 4356: 2509,
            292: 2960, 296: 2959, 112: 3101, 2192: 2639,
            3200: 2603, 3074: 2609, 304: 2958, 1160: 2750,
            1408: 2735, 1033: 2797, 5136: 2485, 4136: 2541,
            1664: 2724, 6148: 2476, 832: 2835, 321: 2951,
            322: 2950, 324: 2949, 6160: 2474, 2568: 2618,
            1153: 2753, 4256: 2517, 336: 2947, 1034: 2796,
            2057: 2687, 6146: 2477, 4162: 2532, 2688: 2614,
            1216: 2747, 4288: 2516, 352: 2946, 1168: 2749,
            3088: 2606, 2177: 2643, 1296: 2738, 4240: 2518,
            5376: 2481, 6208: 2472, 2058: 2686, 148: 3048,
            4360: 2508, 896: 2834, 385: 2940, 386: 2939,
            388: 2938, 2178: 2642, 4161: 2533, 392: 2937,
            2144: 2649, 5184: 2483, 224: 3023, 3136: 2604,
            1090: 2763, 1036: 2795, 400: 2936, 4480: 2504,
            5128: 2486, 1288: 2739, 580: 2861, 4736: 2493,
            416: 2935, 4616: 2497, 2128: 2650, 5248: 2482,
            2060: 2685, 1344: 2736, 328: 2948, 6152: 2475,
            1600: 2725, 448: 2934, 1184: 2748, 2180: 2641,
            1089: 2764, 1072: 2771, 4192: 2528, 6272: 2471,
            162: 3038, 2368: 2626, 1568: 2726, 2624: 2615,
            1104: 2760, 3104: 2605, 2113: 2654, 2096: 2661,
            4176: 2529, 4108: 2564, 1312: 2737, 545: 2874,
            4354: 2510, 84: 3114            
        }
        
        even_xors_to_odd_xors_to_rank = {
            4096: { 2055: 3378, 2059: 3376, 2061: 3375, 2062: 3375,
            15: 1609, 2067: 3373, 2069: 3372, 2070: 3372,
            23: 3539, 2073: 3371, 2074: 3371, 27: 3537,
            2076: 3371, 29: 3536, 30: 3536, 2083: 3369,
            2085: 3368, 2086: 3368, 39: 3533, 2089: 3367,
            2090: 3367, 43: 3531, 2092: 3367, 45: 3530,
            46: 3530, 2097: 3366, 2098: 3366, 51: 3528,
            2100: 3366, 53: 3527, 54: 3527, 2104: 3366,
            57: 3526, 58: 3526, 60: 3526, 2115: 3364,
            2117: 3363, 2118: 3363, 71: 3523, 2121: 3362,
            2122: 3362, 75: 3521, 2124: 3362, 77: 3520,
            78: 3520, 2129: 3361, 2130: 3361, 83: 3518,
            2132: 3361, 85: 3517, 86: 3517, 2136: 3361,
            89: 3516, 90: 3516, 92: 3516, 2145: 3360,
            2146: 3360, 99: 3514, 2148: 3360, 101: 3513,
            102: 3513, 2152: 3360, 105: 3512, 106: 3512,
            108: 3512, 2160: 3360, 113: 3511, 114: 3511,
            116: 3511, 120: 3511, 2179: 3358, 2181: 3357,
            2182: 3357, 135: 3508, 2185: 3356, 2186: 3356,
            139: 3506, 2188: 3356, 141: 3505, 142: 3505,
            2193: 3355, 2194: 3355, 147: 3503, 2196: 3355,
            149: 3502, 150: 3502, 2200: 3355, 153: 3501,
            154: 3501, 156: 3501, 2209: 3354, 2210: 3354,
            163: 3499, 2212: 3354, 165: 3498, 166: 3498,
            2216: 3354, 169: 3497, 170: 3497, 172: 3497,
            2224: 3354, 177: 3496, 178: 3496, 180: 3496,
            184: 3496, 2241: 3353, 2242: 3353, 195: 3494,
            2244: 3353, 197: 3493, 198: 3493, 2248: 3353,
            201: 3492, 202: 3492, 204: 3492, 2256: 3353,
            209: 3491, 210: 3491, 212: 3491, 216: 3491,
            2272: 3353, 225: 3490, 226: 3490, 228: 3490,
            232: 3490, 240: 3490, 2307: 3351, 2309: 3350,
            2310: 3350, 263: 3487, 2313: 3349, 2314: 3349,
            267: 3485, 2316: 3349, 269: 3484, 270: 3484,
            2321: 3348, 2322: 3348, 275: 3482, 2324: 3348,
            277: 3481, 278: 3481, 2328: 3348, 281: 3480,
            282: 3480, 284: 3480, 2337: 3347, 2338: 3347,
            291: 3478, 2340: 3347, 293: 3477, 294: 3477,
            2344: 3347, 297: 3476, 298: 3476, 300: 3476,
            2352: 3347, 305: 3475, 306: 3475, 308: 3475,
            312: 3475, 2369: 3346, 2370: 3346, 323: 3473,
            2372: 3346, 325: 3472, 326: 3472, 2376: 3346,
            329: 3471, 330: 3471, 332: 3471, 2384: 3346,
            337: 3470, 338: 3470, 340: 3470, 344: 3470,
            2400: 3346, 353: 3469, 354: 3469, 356: 3469,
            360: 3469, 368: 3469, 2433: 3345, 2434: 3345,
            387: 3467, 2436: 3345, 389: 3466, 390: 3466,
            2440: 3345, 393: 3465, 394: 3465, 396: 3465,
            2448: 3345, 401: 3464, 402: 3464, 404: 3464,
            408: 3464, 2464: 3345, 417: 3463, 418: 3463,
            420: 3463, 424: 3463, 432: 3463, 2496: 3345,
            449: 3462, 450: 3462, 452: 3462, 456: 3462,
            464: 3462, 480: 3462, 2563: 3343, 2565: 3342,
            2566: 3342, 519: 3459, 2569: 3341, 2570: 3341,
            523: 3457, 2572: 3341, 525: 3456, 526: 3456,
            2577: 3340, 2578: 3340, 531: 3454, 2580: 3340,
            533: 3453, 534: 3453, 2584: 3340, 537: 3452,
            538: 3452, 540: 3452, 2593: 3339, 2594: 3339,
            547: 3450, 2596: 3339, 549: 3449, 550: 3449,
            2600: 3339, 553: 3448, 554: 3448, 556: 3448,
            2608: 3339, 561: 3447, 562: 3447, 564: 3447,
            568: 3447, 2625: 3338, 2626: 3338, 579: 3445,
            2628: 3338, 581: 3444, 582: 3444, 2632: 3338,
            585: 3443, 586: 3443, 588: 3443, 2640: 3338,
            593: 3442, 594: 3442, 596: 3442, 600: 3442,
            2656: 3338, 609: 3441, 610: 3441, 612: 3441,
            616: 3441, 624: 3441, 2689: 3337, 2690: 3337,
            643: 3439, 2692: 3337, 645: 3438, 646: 3438,
            2696: 3337, 649: 3437, 650: 3437, 652: 3437,
            2704: 3337, 657: 3436, 658: 3436, 660: 3436,
            664: 3436, 2720: 3337, 673: 3435, 674: 3435,
            676: 3435, 680: 3435, 688: 3435, 2752: 3337,
            705: 3434, 706: 3434, 708: 3434, 712: 3434,
            720: 3434, 736: 3434, 2817: 3336, 2818: 3336,
            771: 3432, 2820: 3336, 773: 3431, 774: 3431,
            2824: 3336, 777: 3430, 778: 3430, 780: 3430,
            2832: 3336, 785: 3429, 786: 3429, 788: 3429,
            792: 3429, 2848: 3336, 801: 3428, 802: 3428,
            804: 3428, 808: 3428, 816: 3428, 2880: 3336,
            833: 3427, 834: 3427, 836: 3427, 840: 3427,
            848: 3427, 864: 3427, 2944: 3336, 897: 3426,
            898: 3426, 900: 3426, 904: 3426, 912: 3426,
            928: 3426, 960: 3426, 3075: 3334, 3077: 3333,
            3078: 3333, 1031: 3423, 3081: 3332, 3082: 3332,
            1035: 3421, 3084: 3332, 1037: 3420, 1038: 3420,
            3089: 3331, 3090: 3331, 1043: 3418, 3092: 3331,
            1045: 3417, 1046: 3417, 3096: 3331, 1049: 3416,
            1050: 3416, 1052: 3416, 3105: 3330, 3106: 3330,
            1059: 3414, 3108: 3330, 1061: 3413, 1062: 3413,
            3112: 3330, 1065: 3412, 1066: 3412, 1068: 3412,
            3120: 3330, 1073: 3411, 1074: 3411, 1076: 3411,
            1080: 3411, 3137: 3329, 3138: 3329, 1091: 3409,
            3140: 3329, 1093: 3408, 1094: 3408, 3144: 3329,
            1097: 3407, 1098: 3407, 1100: 3407, 3152: 3329,
            1105: 3406, 1106: 3406, 1108: 3406, 1112: 3406,
            3168: 3329, 1121: 3405, 1122: 3405, 1124: 3405,
            1128: 3405, 1136: 3405, 3201: 3328, 3202: 3328,
            1155: 3403, 3204: 3328, 1157: 3402, 1158: 3402,
            3208: 3328, 1161: 3401, 1162: 3401, 1164: 3401,
            3216: 3328, 1169: 3400, 1170: 3400, 1172: 3400,
            1176: 3400, 3232: 3328, 1185: 3399, 1186: 3399,
            1188: 3399, 1192: 3399, 1200: 3399, 3264: 3328,
            1217: 3398, 1218: 3398, 1220: 3398, 1224: 3398,
            1232: 3398, 1248: 3398, 3329: 3327, 3330: 3327,
            1283: 3396, 3332: 3327, 1285: 3395, 1286: 3395,
            3336: 3327, 1289: 3394, 1290: 3394, 1292: 3394,
            3344: 3327, 1297: 3393, 1298: 3393, 1300: 3393,
            1304: 3393, 3360: 3327, 1313: 3392, 1314: 3392,
            1316: 3392, 1320: 3392, 1328: 3392, 3392: 3327,
            1345: 3391, 1346: 3391, 1348: 3391, 1352: 3391,
            1360: 3391, 1376: 3391, 3456: 3327, 1409: 3390,
            1410: 3390, 1412: 3390, 1416: 3390, 1424: 3390,
            1440: 3390, 1472: 3390, 3585: 3326, 3586: 3326,
            1539: 3388, 3588: 3326, 1541: 3387, 1542: 3387,
            3592: 3326, 1545: 3386, 1546: 3386, 1548: 3386,
            3600: 3326, 1553: 3385, 1554: 3385, 1556: 3385,
            1560: 3385, 3616: 3326, 1569: 3384, 1570: 3384,
            1572: 3384, 1576: 3384, 1584: 3384, 3648: 3326,
            1601: 3383, 1602: 3383, 1604: 3383, 1608: 3383,
            1616: 3383, 1632: 3383, 3712: 3326, 1665: 3382,
            1666: 3382, 1668: 3382, 1672: 3382, 1680: 3382,
            1696: 3382, 1728: 3382, 3840: 1600, 1793: 3381,
            1794: 3381, 1796: 3381, 1800: 3381, 1808: 3381,
            1824: 3381, 1856: 3381, 1920: 3381 },
            1: { 6150: 5974, 6154: 5973, 6156: 5973, 4110: 1609,
            6162: 5972, 6164: 5972, 4118: 6016, 6168: 5972,
            2074: 6060, 4124: 6015, 30: 1608, 6178: 5971,
            6180: 5971, 3078: 6028, 2086: 6058, 6184: 5971,
            2090: 6057, 2092: 6057, 46: 6179, 6192: 5971,
            2098: 6056, 2100: 6056, 54: 6177, 2104: 6056,
            58: 6176, 60: 6176, 3082: 6027, 4448: 5994,
            6210: 5970, 6212: 5970, 4166: 6009, 6216: 5970,
            5132: 5982, 4170: 6008, 2124: 6053, 78: 6173,
            6224: 5970, 4178: 6007, 2132: 6052, 2062: 6063,
            86: 6171, 2136: 6052, 90: 6170, 92: 6170,
            6240: 5970, 4194: 6006, 2148: 6051, 102: 6168,
            4200: 6006, 106: 6167, 108: 6167, 5138: 5981,
            2160: 6051, 114: 6166, 116: 6166, 120: 6166,
            5140: 5981, 4800: 5986, 6274: 5969, 6276: 5969,
            2070: 6061, 4230: 6004, 6280: 5969, 2186: 6048,
            4236: 6003, 142: 6163, 6288: 5969, 3096: 6026,
            2194: 6047, 2196: 6047, 150: 6161, 2200: 6047,
            154: 6160, 156: 6160, 4122: 6015, 6304: 5969,
            2210: 6046, 2212: 6046, 166: 6158, 2216: 6046,
            2076: 6060, 170: 6157, 172: 6157, 2224: 6046,
            178: 6156, 180: 6156, 184: 6156, 6336: 5969,
            2242: 6045, 2244: 6045, 198: 6154, 4296: 6000,
            202: 6153, 204: 6153, 3106: 6025, 2256: 6045,
            210: 6152, 212: 6152, 216: 6152, 3108: 6025,
            2272: 6045, 226: 6151, 228: 6151, 4134: 6013,
            232: 6151, 240: 6151, 3112: 6025, 4138: 6012,
            5504: 5977, 6402: 5968, 6404: 5968, 2310: 6043,
            6408: 5968, 4140: 6012, 4362: 5997, 2316: 6042,
            4482: 5993, 270: 6148, 6416: 5968, 2322: 6041,
            4372: 5996, 278: 6146, 4376: 5996, 2436: 6038,
            282: 6145, 284: 6145, 6432: 5968, 5168: 5980,
            2338: 6040, 2340: 6040, 294: 6143, 2344: 6040,
            298: 6142, 300: 6142, 4146: 6011, 2352: 6040,
            4488: 5993, 306: 6141, 308: 6141, 312: 6141,
            4148: 6011, 6464: 5968, 2370: 6039, 2372: 6039,
            326: 6139, 2376: 6039, 330: 6138, 332: 6138,
            2384: 6039, 4152: 6011, 338: 6137, 340: 6137,
            344: 6137, 2400: 6039, 4496: 5993, 354: 6136,
            356: 6136, 360: 6136, 368: 6136, 6528: 5968,
            2434: 6038, 4484: 5993, 390: 6134, 2440: 6038,
            394: 6133, 396: 6133, 3138: 6024, 2448: 6038,
            402: 6132, 404: 6132, 408: 6132, 3140: 6024,
            2464: 6038, 418: 6131, 420: 6131, 2118: 6054,
            424: 6131, 432: 6131, 5192: 5979, 2122: 6053,
            2496: 6038, 4512: 5993, 450: 6130, 452: 6130,
            456: 6130, 4172: 6008, 464: 6130, 480: 6130,
            5200: 5979, 2130: 6052, 4180: 6007, 5888: 5976,
            6658: 5967, 6660: 5967, 2566: 6036, 6664: 5967,
            2570: 6035, 2572: 6035, 4866: 5985, 526: 6127,
            6672: 5967, 4184: 6007, 4626: 5989, 2580: 6034,
            534: 6125, 4632: 5989, 4868: 5985, 538: 6124,
            540: 6124, 6688: 5967, 2594: 6033, 2596: 6033,
            550: 6122, 4648: 5988, 554: 6121, 556: 6121,
            2608: 6033, 4872: 5985, 562: 6120, 564: 6120,
            568: 6120, 6720: 5967, 5216: 5979, 2626: 6032,
            2628: 6032, 582: 6118, 2632: 6032, 586: 6117,
            588: 6117, 2146: 6051, 2640: 6032, 594: 6116,
            596: 6116, 600: 6116, 4196: 6006, 2656: 6032,
            4880: 5985, 610: 6115, 612: 6115, 616: 6115,
            624: 6115, 2152: 6051, 6784: 5967, 4544: 5993,
            2690: 6031, 2692: 6031, 646: 6113, 2696: 6031,
            650: 6112, 652: 6112, 2704: 6031, 658: 6111,
            660: 6111, 664: 6111, 2720: 6031, 4208: 6006,
            674: 6110, 676: 6110, 680: 6110, 688: 6110,
            2752: 6031, 4896: 5985, 706: 6109, 708: 6109,
            712: 6109, 720: 6109, 736: 6109, 6912: 5967,
            2818: 6030, 2820: 6030, 774: 6107, 2824: 6030,
            778: 6106, 780: 6106, 5250: 5978, 2832: 6030,
            786: 6105, 788: 6105, 792: 6105, 3204: 6023,
            2848: 6030, 802: 6104, 804: 6104, 2182: 6049,
            808: 6104, 816: 6104, 5256: 5978, 4234: 6003,
            2880: 6030, 834: 6103, 836: 6103, 840: 6103,
            2188: 6048, 848: 6103, 864: 6103, 5264: 5978,
            4242: 6002, 4244: 6002, 2944: 6030, 4928: 5985,
            898: 6102, 900: 6102, 904: 6102, 912: 6102,
            4248: 6002, 928: 6102, 960: 6102, 5280: 5978,
            4258: 6001, 4260: 6001, 4264: 6001, 7170: 5966,
            7172: 5966, 5126: 5983, 7176: 5966, 5130: 5982,
            3084: 6027, 5634: 5976, 1038: 6099, 7184: 5966,
            3090: 6026, 3092: 6026, 1046: 6097, 5144: 5981,
            5636: 5976, 1050: 6096, 1052: 6096, 7200: 5966,
            4272: 6001, 5154: 5980, 5156: 5980, 4614: 5991,
            1062: 6094, 5160: 5980, 1066: 6093, 1068: 6093,
            3120: 6025, 5640: 5976, 1074: 6092, 1076: 6092,
            1080: 6092, 4618: 5990, 7232: 5966, 5186: 5979,
            5188: 5979, 1094: 6090, 3144: 6024, 4620: 5990,
            1098: 6089, 1100: 6089, 3152: 6024, 1106: 6088,
            1108: 6088, 1112: 6088, 3168: 6024, 5648: 5976,
            1122: 6087, 1124: 6087, 1128: 6087, 2578: 6034,
            1136: 6087, 4628: 5989, 7296: 5966, 5312: 5978,
            3202: 6023, 5252: 5978, 1158: 6085, 3208: 6023,
            1162: 6084, 1164: 6084, 4290: 6000, 3216: 6023,
            2584: 6034, 1170: 6083, 1172: 6083, 1176: 6083,
            4292: 6000, 3232: 6023, 1186: 6082, 1188: 6082,
            1192: 6082, 1200: 6082, 2248: 6045, 3264: 6023,
            5664: 5976, 1218: 6081, 1220: 6081, 1224: 6081,
            4642: 5988, 1232: 6081, 4644: 5988, 1248: 6081,
            4304: 6000, 2600: 6033, 7424: 5966, 4992: 5985,
            5378: 5977, 5380: 5977, 1286: 6079, 3336: 6022,
            1290: 6078, 1292: 6078, 3344: 6022, 1298: 6077,
            1300: 6077, 1304: 6077, 3360: 6022, 4656: 5988,
            1314: 6076, 1316: 6076, 1320: 6076, 1328: 6076,
            3392: 6022, 4320: 6000, 1346: 6075, 1348: 6075,
            1352: 6075, 1360: 6075, 1376: 6075, 3456: 6022,
            5696: 5976, 1410: 6074, 1412: 6074, 1416: 6074,
            4674: 5987, 1424: 6074, 4676: 5987, 1440: 6074,
            4680: 5987, 1472: 6074, 4688: 5987, 7680: 5966,
            3586: 6021, 3588: 6021, 1542: 6072, 3592: 6021,
            1546: 6071, 1548: 6071, 3330: 6022, 3600: 6021,
            1554: 6070, 1556: 6070, 1560: 6070, 3332: 6022,
            3616: 6021, 1570: 6069, 1572: 6069, 4358: 5998,
            1576: 6069, 1584: 6069, 5384: 5977, 2314: 6042,
            3648: 6021, 4704: 5987, 1602: 6068, 1604: 6068,
            1608: 6068, 4364: 5997, 1616: 6068, 1632: 6068,
            5392: 5977, 4370: 5996, 2324: 6041, 3712: 6021,
            1666: 6067, 1668: 6067, 1672: 6067, 1680: 6067,
            2328: 6041, 1696: 6067, 1728: 6067, 5408: 5977,
            4386: 5995, 4388: 5995, 4392: 5995, 3840: 6021,
            5760: 5976, 1794: 6066, 1796: 6066, 1800: 6066,
            4738: 5986, 1808: 6066, 4740: 5986, 1824: 6066,
            4400: 5995, 4744: 5986, 1856: 6066, 4752: 5986,
            1920: 6066, 5440: 5977, 4418: 5994, 4420: 5994,
            4424: 5994, 4768: 5986, 4432: 5994 },
            2: { 6149: 5754, 6153: 5753, 6156: 5753, 4109: 1609,
            6161: 5752, 6164: 5752, 2069: 5841, 6168: 5752,
            4121: 5795, 2076: 5840, 29: 1608, 3077: 5808,
            6177: 5751, 6180: 5751, 4133: 5793, 6184: 5751,
            2089: 5837, 2092: 5837, 45: 5959, 6192: 5751,
            2097: 5836, 2100: 5836, 53: 5957, 3081: 5807,
            2104: 5836, 57: 5956, 60: 1607, 6209: 5750,
            6212: 5750, 4165: 5789, 6216: 5750, 4169: 5788,
            2124: 5833, 77: 5953, 2061: 5843, 6224: 5750,
            4177: 5787, 2132: 5832, 85: 5951, 4184: 5787,
            89: 5950, 92: 5950, 6240: 5750, 2145: 5831,
            2148: 5831, 101: 5948, 5137: 5761, 2152: 5831,
            105: 5947, 108: 5947, 2160: 5831, 113: 5946,
            116: 5946, 5664: 5756, 120: 5946, 5140: 5761,
            4117: 5796, 6273: 5749, 6276: 5749, 4229: 5784,
            6280: 5749, 2185: 5828, 2188: 5828, 141: 5943,
            6288: 5749, 2193: 5827, 2196: 5827, 149: 5941,
            2073: 5840, 2200: 5827, 153: 5940, 156: 5940,
            6304: 5749, 4257: 5781, 2212: 5826, 165: 5938,
            4264: 5781, 169: 5937, 172: 5937, 2224: 5826,
            177: 5936, 180: 5936, 184: 5936, 6336: 5749,
            2241: 5825, 2244: 5825, 197: 5934, 3105: 5805,
            2248: 5825, 201: 5933, 204: 5933, 2256: 5825,
            209: 5932, 212: 5932, 216: 5932, 5156: 5760,
            2085: 5838, 2272: 5825, 225: 5931, 228: 5931,
            232: 5931, 240: 5931, 3112: 5805, 4137: 5792,
            6401: 5748, 6404: 5748, 2309: 5823, 4481: 5773,
            6408: 5748, 4361: 5777, 2316: 5822, 269: 5928,
            6416: 5748, 2321: 5821, 2324: 5821, 277: 5926,
            4376: 5776, 281: 5925, 284: 5925, 6432: 5748,
            4385: 5775, 2340: 5820, 293: 5923, 4145: 5791,
            4392: 5775, 297: 5922, 300: 5922, 2352: 5820,
            305: 5921, 308: 5921, 312: 5921, 4148: 5791,
            6464: 5748, 4417: 5774, 2372: 5819, 325: 5919,
            2376: 5819, 329: 5918, 332: 5918, 2384: 5819,
            4152: 5791, 4512: 5773, 340: 5917, 344: 5917,
            2400: 5819, 353: 5916, 356: 5916, 360: 5916,
            4544: 5773, 368: 5916, 6528: 5748, 2433: 5818,
            4484: 5773, 389: 5914, 5185: 5759, 4241: 5782,
            393: 5913, 396: 5913, 2448: 5818, 401: 5912,
            404: 5912, 408: 5912, 3140: 5804, 2117: 5834,
            2464: 5818, 417: 5911, 4992: 5765, 420: 5911,
            424: 5911, 432: 5911, 5192: 5759, 2121: 5833,
            2496: 5818, 449: 5910, 452: 5910, 456: 5910,
            4172: 5788, 3084: 5807, 464: 5910, 4448: 5774,
            480: 5910, 5200: 5759, 2129: 5832, 4180: 5787,
            6657: 5747, 6660: 5747, 4613: 5771, 4865: 5765,
            6664: 5747, 2569: 5815, 2572: 5815, 525: 5907,
            6672: 5747, 2577: 5814, 2580: 5814, 533: 5905,
            2584: 5814, 537: 5904, 540: 5904, 6688: 5747,
            4641: 5768, 2596: 5813, 549: 5902, 4648: 5768,
            553: 5901, 556: 5901, 2608: 5813, 561: 5900,
            564: 5900, 4656: 5768, 568: 5900, 6720: 5747,
            4673: 5767, 2628: 5812, 581: 5898, 4193: 5786,
            2632: 5812, 585: 5897, 588: 5897, 2640: 5812,
            593: 5896, 596: 5896, 600: 5896, 4196: 5786,
            2656: 5812, 609: 5895, 612: 5895, 616: 5895,
            624: 5895, 4200: 5786, 6784: 5747, 2689: 5811,
            4740: 5766, 645: 5893, 2696: 5811, 649: 5892,
            652: 5892, 2704: 5811, 657: 5891, 660: 5891,
            2136: 5832, 2720: 5811, 673: 5890, 676: 5890,
            4928: 5765, 680: 5890, 688: 5890, 5888: 5756,
            2752: 5811, 705: 5889, 708: 5889, 712: 5889,
            4320: 5780, 720: 5889, 736: 5889, 6912: 5747,
            2817: 5810, 2820: 5810, 773: 5887, 5249: 5758,
            2824: 5810, 777: 5886, 780: 5886, 2832: 5810,
            785: 5885, 788: 5885, 4868: 5765, 792: 5885,
            3204: 5803, 4800: 5766, 2181: 5829, 2848: 5810,
            801: 5884, 804: 5884, 808: 5884, 816: 5884,
            5256: 5758, 4233: 5783, 2880: 5810, 833: 5883,
            836: 5883, 840: 5883, 4236: 5783, 848: 5883,
            864: 5883, 5264: 5758, 1169: 5863, 5144: 5761,
            4244: 5782, 2944: 5810, 897: 5882, 900: 5882,
            904: 5882, 4872: 5765, 912: 5882, 4248: 5782,
            928: 5882, 5760: 5756, 960: 5882, 5280: 5758,
            2209: 5826, 4124: 5795, 4260: 5781, 5216: 5759,
            2216: 5826, 7169: 5746, 7172: 5746, 5125: 5763,
            5633: 5756, 7176: 5746, 5129: 5762, 5132: 5762,
            1037: 5879, 7184: 5746, 3089: 5806, 3092: 5806,
            1045: 5877, 3096: 5806, 1049: 5876, 1052: 5876,
            2565: 5816, 7200: 5746, 5153: 5760, 3108: 5805,
            1061: 5874, 5160: 5760, 1065: 5873, 1068: 5873,
            3120: 5805, 1073: 5872, 1076: 5872, 4617: 5770,
            1080: 5872, 7232: 5746, 3137: 5804, 5188: 5759,
            1093: 5870, 3144: 5804, 1097: 5869, 1100: 5869,
            3152: 5804, 1105: 5868, 1108: 5868, 1112: 5868,
            3168: 5804, 1121: 5867, 1124: 5867, 4625: 5769,
            1128: 5867, 1136: 5867, 4628: 5769, 4880: 5765,
            7296: 5746, 3201: 5803, 5252: 5758, 1157: 5865,
            4289: 5780, 3208: 5803, 1161: 5864, 1164: 5864,
            3216: 5803, 4632: 5769, 1172: 5863, 1176: 5863,
            4292: 5780, 3232: 5803, 1185: 5862, 1188: 5862,
            1192: 5862, 1200: 5862, 4296: 5780, 3264: 5803,
            1217: 5861, 1220: 5861, 2593: 5813, 1224: 5861,
            1232: 5861, 4644: 5768, 1248: 5861, 4304: 5780,
            2600: 5813, 7424: 5746, 5377: 5757, 3332: 5802,
            1285: 5859, 3336: 5802, 1289: 5858, 1292: 5858,
            3344: 5802, 1297: 5857, 1300: 5857, 1304: 5857,
            5696: 5756, 3360: 5802, 1313: 5856, 1316: 5856,
            1320: 5856, 4272: 5781, 5636: 5756, 1328: 5856,
            3392: 5802, 1345: 5855, 1348: 5855, 1352: 5855,
            1360: 5855, 1376: 5855, 3456: 5802, 1409: 5854,
            1412: 5854, 2625: 5812, 1416: 5854, 1424: 5854,
            4676: 5767, 1440: 5854, 5640: 5756, 4208: 5786,
            4140: 5792, 4680: 5767, 5504: 5757, 1472: 5854,
            2436: 5818, 4688: 5767, 4620: 5770, 7680: 5746,
            3585: 5801, 3588: 5801, 1541: 5852, 3329: 5802,
            3592: 5801, 1545: 5851, 1548: 5851, 3600: 5801,
            1553: 5850, 1556: 5850, 1560: 5850, 5380: 5757,
            4357: 5778, 3616: 5801, 1569: 5849, 1572: 5849,
            1576: 5849, 1584: 5849, 5384: 5757, 2313: 5822,
            3648: 5801, 1601: 5848, 2440: 5818, 1604: 5848,
            5168: 5760, 1608: 5848, 4364: 5777, 1616: 5848,
            4896: 5765, 1632: 5848, 5392: 5757, 4369: 5776,
            4372: 5776, 3712: 5801, 1665: 5847, 4488: 5773,
            1668: 5847, 1672: 5847, 1680: 5847, 2328: 5821,
            5648: 5756, 1696: 5847, 1728: 5847, 5408: 5757,
            2337: 5820, 4388: 5775, 2344: 5820, 3840: 5801,
            1793: 5846, 1796: 5846, 4737: 5766, 1800: 5846,
            1808: 5846, 2692: 5811, 1824: 5846, 4400: 5775,
            5312: 5758, 4744: 5766, 1856: 5846, 4752: 5766,
            4496: 5773, 1920: 5846, 5440: 5757, 2369: 5819,
            664: 5891, 4420: 5774, 4424: 5774, 4768: 5766,
            4704: 5767, 4432: 5774, 337: 5917 },
            3: { 384: 3319, 320: 3319, 132: 3320, 260: 3319,
            520: 3318, 2080: 3316, 264: 3319, 4224: 3315,
            3072: 3316, 12: 3324, 4352: 3315, 144: 3320,
            20: 3323, 1032: 3317, 768: 3318, 24: 3323,
            516: 3318, 640: 3318, 1028: 3317, 1040: 3317,
            36: 3322, 2064: 3316, 40: 3322, 1152: 3317,
            4160: 3315, 1280: 3317, 48: 3322, 2056: 3316,
            1536: 3317, 288: 3319, 2052: 3316, 192: 3320,
            160: 3320, 68: 3321, 6144: 3315, 4128: 3315,
            72: 3321, 1088: 3317, 2304: 3316, 528: 3318,
            80: 3321, 5120: 3315, 2560: 3316, 544: 3318,
            96: 3321, 272: 3319, 4112: 3315, 1056: 3317,
            2112: 3316, 4608: 3315, 2176: 3316, 4104: 3315,
            576: 3318, 136: 3320, 4100: 3315 },
            4: { 6147: 5534, 6153: 5533, 6154: 5533, 2059: 5623,
            6161: 5532, 6162: 5532, 2067: 5621, 6168: 5532,
            2073: 5620, 2074: 5620, 27: 1608, 6177: 5531,
            6178: 5531, 4131: 5573, 6184: 5531, 4137: 5572,
            2090: 5617, 43: 5739, 4992: 5545, 6192: 5531,
            2097: 5616, 2098: 5616, 51: 5737, 3081: 5587,
            2104: 5616, 57: 5736, 58: 1607, 3082: 5587,
            6209: 5530, 6210: 5530, 4163: 5569, 6216: 5530,
            4169: 5568, 4170: 5568, 75: 5733, 6224: 5530,
            4177: 5567, 4178: 5567, 83: 5731, 2136: 5612,
            89: 5730, 90: 5730, 6240: 5530, 2145: 5611,
            4194: 5566, 99: 5728, 5137: 5541, 2152: 5611,
            105: 5727, 106: 5727, 5138: 5541, 2160: 5611,
            113: 5726, 114: 5726, 4115: 5576, 5664: 5536,
            120: 1606, 6273: 5529, 6274: 5529, 2179: 5609,
            6280: 5529, 2185: 5608, 2186: 5608, 139: 5723,
            4488: 5553, 6288: 5529, 5144: 5541, 2194: 5607,
            147: 5721, 4121: 5575, 2200: 5607, 153: 5720,
            154: 5720, 4122: 5575, 6304: 5529, 2209: 5606,
            2210: 5606, 163: 5718, 4264: 5561, 169: 5717,
            170: 5717, 2224: 5606, 177: 5716, 178: 5716,
            184: 5716, 3075: 5588, 2241: 5605, 4290: 5560,
            195: 5714, 3105: 5585, 2248: 5605, 201: 5713,
            202: 5713, 3106: 5585, 2256: 5605, 209: 5712,
            210: 5712, 2083: 5618, 216: 5712, 2272: 5605,
            225: 5711, 226: 5711, 232: 5711, 240: 5711,
            5160: 5540, 2089: 5617, 4138: 5572, 6401: 5528,
            6402: 5528, 2307: 5603, 4481: 5553, 6408: 5528,
            4361: 5557, 2314: 5602, 267: 5708, 2434: 5598,
            6416: 5528, 2321: 5601, 2322: 5601, 275: 5706,
            4376: 5556, 281: 5705, 282: 5705, 6432: 5528,
            2337: 5600, 2338: 5600, 291: 5703, 4145: 5571,
            2344: 5600, 297: 5702, 298: 5702, 4146: 5571,
            2352: 5600, 305: 5701, 306: 5701, 312: 5701,
            6464: 5528, 4417: 5554, 2370: 5599, 323: 5699,
            2376: 5599, 329: 5698, 330: 5698, 2384: 5599,
            4152: 5571, 338: 5697, 4512: 5553, 344: 5697,
            2400: 5599, 353: 5696, 354: 5696, 360: 5696,
            368: 5696, 6528: 5528, 2433: 5598, 4482: 5553,
            387: 5694, 5185: 5539, 4241: 5562, 393: 5693,
            394: 5693, 5186: 5539, 2448: 5598, 401: 5692,
            402: 5692, 2115: 5614, 408: 5692, 2464: 5598,
            417: 5691, 418: 5691, 424: 5691, 432: 5691,
            5192: 5539, 2121: 5613, 2122: 5613, 2496: 5598,
            449: 5690, 450: 5690, 456: 5690, 4107: 1609,
            4448: 5554, 480: 5690, 5200: 5539, 2129: 5612,
            2130: 5612, 6657: 5527, 6658: 5527, 2563: 5596,
            4865: 5545, 6664: 5527, 2569: 5595, 2570: 5595,
            523: 5687, 4866: 5545, 6672: 5527, 2577: 5594,
            4626: 5549, 531: 5685, 4632: 5549, 537: 5684,
            538: 5684, 6688: 5527, 2593: 5593, 2594: 5593,
            547: 5682, 4648: 5548, 553: 5681, 554: 5681,
            2608: 5593, 561: 5680, 562: 5680, 4656: 5548,
            568: 5680, 6720: 5527, 4673: 5547, 2626: 5592,
            579: 5678, 4193: 5566, 2632: 5592, 585: 5677,
            586: 5677, 2146: 5611, 2640: 5592, 593: 5676,
            594: 5676, 600: 5676, 2656: 5592, 609: 5675,
            610: 5675, 616: 5675, 624: 5675, 4200: 5566,
            6784: 5527, 2689: 5591, 4738: 5546, 643: 5673,
            2696: 5591, 649: 5672, 650: 5672, 2704: 5591,
            657: 5671, 658: 5671, 664: 5671, 2720: 5591,
            673: 5670, 674: 5670, 4928: 5545, 680: 5670,
            688: 5670, 5888: 5536, 2752: 5591, 705: 5669,
            706: 5669, 712: 5669, 4320: 5560, 720: 5669,
            4184: 5567, 736: 5669, 464: 5690, 6912: 5527,
            2817: 5590, 2818: 5590, 771: 5667, 5249: 5538,
            2824: 5590, 777: 5666, 778: 5666, 5250: 5538,
            2832: 5590, 785: 5665, 786: 5665, 4227: 5564,
            792: 5665, 4800: 5546, 2848: 5590, 801: 5664,
            802: 5664, 808: 5664, 816: 5664, 5256: 5538,
            4233: 5563, 4234: 5563, 2880: 5590, 833: 5663,
            834: 5663, 840: 5663, 848: 5663, 864: 5663,
            5264: 5538, 2193: 5607, 4242: 5562, 2944: 5590,
            897: 5662, 898: 5662, 904: 5662, 4872: 5545,
            912: 5662, 4248: 5562, 928: 5662, 5760: 5536,
            960: 5662, 5280: 5538, 4257: 5561, 4258: 5561,
            5216: 5539, 2216: 5606, 7169: 5526, 7170: 5526,
            5123: 5543, 5633: 5536, 7176: 5526, 5129: 5542,
            5130: 5542, 1035: 5659, 3586: 5581, 7184: 5526,
            3089: 5586, 3090: 5586, 1043: 5657, 3096: 5586,
            1049: 5656, 1050: 5656, 7200: 5526, 5153: 5540,
            5154: 5540, 1059: 5654, 3112: 5585, 1065: 5653,
            1066: 5653, 3120: 5585, 1073: 5652, 1074: 5652,
            4617: 5550, 1080: 5652, 4618: 5550, 7232: 5526,
            3137: 5584, 3138: 5584, 1091: 5650, 3144: 5584,
            1097: 5649, 1098: 5649, 3152: 5584, 1105: 5648,
            1106: 5648, 1112: 5648, 3168: 5584, 1121: 5647,
            1122: 5647, 4625: 5549, 1128: 5647, 2578: 5594,
            1136: 5647, 4880: 5545, 7296: 5526, 3201: 5583,
            3202: 5583, 1155: 5645, 4289: 5560, 3208: 5583,
            1161: 5644, 1162: 5644, 2242: 5605, 3216: 5583,
            2584: 5594, 1170: 5643, 1176: 5643, 3232: 5583,
            1185: 5642, 1186: 5642, 1192: 5642, 1200: 5642,
            4296: 5560, 3264: 5583, 1217: 5641, 1218: 5641,
            4641: 5548, 1224: 5641, 4642: 5548, 1232: 5641,
            1248: 5641, 4304: 5560, 4611: 5551, 2600: 5593,
            7424: 5526, 3329: 5582, 5378: 5537, 1283: 5639,
            3336: 5582, 1289: 5638, 1290: 5638, 3344: 5582,
            1297: 5637, 1298: 5637, 4544: 5553, 1304: 5637,
            5696: 5536, 3360: 5582, 1313: 5636, 1314: 5636,
            1320: 5636, 4272: 5561, 1328: 5636, 3392: 5582,
            1345: 5635, 1346: 5635, 1352: 5635, 1360: 5635,
            1376: 5635, 3456: 5582, 1409: 5634, 1410: 5634,
            2625: 5592, 1416: 5634, 4674: 5547, 1424: 5634,
            1440: 5634, 5640: 5536, 4208: 5566, 4680: 5547,
            5504: 5537, 1472: 5634, 1169: 5643, 4688: 5547,
            7680: 5526, 3585: 5581, 5634: 5536, 1539: 5632,
            5377: 5537, 3592: 5581, 1545: 5631, 1546: 5631,
            3330: 5582, 3600: 5581, 1553: 5630, 1554: 5630,
            4355: 5558, 1560: 5630, 3616: 5581, 1569: 5629,
            1570: 5629, 1576: 5629, 1584: 5629, 5384: 5537,
            2313: 5602, 4362: 5557, 3648: 5581, 1601: 5628,
            1602: 5628, 5168: 5540, 1608: 5628, 1616: 5628,
            4896: 5545, 1632: 5628, 5392: 5537, 4369: 5556,
            4370: 5556, 3712: 5581, 1665: 5627, 1666: 5627,
            1672: 5627, 1680: 5627, 2328: 5601, 5648: 5536,
            1696: 5627, 1728: 5627, 5408: 5537, 4385: 5555,
            4386: 5555, 4392: 5555, 3840: 5581, 1793: 5626,
            1794: 5626, 4737: 5546, 1800: 5626, 2690: 5591,
            1808: 5626, 1824: 5626, 4400: 5555, 5312: 5538,
            4744: 5546, 1856: 5626, 6336: 5529, 2440: 5598,
            4752: 5546, 4496: 5553, 1920: 5626, 5440: 5537,
            2369: 5599, 4418: 5554, 4424: 5554, 4768: 5546,
            4704: 5547, 4432: 5554, 337: 5697 },
            5: { 384: 3308, 320: 3308, 258: 3308, 520: 3307,
            2080: 3305, 4104: 3304, 10: 3313, 3072: 3305,
            288: 3308, 130: 3309, 4352: 3304, 144: 3309,
            18: 3312, 4608: 3304, 24: 3312, 640: 3307,
            768: 3307, 1040: 3306, 34: 3311, 2064: 3305,
            40: 3311, 1152: 3306, 4160: 3304, 1280: 3306,
            48: 3311, 1032: 3306, 2056: 3305, 4224: 3304,
            192: 3309, 160: 3309, 66: 3310, 5120: 3304,
            6144: 3304, 4128: 3304, 72: 3310, 1088: 3306,
            2050: 3305, 2304: 3305, 4098: 3304, 80: 3310,
            1536: 3306, 514: 3307, 2560: 3305, 544: 3307,
            96: 3310, 272: 3308, 1026: 3306, 4112: 3304,
            1056: 3306, 2112: 3305, 2176: 3305, 528: 3307,
            576: 3307, 136: 3309, 264: 3308 },
            6: { 384: 3297, 129: 3298, 3072: 3294, 520: 3296,
            1025: 3295, 264: 3297, 9: 3302, 4224: 3293,
            288: 3297, 4352: 3293, 144: 3298, 17: 3301,
            1032: 3295, 24: 3301, 640: 3296, 768: 3296,
            1040: 3295, 33: 3300, 4097: 3293, 2064: 3294,
            40: 3300, 1152: 3295, 257: 3297, 4160: 3293,
            1280: 3295, 48: 3300, 2056: 3294, 513: 3296,
            1536: 3295, 2080: 3294, 192: 3298, 65: 3299,
            5120: 3293, 6144: 3293, 4128: 3293, 72: 3299,
            1088: 3295, 160: 3298, 2304: 3294, 528: 3296,
            80: 3299, 320: 3297, 2560: 3294, 544: 3296,
            96: 3299, 272: 3297, 2049: 3294, 4112: 3293,
            1056: 3295, 2112: 3294, 4608: 3293, 2176: 3294,
            4104: 3293, 576: 3296, 136: 3298 },
            257: { 640: 3010, 576: 3010, 2050: 3008, 4100: 3007,
            6: 3016, 2080: 3008, 136: 3011, 10: 3015,
            132: 3011, 12: 3015, 1026: 3009, 144: 3011,
            18: 3014, 20: 3014, 1032: 3009, 24: 3014,
            516: 3010, 1028: 3009, 1040: 3009, 34: 3013,
            36: 3013, 2064: 3008, 40: 3013, 1152: 3009,
            4160: 3007, 48: 3013, 520: 3010, 2056: 3008,
            4224: 3007, 3072: 3008, 2052: 3008, 192: 3011,
            160: 3011, 66: 3012, 68: 3012, 130: 3011,
            4128: 3007, 72: 3012, 1088: 3009, 4098: 3007,
            80: 3012, 1536: 3009, 514: 3010, 5120: 3007,
            2560: 3008, 544: 3010, 96: 3012, 528: 3010,
            6144: 3007, 4112: 3007, 1056: 3009, 2112: 3008,
            4608: 3007, 2176: 3008, 4104: 3007 },
            8: { 6147: 5314, 6149: 5313, 6150: 5313, 2055: 5403,
            6161: 5312, 6162: 5312, 2067: 5401, 6164: 5312,
            2069: 5400, 2070: 5400, 23: 1608, 5125: 5322,
            6177: 5311, 6178: 5311, 4131: 5353, 6180: 5311,
            2085: 5397, 2086: 5397, 39: 5519, 1031: 5439,
            4992: 5325, 6192: 5311, 2097: 5396, 2098: 5396,
            51: 5517, 2100: 5396, 53: 5516, 54: 1607,
            6209: 5310, 6210: 5310, 4163: 5349, 6212: 5310,
            4165: 5348, 2118: 5393, 71: 5513, 6224: 5310,
            4177: 5347, 4178: 5347, 83: 5511, 2132: 5392,
            85: 5510, 86: 5510, 6240: 5310, 2145: 5391,
            4194: 5346, 99: 5508, 2148: 5391, 101: 5507,
            102: 5507, 5137: 5321, 5138: 5321, 2160: 5391,
            113: 5506, 114: 5506, 4115: 5356, 116: 1606,
            5664: 5316, 5140: 5321, 4117: 5355, 6273: 5309,
            6274: 5309, 2179: 5389, 6276: 5309, 4229: 5343,
            4230: 5343, 135: 5503, 6288: 5309, 2193: 5387,
            2194: 5387, 147: 5501, 2196: 5387, 149: 5500,
            150: 5500, 6304: 5309, 2209: 5386, 2210: 5386,
            163: 5498, 2212: 5386, 165: 5497, 166: 5497,
            2224: 5386, 177: 5496, 178: 5496, 180: 5496,
            3075: 5368, 2241: 5385, 4290: 5340, 195: 5494,
            2244: 5385, 197: 5493, 198: 5493, 3105: 5365,
            3106: 5365, 2256: 5385, 209: 5492, 210: 5492,
            2083: 5398, 212: 5492, 3108: 5365, 4133: 5352,
            2272: 5385, 225: 5491, 226: 5491, 228: 5491,
            4134: 5352, 240: 1605, 6401: 5308, 6402: 5308,
            2307: 5383, 6404: 5308, 2309: 5382, 2310: 5382,
            263: 5488, 2434: 5378, 6416: 5308, 2321: 5381,
            2322: 5381, 275: 5486, 4372: 5336, 277: 5485,
            278: 5485, 4484: 5333, 6432: 5308, 4385: 5335,
            2338: 5380, 291: 5483, 2340: 5380, 293: 5482,
            294: 5482, 4145: 5351, 4146: 5351, 2352: 5380,
            305: 5481, 306: 5481, 308: 5481, 4148: 5351,
            6464: 5308, 4417: 5334, 2370: 5379, 323: 5479,
            2372: 5379, 325: 5478, 326: 5478, 2384: 5379,
            337: 5477, 338: 5477, 4512: 5333, 340: 5477,
            4103: 1609, 5126: 5322, 2400: 5379, 353: 5476,
            354: 5476, 356: 5476, 4544: 5333, 368: 5476,
            6528: 5308, 4481: 5333, 4482: 5333, 387: 5474,
            2436: 5378, 389: 5473, 390: 5473, 5185: 5319,
            5186: 5319, 2448: 5378, 401: 5472, 402: 5472,
            2115: 5394, 404: 5472, 5188: 5319, 2117: 5393,
            2464: 5378, 417: 5471, 418: 5471, 420: 5471,
            4166: 5348, 432: 5471, 2496: 5378, 449: 5470,
            450: 5470, 452: 5470, 464: 5470, 4448: 5334,
            480: 5470, 5200: 5319, 2129: 5392, 2130: 5392,
            4180: 5347, 6657: 5307, 6658: 5307, 2563: 5376,
            6660: 5307, 4613: 5330, 2566: 5375, 519: 5467,
            4866: 5325, 6672: 5307, 2577: 5374, 2578: 5374,
            531: 5465, 2580: 5374, 533: 5464, 534: 5464,
            4868: 5325, 6688: 5307, 4641: 5328, 2594: 5373,
            547: 5462, 2596: 5373, 549: 5461, 550: 5461,
            2608: 5373, 561: 5460, 562: 5460, 564: 5460,
            4656: 5328, 6720: 5307, 4673: 5327, 2626: 5372,
            579: 5458, 2628: 5372, 581: 5457, 582: 5457,
            4193: 5346, 2146: 5391, 2640: 5372, 593: 5456,
            594: 5456, 596: 5456, 4196: 5346, 2656: 5372,
            609: 5455, 610: 5455, 612: 5455, 624: 5455,
            6784: 5307, 2689: 5371, 4738: 5326, 643: 5453,
            2692: 5371, 645: 5452, 646: 5452, 2704: 5371,
            657: 5451, 658: 5451, 660: 5451, 2720: 5371,
            673: 5450, 674: 5450, 676: 5450, 4928: 5325,
            688: 5450, 4865: 5325, 5888: 5316, 2752: 5371,
            705: 5449, 706: 5449, 708: 5449, 4320: 5340,
            720: 5449, 736: 5449, 6912: 5307, 2817: 5370,
            2818: 5370, 771: 5447, 2820: 5370, 773: 5446,
            774: 5446, 5249: 5318, 5250: 5318, 2832: 5370,
            785: 5445, 786: 5445, 4227: 5344, 788: 5445,
            5252: 5318, 4118: 5355, 4800: 5326, 2181: 5388,
            2848: 5370, 801: 5444, 802: 5444, 804: 5444,
            2182: 5388, 816: 5444, 2880: 5370, 833: 5443,
            834: 5443, 836: 5443, 848: 5443, 864: 5443,
            5264: 5318, 4241: 5342, 4242: 5342, 4244: 5342,
            2944: 5370, 897: 5442, 898: 5442, 900: 5442,
            912: 5442, 928: 5442, 5760: 5316, 960: 5442,
            5280: 5318, 4257: 5341, 4258: 5341, 4260: 5341,
            5216: 5319, 7169: 5306, 7170: 5306, 5123: 5323,
            7172: 5306, 3077: 5367, 3078: 5367, 5633: 5316,
            3586: 5361, 7184: 5306, 3089: 5366, 3090: 5366,
            1043: 5437, 3092: 5366, 1045: 5436, 1046: 5436,
            5636: 5316, 2565: 5375, 7200: 5306, 5153: 5320,
            5154: 5320, 1059: 5434, 5156: 5320, 1061: 5433,
            1062: 5433, 3120: 5365, 1073: 5432, 1074: 5432,
            1076: 5432, 5696: 5316, 7232: 5306, 3137: 5364,
            3138: 5364, 1091: 5430, 3140: 5364, 1093: 5429,
            1094: 5429, 3152: 5364, 1105: 5428, 1106: 5428,
            1108: 5428, 3168: 5364, 1121: 5427, 1122: 5427,
            1124: 5427, 4625: 5329, 4626: 5329, 1136: 5427,
            4628: 5329, 4880: 5325, 7296: 5306, 3201: 5363,
            3202: 5363, 1155: 5425, 3204: 5363, 1157: 5424,
            1158: 5424, 4289: 5340, 2242: 5385, 3216: 5363,
            1169: 5423, 1170: 5423, 1172: 5423, 4292: 5340,
            3232: 5363, 1185: 5422, 1186: 5422, 1188: 5422,
            1200: 5422, 3264: 5363, 1217: 5421, 1218: 5421,
            1220: 5421, 2593: 5373, 4642: 5328, 1232: 5421,
            4644: 5328, 1248: 5421, 4304: 5340, 4611: 5331,
            7424: 5306, 5377: 5317, 5378: 5317, 1283: 5419,
            3332: 5362, 1285: 5418, 1286: 5418, 3344: 5362,
            1297: 5417, 1298: 5417, 1300: 5417, 3360: 5362,
            1313: 5416, 1314: 5416, 1316: 5416, 4272: 5341,
            1328: 5416, 3392: 5362, 1345: 5415, 1346: 5415,
            1348: 5415, 4614: 5330, 1360: 5415, 1376: 5415,
            2433: 5378, 3456: 5362, 1409: 5414, 1410: 5414,
            1412: 5414, 2625: 5372, 4674: 5327, 1424: 5414,
            4676: 5327, 1440: 5414, 4208: 5346, 5504: 5317,
            1472: 5414, 4688: 5327, 7680: 5306, 3585: 5361,
            5634: 5316, 1539: 5412, 3588: 5361, 1541: 5411,
            1542: 5411, 3329: 5362, 3330: 5362, 3600: 5361,
            1553: 5410, 1554: 5410, 4355: 5338, 1556: 5410,
            5380: 5317, 4357: 5337, 3616: 5361, 1569: 5409,
            1570: 5409, 1572: 5409, 4358: 5337, 1584: 5409,
            3648: 5361, 1601: 5408, 1602: 5408, 1604: 5408,
            5168: 5320, 1616: 5408, 4896: 5325, 1632: 5408,
            5392: 5317, 4369: 5336, 4370: 5336, 2324: 5381,
            3712: 5361, 1665: 5407, 1666: 5407, 1668: 5407,
            1680: 5407, 5648: 5316, 1696: 5407, 1728: 5407,
            5408: 5317, 2337: 5380, 4386: 5335, 4388: 5335,
            3840: 5361, 1793: 5406, 1794: 5406, 1796: 5406,
            4737: 5326, 2690: 5371, 1808: 5406, 4740: 5326,
            1824: 5406, 4400: 5335, 5312: 5318, 1856: 5406,
            6336: 5309, 4752: 5326, 4496: 5333, 1920: 5406,
            5440: 5317, 2369: 5379, 4418: 5334, 4420: 5334,
            4768: 5326, 4704: 5327, 4432: 5334 },
            9: { 384: 3286, 320: 3286, 258: 3286, 4100: 3282,
            6: 3291, 2080: 3283, 4160: 3282, 4224: 3282,
            132: 3287, 288: 3286, 2050: 3283, 4352: 3282,
            144: 3287, 18: 3290, 20: 3290, 4608: 3282,
            768: 3285, 576: 3285, 516: 3285, 640: 3285,
            1028: 3284, 260: 3286, 1040: 3284, 34: 3289,
            36: 3289, 2064: 3283, 1088: 3284, 1152: 3284,
            1280: 3284, 48: 3289, 1536: 3284, 3072: 3283,
            2052: 3283, 192: 3287, 160: 3287, 66: 3288,
            68: 3288, 130: 3287, 4128: 3282, 2112: 3283,
            2176: 3283, 2304: 3283, 4098: 3282, 80: 3288,
            514: 3285, 5120: 3282, 2560: 3283, 544: 3285,
            96: 3288, 272: 3286, 1026: 3284, 6144: 3282,
            4112: 3282, 1056: 3284, 528: 3285 },
            10: { 384: 3275, 129: 3276, 3072: 3272, 132: 3276,
            5: 3280, 260: 3275, 1025: 3273, 4160: 3271,
            4224: 3271, 516: 3274, 144: 3276, 17: 3279,
            20: 3279, 4608: 3271, 768: 3274, 576: 3274,
            2052: 3272, 640: 3274, 1028: 3273, 1040: 3273,
            33: 3278, 4097: 3271, 2064: 3272, 1088: 3273,
            1152: 3273, 257: 3275, 1280: 3273, 48: 3278,
            513: 3274, 1536: 3273, 2080: 3272, 192: 3276,
            65: 3277, 68: 3277, 6144: 3271, 4128: 3271,
            2112: 3272, 2176: 3272, 160: 3276, 2304: 3272,
            288: 3275, 80: 3277, 320: 3275, 5120: 3271,
            2560: 3272, 544: 3274, 36: 3278, 96: 3277,
            272: 3275, 2049: 3272, 4112: 3271, 1056: 3273,
            528: 3274, 4352: 3271, 4100: 3271 },
            3072: { 384: 2602, 4097: 2600, 4098: 2600, 3: 2609,
            132: 2603, 5: 2608, 6: 2608, 129: 2603,
            136: 2603, 9: 2607, 10: 2607, 12: 2607,
            258: 2602, 516: 2601, 144: 2603, 17: 2606,
            18: 2606, 20: 2606, 4608: 2600, 24: 2606,
            260: 2602, 640: 2601, 768: 2601, 520: 2601,
            160: 2603, 33: 2605, 34: 2605, 36: 2605,
            40: 2605, 257: 2602, 4160: 2600, 48: 2605,
            264: 2602, 513: 2601, 4224: 2600, 288: 2602,
            192: 2603, 65: 2604, 66: 2604, 68: 2604,
            130: 2603, 4128: 2600, 72: 2604, 4352: 2600,
            528: 2601, 80: 2604, 320: 2602, 514: 2601,
            544: 2601, 96: 2604, 272: 2602, 4112: 2600,
            4104: 2600, 576: 2601, 4100: 2600 },
            12: { 384: 3264, 129: 3265, 258: 3264, 3: 3269,
            1040: 3262, 1025: 3262, 4160: 3260, 4224: 3260,
            3072: 3261, 288: 3264, 2050: 3261, 4352: 3260,
            144: 3265, 17: 3268, 18: 3268, 4608: 3260,
            576: 3263, 640: 3263, 768: 3263, 160: 3265,
            33: 3267, 34: 3267, 4097: 3260, 2064: 3261,
            1088: 3262, 1152: 3262, 257: 3264, 1280: 3262,
            48: 3267, 513: 3263, 1536: 3262, 2080: 3261,
            192: 3265, 65: 3266, 66: 3266, 5120: 3260,
            130: 3265, 4128: 3260, 2112: 3261, 2176: 3261,
            2304: 3261, 4098: 3260, 80: 3266, 320: 3264,
            514: 3263, 2560: 3261, 544: 3263, 96: 3266,
            272: 3264, 1026: 3262, 2049: 3261, 6144: 3260,
            4112: 3260, 1056: 3262, 528: 3263 },
            2050: { 384: 2702, 129: 2703, 132: 2703, 5: 2708,
            260: 2702, 1025: 2700, 136: 2703, 9: 2707,
            4224: 2699, 12: 2707, 4352: 2699, 144: 2703,
            17: 2706, 20: 2706, 1032: 2700, 768: 2701,
            24: 2706, 516: 2701, 640: 2701, 1028: 2700,
            520: 2701, 1040: 2700, 33: 2705, 4097: 2699,
            5120: 2699, 40: 2705, 1152: 2700, 257: 2702,
            4160: 2699, 1280: 2700, 48: 2705, 264: 2702,
            513: 2701, 1536: 2700, 288: 2702, 192: 2703,
            65: 2704, 68: 2704, 4128: 2699, 72: 2704,
            1088: 2700, 160: 2703, 528: 2701, 80: 2704,
            320: 2702, 544: 2701, 36: 2705, 96: 2704,
            272: 2702, 4112: 2699, 1056: 2700, 4608: 2699,
            4104: 2699, 576: 2701, 4100: 2699 },
            16: { 6147: 5094, 6149: 5093, 6150: 5093, 2055: 5183,
            6153: 5092, 6154: 5092, 2059: 5181, 6156: 5092,
            4109: 5135, 4110: 5135, 15: 1608, 3075: 5148,
            5125: 5102, 6177: 5091, 6178: 5091, 4131: 5133,
            6180: 5091, 2085: 5177, 2086: 5177, 39: 5299,
            6184: 5091, 2089: 5176, 2090: 5176, 43: 5297,
            2092: 5176, 45: 5296, 46: 1607, 4992: 5105,
            5129: 5101, 5130: 5101, 6209: 5090, 6210: 5090,
            4163: 5129, 6212: 5090, 4165: 5128, 2118: 5173,
            71: 5293, 6216: 5090, 2121: 5172, 4170: 5127,
            75: 5291, 4172: 5127, 77: 5290, 78: 5290,
            1037: 5216, 2062: 5180, 6240: 5090, 2145: 5171,
            4194: 5126, 99: 5288, 2148: 5171, 101: 5287,
            102: 5287, 2152: 5171, 105: 5286, 106: 5286,
            108: 1606, 5664: 5096, 6273: 5089, 6274: 5089,
            2179: 5169, 6276: 5089, 4229: 5123, 4230: 5123,
            135: 5283, 6280: 5089, 2185: 5167, 2186: 5167,
            139: 5281, 4236: 5122, 141: 5280, 142: 5280,
            6304: 5089, 2209: 5166, 2210: 5166, 163: 5278,
            4260: 5121, 165: 5277, 166: 5277, 2216: 5166,
            169: 5276, 170: 5276, 172: 5276, 6336: 5089,
            2241: 5165, 4290: 5120, 195: 5274, 2244: 5165,
            197: 5273, 198: 5273, 3105: 5145, 2248: 5165,
            201: 5272, 202: 5272, 204: 5272, 3106: 5145,
            2083: 5178, 5156: 5100, 4133: 5132, 2272: 5165,
            225: 5271, 226: 5271, 228: 5271, 4134: 5132,
            232: 1605, 5160: 5100, 4137: 5131, 1031: 5219,
            4138: 5131, 6401: 5088, 6402: 5088, 4355: 5118,
            6404: 5088, 2309: 5162, 2310: 5162, 263: 5268,
            6408: 5088, 2313: 5161, 2314: 5161, 267: 5266,
            4364: 5116, 269: 5265, 270: 5265, 4484: 5113,
            6432: 5088, 4385: 5115, 2338: 5160, 291: 5263,
            2340: 5160, 293: 5262, 294: 5262, 2344: 5160,
            297: 5261, 298: 5261, 300: 5261, 4488: 5113,
            6464: 5088, 4417: 5114, 2370: 5159, 323: 5259,
            2372: 5159, 325: 5258, 326: 5258, 2376: 5159,
            329: 5257, 330: 5257, 332: 5257, 4512: 5113,
            4103: 5138, 5126: 5102, 2400: 5159, 353: 5256,
            354: 5256, 356: 5256, 360: 5256, 6528: 5088,
            4481: 5113, 4482: 5113, 387: 5254, 2436: 5158,
            389: 5253, 390: 5253, 5185: 5099, 2440: 5158,
            393: 5252, 394: 5252, 396: 5252, 5186: 5099,
            2115: 5174, 5188: 5099, 2117: 5173, 2464: 5158,
            417: 5251, 418: 5251, 420: 5251, 4166: 5128,
            424: 5251, 5192: 5099, 4169: 5127, 2122: 5172,
            2496: 5158, 449: 5250, 450: 5250, 452: 5250,
            456: 5250, 2124: 5172, 2061: 5180, 4107: 5136,
            4448: 5114, 480: 1604, 6657: 5087, 6658: 5087,
            2563: 5156, 6660: 5087, 2565: 5155, 2566: 5155,
            4865: 5105, 6664: 5087, 2569: 5154, 2570: 5154,
            523: 5245, 2572: 5154, 525: 5244, 526: 5244,
            4868: 5105, 6688: 5087, 2593: 5153, 2594: 5153,
            547: 5242, 2596: 5153, 549: 5241, 550: 5241,
            2600: 5153, 553: 5240, 554: 5240, 556: 5240,
            4872: 5105, 6720: 5087, 4673: 5107, 2626: 5152,
            579: 5238, 2628: 5152, 581: 5237, 582: 5237,
            4193: 5126, 2632: 5152, 585: 5236, 586: 5236,
            5132: 5101, 2146: 5171, 4196: 5126, 2656: 5152,
            609: 5235, 610: 5235, 612: 5235, 616: 5235,
            4200: 5126, 6784: 5087, 2689: 5151, 4738: 5106,
            643: 5233, 2692: 5151, 645: 5232, 646: 5232,
            2696: 5151, 649: 5231, 650: 5231, 652: 5231,
            2720: 5151, 673: 5230, 674: 5230, 676: 5230,
            4928: 5105, 680: 5230, 5888: 5096, 2752: 5151,
            705: 5229, 706: 5229, 708: 5229, 712: 5229,
            4320: 5120, 4866: 5105, 736: 5229, 6912: 5087,
            2817: 5150, 2818: 5150, 771: 5227, 2820: 5150,
            773: 5226, 774: 5226, 5249: 5098, 2824: 5150,
            777: 5225, 778: 5225, 780: 5225, 5250: 5098,
            4227: 5124, 5252: 5098, 4800: 5106, 2181: 5168,
            2848: 5150, 801: 5224, 802: 5224, 804: 5224,
            2182: 5168, 808: 5224, 5256: 5098, 4233: 5122,
            4234: 5122, 2880: 5150, 833: 5223, 834: 5223,
            836: 5223, 840: 5223, 2188: 5167, 864: 5223,
            2944: 5150, 897: 5222, 898: 5222, 900: 5222,
            904: 5222, 928: 5222, 5760: 5096, 960: 5222,
            5280: 5098, 4257: 5121, 4258: 5121, 2212: 5166,
            5216: 5099, 4264: 5121, 7169: 5086, 7170: 5086,
            5123: 5103, 7172: 5086, 3077: 5147, 3078: 5147,
            5633: 5096, 7176: 5086, 3081: 5146, 3082: 5146,
            1035: 5217, 3084: 5146, 5634: 5096, 1038: 5216,
            4611: 5111, 5636: 5096, 4613: 5110, 7200: 5086,
            5153: 5100, 5154: 5100, 1059: 5214, 3108: 5145,
            1061: 5213, 1062: 5213, 3112: 5145, 1065: 5212,
            1066: 5212, 519: 5247, 1068: 5212, 5640: 5096,
            4617: 5109, 5696: 5096, 4618: 5109, 7232: 5086,
            3137: 5144, 3138: 5144, 1091: 5210, 3140: 5144,
            1093: 5209, 1094: 5209, 3144: 5144, 1097: 5208,
            1098: 5208, 1100: 5208, 3168: 5144, 1121: 5207,
            1122: 5207, 1124: 5207, 1128: 5207, 7296: 5086,
            3201: 5143, 3202: 5143, 1155: 5205, 3204: 5143,
            1157: 5204, 1158: 5204, 4289: 5120, 3208: 5143,
            1161: 5203, 1162: 5203, 1164: 5203, 2242: 5165,
            4292: 5120, 3232: 5143, 1185: 5202, 1186: 5202,
            1188: 5202, 1192: 5202, 4296: 5120, 3264: 5143,
            1217: 5201, 1218: 5201, 1220: 5201, 4641: 5108,
            1224: 5201, 4642: 5108, 4644: 5108, 1248: 5201,
            4648: 5108, 7424: 5086, 5377: 5097, 5378: 5097,
            1283: 5199, 3332: 5142, 1285: 5198, 1286: 5198,
            3336: 5142, 1289: 5197, 1290: 5197, 1292: 5197,
            4544: 5113, 3360: 5142, 1313: 5196, 1314: 5196,
            1316: 5196, 1320: 5196, 3392: 5142, 1345: 5195,
            1346: 5195, 1348: 5195, 1352: 5195, 4614: 5110,
            1376: 5195, 2433: 5158, 3456: 5142, 1409: 5194,
            1410: 5194, 1412: 5194, 2625: 5152, 1416: 5194,
            4674: 5107, 2434: 5158, 4676: 5107, 1440: 5194,
            4140: 5131, 4680: 5107, 5504: 5097, 1472: 5194,
            588: 5236, 4620: 5109, 7680: 5086, 3585: 5141,
            3586: 5141, 1539: 5192, 3588: 5141, 1541: 5191,
            1542: 5191, 3329: 5142, 3592: 5141, 1545: 5190,
            1546: 5190, 1548: 5190, 3330: 5142, 2307: 5163,
            5380: 5097, 4357: 5117, 3616: 5141, 1569: 5189,
            1570: 5189, 1572: 5189, 4358: 5117, 1576: 5189,
            5384: 5097, 4361: 5116, 4362: 5116, 3648: 5141,
            1601: 5188, 1602: 5188, 1604: 5188, 1608: 5188,
            2316: 5161, 4896: 5105, 1632: 5188, 3712: 5141,
            1665: 5187, 1666: 5187, 1668: 5187, 1672: 5187,
            1696: 5187, 1728: 5187, 5408: 5097, 2337: 5160,
            4386: 5115, 4388: 5115, 4392: 5115, 3840: 5141,
            1793: 5186, 1794: 5186, 1796: 5186, 4737: 5106,
            1800: 5186, 2690: 5151, 4740: 5106, 1824: 5186,
            5312: 5098, 4744: 5106, 1856: 5186, 1920: 5186,
            5440: 5097, 2369: 5159, 4418: 5114, 4420: 5114,
            4424: 5114, 4768: 5106, 4704: 5107 },
            17: { 384: 3253, 320: 3253, 258: 3253, 516: 3252,
            6: 3258, 2080: 3250, 136: 3254, 10: 3257,
            132: 3254, 12: 3257, 2050: 3250, 4352: 3249,
            1536: 3251, 1032: 3251, 768: 3252, 576: 3252,
            2052: 3250, 640: 3252, 520: 3252, 1028: 3251,
            260: 3253, 160: 3254, 34: 3256, 36: 3256,
            5120: 3249, 40: 3256, 1152: 3251, 4160: 3249,
            1280: 3251, 264: 3253, 2056: 3250, 4224: 3249,
            192: 3254, 288: 3253, 66: 3255, 68: 3255,
            130: 3254, 4128: 3249, 72: 3255, 1088: 3251,
            2304: 3250, 4098: 3249, 514: 3252, 2560: 3250,
            544: 3252, 96: 3255, 1026: 3251, 6144: 3249,
            3072: 3250, 1056: 3251, 2112: 3250, 4608: 3249,
            2176: 3250, 4104: 3249, 4100: 3249 },
            18: { 384: 3242, 129: 3243, 132: 3243, 5: 3247,
            260: 3242, 1025: 3240, 136: 3243, 9: 3246,
            4224: 3238, 12: 3246, 516: 3241, 320: 3242,
            1032: 3240, 768: 3241, 576: 3241, 2052: 3239,
            640: 3241, 1028: 3240, 520: 3241, 160: 3243,
            33: 3245, 4097: 3238, 2080: 3239, 40: 3245,
            1152: 3240, 257: 3242, 4160: 3238, 1280: 3240,
            264: 3242, 513: 3241, 2056: 3239, 192: 3243,
            65: 3244, 68: 3244, 6144: 3238, 4128: 3238,
            72: 3244, 1088: 3240, 4352: 3238, 2304: 3239,
            288: 3242, 1536: 3240, 5120: 3238, 2560: 3239,
            544: 3241, 36: 3245, 96: 3244, 2049: 3239,
            3072: 3239, 1056: 3240, 2112: 3239, 4608: 3238,
            2176: 3239, 4104: 3238, 4100: 3238 },
            20: { 384: 3231, 129: 3232, 2050: 3228, 3: 3236,
            520: 3230, 1025: 3229, 136: 3232, 9: 3235,
            10: 3235, 288: 3231, 1026: 3229, 4352: 3227,
            320: 3231, 1032: 3229, 576: 3230, 640: 3230,
            768: 3230, 160: 3232, 33: 3234, 34: 3234,
            4097: 3227, 2080: 3228, 40: 3234, 1152: 3229,
            257: 3231, 4160: 3227, 1280: 3229, 264: 3231,
            513: 3230, 2056: 3228, 4224: 3227, 192: 3232,
            65: 3233, 66: 3233, 5120: 3227, 130: 3232,
            4128: 3227, 72: 3233, 258: 3231, 2304: 3228,
            4098: 3227, 1536: 3229, 514: 3230, 2560: 3228,
            544: 3230, 4608: 3227, 96: 3233, 2049: 3228,
            6144: 3227, 3072: 3228, 1056: 3229, 2112: 3228,
            1088: 3229, 2176: 3228, 4104: 3227 },
            512: { 6147: 3994, 6149: 3993, 6150: 3993, 2055: 4083,
            6153: 3992, 6154: 3992, 2059: 4081, 6156: 3992,
            4109: 4035, 4110: 4035, 15: 4202, 6161: 3991,
            6162: 3991, 2067: 4078, 6164: 3991, 2069: 4077,
            2070: 4077, 23: 4199, 6168: 3991, 2073: 4076,
            2074: 4076, 27: 4197, 4124: 4031, 29: 4196,
            30: 4196, 3077: 4047, 6177: 3990, 6178: 3990,
            4131: 4029, 6180: 3990, 2085: 4073, 2086: 4073,
            39: 4193, 6184: 3990, 2089: 4072, 2090: 4072,
            43: 4191, 2092: 4072, 45: 4190, 46: 4190,
            6192: 3990, 2097: 4071, 2098: 4071, 51: 4188,
            2100: 4071, 53: 4187, 54: 4187, 5129: 4001,
            2104: 4071, 57: 4186, 58: 4186, 60: 4186,
            5130: 4001, 6209: 3989, 6210: 3989, 4163: 4024,
            6212: 3989, 4165: 4023, 2118: 4068, 71: 4183,
            6216: 3989, 4169: 4022, 4170: 4022, 75: 4181,
            4172: 4022, 77: 4180, 78: 4180, 2061: 4080,
            6224: 3989, 4177: 4021, 4178: 4021, 83: 4178,
            4180: 4021, 85: 4177, 86: 4177, 2136: 4066,
            89: 4176, 90: 4176, 92: 4176, 344: 4130,
            2145: 4065, 4194: 4020, 99: 4174, 2148: 4065,
            101: 4173, 102: 4173, 5137: 4000, 2152: 4065,
            105: 4172, 106: 4172, 108: 4172, 5138: 4000,
            2160: 4065, 113: 4171, 114: 4171, 4115: 4033,
            116: 4171, 120: 4171, 5140: 4000, 4117: 4032,
            6273: 3988, 6274: 3988, 2179: 4063, 6276: 3988,
            4229: 4017, 4230: 4017, 135: 4168, 6280: 3988,
            4233: 4016, 4234: 4016, 139: 4166, 4236: 4016,
            141: 4165, 142: 4165, 6288: 3988, 2193: 4060,
            2194: 4060, 147: 4163, 2196: 4060, 149: 4162,
            150: 4162, 4121: 4031, 2200: 4060, 153: 4161,
            154: 4161, 156: 4161, 4122: 4031, 6304: 3988,
            4257: 4014, 2210: 4059, 163: 4159, 2212: 4059,
            165: 4158, 166: 4158, 2216: 4059, 169: 4157,
            170: 4157, 172: 4157, 2224: 4059, 177: 4156,
            178: 4156, 180: 4156, 184: 4156, 3075: 4048,
            2241: 4058, 2242: 4058, 195: 4154, 2244: 4058,
            197: 4153, 198: 4153, 5153: 3999, 2248: 4058,
            201: 4152, 202: 4152, 204: 4152, 5154: 3999,
            2256: 4058, 209: 4151, 210: 4151, 2083: 4074,
            212: 4151, 216: 4151, 5156: 3999, 4133: 4028,
            2272: 4058, 225: 4150, 226: 4150, 228: 4150,
            4134: 4028, 232: 4150, 240: 4150, 5160: 3999,
            4137: 4027, 4138: 4027, 6401: 3987, 6402: 3987,
            2307: 4056, 6404: 3987, 2309: 4055, 2310: 4055,
            263: 4147, 6408: 3987, 2313: 4054, 2314: 4054,
            267: 4145, 2316: 4054, 269: 4144, 270: 4144,
            6416: 3987, 2321: 4053, 2322: 4053, 275: 4142,
            2324: 4053, 277: 4141, 278: 4141, 2328: 4053,
            281: 4140, 282: 4140, 284: 4140, 6432: 3987,
            4385: 4007, 2338: 4052, 291: 4138, 2340: 4052,
            293: 4137, 294: 4137, 4145: 4026, 2344: 4052,
            297: 4136, 298: 4136, 300: 4136, 4146: 4026,
            2352: 4052, 305: 4135, 306: 4135, 308: 4135,
            312: 4135, 4148: 4026, 6464: 3987, 4417: 4006,
            2370: 4051, 323: 4133, 2372: 4051, 325: 4132,
            326: 4132, 2376: 4051, 329: 4131, 330: 4131,
            332: 4131, 2384: 4051, 337: 4130, 338: 4130,
            4512: 4005, 340: 4130, 4103: 4038, 5126: 4002,
            2400: 4051, 353: 4129, 354: 4129, 356: 4129,
            360: 4129, 368: 4129, 6528: 3987, 2433: 4050,
            2434: 4050, 387: 4127, 2436: 4050, 389: 4126,
            390: 4126, 5185: 3998, 2440: 4050, 393: 4125,
            394: 4125, 396: 4125, 5186: 3998, 2448: 4050,
            401: 4124, 402: 4124, 2115: 4069, 404: 4124,
            408: 4124, 5188: 3998, 2117: 4068, 2464: 4050,
            417: 4123, 418: 4123, 420: 4123, 4166: 4023,
            424: 4123, 432: 4123, 5192: 3998, 2121: 4067,
            2122: 4067, 2496: 4050, 449: 4122, 450: 4122,
            452: 4122, 456: 4122, 2124: 4067, 4107: 4036,
            4448: 4006, 480: 1603, 5200: 3998, 2129: 4066,
            2062: 4080, 2130: 4066, 2132: 4066, 5132: 4001,
            4184: 4021, 5216: 3998, 4193: 4020, 2146: 4065,
            4196: 4020, 4200: 4020, 4544: 4005, 4208: 4020,
            4320: 4013, 464: 4122, 5249: 3997, 5250: 3997,
            4227: 4018, 5252: 3997, 4118: 4032, 2181: 4062,
            2182: 4062, 5256: 3997, 2185: 4061, 2186: 4061,
            2188: 4061, 5264: 3997, 4241: 4015, 4242: 4015,
            5144: 4000, 4244: 4015, 2076: 4076, 4248: 4015,
            5280: 3997, 2209: 4059, 4258: 4014, 4260: 4014,
            4264: 4014, 7169: 3986, 7170: 3986, 5123: 4003,
            7172: 3986, 5125: 4002, 3078: 4047, 1031: 4119,
            7176: 3986, 3081: 4046, 3082: 4046, 1035: 4117,
            3084: 4046, 1037: 4116, 1038: 4116, 7184: 3986,
            3089: 4045, 3090: 4045, 1043: 4114, 3092: 4045,
            1045: 4113, 1046: 4113, 3096: 4045, 1049: 4112,
            1050: 4112, 1052: 4112, 7200: 3986, 3105: 4044,
            3106: 4044, 1059: 4110, 3108: 4044, 1061: 4109,
            1062: 4109, 3112: 4044, 1065: 4108, 1066: 4108,
            1068: 4108, 3120: 4044, 1073: 4107, 1074: 4107,
            1076: 4107, 1080: 4107, 7232: 3986, 3137: 4043,
            3138: 4043, 1091: 4105, 3140: 4043, 1093: 4104,
            1094: 4104, 3144: 4043, 1097: 4103, 1098: 4103,
            1100: 4103, 3152: 4043, 1105: 4102, 1106: 4102,
            1108: 4102, 1112: 4102, 3168: 4043, 1121: 4101,
            1122: 4101, 1124: 4101, 1128: 4101, 1136: 4101,
            7296: 3986, 3201: 4042, 3202: 4042, 1155: 4099,
            3204: 4042, 1157: 4098, 1158: 4098, 4289: 4013,
            3208: 4042, 1161: 4097, 1162: 4097, 1164: 4097,
            4290: 4013, 3216: 4042, 1169: 4096, 1170: 4096,
            1172: 4096, 1176: 4096, 4292: 4013, 3232: 4042,
            1185: 4095, 1186: 4095, 1188: 4095, 1192: 4095,
            1200: 4095, 4296: 4013, 3264: 4042, 1217: 4094,
            1218: 4094, 1220: 4094, 1224: 4094, 1232: 4094,
            1248: 4094, 4304: 4013, 7424: 1600, 5377: 3996,
            5378: 3996, 1283: 4092, 3332: 4041, 1285: 4091,
            1286: 4091, 3336: 4041, 1289: 4090, 1290: 4090,
            1292: 4090, 3344: 4041, 1297: 4089, 1298: 4089,
            1300: 4089, 1304: 4089, 3360: 4041, 1313: 4088,
            1314: 4088, 1316: 4088, 1320: 4088, 4272: 4014,
            1328: 4088, 3392: 4041, 1345: 4087, 1346: 4087,
            1348: 4087, 1352: 4087, 1360: 4087, 1376: 4087,
            3456: 1601, 1409: 4086, 1410: 4086, 6240: 3989,
            1412: 4086, 1416: 4086, 1424: 4086, 1440: 4086,
            4140: 4027, 4481: 4005, 5504: 3996, 1472: 1602,
            4482: 4005, 3329: 4041, 4484: 4005, 3330: 4041,
            4355: 4011, 5380: 3996, 4357: 4010, 4358: 4010,
            5384: 3996, 4361: 4009, 4362: 4009, 5168: 3999,
            4364: 4009, 5392: 3996, 4369: 4008, 4370: 4008,
            4372: 4008, 4488: 4005, 4376: 4008, 5408: 3996,
            2337: 4052, 4386: 4007, 4388: 4007, 4392: 4007,
            4152: 4026, 4400: 4007, 5312: 3997, 6336: 3988,
            4496: 4005, 5440: 3996, 2369: 4051, 4418: 4006,
            4420: 4006, 4424: 4006, 4432: 4006 },
            24: { 384: 3220, 129: 3221, 258: 3220, 3: 3225,
            132: 3221, 5: 3224, 6: 3224, 1025: 3218,
            4160: 3216, 4224: 3216, 288: 3220, 2050: 3217,
            516: 3219, 320: 3220, 4608: 3216, 768: 3219,
            576: 3219, 260: 3220, 640: 3219, 1028: 3218,
            160: 3221, 33: 3223, 34: 3223, 4097: 3216,
            2080: 3217, 1088: 3218, 1152: 3218, 257: 3220,
            1280: 3218, 513: 3219, 1536: 3218, 2052: 3217,
            192: 3221, 65: 3222, 66: 3222, 68: 3222,
            130: 3221, 4128: 3216, 2112: 3217, 2176: 3217,
            4352: 3216, 2304: 3217, 4098: 3216, 514: 3219,
            5120: 3216, 2560: 3217, 544: 3219, 36: 3223,
            96: 3222, 1026: 3218, 2049: 3217, 6144: 3216,
            3072: 3217, 1056: 3218, 4100: 3216 },
            1028: { 384: 2801, 129: 2802, 2050: 2799, 3: 2807,
            520: 2800, 2049: 2799, 136: 2802, 9: 2806,
            10: 2806, 288: 2801, 4098: 2798, 4352: 2798,
            144: 2802, 17: 2805, 18: 2805, 4608: 2798,
            24: 2805, 640: 2800, 768: 2800, 160: 2802,
            33: 2804, 34: 2804, 4097: 2798, 2064: 2799,
            40: 2804, 257: 2801, 4160: 2798, 48: 2804,
            264: 2801, 513: 2800, 2056: 2799, 4224: 2798,
            2080: 2799, 192: 2802, 65: 2803, 66: 2803,
            130: 2802, 4128: 2798, 72: 2803, 258: 2801,
            2304: 2799, 528: 2800, 80: 2803, 320: 2801,
            514: 2800, 2560: 2799, 544: 2800, 96: 2803,
            272: 2801, 6144: 2798, 4112: 2798, 2112: 2799,
            2176: 2799, 4104: 2798, 576: 2800 },
            768: { 1152: 2833, 1025: 2833, 2050: 2832, 3: 2840,
            132: 2834, 5: 2839, 6: 2839, 129: 2834,
            136: 2834, 9: 2838, 10: 2838, 3072: 2832,
            12: 2838, 1026: 2833, 144: 2834, 17: 2837,
            18: 2837, 20: 2837, 24: 2837, 1028: 2833,
            160: 2834, 33: 2836, 34: 2836, 4097: 2831,
            2064: 2832, 40: 2836, 4160: 2831, 48: 2836,
            1032: 2833, 2056: 2832, 4224: 2831, 2052: 2832,
            2080: 2832, 192: 2834, 65: 2835, 66: 2835,
            68: 2835, 130: 2834, 4128: 2831, 72: 2835,
            1088: 2833, 4098: 2831, 80: 2835, 5120: 2831,
            36: 2836, 96: 2835, 1040: 2833, 2049: 2832,
            6144: 2831, 4112: 2831, 1056: 2833, 2112: 2832,
            2176: 2832, 4104: 2831, 4100: 2831 },
            32: { 6147: 4874, 6149: 4873, 6150: 4873, 2055: 4963,
            6153: 4872, 6154: 4872, 2059: 4961, 6156: 4872,
            4109: 4915, 4110: 4915, 15: 5082, 6161: 4871,
            6162: 4871, 2067: 4958, 6164: 4871, 2069: 4957,
            2070: 4957, 23: 5079, 6168: 4871, 2073: 4956,
            2074: 4956, 27: 5077, 4124: 4911, 29: 5076,
            30: 1607, 5125: 4882, 5126: 4882, 1031: 4999,
            5129: 4881, 3082: 4926, 6209: 4870, 6210: 4870,
            4163: 4909, 6212: 4870, 4165: 4908, 2118: 4953,
            71: 5073, 6216: 4870, 2121: 4952, 2122: 4952,
            75: 5071, 2124: 4952, 77: 5070, 78: 5070,
            1037: 4996, 6224: 4870, 4177: 4906, 4178: 4906,
            83: 5068, 2132: 4951, 85: 5067, 86: 5067,
            2136: 4951, 89: 5066, 90: 5066, 92: 1606,
            344: 5036, 5137: 4880, 5138: 4880, 4115: 4913,
            5140: 4880, 4117: 4912, 6273: 4869, 6274: 4869,
            2179: 4949, 6276: 4869, 4229: 4903, 4230: 4903,
            135: 5063, 6280: 4869, 2185: 4947, 4234: 4902,
            139: 5061, 4236: 4902, 141: 5060, 142: 5060,
            6288: 4869, 2193: 4946, 2194: 4946, 147: 5058,
            2196: 4946, 149: 5057, 150: 5057, 4121: 4911,
            2200: 4946, 153: 5056, 154: 5056, 156: 5056,
            4122: 4911, 2076: 4956, 3075: 4928, 2241: 4945,
            4290: 4900, 195: 5054, 2244: 4945, 197: 5053,
            198: 5053, 2248: 4945, 201: 5052, 202: 5052,
            204: 5052, 2256: 4945, 209: 5051, 210: 5051,
            212: 5051, 216: 1605, 6401: 4868, 6402: 4868,
            2307: 4943, 6404: 4868, 2309: 4942, 2310: 4942,
            263: 5048, 6408: 4868, 2313: 4941, 2314: 4941,
            267: 5046, 2316: 4941, 269: 5045, 270: 5045,
            6416: 4868, 2321: 4940, 2322: 4940, 275: 5043,
            4372: 4895, 277: 5042, 278: 5042, 2328: 4940,
            281: 5041, 282: 5041, 284: 5041, 4488: 4893,
            6464: 4868, 4417: 4894, 2370: 4939, 323: 5039,
            2372: 4939, 325: 5038, 326: 5038, 2376: 4939,
            329: 5037, 330: 5037, 332: 5037, 2384: 4939,
            337: 5036, 338: 5036, 340: 5036, 4103: 4918,
            4496: 4893, 4544: 4893, 6528: 4868, 4481: 4893,
            2434: 4938, 387: 5034, 2436: 4938, 389: 5033,
            390: 5033, 5185: 4879, 2440: 4938, 393: 5032,
            394: 5032, 396: 5032, 5186: 4879, 2448: 4938,
            401: 5031, 402: 5031, 2115: 4954, 404: 5031,
            408: 5031, 5188: 4879, 2117: 4953, 4992: 4885,
            4166: 4908, 5192: 4879, 4169: 4907, 4170: 4907,
            2496: 4938, 449: 5030, 450: 5030, 452: 5030,
            456: 5030, 4172: 4907, 2061: 4960, 4107: 4916,
            5200: 4879, 2129: 4951, 2062: 4960, 2130: 4951,
            4180: 4906, 6657: 4867, 6658: 4867, 2563: 4936,
            6660: 4867, 2565: 4935, 2566: 4935, 519: 5027,
            6664: 4867, 2569: 4934, 2570: 4934, 523: 5025,
            2572: 4934, 525: 5024, 526: 5024, 6672: 4867,
            2577: 4933, 2578: 4933, 531: 5022, 2580: 4933,
            533: 5021, 534: 5021, 2584: 4933, 537: 5020,
            538: 5020, 540: 5020, 4928: 4885, 4872: 4885,
            6720: 4867, 4673: 4887, 2626: 4932, 579: 5018,
            2628: 4932, 581: 5017, 582: 5017, 2632: 4932,
            585: 5016, 586: 5016, 588: 5016, 2640: 4932,
            593: 5015, 594: 5015, 596: 5015, 600: 5015,
            4880: 4885, 6784: 4867, 2689: 4931, 4738: 4886,
            643: 5013, 2692: 4931, 645: 5012, 646: 5012,
            2696: 4931, 649: 5011, 650: 5011, 652: 5011,
            2704: 4931, 657: 5010, 658: 5010, 660: 5010,
            664: 5010, 2818: 4930, 4865: 4885, 5888: 4876,
            2752: 4931, 705: 5009, 706: 5009, 708: 5009,
            712: 5009, 720: 5009, 4184: 4906, 464: 1604,
            6912: 4867, 2817: 4930, 4866: 4885, 771: 5007,
            2820: 4930, 773: 5006, 774: 5006, 5249: 4878,
            2824: 4930, 777: 5005, 778: 5005, 780: 5005,
            5250: 4878, 2832: 4930, 785: 5004, 786: 5004,
            4227: 4904, 788: 5004, 4868: 4885, 792: 5004,
            5252: 4878, 4118: 4912, 4800: 4886, 2181: 4948,
            2182: 4948, 5256: 4878, 4233: 4902, 2186: 4947,
            2880: 4930, 833: 5003, 834: 5003, 836: 5003,
            840: 5003, 2188: 4947, 848: 5003, 5264: 4878,
            4241: 4901, 4242: 4901, 5144: 4880, 4244: 4901,
            5132: 4881, 2944: 4930, 897: 5002, 898: 5002,
            900: 5002, 904: 5002, 912: 5002, 4248: 4901,
            5760: 4876, 960: 1603, 7169: 4866, 7170: 4866,
            5123: 4883, 7172: 4866, 3077: 4927, 3078: 4927,
            5633: 4876, 7176: 4866, 3081: 4926, 5130: 4881,
            1035: 4997, 3084: 4926, 3586: 4921, 1038: 4996,
            7184: 4866, 3089: 4925, 3090: 4925, 1043: 4994,
            3092: 4925, 1045: 4993, 1046: 4993, 3096: 4925,
            1049: 4992, 1050: 4992, 1052: 4992, 4613: 4890,
            4614: 4890, 5640: 4876, 4617: 4889, 5696: 4876,
            4618: 4889, 7232: 4866, 3137: 4924, 3138: 4924,
            1091: 4990, 3140: 4924, 1093: 4989, 1094: 4989,
            3144: 4924, 1097: 4988, 1098: 4988, 1100: 4988,
            3152: 4924, 1105: 4987, 1106: 4987, 1108: 4987,
            1112: 4987, 5648: 4876, 4625: 4888, 4626: 4888,
            4628: 4888, 7296: 4866, 3201: 4923, 3202: 4923,
            1155: 4985, 3204: 4923, 1157: 4984, 1158: 4984,
            4289: 4900, 3208: 4923, 1161: 4983, 1162: 4983,
            1164: 4983, 2242: 4945, 3216: 4923, 1169: 4982,
            1170: 4982, 1172: 4982, 1176: 4982, 4292: 4900,
            4296: 4900, 3264: 4923, 1217: 4981, 1218: 4981,
            1220: 4981, 1224: 4981, 1232: 4981, 4304: 4900,
            4611: 4891, 7424: 4866, 5377: 4877, 5378: 4877,
            1283: 4979, 3332: 4922, 1285: 4978, 1286: 4978,
            3336: 4922, 1289: 4977, 1290: 4977, 1292: 4977,
            3344: 4922, 1297: 4976, 1298: 4976, 1300: 4976,
            1304: 4976, 5636: 4876, 3392: 4922, 1345: 4975,
            1346: 4975, 1348: 4975, 1352: 4975, 1360: 4975,
            2433: 4938, 3456: 4922, 1409: 4974, 1410: 4974,
            1412: 4974, 2625: 4932, 1416: 4974, 4674: 4887,
            1424: 4974, 4676: 4887, 4680: 4887, 5504: 4877,
            1472: 4974, 4482: 4893, 4688: 4887, 4620: 4889,
            7680: 4866, 3585: 4921, 5634: 4876, 1539: 4972,
            3588: 4921, 1541: 4971, 1542: 4971, 3329: 4922,
            3592: 4921, 1545: 4970, 1546: 4970, 1548: 4970,
            3330: 4922, 3600: 4921, 1553: 4969, 1554: 4969,
            4355: 4898, 1556: 4969, 1560: 4969, 5380: 4877,
            4357: 4897, 4358: 4897, 5384: 4877, 4361: 4896,
            4362: 4896, 3648: 4921, 1601: 4968, 1602: 4968,
            1604: 4968, 1608: 4968, 4364: 4896, 1616: 4968,
            5392: 4877, 4369: 4895, 4370: 4895, 2324: 4940,
            3712: 4921, 1665: 4967, 1666: 4967, 1668: 4967,
            1672: 4967, 1680: 4967, 4376: 4895, 1728: 4967,
            3840: 4921, 1793: 4966, 1794: 4966, 1796: 4966,
            4737: 4886, 1800: 4966, 2690: 4931, 1808: 4966,
            4484: 4893, 4740: 4886, 5312: 4878, 4744: 4886,
            1856: 4966, 6336: 4869, 4752: 4886, 4632: 4888,
            1920: 4966, 5440: 4877, 2369: 4939, 4418: 4894,
            4420: 4894, 4424: 4894, 4432: 4894 },
            33: { 384: 3209, 320: 3209, 258: 3209, 4100: 3205,
            6: 3214, 136: 3210, 10: 3213, 132: 3210,
            12: 3213, 2050: 3206, 4352: 3205, 144: 3210,
            18: 3212, 20: 3212, 1032: 3207, 768: 3208,
            24: 3212, 516: 3208, 640: 3208, 520: 3208,
            1028: 3207, 260: 3209, 1040: 3207, 2064: 3206,
            1088: 3207, 1152: 3207, 4160: 3205, 1280: 3207,
            264: 3209, 2056: 3206, 4224: 3205, 3072: 3206,
            528: 3208, 2052: 3206, 192: 3210, 66: 3211,
            68: 3211, 130: 3210, 72: 3211, 2176: 3206,
            2304: 3206, 4098: 3205, 80: 3211, 1536: 3207,
            514: 3208, 5120: 3205, 2560: 3206, 272: 3209,
            1026: 3207, 6144: 3205, 4112: 3205, 2112: 3206,
            4608: 3205, 4104: 3205, 576: 3208 },
            34: { 384: 3198, 129: 3199, 3072: 3195, 132: 3199,
            5: 3203, 260: 3198, 1025: 3196, 136: 3199,
            9: 3202, 4224: 3194, 12: 3202, 4352: 3194,
            144: 3199, 17: 3201, 20: 3201, 1032: 3196,
            768: 3197, 24: 3201, 516: 3197, 640: 3197,
            1028: 3196, 520: 3197, 1040: 3196, 4097: 3194,
            2064: 3195, 1088: 3196, 1152: 3196, 257: 3198,
            4160: 3194, 1280: 3196, 264: 3198, 513: 3197,
            2056: 3195, 2052: 3195, 192: 3199, 65: 3200,
            68: 3200, 6144: 3194, 72: 3200, 2176: 3195,
            2304: 3195, 528: 3197, 80: 3200, 320: 3198,
            5120: 3194, 2560: 3195, 272: 3198, 2049: 3195,
            4112: 3194, 2112: 3195, 1536: 3196, 4608: 3194,
            4104: 3194, 576: 3197, 4100: 3194 },
            36: { 384: 3187, 129: 3188, 2050: 3184, 3: 3192,
            520: 3186, 1025: 3185, 136: 3188, 9: 3191,
            10: 3191, 3072: 3184, 528: 3186, 1026: 3185,
            4352: 3183, 144: 3188, 17: 3190, 18: 3190,
            1032: 3185, 24: 3190, 640: 3186, 768: 3186,
            1040: 3185, 4097: 3183, 2064: 3184, 1088: 3185,
            1152: 3185, 257: 3187, 4160: 3183, 1280: 3185,
            264: 3187, 513: 3186, 2056: 3184, 4224: 3183,
            192: 3188, 65: 3189, 66: 3189, 5120: 3183,
            130: 3188, 72: 3189, 258: 3187, 2304: 3184,
            4098: 3183, 80: 3189, 320: 3187, 514: 3186,
            2560: 3184, 272: 3187, 2049: 3184, 6144: 3183,
            4112: 3183, 2112: 3184, 1536: 3185, 4608: 3183,
            2176: 3184, 4104: 3183, 576: 3186 },
            1024: { 6147: 3774, 6149: 3773, 6150: 3773, 2055: 3863,
            6153: 3772, 6154: 3772, 4107: 3816, 6156: 3772,
            4109: 3815, 4110: 3815, 15: 3982, 6161: 3771,
            6162: 3771, 2067: 3858, 6164: 3771, 2069: 3857,
            2070: 3857, 23: 3979, 6168: 3771, 2073: 3856,
            2074: 3856, 27: 3977, 4124: 3811, 29: 3976,
            30: 3976, 6177: 3770, 6178: 3770, 4131: 3809,
            6180: 3770, 4133: 3808, 2086: 3853, 39: 3973,
            6184: 3770, 2089: 3852, 2090: 3852, 43: 3971,
            2092: 3852, 45: 3970, 46: 3970, 6192: 3770,
            2097: 3851, 2098: 3851, 51: 3968, 4148: 3806,
            53: 3967, 54: 3967, 2104: 3851, 57: 3966,
            58: 3966, 60: 3966, 6209: 3769, 6210: 3769,
            4163: 3804, 6212: 3769, 4165: 3803, 2118: 3848,
            71: 3963, 6216: 3769, 2121: 3847, 2122: 3847,
            75: 3961, 4172: 3802, 77: 3960, 78: 3960,
            2061: 3860, 6224: 3769, 4177: 3801, 4178: 3801,
            83: 3958, 2132: 3846, 85: 3957, 86: 3957,
            2136: 3846, 89: 3956, 90: 3956, 92: 3956,
            344: 3910, 2145: 3845, 2146: 3845, 99: 3954,
            2148: 3845, 101: 3953, 102: 3953, 2152: 3845,
            105: 3952, 106: 3952, 108: 3952, 2160: 3845,
            113: 3951, 114: 3951, 4115: 3813, 116: 3951,
            120: 3951, 4117: 3812, 6273: 3768, 6274: 3768,
            2179: 3843, 6276: 3768, 4229: 3797, 4230: 3797,
            135: 3948, 6280: 3768, 4233: 3796, 4234: 3796,
            139: 3946, 4236: 3796, 141: 3945, 142: 3945,
            6288: 3768, 2193: 3840, 2194: 3840, 147: 3943,
            2196: 3840, 149: 3942, 150: 3942, 4121: 3811,
            2200: 3840, 153: 3941, 154: 3941, 156: 3941,
            4122: 3811, 6304: 3768, 4257: 3794, 2210: 3839,
            163: 3939, 2212: 3839, 165: 3938, 166: 3938,
            2216: 3839, 169: 3937, 170: 3937, 172: 3937,
            2224: 3839, 177: 3936, 178: 3936, 180: 3936,
            184: 3936, 6336: 3768, 2241: 3838, 2242: 3838,
            195: 3934, 2244: 3838, 197: 3933, 198: 3933,
            2248: 3838, 201: 3932, 202: 3932, 204: 3932,
            2256: 3838, 209: 3931, 210: 3931, 2083: 3854,
            212: 3931, 216: 3931, 2085: 3853, 2272: 3838,
            225: 3930, 226: 3930, 228: 3930, 4134: 3808,
            232: 3930, 240: 3930, 4137: 3807, 4138: 3807,
            6401: 3767, 6402: 3767, 2307: 3836, 6404: 3767,
            2309: 3835, 2310: 3835, 263: 3927, 6408: 3767,
            2313: 3834, 2314: 3834, 267: 3925, 2316: 3834,
            269: 3924, 270: 3924, 6416: 3767, 2321: 3833,
            2322: 3833, 275: 3922, 2324: 3833, 277: 3921,
            278: 3921, 2328: 3833, 281: 3920, 282: 3920,
            284: 3920, 6432: 3767, 4385: 3787, 2338: 3832,
            291: 3918, 2340: 3832, 293: 3917, 294: 3917,
            4145: 3806, 2344: 3832, 297: 3916, 298: 3916,
            300: 3916, 4146: 3806, 2352: 3832, 305: 3915,
            306: 3915, 308: 3915, 312: 3915, 2100: 3851,
            6464: 3767, 4417: 3786, 2370: 3831, 323: 3913,
            2372: 3831, 325: 3912, 326: 3912, 2376: 3831,
            329: 3911, 330: 3911, 332: 3911, 2384: 3831,
            337: 3910, 338: 3910, 4512: 3785, 340: 3910,
            4103: 3818, 2400: 3831, 353: 3909, 354: 3909,
            356: 3909, 360: 3909, 368: 3909, 6528: 3767,
            4481: 3785, 2434: 3830, 387: 3907, 2436: 3830,
            389: 3906, 390: 3906, 2440: 3830, 393: 3905,
            394: 3905, 396: 3905, 2059: 3861, 401: 3904,
            402: 3904, 2115: 3849, 404: 3904, 408: 3904,
            2117: 3848, 2464: 3830, 417: 3903, 418: 3903,
            420: 3903, 4166: 3803, 424: 3903, 432: 3903,
            4169: 3802, 4170: 3802, 2496: 3830, 449: 3902,
            450: 3902, 452: 3902, 456: 3902, 2124: 3847,
            4872: 3776, 464: 3902, 4448: 3786, 480: 3902,
            2129: 3846, 2062: 3860, 2130: 3846, 4180: 3801,
            6657: 3766, 6658: 3766, 2563: 3828, 6660: 3766,
            4613: 3782, 2566: 3827, 519: 3899, 6664: 3766,
            2569: 3826, 2570: 3826, 523: 3897, 2572: 3826,
            525: 3896, 526: 3896, 6672: 3766, 2577: 3825,
            2578: 3825, 531: 3894, 2580: 3825, 533: 3893,
            534: 3893, 2584: 3825, 537: 3892, 538: 3892,
            540: 3892, 6688: 3766, 2593: 3824, 2594: 3824,
            547: 3890, 2596: 3824, 549: 3889, 550: 3889,
            2600: 3824, 553: 3888, 554: 3888, 556: 3888,
            2608: 3824, 561: 3887, 562: 3887, 564: 3887,
            568: 3887, 6720: 3766, 4673: 3778, 2626: 3823,
            579: 3885, 2628: 3823, 581: 3884, 582: 3884,
            4193: 3800, 2632: 3823, 585: 3883, 586: 3883,
            588: 3883, 4194: 3800, 2640: 3823, 593: 3882,
            594: 3882, 596: 3882, 600: 3882, 4196: 3800,
            2656: 3823, 609: 3881, 610: 3881, 612: 3881,
            616: 3881, 624: 3881, 4200: 3800, 2817: 3821,
            6784: 3766, 2689: 3822, 4738: 3777, 643: 3879,
            2692: 3822, 645: 3878, 646: 3878, 2696: 3822,
            649: 3877, 650: 3877, 652: 3877, 2704: 3822,
            657: 3876, 658: 3876, 660: 3876, 664: 3876,
            2818: 3821, 2720: 3822, 673: 3875, 674: 3875,
            676: 3875, 4928: 3776, 680: 3875, 688: 3875,
            2752: 3822, 705: 3874, 706: 3874, 708: 3874,
            712: 3874, 720: 3874, 4184: 3801, 736: 3874,
            6912: 1600, 4865: 3776, 4866: 3776, 771: 3872,
            2820: 3821, 773: 3871, 774: 3871, 2824: 3821,
            777: 3870, 778: 3870, 780: 3870, 2832: 3821,
            785: 3869, 786: 3869, 4227: 3798, 788: 3869,
            4868: 3776, 792: 3869, 4118: 3812, 4800: 3777,
            2181: 3842, 2848: 3821, 801: 3868, 802: 3868,
            804: 3868, 2182: 3842, 808: 3868, 816: 3868,
            2185: 3841, 2186: 3841, 2880: 3821, 833: 3867,
            834: 3867, 836: 3867, 840: 3867, 2188: 3841,
            848: 3867, 864: 3867, 4241: 3795, 4242: 3795,
            4244: 3795, 2944: 1601, 897: 3866, 898: 3866,
            900: 3866, 904: 3866, 2076: 3856, 912: 3866,
            4248: 3795, 928: 3866, 960: 1602, 2209: 3839,
            4258: 3794, 4260: 3794, 4264: 3794, 6240: 3769,
            4611: 3783, 2565: 3827, 4272: 3794, 4614: 3782,
            4617: 3781, 4618: 3781, 4620: 3781, 4625: 3780,
            4626: 3780, 4628: 3780, 4880: 3776, 4289: 3793,
            4290: 3793, 4632: 3780, 4292: 3793, 4296: 3793,
            4641: 3779, 4642: 3779, 4644: 3779, 4304: 3793,
            4648: 3779, 4992: 3776, 4544: 3785, 4656: 3779,
            4320: 3793, 2433: 3830, 2625: 3823, 4674: 3778,
            4676: 3778, 4208: 3800, 4140: 3807, 4680: 3778,
            4482: 3785, 4688: 3778, 4484: 3785, 4355: 3791,
            4357: 3790, 4358: 3790, 4361: 3789, 4362: 3789,
            4704: 3778, 4364: 3789, 4896: 3776, 4369: 3788,
            4370: 3788, 4372: 3788, 4488: 3785, 4376: 3788,
            2337: 3832, 4386: 3787, 4388: 3787, 4392: 3787,
            4737: 3777, 2690: 3822, 4152: 3806, 4740: 3777,
            4400: 3787, 4744: 3777, 2448: 3830, 4752: 3777,
            4496: 3785, 2369: 3831, 4418: 3786, 4420: 3786,
            4424: 3786, 4768: 3777, 4432: 3786 },
            40: { 384: 3176, 129: 3177, 258: 3176, 3: 3181,
            132: 3177, 5: 3180, 6: 3180, 1025: 3174,
            4160: 3172, 4224: 3172, 3072: 3173, 2050: 3173,
            516: 3175, 144: 3177, 17: 3179, 18: 3179,
            20: 3179, 4608: 3172, 768: 3175, 576: 3175,
            260: 3176, 640: 3175, 1028: 3174, 1040: 3174,
            4097: 3172, 2064: 3173, 1088: 3174, 1152: 3174,
            257: 3176, 1280: 3174, 513: 3175, 1536: 3174,
            2052: 3173, 192: 3177, 65: 3178, 66: 3178,
            68: 3178, 130: 3177, 2112: 3173, 2176: 3173,
            4352: 3172, 2304: 3173, 4098: 3172, 80: 3178,
            320: 3176, 514: 3175, 5120: 3172, 2560: 3173,
            272: 3176, 1026: 3174, 2049: 3173, 6144: 3172,
            4112: 3172, 528: 3175, 4100: 3172 },
            1280: { 640: 2734, 2049: 2733, 2050: 2733, 3: 2741,
            132: 2735, 5: 2740, 6: 2740, 129: 2735,
            136: 2735, 9: 2739, 10: 2739, 12: 2739,
            4098: 2732, 144: 2735, 17: 2738, 18: 2738,
            20: 2738, 4608: 2732, 24: 2738, 516: 2734,
            160: 2735, 33: 2737, 34: 2737, 4097: 2732,
            2064: 2733, 40: 2737, 4160: 2732, 48: 2737,
            520: 2734, 513: 2734, 2056: 2733, 4224: 2732,
            2052: 2733, 2080: 2733, 192: 2735, 65: 2736,
            66: 2736, 68: 2736, 130: 2735, 4128: 2732,
            72: 2736, 2176: 2733, 80: 2736, 514: 2734,
            2560: 2733, 544: 2734, 36: 2737, 96: 2736,
            528: 2734, 6144: 2732, 4112: 2732, 2112: 2733,
            4104: 2732, 576: 2734, 4100: 2732 },
            48: { 384: 3165, 129: 3166, 2050: 3162, 3: 3170,
            132: 3166, 5: 3169, 6: 3169, 1025: 3163,
            136: 3166, 9: 3168, 10: 3168, 12: 3168,
            1026: 3163, 516: 3164, 320: 3165, 1032: 3163,
            768: 3164, 576: 3164, 260: 3165, 640: 3164,
            1028: 3163, 520: 3164, 4097: 3161, 5120: 3161,
            1088: 3163, 1152: 3163, 257: 3165, 4160: 3161,
            1280: 3163, 264: 3165, 513: 3164, 2056: 3162,
            4224: 3161, 2052: 3162, 192: 3166, 65: 3167,
            66: 3167, 68: 3167, 130: 3166, 72: 3167,
            258: 3165, 4352: 3161, 2304: 3162, 4098: 3161,
            1536: 3163, 514: 3164, 2560: 3162, 2049: 3162,
            6144: 3161, 3072: 3162, 2112: 3162, 4608: 3161,
            2176: 3162, 4104: 3161, 4100: 3161 },
            520: { 384: 2889, 129: 2890, 258: 2889, 3: 2895,
            132: 2890, 5: 2894, 6: 2894, 1025: 2888,
            4160: 2886, 4224: 2886, 3072: 2887, 288: 2889,
            2050: 2887, 4352: 2886, 144: 2890, 17: 2893,
            18: 2893, 20: 2893, 260: 2889, 1028: 2888,
            1040: 2888, 33: 2892, 34: 2892, 4097: 2886,
            2064: 2887, 1088: 2888, 1152: 2888, 257: 2889,
            1280: 2888, 48: 2892, 2052: 2887, 2080: 2887,
            192: 2890, 65: 2891, 66: 2891, 68: 2891,
            130: 2890, 4128: 2886, 2112: 2887, 2176: 2887,
            160: 2890, 2304: 2887, 4098: 2886, 80: 2891,
            320: 2889, 5120: 2886, 36: 2892, 96: 2891,
            272: 2889, 1026: 2888, 2049: 2887, 6144: 2886,
            4112: 2886, 1056: 2888, 4100: 2886 },
            513: { 384: 2922, 320: 2922, 2050: 2920, 2052: 2920,
            6: 2928, 2080: 2920, 136: 2923, 10: 2927,
            3072: 2920, 12: 2927, 1026: 2921, 4352: 2919,
            144: 2923, 18: 2926, 20: 2926, 1032: 2921,
            24: 2926, 132: 2923, 1028: 2921, 260: 2922,
            1040: 2921, 34: 2925, 36: 2925, 2064: 2920,
            40: 2925, 1152: 2921, 4160: 2919, 1280: 2921,
            48: 2925, 264: 2922, 2056: 2920, 4224: 2919,
            288: 2922, 192: 2923, 160: 2923, 66: 2924,
            68: 2924, 130: 2923, 4128: 2919, 72: 2924,
            258: 2922, 2304: 2920, 4098: 2919, 80: 2924,
            5120: 2919, 96: 2924, 272: 2922, 6144: 2919,
            4112: 2919, 1056: 2921, 2112: 2920, 1088: 2921,
            2176: 2920, 4104: 2919, 4100: 2919 },
            1536: { 384: 2723, 2049: 2722, 2050: 2722, 3: 2730,
            132: 2724, 5: 2729, 6: 2729, 129: 2724,
            136: 2724, 9: 2728, 10: 2728, 12: 2728,
            4098: 2721, 4352: 2721, 144: 2724, 17: 2727,
            18: 2727, 20: 2727, 24: 2727, 260: 2723,
            160: 2724, 33: 2726, 34: 2726, 4097: 2721,
            2064: 2722, 40: 2726, 257: 2723, 4160: 2721,
            48: 2726, 264: 2723, 2056: 2722, 4224: 2721,
            2052: 2722, 2080: 2722, 192: 2724, 65: 2725,
            66: 2725, 68: 2725, 130: 2724, 4128: 2721,
            72: 2725, 258: 2723, 2304: 2722, 288: 2723,
            80: 2725, 320: 2723, 36: 2726, 96: 2725,
            272: 2723, 6144: 2721, 4112: 2721, 2112: 2722,
            2176: 2722, 4104: 2721, 4100: 2721 },
            4160: { 384: 2526, 129: 2527, 2050: 2523, 3: 2532,
            132: 2527, 5: 2531, 6: 2531, 1025: 2524,
            136: 2527, 9: 2530, 10: 2530, 12: 2530,
            130: 2527, 516: 2525, 144: 2527, 17: 2529,
            18: 2529, 20: 2529, 1032: 2524, 768: 2525,
            24: 2529, 260: 2526, 640: 2525, 1028: 2524,
            520: 2525, 1040: 2524, 33: 2528, 34: 2528,
            36: 2528, 2064: 2523, 40: 2528, 1152: 2524,
            257: 2526, 1280: 2524, 48: 2528, 264: 2526,
            513: 2525, 2056: 2523, 2052: 2523, 2080: 2523,
            160: 2527, 258: 2526, 2304: 2523, 288: 2526,
            1536: 2524, 514: 2525, 2560: 2523, 544: 2525,
            272: 2526, 1026: 2524, 2049: 2523, 3072: 2523,
            1056: 2524, 2176: 2523, 528: 2525 },
            65: { 384: 3154, 640: 3153, 258: 3154, 4100: 3150,
            6: 3159, 2080: 3151, 136: 3155, 10: 3158,
            132: 3155, 12: 3158, 2050: 3151, 4352: 3150,
            144: 3155, 18: 3157, 20: 3157, 1032: 3152,
            768: 3153, 24: 3157, 516: 3153, 520: 3153,
            1028: 3152, 260: 3154, 1040: 3152, 34: 3156,
            36: 3156, 2064: 3151, 40: 3156, 1152: 3152,
            1280: 3152, 48: 3156, 264: 3154, 2056: 3151,
            4224: 3150, 3072: 3151, 288: 3154, 2052: 3151,
            160: 3155, 4098: 3150, 5120: 3150, 130: 3155,
            4128: 3150, 2176: 3151, 2304: 3151, 528: 3153,
            1536: 3152, 514: 3153, 2560: 3151, 544: 3153,
            272: 3154, 1026: 3152, 6144: 3150, 4112: 3150,
            1056: 3152, 4608: 3150, 4104: 3150 },
            66: { 384: 3143, 129: 3144, 3072: 3140, 132: 3144,
            5: 3148, 520: 3142, 1025: 3141, 136: 3144,
            9: 3147, 4224: 3139, 12: 3147, 516: 3142,
            144: 3144, 17: 3146, 20: 3146, 1032: 3141,
            768: 3142, 24: 3146, 260: 3143, 640: 3142,
            1028: 3141, 1040: 3141, 33: 3145, 4097: 3139,
            2064: 3140, 40: 3145, 1152: 3141, 257: 3143,
            1280: 3141, 48: 3145, 264: 3143, 513: 3142,
            2056: 3140, 288: 3143, 2052: 3140, 2080: 3140,
            160: 3144, 5120: 3139, 6144: 3139, 4128: 3139,
            2176: 3140, 4352: 3139, 2304: 3140, 528: 3142,
            1536: 3141, 2560: 3140, 544: 3142, 36: 3145,
            272: 3143, 2049: 3140, 4112: 3139, 1056: 3141,
            4608: 3139, 4104: 3139, 4100: 3139 },
            68: { 384: 3132, 129: 3133, 2050: 3129, 3: 3137,
            520: 3131, 1025: 3130, 136: 3133, 9: 3136,
            10: 3136, 3072: 3129, 288: 3132, 1026: 3130,
            4352: 3128, 144: 3133, 17: 3135, 18: 3135,
            1032: 3130, 24: 3135, 640: 3131, 768: 3131,
            1040: 3130, 33: 3134, 34: 3134, 4097: 3128,
            2064: 3129, 40: 3134, 1152: 3130, 257: 3132,
            1280: 3130, 48: 3134, 264: 3132, 513: 3131,
            2056: 3129, 4224: 3128, 2080: 3129, 160: 3133,
            4098: 3128, 5120: 3128, 130: 3133, 4128: 3128,
            258: 3132, 2304: 3129, 528: 3131, 1536: 3130,
            514: 3131, 2560: 3129, 544: 3131, 272: 3132,
            2049: 3129, 6144: 3128, 4112: 3128, 1056: 3130,
            4608: 3128, 2176: 3129, 4104: 3128 },
            2048: { 4103: 3598, 4107: 3596, 4109: 3595, 4110: 3595,
            15: 3762, 4115: 3593, 4117: 3592, 4118: 3592,
            23: 3759, 4121: 3591, 4122: 3591, 27: 3757,
            4124: 3591, 29: 3756, 30: 3756, 4131: 3589,
            4133: 3588, 4134: 3588, 39: 3753, 4137: 3587,
            4138: 3587, 43: 3751, 4140: 3587, 45: 3750,
            46: 3750, 4145: 3586, 4146: 3586, 51: 3748,
            4148: 3586, 53: 3747, 54: 3747, 4152: 3586,
            57: 3746, 58: 3746, 60: 3746, 4163: 3584,
            4165: 3583, 4166: 3583, 71: 3743, 4169: 3582,
            4170: 3582, 75: 3741, 4172: 3582, 77: 3740,
            78: 3740, 4177: 3581, 4178: 3581, 83: 3738,
            4180: 3581, 85: 3737, 86: 3737, 4184: 3581,
            89: 3736, 90: 3736, 92: 3736, 4193: 3580,
            4194: 3580, 99: 3734, 4196: 3580, 101: 3733,
            102: 3733, 4200: 3580, 105: 3732, 106: 3732,
            108: 3732, 4208: 3580, 113: 3731, 114: 3731,
            116: 3731, 120: 3731, 4227: 3578, 4229: 3577,
            4230: 3577, 135: 3728, 4233: 3576, 4234: 3576,
            139: 3726, 4236: 3576, 141: 3725, 142: 3725,
            4241: 3575, 4242: 3575, 147: 3723, 4244: 3575,
            149: 3722, 150: 3722, 4248: 3575, 153: 3721,
            154: 3721, 156: 3721, 4257: 3574, 4258: 3574,
            163: 3719, 4260: 3574, 165: 3718, 166: 3718,
            4264: 3574, 169: 3717, 170: 3717, 172: 3717,
            4272: 3574, 177: 3716, 178: 3716, 180: 3716,
            184: 3716, 4289: 3573, 4290: 3573, 195: 3714,
            4292: 3573, 197: 3713, 198: 3713, 4296: 3573,
            201: 3712, 202: 3712, 204: 3712, 4304: 3573,
            209: 3711, 210: 3711, 212: 3711, 216: 3711,
            4320: 3573, 225: 3710, 226: 3710, 228: 3710,
            232: 3710, 240: 3710, 4355: 3571, 4357: 3570,
            4358: 3570, 263: 3707, 4361: 3569, 4362: 3569,
            267: 3705, 4364: 3569, 269: 3704, 270: 3704,
            4369: 3568, 4370: 3568, 275: 3702, 4372: 3568,
            277: 3701, 278: 3701, 4376: 3568, 281: 3700,
            282: 3700, 284: 3700, 4385: 3567, 4386: 3567,
            291: 3698, 4388: 3567, 293: 3697, 294: 3697,
            4392: 3567, 297: 3696, 298: 3696, 300: 3696,
            4400: 3567, 305: 3695, 306: 3695, 308: 3695,
            312: 3695, 4417: 3566, 4418: 3566, 323: 3693,
            4420: 3566, 325: 3692, 326: 3692, 4424: 3566,
            329: 3691, 330: 3691, 332: 3691, 4432: 3566,
            337: 3690, 338: 3690, 340: 3690, 344: 3690,
            4448: 3566, 353: 3689, 354: 3689, 356: 3689,
            360: 3689, 368: 3689, 4481: 3565, 4482: 3565,
            387: 3687, 4484: 3565, 389: 3686, 390: 3686,
            4488: 3565, 393: 3685, 394: 3685, 396: 3685,
            4496: 3565, 401: 3684, 402: 3684, 404: 3684,
            408: 3684, 4512: 3565, 417: 3683, 418: 3683,
            420: 3683, 424: 3683, 432: 3683, 4544: 3565,
            449: 3682, 450: 3682, 452: 3682, 456: 3682,
            464: 3682, 480: 3682, 4611: 3563, 4613: 3562,
            4614: 3562, 519: 3679, 4617: 3561, 4618: 3561,
            523: 3677, 4620: 3561, 525: 3676, 526: 3676,
            4625: 3560, 4626: 3560, 531: 3674, 4628: 3560,
            533: 3673, 534: 3673, 4632: 3560, 537: 3672,
            538: 3672, 540: 3672, 4641: 3559, 4642: 3559,
            547: 3670, 4644: 3559, 549: 3669, 550: 3669,
            4648: 3559, 553: 3668, 554: 3668, 556: 3668,
            4656: 3559, 561: 3667, 562: 3667, 564: 3667,
            568: 3667, 4673: 3558, 4674: 3558, 579: 3665,
            4676: 3558, 581: 3664, 582: 3664, 4680: 3558,
            585: 3663, 586: 3663, 588: 3663, 4688: 3558,
            593: 3662, 594: 3662, 596: 3662, 600: 3662,
            4704: 3558, 609: 3661, 610: 3661, 612: 3661,
            616: 3661, 624: 3661, 4737: 3557, 4738: 3557,
            643: 3659, 4740: 3557, 645: 3658, 646: 3658,
            4744: 3557, 649: 3657, 650: 3657, 652: 3657,
            4752: 3557, 657: 3656, 658: 3656, 660: 3656,
            664: 3656, 4768: 3557, 673: 3655, 674: 3655,
            676: 3655, 680: 3655, 688: 3655, 4800: 3557,
            705: 3654, 706: 3654, 708: 3654, 712: 3654,
            720: 3654, 736: 3654, 4865: 3556, 4866: 3556,
            771: 3652, 4868: 3556, 773: 3651, 774: 3651,
            4872: 3556, 777: 3650, 778: 3650, 780: 3650,
            4880: 3556, 785: 3649, 786: 3649, 788: 3649,
            792: 3649, 4896: 3556, 801: 3648, 802: 3648,
            804: 3648, 808: 3648, 816: 3648, 4928: 3556,
            833: 3647, 834: 3647, 836: 3647, 840: 3647,
            848: 3647, 864: 3647, 4992: 3556, 897: 3646,
            898: 3646, 900: 3646, 904: 3646, 912: 3646,
            928: 3646, 960: 3646, 5123: 3554, 5125: 3553,
            5126: 3553, 1031: 3643, 5129: 3552, 5130: 3552,
            1035: 3641, 5132: 3552, 1037: 3640, 1038: 3640,
            5137: 3551, 5138: 3551, 1043: 3638, 5140: 3551,
            1045: 3637, 1046: 3637, 5144: 3551, 1049: 3636,
            1050: 3636, 1052: 3636, 5153: 3550, 5154: 3550,
            1059: 3634, 5156: 3550, 1061: 3633, 1062: 3633,
            5160: 3550, 1065: 3632, 1066: 3632, 1068: 3632,
            5168: 3550, 1073: 3631, 1074: 3631, 1076: 3631,
            1080: 3631, 5185: 3549, 5186: 3549, 1091: 3629,
            5188: 3549, 1093: 3628, 1094: 3628, 5192: 3549,
            1097: 3627, 1098: 3627, 1100: 3627, 5200: 3549,
            1105: 3626, 1106: 3626, 1108: 3626, 1112: 3626,
            5216: 3549, 1121: 3625, 1122: 3625, 1124: 3625,
            1128: 3625, 1136: 3625, 5249: 3548, 5250: 3548,
            1155: 3623, 5252: 3548, 1157: 3622, 1158: 3622,
            5256: 3548, 1161: 3621, 1162: 3621, 1164: 3621,
            5264: 3548, 1169: 3620, 1170: 3620, 1172: 3620,
            1176: 3620, 5280: 3548, 1185: 3619, 1186: 3619,
            1188: 3619, 1192: 3619, 1200: 3619, 5312: 3548,
            1217: 3618, 1218: 3618, 1220: 3618, 1224: 3618,
            1232: 3618, 1248: 3618, 5377: 3547, 5378: 3547,
            1283: 3616, 5380: 3547, 1285: 3615, 1286: 3615,
            5384: 3547, 1289: 3614, 1290: 3614, 1292: 3614,
            5392: 3547, 1297: 3613, 1298: 3613, 1300: 3613,
            1304: 3613, 5408: 3547, 1313: 3612, 1314: 3612,
            1316: 3612, 1320: 3612, 1328: 3612, 5440: 3547,
            1345: 3611, 1346: 3611, 1348: 3611, 1352: 3611,
            1360: 3611, 1376: 3611, 5504: 3547, 1409: 3610,
            1410: 3610, 1412: 3610, 1416: 3610, 1424: 3610,
            1440: 3610, 1472: 3610, 5633: 3546, 5634: 3546,
            1539: 3608, 5636: 3546, 1541: 3607, 1542: 3607,
            5640: 3546, 1545: 3606, 1546: 3606, 1548: 3606,
            5648: 3546, 1553: 3605, 1554: 3605, 1556: 3605,
            1560: 3605, 5664: 3546, 1569: 3604, 1570: 3604,
            1572: 3604, 1576: 3604, 1584: 3604, 5696: 3546,
            1601: 3603, 1602: 3603, 1604: 3603, 1608: 3603,
            1616: 3603, 1632: 3603, 5760: 3546, 1665: 3602,
            1666: 3602, 1668: 3602, 1672: 3602, 1680: 3602,
            1696: 3602, 1728: 3602, 5888: 1600, 1793: 3601,
            1794: 3601, 1796: 3601, 1800: 3601, 1808: 3601,
            1824: 3601, 1856: 3601, 1920: 1601 },
            4128: { 384: 2537, 129: 2538, 2050: 2534, 3: 2543,
            132: 2538, 5: 2542, 6: 2542, 1025: 2535,
            136: 2538, 9: 2541, 10: 2541, 12: 2541,
            130: 2538, 516: 2536, 144: 2538, 17: 2540,
            18: 2540, 20: 2540, 1032: 2535, 768: 2536,
            24: 2540, 260: 2537, 640: 2536, 1028: 2535,
            520: 2536, 1040: 2535, 2064: 2534, 1088: 2535,
            1152: 2535, 257: 2537, 1280: 2535, 264: 2537,
            513: 2536, 2056: 2534, 2052: 2534, 192: 2538,
            65: 2539, 66: 2539, 68: 2539, 72: 2539,
            258: 2537, 2304: 2534, 80: 2539, 320: 2537,
            514: 2536, 2560: 2534, 272: 2537, 1026: 2535,
            2049: 2534, 3072: 2534, 2112: 2534, 1536: 2535,
            2176: 2534, 528: 2536, 576: 2536 },
            72: { 384: 3121, 129: 3122, 258: 3121, 3: 3126,
            132: 3122, 5: 3125, 6: 3125, 1025: 3119,
            4224: 3117, 3072: 3118, 2050: 3118, 516: 3120,
            144: 3122, 17: 3124, 18: 3124, 20: 3124,
            4608: 3117, 768: 3120, 260: 3121, 640: 3120,
            1028: 3119, 1040: 3119, 33: 3123, 34: 3123,
            4097: 3117, 2064: 3118, 1152: 3119, 257: 3121,
            1280: 3119, 48: 3123, 513: 3120, 1536: 3119,
            2052: 3118, 2080: 3118, 160: 3122, 4098: 3117,
            5120: 3117, 130: 3122, 4128: 3117, 2176: 3118,
            4352: 3117, 2304: 3118, 288: 3121, 514: 3120,
            2560: 3118, 544: 3120, 36: 3123, 272: 3121,
            1026: 3119, 2049: 3118, 6144: 3117, 4112: 3117,
            1056: 3119, 528: 3120, 4100: 3117 },
            2304: { 640: 2624, 1025: 2623, 1026: 2623, 3: 2631,
            132: 2625, 5: 2630, 6: 2630, 129: 2625,
            136: 2625, 9: 2629, 10: 2629, 12: 2629,
            4098: 2622, 144: 2625, 17: 2628, 18: 2628,
            20: 2628, 1032: 2623, 24: 2628, 516: 2624,
            1028: 2623, 1040: 2623, 33: 2627, 34: 2627,
            4097: 2622, 5120: 2622, 40: 2627, 1152: 2623,
            4160: 2622, 48: 2627, 520: 2624, 513: 2624,
            1536: 2623, 4224: 2622, 192: 2625, 65: 2626,
            66: 2626, 68: 2626, 130: 2625, 4128: 2622,
            72: 2626, 1088: 2623, 160: 2625, 80: 2626,
            514: 2624, 544: 2624, 36: 2627, 96: 2626,
            528: 2624, 4112: 2622, 1056: 2623, 4608: 2622,
            4104: 2622, 576: 2624, 4100: 2622 },
            80: { 384: 3110, 129: 3111, 2050: 3107, 3: 3115,
            132: 3111, 5: 3114, 6: 3114, 1025: 3108,
            136: 3111, 9: 3113, 10: 3113, 12: 3113,
            1026: 3108, 516: 3109, 1536: 3108, 1032: 3108,
            768: 3109, 260: 3110, 640: 3109, 1028: 3108,
            520: 3109, 160: 3111, 33: 3112, 34: 3112,
            4097: 3106, 2080: 3107, 40: 3112, 1152: 3108,
            257: 3110, 1280: 3108, 264: 3110, 513: 3109,
            2056: 3107, 4224: 3106, 2052: 3107, 288: 3110,
            4098: 3106, 5120: 3106, 130: 3111, 4128: 3106,
            258: 3110, 4352: 3106, 2304: 3107, 514: 3109,
            2560: 3107, 544: 3109, 36: 3112, 2049: 3107,
            6144: 3106, 3072: 3107, 1056: 3108, 4608: 3106,
            2176: 3107, 4104: 3106, 4100: 3106 },
            514: { 384: 2911, 129: 2912, 3072: 2909, 132: 2912,
            5: 2917, 260: 2911, 1025: 2910, 136: 2912,
            9: 2916, 4224: 2908, 12: 2916, 4352: 2908,
            144: 2912, 17: 2915, 20: 2915, 1032: 2910,
            24: 2915, 2052: 2909, 1028: 2910, 1040: 2910,
            33: 2914, 4097: 2908, 2064: 2909, 40: 2914,
            1152: 2910, 257: 2911, 4160: 2908, 1280: 2910,
            48: 2914, 264: 2911, 2056: 2909, 2080: 2909,
            192: 2912, 65: 2913, 68: 2913, 6144: 2908,
            4128: 2908, 72: 2913, 1088: 2910, 160: 2912,
            2304: 2909, 288: 2911, 80: 2913, 320: 2911,
            5120: 2908, 36: 2914, 96: 2913, 272: 2911,
            2049: 2909, 4112: 2908, 1056: 2910, 2112: 2909,
            2176: 2909, 4104: 2908, 4100: 2908 },
            2560: { 384: 2613, 1025: 2612, 4098: 2611, 3: 2620,
            132: 2614, 5: 2619, 6: 2619, 129: 2614,
            136: 2614, 9: 2618, 10: 2618, 12: 2618,
            258: 2613, 4352: 2611, 144: 2614, 17: 2617,
            18: 2617, 20: 2617, 1032: 2612, 24: 2617,
            260: 2613, 1028: 2612, 1040: 2612, 33: 2616,
            34: 2616, 4097: 2611, 5120: 2611, 40: 2616,
            1152: 2612, 257: 2613, 4160: 2611, 1280: 2612,
            48: 2616, 264: 2613, 4224: 2611, 192: 2614,
            65: 2615, 66: 2615, 68: 2615, 130: 2614,
            4128: 2611, 72: 2615, 1088: 2612, 160: 2614,
            288: 2613, 80: 2615, 320: 2613, 36: 2616,
            96: 2615, 272: 2613, 1026: 2612, 4112: 2611,
            1056: 2612, 4104: 2611, 4100: 2611 },
            96: { 384: 3099, 129: 3100, 130: 3100, 3: 3104,
            132: 3100, 5: 3103, 6: 3103, 1025: 3097,
            136: 3100, 9: 3102, 10: 3102, 3072: 3096,
            12: 3102, 2050: 3096, 516: 3098, 144: 3100,
            17: 3101, 18: 3101, 20: 3101, 1032: 3097,
            768: 3098, 24: 3101, 260: 3099, 640: 3098,
            1028: 3097, 520: 3098, 1040: 3097, 4097: 3095,
            2064: 3096, 1152: 3097, 257: 3099, 1280: 3097,
            264: 3099, 513: 3098, 2056: 3096, 4224: 3095,
            2052: 3096, 4098: 3095, 5120: 3095, 6144: 3095,
            258: 3099, 4352: 3095, 2304: 3096, 528: 3098,
            1536: 3097, 514: 3098, 2560: 3096, 272: 3099,
            1026: 3097, 2049: 3096, 4112: 3095, 4608: 3095,
            2176: 3096, 4104: 3095, 4100: 3095 },
            528: { 384: 2878, 129: 2879, 2050: 2876, 3: 2884,
            132: 2879, 5: 2883, 6: 2883, 1025: 2877,
            136: 2879, 9: 2882, 10: 2882, 12: 2882,
            4098: 2875, 4352: 2875, 320: 2878, 1032: 2877,
            260: 2878, 1028: 2877, 160: 2879, 33: 2881,
            34: 2881, 4097: 2875, 2080: 2876, 40: 2881,
            1152: 2877, 257: 2878, 4160: 2875, 1280: 2877,
            264: 2878, 2056: 2876, 4224: 2875, 2052: 2876,
            192: 2879, 65: 2880, 66: 2880, 68: 2880,
            130: 2879, 4128: 2875, 72: 2880, 258: 2878,
            2304: 2876, 288: 2878, 5120: 2875, 36: 2881,
            96: 2880, 1026: 2877, 2049: 2876, 6144: 2875,
            3072: 2876, 1056: 2877, 2112: 2876, 1088: 2877,
            2176: 2876, 4104: 2875, 4100: 2875 },
            1026: { 384: 2812, 129: 2813, 132: 2813, 5: 2818,
            260: 2812, 2049: 2810, 136: 2813, 9: 2817,
            4224: 2809, 12: 2817, 4352: 2809, 144: 2813,
            17: 2816, 20: 2816, 4608: 2809, 24: 2816,
            516: 2811, 640: 2811, 768: 2811, 520: 2811,
            160: 2813, 33: 2815, 4097: 2809, 2064: 2810,
            40: 2815, 257: 2812, 4160: 2809, 48: 2815,
            264: 2812, 513: 2811, 2056: 2810, 288: 2812,
            2052: 2810, 2080: 2810, 192: 2813, 65: 2814,
            68: 2814, 6144: 2809, 4128: 2809, 72: 2814,
            2176: 2810, 2304: 2810, 528: 2811, 80: 2814,
            320: 2812, 2560: 2810, 544: 2811, 36: 2815,
            96: 2814, 272: 2812, 4112: 2809, 2112: 2810,
            4104: 2809, 576: 2811, 4100: 2809 },
            2049: { 384: 2713, 320: 2713, 1026: 2711, 4100: 2710,
            6: 2719, 136: 2714, 10: 2718, 12: 2718,
            4098: 2710, 516: 2712, 144: 2714, 18: 2717,
            20: 2717, 1032: 2711, 768: 2712, 24: 2717,
            132: 2714, 640: 2712, 520: 2712, 1028: 2711,
            260: 2713, 1040: 2711, 34: 2716, 36: 2716,
            5120: 2710, 40: 2716, 1152: 2711, 4160: 2710,
            1280: 2711, 48: 2716, 264: 2713, 1536: 2711,
            4224: 2710, 288: 2713, 192: 2714, 160: 2714,
            66: 2715, 68: 2715, 130: 2714, 4128: 2710,
            72: 2715, 258: 2713, 4352: 2710, 528: 2712,
            80: 2715, 514: 2712, 544: 2712, 4608: 2710,
            96: 2715, 272: 2713, 4112: 2710, 1056: 2711,
            1088: 2711, 4104: 2710, 576: 2712 },
            4112: { 384: 2548, 129: 2549, 2050: 2545, 3: 2554,
            132: 2549, 5: 2553, 6: 2553, 1025: 2546,
            136: 2549, 9: 2552, 10: 2552, 12: 2552,
            514: 2547, 516: 2547, 320: 2548, 1032: 2546,
            768: 2547, 576: 2547, 260: 2548, 640: 2547,
            1028: 2546, 520: 2547, 160: 2549, 33: 2551,
            34: 2551, 36: 2551, 2080: 2545, 40: 2551,
            1152: 2546, 257: 2548, 1280: 2546, 264: 2548,
            513: 2547, 2056: 2545, 2052: 2545, 192: 2549,
            65: 2550, 66: 2550, 68: 2550, 130: 2549,
            72: 2550, 258: 2548, 2304: 2545, 288: 2548,
            1536: 2546, 2560: 2545, 544: 2547, 96: 2550,
            1026: 2546, 2049: 2545, 3072: 2545, 1056: 2546,
            2112: 2545, 1088: 2546, 2176: 2545 },
            128: { 6147: 4434, 6149: 4433, 6150: 4433, 2055: 4523,
            6153: 4432, 6154: 4432, 2059: 4521, 6156: 4432,
            4109: 4475, 4110: 4475, 15: 4642, 6161: 4431,
            6162: 4431, 2067: 4518, 6164: 4431, 2069: 4517,
            2070: 4517, 23: 4639, 6168: 4431, 2073: 4516,
            2074: 4516, 27: 4637, 4124: 4471, 29: 4636,
            30: 4636, 3077: 4487, 6177: 4430, 6178: 4430,
            4131: 4469, 6180: 4430, 2085: 4513, 2086: 4513,
            39: 4633, 6184: 4430, 4137: 4467, 2090: 4512,
            43: 4631, 4140: 4467, 45: 4630, 46: 4630,
            6192: 4430, 2097: 4511, 2098: 4511, 51: 4628,
            2100: 4511, 53: 4627, 54: 4627, 5129: 4441,
            2104: 4511, 57: 4626, 58: 4626, 60: 4626,
            3082: 4486, 6209: 4429, 6210: 4429, 4163: 4464,
            6212: 4429, 4165: 4463, 2118: 4508, 71: 4623,
            6216: 4429, 2121: 4507, 4170: 4462, 75: 4621,
            4172: 4462, 77: 4620, 78: 4620, 2061: 4520,
            6224: 4429, 4177: 4461, 4178: 4461, 83: 4618,
            2132: 4506, 85: 4617, 86: 4617, 2136: 4506,
            89: 4616, 90: 4616, 92: 4616, 344: 4591,
            4193: 4460, 4194: 4460, 99: 4614, 2148: 4505,
            101: 4613, 102: 4613, 5137: 4440, 2152: 4505,
            105: 4612, 106: 4612, 108: 4612, 5138: 4440,
            2160: 4505, 113: 4611, 114: 4611, 4115: 4473,
            116: 4611, 120: 1605, 5140: 4440, 4117: 4472,
            4118: 4472, 5144: 4440, 4121: 4471, 4122: 4471,
            2076: 4516, 3075: 4488, 3105: 4484, 3106: 4484,
            2083: 4514, 5156: 4439, 4133: 4468, 4134: 4468,
            5160: 4439, 2089: 4512, 1031: 4559, 4138: 4467,
            6401: 4428, 6402: 4428, 4355: 4458, 6404: 4428,
            4357: 4457, 2310: 4502, 263: 4608, 6408: 4428,
            4361: 4456, 2314: 4501, 267: 4606, 4364: 4456,
            269: 4605, 270: 4605, 6416: 4428, 2321: 4500,
            4370: 4455, 275: 4603, 4372: 4455, 277: 4602,
            278: 4602, 2328: 4500, 281: 4601, 282: 4601,
            284: 4601, 6432: 4428, 4385: 4454, 4386: 4454,
            291: 4599, 2340: 4499, 293: 4598, 294: 4598,
            4145: 4466, 2344: 4499, 297: 4597, 298: 4597,
            300: 4597, 4146: 4466, 2352: 4499, 305: 4596,
            306: 4596, 308: 4596, 312: 4596, 4148: 4466,
            6464: 4428, 4417: 4453, 2370: 4498, 323: 4594,
            2372: 4498, 325: 4593, 326: 4593, 2376: 4498,
            329: 4592, 330: 4592, 332: 4592, 2384: 4498,
            337: 4591, 338: 4591, 340: 4591, 4103: 4478,
            2400: 4498, 353: 4590, 354: 4590, 356: 4590,
            360: 4590, 368: 1604, 5185: 4438, 5186: 4438,
            2115: 4509, 5188: 4438, 2117: 4508, 4166: 4463,
            5192: 4438, 4169: 4462, 2122: 4507, 2124: 4507,
            4107: 4476, 4448: 4453, 5200: 4438, 2129: 4506,
            2062: 4520, 2130: 4506, 4180: 4461, 6657: 4427,
            6658: 4427, 2563: 4496, 6660: 4427, 2565: 4495,
            2566: 4495, 4865: 4445, 6664: 4427, 2569: 4494,
            2570: 4494, 523: 4585, 2572: 4494, 4866: 4445,
            526: 4584, 6672: 4427, 2577: 4493, 4626: 4448,
            531: 4582, 2580: 4493, 533: 4581, 534: 4581,
            2584: 4493, 537: 4580, 538: 4580, 540: 4580,
            6688: 4427, 4641: 4447, 4642: 4447, 547: 4578,
            2596: 4492, 549: 4577, 550: 4577, 2600: 4492,
            553: 4576, 554: 4576, 556: 4576, 2608: 4492,
            561: 4575, 562: 4575, 564: 4575, 4656: 4447,
            568: 4575, 6720: 4427, 4673: 4446, 2626: 4491,
            579: 4573, 2628: 4491, 581: 4572, 582: 4572,
            2145: 4505, 2632: 4491, 585: 4571, 586: 4571,
            5132: 4441, 2146: 4505, 2640: 4491, 593: 4570,
            594: 4570, 596: 4570, 600: 4570, 4196: 4460,
            2656: 4491, 609: 4569, 610: 4569, 612: 4569,
            616: 4569, 624: 4569, 4200: 4460, 4208: 4460,
            5888: 4436, 4896: 4445, 4184: 4461, 6912: 4427,
            2817: 4490, 2818: 4490, 771: 4567, 2820: 4490,
            773: 4566, 774: 4566, 2824: 4490, 777: 4565,
            778: 4565, 780: 4565, 2832: 4490, 785: 4564,
            786: 4564, 788: 4564, 4868: 4445, 792: 4564,
            2848: 4490, 801: 4563, 802: 4563, 804: 4563,
            808: 4563, 816: 4563, 2880: 4490, 833: 4562,
            834: 4562, 836: 4562, 840: 4562, 848: 4562,
            864: 1603, 4928: 4445, 4872: 4445, 5216: 4438,
            7169: 4426, 7170: 4426, 5123: 4443, 7172: 4426,
            5125: 4442, 5126: 4442, 5633: 4436, 7176: 4426,
            3081: 4486, 5130: 4441, 1035: 4557, 3084: 4486,
            1037: 4556, 1038: 4556, 7184: 4426, 3089: 4485,
            3090: 4485, 1043: 4554, 3092: 4485, 1045: 4553,
            1046: 4553, 3096: 4485, 1049: 4552, 1050: 4552,
            1052: 4552, 4613: 4450, 7200: 4426, 5153: 4439,
            5154: 4439, 1059: 4550, 3108: 4484, 1061: 4549,
            1062: 4549, 3112: 4484, 1065: 4548, 1066: 4548,
            519: 4587, 1068: 4548, 3120: 4484, 1073: 4547,
            1074: 4547, 1076: 4547, 4617: 4449, 1080: 4547,
            4618: 4449, 7232: 4426, 3137: 4483, 3138: 4483,
            1091: 4545, 3140: 4483, 1093: 4544, 1094: 4544,
            3144: 4483, 1097: 4543, 1098: 4543, 1100: 4543,
            525: 4584, 3152: 4483, 1105: 4542, 1106: 4542,
            1108: 4542, 1112: 4542, 3168: 4483, 1121: 4541,
            1122: 4541, 1124: 4541, 4625: 4448, 1128: 4541,
            2578: 4493, 1136: 4541, 4628: 4448, 4880: 4445,
            4632: 4448, 3586: 4481, 5664: 4436, 2593: 4492,
            2594: 4492, 4644: 4447, 4611: 4451, 4648: 4447,
            7424: 4426, 5377: 4437, 5378: 4437, 1283: 4539,
            3332: 4482, 1285: 4538, 1286: 4538, 3336: 4482,
            1289: 4537, 1290: 4537, 1292: 4537, 3344: 4482,
            1297: 4536, 1298: 4536, 1300: 4536, 1304: 4536,
            3360: 4482, 1313: 4535, 1314: 4535, 1316: 4535,
            1320: 4535, 5636: 4436, 1328: 4535, 3392: 4482,
            1345: 4534, 1346: 4534, 1348: 4534, 1352: 4534,
            4614: 4450, 1360: 4534, 1376: 4534, 2092: 4512,
            5696: 4436, 6240: 4429, 3078: 4487, 2625: 4491,
            4674: 4446, 4676: 4446, 5640: 4436, 4680: 4446,
            588: 4571, 4688: 4446, 4620: 4449, 7680: 4426,
            3585: 4481, 5634: 4436, 1539: 4532, 3588: 4481,
            1541: 4531, 1542: 4531, 3329: 4482, 3592: 4481,
            1545: 4530, 1546: 4530, 1548: 4530, 3330: 4482,
            3600: 4481, 1553: 4529, 1554: 4529, 2307: 4503,
            1556: 4529, 1560: 4529, 5380: 4437, 2309: 4502,
            3616: 4481, 1569: 4528, 1570: 4528, 1572: 4528,
            4358: 4457, 1576: 4528, 1584: 4528, 5384: 4437,
            2313: 4501, 4362: 4456, 3648: 4481, 1601: 4527,
            1602: 4527, 1604: 4527, 5168: 4439, 1608: 4527,
            2316: 4501, 1616: 4527, 1632: 4527, 5392: 4437,
            4369: 4455, 2322: 4500, 2324: 4500, 4376: 4455,
            5648: 4436, 5408: 4437, 2337: 4499, 2338: 4499,
            4388: 4454, 4392: 4454, 3840: 1601, 1793: 4526,
            1794: 4526, 1796: 4526, 1800: 4526, 1808: 4526,
            4152: 4466, 1824: 4526, 4400: 4454, 1856: 1602,
            5440: 4437, 2369: 4498, 4418: 4453, 4420: 4453,
            4424: 4453, 4704: 4446, 4432: 4453 },
            129: { 768: 3087, 576: 3087, 258: 3088, 4100: 3084,
            6: 3093, 2080: 3085, 264: 3088, 10: 3092,
            3072: 3085, 12: 3092, 2050: 3085, 4352: 3084,
            272: 3088, 18: 3091, 20: 3091, 1032: 3086,
            24: 3091, 516: 3087, 1028: 3086, 260: 3088,
            1040: 3086, 34: 3090, 36: 3090, 2064: 3085,
            40: 3090, 4160: 3084, 1280: 3086, 48: 3090,
            520: 3087, 2056: 3085, 2052: 3085, 320: 3088,
            288: 3088, 66: 3089, 68: 3089, 6144: 3084,
            4128: 3084, 72: 3089, 1088: 3086, 2304: 3085,
            4098: 3084, 80: 3089, 1536: 3086, 514: 3087,
            5120: 3084, 2560: 3085, 544: 3087, 96: 3089,
            528: 3087, 1026: 3086, 4112: 3084, 1056: 3086,
            2112: 3085, 4608: 3084, 4104: 3084 },
            130: { 768: 3076, 1025: 3075, 3072: 3074, 516: 3076,
            5: 3082, 260: 3077, 257: 3077, 264: 3077,
            9: 3081, 12: 3081, 4352: 3073, 272: 3077,
            17: 3080, 20: 3080, 1032: 3075, 24: 3080,
            1028: 3075, 1040: 3075, 33: 3079, 4097: 3073,
            2064: 3074, 40: 3079, 4160: 3073, 1280: 3075,
            48: 3079, 520: 3076, 513: 3076, 2056: 3074,
            2052: 3074, 2080: 3074, 320: 3077, 65: 3078,
            68: 3078, 6144: 3073, 4128: 3073, 72: 3078,
            1088: 3075, 2304: 3074, 288: 3077, 80: 3078,
            1536: 3075, 5120: 3073, 2560: 3074, 544: 3076,
            36: 3079, 96: 3078, 528: 3076, 2049: 3074,
            4112: 3073, 1056: 3075, 2112: 3074, 4608: 3073,
            4104: 3073, 576: 3076, 4100: 3073 },
            132: { 768: 3065, 257: 3066, 2050: 3063, 3: 3071,
            1040: 3064, 1025: 3064, 264: 3066, 9: 3070,
            10: 3070, 3072: 3063, 1026: 3064, 4352: 3062,
            272: 3066, 17: 3069, 18: 3069, 1032: 3064,
            24: 3069, 288: 3066, 33: 3068, 34: 3068,
            4097: 3062, 2064: 3063, 40: 3068, 4160: 3062,
            1280: 3064, 48: 3068, 520: 3065, 513: 3065,
            2056: 3063, 2080: 3063, 320: 3066, 65: 3067,
            66: 3067, 5120: 3062, 4608: 3062, 4128: 3062,
            72: 3067, 258: 3066, 2304: 3063, 4098: 3062,
            80: 3067, 1536: 3064, 514: 3065, 2560: 3063,
            544: 3065, 96: 3067, 528: 3065, 2049: 3063,
            6144: 3062, 4112: 3062, 1056: 3064, 2112: 3063,
            1088: 3064, 4104: 3062, 576: 3065 },
            136: { 768: 3054, 257: 3055, 258: 3055, 3: 3060,
            260: 3055, 5: 3059, 6: 3059, 1025: 3053,
            4160: 3051, 3072: 3052, 288: 3055, 2050: 3052,
            4352: 3051, 272: 3055, 17: 3058, 18: 3058,
            20: 3058, 4608: 3051, 576: 3054, 516: 3054,
            1028: 3053, 1040: 3053, 33: 3057, 34: 3057,
            4097: 3051, 2064: 3052, 1088: 3053, 1280: 3053,
            48: 3057, 513: 3054, 1536: 3053, 2052: 3052,
            2080: 3052, 320: 3055, 65: 3056, 66: 3056,
            68: 3056, 6144: 3051, 4128: 3051, 2112: 3052,
            2304: 3052, 4098: 3051, 80: 3056, 514: 3054,
            5120: 3051, 2560: 3052, 544: 3054, 36: 3057,
            96: 3056, 528: 3054, 1026: 3053, 2049: 3052,
            4112: 3051, 1056: 3053, 4100: 3051 },
            516: { 384: 2900, 129: 2901, 2050: 2898, 3: 2906,
            1040: 2899, 1025: 2899, 136: 2901, 9: 2905,
            10: 2905, 3072: 2898, 4098: 2897, 4352: 2897,
            144: 2901, 17: 2904, 18: 2904, 1032: 2899,
            24: 2904, 160: 2901, 33: 2903, 34: 2903,
            4097: 2897, 2064: 2898, 40: 2903, 1152: 2899,
            257: 2900, 4160: 2897, 1280: 2899, 48: 2903,
            264: 2900, 2056: 2898, 4224: 2897, 2080: 2898,
            192: 2901, 65: 2902, 66: 2902, 5120: 2897,
            130: 2901, 4128: 2897, 72: 2902, 258: 2900,
            2304: 2898, 288: 2900, 80: 2902, 320: 2900,
            96: 2902, 272: 2900, 1026: 2899, 2049: 2898,
            6144: 2897, 4112: 2897, 1056: 2899, 2112: 2898,
            1088: 2899, 2176: 2898, 4104: 2897 },
            144: { 768: 3043, 257: 3044, 2050: 3041, 3: 3049,
            260: 3044, 5: 3048, 6: 3048, 1025: 3042,
            264: 3044, 9: 3047, 10: 3047, 12: 3047,
            1026: 3042, 4352: 3040, 1536: 3042, 1032: 3042,
            576: 3043, 516: 3043, 1028: 3042, 288: 3044,
            33: 3046, 34: 3046, 4097: 3040, 2080: 3041,
            40: 3046, 4160: 3040, 1280: 3042, 520: 3043,
            513: 3043, 2056: 3041, 2052: 3041, 320: 3044,
            65: 3045, 66: 3045, 68: 3045, 4608: 3040,
            4128: 3040, 72: 3045, 258: 3044, 2304: 3041,
            4098: 3040, 514: 3043, 5120: 3040, 2560: 3041,
            544: 3043, 36: 3046, 96: 3045, 2049: 3041,
            6144: 3040, 3072: 3041, 1056: 3042, 2112: 3041,
            1088: 3042, 4104: 3040, 4100: 3040 },
            4608: { 384: 2492, 1025: 2491, 2050: 2490, 3: 2499,
            132: 2493, 5: 2498, 6: 2498, 129: 2493,
            136: 2493, 9: 2497, 10: 2497, 12: 2497,
            258: 2492, 144: 2493, 17: 2496, 18: 2496,
            20: 2496, 1032: 2491, 24: 2496, 260: 2492,
            1028: 2491, 1040: 2491, 33: 2495, 34: 2495,
            36: 2495, 2064: 2490, 40: 2495, 1152: 2491,
            257: 2492, 1280: 2491, 48: 2495, 264: 2492,
            2056: 2490, 2052: 2490, 2080: 2490, 192: 2493,
            65: 2494, 66: 2494, 68: 2494, 130: 2493,
            72: 2494, 1088: 2491, 160: 2493, 2304: 2490,
            288: 2492, 80: 2494, 320: 2492, 96: 2494,
            272: 2492, 1026: 2491, 2049: 2490, 3072: 2490,
            1056: 2491, 2112: 2490, 2176: 2490 },
            160: { 768: 3032, 257: 3033, 2050: 3030, 3: 3038,
            260: 3033, 5: 3037, 6: 3037, 1025: 3031,
            264: 3033, 9: 3036, 10: 3036, 3072: 3030,
            12: 3036, 1026: 3031, 4352: 3029, 272: 3033,
            17: 3035, 18: 3035, 20: 3035, 1032: 3031,
            24: 3035, 516: 3032, 1028: 3031, 1040: 3031,
            4097: 3029, 2064: 3030, 1088: 3031, 4160: 3029,
            1280: 3031, 520: 3032, 513: 3032, 2056: 3030,
            2052: 3030, 320: 3033, 65: 3034, 66: 3034,
            68: 3034, 6144: 3029, 72: 3034, 258: 3033,
            2304: 3030, 4098: 3029, 80: 3034, 1536: 3031,
            514: 3032, 5120: 3029, 2560: 3030, 528: 3032,
            2049: 3030, 4112: 3029, 2112: 3030, 4608: 3029,
            4104: 3029, 576: 3032, 4100: 3029 },
            1040: { 384: 2779, 129: 2780, 2050: 2777, 3: 2785,
            132: 2780, 5: 2784, 6: 2784, 2049: 2777,
            136: 2780, 9: 2783, 10: 2783, 12: 2783,
            4098: 2776, 516: 2778, 320: 2779, 4608: 2776,
            576: 2778, 260: 2779, 640: 2778, 768: 2778,
            520: 2778, 160: 2780, 33: 2782, 34: 2782,
            4097: 2776, 2080: 2777, 40: 2782, 257: 2779,
            4160: 2776, 264: 2779, 513: 2778, 2056: 2777,
            4224: 2776, 2052: 2777, 192: 2780, 65: 2781,
            66: 2781, 68: 2781, 130: 2780, 4128: 2776,
            72: 2781, 258: 2779, 4352: 2776, 2304: 2777,
            288: 2779, 514: 2778, 2560: 2777, 544: 2778,
            36: 2782, 96: 2781, 6144: 2776, 2112: 2777,
            2176: 2777, 4104: 2776, 4100: 2776 },
            4097: { 384: 2592, 320: 2592, 2050: 2589, 516: 2591,
            6: 2598, 2080: 2589, 136: 2593, 10: 2597,
            132: 2593, 12: 2597, 1026: 2590, 144: 2593,
            18: 2596, 20: 2596, 1032: 2590, 768: 2591,
            24: 2596, 2052: 2589, 640: 2591, 520: 2591,
            1028: 2590, 260: 2592, 1040: 2590, 34: 2595,
            36: 2595, 2064: 2589, 40: 2595, 1152: 2590,
            1280: 2590, 48: 2595, 264: 2592, 2056: 2589,
            192: 2593, 160: 2593, 66: 2594, 68: 2594,
            130: 2593, 72: 2594, 258: 2592, 2304: 2589,
            288: 2592, 80: 2594, 1536: 2590, 514: 2591,
            2560: 2589, 544: 2591, 96: 2594, 272: 2592,
            3072: 2589, 1056: 2590, 2112: 2589, 1088: 2590,
            2176: 2589, 528: 2591, 576: 2591 },
            5120: { 384: 2481, 2049: 2479, 2050: 2479, 3: 2488,
            132: 2482, 5: 2487, 6: 2487, 129: 2482,
            136: 2482, 9: 2486, 10: 2486, 12: 2486,
            258: 2481, 516: 2480, 144: 2482, 17: 2485,
            18: 2485, 20: 2485, 24: 2485, 260: 2481,
            640: 2480, 768: 2480, 520: 2480, 160: 2482,
            33: 2484, 34: 2484, 36: 2484, 2064: 2479,
            40: 2484, 257: 2481, 48: 2484, 264: 2481,
            513: 2480, 2056: 2479, 2052: 2479, 2080: 2479,
            192: 2482, 65: 2483, 66: 2483, 68: 2483,
            130: 2482, 72: 2483, 2176: 2479, 2304: 2479,
            288: 2481, 80: 2483, 320: 2481, 514: 2480,
            2560: 2479, 544: 2480, 96: 2483, 272: 2481,
            2112: 2479, 528: 2480, 576: 2480 },
            2052: { 384: 2691, 129: 2692, 4098: 2688, 3: 2697,
            520: 2690, 1025: 2689, 136: 2692, 9: 2696,
            10: 2696, 288: 2691, 258: 2691, 4352: 2688,
            144: 2692, 17: 2695, 18: 2695, 1032: 2689,
            24: 2695, 640: 2690, 768: 2690, 1040: 2689,
            33: 2694, 34: 2694, 4097: 2688, 5120: 2688,
            40: 2694, 1152: 2689, 257: 2691, 4160: 2688,
            1280: 2689, 48: 2694, 264: 2691, 513: 2690,
            1536: 2689, 4224: 2688, 192: 2692, 65: 2693,
            66: 2693, 130: 2692, 4128: 2688, 72: 2693,
            1088: 2689, 160: 2692, 528: 2690, 80: 2693,
            320: 2691, 514: 2690, 544: 2690, 96: 2693,
            272: 2691, 1026: 2689, 4112: 2688, 1056: 2689,
            4608: 2688, 4104: 2688, 576: 2690 },
            192: { 768: 3021, 1025: 3020, 2050: 3019, 3: 3027,
            260: 3022, 5: 3026, 6: 3026, 257: 3022,
            264: 3022, 9: 3025, 10: 3025, 3072: 3019,
            12: 3025, 1026: 3020, 4352: 3018, 272: 3022,
            17: 3024, 18: 3024, 20: 3024, 1032: 3020,
            24: 3024, 516: 3021, 1028: 3020, 1040: 3020,
            33: 3023, 34: 3023, 4097: 3018, 2064: 3019,
            40: 3023, 1280: 3020, 48: 3023, 520: 3021,
            513: 3021, 2056: 3019, 2052: 3019, 2080: 3019,
            288: 3022, 4098: 3018, 5120: 3018, 6144: 3018,
            4128: 3018, 258: 3022, 2304: 3019, 1536: 3020,
            514: 3021, 2560: 3019, 544: 3021, 36: 3023,
            528: 3021, 2049: 3019, 4112: 3018, 1056: 3020,
            4608: 3018, 4104: 3018, 4100: 3018 },
            2080: { 384: 2658, 129: 2659, 130: 2659, 3: 2664,
            132: 2659, 5: 2663, 6: 2663, 1025: 2656,
            136: 2659, 9: 2662, 10: 2662, 12: 2662,
            4098: 2655, 516: 2657, 144: 2659, 17: 2661,
            18: 2661, 20: 2661, 1032: 2656, 768: 2657,
            24: 2661, 260: 2658, 640: 2657, 1028: 2656,
            520: 2657, 1040: 2656, 4097: 2655, 5120: 2655,
            1088: 2656, 1152: 2656, 257: 2658, 4160: 2655,
            1280: 2656, 264: 2658, 513: 2657, 1536: 2656,
            4224: 2655, 192: 2659, 65: 2660, 66: 2660,
            68: 2660, 72: 2660, 258: 2658, 4352: 2655,
            528: 2657, 80: 2660, 320: 2658, 514: 2657,
            272: 2658, 1026: 2656, 4112: 2655, 4608: 2655,
            4104: 2655, 576: 2657, 4100: 2655 },
            4098: { 384: 2581, 129: 2582, 132: 2582, 5: 2587,
            260: 2581, 1025: 2579, 136: 2582, 9: 2586,
            12: 2586, 144: 2582, 17: 2585, 20: 2585,
            1032: 2579, 768: 2580, 24: 2585, 516: 2580,
            640: 2580, 1028: 2579, 520: 2580, 1040: 2579,
            33: 2584, 36: 2584, 2064: 2578, 40: 2584,
            1152: 2579, 257: 2581, 1280: 2579, 48: 2584,
            264: 2581, 513: 2580, 2056: 2578, 2052: 2578,
            2080: 2578, 192: 2582, 65: 2583, 68: 2583,
            72: 2583, 1088: 2579, 160: 2582, 2304: 2578,
            288: 2581, 80: 2583, 320: 2581, 2560: 2578,
            544: 2580, 96: 2583, 272: 2581, 2049: 2578,
            3072: 2578, 1056: 2579, 2112: 2578, 1536: 2579,
            2176: 2578, 528: 2580, 576: 2580 },
            6144: { 384: 2470, 1025: 2468, 258: 2470, 3: 2477,
            132: 2471, 5: 2476, 6: 2476, 129: 2471,
            136: 2471, 9: 2475, 10: 2475, 12: 2475,
            514: 2469, 516: 2469, 144: 2471, 17: 2474,
            18: 2474, 20: 2474, 1032: 2468, 768: 2469,
            24: 2474, 260: 2470, 640: 2469, 1028: 2468,
            520: 2469, 1040: 2468, 33: 2473, 34: 2473,
            36: 2473, 40: 2473, 1152: 2468, 257: 2470,
            1280: 2468, 48: 2473, 264: 2470, 513: 2469,
            1536: 2468, 192: 2471, 65: 2472, 66: 2472,
            68: 2472, 130: 2471, 72: 2472, 1088: 2468,
            160: 2471, 288: 2470, 80: 2472, 320: 2470,
            544: 2469, 96: 2472, 272: 2470, 1026: 2468,
            1056: 2468, 528: 2469, 576: 2469 },
            4352: { 640: 2503, 1025: 2502, 2050: 2501, 3: 2510,
            132: 2504, 5: 2509, 6: 2509, 129: 2504,
            136: 2504, 9: 2508, 10: 2508, 12: 2508,
            1026: 2502, 144: 2504, 17: 2507, 18: 2507,
            20: 2507, 1032: 2502, 24: 2507, 516: 2503,
            1028: 2502, 1040: 2502, 33: 2506, 34: 2506,
            36: 2506, 2064: 2501, 40: 2506, 1152: 2502,
            48: 2506, 520: 2503, 513: 2503, 2056: 2501,
            2052: 2501, 2080: 2501, 192: 2504, 65: 2505,
            66: 2505, 68: 2505, 130: 2504, 72: 2505,
            1088: 2502, 160: 2504, 80: 2505, 1536: 2502,
            514: 2503, 2560: 2501, 544: 2503, 96: 2505,
            528: 2503, 2049: 2501, 3072: 2501, 1056: 2502,
            2112: 2501, 2176: 2501, 576: 2503 },
            4100: { 384: 2570, 129: 2571, 2050: 2567, 3: 2576,
            520: 2569, 1025: 2568, 136: 2571, 9: 2575,
            10: 2575, 258: 2570, 144: 2571, 17: 2574,
            18: 2574, 1032: 2568, 24: 2574, 640: 2569,
            768: 2569, 1040: 2568, 33: 2573, 34: 2573,
            2064: 2567, 40: 2573, 1152: 2568, 257: 2570,
            1280: 2568, 48: 2573, 264: 2570, 513: 2569,
            2056: 2567, 2080: 2567, 192: 2571, 65: 2572,
            66: 2572, 130: 2571, 72: 2572, 1088: 2568,
            160: 2571, 2304: 2567, 288: 2570, 80: 2572,
            320: 2570, 514: 2569, 2560: 2567, 544: 2569,
            96: 2572, 272: 2570, 1026: 2568, 2049: 2567,
            3072: 2567, 1056: 2568, 2112: 2567, 1536: 2568,
            2176: 2567, 528: 2569, 576: 2569 },
            256: { 6147: 4214, 6149: 4213, 6150: 4213, 2055: 4303,
            6153: 4212, 6154: 4212, 2059: 4301, 6156: 4212,
            4109: 4255, 4110: 4255, 15: 4422, 6161: 4211,
            6162: 4211, 2067: 4298, 6164: 4211, 2069: 4297,
            2070: 4297, 23: 4419, 6168: 4211, 2073: 4296,
            2074: 4296, 27: 4417, 2076: 4296, 29: 4416,
            30: 4416, 3077: 4267, 6177: 4210, 6178: 4210,
            4131: 4249, 6180: 4210, 2085: 4293, 2086: 4293,
            39: 4413, 6184: 4210, 2089: 4292, 2090: 4292,
            1031: 4339, 2092: 4292, 45: 4410, 46: 4410,
            6192: 4210, 2097: 4291, 2098: 4291, 51: 4408,
            2100: 4291, 53: 4407, 54: 4407, 5129: 4221,
            2104: 4291, 57: 4406, 58: 4406, 60: 4406,
            3082: 4266, 6209: 4209, 6210: 4209, 4163: 4244,
            6212: 4209, 4165: 4243, 2118: 4288, 71: 4403,
            6216: 4209, 2121: 4287, 4170: 4242, 75: 4401,
            4172: 4242, 77: 4400, 78: 4400, 2061: 4300,
            6224: 4209, 4177: 4241, 4178: 4241, 83: 4398,
            2132: 4286, 85: 4397, 86: 4397, 2136: 4286,
            89: 4396, 90: 4396, 92: 4396, 6240: 4209,
            2145: 4285, 2146: 4285, 99: 4394, 2148: 4285,
            101: 4393, 102: 4393, 5137: 4220, 2152: 4285,
            105: 4392, 106: 4392, 108: 4392, 5138: 4220,
            2160: 4285, 113: 4391, 114: 4391, 4115: 4253,
            116: 4391, 5664: 4216, 120: 4391, 5140: 4220,
            4117: 4252, 6273: 4208, 6274: 4208, 2179: 4283,
            6276: 4208, 4118: 4252, 4230: 4237, 135: 4388,
            6280: 4208, 2185: 4281, 2186: 4281, 139: 4386,
            4236: 4236, 141: 4385, 142: 4385, 6288: 4208,
            2193: 4280, 2194: 4280, 147: 4383, 2196: 4280,
            149: 4382, 150: 4382, 4121: 4251, 2200: 4280,
            153: 4381, 154: 4381, 156: 4381, 4122: 4251,
            6304: 4208, 2209: 4279, 2210: 4279, 163: 4379,
            2212: 4279, 165: 4378, 166: 4378, 2216: 4279,
            169: 4377, 170: 4377, 172: 4377, 2224: 4279,
            177: 4376, 178: 4376, 180: 4376, 184: 4376,
            3075: 4268, 2241: 4278, 4290: 4233, 195: 4374,
            2244: 4278, 197: 4373, 198: 4373, 3105: 4264,
            2248: 4278, 201: 4372, 202: 4372, 204: 4372,
            3106: 4264, 2256: 4278, 209: 4371, 210: 4371,
            2083: 4294, 212: 4371, 216: 4371, 5156: 4219,
            4133: 4248, 2272: 4278, 225: 4370, 226: 4370,
            228: 4370, 4134: 4248, 232: 4370, 240: 1604,
            5160: 4219, 4137: 4247, 4138: 4247, 43: 4411,
            4140: 4247, 3078: 4267, 5168: 4219, 4145: 4246,
            4146: 4246, 4148: 4246, 4152: 4246, 4103: 4258,
            5185: 4218, 5186: 4218, 2115: 4289, 5188: 4218,
            2117: 4288, 4166: 4243, 5192: 4218, 4169: 4242,
            2122: 4287, 2124: 4287, 4107: 4256, 5200: 4218,
            2129: 4286, 2062: 4300, 2130: 4286, 4180: 4241,
            6657: 4207, 6658: 4207, 2563: 4276, 6660: 4207,
            2565: 4275, 2566: 4275, 519: 4367, 6664: 4207,
            2569: 4274, 2570: 4274, 523: 4365, 2572: 4274,
            525: 4364, 526: 4364, 6672: 4207, 2577: 4273,
            2578: 4273, 531: 4362, 2580: 4273, 533: 4361,
            534: 4361, 2584: 4273, 537: 4360, 538: 4360,
            540: 4360, 6688: 4207, 4641: 4227, 4642: 4227,
            547: 4358, 2596: 4272, 549: 4357, 550: 4357,
            2600: 4272, 553: 4356, 554: 4356, 556: 4356,
            2608: 4272, 561: 4355, 562: 4355, 564: 4355,
            568: 4355, 6720: 4207, 4673: 4226, 4674: 4226,
            579: 4353, 2628: 4271, 581: 4352, 582: 4352,
            4193: 4240, 2632: 4271, 585: 4351, 586: 4351,
            588: 4351, 4194: 4240, 2640: 4271, 593: 4350,
            594: 4350, 596: 4350, 600: 4350, 4196: 4240,
            2656: 4271, 609: 4349, 610: 4349, 612: 4349,
            616: 4349, 624: 4349, 4200: 4240, 6784: 4207,
            2689: 4270, 4738: 4225, 643: 4347, 2692: 4270,
            645: 4346, 646: 4346, 2696: 4270, 649: 4345,
            650: 4345, 652: 4345, 2704: 4270, 657: 4344,
            658: 4344, 660: 4344, 664: 4344, 2720: 4270,
            673: 4343, 674: 4343, 676: 4343, 680: 4343,
            688: 4343, 2752: 4270, 705: 4342, 706: 4342,
            708: 4342, 712: 4342, 720: 4342, 4184: 4241,
            736: 1603, 5249: 4217, 5250: 4217, 4227: 4238,
            5252: 4217, 4800: 4225, 4229: 4237, 2182: 4282,
            5256: 4217, 4233: 4236, 4234: 4236, 2188: 4281,
            5264: 4217, 4241: 4235, 4242: 4235, 5144: 4220,
            4244: 4235, 5132: 4221, 4248: 4235, 5280: 4217,
            4257: 4234, 4258: 4234, 4124: 4251, 4260: 4234,
            5216: 4218, 4264: 4234, 7169: 4206, 7170: 4206,
            5123: 4223, 7172: 4206, 5125: 4222, 5126: 4222,
            5633: 4216, 7176: 4206, 3081: 4266, 5130: 4221,
            1035: 4337, 3084: 4266, 1037: 4336, 1038: 4336,
            7184: 4206, 3089: 4265, 3090: 4265, 1043: 4334,
            3092: 4265, 1045: 4333, 1046: 4333, 3096: 4265,
            1049: 4332, 1050: 4332, 1052: 4332, 4613: 4230,
            7200: 4206, 5153: 4219, 5154: 4219, 1059: 4330,
            3108: 4264, 1061: 4329, 1062: 4329, 3112: 4264,
            1065: 4328, 1066: 4328, 1068: 4328, 3120: 4264,
            1073: 4327, 1074: 4327, 1076: 4327, 4617: 4229,
            1080: 4327, 4618: 4229, 7232: 4206, 3137: 4263,
            3138: 4263, 1091: 4325, 3140: 4263, 1093: 4324,
            1094: 4324, 3144: 4263, 1097: 4323, 1098: 4323,
            1100: 4323, 3152: 4263, 1105: 4322, 1106: 4322,
            1108: 4322, 1112: 4322, 3168: 4263, 1121: 4321,
            1122: 4321, 1124: 4321, 4625: 4228, 1128: 4321,
            4626: 4228, 1136: 4321, 4628: 4228, 7296: 4206,
            3201: 4262, 3202: 4262, 1155: 4319, 3204: 4262,
            1157: 4318, 1158: 4318, 4289: 4233, 3208: 4262,
            1161: 4317, 1162: 4317, 1164: 4317, 2242: 4278,
            3216: 4262, 1169: 4316, 1170: 4316, 1172: 4316,
            1176: 4316, 4292: 4233, 3232: 4262, 1185: 4315,
            1186: 4315, 1188: 4315, 1192: 4315, 1200: 4315,
            4296: 4233, 3264: 4262, 1217: 4314, 1218: 4314,
            1220: 4314, 2593: 4272, 1224: 4314, 2594: 4272,
            1232: 4314, 4644: 4227, 1248: 4314, 4304: 4233,
            4611: 4231, 4648: 4227, 5634: 4216, 4656: 4227,
            4272: 4234, 5636: 4216, 4320: 4233, 4614: 4230,
            5696: 4216, 2625: 4271, 2626: 4271, 4676: 4226,
            5640: 4216, 4208: 4240, 4680: 4226, 4688: 4226,
            4620: 4229, 7680: 1600, 3585: 4261, 3586: 4261,
            1539: 4312, 3588: 4261, 1541: 4311, 1542: 4311,
            3592: 4261, 1545: 4310, 1546: 4310, 1548: 4310,
            3600: 4261, 1553: 4309, 1554: 4309, 1556: 4309,
            1560: 4309, 3616: 4261, 1569: 4308, 1570: 4308,
            1572: 4308, 1576: 4308, 1584: 4308, 3648: 4261,
            1601: 4307, 1602: 4307, 1604: 4307, 1608: 4307,
            1616: 4307, 1632: 4307, 3712: 1601, 1665: 4306,
            1666: 4306, 1668: 4306, 1672: 4306, 1680: 4306,
            5648: 4216, 1696: 4306, 1728: 1602, 5760: 4216,
            4737: 4225, 2690: 4270, 4740: 4225, 5312: 4217,
            4744: 4225, 6336: 4208, 4752: 4225, 4632: 4228,
            4768: 4225, 4704: 4226, 2181: 4282 },
            640: { 1280: 2844, 1025: 2844, 2050: 2843, 3: 2851,
            260: 2845, 5: 2850, 6: 2850, 257: 2845,
            264: 2845, 9: 2849, 10: 2849, 3072: 2843,
            12: 2849, 4098: 2842, 4352: 2842, 272: 2845,
            17: 2848, 18: 2848, 20: 2848, 24: 2848,
            1028: 2844, 288: 2845, 33: 2847, 34: 2847,
            4097: 2842, 2064: 2843, 40: 2847, 4160: 2842,
            48: 2847, 1032: 2844, 2056: 2843, 2052: 2843,
            2080: 2843, 320: 2845, 65: 2846, 66: 2846,
            68: 2846, 6144: 2842, 4128: 2842, 72: 2846,
            258: 2845, 2304: 2843, 80: 2846, 5120: 2842,
            36: 2847, 96: 2846, 1040: 2844, 1026: 2844,
            2049: 2843, 4112: 2842, 1056: 2844, 2112: 2843,
            1088: 2844, 4104: 2842, 4100: 2842 },
            258: { 640: 2999, 129: 3000, 3072: 2997, 132: 3000,
            5: 3005, 1040: 2998, 1025: 2998, 136: 3000,
            9: 3004, 4224: 2996, 12: 3004, 144: 3000,
            17: 3003, 20: 3003, 1032: 2998, 24: 3003,
            516: 2999, 1028: 2998, 160: 3000, 33: 3002,
            4097: 2996, 2064: 2997, 40: 3002, 1152: 2998,
            4160: 2996, 48: 3002, 520: 2999, 513: 2999,
            2056: 2997, 2052: 2997, 2080: 2997, 192: 3000,
            65: 3001, 68: 3001, 6144: 2996, 4128: 2996,
            72: 3001, 1088: 2998, 80: 3001, 1536: 2998,
            5120: 2996, 2560: 2997, 544: 2999, 36: 3002,
            96: 3001, 528: 2999, 2049: 2997, 4112: 2996,
            1056: 2998, 2112: 2997, 4608: 2996, 2176: 2997,
            4104: 2996, 576: 2999, 4100: 2996 },
            260: { 640: 2988, 129: 2989, 2050: 2986, 3: 2994,
            1040: 2987, 1025: 2987, 136: 2989, 9: 2993,
            10: 2993, 3072: 2986, 1026: 2987, 144: 2989,
            17: 2992, 18: 2992, 1032: 2987, 24: 2992,
            160: 2989, 33: 2991, 34: 2991, 4097: 2985,
            2064: 2986, 40: 2991, 1152: 2987, 4160: 2985,
            48: 2991, 520: 2988, 513: 2988, 2056: 2986,
            4224: 2985, 2080: 2986, 192: 2989, 65: 2990,
            66: 2990, 5120: 2985, 130: 2989, 4128: 2985,
            72: 2990, 1088: 2987, 4098: 2985, 80: 2990,
            1536: 2987, 514: 2988, 2560: 2986, 544: 2988,
            96: 2990, 528: 2988, 2049: 2986, 6144: 2985,
            4112: 2985, 1056: 2987, 2112: 2986, 4608: 2985,
            2176: 2986, 4104: 2985, 576: 2988 },
            264: { 640: 2977, 129: 2978, 2050: 2975, 3: 2983,
            132: 2978, 5: 2982, 6: 2982, 1025: 2976,
            4160: 2974, 4224: 2974, 3072: 2975, 1026: 2976,
            144: 2978, 17: 2981, 18: 2981, 20: 2981,
            4608: 2974, 576: 2977, 516: 2977, 1028: 2976,
            1040: 2976, 33: 2980, 34: 2980, 4097: 2974,
            2064: 2975, 1088: 2976, 1152: 2976, 48: 2980,
            513: 2977, 1536: 2976, 2052: 2975, 2080: 2975,
            192: 2978, 65: 2979, 66: 2979, 68: 2979,
            130: 2978, 4128: 2974, 2112: 2975, 2176: 2975,
            160: 2978, 4098: 2974, 80: 2979, 514: 2977,
            5120: 2974, 2560: 2975, 544: 2977, 36: 2980,
            96: 2979, 528: 2977, 2049: 2975, 6144: 2974,
            4112: 2974, 1056: 2976, 4100: 2974 },
            272: { 640: 2966, 129: 2967, 2050: 2964, 3: 2972,
            132: 2967, 5: 2971, 6: 2971, 1025: 2965,
            136: 2967, 9: 2970, 10: 2970, 12: 2970,
            1026: 2965, 1536: 2965, 1032: 2965, 576: 2966,
            516: 2966, 1028: 2965, 160: 2967, 33: 2969,
            34: 2969, 4097: 2963, 2080: 2964, 40: 2969,
            1152: 2965, 4160: 2963, 520: 2966, 513: 2966,
            2056: 2964, 4224: 2963, 2052: 2964, 192: 2967,
            65: 2968, 66: 2968, 68: 2968, 130: 2967,
            4128: 2963, 72: 2968, 1088: 2965, 4098: 2963,
            514: 2966, 5120: 2963, 2560: 2964, 544: 2966,
            36: 2969, 96: 2968, 2049: 2964, 6144: 2963,
            3072: 2964, 1056: 2965, 2112: 2964, 4608: 2963,
            2176: 2964, 4104: 2963, 4100: 2963 },
            1032: { 384: 2790, 129: 2791, 258: 2790, 3: 2796,
            132: 2791, 5: 2795, 6: 2795, 2049: 2788,
            4160: 2787, 4224: 2787, 288: 2790, 2050: 2788,
            516: 2789, 144: 2791, 17: 2794, 18: 2794,
            20: 2794, 4608: 2787, 576: 2789, 260: 2790,
            640: 2789, 768: 2789, 160: 2791, 33: 2793,
            34: 2793, 4097: 2787, 2064: 2788, 257: 2790,
            48: 2793, 513: 2789, 2052: 2788, 2080: 2788,
            192: 2791, 65: 2792, 66: 2792, 68: 2792,
            130: 2791, 4128: 2787, 2112: 2788, 2176: 2788,
            4352: 2787, 2304: 2788, 4098: 2787, 80: 2792,
            320: 2790, 514: 2789, 2560: 2788, 544: 2789,
            36: 2793, 96: 2792, 272: 2790, 6144: 2787,
            4112: 2787, 528: 2789, 4100: 2787 },
            288: { 640: 2955, 129: 2956, 2050: 2953, 3: 2961,
            132: 2956, 5: 2960, 6: 2960, 1025: 2954,
            136: 2956, 9: 2959, 10: 2959, 3072: 2953,
            12: 2959, 1026: 2954, 144: 2956, 17: 2958,
            18: 2958, 20: 2958, 1032: 2954, 24: 2958,
            516: 2955, 1028: 2954, 1040: 2954, 4097: 2952,
            2064: 2953, 1088: 2954, 1152: 2954, 4160: 2952,
            520: 2955, 513: 2955, 2056: 2953, 4224: 2952,
            2052: 2953, 192: 2956, 65: 2957, 66: 2957,
            68: 2957, 130: 2956, 72: 2957, 2176: 2953,
            4098: 2952, 80: 2957, 1536: 2954, 514: 2955,
            5120: 2952, 2560: 2953, 528: 2955, 2049: 2953,
            6144: 2952, 4112: 2952, 2112: 2953, 4608: 2952,
            4104: 2952, 576: 2955, 4100: 2952 },
            1152: { 768: 2745, 2049: 2744, 2050: 2744, 3: 2752,
            260: 2746, 5: 2751, 6: 2751, 257: 2746,
            264: 2746, 9: 2750, 10: 2750, 12: 2750,
            4098: 2743, 4352: 2743, 272: 2746, 17: 2749,
            18: 2749, 20: 2749, 4608: 2743, 24: 2749,
            516: 2745, 288: 2746, 33: 2748, 34: 2748,
            4097: 2743, 2064: 2744, 40: 2748, 4160: 2743,
            48: 2748, 520: 2745, 513: 2745, 2056: 2744,
            2052: 2744, 2080: 2744, 320: 2746, 65: 2747,
            66: 2747, 68: 2747, 6144: 2743, 4128: 2743,
            72: 2747, 258: 2746, 2304: 2744, 80: 2747,
            514: 2745, 2560: 2744, 544: 2745, 36: 2748,
            96: 2747, 528: 2745, 4112: 2743, 2112: 2744,
            4104: 2743, 576: 2745, 4100: 2743 },
            2056: { 384: 2680, 129: 2681, 258: 2680, 3: 2686,
            132: 2681, 5: 2685, 6: 2685, 1025: 2678,
            4160: 2677, 4224: 2677, 4098: 2677, 516: 2679,
            144: 2681, 17: 2684, 18: 2684, 20: 2684,
            4608: 2677, 768: 2679, 576: 2679, 260: 2680,
            640: 2679, 1028: 2678, 1040: 2678, 33: 2683,
            34: 2683, 4097: 2677, 5120: 2677, 1088: 2678,
            1152: 2678, 257: 2680, 1280: 2678, 48: 2683,
            513: 2679, 1536: 2678, 192: 2681, 65: 2682,
            66: 2682, 68: 2682, 130: 2681, 4128: 2677,
            160: 2681, 288: 2680, 80: 2682, 320: 2680,
            514: 2679, 544: 2679, 36: 2683, 96: 2682,
            272: 2680, 1026: 2678, 4112: 2677, 1056: 2678,
            528: 2679, 4352: 2677, 4100: 2677 },
            320: { 640: 2944, 129: 2945, 2050: 2942, 3: 2950,
            132: 2945, 5: 2949, 6: 2949, 1025: 2943,
            136: 2945, 9: 2948, 10: 2948, 3072: 2942,
            12: 2948, 1026: 2943, 144: 2945, 17: 2947,
            18: 2947, 20: 2947, 1032: 2943, 24: 2947,
            516: 2944, 1028: 2943, 1040: 2943, 33: 2946,
            34: 2946, 4097: 2941, 2064: 2942, 40: 2946,
            1152: 2943, 48: 2946, 520: 2944, 513: 2944,
            2056: 2942, 4224: 2941, 2052: 2942, 2080: 2942,
            160: 2945, 4098: 2941, 5120: 2941, 130: 2945,
            4128: 2941, 2176: 2942, 1536: 2943, 514: 2944,
            2560: 2942, 544: 2944, 36: 2946, 528: 2944,
            2049: 2942, 6144: 2941, 4112: 2941, 1056: 2943,
            4608: 2941, 4104: 2941, 4100: 2941 },
            2176: { 768: 2635, 1025: 2634, 4098: 2633, 3: 2642,
            260: 2636, 5: 2641, 6: 2641, 257: 2636,
            264: 2636, 9: 2640, 10: 2640, 12: 2640,
            258: 2636, 4352: 2633, 272: 2636, 17: 2639,
            18: 2639, 20: 2639, 1032: 2634, 24: 2639,
            516: 2635, 1028: 2634, 1040: 2634, 33: 2638,
            34: 2638, 4097: 2633, 5120: 2633, 40: 2638,
            4160: 2633, 1280: 2634, 48: 2638, 520: 2635,
            513: 2635, 1536: 2634, 320: 2636, 65: 2637,
            66: 2637, 68: 2637, 4128: 2633, 72: 2637,
            1088: 2634, 288: 2636, 80: 2637, 514: 2635,
            544: 2635, 36: 2638, 96: 2637, 528: 2635,
            1026: 2634, 4112: 2633, 1056: 2634, 4608: 2633,
            4104: 2633, 576: 2635, 4100: 2633 },
            1025: { 384: 2823, 320: 2823, 2050: 2821, 4100: 2820,
            6: 2829, 2080: 2821, 136: 2824, 10: 2828,
            132: 2824, 12: 2828, 4098: 2820, 4352: 2820,
            144: 2824, 18: 2827, 20: 2827, 4608: 2820,
            24: 2827, 516: 2822, 640: 2822, 520: 2822,
            768: 2822, 260: 2823, 160: 2824, 34: 2826,
            36: 2826, 2064: 2821, 40: 2826, 4160: 2820,
            48: 2826, 264: 2823, 2056: 2821, 4224: 2820,
            2052: 2821, 192: 2824, 288: 2823, 66: 2825,
            68: 2825, 130: 2824, 4128: 2820, 72: 2825,
            258: 2823, 2304: 2821, 528: 2822, 80: 2825,
            514: 2822, 2560: 2821, 544: 2822, 96: 2825,
            272: 2823, 6144: 2820, 4112: 2820, 2112: 2821,
            2176: 2821, 4104: 2820, 576: 2822 },
            4104: { 384: 2559, 129: 2560, 258: 2559, 3: 2565,
            132: 2560, 5: 2564, 6: 2564, 1025: 2557,
            2050: 2556, 516: 2558, 144: 2560, 17: 2563,
            18: 2563, 20: 2563, 768: 2558, 576: 2558,
            260: 2559, 640: 2558, 1028: 2557, 1040: 2557,
            33: 2562, 34: 2562, 36: 2562, 2064: 2556,
            1088: 2557, 1152: 2557, 257: 2559, 1280: 2557,
            48: 2562, 513: 2558, 1536: 2557, 2052: 2556,
            2080: 2556, 192: 2560, 65: 2561, 66: 2561,
            68: 2561, 130: 2560, 2112: 2556, 2176: 2556,
            160: 2560, 2304: 2556, 288: 2559, 80: 2561,
            320: 2559, 514: 2558, 2560: 2556, 544: 2558,
            96: 2561, 272: 2559, 1026: 2557, 2049: 2556,
            3072: 2556, 1056: 2557, 528: 2558 },
            384: { 1536: 2932, 1025: 2932, 2050: 2931, 3: 2939,
            516: 2933, 5: 2938, 6: 2938, 513: 2933,
            520: 2933, 9: 2937, 10: 2937, 3072: 2931,
            12: 2937, 1026: 2932, 528: 2933, 17: 2936,
            18: 2936, 20: 2936, 4608: 2930, 24: 2936,
            1028: 2932, 544: 2933, 33: 2935, 34: 2935,
            4097: 2930, 2064: 2931, 40: 2935, 4160: 2930,
            48: 2935, 1032: 2932, 2056: 2931, 2052: 2931,
            2080: 2931, 576: 2933, 65: 2934, 66: 2934,
            68: 2934, 6144: 2930, 4128: 2930, 72: 2934,
            1088: 2932, 4098: 2930, 80: 2934, 514: 2933,
            5120: 2930, 2560: 2931, 36: 2935, 96: 2934,
            1040: 2932, 2049: 2931, 4112: 2930, 1056: 2932,
            2112: 2931, 4104: 2930, 4100: 2930 },
            64: { 6147: 4654, 6149: 4653, 6150: 4653, 2055: 4743,
            6153: 4652, 6154: 4652, 2059: 4741, 6156: 4652,
            4109: 4695, 4110: 4695, 15: 4862, 6161: 4651,
            6162: 4651, 2067: 4738, 6164: 4651, 2069: 4737,
            2070: 4737, 23: 4859, 6168: 4651, 2073: 4736,
            2074: 4736, 27: 4857, 4124: 4691, 29: 4856,
            30: 4856, 5125: 4662, 6177: 4650, 6178: 4650,
            4131: 4689, 6180: 4650, 2085: 4733, 2086: 4733,
            39: 4853, 6184: 4650, 4137: 4687, 2090: 4732,
            43: 4851, 2092: 4732, 45: 4850, 46: 4850,
            4992: 4665, 6192: 4650, 2097: 4731, 4146: 4686,
            51: 4848, 2100: 4731, 53: 4847, 54: 4847,
            5129: 4661, 2104: 4731, 57: 4846, 58: 4846,
            60: 1606, 5130: 4661, 4107: 4696, 5132: 4661,
            1037: 4776, 2062: 4740, 5137: 4660, 5138: 4660,
            4115: 4693, 5140: 4660, 4117: 4692, 6273: 4649,
            6274: 4649, 2179: 4729, 6276: 4649, 4118: 4692,
            4230: 4683, 135: 4843, 6280: 4649, 2185: 4727,
            2186: 4727, 139: 4841, 4236: 4682, 141: 4840,
            142: 4840, 4488: 4673, 6288: 4649, 2193: 4726,
            2194: 4726, 147: 4838, 2196: 4726, 149: 4837,
            150: 4837, 4121: 4691, 2200: 4726, 153: 4836,
            154: 4836, 156: 4836, 4122: 4691, 6304: 4649,
            2209: 4725, 2210: 4725, 163: 4834, 2212: 4725,
            165: 4833, 166: 4833, 2216: 4725, 169: 4832,
            170: 4832, 172: 4832, 2224: 4725, 177: 4831,
            178: 4831, 180: 4831, 184: 1605, 3075: 4708,
            3105: 4704, 3106: 4704, 2083: 4734, 5156: 4659,
            4133: 4688, 4134: 4688, 5160: 4659, 2089: 4732,
            1031: 4779, 4138: 4687, 6401: 4648, 6402: 4648,
            2307: 4723, 6404: 4648, 4357: 4677, 2310: 4722,
            263: 4828, 6408: 4648, 2313: 4721, 2314: 4721,
            267: 4826, 2316: 4721, 269: 4825, 270: 4825,
            6416: 4648, 2321: 4720, 2322: 4720, 275: 4823,
            4372: 4675, 277: 4822, 278: 4822, 2328: 4720,
            281: 4821, 282: 4821, 284: 4821, 6432: 4648,
            4385: 4674, 2338: 4719, 291: 4819, 2340: 4719,
            293: 4818, 294: 4818, 4145: 4686, 2344: 4719,
            297: 4817, 298: 4817, 300: 4817, 2098: 4731,
            2352: 4719, 305: 4816, 306: 4816, 308: 4816,
            312: 4816, 4148: 4686, 4152: 4686, 4103: 4698,
            4496: 4673, 6528: 4648, 2433: 4718, 2434: 4718,
            387: 4814, 2436: 4718, 389: 4813, 390: 4813,
            2440: 4718, 393: 4812, 394: 4812, 396: 4812,
            2448: 4718, 401: 4811, 402: 4811, 404: 4811,
            408: 4811, 2464: 4718, 417: 4810, 418: 4810,
            420: 4810, 424: 4810, 432: 1604, 4512: 4673,
            4872: 4665, 2061: 4740, 6657: 4647, 6658: 4647,
            2563: 4716, 6660: 4647, 2565: 4715, 2566: 4715,
            519: 4807, 6664: 4647, 2569: 4714, 2570: 4714,
            523: 4805, 2572: 4714, 525: 4804, 526: 4804,
            6672: 4647, 2577: 4713, 2578: 4713, 531: 4802,
            2580: 4713, 533: 4801, 534: 4801, 2584: 4713,
            537: 4800, 538: 4800, 540: 4800, 6688: 4647,
            4641: 4667, 2594: 4712, 547: 4798, 2596: 4712,
            549: 4797, 550: 4797, 2600: 4712, 553: 4796,
            554: 4796, 556: 4796, 2608: 4712, 561: 4795,
            562: 4795, 564: 4795, 4656: 4667, 568: 4795,
            4880: 4665, 6784: 4647, 2689: 4711, 2690: 4711,
            643: 4793, 2692: 4711, 645: 4792, 646: 4792,
            2696: 4711, 649: 4791, 650: 4791, 652: 4791,
            2704: 4711, 657: 4790, 658: 4790, 660: 4790,
            664: 4790, 2818: 4710, 2720: 4711, 673: 4789,
            674: 4789, 676: 4789, 680: 4789, 688: 4789,
            4865: 4665, 5888: 4656, 4896: 4665, 6912: 4647,
            2817: 4710, 4866: 4665, 771: 4787, 2820: 4710,
            773: 4786, 774: 4786, 5249: 4658, 2824: 4710,
            777: 4785, 778: 4785, 780: 4785, 5250: 4658,
            2832: 4710, 785: 4784, 786: 4784, 4227: 4684,
            788: 4784, 4868: 4665, 792: 4784, 5252: 4658,
            4229: 4683, 2848: 4710, 801: 4783, 802: 4783,
            804: 4783, 2182: 4728, 808: 4783, 816: 4783,
            5256: 4658, 4233: 4682, 4234: 4682, 2188: 4727,
            5264: 4658, 4241: 4681, 4242: 4681, 5144: 4660,
            4244: 4681, 2944: 4710, 897: 4782, 898: 4782,
            900: 4782, 904: 4782, 2076: 4736, 912: 4782,
            4248: 4681, 928: 1603, 5760: 4656, 5280: 4658,
            4257: 4680, 4258: 4680, 4260: 4680, 4264: 4680,
            7169: 4646, 7170: 4646, 5123: 4663, 7172: 4646,
            3077: 4707, 5126: 4662, 5633: 4656, 7176: 4646,
            3081: 4706, 3082: 4706, 1035: 4777, 3084: 4706,
            3586: 4701, 1038: 4776, 7184: 4646, 3089: 4705,
            3090: 4705, 1043: 4774, 3092: 4705, 1045: 4773,
            1046: 4773, 3096: 4705, 1049: 4772, 1050: 4772,
            1052: 4772, 4613: 4670, 7200: 4646, 5153: 4659,
            5154: 4659, 1059: 4770, 3108: 4704, 1061: 4769,
            1062: 4769, 3112: 4704, 1065: 4768, 1066: 4768,
            1068: 4768, 3120: 4704, 1073: 4767, 1074: 4767,
            1076: 4767, 4617: 4669, 1080: 4767, 4618: 4669,
            4620: 4669, 5648: 4656, 4625: 4668, 4626: 4668,
            4628: 4668, 7296: 4646, 3201: 4703, 3202: 4703,
            1155: 4765, 3204: 4703, 1157: 4764, 1158: 4764,
            3208: 4703, 1161: 4763, 1162: 4763, 1164: 4763,
            3216: 4703, 1169: 4762, 1170: 4762, 1172: 4762,
            1176: 4762, 3232: 4703, 1185: 4761, 1186: 4761,
            1188: 4761, 1192: 4761, 1200: 4761, 5664: 4656,
            2593: 4712, 4642: 4667, 4644: 4667, 4611: 4671,
            4648: 4667, 7424: 4646, 5377: 4657, 5378: 4657,
            1283: 4759, 3332: 4702, 1285: 4758, 1286: 4758,
            3336: 4702, 1289: 4757, 1290: 4757, 1292: 4757,
            3344: 4702, 1297: 4756, 1298: 4756, 1300: 4756,
            1304: 4756, 3360: 4702, 1313: 4755, 1314: 4755,
            1316: 4755, 1320: 4755, 4272: 4680, 5636: 4656,
            1328: 4755, 4614: 4670, 3456: 4702, 1409: 4754,
            1410: 4754, 1412: 4754, 3078: 4707, 1416: 4754,
            1424: 4754, 1440: 4754, 5640: 4656, 4140: 4687,
            4481: 4673, 5504: 4657, 4482: 4673, 7680: 4646,
            3585: 4701, 5634: 4656, 1539: 4752, 3588: 4701,
            1541: 4751, 1542: 4751, 3329: 4702, 3592: 4701,
            1545: 4750, 1546: 4750, 1548: 4750, 3330: 4702,
            3600: 4701, 1553: 4749, 1554: 4749, 4355: 4678,
            1556: 4749, 1560: 4749, 5380: 4657, 2309: 4722,
            3616: 4701, 1569: 4748, 1570: 4748, 1572: 4748,
            4358: 4677, 1576: 4748, 1584: 4748, 5384: 4657,
            4361: 4676, 4362: 4676, 5168: 4659, 4364: 4676,
            5392: 4657, 4369: 4675, 4370: 4675, 2324: 4720,
            3712: 4701, 1665: 4747, 1666: 4747, 1668: 4747,
            1672: 4747, 1680: 4747, 4376: 4675, 1696: 4747,
            5408: 4657, 2337: 4719, 4386: 4674, 4388: 4674,
            4392: 4674, 3840: 4701, 1793: 4746, 1794: 4746,
            1796: 4746, 4737: 4666, 1800: 4746, 4738: 4666,
            1808: 4746, 4484: 4673, 4740: 4666, 1824: 4746,
            4400: 4674, 4744: 4666, 4752: 4666, 4632: 4668,
            1920: 1602, 4768: 4666, 2181: 4728 },
            4224: { 768: 2514, 1025: 2513, 2050: 2512, 3: 2521,
            260: 2515, 5: 2520, 6: 2520, 257: 2515,
            264: 2515, 9: 2519, 10: 2519, 12: 2519,
            258: 2515, 272: 2515, 17: 2518, 18: 2518,
            20: 2518, 1032: 2513, 24: 2518, 516: 2514,
            1028: 2513, 1040: 2513, 33: 2517, 34: 2517,
            36: 2517, 2064: 2512, 40: 2517, 1280: 2513,
            48: 2517, 520: 2514, 513: 2514, 2056: 2512,
            2052: 2512, 2080: 2512, 320: 2515, 65: 2516,
            66: 2516, 68: 2516, 72: 2516, 1088: 2513,
            2304: 2512, 288: 2515, 80: 2516, 1536: 2513,
            514: 2514, 2560: 2512, 544: 2514, 96: 2516,
            528: 2514, 1026: 2513, 2049: 2512, 3072: 2512,
            1056: 2513, 2112: 2512, 576: 2514 },
            576: { 384: 2856, 129: 2857, 2050: 2854, 3: 2862,
            132: 2857, 5: 2861, 6: 2861, 1025: 2855,
            136: 2857, 9: 2860, 10: 2860, 3072: 2854,
            12: 2860, 130: 2857, 4352: 2853, 144: 2857,
            17: 2859, 18: 2859, 20: 2859, 1032: 2855,
            24: 2859, 260: 2856, 1028: 2855, 1040: 2855,
            33: 2858, 34: 2858, 4097: 2853, 2064: 2854,
            40: 2858, 1152: 2855, 257: 2856, 1280: 2855,
            48: 2858, 264: 2856, 2056: 2854, 4224: 2853,
            2052: 2854, 2080: 2854, 160: 2857, 4098: 2853,
            5120: 2853, 6144: 2853, 4128: 2853, 258: 2856,
            2304: 2854, 288: 2856, 36: 2858, 272: 2856,
            1026: 2855, 2049: 2854, 4112: 2853, 1056: 2855,
            2176: 2854, 4104: 2853, 4100: 2853 },
            1088: { 384: 2757, 129: 2758, 2050: 2755, 3: 2763,
            132: 2758, 5: 2762, 6: 2762, 2049: 2755,
            136: 2758, 9: 2761, 10: 2761, 12: 2761,
            130: 2758, 516: 2756, 144: 2758, 17: 2760,
            18: 2760, 20: 2760, 4608: 2754, 24: 2760,
            260: 2757, 640: 2756, 768: 2756, 520: 2756,
            160: 2758, 33: 2759, 34: 2759, 4097: 2754,
            2064: 2755, 40: 2759, 257: 2757, 48: 2759,
            264: 2757, 513: 2756, 2056: 2755, 4224: 2754,
            2052: 2755, 2080: 2755, 288: 2757, 4098: 2754,
            6144: 2754, 4128: 2754, 258: 2757, 4352: 2754,
            2304: 2755, 528: 2756, 514: 2756, 2560: 2755,
            544: 2756, 36: 2759, 272: 2757, 4112: 2754,
            2176: 2755, 4104: 2754, 4100: 2754 },
            2064: { 384: 2669, 129: 2670, 4098: 2666, 3: 2675,
            132: 2670, 5: 2674, 6: 2674, 1025: 2667,
            136: 2670, 9: 2673, 10: 2673, 12: 2673,
            514: 2668, 516: 2668, 320: 2669, 1032: 2667,
            768: 2668, 576: 2668, 260: 2669, 640: 2668,
            1028: 2667, 520: 2668, 160: 2670, 33: 2672,
            34: 2672, 4097: 2666, 5120: 2666, 40: 2672,
            1152: 2667, 257: 2669, 4160: 2666, 1280: 2667,
            264: 2669, 513: 2668, 1536: 2667, 4224: 2666,
            192: 2670, 65: 2671, 66: 2671, 68: 2671,
            130: 2670, 4128: 2666, 72: 2671, 258: 2669,
            4352: 2666, 288: 2669, 544: 2668, 36: 2672,
            4608: 2666, 96: 2671, 1026: 2667, 1056: 2667,
            1088: 2667, 4104: 2666, 4100: 2666 },
            2112: { 384: 2647, 129: 2648, 130: 2648, 3: 2653,
            132: 2648, 5: 2652, 6: 2652, 1025: 2645,
            136: 2648, 9: 2651, 10: 2651, 12: 2651,
            4098: 2644, 516: 2646, 144: 2648, 17: 2650,
            18: 2650, 20: 2650, 1032: 2645, 768: 2646,
            24: 2650, 260: 2647, 640: 2646, 1028: 2645,
            520: 2646, 1040: 2645, 33: 2649, 34: 2649,
            4097: 2644, 5120: 2644, 40: 2649, 1152: 2645,
            257: 2647, 1280: 2645, 48: 2649, 264: 2647,
            513: 2646, 1536: 2645, 4224: 2644, 288: 2647,
            160: 2648, 4128: 2644, 258: 2647, 4352: 2644,
            528: 2646, 514: 2646, 544: 2646, 36: 2649,
            272: 2647, 1026: 2645, 4112: 2644, 1056: 2645,
            4608: 2644, 4104: 2644, 4100: 2644 },
            544: { 384: 2867, 129: 2868, 2050: 2865, 3: 2873,
            132: 2868, 5: 2872, 6: 2872, 1025: 2866,
            136: 2868, 9: 2871, 10: 2871, 3072: 2865,
            12: 2871, 130: 2868, 4352: 2864, 144: 2868,
            17: 2870, 18: 2870, 20: 2870, 1032: 2866,
            24: 2870, 260: 2867, 1028: 2866, 1040: 2866,
            4097: 2864, 2064: 2865, 1088: 2866, 1152: 2866,
            257: 2867, 4160: 2864, 1280: 2866, 264: 2867,
            2056: 2865, 4224: 2864, 2052: 2865, 192: 2868,
            65: 2869, 66: 2869, 68: 2869, 6144: 2864,
            72: 2869, 258: 2867, 2304: 2865, 4098: 2864,
            80: 2869, 320: 2867, 5120: 2864, 272: 2867,
            1026: 2866, 2049: 2865, 4112: 2864, 2112: 2865,
            2176: 2865, 4104: 2864, 4100: 2864 },
            1056: { 384: 2768, 129: 2769, 2050: 2766, 3: 2774,
            132: 2769, 5: 2773, 6: 2773, 2049: 2766,
            136: 2769, 9: 2772, 10: 2772, 12: 2772,
            130: 2769, 516: 2767, 144: 2769, 17: 2771,
            18: 2771, 20: 2771, 4608: 2765, 24: 2771,
            260: 2768, 640: 2767, 768: 2767, 520: 2767,
            4097: 2765, 2064: 2766, 257: 2768, 4160: 2765,
            264: 2768, 513: 2767, 2056: 2766, 4224: 2765,
            528: 2767, 2052: 2766, 192: 2769, 65: 2770,
            66: 2770, 68: 2770, 6144: 2765, 72: 2770,
            258: 2768, 4352: 2765, 2304: 2766, 4098: 2765,
            80: 2770, 320: 2768, 514: 2767, 2560: 2766,
            272: 2768, 4112: 2765, 2112: 2766, 2176: 2766,
            4104: 2765, 576: 2767, 4100: 2765 }
        }
    
    class Seven:
        card_to_binary = [[], [],
            [0, 73730, 77826, 86018, 94210],
            [0, 139523, 143619, 151811, 160003],
            [0, 270853, 274949, 283141, 291333],
            [0, 533255, 537351, 545543, 553735],
            [0, 1057803, 1061899, 1070091, 1078283],
            [0, 2106637, 2110733, 2118925, 2127117],
            [0, 4204049, 4208145, 4216337, 4224529],
            [0, 8398611, 8402707, 8410899, 8419091],
            [0, 16787479, 16791575, 16799767, 16807959],
            [0, 33564957, 33569053, 33577245, 33585437],
            [0, 67119647, 67123743, 67131935, 67140127],
            [0, 134228773, 134232869, 134241061, 134249253],
            [0, 268446761, 268450857, 268459049, 268467241]
        ]
        prime_products_to_flush = {
            128: 2, 192: 2, 288: 2, 320: 2, 448: 2, 480: 2, 672: 2, 800: 2, 1120: 2, 1568: 2,
            972: 3, 1458: 3, 2187: 3, 2430: 3, 3402: 3, 3645: 3, 5103: 3, 6075: 3, 8505: 3, 11907: 3,
            12500: 5, 18750: 5, 28125: 5, 31250: 5, 43750: 5, 46875: 5, 65625: 5, 78125: 5, 109375: 5, 153125: 5,
            67228: 7, 100842: 7, 151263: 7, 168070: 7, 235298: 7, 252105: 7, 352947: 7, 420175: 7, 588245: 7, 823543: 7
        }
        flush_rank_bits_to_rank = {
            31: 9, 47: 1599, 55: 1598, 59: 1597,
            61: 1596, 62: 8, 63: 8, 79: 1595,
            87: 1594, 91: 1593, 93: 1592, 94: 1591,
            95: 9, 103: 1590, 107: 1589, 109: 1588,
            110: 1587, 111: 1587, 115: 1586, 117: 1585,
            118: 1584, 119: 1584, 121: 1583, 122: 1582,
            123: 1582, 124: 7, 125: 7, 126: 7,
            127: 7, 143: 1581, 151: 1580, 155: 1579,
            157: 1578, 158: 1577, 159: 9, 167: 1576,
            171: 1575, 173: 1574, 174: 1573, 175: 1573,
            179: 1572, 181: 1571, 182: 1570, 183: 1570,
            185: 1569, 186: 1568, 187: 1568, 188: 1567,
            189: 1567, 190: 8, 191: 8, 199: 1566,
            203: 1565, 205: 1564, 206: 1563, 207: 1563,
            211: 1562, 213: 1561, 214: 1560, 215: 1560,
            217: 1559, 218: 1558, 219: 1558, 220: 1557,
            221: 1557, 222: 1557, 223: 9, 227: 1556,
            229: 1555, 230: 1554, 231: 1554, 233: 1553,
            234: 1552, 235: 1552, 236: 1551, 237: 1551,
            238: 1551, 239: 1551, 241: 1550, 242: 1549,
            243: 1549, 244: 1548, 245: 1548, 246: 1548,
            247: 1548, 248: 6, 249: 6, 250: 6,
            251: 6, 252: 6, 253: 6, 254: 6,
            271: 1547, 279: 1546, 283: 1545, 285: 1544,
            286: 1543, 287: 9, 295: 1542, 299: 1541,
            301: 1540, 302: 1539, 303: 1539, 307: 1538,
            309: 1537, 310: 1536, 311: 1536, 313: 1535,
            314: 1534, 315: 1534, 316: 1533, 317: 1533,
            318: 8, 319: 8, 327: 1532, 331: 1531,
            333: 1530, 334: 1529, 335: 1529, 339: 1528,
            341: 1527, 342: 1526, 343: 1526, 345: 1525,
            346: 1524, 347: 1524, 348: 1523, 349: 1523,
            350: 1523, 351: 9, 355: 1522, 357: 1521,
            358: 1520, 359: 1520, 361: 1519, 362: 1518,
            363: 1518, 364: 1517, 365: 1517, 366: 1517,
            367: 1517, 369: 1516, 370: 1515, 371: 1515,
            372: 1514, 373: 1514, 374: 1514, 375: 1514,
            376: 1513, 377: 1513, 378: 1513, 379: 1513,
            380: 7, 381: 7, 382: 7, 391: 1512,
            395: 1511, 397: 1510, 398: 1509, 399: 1509,
            403: 1508, 405: 1507, 406: 1506, 407: 1506,
            409: 1505, 410: 1504, 411: 1504, 412: 1503,
            413: 1503, 414: 1503, 415: 9, 419: 1502,
            421: 1501, 422: 1500, 423: 1500, 425: 1499,
            426: 1498, 427: 1498, 428: 1497, 429: 1497,
            430: 1497, 431: 1497, 433: 1496, 434: 1495,
            435: 1495, 436: 1494, 437: 1494, 438: 1494,
            439: 1494, 440: 1493, 441: 1493, 442: 1493,
            443: 1493, 444: 1493, 445: 1493, 446: 8,
            451: 1492, 453: 1491, 454: 1490, 455: 1490,
            457: 1489, 458: 1488, 459: 1488, 460: 1487,
            461: 1487, 462: 1487, 463: 1487, 465: 1486,
            466: 1485, 467: 1485, 468: 1484, 469: 1484,
            470: 1484, 471: 1484, 472: 1483, 473: 1483,
            474: 1483, 475: 1483, 476: 1483, 477: 1483,
            478: 1483, 481: 1482, 482: 1481, 483: 1481,
            484: 1480, 485: 1480, 486: 1480, 487: 1480,
            488: 1479, 489: 1479, 490: 1479, 491: 1479,
            492: 1479, 493: 1479, 494: 1479, 496: 5,
            497: 5, 498: 5, 499: 5, 500: 5,
            501: 5, 502: 5, 504: 5, 505: 5,
            506: 5, 508: 5, 527: 1478, 535: 1477,
            539: 1476, 541: 1475, 542: 1474, 543: 9,
            551: 1473, 555: 1472, 557: 1471, 558: 1470,
            559: 1470, 563: 1469, 565: 1468, 566: 1467,
            567: 1467, 569: 1466, 570: 1465, 571: 1465,
            572: 1464, 573: 1464, 574: 8, 575: 8,
            583: 1463, 587: 1462, 589: 1461, 590: 1460,
            591: 1460, 595: 1459, 597: 1458, 598: 1457,
            599: 1457, 601: 1456, 602: 1455, 603: 1455,
            604: 1454, 605: 1454, 606: 1454, 607: 9,
            611: 1453, 613: 1452, 614: 1451, 615: 1451,
            617: 1450, 618: 1449, 619: 1449, 620: 1448,
            621: 1448, 622: 1448, 623: 1448, 625: 1447,
            626: 1446, 627: 1446, 628: 1445, 629: 1445,
            630: 1445, 631: 1445, 632: 1444, 633: 1444,
            634: 1444, 635: 1444, 636: 7, 637: 7,
            638: 7, 647: 1443, 651: 1442, 653: 1441,
            654: 1440, 655: 1440, 659: 1439, 661: 1438,
            662: 1437, 663: 1437, 665: 1436, 666: 1435,
            667: 1435, 668: 1434, 669: 1434, 670: 1434,
            671: 9, 675: 1433, 677: 1432, 678: 1431,
            679: 1431, 681: 1430, 682: 1429, 683: 1429,
            684: 1428, 685: 1428, 686: 1428, 687: 1428,
            689: 1427, 690: 1426, 691: 1426, 692: 1425,
            693: 1425, 694: 1425, 695: 1425, 696: 1424,
            697: 1424, 698: 1424, 699: 1424, 700: 1424,
            701: 1424, 702: 8, 707: 1423, 709: 1422,
            710: 1421, 711: 1421, 713: 1420, 714: 1419,
            715: 1419, 716: 1418, 717: 1418, 718: 1418,
            719: 1418, 721: 1417, 722: 1416, 723: 1416,
            724: 1415, 725: 1415, 726: 1415, 727: 1415,
            728: 1414, 729: 1414, 730: 1414, 731: 1414,
            732: 1414, 733: 1414, 734: 1414, 737: 1413,
            738: 1412, 739: 1412, 740: 1411, 741: 1411,
            742: 1411, 743: 1411, 744: 1410, 745: 1410,
            746: 1410, 747: 1410, 748: 1410, 749: 1410,
            750: 1410, 752: 1409, 753: 1409, 754: 1409,
            755: 1409, 756: 1409, 757: 1409, 758: 1409,
            760: 6, 761: 6, 762: 6, 764: 6,
            775: 1408, 779: 1407, 781: 1406, 782: 1405,
            783: 1405, 787: 1404, 789: 1403, 790: 1402,
            791: 1402, 793: 1401, 794: 1400, 795: 1400,
            796: 1399, 797: 1399, 798: 1399, 799: 9,
            803: 1398, 805: 1397, 806: 1396, 807: 1396,
            809: 1395, 810: 1394, 811: 1394, 812: 1393,
            813: 1393, 814: 1393, 815: 1393, 817: 1392,
            818: 1391, 819: 1391, 820: 1390, 821: 1390,
            822: 1390, 823: 1390, 824: 1389, 825: 1389,
            826: 1389, 827: 1389, 828: 1389, 829: 1389,
            830: 8, 835: 1388, 837: 1387, 838: 1386,
            839: 1386, 841: 1385, 842: 1384, 843: 1384,
            844: 1383, 845: 1383, 846: 1383, 847: 1383,
            849: 1382, 850: 1381, 851: 1381, 852: 1380,
            853: 1380, 854: 1380, 855: 1380, 856: 1379,
            857: 1379, 858: 1379, 859: 1379, 860: 1379,
            861: 1379, 862: 1379, 865: 1378, 866: 1377,
            867: 1377, 868: 1376, 869: 1376, 870: 1376,
            871: 1376, 872: 1375, 873: 1375, 874: 1375,
            875: 1375, 876: 1375, 877: 1375, 878: 1375,
            880: 1374, 881: 1374, 882: 1374, 883: 1374,
            884: 1374, 885: 1374, 886: 1374, 888: 1374,
            889: 1374, 890: 1374, 892: 7, 899: 1373,
            901: 1372, 902: 1371, 903: 1371, 905: 1370,
            906: 1369, 907: 1369, 908: 1368, 909: 1368,
            910: 1368, 911: 1368, 913: 1367, 914: 1366,
            915: 1366, 916: 1365, 917: 1365, 918: 1365,
            919: 1365, 920: 1364, 921: 1364, 922: 1364,
            923: 1364, 924: 1364, 925: 1364, 926: 1364,
            929: 1363, 930: 1362, 931: 1362, 932: 1361,
            933: 1361, 934: 1361, 935: 1361, 936: 1360,
            937: 1360, 938: 1360, 939: 1360, 940: 1360,
            941: 1360, 942: 1360, 944: 1359, 945: 1359,
            946: 1359, 947: 1359, 948: 1359, 949: 1359,
            950: 1359, 952: 1359, 953: 1359, 954: 1359,
            956: 1359, 961: 1358, 962: 1357, 963: 1357,
            964: 1356, 965: 1356, 966: 1356, 967: 1356,
            968: 1355, 969: 1355, 970: 1355, 971: 1355,
            972: 1355, 973: 1355, 974: 1355, 976: 1354,
            977: 1354, 978: 1354, 979: 1354, 980: 1354,
            981: 1354, 982: 1354, 984: 1354, 985: 1354,
            986: 1354, 988: 1354, 992: 4, 993: 4,
            994: 4, 995: 4, 996: 4, 997: 4,
            998: 4, 1000: 4, 1001: 4, 1002: 4,
            1004: 4, 1008: 4, 1009: 4, 1010: 4,
            1012: 4, 1016: 4, 1039: 1353, 1047: 1352,
            1051: 1351, 1053: 1350, 1054: 1349, 1055: 9,
            1063: 1348, 1067: 1347, 1069: 1346, 1070: 1345,
            1071: 1345, 1075: 1344, 1077: 1343, 1078: 1342,
            1079: 1342, 1081: 1341, 1082: 1340, 1083: 1340,
            1084: 1339, 1085: 1339, 1086: 8, 1087: 8,
            1095: 1338, 1099: 1337, 1101: 1336, 1102: 1335,
            1103: 1335, 1107: 1334, 1109: 1333, 1110: 1332,
            1111: 1332, 1113: 1331, 1114: 1330, 1115: 1330,
            1116: 1329, 1117: 1329, 1118: 1329, 1119: 9,
            1123: 1328, 1125: 1327, 1126: 1326, 1127: 1326,
            1129: 1325, 1130: 1324, 1131: 1324, 1132: 1323,
            1133: 1323, 1134: 1323, 1135: 1323, 1137: 1322,
            1138: 1321, 1139: 1321, 1140: 1320, 1141: 1320,
            1142: 1320, 1143: 1320, 1144: 1319, 1145: 1319,
            1146: 1319, 1147: 1319, 1148: 7, 1149: 7,
            1150: 7, 1159: 1318, 1163: 1317, 1165: 1316,
            1166: 1315, 1167: 1315, 1171: 1314, 1173: 1313,
            1174: 1312, 1175: 1312, 1177: 1311, 1178: 1310,
            1179: 1310, 1180: 1309, 1181: 1309, 1182: 1309,
            1183: 9, 1187: 1308, 1189: 1307, 1190: 1306,
            1191: 1306, 1193: 1305, 1194: 1304, 1195: 1304,
            1196: 1303, 1197: 1303, 1198: 1303, 1199: 1303,
            1201: 1302, 1202: 1301, 1203: 1301, 1204: 1300,
            1205: 1300, 1206: 1300, 1207: 1300, 1208: 1299,
            1209: 1299, 1210: 1299, 1211: 1299, 1212: 1299,
            1213: 1299, 1214: 8, 1219: 1298, 1221: 1297,
            1222: 1296, 1223: 1296, 1225: 1295, 1226: 1294,
            1227: 1294, 1228: 1293, 1229: 1293, 1230: 1293,
            1231: 1293, 1233: 1292, 1234: 1291, 1235: 1291,
            1236: 1290, 1237: 1290, 1238: 1290, 1239: 1290,
            1240: 1289, 1241: 1289, 1242: 1289, 1243: 1289,
            1244: 1289, 1245: 1289, 1246: 1289, 1249: 1288,
            1250: 1287, 1251: 1287, 1252: 1286, 1253: 1286,
            1254: 1286, 1255: 1286, 1256: 1285, 1257: 1285,
            1258: 1285, 1259: 1285, 1260: 1285, 1261: 1285,
            1262: 1285, 1264: 1284, 1265: 1284, 1266: 1284,
            1267: 1284, 1268: 1284, 1269: 1284, 1270: 1284,
            1272: 6, 1273: 6, 1274: 6, 1276: 6,
            1287: 1283, 1291: 1282, 1293: 1281, 1294: 1280,
            1295: 1280, 1299: 1279, 1301: 1278, 1302: 1277,
            1303: 1277, 1305: 1276, 1306: 1275, 1307: 1275,
            1308: 1274, 1309: 1274, 1310: 1274, 1311: 9,
            1315: 1273, 1317: 1272, 1318: 1271, 1319: 1271,
            1321: 1270, 1322: 1269, 1323: 1269, 1324: 1268,
            1325: 1268, 1326: 1268, 1327: 1268, 1329: 1267,
            1330: 1266, 1331: 1266, 1332: 1265, 1333: 1265,
            1334: 1265, 1335: 1265, 1336: 1264, 1337: 1264,
            1338: 1264, 1339: 1264, 1340: 1264, 1341: 1264,
            1342: 8, 1347: 1263, 1349: 1262, 1350: 1261,
            1351: 1261, 1353: 1260, 1354: 1259, 1355: 1259,
            1356: 1258, 1357: 1258, 1358: 1258, 1359: 1258,
            1361: 1257, 1362: 1256, 1363: 1256, 1364: 1255,
            1365: 1255, 1366: 1255, 1367: 1255, 1368: 1254,
            1369: 1254, 1370: 1254, 1371: 1254, 1372: 1254,
            1373: 1254, 1374: 1254, 1377: 1253, 1378: 1252,
            1379: 1252, 1380: 1251, 1381: 1251, 1382: 1251,
            1383: 1251, 1384: 1250, 1385: 1250, 1386: 1250,
            1387: 1250, 1388: 1250, 1389: 1250, 1390: 1250,
            1392: 1249, 1393: 1249, 1394: 1249, 1395: 1249,
            1396: 1249, 1397: 1249, 1398: 1249, 1400: 1249,
            1401: 1249, 1402: 1249, 1404: 7, 1411: 1248,
            1413: 1247, 1414: 1246, 1415: 1246, 1417: 1245,
            1418: 1244, 1419: 1244, 1420: 1243, 1421: 1243,
            1422: 1243, 1423: 1243, 1425: 1242, 1426: 1241,
            1427: 1241, 1428: 1240, 1429: 1240, 1430: 1240,
            1431: 1240, 1432: 1239, 1433: 1239, 1434: 1239,
            1435: 1239, 1436: 1239, 1437: 1239, 1438: 1239,
            1441: 1238, 1442: 1237, 1443: 1237, 1444: 1236,
            1445: 1236, 1446: 1236, 1447: 1236, 1448: 1235,
            1449: 1235, 1450: 1235, 1451: 1235, 1452: 1235,
            1453: 1235, 1454: 1235, 1456: 1234, 1457: 1234,
            1458: 1234, 1459: 1234, 1460: 1234, 1461: 1234,
            1462: 1234, 1464: 1234, 1465: 1234, 1466: 1234,
            1468: 1234, 1473: 1233, 1474: 1232, 1475: 1232,
            1476: 1231, 1477: 1231, 1478: 1231, 1479: 1231,
            1480: 1230, 1481: 1230, 1482: 1230, 1483: 1230,
            1484: 1230, 1485: 1230, 1486: 1230, 1488: 1229,
            1489: 1229, 1490: 1229, 1491: 1229, 1492: 1229,
            1493: 1229, 1494: 1229, 1496: 1229, 1497: 1229,
            1498: 1229, 1500: 1229, 1504: 1228, 1505: 1228,
            1506: 1228, 1507: 1228, 1508: 1228, 1509: 1228,
            1510: 1228, 1512: 1228, 1513: 1228, 1514: 1228,
            1516: 1228, 1520: 5, 1521: 5, 1522: 5,
            1524: 5, 1528: 5, 1543: 1227, 1547: 1226,
            1549: 1225, 1550: 1224, 1551: 1224, 1555: 1223,
            1557: 1222, 1558: 1221, 1559: 1221, 1561: 1220,
            1562: 1219, 1563: 1219, 1564: 1218, 1565: 1218,
            1566: 1218, 1567: 9, 1571: 1217, 1573: 1216,
            1574: 1215, 1575: 1215, 1577: 1214, 1578: 1213,
            1579: 1213, 1580: 1212, 1581: 1212, 1582: 1212,
            1583: 1212, 1585: 1211, 1586: 1210, 1587: 1210,
            1588: 1209, 1589: 1209, 1590: 1209, 1591: 1209,
            1592: 1208, 1593: 1208, 1594: 1208, 1595: 1208,
            1596: 1208, 1597: 1208, 1598: 8, 1603: 1207,
            1605: 1206, 1606: 1205, 1607: 1205, 1609: 1204,
            1610: 1203, 1611: 1203, 1612: 1202, 1613: 1202,
            1614: 1202, 1615: 1202, 1617: 1201, 1618: 1200,
            1619: 1200, 1620: 1199, 1621: 1199, 1622: 1199,
            1623: 1199, 1624: 1198, 1625: 1198, 1626: 1198,
            1627: 1198, 1628: 1198, 1629: 1198, 1630: 1198,
            1633: 1197, 1634: 1196, 1635: 1196, 1636: 1195,
            1637: 1195, 1638: 1195, 1639: 1195, 1640: 1194,
            1641: 1194, 1642: 1194, 1643: 1194, 1644: 1194,
            1645: 1194, 1646: 1194, 1648: 1193, 1649: 1193,
            1650: 1193, 1651: 1193, 1652: 1193, 1653: 1193,
            1654: 1193, 1656: 1193, 1657: 1193, 1658: 1193,
            1660: 7, 1667: 1192, 1669: 1191, 1670: 1190,
            1671: 1190, 1673: 1189, 1674: 1188, 1675: 1188,
            1676: 1187, 1677: 1187, 1678: 1187, 1679: 1187,
            1681: 1186, 1682: 1185, 1683: 1185, 1684: 1184,
            1685: 1184, 1686: 1184, 1687: 1184, 1688: 1183,
            1689: 1183, 1690: 1183, 1691: 1183, 1692: 1183,
            1693: 1183, 1694: 1183, 1697: 1182, 1698: 1181,
            1699: 1181, 1700: 1180, 1701: 1180, 1702: 1180,
            1703: 1180, 1704: 1179, 1705: 1179, 1706: 1179,
            1707: 1179, 1708: 1179, 1709: 1179, 1710: 1179,
            1712: 1178, 1713: 1178, 1714: 1178, 1715: 1178,
            1716: 1178, 1717: 1178, 1718: 1178, 1720: 1178,
            1721: 1178, 1722: 1178, 1724: 1178, 1729: 1177,
            1730: 1176, 1731: 1176, 1732: 1175, 1733: 1175,
            1734: 1175, 1735: 1175, 1736: 1174, 1737: 1174,
            1738: 1174, 1739: 1174, 1740: 1174, 1741: 1174,
            1742: 1174, 1744: 1173, 1745: 1173, 1746: 1173,
            1747: 1173, 1748: 1173, 1749: 1173, 1750: 1173,
            1752: 1173, 1753: 1173, 1754: 1173, 1756: 1173,
            1760: 1172, 1761: 1172, 1762: 1172, 1763: 1172,
            1764: 1172, 1765: 1172, 1766: 1172, 1768: 1172,
            1769: 1172, 1770: 1172, 1772: 1172, 1776: 1172,
            1777: 1172, 1778: 1172, 1780: 1172, 1784: 6,
            1795: 1171, 1797: 1170, 1798: 1169, 1799: 1169,
            1801: 1168, 1802: 1167, 1803: 1167, 1804: 1166,
            1805: 1166, 1806: 1166, 1807: 1166, 1809: 1165,
            1810: 1164, 1811: 1164, 1812: 1163, 1813: 1163,
            1814: 1163, 1815: 1163, 1816: 1162, 1817: 1162,
            1818: 1162, 1819: 1162, 1820: 1162, 1821: 1162,
            1822: 1162, 1825: 1161, 1826: 1160, 1827: 1160,
            1828: 1159, 1829: 1159, 1830: 1159, 1831: 1159,
            1832: 1158, 1833: 1158, 1834: 1158, 1835: 1158,
            1836: 1158, 1837: 1158, 1838: 1158, 1840: 1157,
            1841: 1157, 1842: 1157, 1843: 1157, 1844: 1157,
            1845: 1157, 1846: 1157, 1848: 1157, 1849: 1157,
            1850: 1157, 1852: 1157, 1857: 1156, 1858: 1155,
            1859: 1155, 1860: 1154, 1861: 1154, 1862: 1154,
            1863: 1154, 1864: 1153, 1865: 1153, 1866: 1153,
            1867: 1153, 1868: 1153, 1869: 1153, 1870: 1153,
            1872: 1152, 1873: 1152, 1874: 1152, 1875: 1152,
            1876: 1152, 1877: 1152, 1878: 1152, 1880: 1152,
            1881: 1152, 1882: 1152, 1884: 1152, 1888: 1151,
            1889: 1151, 1890: 1151, 1891: 1151, 1892: 1151,
            1893: 1151, 1894: 1151, 1896: 1151, 1897: 1151,
            1898: 1151, 1900: 1151, 1904: 1151, 1905: 1151,
            1906: 1151, 1908: 1151, 1912: 1151, 1921: 1150,
            1922: 1149, 1923: 1149, 1924: 1148, 1925: 1148,
            1926: 1148, 1927: 1148, 1928: 1147, 1929: 1147,
            1930: 1147, 1931: 1147, 1932: 1147, 1933: 1147,
            1934: 1147, 1936: 1146, 1937: 1146, 1938: 1146,
            1939: 1146, 1940: 1146, 1941: 1146, 1942: 1146,
            1944: 1146, 1945: 1146, 1946: 1146, 1948: 1146,
            1952: 1145, 1953: 1145, 1954: 1145, 1955: 1145,
            1956: 1145, 1957: 1145, 1958: 1145, 1960: 1145,
            1961: 1145, 1962: 1145, 1964: 1145, 1968: 1145,
            1969: 1145, 1970: 1145, 1972: 1145, 1976: 1145,
            1984: 3, 1985: 3, 1986: 3, 1987: 3,
            1988: 3, 1989: 3, 1990: 3, 1992: 3,
            1993: 3, 1994: 3, 1996: 3, 2000: 3,
            2001: 3, 2002: 3, 2004: 3, 2008: 3,
            2016: 3, 2017: 3, 2018: 3, 2020: 3,
            2024: 3, 2032: 3, 2063: 1144, 2071: 1143,
            2075: 1142, 2077: 1141, 2078: 1140, 2079: 9,
            2087: 1139, 2091: 1138, 2093: 1137, 2094: 1136,
            2095: 1136, 2099: 1135, 2101: 1134, 2102: 1133,
            2103: 1133, 2105: 1132, 2106: 1131, 2107: 1131,
            2108: 1130, 2109: 1130, 2110: 8, 2111: 8,
            2119: 1129, 2123: 1128, 2125: 1127, 2126: 1126,
            2127: 1126, 2131: 1125, 2133: 1124, 2134: 1123,
            2135: 1123, 2137: 1122, 2138: 1121, 2139: 1121,
            2140: 1120, 2141: 1120, 2142: 1120, 2143: 9,
            2147: 1119, 2149: 1118, 2150: 1117, 2151: 1117,
            2153: 1116, 2154: 1115, 2155: 1115, 2156: 1114,
            2157: 1114, 2158: 1114, 2159: 1114, 2161: 1113,
            2162: 1112, 2163: 1112, 2164: 1111, 2165: 1111,
            2166: 1111, 2167: 1111, 2168: 1110, 2169: 1110,
            2170: 1110, 2171: 1110, 2172: 7, 2173: 7,
            2174: 7, 2183: 1109, 2187: 1108, 2189: 1107,
            2190: 1106, 2191: 1106, 2195: 1105, 2197: 1104,
            2198: 1103, 2199: 1103, 2201: 1102, 2202: 1101,
            2203: 1101, 2204: 1100, 2205: 1100, 2206: 1100,
            2207: 9, 2211: 1099, 2213: 1098, 2214: 1097,
            2215: 1097, 2217: 1096, 2218: 1095, 2219: 1095,
            2220: 1094, 2221: 1094, 2222: 1094, 2223: 1094,
            2225: 1093, 2226: 1092, 2227: 1092, 2228: 1091,
            2229: 1091, 2230: 1091, 2231: 1091, 2232: 1090,
            2233: 1090, 2234: 1090, 2235: 1090, 2236: 1090,
            2237: 1090, 2238: 8, 2243: 1089, 2245: 1088,
            2246: 1087, 2247: 1087, 2249: 1086, 2250: 1085,
            2251: 1085, 2252: 1084, 2253: 1084, 2254: 1084,
            2255: 1084, 2257: 1083, 2258: 1082, 2259: 1082,
            2260: 1081, 2261: 1081, 2262: 1081, 2263: 1081,
            2264: 1080, 2265: 1080, 2266: 1080, 2267: 1080,
            2268: 1080, 2269: 1080, 2270: 1080, 2273: 1079,
            2274: 1078, 2275: 1078, 2276: 1077, 2277: 1077,
            2278: 1077, 2279: 1077, 2280: 1076, 2281: 1076,
            2282: 1076, 2283: 1076, 2284: 1076, 2285: 1076,
            2286: 1076, 2288: 1075, 2289: 1075, 2290: 1075,
            2291: 1075, 2292: 1075, 2293: 1075, 2294: 1075,
            2296: 6, 2297: 6, 2298: 6, 2300: 6,
            2311: 1074, 2315: 1073, 2317: 1072, 2318: 1071,
            2319: 1071, 2323: 1070, 2325: 1069, 2326: 1068,
            2327: 1068, 2329: 1067, 2330: 1066, 2331: 1066,
            2332: 1065, 2333: 1065, 2334: 1065, 2335: 9,
            2339: 1064, 2341: 1063, 2342: 1062, 2343: 1062,
            2345: 1061, 2346: 1060, 2347: 1060, 2348: 1059,
            2349: 1059, 2350: 1059, 2351: 1059, 2353: 1058,
            2354: 1057, 2355: 1057, 2356: 1056, 2357: 1056,
            2358: 1056, 2359: 1056, 2360: 1055, 2361: 1055,
            2362: 1055, 2363: 1055, 2364: 1055, 2365: 1055,
            2366: 8, 2371: 1054, 2373: 1053, 2374: 1052,
            2375: 1052, 2377: 1051, 2378: 1050, 2379: 1050,
            2380: 1049, 2381: 1049, 2382: 1049, 2383: 1049,
            2385: 1048, 2386: 1047, 2387: 1047, 2388: 1046,
            2389: 1046, 2390: 1046, 2391: 1046, 2392: 1045,
            2393: 1045, 2394: 1045, 2395: 1045, 2396: 1045,
            2397: 1045, 2398: 1045, 2401: 1044, 2402: 1043,
            2403: 1043, 2404: 1042, 2405: 1042, 2406: 1042,
            2407: 1042, 2408: 1041, 2409: 1041, 2410: 1041,
            2411: 1041, 2412: 1041, 2413: 1041, 2414: 1041,
            2416: 1040, 2417: 1040, 2418: 1040, 2419: 1040,
            2420: 1040, 2421: 1040, 2422: 1040, 2424: 1040,
            2425: 1040, 2426: 1040, 2428: 7, 2435: 1039,
            2437: 1038, 2438: 1037, 2439: 1037, 2441: 1036,
            2442: 1035, 2443: 1035, 2444: 1034, 2445: 1034,
            2446: 1034, 2447: 1034, 2449: 1033, 2450: 1032,
            2451: 1032, 2452: 1031, 2453: 1031, 2454: 1031,
            2455: 1031, 2456: 1030, 2457: 1030, 2458: 1030,
            2459: 1030, 2460: 1030, 2461: 1030, 2462: 1030,
            2465: 1029, 2466: 1028, 2467: 1028, 2468: 1027,
            2469: 1027, 2470: 1027, 2471: 1027, 2472: 1026,
            2473: 1026, 2474: 1026, 2475: 1026, 2476: 1026,
            2477: 1026, 2478: 1026, 2480: 1025, 2481: 1025,
            2482: 1025, 2483: 1025, 2484: 1025, 2485: 1025,
            2486: 1025, 2488: 1025, 2489: 1025, 2490: 1025,
            2492: 1025, 2497: 1024, 2498: 1023, 2499: 1023,
            2500: 1022, 2501: 1022, 2502: 1022, 2503: 1022,
            2504: 1021, 2505: 1021, 2506: 1021, 2507: 1021,
            2508: 1021, 2509: 1021, 2510: 1021, 2512: 1020,
            2513: 1020, 2514: 1020, 2515: 1020, 2516: 1020,
            2517: 1020, 2518: 1020, 2520: 1020, 2521: 1020,
            2522: 1020, 2524: 1020, 2528: 1019, 2529: 1019,
            2530: 1019, 2531: 1019, 2532: 1019, 2533: 1019,
            2534: 1019, 2536: 1019, 2537: 1019, 2538: 1019,
            2540: 1019, 2544: 5, 2545: 5, 2546: 5,
            2548: 5, 2552: 5, 2567: 1018, 2571: 1017,
            2573: 1016, 2574: 1015, 2575: 1015, 2579: 1014,
            2581: 1013, 2582: 1012, 2583: 1012, 2585: 1011,
            2586: 1010, 2587: 1010, 2588: 1009, 2589: 1009,
            2590: 1009, 2591: 9, 2595: 1008, 2597: 1007,
            2598: 1006, 2599: 1006, 2601: 1005, 2602: 1004,
            2603: 1004, 2604: 1003, 2605: 1003, 2606: 1003,
            2607: 1003, 2609: 1002, 2610: 1001, 2611: 1001,
            2612: 1000, 2613: 1000, 2614: 1000, 2615: 1000,
            2616: 999, 2617: 999, 2618: 999, 2619: 999,
            2620: 999, 2621: 999, 2622: 8, 2627: 998,
            2629: 997, 2630: 996, 2631: 996, 2633: 995,
            2634: 994, 2635: 994, 2636: 993, 2637: 993,
            2638: 993, 2639: 993, 2641: 992, 2642: 991,
            2643: 991, 2644: 990, 2645: 990, 2646: 990,
            2647: 990, 2648: 989, 2649: 989, 2650: 989,
            2651: 989, 2652: 989, 2653: 989, 2654: 989,
            2657: 988, 2658: 987, 2659: 987, 2660: 986,
            2661: 986, 2662: 986, 2663: 986, 2664: 985,
            2665: 985, 2666: 985, 2667: 985, 2668: 985,
            2669: 985, 2670: 985, 2672: 984, 2673: 984,
            2674: 984, 2675: 984, 2676: 984, 2677: 984,
            2678: 984, 2680: 984, 2681: 984, 2682: 984,
            2684: 7, 2691: 983, 2693: 982, 2694: 981,
            2695: 981, 2697: 980, 2698: 979, 2699: 979,
            2700: 978, 2701: 978, 2702: 978, 2703: 978,
            2705: 977, 2706: 976, 2707: 976, 2708: 975,
            2709: 975, 2710: 975, 2711: 975, 2712: 974,
            2713: 974, 2714: 974, 2715: 974, 2716: 974,
            2717: 974, 2718: 974, 2721: 973, 2722: 972,
            2723: 972, 2724: 971, 2725: 971, 2726: 971,
            2727: 971, 2728: 970, 2729: 970, 2730: 970,
            2731: 970, 2732: 970, 2733: 970, 2734: 970,
            2736: 969, 2737: 969, 2738: 969, 2739: 969,
            2740: 969, 2741: 969, 2742: 969, 2744: 969,
            2745: 969, 2746: 969, 2748: 969, 2753: 968,
            2754: 967, 2755: 967, 2756: 966, 2757: 966,
            2758: 966, 2759: 966, 2760: 965, 2761: 965,
            2762: 965, 2763: 965, 2764: 965, 2765: 965,
            2766: 965, 2768: 964, 2769: 964, 2770: 964,
            2771: 964, 2772: 964, 2773: 964, 2774: 964,
            2776: 964, 2777: 964, 2778: 964, 2780: 964,
            2784: 963, 2785: 963, 2786: 963, 2787: 963,
            2788: 963, 2789: 963, 2790: 963, 2792: 963,
            2793: 963, 2794: 963, 2796: 963, 2800: 963,
            2801: 963, 2802: 963, 2804: 963, 2808: 6,
            2819: 962, 2821: 961, 2822: 960, 2823: 960,
            2825: 959, 2826: 958, 2827: 958, 2828: 957,
            2829: 957, 2830: 957, 2831: 957, 2833: 956,
            2834: 955, 2835: 955, 2836: 954, 2837: 954,
            2838: 954, 2839: 954, 2840: 953, 2841: 953,
            2842: 953, 2843: 953, 2844: 953, 2845: 953,
            2846: 953, 2849: 952, 2850: 951, 2851: 951,
            2852: 950, 2853: 950, 2854: 950, 2855: 950,
            2856: 949, 2857: 949, 2858: 949, 2859: 949,
            2860: 949, 2861: 949, 2862: 949, 2864: 948,
            2865: 948, 2866: 948, 2867: 948, 2868: 948,
            2869: 948, 2870: 948, 2872: 948, 2873: 948,
            2874: 948, 2876: 948, 2881: 947, 2882: 946,
            2883: 946, 2884: 945, 2885: 945, 2886: 945,
            2887: 945, 2888: 944, 2889: 944, 2890: 944,
            2891: 944, 2892: 944, 2893: 944, 2894: 944,
            2896: 943, 2897: 943, 2898: 943, 2899: 943,
            2900: 943, 2901: 943, 2902: 943, 2904: 943,
            2905: 943, 2906: 943, 2908: 943, 2912: 942,
            2913: 942, 2914: 942, 2915: 942, 2916: 942,
            2917: 942, 2918: 942, 2920: 942, 2921: 942,
            2922: 942, 2924: 942, 2928: 942, 2929: 942,
            2930: 942, 2932: 942, 2936: 942, 2945: 941,
            2946: 940, 2947: 940, 2948: 939, 2949: 939,
            2950: 939, 2951: 939, 2952: 938, 2953: 938,
            2954: 938, 2955: 938, 2956: 938, 2957: 938,
            2958: 938, 2960: 937, 2961: 937, 2962: 937,
            2963: 937, 2964: 937, 2965: 937, 2966: 937,
            2968: 937, 2969: 937, 2970: 937, 2972: 937,
            2976: 936, 2977: 936, 2978: 936, 2979: 936,
            2980: 936, 2981: 936, 2982: 936, 2984: 936,
            2985: 936, 2986: 936, 2988: 936, 2992: 936,
            2993: 936, 2994: 936, 2996: 936, 3000: 936,
            3008: 935, 3009: 935, 3010: 935, 3011: 935,
            3012: 935, 3013: 935, 3014: 935, 3016: 935,
            3017: 935, 3018: 935, 3020: 935, 3024: 935,
            3025: 935, 3026: 935, 3028: 935, 3032: 935,
            3040: 4, 3041: 4, 3042: 4, 3044: 4,
            3048: 4, 3056: 4, 3079: 934, 3083: 933,
            3085: 932, 3086: 931, 3087: 931, 3091: 930,
            3093: 929, 3094: 928, 3095: 928, 3097: 927,
            3098: 926, 3099: 926, 3100: 925, 3101: 925,
            3102: 925, 3103: 9, 3107: 924, 3109: 923,
            3110: 922, 3111: 922, 3113: 921, 3114: 920,
            3115: 920, 3116: 919, 3117: 919, 3118: 919,
            3119: 919, 3121: 918, 3122: 917, 3123: 917,
            3124: 916, 3125: 916, 3126: 916, 3127: 916,
            3128: 915, 3129: 915, 3130: 915, 3131: 915,
            3132: 915, 3133: 915, 3134: 8, 3139: 914,
            3141: 913, 3142: 912, 3143: 912, 3145: 911,
            3146: 910, 3147: 910, 3148: 909, 3149: 909,
            3150: 909, 3151: 909, 3153: 908, 3154: 907,
            3155: 907, 3156: 906, 3157: 906, 3158: 906,
            3159: 906, 3160: 905, 3161: 905, 3162: 905,
            3163: 905, 3164: 905, 3165: 905, 3166: 905,
            3169: 904, 3170: 903, 3171: 903, 3172: 902,
            3173: 902, 3174: 902, 3175: 902, 3176: 901,
            3177: 901, 3178: 901, 3179: 901, 3180: 901,
            3181: 901, 3182: 901, 3184: 900, 3185: 900,
            3186: 900, 3187: 900, 3188: 900, 3189: 900,
            3190: 900, 3192: 900, 3193: 900, 3194: 900,
            3196: 7, 3203: 899, 3205: 898, 3206: 897,
            3207: 897, 3209: 896, 3210: 895, 3211: 895,
            3212: 894, 3213: 894, 3214: 894, 3215: 894,
            3217: 893, 3218: 892, 3219: 892, 3220: 891,
            3221: 891, 3222: 891, 3223: 891, 3224: 890,
            3225: 890, 3226: 890, 3227: 890, 3228: 890,
            3229: 890, 3230: 890, 3233: 889, 3234: 888,
            3235: 888, 3236: 887, 3237: 887, 3238: 887,
            3239: 887, 3240: 886, 3241: 886, 3242: 886,
            3243: 886, 3244: 886, 3245: 886, 3246: 886,
            3248: 885, 3249: 885, 3250: 885, 3251: 885,
            3252: 885, 3253: 885, 3254: 885, 3256: 885,
            3257: 885, 3258: 885, 3260: 885, 3265: 884,
            3266: 883, 3267: 883, 3268: 882, 3269: 882,
            3270: 882, 3271: 882, 3272: 881, 3273: 881,
            3274: 881, 3275: 881, 3276: 881, 3277: 881,
            3278: 881, 3280: 880, 3281: 880, 3282: 880,
            3283: 880, 3284: 880, 3285: 880, 3286: 880,
            3288: 880, 3289: 880, 3290: 880, 3292: 880,
            3296: 879, 3297: 879, 3298: 879, 3299: 879,
            3300: 879, 3301: 879, 3302: 879, 3304: 879,
            3305: 879, 3306: 879, 3308: 879, 3312: 879,
            3313: 879, 3314: 879, 3316: 879, 3320: 6,
            3331: 878, 3333: 877, 3334: 876, 3335: 876,
            3337: 875, 3338: 874, 3339: 874, 3340: 873,
            3341: 873, 3342: 873, 3343: 873, 3345: 872,
            3346: 871, 3347: 871, 3348: 870, 3349: 870,
            3350: 870, 3351: 870, 3352: 869, 3353: 869,
            3354: 869, 3355: 869, 3356: 869, 3357: 869,
            3358: 869, 3361: 868, 3362: 867, 3363: 867,
            3364: 866, 3365: 866, 3366: 866, 3367: 866,
            3368: 865, 3369: 865, 3370: 865, 3371: 865,
            3372: 865, 3373: 865, 3374: 865, 3376: 864,
            3377: 864, 3378: 864, 3379: 864, 3380: 864,
            3381: 864, 3382: 864, 3384: 864, 3385: 864,
            3386: 864, 3388: 864, 3393: 863, 3394: 862,
            3395: 862, 3396: 861, 3397: 861, 3398: 861,
            3399: 861, 3400: 860, 3401: 860, 3402: 860,
            3403: 860, 3404: 860, 3405: 860, 3406: 860,
            3408: 859, 3409: 859, 3410: 859, 3411: 859,
            3412: 859, 3413: 859, 3414: 859, 3416: 859,
            3417: 859, 3418: 859, 3420: 859, 3424: 858,
            3425: 858, 3426: 858, 3427: 858, 3428: 858,
            3429: 858, 3430: 858, 3432: 858, 3433: 858,
            3434: 858, 3436: 858, 3440: 858, 3441: 858,
            3442: 858, 3444: 858, 3448: 858, 3457: 857,
            3458: 856, 3459: 856, 3460: 855, 3461: 855,
            3462: 855, 3463: 855, 3464: 854, 3465: 854,
            3466: 854, 3467: 854, 3468: 854, 3469: 854,
            3470: 854, 3472: 853, 3473: 853, 3474: 853,
            3475: 853, 3476: 853, 3477: 853, 3478: 853,
            3480: 853, 3481: 853, 3482: 853, 3484: 853,
            3488: 852, 3489: 852, 3490: 852, 3491: 852,
            3492: 852, 3493: 852, 3494: 852, 3496: 852,
            3497: 852, 3498: 852, 3500: 852, 3504: 852,
            3505: 852, 3506: 852, 3508: 852, 3512: 852,
            3520: 851, 3521: 851, 3522: 851, 3523: 851,
            3524: 851, 3525: 851, 3526: 851, 3528: 851,
            3529: 851, 3530: 851, 3532: 851, 3536: 851,
            3537: 851, 3538: 851, 3540: 851, 3544: 851,
            3552: 851, 3553: 851, 3554: 851, 3556: 851,
            3560: 851, 3568: 5, 3587: 850, 3589: 849,
            3590: 848, 3591: 848, 3593: 847, 3594: 846,
            3595: 846, 3596: 845, 3597: 845, 3598: 845,
            3599: 845, 3601: 844, 3602: 843, 3603: 843,
            3604: 842, 3605: 842, 3606: 842, 3607: 842,
            3608: 841, 3609: 841, 3610: 841, 3611: 841,
            3612: 841, 3613: 841, 3614: 841, 3617: 840,
            3618: 839, 3619: 839, 3620: 838, 3621: 838,
            3622: 838, 3623: 838, 3624: 837, 3625: 837,
            3626: 837, 3627: 837, 3628: 837, 3629: 837,
            3630: 837, 3632: 836, 3633: 836, 3634: 836,
            3635: 836, 3636: 836, 3637: 836, 3638: 836,
            3640: 836, 3641: 836, 3642: 836, 3644: 836,
            3649: 835, 3650: 834, 3651: 834, 3652: 833,
            3653: 833, 3654: 833, 3655: 833, 3656: 832,
            3657: 832, 3658: 832, 3659: 832, 3660: 832,
            3661: 832, 3662: 832, 3664: 831, 3665: 831,
            3666: 831, 3667: 831, 3668: 831, 3669: 831,
            3670: 831, 3672: 831, 3673: 831, 3674: 831,
            3676: 831, 3680: 830, 3681: 830, 3682: 830,
            3683: 830, 3684: 830, 3685: 830, 3686: 830,
            3688: 830, 3689: 830, 3690: 830, 3692: 830,
            3696: 830, 3697: 830, 3698: 830, 3700: 830,
            3704: 830, 3713: 829, 3714: 828, 3715: 828,
            3716: 827, 3717: 827, 3718: 827, 3719: 827,
            3720: 826, 3721: 826, 3722: 826, 3723: 826,
            3724: 826, 3725: 826, 3726: 826, 3728: 825,
            3729: 825, 3730: 825, 3731: 825, 3732: 825,
            3733: 825, 3734: 825, 3736: 825, 3737: 825,
            3738: 825, 3740: 825, 3744: 824, 3745: 824,
            3746: 824, 3747: 824, 3748: 824, 3749: 824,
            3750: 824, 3752: 824, 3753: 824, 3754: 824,
            3756: 824, 3760: 824, 3761: 824, 3762: 824,
            3764: 824, 3768: 824, 3776: 823, 3777: 823,
            3778: 823, 3779: 823, 3780: 823, 3781: 823,
            3782: 823, 3784: 823, 3785: 823, 3786: 823,
            3788: 823, 3792: 823, 3793: 823, 3794: 823,
            3796: 823, 3800: 823, 3808: 823, 3809: 823,
            3810: 823, 3812: 823, 3816: 823, 3824: 823,
            3841: 822, 3842: 821, 3843: 821, 3844: 820,
            3845: 820, 3846: 820, 3847: 820, 3848: 819,
            3849: 819, 3850: 819, 3851: 819, 3852: 819,
            3853: 819, 3854: 819, 3856: 818, 3857: 818,
            3858: 818, 3859: 818, 3860: 818, 3861: 818,
            3862: 818,