#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys

from .cli import cmdoptions
from .cli.cmdparser import UpdatingDefaultsHelpFormatter, ConfigOptionParser
from .cli.utils import get_prog
from . import __version__


def create_main_parser():
    parser_kw = {
        'usage': '\n%prog <command> [options]',
        'add_help_option': False,
        'formatter': UpdatingDefaultsHelpFormatter(),
        'name': 'global',
        'prog': get_prog(),
    }

    parser = ConfigOptionParser(**parser_kw)
    parser.disable_interspersed_args()

    # add the general options
    gen_opts = cmdoptions.make_option_group(cmdoptions.general_group, parser)
    parser.add_option_group(gen_opts)

    # create command listing for description
    # command_summaries = get_summaries()
    # description = [''] + ['%-27s %s' % (i, j) for i, j in command_summaries]
    # parser.description = '\n'.join(description)
    # parser.main = True  # so the help formatter knows

    return parser


def parse_opts(args):
    main_parser = create_main_parser()

    # first get the general options
    general_options, args_else = main_parser.parse_args(args)

    if general_options.version:
        sys.stdout.write("version {}\n".format(__version__))
        sys.exit()

    if not args_else or (args_else[0].lower() == 'help' and len(args_else) == 1):
        main_parser.print_help()
        sys.exit()

    # the subcommand name
    cmd_name = args_else[0].lower()
    # all the args without the subcommand
    cmd_args = args[:]
    cmd_args.remove(args_else[0].lower())
    return cmd_name, cmd_args


def main():
    pass