#!/bin/bash


echo $MULTIMASTER_PORT_8089_TCP_ADDR
echo $LM_PORT_8089_TCP_ADDR


MASTER_URL="https://$MULTIMASTER_PORT_8089_TCP_ADDR:8089"
RETRY=1

while [ $RETRY -lt 10 ];do
    OUTPUT=`curl -IsSk $MASTER_URL|grep HTTP/1.1|grep -v grep|awk '{print $3}'`
    if [[ "$OUTPUT" == "OK" ]];then
        break
    else
        sleep 3
        let RETRY+=1
    fi
done

/tmp/splunk/bin/splunk edit cluster-config -mode slave -site $1 -master_uri https://$MULTIMASTER_PORT_8089_TCP_ADDR:8089 -replication_port 9011 -auth admin:notchangeme
/tmp/splunk/bin/splunk edit licenser-localslave -master_uri https://$LM_PORT_8089_TCP_ADDR:8089 -auth admin:notchangeme
/tmp/splunk/bin/splunk stop -f

echo "finish subtask configuration"