import os

import paramiko
from fabric.api import settings
from fabric.operations import run, hide


ROOT_USER = "root"
ROOT_PASSWORD = "password"


class Machine(object):
    def __init__(self, __container, __service):
        self.__container = __container
        self.__service = __service
        self.username = ROOT_USER
        self.password = ROOT_PASSWORD
        self.islinked = False

    @property
    def name(self):
        """
        represent for machine's name

        :return: str

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].name
        """
        return self.__container.name

    @property
    def container(self):
        return self.__container

    @property
    def ssh_public_host(self):
        return os.environ["DOCKER_SSH_HOST"] if "DOCKER_SSH_HOST" in os.environ else "192.168.59.103"

    @property
    def ssh_public_port(self):
        return self.container.ports["22/tcp"][0]["HostPort"]

    @property
    def ssh_host_string(self):
        return "%s:%s" % (self.ssh_public_host, self.ssh_public_port)

    @property
    def is_ssh_accessible(self, timeout=10):
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        try:
            ssh.connect(self.ssh_public_host, int(self.ssh_public_port), self.username, self.password, timeout=timeout)
            return True
        except Exception, e:
            return False

    @property
    def ports(self):
        return self.container.ports

    def execute_command(self, cmd):
        """
        execute command inside machine

        :param cmd: command to be execute in machine
        :return: result code of command executed

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].execute_command('./splunk stop')
        """
        with settings(hide('warnings', 'running', 'stdout', 'stderr'), host_string=self.ssh_host_string, user=ROOT_USER,
                      password=ROOT_PASSWORD, warn_only=True):
            result = run(cmd, shell=True, pty=True)
            return result, result.return_code





