import re

from pkg.fig.project import Project
from pkg.fig.service import VALID_NAME_CHARS,ConfigError,NAME_RE
from pkg.fig.cli.docker_client import docker_client

from service import Service



# import  os
# os.environ["FIG_FILE"] = "/Users/weiwang/work/github/rider/rider/pkg/fig.yml"
# os.environ["DOCKER_HOST"] = 'tcp://192.168.59.103:2376'
# os.environ["DOCKER_TLS_VERIFY"] = '1'
# os.environ["DOCKER_CERT_PATH"] = '/Users/weiwang/.boot2docker/certs/boot2docker-vm'


CONTAINER_NAME_REGEX = '\s+\_\d+\_\s+\_\d+'
DEFAULT_IMAGE = '10.66.128.203:49153/coreqa/splunk:fig'


class Environment(object):
    '''
    Represents a rider environment of splunk instances
    Current support: cluster, dst, shc

    '''
    client = docker_client()

    def __init__(self,env_name):
        self.env_name = env_name

    @classmethod
    def create_environment(cls,env_type,env_name,image_name = DEFAULT_IMAGE):
        if not re.match('^%s+$' % VALID_NAME_CHARS, env_name):
            raise ConfigError('Invalid service name "%s" - only %s are allowed' % (env_name, VALID_NAME_CHARS))

        Env_class=ENV_CLASS_MAPPING[env_type]
        new_env_name = "%s_%s" % (env_name,env_type)
        return Env_class(new_env_name,image_name)


    @classmethod
    def get_environments(cls):

        all_environment = []
        all_environment_name_image = cls.get_all_environments_name_image_dict()
        if len(all_environment_name_image.keys()) != 0:
            for env_identifier in all_environment_name_image.keys():
                env_instance = cls.get_environment_by_name(env_identifier, all_environment_name_image[env_identifier])
                all_environment.append(env_instance)

        return  all_environment


    @classmethod
    def get_environment_by_name(cls,name,image):
        env_name,env_type = name.split('_')

        Env_class=ENV_CLASS_MAPPING[env_type]
        return Env_class(name,image)

        pass


    @classmethod
    def get_all_environments_name_image_dict(cls,stopped=False):

        all_environments_name_image = {}
        for container in cls.client.containers(all=stopped):
            match = NAME_RE.match(container['Names'][0])
            if match:
                env_identifier =  match.group(1).replace("/","")+"_"+match.group(2)
                if not env_identifier in all_environments_name_image.keys():
                    all_environments_name_image[env_identifier] = container['Image']

        return all_environments_name_image
        pass



    def get_service_names(self):

        service_name = []
        for service in self._services:
            if service.name not in service_name:
                service_name.append(service.name)

        return service_name
        pass



    def clean(self):
        pass


    def up(self):
        self._project.up()
        pass


    def _get_service_dict(self,image_name):
        pre_service_dict = ENV_DICT_MAPPING[ClusterEnvironment.env_type]
        aft_service_dict =[]
        for service in pre_service_dict:
            service['image'] = image_name
            aft_service_dict.append(service)
        return  aft_service_dict

class ClusterEnvironment(Environment):

    env_type = "cluster"
    def __init__(self,env_name,image_name):
        super(ClusterEnvironment,self).__init__(env_name)
        # add your init functions
        self._image_name = image_name
        self._service_dict = self._get_service_dict(image_name)
        self._project = Project.from_dicts(self.env_name,self._service_dict,self.client)
        self._services = self._project.get_services()
        for service in self._services:
            setattr(self,service.name, Service(service,self))



class DistributedEnvironment(Environment):

    env_type = "dst"
    def __init__(self,env_name):
        super(DistributedEnvironment,self).__init__(env_name)

class ShcEnvironment(Environment):
    env_type = "shc"
    def __init__(self,env_name):
        super(ShcEnvironment,self).__init__(env_name)




# CONSTANTS VARIABLES
ENV_CLASS_MAPPING = {
    ClusterEnvironment.env_type:ClusterEnvironment,
    DistributedEnvironment.env_type:DistributedEnvironment,
    ShcEnvironment.env_type:ShcEnvironment
}

ENV_DICT_MAPPING = {
    ClusterEnvironment.env_type: [{'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'sh', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'sh'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'master', 'ports': ['8000', '8089', '22'], u'name': 'master'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'indexer', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'indexer'}],
    DistributedEnvironment.env_type: [{'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'sh', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'sh'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'master', 'ports': ['8000', '8089', '22'], u'name': 'master'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'indexer', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'indexer'}],
    ShcEnvironment.env_type:[{'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'sh', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'sh'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'master', 'ports': ['8000', '8089', '22'], u'name': 'master'}, {'image': '10.66.128.203:49153/coreqa/splunk:fig', 'command': 'indexer', 'ports': ['8000', '8089', '22'], 'links': ['master'], u'name': 'indexer'}]
}


# if __name__ == "__main__":
#
#
#     Environment.get_environments()
#
#     myEnv = Environment.create_environment("cluster","jacktestapi2")
#
#     myEnv.get_service_names()
#
#     myEnv.up()
#     myEnv.indexer.scale(2)
#     print myEnv.indexer.machines[0].name
