from machine import Machine

class Service(object):
    def __init__(self,_service,_environment):
        self._environment = _environment
        self._service = _service




    def scale(self,desire_number):
        if self._can_be_scaled():
            self._service.scale(desire_number)



    def get_env(self):
        return self._service.project



    def _can_be_scaled(self):

        if self._service.name == 'master':
            raise CouldNotScale(self._service.name)
        else:
            return True


    @property
    def machines(self):
        machines = []
        for _container in self._service.containers():
            machines.append(Machine(_container,self))
        return machines




class CouldNotScale(Exception):
    def __init__(self, name):
        self.name = name
        self.msg = "%s is not able to scale" % self.name

    def __str__(self):
        return self.msg
