#!/bin/bash

echo $DSP_PORT_8089_TCP_ADDR
echo $LM_PORT_8089_TCP_ADDR

DSP_URL="https://$DSP_PORT_8089_TCP_ADDR:8089"
RETRY=1

while [ $RETRY -lt 10 ];do
    OUTPUT=`curl -IsSk $DSP_URL|grep HTTP/1.1|grep -v grep|awk '{print $3}'`
    if [[ "$OUTPUT" == "OK" ]];then
        break
    else
        sleep 3
        let RETRY+=1
    fi
done

/tmp/splunk/bin/splunk add search-server -host $DSP_PORT_8089_TCP_ADDR:8089 -auth admin:notchangeme -remoteUsername admin -remotePassword notchangeme

/tmp/splunk/bin/splunk edit licenser-localslave -master_uri https://$LM_PORT_8089_TCP_ADDR:8089 -auth admin:notchangeme
/tmp/splunk/bin/splunk stop -f

echo "finish distributed search configuration"