import os

import paramiko
from fabric.api import settings
from fabric.operations import run, hide


ROOT_USER = "root"
ROOT_PASSWORD = "password"


class Machine(object):
    def __init__(self, __container, __service):
        self.__container = __container
        self.__service = __service
        self.username = ROOT_USER
        self.password = ROOT_PASSWORD
        self.islinked = False
        self.splunk_username = "admin"
        self.splunk_password = "notchangeme"

    @property
    def name(self):
        """
        represent for machine's name

        :return: str

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].name
        """
        return self.__container.name

    @property
    def container(self):
        """
        represent the container object for this machine

        :return:
        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].container
        """
        return self.__container

    @property
    def ssh_public_host(self):
        """
        represent the ssh public host
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].ssh_public_host
        """

        return os.environ["DOCKER_SSH_HOST"] if "DOCKER_SSH_HOST" in os.environ else "192.168.59.103"

    @property
    def ssh_public_port(self):
        """
        represent the ssh public port of a machine
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].ssh_public_port
        """
        return self.container.ports["22/tcp"][0]["HostPort"]

    @property
    def splunkd_public_host(self):
        """
        represent the ssh public port of a machine
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].splunk_public_host
        """
        return self.ssh_public_host

    @property
    def splunkd_public_port(self):
        """
        represent the ssh public port of a machine
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].splunk_public_port
        """
        return self.container.ports["8089/tcp"][0]["HostPort"]

    @property
    def ssh_host_string(self):
        """
        represent the ssh host and ssh public port string
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].ssh_host_string
        """
        return "%s:%s" % (self.ssh_public_host, self.ssh_public_port)

    @property
    def is_ssh_accessible(self, timeout=10):
        """
        Check if machine ssh ready
        :param timeout: default 10 secs
        :return: boolean

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].is_ssh_accessible
        """
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        try:
            ssh.connect(self.ssh_public_host, int(self.ssh_public_port), self.username, self.password, timeout=timeout)
            return True
        except Exception, e:
            return False

    @property
    def ports(self):
        """
        Return machine's container exported ports
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].ports
        """
        return self.container.ports

    def execute_command(self, cmd):
        """
        execute command inside machine

        :param cmd: command to be execute in machine
        :return: result code of command executed

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].execute_command('/tmp/splunk/bin/splunk restart')
        """
        with settings(hide('warnings', 'running', 'stdout', 'stderr'), host_string=self.ssh_host_string, user=ROOT_USER,
                      password=ROOT_PASSWORD, warn_only=True):
            result = run(cmd, shell=True, pty=True)
            return result, result.return_code





