class Machine(object):
    def __init__(self, __container, __service):
        self.__container = __container
        self.__service = __service

    @property
    def name(self):
        """
        represent for machine's name

        :return: str

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].name
        """
        return self.__container.name

    @property
    def container(self):
        return self.__container

    def execute_command(self, cmd):
        """
        execute command inside machine

        :param cmd: command to be execute in machine
        :return: result code of command executed

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines[0].execute_command('./splunk stop')
        """
        pass



