from machine import Machine


class Service(object):
    def __init__(self, name, _service, _environment):
        self.name = name
        self._environment = _environment
        self._service = _service


    def scale(self, desire_number):
        """
        scale a service to desire_number

        :param desire_number: int
        :return:

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.scale(5)
        """
        if self._can_be_scaled():
            self._service.scale(desire_number)


    def get_env(self):
        return self._service.project


    def _can_be_scaled(self):

        if self._service.name == 'master':
            raise CouldNotScale(self._service.name)
        else:
            return True


    @property
    def machines(self):
        """
        Return machine objects belong to this service

        :return: list of machine objects

        >>> from rider.environment import Environment
        >>> env = Environment.get_environments('jacktestapi2_cluster')
        >>> env.indexer.machines
        >>> env.indexer.machines[0]
        """
        machines = []
        for _container in self._service.containers():
            machines.append(Machine(_container, self))
        return machines


class CouldNotScale(Exception):
    def __init__(self, name):
        self.name = name
        self.msg = "%s is not able to scale" % self.name

    def __str__(self):
        return self.msg
