---
layout: page.html
location: development
title: Development
toc: true
---

An overview of the information needed for development on Misaka and related things
like documentation, testing and dependencies.


## Code

The code can be cloned, forked or downloaded from https://github.com/FSX/misaka.
And issues can be reported on the [Issues][] page.

The only two dependencies for development are [Sundown][] and [Cython][]. Sundown
is already included, but can be updated with:

    git submodule foreach git pull
    python setup.py update_vendor

Cython can be installed with pip, easy_install or other methods described in the
Cython documentation:

    pip install Cython

The file organization is as follows (directories end for a forward slash, `/`):

 - `benchmark/` --- A simple benchmark between different Python-based Markdown parsers.
 - `docs/` --- Documentation in Markdown format.
 - `scripts/` --- Command-line script that are installed to `/usr/bin` or `/usr/local/bin`
   on Linux for example.
 - `src/` --- All source files.
    - `sundown/` --- The Sundown files that are copied from `vendor/sundown/`.
      These files should not be changed, because they come from the Sundown Git
      repository.
    - `misaka.pyx` --- Cython source file.
    - `misaka.c` --- C file that's generated by Cython. This file should not be edited.
      Changes need to be made to `misaka.pyx` and `python setup.py compile_cython`
      is used to update this file.
    - `wrapper.h`, `wrapper.c` --- All callbacks for custom renderers.
    - `*.pxd` --- Header files for Cython to import variables and function from
      C files.
 - `tests/` --- Unit tests.
 - `vendor/` --- Submodules of dependencies (e.g. Sundown).
 - `.travis.yml` --- Configuration files for [Travis CI][].
 - `setup.py` --- Python setup file.

Files that are nor critical for development or speak for themselves have been omitted.

[Sundown]: https://github.com/tanoku/sundown
[Cython]: http://cython.org/
[Travis CI]: http://about.travis-ci.org/docs/user/languages/python/
[Issues]: https://github.com/FSX/misaka/issues


## Unit tests

The unit tests require two dependencies: [HTML Tidy][] and minitest. The latter
one is already included, but HTML Tidy needs to be installed.

~~~bash
pacman -S tidyhtml # on Arch Linux
apt-get install tidy # on Ubuntu
~~~

To run the unit tests one simply goes into the `test/` directory and runs:

    python misaka_tests.py

A list of tests and results will appear and the end result. When a test fails, the
test condition or a diff will be shown under the failed test.

The unit testing library, `minitest`, is used instead of Python's `unittest`,
because it does not require documentation. It's code is simple enough to figure
out what it does. And `minitest` does everything that is required in this project.
Additional functionality can be added as needed.


[HTML Tidy]: http://tidy.sourceforge.net/


## Documentation

The documentation uses some more dependencies. It requires [LESS][], [Elyse][]
and Misaka itself. Because LESS is needed, [Node.js][] and [npm][] are also needed.
Node.js has installers for Windows and Macintosh and most Linux distributions provide
a package that can be installed with the package manager. npm [isn't hard to install][npm-install].

Elyse is a simple static website generator. It pulls in the following dependencies:
PyYAML, Tornado, Houdini.py, Misaka, Pygments and Unidecode. If you would like to
use your own modified version of Misaka just install it manually.

The conversion of the LESS files depend on a Bash script. That probably doesn't work
Windows without installing a Bash environment first.

Elyse can be installed with:

    pip -e git+git://github.com/FSX/elyse.git#egg=elyse

That's quite a lot. If you don't like it you can just read the plain text files
in the `docs/` directory or visit the online documentation at
[misaka.61924.nl](http://misaka.61924.nl/).

Building the documentation (generating HTML files) is easy. Move into the `docs/`
directory and run one of the following commands.

~~~bash
make
# Or...
elyse ./ _build/
# Or for more information...
elyse --help
~~~

The actual contents are located inside `docs/pages/`. These are Markdown files
with some metadata at the top of the file. In addition to the Markdown and YAML
you can use [Tornado template][tornado-template] tags.

~~~yaml
layout: page.html  # A file in the `docs/templates/` directory
location: development  # Used in the body ID
title: Development  # Title of the page
toc: true  # Show table of contents? Optional.
~~~

To preview the documentation you can serve the output directory with a simple
webserver like [darkhttp][], but before you do you need to change the `base_url`
in `docs/config.yml` to the local URL. Like the following for example.

    base_url: http://0.0.0.0:8080

It should be changed back when local testing is done. It's a bit cumbersome, but
improvements are on the to do list.


[LESS]: http://lesscss.org/
[Elyse]: https://github.com/FSX/elyse
[Node.js]: http://nodejs.org/
[npm]: http://npmjs.org/
[npm-install]: http://npmjs.org/doc/README.html
[tornado-template]: http://www.tornadoweb.org/documentation/template.html
[darkhttp]: http://unix4lyfe.org/darkhttpd/
