#!/usr/bin/env python
# -*- coding: utf-8 -*-

# pyVows testing engine
# https://github.com/heynemann/pyvows

# Licensed under the MIT license:
# http://www.opensource.org/licenses/mit-license
# Copyright (c) 2011 Bernardo Heynemann heynemann@gmail.com

from setuptools import setup
from preggy import __version__

test_requires = [
    'nose',
    'yanc',
    'coverage',
    'tox',
]

setup(
    name='preggy',
    version=__version__,
    description='preggy is a set of matchers extracted from pyVows.',
    long_description='''
preggy is a set of matchers extracted from pyVows.
''',
    keywords='test testing vows tdd bdd development coverage profile profiling',
    author='Bernardo Heynemann',
    author_email='heynemann@gmail.com',
    url='http://github.com/heynemann/preggy/',
    license='MIT',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Operating System :: MacOS',
        'Operating System :: POSIX',
        'Operating System :: Unix',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Software Development :: Testing'
    ],
    packages=['preggy', 'preggy.types'],

    install_requires=[
        'six',
    ],

    extras_require={
        'tests': test_requires,
    },

    entry_points={
    },
)
