import ast
import prettier as pp

class Symbol(str):
    def __repr__(self):
        return self

class Node:
    def __init__(self, name, child, node):
        self.name = name
        self.child = child
        self.node = node
    
    def pprint(self):
        name = self.name
        args = []
        child = [c.pprint() for c in self.child]
        if 0:
            pass
        elif name == "Name":
            args.append("(id: %r)" % self.node.id)
        elif name == "Num":
            args.append("(n: %r)" % self.node.n)
        elif name == "Str":
            args.append("(s: %s)" % self.node.s)
        elif name == "Attribute":
            args.append("(attr: %r)" % self.node.attr)
        elif name == "ClassDef":
            args.append("(name: %r)" % self.node.name)
        elif name == "Print":
            args.append("(nl: %r)" % self.node.nl)
        elif name == "ImportFrom":
            args.append("(module: %r)" % self.node.module)
        elif name == "alias":
            args.append("(name: %r) (asname: %r)" % (self.node.name, self.node.asname))
        elif name in """
            Interactive Store Assign For Call Print Load FunctionDef
            Param arguments comprehension BinOp Expr Mult Return
            ListComp Tuple Add List Module""".split():
            pass
        else:
            d = vars(self.node)
            if d:
                args.append(repr(d))

        if not child and not args:
            return pp.Text("(%s)" % name)

        head = "(%s " % name 
        if args:
            head += " ".join(a for a in args)
            if child: 
                head += " "
            else:
                return pp.Text(head + ")")

        return pp.union(
            pp.concat(
                pp.Text(head),
                pp.flatten(pp.spread(child)),
                pp.Text(")")),
            pp.concat(
                pp.Text(head),
                pp.Nest(1, 
                        pp.concat(
                          pp.LINE, 
                          pp.stack(child),
                          pp.Text(")")))))
                 
                      


def build(node):
    return Node(node.__class__.__name__,
                [build(c) for c in ast.iter_child_nodes(node)],
                node)



def pprint(node):
    x = build(node)
    print pp.pretty(80, x.pprint())
                    

SAMPLE_CODE = """
for i in range(10):
    x, y = y, x + y
    print x,
"""

if __name__ == "__main__":
    nodes = pprint(ast.parse(SAMPLE_CODE))
    
    
