define([], function() {
  'use strict';
  /* jshint -W101:true, -W106:true, -W109:true */

  var auth = {
    username: 'demo',
    password: 'demo',
    authenticated: false
  };

  var events = [];

  var logs = [
    {
      id: '4eca4b80300347a2a237b1545bcfa728',
      message: 'Created new server "server2".',
      time: 1380863023
    },
    {
      id: '35e9b53b3e2c0d3bad674bcf4e7f2ba9',
      message: 'Created new server "server1".',
      time: 1380862905
    },
    {
      id: 'a66f7ec1117ac2708465adf3ab9cd6ec',
      message: 'Deleted user "user3".',
      time: 1380862844
    },
    {
      id: '126d5f9d78c7bd399484613f9aaf4383',
      message: 'Created new user "user3".',
      time: 1380862712
    },
    {
      id: 'ec21498ea20d9c9def138293a822a39c',
      message: 'Created new user "user2".',
      time: 1380862662
    },
    {
      id: '1e743b5234e32164837c89c2b706c1b7',
      message: 'Created new user "user1".',
      time: 1380862585
    },
    {
      id: '3dd359a679ec9772cc0c209d0d8c4cb4',
      message: 'Created new organization "org2".',
      time: 1380862472
    },
    {
      id: 'de50f62440b7bc39caaad622e5b3f402',
      message: 'Created new user "user4".',
      time: 1380862394
    },
    {
      id: '8e40c42302dbc14df2003febf611571c',
      message: 'Created new user "user3".',
      time: 1380862243
    },
    {
      id: '9fb1ece8c427767afe7adefa5fdb903f',
      message: 'Created new user "user2".',
      time: 1380862194
    },
    {
      id: '73cfe76951c4fe94df0d4cb12a6fbce7',
      message: 'Created new user "user1".',
      time: 1380862042
    },
    {
      id: 'c22c3996cbd8d44da469bae9e99ac57e',
      message: 'Created new organization "org1".',
      time: 1380861943
    },
    {
      id: '94bc0d3e2afa44ccb22c56843ac90c08',
      message: 'Web server started.',
      time: 1380861803
    }
  ];

  var orgs = {
    '55f5c6820e7a7de989916b4cdddf6070': {
      id: '55f5c6820e7a7de989916b4cdddf6070',
      name: 'org1'
    },
    'adb484e1f3c653dbc2aab10b14265dc6': {
      id: 'adb484e1f3c653dbc2aab10b14265dc6',
      name: 'org2'
    }
  };

  var servers = {
    '5310c28eacaeb3bd2a172c9db9ee1379': {
      id: '5310c28eacaeb3bd2a172c9db9ee1379',
      debug: false,
      otp_auth: true,
      lzo_compression: false,
      interface: 'tun0',
      local_networks: [],
      dns_servers: [
        '8.8.4.4'
      ],
      name: 'server1',
      type: 'server',
      network: '10.139.17.0/24',
      orgs: [
        '55f5c6820e7a7de989916b4cdddf6070',
        'adb484e1f3c653dbc2aab10b14265dc6'
      ],
      output: 'Thu Oct  3 18:07:06 2013 OpenVPN 2.3.2 x86_64-unknown-linux-gnu [SSL (OpenSSL)] [LZO] [EPOLL] [eurephia] [MH] [IPv6] built on Jun  7 2013\nThu Oct  3 18:07:06 2013 NOTE: the current --script-security setting may allow this configuration to call user-defined scripts\nThu Oct  3 18:07:06 2013 TUN/TAP device tun0 opened\nThu Oct  3 18:07:06 2013 do_ifconfig, tt->ipv6=0, tt->did_ifconfig_ipv6_setup=0\nThu Oct  3 18:07:06 2013 /usr/bin/ip link set dev tun0 up mtu 1500\nThu Oct  3 18:07:06 2013 /usr/bin/ip addr add dev tun0 local 10.100.68.1 peer 10.100.68.2\nThu Oct  3 18:07:06 2013 UDPv4 link local (bound): [undef]\nThu Oct  3 18:07:06 2013 UDPv4 link remote: [undef]\nThu Oct  3 18:07:06 2013 Initialization Sequence Completed\n',
      port: '16070',
      protocol: 'udp',
      dh_param_bits: 2048,
      public_address: '8.8.8.8',
      status: true
    },
    '8159a073832f4bc481a1de9676326a9e': {
      id: '8159a073832f4bc481a1de9676326a9e',
      debug: false,
      otp_auth: true,
      lzo_compression: false,
      interface: 'tun1',
      local_networks: [],
      dns_servers: [
        '8.8.4.4'
      ],
      name: 'server2',
      type: 'server',
      network: '10.113.56.0/24',
      orgs: [
        '55f5c6820e7a7de989916b4cdddf6070',
        'adb484e1f3c653dbc2aab10b14265dc6'
      ],
      output: 'Thu Oct  3 18:07:06 2013 OpenVPN 2.3.2 x86_64-unknown-linux-gnu [SSL (OpenSSL)] [LZO] [EPOLL] [eurephia] [MH] [IPv6] built on Jun  7 2013\nThu Oct  3 18:07:06 2013 NOTE: the current --script-security setting may allow this configuration to call user-defined scripts\nThu Oct  3 18:07:06 2013 TUN/TAP device tun0 opened\nThu Oct  3 18:07:06 2013 do_ifconfig, tt->ipv6=0, tt->did_ifconfig_ipv6_setup=0\nThu Oct  3 18:07:06 2013 /usr/bin/ip link set dev tun0 up mtu 1500\nThu Oct  3 18:07:06 2013 /usr/bin/ip addr add dev tun0 local 10.100.68.1 peer 10.100.68.2\nThu Oct  3 18:07:06 2013 UDPv4 link local (bound): [undef]\nThu Oct  3 18:07:06 2013 UDPv4 link remote: [undef]\nThu Oct  3 18:07:06 2013 Initialization Sequence Completed\n',
      port: '9430',
      protocol: 'udp',
      dh_param_bits: 2048,
      public_address: '8.8.8.8',
      status: true
    }
  };

  var serverOutput = {
    online: 'Thu Oct  3 18:07:06 2013 OpenVPN 2.3.2 x86_64-unknown-linux-gnu [SSL (OpenSSL)] [LZO] [EPOLL] [eurephia] [MH] [IPv6] built on Jun  7 2013\nThu Oct  3 18:07:06 2013 NOTE: the current --script-security setting may allow this configuration to call user-defined scripts\nThu Oct  3 18:07:06 2013 TUN/TAP device tun0 opened\nThu Oct  3 18:07:06 2013 do_ifconfig, tt->ipv6=0, tt->did_ifconfig_ipv6_setup=0\nThu Oct  3 18:07:06 2013 /usr/bin/ip link set dev tun0 up mtu 1500\nThu Oct  3 18:07:06 2013 /usr/bin/ip addr add dev tun0 local 10.100.68.1 peer 10.100.68.2\nThu Oct  3 18:07:06 2013 UDPv4 link local (bound): [undef]\nThu Oct  3 18:07:06 2013 UDPv4 link remote: [undef]\nThu Oct  3 18:07:06 2013 Initialization Sequence Completed\n',
    offline: 'Thu Oct  3 18:08:21 2013 event_wait : Interrupted system call (code=4)\nThu Oct  3 18:08:21 2013 /usr/bin/ip addr del dev tun0 local 10.100.68.1 peer 10.100.68.2\nThu Oct  3 18:08:21 2013 SIGINT[hard,] received, process exiting\n'
  };

  var serverBandwidth = {
    '1m': {'received': [[1393181880, 729928], [1393181940, 709239], [1393182000, 673642], [1393182060, 655254], [1393182120, 641047], [1393182180, 623143], [1393182240, 650909], [1393182300, 601116], [1393182360, 630741], [1393182420, 663032], [1393182480, 653714], [1393182540, 677696], [1393182600, 718833], [1393182660, 724857], [1393182720, 748424], [1393182780, 723421], [1393182840, 740876], [1393182900, 747720], [1393182960, 728156], [1393183020, 711125], [1393183080, 706824], [1393183140, 668606], [1393183200, 690494], [1393183260, 645943], [1393183320, 689116], [1393183380, 682868], [1393183440, 693788], [1393183500, 726966], [1393183560, 764526], [1393183620, 805756], [1393183680, 758414], [1393183740, 795887], [1393183800, 832732], [1393183860, 808732], [1393183920, 781919], [1393183980, 734629], [1393184040, 781728], [1393184100, 783536], [1393184160, 782102], [1393184220, 789014], [1393184280, 768131], [1393184340, 807173], [1393184400, 810490], [1393184460, 813164], [1393184520, 858954], [1393184580, 846216], [1393184640, 801777], [1393184700, 848336], [1393184760, 864650], [1393184820, 860121], [1393184880, 822072], [1393184940, 815958], [1393185000, 774545], [1393185060, 822615], [1393185120, 814559], [1393185180, 792236], [1393185240, 772526], [1393185300, 802329], [1393185360, 766814], [1393185420, 783998], [1393185480, 815624], [1393185540, 859087], [1393185600, 888119], [1393185660, 922318], [1393185720, 942417], [1393185780, 941018], [1393185840, 902488], [1393185900, 947043], [1393185960, 969090], [1393186020, 945286], [1393186080, 981784], [1393186140, 963434], [1393186200, 950630], [1393186260, 989872], [1393186320, 947424], [1393186380, 945465], [1393186440, 967019], [1393186500, 952888], [1393186560, 921407], [1393186620, 951189], [1393186680, 984163], [1393186740, 1013720], [1393186800, 973808], [1393186860, 986730], [1393186920, 944135], [1393186980, 933284], [1393187040, 913965], [1393187100, 875848], [1393187160, 923483], [1393187220, 952648], [1393187280, 942301], [1393187340, 974979], [1393187400, 1023902], [1393187460, 1015719], [1393187520, 1052818], [1393187580, 1018362], [1393187640, 1040400], [1393187700, 1014452], [1393187760, 970818], [1393187820, 955782], [1393187880, 937570], [1393187940, 933190], [1393188000, 916265], [1393188060, 960508], [1393188120, 924701], [1393188180, 934956], [1393188240, 906149], [1393188300, 906998], [1393188360, 923421], [1393188420, 928489], [1393188480, 964006], [1393188540, 947856], [1393188600, 960817], [1393188660, 920022], [1393188720, 876641], [1393188780, 911433], [1393188840, 925899], [1393188900, 890772], [1393188960, 863930], [1393189020, 861089], [1393189080, 821324], [1393189140, 860171], [1393189200, 859267], [1393189260, 900076], [1393189320, 882944], [1393189380, 887090], [1393189440, 917971], [1393189500, 942625], [1393189560, 894367], [1393189620, 934424], [1393189680, 965841], [1393189740, 947918], [1393189800, 903662], [1393189860, 928847], [1393189920, 953526], [1393189980, 972936], [1393190040, 991707], [1393190100, 1037401], [1393190160, 1084757], [1393190220, 1130977], [1393190280, 1112598], [1393190340, 1150518], [1393190400, 1130347], [1393190460, 1101799], [1393190520, 1075356], [1393190580, 1057426], [1393190640, 1055296], [1393190700, 1075978], [1393190760, 1101456], [1393190820, 1088019], [1393190880, 1081575], [1393190940, 1121564], [1393191000, 1101717], [1393191060, 1116896], [1393191120, 1086834], [1393191180, 1092559], [1393191240, 1061351], [1393191300, 1026638], [1393191360, 1048728], [1393191420, 1010610], [1393191480, 1035006], [1393191540, 998903], [1393191600, 1047030], [1393191660, 1048167], [1393191720, 1027614], [1393191780, 1009475], [1393191840, 1014090], [1393191900, 1024706], [1393191960, 1007050], [1393192020, 1051445], [1393192080, 1044408], [1393192140, 1039750], [1393192200, 1064928], [1393192260, 1071133], [1393192320, 1030006], [1393192380, 1068419], [1393192440, 1107576], [1393192500, 1067381], [1393192560, 1107894], [1393192620, 1063324], [1393192680, 1086596], [1393192740, 1120231], [1393192800, 1121679], [1393192860, 1154333], [1393192920, 1137943], [1393192980, 1167247], [1393193040, 1119173], [1393193100, 1138097], [1393193160, 1147528], [1393193220, 1111968], [1393193280, 1150957], [1393193340, 1177088], [1393193400, 1160234], [1393193460, 1113949], [1393193520, 1153695], [1393193580, 1110972], [1393193640, 1116051], [1393193700, 1133312], [1393193760, 1160310], [1393193820, 1140148], [1393193880, 1109321], [1393193940, 1104260], [1393194000, 1143799], [1393194060, 1095523], [1393194120, 1103756], [1393194180, 1120001], [1393194240, 1094789], [1393194300, 1113196], [1393194360, 1120938], [1393194420, 1110414], [1393194480, 1097418], [1393194540, 1098705], [1393194600, 1137238], [1393194660, 1152781], [1393194720, 1132531], [1393194780, 1097007], [1393194840, 1132139], [1393194900, 1152546], [1393194960, 1123737], [1393195020, 1098057], [1393195080, 1143289], [1393195140, 1129488], [1393195200, 1124634], [1393195260, 1152293], [1393195320, 1162552], [1393195380, 1125351], [1393195440, 1151542], [1393195500, 1151953], [1393195560, 1140851], [1393195620, 1142619], [1393195680, 1148381], [1393195740, 1145748], [1393195800, 1190392], [1393195860, 1142786], [1393195920, 1178979], [1393195980, 1138016], [1393196040, 1102174], [1393196100, 1111084], [1393196160, 1118774], [1393196220, 1110390], [1393196280, 1071475], [1393196340, 1075003], [1393196400, 1066830], [1393196460, 1103189], [1393196520, 1103249], [1393196580, 1150710], [1393196640, 1147442], [1393196700, 1183126], [1393196760, 1186034], [1393196820, 1222995], [1393196880, 1201879], [1393196940, 1244057], [1393197000, 1287949], [1393197060, 1321489], [1393197120, 1326628], [1393197180, 1372322], [1393197240, 1339376], [1393197300, 1294714], [1393197360, 1248900], [1393197420, 1217445], [1393197480, 1173739], [1393197540, 1165471], [1393197600, 1214571], [1393197660, 1172851], [1393197720, 1151338], [1393197780, 1136593], [1393197840, 1135188], [1393197900, 1169230], [1393197960, 1162172], [1393198020, 1158026], [1393198080, 1203304], [1393198140, 1216037], [1393198200, 1167396], [1393198260, 1163166], [1393198320, 1186211], [1393198380, 1205088], [1393198440, 1237520], [1393198500, 1190906], [1393198560, 1218432], [1393198620, 1185383], [1393198680, 1161048], [1393198740, 1124261], [1393198800, 1097597], [1393198860, 1098091], [1393198920, 1067452], [1393198980, 1093551], [1393199040, 1047126], [1393199100, 1083891], [1393199160, 1080730], [1393199220, 1071595], [1393199280, 1042009], [1393199340, 993485], [1393199400, 945477], [1393199460, 910181], [1393199520, 873067], [1393199580, 825170], [1393199640, 835849], [1393199700, 862286], [1393199760, 820884], [1393199820, 816993], [1393199880, 778265], [1393199940, 827549], [1393200000, 860834], [1393200060, 889012], [1393200120, 920973], [1393200180, 925694], [1393200240, 969155], [1393200300, 1000819], [1393200360, 1031264], [1393200420, 1025033], [1393200480, 1062545], [1393200540, 1027331], [1393200600, 1018805], [1393200660, 1068702], [1393200720, 1072465], [1393200780, 1103792], [1393200840, 1065906], [1393200900, 1039186], [1393200960, 1055253], [1393201020, 1080481], [1393201080, 1113802], [1393201140, 1071233], [1393201200, 1080937], [1393201260, 1098915], [1393201320, 1140253], [1393201380, 1113772], [1393201440, 1133783], [1393201500, 1178311], [1393201560, 1189324], [1393201620, 1187479], [1393201680, 1177753], [1393201740, 1165214], [1393201800, 1141469], [1393201860, 1139466], [1393201920, 1134085], [1393201980, 1084539], [1393202040, 1084066], [1393202100, 1076159], [1393202160, 1027691], [1393202220, 991129], [1393202280, 971611], [1393202340, 955972], [1393202400, 954616], [1393202460, 948192], [1393202520, 908518], [1393202580, 931783], [1393202640, 945439], [1393202700, 938766], [1393202760, 939141], [1393202820, 893470], [1393202880, 893263], [1393202940, 913082], [1393203000, 880371], [1393203060, 910941], [1393203120, 866069], [1393203180, 834808], [1393203240, 793775], [1393203300, 755186], [1393203360, 765977], [1393203420, 782557]], 'sent': [[1393181880, 728328], [1393181940, 737506], [1393182000, 747553], [1393182060, 788978], [1393182120, 820280], [1393182180, 862551], [1393182240, 819764], [1393182300, 774276], [1393182360, 796921], [1393182420, 771079], [1393182480, 765770], [1393182540, 770378], [1393182600, 733957], [1393182660, 735829], [1393182720, 702013], [1393182780, 654077], [1393182840, 655292], [1393182900, 610588], [1393182960, 634186], [1393183020, 629763], [1393183080, 605572], [1393183140, 582977], [1393183200, 571073], [1393183260, 589277], [1393183320, 543640], [1393183380, 556649], [1393183440, 549607], [1393183500, 567873], [1393183560, 574014], [1393183620, 612962], [1393183680, 614935], [1393183740, 661858], [1393183800, 700436], [1393183860, 670764], [1393183920, 681657], [1393183980, 637493], [1393184040, 661845], [1393184100, 704890], [1393184160, 736638], [1393184220, 749013], [1393184280, 735106], [1393184340, 707357], [1393184400, 737103], [1393184460, 726740], [1393184520, 758018], [1393184580, 719063], [1393184640, 680309], [1393184700, 659467], [1393184760, 668791], [1393184820, 633876], [1393184880, 645477], [1393184940, 626726], [1393185000, 606041], [1393185060, 593067], [1393185120, 580480], [1393185180, 618548], [1393185240, 603169], [1393185300, 639122], [1393185360, 684700], [1393185420, 664107], [1393185480, 638628], [1393185540, 612280], [1393185600, 646544], [1393185660, 686809], [1393185720, 711350], [1393185780, 747163], [1393185840, 750552], [1393185900, 752133], [1393185960, 731949], [1393186020, 718287], [1393186080, 704641], [1393186140, 666621], [1393186200, 715443], [1393186260, 734106], [1393186320, 723326], [1393186380, 746828], [1393186440, 779939], [1393186500, 804235], [1393186560, 795206], [1393186620, 772367], [1393186680, 745277], [1393186740, 729707], [1393186800, 731337], [1393186860, 723999], [1393186920, 699782], [1393186980, 686326], [1393187040, 638350], [1393187100, 628565], [1393187160, 599864], [1393187220, 611735], [1393187280, 571568], [1393187340, 570773], [1393187400, 617584], [1393187460, 606164], [1393187520, 577511], [1393187580, 576510], [1393187640, 620351], [1393187700, 645513], [1393187760, 669568], [1393187820, 698624], [1393187880, 706549], [1393187940, 731537], [1393188000, 739996], [1393188060, 777594], [1393188120, 755393], [1393188180, 784492], [1393188240, 752496], [1393188300, 751172], [1393188360, 756244], [1393188420, 743567], [1393188480, 729746], [1393188540, 719245], [1393188600, 675134], [1393188660, 699932], [1393188720, 657916], [1393188780, 707373], [1393188840, 707570], [1393188900, 729684], [1393188960, 718653], [1393189020, 754818], [1393189080, 713011], [1393189140, 725650], [1393189200, 756839], [1393189260, 788734], [1393189320, 808115], [1393189380, 794259], [1393189440, 828861], [1393189500, 787969], [1393189560, 745020], [1393189620, 744244], [1393189680, 763281], [1393189740, 792781], [1393189800, 789588], [1393189860, 756004], [1393189920, 766203], [1393189980, 812728], [1393190040, 809763], [1393190100, 845341], [1393190160, 866222], [1393190220, 827765], [1393190280, 815936], [1393190340, 812558], [1393190400, 787398], [1393190460, 818114], [1393190520, 794267], [1393190580, 770074], [1393190640, 812691], [1393190700, 846821], [1393190760, 864196], [1393190820, 880100], [1393190880, 864341], [1393190940, 902033], [1393191000, 898647], [1393191060, 874039], [1393191120, 918674], [1393191180, 949474], [1393191240, 962828], [1393191300, 986146], [1393191360, 936735], [1393191420, 970941], [1393191480, 946552], [1393191540, 959548], [1393191600, 951815], [1393191660, 993879], [1393191720, 944970], [1393191780, 971498], [1393191840, 943140], [1393191900, 926266], [1393191960, 880078], [1393192020, 878371], [1393192080, 882365], [1393192140, 833653], [1393192200, 824823], [1393192260, 844445], [1393192320, 817960], [1393192380, 836334], [1393192440, 843395], [1393192500, 837949], [1393192560, 862573], [1393192620, 820761], [1393192680, 841861], [1393192740, 888088], [1393192800, 920159], [1393192860, 956675], [1393192920, 973505], [1393192980, 1015959], [1393193040, 1021674], [1393193100, 1043223], [1393193160, 1018034], [1393193220, 1067568], [1393193280, 1098280], [1393193340, 1080979], [1393193400, 1088767], [1393193460, 1134872], [1393193520, 1086508], [1393193580, 1036585], [1393193640, 1010355], [1393193700, 1050229], [1393193760, 1037590], [1393193820, 1041675], [1393193880, 1059460], [1393193940, 1079484], [1393194000, 1078573], [1393194060, 1106753], [1393194120, 1122829], [1393194180, 1151460], [1393194240, 1165209], [1393194300, 1207009], [1393194360, 1224786], [1393194420, 1192708], [1393194480, 1238694], [1393194540, 1254187], [1393194600, 1220055], [1393194660, 1250694], [1393194720, 1245975], [1393194780, 1212540], [1393194840, 1206274], [1393194900, 1159627], [1393194960, 1125742], [1393195020, 1078399], [1393195080, 1042091], [1393195140, 1079980], [1393195200, 1057894], [1393195260, 1049578], [1393195320, 1059793], [1393195380, 1046284], [1393195440, 1016396], [1393195500, 1012541], [1393195560, 1003768], [1393195620, 972616], [1393195680, 941439], [1393195740, 935134], [1393195800, 927877], [1393195860, 917219], [1393195920, 918753], [1393195980, 968530], [1393196040, 948634], [1393196100, 960798], [1393196160, 982971], [1393196220, 964060], [1393196280, 992403], [1393196340, 986911], [1393196400, 956028], [1393196460, 970243], [1393196520, 937952], [1393196580, 936622], [1393196640, 910364], [1393196700, 898528], [1393196760, 896084], [1393196820, 936932], [1393196880, 978480], [1393196940, 960075], [1393197000, 997547], [1393197060, 977861], [1393197120, 1002345], [1393197180, 1019515], [1393197240, 999730], [1393197300, 958958], [1393197360, 913564], [1393197420, 954002], [1393197480, 978102], [1393197540, 1022505], [1393197600, 1034965], [1393197660, 985775], [1393197720, 992462], [1393197780, 1009869], [1393197840, 1023920], [1393197900, 988639], [1393197960, 958466], [1393198020, 950184], [1393198080, 964275], [1393198140, 1011005], [1393198200, 993899], [1393198260, 1040886], [1393198320, 1056303], [1393198380, 1068721], [1393198440, 1105582], [1393198500, 1112267], [1393198560, 1064148], [1393198620, 1095956], [1393198680, 1066351], [1393198740, 1058211], [1393198800, 1044739], [1393198860, 1002008], [1393198920, 1004804], [1393198980, 985026], [1393199040, 981337], [1393199100, 991894], [1393199160, 969469], [1393199220, 968166], [1393199280, 1005473], [1393199340, 1007311], [1393199400, 1044797], [1393199460, 1065914], [1393199520, 1031344], [1393199580, 983641], [1393199640, 998337], [1393199700, 952299], [1393199760, 951491], [1393199820, 904644], [1393199880, 902086], [1393199940, 881563], [1393200000, 909355], [1393200060, 877089], [1393200120, 868150], [1393200180, 844752], [1393200240, 845211], [1393200300, 873795], [1393200360, 876337], [1393200420, 911673], [1393200480, 878242], [1393200540, 862255], [1393200600, 842636], [1393200660, 831416], [1393200720, 812932], [1393200780, 860986], [1393200840, 834029], [1393200900, 847682], [1393200960, 829962], [1393201020, 806436], [1393201080, 798281], [1393201140, 758479], [1393201200, 807918], [1393201260, 785750], [1393201320, 793724], [1393201380, 839959], [1393201440, 794611], [1393201500, 831231], [1393201560, 813430], [1393201620, 775501], [1393201680, 746484], [1393201740, 709979], [1393201800, 724569], [1393201860, 709531], [1393201920, 726922], [1393201980, 773624], [1393202040, 729780], [1393202100, 752458], [1393202160, 726087], [1393202220, 694658], [1393202280, 731352], [1393202340, 731625], [1393202400, 734721], [1393202460, 760206], [1393202520, 774457], [1393202580, 780171], [1393202640, 819351], [1393202700, 861273], [1393202760, 888675], [1393202820, 880075], [1393202880, 898176], [1393202940, 908860], [1393203000, 863573], [1393203060, 884957], [1393203120, 889699], [1393203180, 917885], [1393203240, 918202], [1393203300, 905818], [1393203360, 900928], [1393203420, 909999]]},
    '5m': {'received': [[1393117200, 3519006], [1393117500, 3413034], [1393117800, 3530960], [1393118100, 3308487], [1393118400, 3469029], [1393118700, 3512844], [1393119000, 3691499], [1393119300, 3936686], [1393119600, 4085096], [1393119900, 3927804], [1393120200, 4160789], [1393120500, 4244801], [1393120800, 4295441], [1393121100, 4373765], [1393121400, 4275882], [1393121700, 4115174], [1393122000, 4170018], [1393122300, 3987495], [1393122600, 3771895], [1393122900, 3879728], [1393123200, 3817718], [1393123500, 3604570], [1393123800, 3460516], [1393124100, 3347280], [1393124400, 3273780], [1393124700, 3375128], [1393125000, 3137960], [1393125300, 3370936], [1393125600, 3190286], [1393125900, 3085246], [1393126200, 3288816], [1393126500, 3496157], [1393126800, 3494717], [1393127100, 3462662], [1393127400, 3288622], [1393127700, 3380992], [1393128000, 3142866], [1393128300, 3373792], [1393128600, 3517010], [1393128900, 3294445], [1393129200, 3246703], [1393129500, 3177160], [1393129800, 2975458], [1393130100, 2928179], [1393130400, 2751546], [1393130700, 2734936], [1393131000, 2526184], [1393131300, 2675989], [1393131600, 2829343], [1393131900, 2927234], [1393132200, 2788250], [1393132500, 2749949], [1393132800, 2634418], [1393133100, 2794346], [1393133400, 2902335], [1393133700, 3054893], [1393134000, 2854229], [1393134300, 2742924], [1393134600, 2558060], [1393134900, 2732347], [1393135200, 2651344], [1393135500, 2742327], [1393135800, 2765511], [1393136100, 2943548], [1393136400, 2880894], [1393136700, 2802661], [1393137000, 2874324], [1393137300, 3004236], [1393137600, 2892418], [1393137900, 2760085], [1393138200, 2958177], [1393138500, 3031877], [1393138800, 2894905], [1393139100, 2857321], [1393139400, 3039857], [1393139700, 2954747], [1393140000, 3075428], [1393140300, 3247111], [1393140600, 3403930], [1393140900, 3239850], [1393141200, 3162583], [1393141500, 3340466], [1393141800, 3538594], [1393142100, 3445056], [1393142400, 3623255], [1393142700, 3658862], [1393143000, 3527819], [1393143300, 3620377], [1393143600, 3735357], [1393143900, 3528924], [1393144200, 3645422], [1393144500, 3396671], [1393144800, 3427522], [1393145100, 3440970], [1393145400, 3302392], [1393145700, 3487785], [1393146000, 3560822], [1393146300, 3484141], [1393146600, 3366891], [1393146900, 3283422], [1393147200, 3181201], [1393147500, 3100367], [1393147800, 2884478], [1393148100, 3003666], [1393148400, 2977625], [1393148700, 2933151], [1393149000, 2935670], [1393149300, 2808162], [1393149600, 2660376], [1393149900, 2782247], [1393150200, 2799273], [1393150500, 2893155], [1393150800, 2905154], [1393151100, 2777536], [1393151400, 2799662], [1393151700, 2559850], [1393152000, 2805352], [1393152300, 2954922], [1393152600, 3033304], [1393152900, 3109394], [1393153200, 3315269], [1393153500, 3108212], [1393153800, 3131355], [1393154100, 2981021], [1393154400, 2863422], [1393154700, 2650977], [1393155000, 2581941], [1393155300, 2499818], [1393155600, 2461532], [1393155900, 2467357], [1393156200, 2686155], [1393156500, 2890832], [1393156800, 2991240], [1393157100, 2781387], [1393157400, 2779245], [1393157700, 2712231], [1393158000, 2533183], [1393158300, 2572134], [1393158600, 2385506], [1393158900, 2230323], [1393159200, 2174522], [1393159500, 2056584], [1393159800, 1910870], [1393160100, 2020610], [1393160400, 1852020], [1393160700, 1961870], [1393161000, 2063519], [1393161300, 1918201], [1393161600, 2041100], [1393161900, 2063936], [1393162200, 1840810], [1393162500, 2053260], [1393162800, 1835361], [1393163100, 1713011], [1393163400, 1848553], [1393163700, 2006141], [1393164000, 2043626], [1393164300, 1796694], [1393164600, 1780073], [1393164900, 2005844], [1393165200, 1780537], [1393165500, 1932087], [1393165800, 2113662], [1393166100, 2065978], [1393166400, 1991294], [1393166700, 2129261], [1393167000, 1969412], [1393167300, 2050576], [1393167600, 1933290], [1393167900, 2018346], [1393168200, 2047701], [1393168500, 1886591], [1393168800, 2039723], [1393169100, 2277696], [1393169400, 2418453], [1393169700, 2535389], [1393170000, 2450857], [1393170300, 2686403], [1393170600, 2512388], [1393170900, 2751969], [1393171200, 2956133], [1393171500, 2931103], [1393171800, 2817906], [1393172100, 2963137], [1393172400, 3164682], [1393172700, 2974305], [1393173000, 2889917], [1393173300, 3044252], [1393173600, 3204669], [1393173900, 3123896], [1393174200, 3296848], [1393174500, 3424866], [1393174800, 3320842], [1393175100, 3259254], [1393175400, 3072159], [1393175700, 3198827], [1393176000, 3403825], [1393176300, 3329168], [1393176600, 3445032], [1393176900, 3526654], [1393177200, 3397248], [1393177500, 3412771], [1393177800, 3300040], [1393178100, 3505979], [1393178400, 3345316], [1393178700, 3295137], [1393179000, 3078108], [1393179300, 3202809], [1393179600, 3271077], [1393179900, 3341259], [1393180200, 3162499], [1393180500, 3209962], [1393180800, 3209878], [1393181100, 3392386], [1393181400, 3530984], [1393181700, 3556689], [1393182000, 3388295], [1393182300, 3375853], [1393182600, 3375598], [1393182900, 3428607], [1393183200, 3584399], [1393183500, 3345261], [1393183800, 3291440], [1393184100, 3452522], [1393184400, 3535524], [1393184700, 3471816], [1393185000, 3432001], [1393185300, 3205368], [1393185600, 3443043], [1393185900, 3333091], [1393186200, 3255443], [1393186500, 3031564], [1393186800, 2994289], [1393187100, 2848152], [1393187400, 2602642], [1393187700, 2745507], [1393188000, 2985294], [1393188300, 2849345], [1393188600, 2856981], [1393188900, 2932818], [1393189200, 2935034], [1393189500, 2982407], [1393189800, 2964834], [1393190100, 2839521], [1393190400, 3088999], [1393190700, 2951131], [1393191000, 2886803], [1393191300, 3083901], [1393191600, 2952409], [1393191900, 2881193], [1393192200, 2793662], [1393192500, 2547372], [1393192800, 2662842], [1393193100, 2828736], [1393193400, 2669561], [1393193700, 2615073], [1393194000, 2368301], [1393194300, 2217197], [1393194600, 2450683], [1393194900, 2649568], [1393195200, 2737605], [1393195500, 2773397], [1393195800, 2672263], [1393196100, 2515971], [1393196400, 2466684], [1393196700, 2562251], [1393197000, 2586299], [1393197300, 2694057], [1393197600, 2641533], [1393197900, 2595384], [1393198200, 2365455], [1393198500, 2169062], [1393198800, 2163286], [1393199100, 1951228], [1393199400, 1944346], [1393199700, 1887922], [1393200000, 2122107], [1393200300, 1958200], [1393200600, 2171574], [1393200900, 1949811], [1393201200, 1911024], [1393201500, 1750799], [1393201800, 1580341], [1393202100, 1778775], [1393202400, 1567651], [1393202700, 1546483], [1393203000, 1553882], [1393203300, 1726147]], 'sent': [[1393117200, 3601706], [1393117500, 3749511], [1393117800, 3997362], [1393118100, 3765731], [1393118400, 3947874], [1393118700, 3901390], [1393119000, 3835170], [1393119300, 3668155], [1393119600, 3732570], [1393119900, 3899582], [1393120200, 3978606], [1393120500, 4031996], [1393120800, 4172132], [1393121100, 3999695], [1393121400, 3812919], [1393121700, 3922643], [1393122000, 3865913], [1393122300, 3744193], [1393122600, 3959136], [1393122900, 3939031], [1393123200, 4121284], [1393123500, 4102805], [1393123800, 4279241], [1393124100, 4181240], [1393124400, 4139789], [1393124700, 4165850], [1393125000, 4240652], [1393125300, 4367339], [1393125600, 4232234], [1393125900, 4207328], [1393126200, 4122592], [1393126500, 4231307], [1393126800, 4205051], [1393127100, 3993120], [1393127400, 3890730], [1393127700, 4016982], [1393128000, 4027448], [1393128300, 3977780], [1393128600, 3911488], [1393128900, 3744655], [1393129200, 3593990], [1393129500, 3603238], [1393129800, 3464194], [1393130100, 3649109], [1393130400, 3888585], [1393130700, 3748823], [1393131000, 3609132], [1393131300, 3511388], [1393131600, 3552021], [1393131900, 3547313], [1393132200, 3728327], [1393132500, 3824673], [1393132800, 3934991], [1393133100, 3958949], [1393133400, 3931565], [1393133700, 3812029], [1393134000, 3693069], [1393134300, 3552224], [1393134600, 3696687], [1393134900, 3617497], [1393135200, 3408870], [1393135500, 3582621], [1393135800, 3742664], [1393136100, 3641982], [1393136400, 3745900], [1393136700, 3652694], [1393137000, 3855297], [1393137300, 4006433], [1393137600, 3911764], [1393137900, 3817094], [1393138200, 3623854], [1393138500, 3505849], [1393138800, 3366883], [1393139100, 3287509], [1393139400, 3416946], [1393139700, 3172120], [1393140000, 3374275], [1393140300, 3213674], [1393140600, 3218585], [1393140900, 3285727], [1393141200, 3233392], [1393141500, 3214089], [1393141800, 3094194], [1393142100, 3204737], [1393142400, 3332287], [1393142700, 3106718], [1393143000, 3023344], [1393143300, 2930249], [1393143600, 2777874], [1393143900, 2768707], [1393144200, 2819948], [1393144500, 3022367], [1393144800, 3124442], [1393145100, 3106342], [1393145400, 3265288], [1393145700, 3096734], [1393146000, 3055923], [1393146300, 2808138], [1393146600, 2708652], [1393146900, 2811870], [1393147200, 2566045], [1393147500, 2339675], [1393147800, 2440173], [1393148100, 2233465], [1393148400, 2449052], [1393148700, 2463087], [1393149000, 2651222], [1393149300, 2839760], [1393149600, 2651330], [1393149900, 2829647], [1393150200, 2853333], [1393150500, 2610329], [1393150800, 2761184], [1393151100, 2990910], [1393151400, 3079470], [1393151700, 3318943], [1393152000, 3506782], [1393152300, 3403779], [1393152600, 3314795], [1393152900, 3545950], [1393153200, 3771284], [1393153500, 3864720], [1393153800, 3715122], [1393154100, 3792369], [1393154400, 3648310], [1393154700, 3870267], [1393155000, 3745906], [1393155300, 3728795], [1393155600, 3585950], [1393155900, 3481661], [1393156200, 3362884], [1393156500, 3373496], [1393156800, 3517122], [1393157100, 3279928], [1393157400, 3064743], [1393157700, 3284570], [1393158000, 3125951], [1393158300, 3085714], [1393158600, 2968756], [1393158900, 2971320], [1393159200, 3164621], [1393159500, 3412269], [1393159800, 3249849], [1393160100, 3398054], [1393160400, 3513445], [1393160700, 3368990], [1393161000, 3449380], [1393161300, 3659100], [1393161600, 3512568], [1393161900, 3696391], [1393162200, 3634937], [1393162500, 3546603], [1393162800, 3326629], [1393163100, 3363155], [1393163400, 3578961], [1393163700, 3579823], [1393164000, 3496713], [1393164300, 3496460], [1393164600, 3525629], [1393164900, 3715561], [1393165200, 3743583], [1393165500, 3579002], [1393165800, 3823186], [1393166100, 3742099], [1393166400, 3508721], [1393166700, 3386293], [1393167000, 3245879], [1393167300, 3195633], [1393167600, 3220581], [1393167900, 3462896], [1393168200, 3287058], [1393168500, 3328266], [1393168800, 3460625], [1393169100, 3328641], [1393169400, 3345339], [1393169700, 3173837], [1393170000, 2956193], [1393170300, 3025662], [1393170600, 3260291], [1393170900, 3079535], [1393171200, 3028935], [1393171500, 3167906], [1393171800, 3047880], [1393172100, 3130997], [1393172400, 3362827], [1393172700, 3114336], [1393173000, 3177399], [1393173300, 3228173], [1393173600, 3373059], [1393173900, 3418356], [1393174200, 3272884], [1393174500, 3387136], [1393174800, 3181326], [1393175100, 3063020], [1393175400, 2987829], [1393175700, 3171042], [1393176000, 3033664], [1393176300, 2818652], [1393176600, 2784588], [1393176900, 2543923], [1393177200, 2659377], [1393177500, 2557222], [1393177800, 2609052], [1393178100, 2433402], [1393178400, 2494679], [1393178700, 2523727], [1393179000, 2458038], [1393179300, 2514044], [1393179600, 2322200], [1393179900, 2224436], [1393180200, 2130257], [1393180500, 2316036], [1393180800, 2136105], [1393181100, 2217532], [1393181400, 2022237], [1393181700, 2001332], [1393182000, 2006149], [1393182300, 1894789], [1393182600, 1720058], [1393182900, 1604221], [1393183200, 1710816], [1393183500, 1629754], [1393183800, 1563464], [1393184100, 1494424], [1393184400, 1321184], [1393184700, 1269862], [1393185000, 1111460], [1393185300, 1195210], [1393185600, 1294487], [1393185900, 1355229], [1393186200, 1590620], [1393186500, 1778996], [1393186800, 1702947], [1393187100, 1625542], [1393187400, 1756598], [1393187700, 1755536], [1393188000, 1916203], [1393188300, 1838991], [1393188600, 1678532], [1393188900, 1698561], [1393189200, 1629410], [1393189500, 1408567], [1393189800, 1644917], [1393190100, 1670195], [1393190400, 1675066], [1393190700, 1914287], [1393191000, 2058490], [1393191300, 2085068], [1393191600, 2041245], [1393191900, 2260689], [1393192200, 2470453], [1393192500, 2456332], [1393192800, 2206634], [1393193100, 2364843], [1393193400, 2162567], [1393193700, 2006175], [1393194000, 2171832], [1393194300, 2052896], [1393194600, 2007103], [1393194900, 1906544], [1393195200, 2056088], [1393195500, 2080743], [1393195800, 2188145], [1393196100, 1969634], [1393196400, 2168916], [1393196700, 2284944], [1393197000, 2137720], [1393197300, 2263959], [1393197600, 2290287], [1393197900, 2356256], [1393198200, 2528887], [1393198500, 2512135], [1393198800, 2327901], [1393199100, 2145002], [1393199400, 2299352], [1393199700, 2218651], [1393200000, 2394335], [1393200300, 2284844], [1393200600, 2506247], [1393200900, 2445556], [1393201200, 2546924], [1393201500, 2693568], [1393201800, 2753785], [1393202100, 2806497], [1393202400, 2956790], [1393202700, 2872438], [1393203000, 2789344], [1393203300, 2755397]]},
    '30m': {'received': [[1392602400, 22177096], [1392604200, 20756322], [1392606000, 21504642], [1392607800, 20644166], [1392609600, 20733869], [1392611400, 20110638], [1392613200, 18594794], [1392615000, 18638867], [1392616800, 19763353], [1392618600, 18205818], [1392620400, 18683765], [1392622200, 20012256], [1392624000, 20036749], [1392625800, 21292217], [1392627600, 21052886], [1392629400, 19680969], [1392631200, 18496906], [1392633000, 18446323], [1392634800, 17147479], [1392636600, 17885287], [1392638400, 17279670], [1392640200, 15974986], [1392642000, 14484322], [1392643800, 13837738], [1392645600, 14555740], [1392647400, 14134033], [1392649200, 13586823], [1392651000, 13900405], [1392652800, 15514272], [1392654600, 15734412], [1392656400, 13972004], [1392658200, 13631599], [1392660000, 12735673], [1392661800, 11232022], [1392663600, 9758120], [1392665400, 11271749], [1392667200, 12098520], [1392669000, 13566338], [1392670800, 15311102], [1392672600, 16124809], [1392674400, 15367534], [1392676200, 15324416], [1392678000, 15293277], [1392679800, 15172090], [1392681600, 15523470], [1392683400, 17108389], [1392685200, 17207992], [1392687000, 18932491], [1392688800, 20560038], [1392690600, 19576078], [1392692400, 19330194], [1392694200, 18865221], [1392696000, 20304122], [1392697800, 20583476], [1392699600, 18583682], [1392701400, 20132020], [1392703200, 21844048], [1392705000, 19845078], [1392706800, 18551891], [1392708600, 17530241], [1392710400, 15811275], [1392712200, 17639025], [1392714000, 17350790], [1392715800, 19196530], [1392717600, 19196873], [1392719400, 19780126], [1392721200, 21620591], [1392723000, 21232703], [1392724800, 21075158], [1392726600, 22428219], [1392728400, 23664479], [1392730200, 23648965], [1392732000, 21976376], [1392733800, 23619622], [1392735600, 22060799], [1392737400, 20210736], [1392739200, 18433859], [1392741000, 17522465], [1392742800, 17591701], [1392744600, 18814867], [1392746400, 18195712], [1392748200, 17795705], [1392750000, 18454400], [1392751800, 17469593], [1392753600, 17827816], [1392755400, 17976583], [1392757200, 16366528], [1392759000, 15900251], [1392760800, 17680365], [1392762600, 16396391], [1392764400, 16728131], [1392766200, 18059345], [1392768000, 20049488], [1392769800, 18986657], [1392771600, 19616085], [1392773400, 20141831], [1392775200, 18352632], [1392777000, 17354545], [1392778800, 17660513], [1392780600, 15855452], [1392782400, 15445723], [1392784200, 15963329], [1392786000, 16709024], [1392787800, 17598547], [1392789600, 16831462], [1392791400, 16450141], [1392793200, 17782422], [1392795000, 17284115], [1392796800, 19271636], [1392798600, 19619341], [1392800400, 21227784], [1392802200, 20949947], [1392804000, 19511689], [1392805800, 18868380], [1392807600, 18212315], [1392809400, 18241876], [1392811200, 18892694], [1392813000, 18531467], [1392814800, 16880939], [1392816600, 17085598], [1392818400, 15415394], [1392820200, 14430284], [1392822000, 14957691], [1392823800, 15495176], [1392825600, 16638091], [1392827400, 16553991], [1392829200, 15225036], [1392831000, 16409932], [1392832800, 16298184], [1392834600, 15740796], [1392836400, 17401373], [1392838200, 15477391], [1392840000, 16433936], [1392841800, 15538988], [1392843600, 15699561], [1392845400, 15245994], [1392847200, 15069616], [1392849000, 15497172], [1392850800, 16979887], [1392852600, 15294623], [1392854400, 15248159], [1392856200, 13349907], [1392858000, 15089118], [1392859800, 15081551], [1392861600, 13908916], [1392863400, 15716427], [1392865200, 16351334], [1392867000, 17837947], [1392868800, 16615392], [1392870600, 16775037], [1392872400, 18398309], [1392874200, 16694068], [1392876000, 15214163], [1392877800, 15352331], [1392879600, 14203379], [1392881400, 15965056], [1392883200, 15835778], [1392885000, 14624184], [1392886800, 14225639], [1392888600, 15489298], [1392890400, 17019822], [1392892200, 17424952], [1392894000, 17293768], [1392895800, 18985160], [1392897600, 20241999], [1392899400, 20414118], [1392901200, 19379954], [1392903000, 19511965], [1392904800, 17738729], [1392906600, 18903569], [1392908400, 20513916], [1392910200, 18643104], [1392912000, 18280152], [1392913800, 19875926], [1392915600, 18957789], [1392917400, 20219204], [1392919200, 20026677], [1392921000, 21625418], [1392922800, 22606689], [1392924600, 20751066], [1392926400, 18828898], [1392928200, 20587590], [1392930000, 20626311], [1392931800, 19534862], [1392933600, 21236506], [1392935400, 22849546], [1392937200, 24798633], [1392939000, 24532137], [1392940800, 25398502], [1392942600, 26208243], [1392944400, 27587792], [1392946200, 28202912], [1392948000, 29586015], [1392949800, 29203734], [1392951600, 28460677], [1392953400, 27316676], [1392955200, 27051220], [1392957000, 25171573], [1392958800, 24214252], [1392960600, 25345249], [1392962400, 24427634], [1392964200, 23883865], [1392966000, 23066327], [1392967800, 24900809], [1392969600, 25172679], [1392971400, 27153854], [1392973200, 28598489], [1392975000, 27435742], [1392976800, 29034884], [1392978600, 28744519], [1392980400, 29439434], [1392982200, 27747654], [1392984000, 29409398], [1392985800, 27980248], [1392987600, 28995005], [1392989400, 27902289], [1392991200, 29058333], [1392993000, 30079161], [1392994800, 30050082], [1392996600, 28643981], [1392998400, 27849103], [1393000200, 27323321], [1393002000, 26343575], [1393003800, 27591390], [1393005600, 28617859], [1393007400, 27509089], [1393009200, 27306626], [1393011000, 27246676], [1393012800, 27965911], [1393014600, 27620045], [1393016400, 25750929], [1393018200, 26487842], [1393020000, 26327207], [1393021800, 24710675], [1393023600, 25006568], [1393025400, 24896962], [1393027200, 23534688], [1393029000, 25382485], [1393030800, 24794881], [1393032600, 24410643], [1393034400, 24128241], [1393036200, 24188042], [1393038000, 26003613], [1393039800, 25827701], [1393041600, 26056790], [1393043400, 24353999], [1393045200, 23221872], [1393047000, 21432996], [1393048800, 23189574], [1393050600, 21772047], [1393052400, 21082164], [1393054200, 21355633], [1393056000, 22183154], [1393057800, 21163285], [1393059600, 19485673], [1393061400, 18503461], [1393063200, 19204299], [1393065000, 17876327], [1393066800, 17251095], [1393068600, 19110335], [1393070400, 20670963], [1393072200, 20480497], [1393074000, 20950361], [1393075800, 19237616], [1393077600, 18345284], [1393079400, 19273533], [1393081200, 20739301], [1393083000, 19244195], [1393084800, 17687754], [1393086600, 16005774], [1393088400, 16058552], [1393090200, 14406820], [1393092000, 16217491], [1393093800, 15256540], [1393095600, 14581019], [1393097400, 13025048], [1393099200, 14154589], [1393101000, 14800846], [1393102800, 16550371], [1393104600, 15390384], [1393106400, 17291107], [1393108200, 16631682], [1393110000, 17370580], [1393111800, 16405588], [1393113600, 16874515], [1393115400, 17896328], [1393117200, 16307304], [1393119000, 16369136], [1393120800, 15454888], [1393122600, 16365941], [1393124400, 14653703], [1393126200, 15734607], [1393128000, 15826704], [1393129800, 17394415], [1393131600, 19213649], [1393133400, 19971300], [1393135200, 18565945], [1393137000, 17423564], [1393138800, 16363722], [1393140600, 17925043], [1393142400, 19154555], [1393144200, 18080217], [1393146000, 17413577], [1393147800, 18201060], [1393149600, 18065367], [1393151400, 19175317], [1393153200, 20688351], [1393155000, 21976565], [1393156800, 21852533], [1393158600, 20881405], [1393160400, 21729532], [1393162200, 22196103], [1393164000, 20459034], [1393165800, 19502663], [1393167600, 18386054], [1393169400, 16466218], [1393171200, 18365819], [1393173000, 18886574], [1393174800, 17047324], [1393176600, 16647021], [1393178400, 15040432], [1393180200, 16141789], [1393182000, 16510008], [1393183800, 16453229], [1393185600, 18026055], [1393187400, 16166126], [1393189200, 16561677], [1393191000, 14767902], [1393192800, 16683215], [1393194600, 17515062], [1393196400, 15961112], [1393198200, 16040494], [1393200000, 16178592], [1393201800, 17860520], [1393203600, 19451329], [1393205400, 17494420]], 'sent': [[1392602400, 19955107], [1392604200, 19454464], [1392606000, 20069412], [1392607800, 19534730], [1392609600, 21147573], [1392611400, 21849582], [1392613200, 21198574], [1392615000, 19768995], [1392616800, 20565982], [1392618600, 21107781], [1392620400, 22042207], [1392622200, 23519902], [1392624000, 23167552], [1392625800, 22200490], [1392627600, 23124494], [1392629400, 22393863], [1392631200, 24160876], [1392633000, 24468283], [1392634800, 25363913], [1392636600, 24006585], [1392638400, 24900336], [1392640200, 23351938], [1392642000, 21582328], [1392643800, 22806684], [1392645600, 22496183], [1392647400, 21126345], [1392649200, 21121198], [1392651000, 20947016], [1392652800, 22180268], [1392654600, 20556207], [1392656400, 21723316], [1392658200, 19921644], [1392660000, 19950426], [1392661800, 20318571], [1392663600, 20384635], [1392665400, 19259821], [1392667200, 19456798], [1392669000, 18827272], [1392670800, 18570932], [1392672600, 18888196], [1392674400, 20330557], [1392676200, 20190569], [1392678000, 20398669], [1392679800, 20291661], [1392681600, 20737518], [1392683400, 20951229], [1392685200, 20837874], [1392687000, 19469302], [1392688800, 18719866], [1392690600, 17947360], [1392692400, 18898560], [1392694200, 17595241], [1392696000, 17100437], [1392697800, 16845296], [1392699600, 14998166], [1392701400, 14275150], [1392703200, 14259437], [1392705000, 13410928], [1392706800, 12704118], [1392708600, 13532814], [1392710400, 15456483], [1392712200, 17106059], [1392714000, 15515509], [1392715800, 16396418], [1392717600, 16934962], [1392719400, 16313804], [1392721200, 14945866], [1392723000, 15483787], [1392724800, 16515771], [1392726600, 18010872], [1392728400, 19549999], [1392730200, 19901182], [1392732000, 19079404], [1392733800, 18395482], [1392735600, 18304373], [1392737400, 19525248], [1392739200, 19007481], [1392741000, 17262874], [1392742800, 16046370], [1392744600, 17706025], [1392746400, 18167920], [1392748200, 19463870], [1392750000, 20699024], [1392751800, 21587901], [1392753600, 20361426], [1392755400, 18624130], [1392757200, 17901042], [1392759000, 19338148], [1392760800, 18400295], [1392762600, 19560280], [1392764400, 20642414], [1392766200, 22486683], [1392768000, 23820510], [1392769800, 24654062], [1392771600, 23776808], [1392773400, 23529292], [1392775200, 25217005], [1392777000, 23870287], [1392778800, 22940274], [1392780600, 23137694], [1392782400, 24351883], [1392784200, 25014450], [1392786000, 25222889], [1392787800, 27171750], [1392789600, 25358473], [1392791400, 24455712], [1392793200, 26086704], [1392795000, 25304535], [1392796800, 25847053], [1392798600, 24572528], [1392800400, 25473272], [1392802200, 24132091], [1392804000, 24152733], [1392805800, 25349435], [1392807600, 26978522], [1392809400, 27584968], [1392811200, 26335692], [1392813000, 27014227], [1392814800, 26997171], [1392816600, 26459842], [1392818400, 24805687], [1392820200, 23716745], [1392822000, 25455183], [1392823800, 24125551], [1392825600, 22794091], [1392827400, 22967115], [1392829200, 21561169], [1392831000, 23506829], [1392832800, 24913781], [1392834600, 23850143], [1392836400, 25684314], [1392838200, 25661483], [1392840000, 24344781], [1392841800, 24211190], [1392843600, 24230100], [1392845400, 25142279], [1392847200, 26732352], [1392849000, 27975292], [1392850800, 28784804], [1392852600, 27816257], [1392854400, 28394354], [1392856200, 27852791], [1392858000, 29603668], [1392859800, 29658615], [1392861600, 28137772], [1392863400, 27063020], [1392865200, 25523032], [1392867000, 24064465], [1392868800, 24611656], [1392870600, 24118123], [1392872400, 25173238], [1392874200, 26175054], [1392876000, 24345567], [1392877800, 22376762], [1392879600, 23029220], [1392881400, 22300504], [1392883200, 21110247], [1392885000, 19178818], [1392886800, 19324185], [1392888600, 19641499], [1392890400, 19553634], [1392892200, 20217192], [1392894000, 21407201], [1392895800, 19589478], [1392897600, 21031810], [1392899400, 22619985], [1392901200, 24164407], [1392903000, 25098405], [1392904800, 27019652], [1392906600, 25523491], [1392908400, 24308331], [1392910200, 23110664], [1392912000, 24600307], [1392913800, 26043333], [1392915600, 26091605], [1392917400, 25400996], [1392919200, 26652817], [1392921000, 25492908], [1392922800, 27315914], [1392924600, 28434288], [1392926400, 27690899], [1392928200, 27991355], [1392930000, 29241924], [1392931800, 27670599], [1392933600, 26019951], [1392935400, 26801973], [1392937200, 28010859], [1392939000, 26744326], [1392940800, 26851431], [1392942600, 28539311], [1392944400, 29655079], [1392946200, 27876918], [1392948000, 29380140], [1392949800, 29691573], [1392951600, 27820959], [1392953400, 29356085], [1392955200, 28829699], [1392957000, 30441381], [1392958800, 28774178], [1392960600, 29435751], [1392962400, 29354845], [1392964200, 30245211], [1392966000, 30700547], [1392967800, 32610260], [1392969600, 33471323], [1392971400, 35222389], [1392973200, 33718412], [1392975000, 33116572], [1392976800, 32500450], [1392978600, 31606059], [1392980400, 30972792], [1392982200, 30466340], [1392984000, 31857470], [1392985800, 32653287], [1392987600, 34294813], [1392989400, 35252200], [1392991200, 33282375], [1392993000, 34122291], [1392994800, 36079952], [1392996600, 36504460], [1392998400, 36283871], [1393000200, 35821919], [1393002000, 34297858], [1393003800, 34911227], [1393005600, 34306134], [1393007400, 32434272], [1393009200, 33967175], [1393011000, 32488030], [1393012800, 33392539], [1393014600, 34574426], [1393016400, 32961530], [1393018200, 31119857], [1393020000, 29909198], [1393021800, 28135970], [1393023600, 28434228], [1393025400, 28691184], [1393027200, 30307501], [1393029000, 28491174], [1393030800, 27610451], [1393032600, 27569151], [1393034400, 28937749], [1393036200, 28940881], [1393038000, 30740332], [1393039800, 31055520], [1393041600, 31519504], [1393043400, 32745592], [1393045200, 32769213], [1393047000, 31679027], [1393048800, 29960434], [1393050600, 29773017], [1393052400, 28659105], [1393054200, 29263181], [1393056000, 30075001], [1393057800, 28355634], [1393059600, 29583135], [1393061400, 28997543], [1393063200, 29618407], [1393065000, 30834779], [1393066800, 31254408], [1393068600, 31940474], [1393070400, 30698676], [1393072200, 29281260], [1393074000, 30973118], [1393075800, 31630304], [1393077600, 31209045], [1393079400, 32315918], [1393081200, 32191628], [1393083000, 32686790], [1393084800, 31444753], [1393086600, 29976868], [1393088400, 28899299], [1393090200, 29729019], [1393092000, 28609853], [1393093800, 27289725], [1393095600, 26510454], [1393097400, 27565524], [1393099200, 28276802], [1393101000, 29120601], [1393102800, 27864495], [1393104600, 26962411], [1393106400, 27890311], [1393108200, 29079800], [1393110000, 27816947], [1393111800, 28003490], [1393113600, 28445235], [1393115400, 26770436], [1393117200, 24896723], [1393119000, 24550088], [1393120800, 23943143], [1393122600, 25910033], [1393124400, 27068553], [1393126200, 25938266], [1393128000, 25556875], [1393129800, 26653109], [1393131600, 28423087], [1393133400, 27061599], [1393135200, 27326852], [1393137000, 28263002], [1393138800, 29970339], [1393140600, 29622114], [1393142400, 31343381], [1393144200, 33021602], [1393146000, 34914071], [1393147800, 36121371], [1393149600, 36178138], [1393151400, 36476847], [1393153200, 35184335], [1393155000, 36255764], [1393156800, 34675593], [1393158600, 33681284], [1393160400, 35360234], [1393162200, 33423905], [1393164000, 32589141], [1393165800, 31570350], [1393167600, 30836407], [1393169400, 32078985], [1393171200, 30766117], [1393173000, 31714764], [1393174800, 32876957], [1393176600, 31494368], [1393178400, 32035273], [1393180200, 33403482], [1393182000, 31661189], [1393183800, 30321244], [1393185600, 28745338], [1393187400, 29231931], [1393189200, 30346968], [1393191000, 31380314], [1393192800, 31686550], [1393194600, 31989167], [1393196400, 31662193], [1393198200, 32993892], [1393200000, 33530154], [1393201800, 33719087], [1393203600, 33130364], [1393205400, 31210178]]},
    '2h': {'received': [[1390615200, 82183816], [1390622400, 82512579], [1390629600, 82712347], [1390636800, 83675789], [1390644000, 83631078], [1390651200, 84246561], [1390658400, 85570365], [1390665600, 85795955], [1390672800, 86509384], [1390680000, 87771448], [1390687200, 87075107], [1390694400, 87451321], [1390701600, 88094433], [1390708800, 86789702], [1390716000, 85299995], [1390723200, 87049467], [1390730400, 85095315], [1390737600, 83666464], [1390744800, 82308895], [1390752000, 84253986], [1390759200, 85113329], [1390766400, 86819566], [1390773600, 85586931], [1390780800, 85048993], [1390788000, 83337273], [1390795200, 81349940], [1390802400, 80374031], [1390809600, 80426492], [1390816800, 80690882], [1390824000, 80949041], [1390831200, 79480247], [1390838400, 80985220], [1390845600, 80287691], [1390852800, 78522744], [1390860000, 80268825], [1390867200, 79656474], [1390874400, 78492254], [1390881600, 76686343], [1390888800, 75299332], [1390896000, 75444449], [1390903200, 77206732], [1390910400, 79018185], [1390917600, 79043280], [1390924800, 80524791], [1390932000, 80880193], [1390939200, 82144522], [1390946400, 82351749], [1390953600, 81976861], [1390960800, 80728714], [1390968000, 80874111], [1390975200, 82189224], [1390982400, 83038790], [1390989600, 81628307], [1390996800, 80439183], [1391004000, 79630133], [1391011200, 79261129], [1391018400, 79219444], [1391025600, 77620611], [1391032800, 76116368], [1391040000, 75919343], [1391047200, 77736503], [1391054400, 78873619], [1391061600, 79621758], [1391068800, 80283148], [1391076000, 81506719], [1391083200, 80642592], [1391090400, 80295324], [1391097600, 79982220], [1391104800, 80829665], [1391112000, 82358927], [1391119200, 83494012], [1391126400, 83417964], [1391133600, 82444210], [1391140800, 82807534], [1391148000, 83798562], [1391155200, 83148399], [1391162400, 83703253], [1391169600, 84109401], [1391176800, 85928708], [1391184000, 86907834], [1391191200, 86151798], [1391198400, 86175369], [1391205600, 88035432], [1391212800, 86867222], [1391220000, 88218092], [1391227200, 89219398], [1391234400, 88540568], [1391241600, 89120024], [1391248800, 88928692], [1391256000, 89662216], [1391263200, 90923427], [1391270400, 89431507], [1391277600, 88170386], [1391284800, 88372065], [1391292000, 90125321], [1391299200, 91733625], [1391306400, 92101632], [1391313600, 92441404], [1391320800, 92113006], [1391328000, 90784336], [1391335200, 90862249], [1391342400, 89057962], [1391349600, 89393027], [1391356800, 87634954], [1391364000, 88290092], [1391371200, 87128973], [1391378400, 87699761], [1391385600, 86826943], [1391392800, 87710977], [1391400000, 88972873], [1391407200, 89953519], [1391414400, 90203744], [1391421600, 91088676], [1391428800, 90483121], [1391436000, 90711050], [1391443200, 92111312], [1391450400, 90826682], [1391457600, 90227016], [1391464800, 91724823], [1391472000, 89781053], [1391479200, 88599004], [1391486400, 88472308], [1391493600, 88560893], [1391500800, 89339449], [1391508000, 88541232], [1391515200, 88484094], [1391522400, 90417228], [1391529600, 90597758], [1391536800, 89113148], [1391544000, 87270352], [1391551200, 88223411], [1391558400, 88804798], [1391565600, 89441280], [1391572800, 87586297], [1391580000, 87259145], [1391587200, 85925017], [1391594400, 86436665], [1391601600, 85083599], [1391608800, 84033306], [1391616000, 83714538], [1391623200, 85199138], [1391630400, 86374554], [1391637600, 86858185], [1391644800, 88297231], [1391652000, 89483700], [1391659200, 90964259], [1391666400, 92793423], [1391673600, 92325066], [1391680800, 90440993], [1391688000, 90417629], [1391695200, 89084537], [1391702400, 89698927], [1391709600, 87819110], [1391716800, 87121788], [1391724000, 86832035], [1391731200, 88398919], [1391738400, 86533873], [1391745600, 87989838], [1391752800, 86791827], [1391760000, 88476900], [1391767200, 87629736], [1391774400, 87678710], [1391781600, 87402317], [1391788800, 86991900], [1391796000, 87994225], [1391803200, 89352861], [1391810400, 88293868], [1391817600, 87918477], [1391824800, 87835280], [1391832000, 87724319], [1391839200, 87963801], [1391846400, 87755531], [1391853600, 88214332], [1391860800, 89158401], [1391868000, 87252372], [1391875200, 86689602], [1391882400, 87216224], [1391889600, 88434962], [1391896800, 88017696], [1391904000, 89958727], [1391911200, 89879850], [1391918400, 88640545], [1391925600, 88829709], [1391932800, 89818327], [1391940000, 90268761], [1391947200, 89506893], [1391954400, 89450914], [1391961600, 88234499], [1391968800, 88621637], [1391976000, 90473445], [1391983200, 89145696], [1391990400, 90372428], [1391997600, 91300920], [1392004800, 92862239], [1392012000, 91283813], [1392019200, 89767470], [1392026400, 90843878], [1392033600, 92473866], [1392040800, 92511305], [1392048000, 92192434], [1392055200, 92018294], [1392062400, 90240790], [1392069600, 89698207], [1392076800, 90161085], [1392084000, 90985864], [1392091200, 91744306], [1392098400, 91150657], [1392105600, 92703433], [1392112800, 90872174], [1392120000, 90757812], [1392127200, 89955065], [1392134400, 89624682], [1392141600, 88872155], [1392148800, 88759873], [1392156000, 86940506], [1392163200, 86728280], [1392170400, 85670621], [1392177600, 84270235], [1392184800, 85042955], [1392192000, 86358670], [1392199200, 85108623], [1392206400, 86252082], [1392213600, 85050730], [1392220800, 85220287], [1392228000, 85834426], [1392235200, 83870959], [1392242400, 83571001], [1392249600, 83095615], [1392256800, 85067053], [1392264000, 84267761], [1392271200, 82548256], [1392278400, 81902139], [1392285600, 82449968], [1392292800, 83469432], [1392300000, 81702013], [1392307200, 83080972], [1392314400, 83856586], [1392321600, 82477714], [1392328800, 83532656], [1392336000, 82797068], [1392343200, 84787168], [1392350400, 83699357], [1392357600, 83696885], [1392364800, 84401564], [1392372000, 84469423], [1392379200, 85359546], [1392386400, 86129726], [1392393600, 87185276], [1392400800, 87408025], [1392408000, 86750246], [1392415200, 86258362], [1392422400, 87046774], [1392429600, 87299231], [1392436800, 86023016], [1392444000, 86940627], [1392451200, 88649098], [1392458400, 87393502], [1392465600, 88170677], [1392472800, 89147797], [1392480000, 88366900], [1392487200, 88890886], [1392494400, 89820339], [1392501600, 91284048], [1392508800, 92667142], [1392516000, 92087341], [1392523200, 91329462], [1392530400, 90730923], [1392537600, 89508996], [1392544800, 90171410], [1392552000, 89223282], [1392559200, 88069597], [1392566400, 89693161], [1392573600, 89181364], [1392580800, 89710081], [1392588000, 90769054], [1392595200, 90595608], [1392602400, 91272025], [1392609600, 90419750], [1392616800, 88813006], [1392624000, 88568914], [1392631200, 89969499], [1392638400, 91711957], [1392645600, 90693884], [1392652800, 90301273], [1392660000, 88683007], [1392667200, 89945075], [1392674400, 89203688], [1392681600, 91190868], [1392688800, 92077756], [1392696000, 93501636], [1392703200, 94324329], [1392710400, 93488366], [1392717600, 92504368], [1392724800, 92929501], [1392732000, 93755433], [1392739200, 94322869], [1392746400, 94556888], [1392753600, 93410239], [1392760800, 92075323], [1392768000, 90760430], [1392775200, 89883181], [1392782400, 90019107], [1392789600, 91019218], [1392796800, 92130266], [1392804000, 91208140], [1392811200, 90832271], [1392818400, 89005377], [1392825600, 88434921], [1392832800, 86441728], [1392840000, 85317408], [1392847200, 84341333], [1392854400, 83868681], [1392861600, 84134472], [1392868800, 85955940], [1392876000, 85095895], [1392883200, 85676494], [1392890400, 86131553], [1392897600, 85460386], [1392904800, 83556916], [1392912000, 84935443], [1392919200, 86421333], [1392926400, 88418182], [1392933600, 86474296], [1392940800, 84921921], [1392948000, 83038202], [1392955200, 81127436], [1392962400, 79712250], [1392969600, 81620314], [1392976800, 82690877], [1392984000, 81728814], [1392991200, 79947846], [1392998400, 81883538], [1393005600, 80479150], [1393012800, 78502013], [1393020000, 79362717], [1393027200, 81092323], [1393034400, 81242662], [1393041600, 79971748], [1393048800, 79529365], [1393056000, 78210743], [1393063200, 77694842], [1393070400, 79682189], [1393077600, 80787229], [1393084800, 82107780], [1393092000, 81107582], [1393099200, 79529755], [1393106400, 78810737], [1393113600, 79278140], [1393120800, 79891164], [1393128000, 81274437], [1393135200, 82186239], [1393142400, 80800839], [1393149600, 80168923], [1393156800, 79563589], [1393164000, 80418586], [1393171200, 78957901], [1393178400, 77806635], [1393185600, 77312296], [1393192800, 75481229], [1393200000, 75912745]], 'sent': [[1390615200, 82742083], [1390622400, 84711034], [1390629600, 86191254], [1390636800, 86058970], [1390644000, 86188950], [1390651200, 88030080], [1390658400, 89189380], [1390665600, 88216249], [1390672800, 87806087], [1390680000, 88714113], [1390687200, 89527428], [1390694400, 89562589], [1390701600, 88796733], [1390708800, 86813765], [1390716000, 88201507], [1390723200, 87115153], [1390730400, 88097497], [1390737600, 87979826], [1390744800, 88920795], [1390752000, 87888550], [1390759200, 87497264], [1390766400, 88578092], [1390773600, 87007146], [1390780800, 87403927], [1390788000, 88346275], [1390795200, 90227286], [1390802400, 89167065], [1390809600, 87381340], [1390816800, 88638474], [1390824000, 89398915], [1390831200, 88483570], [1390838400, 88762891], [1390845600, 87181824], [1390852800, 85184751], [1390860000, 85265995], [1390867200, 85305991], [1390874400, 84904949], [1390881600, 84453019], [1390888800, 85650852], [1390896000, 85355127], [1390903200, 83613520], [1390910400, 84193234], [1390917600, 86091017], [1390924800, 85768758], [1390932000, 84931513], [1390939200, 85324050], [1390946400, 84752699], [1390953600, 85068739], [1390960800, 84920554], [1390968000, 86582059], [1390975200, 86704758], [1390982400, 87521438], [1390989600, 87924458], [1390996800, 89258559], [1391004000, 89159757], [1391011200, 88609199], [1391018400, 87168981], [1391025600, 87892054], [1391032800, 86889064], [1391040000, 86507338], [1391047200, 86480435], [1391054400, 87788940], [1391061600, 88793308], [1391068800, 89654510], [1391076000, 88075604], [1391083200, 87286767], [1391090400, 86071937], [1391097600, 84805325], [1391104800, 85067699], [1391112000, 85043960], [1391119200, 83421877], [1391126400, 85416233], [1391133600, 85603553], [1391140800, 87082852], [1391148000, 87004649], [1391155200, 86951902], [1391162400, 86346307], [1391169600, 87077290], [1391176800, 87436827], [1391184000, 87932408], [1391191200, 88358104], [1391198400, 90220767], [1391205600, 90688716], [1391212800, 89876066], [1391220000, 91847104], [1391227200, 91251488], [1391234400, 89703574], [1391241600, 90447210], [1391248800, 89126725], [1391256000, 87128908], [1391263200, 87487659], [1391270400, 86425775], [1391277600, 85721779], [1391284800, 84590394], [1391292000, 83837552], [1391299200, 83000564], [1391306400, 82901003], [1391313600, 83847671], [1391320800, 82473098], [1391328000, 82572915], [1391335200, 82302094], [1391342400, 82242600], [1391349600, 80319443], [1391356800, 80421281], [1391364000, 80699725], [1391371200, 81338559], [1391378400, 79583885], [1391385600, 80847681], [1391392800, 80828274], [1391400000, 80829383], [1391407200, 79546554], [1391414400, 78617287], [1391421600, 78164483], [1391428800, 77560213], [1391436000, 77734022], [1391443200, 75907861], [1391450400, 75478130], [1391457600, 77077208], [1391464800, 75956659], [1391472000, 77835427], [1391479200, 77150078], [1391486400, 76153920], [1391493600, 76702590], [1391500800, 75016431], [1391508000, 73438445], [1391515200, 74856369], [1391522400, 76409317], [1391529600, 76371718], [1391536800, 76955668], [1391544000, 76455895], [1391551200, 76877056], [1391558400, 77308768], [1391565600, 75935767], [1391572800, 75500312], [1391580000, 74732317], [1391587200, 74384642], [1391594400, 75764188], [1391601600, 75865452], [1391608800, 77215841], [1391616000, 76458540], [1391623200, 77842022], [1391630400, 78004711], [1391637600, 76857795], [1391644800, 77844074], [1391652000, 78736489], [1391659200, 78378405], [1391666400, 77314453], [1391673600, 79019316], [1391680800, 79601881], [1391688000, 79730451], [1391695200, 79233229], [1391702400, 78767131], [1391709600, 77963661], [1391716800, 79142750], [1391724000, 79400168], [1391731200, 78876872], [1391738400, 79229860], [1391745600, 78501880], [1391752800, 78473232], [1391760000, 79569954], [1391767200, 80580667], [1391774400, 78837427], [1391781600, 77155431], [1391788800, 78253065], [1391796000, 78182625], [1391803200, 79284037], [1391810400, 81103270], [1391817600, 81920230], [1391824800, 83278908], [1391832000, 84785799], [1391839200, 84744599], [1391846400, 84043930], [1391853600, 84166759], [1391860800, 85753184], [1391868000, 85731178], [1391875200, 86835634], [1391882400, 87187447], [1391889600, 86906792], [1391896800, 88728573], [1391904000, 90501210], [1391911200, 89186409], [1391918400, 88011639], [1391925600, 87203457], [1391932800, 87981835], [1391940000, 87519855], [1391947200, 89328047], [1391954400, 90544296], [1391961600, 88595137], [1391968800, 90274102], [1391976000, 88998350], [1391983200, 89081468], [1391990400, 89445100], [1391997600, 88135604], [1392004800, 89088655], [1392012000, 88764847], [1392019200, 87662557], [1392026400, 87450371], [1392033600, 86927227], [1392040800, 86085483], [1392048000, 84140770], [1392055200, 82355230], [1392062400, 81230600], [1392069600, 80643725], [1392076800, 82027071], [1392084000, 81502865], [1392091200, 82346880], [1392098400, 82186623], [1392105600, 80522636], [1392112800, 80569757], [1392120000, 81932510], [1392127200, 83400031], [1392134400, 84597931], [1392141600, 83833505], [1392148800, 84614366], [1392156000, 82841026], [1392163200, 81761897], [1392170400, 79813122], [1392177600, 78299182], [1392184800, 76589164], [1392192000, 77367801], [1392199200, 75778478], [1392206400, 76493164], [1392213600, 77775707], [1392220800, 75984233], [1392228000, 77072942], [1392235200, 78896184], [1392242400, 79148259], [1392249600, 80210175], [1392256800, 81347815], [1392264000, 80180123], [1392271200, 79248785], [1392278400, 78227944], [1392285600, 79998572], [1392292800, 79624492], [1392300000, 81496044], [1392307200, 80799178], [1392314400, 81449230], [1392321600, 80089045], [1392328800, 79362498], [1392336000, 77602225], [1392343200, 77308965], [1392350400, 75504502], [1392357600, 76311137], [1392364800, 76286582], [1392372000, 75417532], [1392379200, 74920461], [1392386400, 73440708], [1392393600, 74925633], [1392400800, 75255361], [1392408000, 76000547], [1392415200, 74018709], [1392422400, 73765397], [1392429600, 74782296], [1392436800, 76668307], [1392444000, 75137561], [1392451200, 75374993], [1392458400, 75039177], [1392465600, 74783428], [1392472800, 74272517], [1392480000, 73668380], [1392487200, 71697683], [1392494400, 69726701], [1392501600, 68531191], [1392508800, 68840717], [1392516000, 70259923], [1392523200, 69730651], [1392530400, 70324340], [1392537600, 69636331], [1392544800, 70932859], [1392552000, 72316552], [1392559200, 73849418], [1392566400, 74708503], [1392573600, 75293450], [1392580800, 76100945], [1392588000, 77608430], [1392595200, 76208697], [1392602400, 77548781], [1392609600, 78807946], [1392616800, 78440206], [1392624000, 78392122], [1392631200, 78946469], [1392638400, 80617670], [1392645600, 80154902], [1392652800, 81387695], [1392660000, 83295525], [1392667200, 83474352], [1392674400, 82854974], [1392681600, 82167763], [1392688800, 82649627], [1392696000, 84056939], [1392703200, 83946865], [1392710400, 84354345], [1392717600, 84158259], [1392724800, 84008347], [1392732000, 84945830], [1392739200, 84588392], [1392746400, 84349060], [1392753600, 83494633], [1392760800, 82806152], [1392768000, 83778205], [1392775200, 85561601], [1392782400, 85786851], [1392789600, 87751472], [1392796800, 87824801], [1392804000, 88784917], [1392811200, 89466244], [1392818400, 88195523], [1392825600, 89721515], [1392832800, 88303052], [1392840000, 86465587], [1392847200, 84531949], [1392854400, 85288456], [1392861600, 85369077], [1392868800, 85392407], [1392876000, 83969767], [1392883200, 83476315], [1392890400, 85034700], [1392897600, 86331634], [1392904800, 84809762], [1392912000, 82888497], [1392919200, 82037967], [1392926400, 81483410], [1392933600, 80334447], [1392940800, 81020945], [1392948000, 80224515], [1392955200, 79355389], [1392962400, 77979481], [1392969600, 76341797], [1392976800, 75932801], [1392984000, 74389795], [1392991200, 72914943], [1392998400, 73779043], [1393005600, 74470212], [1393012800, 73859586], [1393020000, 73155887], [1393027200, 72080236], [1393034400, 72527408], [1393041600, 71230491], [1393048800, 69640870], [1393056000, 69299077], [1393063200, 67318266], [1393070400, 68857774], [1393077600, 69262957], [1393084800, 68858282], [1393092000, 69378509], [1393099200, 68353294], [1393106400, 68766266], [1393113600, 68423985], [1393120800, 68074971], [1393128000, 66739284], [1393135200, 66302390], [1393142400, 65933314], [1393149600, 64464067], [1393156800, 62980118], [1393164000, 61999302], [1393171200, 61353690], [1393178400, 63101269], [1393185600, 63777850], [1393192800, 62359369], [1393200000, 61946705]]},
    '1d': {'received': [[1361750400, 970394195], [1361836800, 1058922581], [1361923200, 1083491913], [1362009600, 1049583104], [1362096000, 1032212733], [1362182400, 1099487181], [1362268800, 1065795151], [1362355200, 1116284860], [1362441600, 1070071033], [1362528000, 1053723468], [1362614400, 984852081], [1362700800, 1010628346], [1362787200, 1023669058], [1362873600, 1028669265], [1362960000, 1052261571], [1363046400, 1113292843], [1363132800, 1146328544], [1363219200, 1215348224], [1363305600, 1139426277], [1363392000, 1160987914], [1363478400, 1134012952], [1363564800, 1115892051], [1363651200, 1184975131], [1363737600, 1124364321], [1363824000, 1214598832], [1363910400, 1305744092], [1363996800, 1381991516], [1364083200, 1448125568], [1364169600, 1413529560], [1364256000, 1434603532], [1364342400, 1431420609], [1364428800, 1446615337], [1364515200, 1541328578], [1364601600, 1600316123], [1364688000, 1693918812], [1364774400, 1785452133], [1364860800, 1819421053], [1364947200, 1909528730], [1365033600, 2005506277], [1365120000, 2012184218], [1365206400, 2006072159], [1365292800, 2032099275], [1365379200, 2007020338], [1365465600, 1911868148], [1365552000, 1870041060], [1365638400, 1957092457], [1365724800, 2016610417], [1365811200, 2081328106], [1365897600, 2020509520], [1365984000, 1958701418], [1366070400, 2042443313], [1366156800, 2140094459], [1366243200, 2062108067], [1366329600, 2020174954], [1366416000, 2055938901], [1366502400, 2090583892], [1366588800, 2143190763], [1366675200, 2178390861], [1366761600, 2082134539], [1366848000, 2098752745], [1366934400, 2084828445], [1367020800, 2082916329], [1367107200, 2128502632], [1367193600, 2179726942], [1367280000, 2234159057], [1367366400, 2280401940], [1367452800, 2297384714], [1367539200, 2298531721], [1367625600, 2301583359], [1367712000, 2250514213], [1367798400, 2169196719], [1367884800, 2238831025], [1367971200, 2258012696], [1368057600, 2356281928], [1368144000, 2432010527], [1368230400, 2337172156], [1368316800, 2391164339], [1368403200, 2421193106], [1368489600, 2430084356], [1368576000, 2429953664], [1368662400, 2349479447], [1368748800, 2255951948], [1368835200, 2341607494], [1368921600, 2318692291], [1369008000, 2317153228], [1369094400, 2358154003], [1369180800, 2342696877], [1369267200, 2413329579], [1369353600, 2381749204], [1369440000, 2343580732], [1369526400, 2412495887], [1369612800, 2458081996], [1369699200, 2542815884], [1369785600, 2589404046], [1369872000, 2598720365], [1369958400, 2518214194], [1370044800, 2492239313], [1370131200, 2459541055], [1370217600, 2367550815], [1370304000, 2400630349], [1370390400, 2459284667], [1370476800, 2512251082], [1370563200, 2418054324], [1370649600, 2330565557], [1370736000, 2330033202], [1370822400, 2387624327], [1370908800, 2377115855], [1370995200, 2282702455], [1371081600, 2189192635], [1371168000, 2195906194], [1371254400, 2238866473], [1371340800, 2283632292], [1371427200, 2246094689], [1371513600, 2234420108], [1371600000, 2212448734], [1371686400, 2299246746], [1371772800, 2261630040], [1371859200, 2317158399], [1371945600, 2365175386], [1372032000, 2290616841], [1372118400, 2381685495], [1372204800, 2414836784], [1372291200, 2507494984], [1372377600, 2577467180], [1372464000, 2608122015], [1372550400, 2679310423], [1372636800, 2684983218], [1372723200, 2628838348], [1372809600, 2709125906], [1372896000, 2726051272], [1372982400, 2754508404], [1373068800, 2732998948], [1373155200, 2770140478], [1373241600, 2731241116], [1373328000, 2769616668], [1373414400, 2820082854], [1373500800, 2873870535], [1373587200, 2798400408], [1373673600, 2792709534], [1373760000, 2890924941], [1373846400, 2973803620], [1373932800, 2936036143], [1374019200, 2894637168], [1374105600, 2911022984], [1374192000, 2818107481], [1374278400, 2795599738], [1374364800, 2829639238], [1374451200, 2927433518], [1374537600, 3024309223], [1374624000, 3085756082], [1374710400, 3182260563], [1374796800, 3205940994], [1374883200, 3262281605], [1374969600, 3192006471], [1375056000, 3126622355], [1375142400, 3057823382], [1375228800, 3083685779], [1375315200, 3015649816], [1375401600, 3064529366], [1375488000, 2981735569], [1375574400, 3034356590], [1375660800, 2952472420], [1375747200, 2902186625], [1375833600, 2815631870], [1375920000, 2818299741], [1376006400, 2779348757], [1376092800, 2809987254], [1376179200, 2757064777], [1376265600, 2682300728], [1376352000, 2774647273], [1376438400, 2774864950], [1376524800, 2872326206], [1376611200, 2892911147], [1376697600, 2838709891], [1376784000, 2863068547], [1376870400, 2957195486], [1376956800, 2881757538], [1377043200, 2917774425], [1377129600, 2888336382], [1377216000, 2919896420], [1377302400, 3005606842], [1377388800, 3001736608], [1377475200, 2978029255], [1377561600, 3014789898], [1377648000, 2997977780], [1377734400, 2972091918], [1377820800, 3016009088], [1377907200, 3043353318], [1377993600, 2948288086], [1378080000, 2981132763], [1378166400, 2923826418], [1378252800, 2833598747], [1378339200, 2924306627], [1378425600, 2826446660], [1378512000, 2770047669], [1378598400, 2766465026], [1378684800, 2848124580], [1378771200, 2875530005], [1378857600, 2964513696], [1378944000, 2985371565], [1379030400, 2911786225], [1379116800, 2930898795], [1379203200, 2971764277], [1379289600, 2969104963], [1379376000, 2971481798], [1379462400, 2877795669], [1379548800, 2921001894], [1379635200, 2846368809], [1379721600, 2859507594], [1379808000, 2814979127], [1379894400, 2914110856], [1379980800, 2820416979], [1380067200, 2872029844], [1380153600, 2869889644], [1380240000, 2801129192], [1380326400, 2859573035], [1380412800, 2801077579], [1380499200, 2817935332], [1380585600, 2780469523], [1380672000, 2711266193], [1380758400, 2775191938], [1380844800, 2731479025], [1380931200, 2819920109], [1381017600, 2754206220], [1381104000, 2671181178], [1381190400, 2635297779], [1381276800, 2589145456], [1381363200, 2505848878], [1381449600, 2417172914], [1381536000, 2318005336], [1381622400, 2228964610], [1381708800, 2322274779], [1381795200, 2329915870], [1381881600, 2338494045], [1381968000, 2261490006], [1382054400, 2243052872], [1382140800, 2262322327], [1382227200, 2231764302], [1382313600, 2308318105], [1382400000, 2382469274], [1382486400, 2348198868], [1382572800, 2437064340], [1382659200, 2506177848], [1382745600, 2468575937], [1382832000, 2410192879], [1382918400, 2348299925], [1383004800, 2401570665], [1383091200, 2430004777], [1383177600, 2525737291], [1383264000, 2550185577], [1383350400, 2467337729], [1383436800, 2484431503], [1383523200, 2403630177], [1383609600, 2463789887], [1383696000, 2391728208], [1383782400, 2450592614], [1383868800, 2407291852], [1383955200, 2464348050], [1384041600, 2437675100], [1384128000, 2527766180], [1384214400, 2443868168], [1384300800, 2505379994], [1384387200, 2500805615], [1384473600, 2455888950], [1384560000, 2409423612], [1384646400, 2504908539], [1384732800, 2554408426], [1384819200, 2621301209], [1384905600, 2540641991], [1384992000, 2476627733], [1385078400, 2392365253], [1385164800, 2433129803], [1385251200, 2347686400], [1385337600, 2281575956], [1385424000, 2315631586], [1385510400, 2229213488], [1385596800, 2160444854], [1385683200, 2242535941], [1385769600, 2325289972], [1385856000, 2353535699], [1385942400, 2385078325], [1386028800, 2320001468], [1386115200, 2224958926], [1386201600, 2172446294], [1386288000, 2179077734], [1386374400, 2101514232], [1386460800, 2121557310], [1386547200, 2172560631], [1386633600, 2176898191], [1386720000, 2176254877], [1386806400, 2225903759], [1386892800, 2317892464], [1386979200, 2345374412], [1387065600, 2331810492], [1387152000, 2255737301], [1387238400, 2341870986], [1387324800, 2339198327], [1387411200, 2388862135], [1387497600, 2423992111], [1387584000, 2439038440], [1387670400, 2422127216], [1387756800, 2402739376], [1387843200, 2358583068], [1387929600, 2350686337], [1388016000, 2418400090], [1388102400, 2449598582], [1388188800, 2386955243], [1388275200, 2442424352], [1388361600, 2415521039], [1388448000, 2406395855], [1388534400, 2335272195], [1388620800, 2365809615], [1388707200, 2270647253], [1388793600, 2303017790], [1388880000, 2385919121], [1388966400, 2389510982], [1389052800, 2292425836], [1389139200, 2357961120], [1389225600, 2320070868], [1389312000, 2235865833], [1389398400, 2233518836], [1389484800, 2236636811], [1389571200, 2306702862], [1389657600, 2229579226], [1389744000, 2237551115], [1389830400, 2280732084], [1389916800, 2376480566], [1390003200, 2317741156], [1390089600, 2259599544], [1390176000, 2200400651], [1390262400, 2279699485], [1390348800, 2342623828], [1390435200, 2353713023], [1390521600, 2281828573], [1390608000, 2228990343], [1390694400, 2278321871], [1390780800, 2298583076], [1390867200, 2388886671], [1390953600, 2453517355], [1391040000, 2451197239], [1391126400, 2503824578], [1391212800, 2465670527], [1391299200, 2562925397], [1391385600, 2629282771], [1391472000, 2654257205], [1391558400, 2577333275], [1391644800, 2544834065], [1391731200, 2490502647], [1391817600, 2449455429], [1391904000, 2358852814], [1391990400, 2420814038], [1392076800, 2404042433], [1392163200, 2330835751], [1392249600, 2274838349], [1392336000, 2232400866], [1392422400, 2216560835], [1392508800, 2229868657], [1392595200, 2280248875], [1392681600, 2351501507], [1392768000, 2343494908], [1392854400, 2268063994], [1392940800, 2242635156], [1393027200, 2153360450], [1393113600, 2130822249], [1393200000, 2174011000]], 'sent': [[1361750400, 924574495], [1361836800, 1018338927], [1361923200, 994479179], [1362009600, 951496641], [1362096000, 909917709], [1362182400, 967921900], [1362268800, 1043422567], [1362355200, 1056203426], [1362441600, 1125782702], [1362528000, 1041196507], [1362614400, 1110279997], [1362700800, 1018833282], [1362787200, 1117219213], [1362873600, 1189968873], [1362960000, 1115348098], [1363046400, 1064216162], [1363132800, 1064127792], [1363219200, 1148661869], [1363305600, 1087331727], [1363392000, 1016526125], [1363478400, 1090219565], [1363564800, 1098674738], [1363651200, 1056112514], [1363737600, 1110860619], [1363824000, 1028397249], [1363910400, 941266805], [1363996800, 901137599], [1364083200, 928519316], [1364169600, 915760951], [1364256000, 971574323], [1364342400, 909742488], [1364428800, 997484369], [1364515200, 959544870], [1364601600, 895243084], [1364688000, 984352325], [1364774400, 949570726], [1364860800, 1016746707], [1364947200, 998995264], [1365033600, 912443662], [1365120000, 1000889123], [1365206400, 1082813561], [1365292800, 1087064532], [1365379200, 994732613], [1365465600, 991434019], [1365552000, 963563480], [1365638400, 1036147625], [1365724800, 1025702808], [1365811200, 964995542], [1365897600, 984480996], [1365984000, 1011113067], [1366070400, 1045725804], [1366156800, 1096391981], [1366243200, 1064191124], [1366329600, 1020840813], [1366416000, 1053703965], [1366502400, 1098793674], [1366588800, 1147568669], [1366675200, 1062112480], [1366761600, 1052919884], [1366848000, 1070284795], [1366934400, 984333699], [1367020800, 933954629], [1367107200, 966915449], [1367193600, 1058752396], [1367280000, 1016870082], [1367366400, 1053279704], [1367452800, 1059959495], [1367539200, 1118495350], [1367625600, 1214050048], [1367712000, 1259173636], [1367798400, 1276228028], [1367884800, 1327103575], [1367971200, 1261951605], [1368057600, 1185221699], [1368144000, 1277307831], [1368230400, 1266498946], [1368316800, 1218508647], [1368403200, 1121363321], [1368489600, 1205580667], [1368576000, 1273224150], [1368662400, 1348874354], [1368748800, 1307550334], [1368835200, 1372123443], [1368921600, 1378207746], [1369008000, 1469348023], [1369094400, 1564328967], [1369180800, 1503617207], [1369267200, 1452845995], [1369353600, 1390982173], [1369440000, 1445908789], [1369526400, 1438024436], [1369612800, 1474462936], [1369699200, 1446634025], [1369785600, 1501197505], [1369872000, 1514214834], [1369958400, 1443553603], [1370044800, 1362715978], [1370131200, 1355614030], [1370217600, 1359914032], [1370304000, 1358043938], [1370390400, 1339717136], [1370476800, 1273911828], [1370563200, 1177480239], [1370649600, 1083291209], [1370736000, 1131217199], [1370822400, 1222200873], [1370908800, 1204769839], [1370995200, 1142507286], [1371081600, 1215837936], [1371168000, 1136119302], [1371254400, 1059179950], [1371340800, 1155737016], [1371427200, 1170154101], [1371513600, 1176141487], [1371600000, 1250821202], [1371686400, 1190176088], [1371772800, 1109301155], [1371859200, 1208579001], [1371945600, 1213246173], [1372032000, 1164406685], [1372118400, 1167982006], [1372204800, 1264888880], [1372291200, 1326149482], [1372377600, 1264089478], [1372464000, 1333069809], [1372550400, 1295571000], [1372636800, 1226945718], [1372723200, 1149683089], [1372809600, 1096985234], [1372896000, 1188045169], [1372982400, 1194251198], [1373068800, 1187597658], [1373155200, 1172775329], [1373241600, 1233409913], [1373328000, 1269509840], [1373414400, 1201856101], [1373500800, 1160805901], [1373587200, 1118419986], [1373673600, 1168036305], [1373760000, 1240474729], [1373846400, 1256893664], [1373932800, 1212181481], [1374019200, 1207372555], [1374105600, 1232540276], [1374192000, 1153660910], [1374278400, 1115632894], [1374364800, 1048905204], [1374451200, 1055432412], [1374537600, 1055115748], [1374624000, 1117230524], [1374710400, 1064441742], [1374796800, 1037701634], [1374883200, 1040794170], [1374969600, 960728740], [1375056000, 970999255], [1375142400, 1050734838], [1375228800, 1137330983], [1375315200, 1162848328], [1375401600, 1226486858], [1375488000, 1292346585], [1375574400, 1272496334], [1375660800, 1198303678], [1375747200, 1224458670], [1375833600, 1147049151], [1375920000, 1149248451], [1376006400, 1248612904], [1376092800, 1282038682], [1376179200, 1328014322], [1376265600, 1323569028], [1376352000, 1399015525], [1376438400, 1356776251], [1376524800, 1332316798], [1376611200, 1257029424], [1376697600, 1240171355], [1376784000, 1225960153], [1376870400, 1212201993], [1376956800, 1198655330], [1377043200, 1198339951], [1377129600, 1234774709], [1377216000, 1303297404], [1377302400, 1382599680], [1377388800, 1471559246], [1377475200, 1560046723], [1377561600, 1653139971], [1377648000, 1693595979], [1377734400, 1746217839], [1377820800, 1697887948], [1377907200, 1709102550], [1377993600, 1689245764], [1378080000, 1654815812], [1378166400, 1603855483], [1378252800, 1507029252], [1378339200, 1526659768], [1378425600, 1460329724], [1378512000, 1424751525], [1378598400, 1477538823], [1378684800, 1386530124], [1378771200, 1480619990], [1378857600, 1432057885], [1378944000, 1521052663], [1379030400, 1526210840], [1379116800, 1445374731], [1379203200, 1346405138], [1379289600, 1320129053], [1379376000, 1353321983], [1379462400, 1281911542], [1379548800, 1324510261], [1379635200, 1310785510], [1379721600, 1275004458], [1379808000, 1254585355], [1379894400, 1273564875], [1379980800, 1302105495], [1380067200, 1353394895], [1380153600, 1261089909], [1380240000, 1288285080], [1380326400, 1216314657], [1380412800, 1302274794], [1380499200, 1330845727], [1380585600, 1286901153], [1380672000, 1301523334], [1380758400, 1371811038], [1380844800, 1343829266], [1380931200, 1315432208], [1381017600, 1328862805], [1381104000, 1349284246], [1381190400, 1435491388], [1381276800, 1465973607], [1381363200, 1379534254], [1381449600, 1477390505], [1381536000, 1398814143], [1381622400, 1463187584], [1381708800, 1475721396], [1381795200, 1489250852], [1381881600, 1583054857], [1381968000, 1543000534], [1382054400, 1605089942], [1382140800, 1544912857], [1382227200, 1529376003], [1382313600, 1470955741], [1382400000, 1443790192], [1382486400, 1354740296], [1382572800, 1298797071], [1382659200, 1223796662], [1382745600, 1306809106], [1382832000, 1397806633], [1382918400, 1465372145], [1383004800, 1525523058], [1383091200, 1540928761], [1383177600, 1597077063], [1383264000, 1618611354], [1383350400, 1520292076], [1383436800, 1541561373], [1383523200, 1498542681], [1383609600, 1492083058], [1383696000, 1429937293], [1383782400, 1457800993], [1383868800, 1479034232], [1383955200, 1453416137], [1384041600, 1516122954], [1384128000, 1539624474], [1384214400, 1615618811], [1384300800, 1611685298], [1384387200, 1551050280], [1384473600, 1504895204], [1384560000, 1408800791], [1384646400, 1386733424], [1384732800, 1358387813], [1384819200, 1322000833], [1384905600, 1345716338], [1384992000, 1374377274], [1385078400, 1444029501], [1385164800, 1510294122], [1385251200, 1433638107], [1385337600, 1492467566], [1385424000, 1591319554], [1385510400, 1591055036], [1385596800, 1677198847], [1385683200, 1581853333], [1385769600, 1621511336], [1385856000, 1556688551], [1385942400, 1633382685], [1386028800, 1595441279], [1386115200, 1530872077], [1386201600, 1470883820], [1386288000, 1417570912], [1386374400, 1412886585], [1386460800, 1382884590], [1386547200, 1440923465], [1386633600, 1347698155], [1386720000, 1445018386], [1386806400, 1465677700], [1386892800, 1483293971], [1386979200, 1557984832], [1387065600, 1559730930], [1387152000, 1475082520], [1387238400, 1484634252], [1387324800, 1535517240], [1387411200, 1476924601], [1387497600, 1546190327], [1387584000, 1620914990], [1387670400, 1610879834], [1387756800, 1594338909], [1387843200, 1638216756], [1387929600, 1683788114], [1388016000, 1589893802], [1388102400, 1635895780], [1388188800, 1691735058], [1388275200, 1682745220], [1388361600, 1593000530], [1388448000, 1564304602], [1388534400, 1570187142], [1388620800, 1594169902], [1388707200, 1579428029], [1388793600, 1564149174], [1388880000, 1506643600], [1388966400, 1494217343], [1389052800, 1511146164], [1389139200, 1527578823], [1389225600, 1439666673], [1389312000, 1474198787], [1389398400, 1402252027], [1389484800, 1435447734], [1389571200, 1427915019], [1389657600, 1409393947], [1389744000, 1338509958], [1389830400, 1296531115], [1389916800, 1268035605], [1390003200, 1240769179], [1390089600, 1309291517], [1390176000, 1211537855], [1390262400, 1184688825], [1390348800, 1219902695], [1390435200, 1152551912], [1390521600, 1225113194], [1390608000, 1264961800], [1390694400, 1268801072], [1390780800, 1270104011], [1390867200, 1324329237], [1390953600, 1406770937], [1391040000, 1349092549], [1391126400, 1404192650], [1391212800, 1366315495], [1391299200, 1360186088], [1391385600, 1382916902], [1391472000, 1453773882], [1391558400, 1438891372], [1391644800, 1444139181], [1391731200, 1363953868], [1391817600, 1322913911], [1391904000, 1376266426], [1391990400, 1460176976], [1392076800, 1373593319], [1392163200, 1397108357], [1392249600, 1352507081], [1392336000, 1346775576], [1392422400, 1306028283], [1392508800, 1234720430], [1392595200, 1229698539], [1392681600, 1239455502], [1392768000, 1143722884], [1392854400, 1158348126], [1392940800, 1245025786], [1393027200, 1237709465], [1393113600, 1148072859], [1393200000, 1228682981]]}
  };

  var users = {
    '55f5c6820e7a7de989916b4cdddf6070': {
      '47402514d02283610f92d681523863a7': {
        id: '47402514d02283610f92d681523863a7',
        name: 'user1',
        organization: '55f5c6820e7a7de989916b4cdddf6070',
        status: true,
        type: 'client',
        otp_auth: true,
        otp_secret: 'SF2GFRK5MQ7JB4TN',
        servers: [{
          real_address: '8.8.8.8',
          virt_address: '10.139.17.32',
          bytes_received: 55322869,
          bytes_sent: 24589107,
          connected_since: 1383170753
        }]
      },
      '9d33758bf6d559e2eb53e7e971248216': {
        id: '9d33758bf6d559e2eb53e7e971248216',
        name: 'user2',
        organization: '55f5c6820e7a7de989916b4cdddf6070',
        status: false,
        type: 'client',
        otp_auth: true,
        otp_secret: 'KBMSQM67TQR7CUYX',
        servers: []
      },
      'b5a694ee9411574964d05015add815cd': {
        id: 'b5a694ee9411574964d05015add815cd',
        name: 'user3',
        organization: '55f5c6820e7a7de989916b4cdddf6070',
        status: false,
        type: 'client',
        otp_auth: true,
        otp_secret: 'QF47Z3V2FWWLZRJZ',
        servers: []
      },
      '096b1604409d4fb791d2f11d2f0beddc': {
        id: '096b1604409d4fb791d2f11d2f0beddc',
        name: 'user4',
        organization: '55f5c6820e7a7de989916b4cdddf6070',
        status: false,
        type: 'client',
        otp_auth: true,
        otp_secret: 'YJGVC2JG2OZ7X45R',
        servers: []
      }
    },
    'adb484e1f3c653dbc2aab10b14265dc6': {
      '8834d44e44011e9aaede036e5ed6d483': {
        id: '8834d44e44011e9aaede036e5ed6d483',
        name: 'user1',
        organization: 'adb484e1f3c653dbc2aab10b14265dc6',
        status: false,
        type: 'client',
        otp_auth: true,
        otp_secret: 'QKKWOXSVCE6ODPFJ',
        servers: []
      },
      'f3b5ad1db481d07aed557d6d34b8cb78': {
        id: 'f3b5ad1db481d07aed557d6d34b8cb78',
        name: 'user2',
        organization: 'adb484e1f3c653dbc2aab10b14265dc6',
        status: false,
        type: 'client',
        otp_auth: true,
        otp_secret: 'DZVOQ6QW2R6OIMQA',
        servers: []
      }
    }
  };

  return {
    auth: auth,
    events: events,
    logs: logs,
    orgs: orgs,
    servers: servers,
    serverOutput: serverOutput,
    serverBandwidth: serverBandwidth,
    users: users
  };
});
