'''
Monthly interest rate = (Annual interest rate) / 12.0
Monthly payment lower bound = Balance / 12
Monthly payment upper bound = (Balance x (1 + Monthly interest rate)**12) / 12.0
'''
balance = 999999
annualInterestRate = 0.18

def islowestp(p,b):  #p stands for payment, b stands for current balance
   for month in range(1,13):
        upb = b - p  #upd stands for unpaid balance
        b = upb + annualInterestRate/12.0 * upb
        month +=1
   return b

lb = balance/12 #lower bound
ub = balance * (1 + annualInterestRate/12.0)**12/12.0 #upper bound

while True:
     lowp = (lb + ub)/2.0  #bisection search
     remainder = islowestp(lowp,balance) # the remainder after every try
     if round(remainder,2) == 0:
         break
     elif remainder > 0:
        lb = lowp
     else :
        ub = lowp
print 'Lowest Payment: ' + str(round(lowp,2))   




'''
If there was no interest,
the debt can be paid off 
by monthly payments of 
one-twelfth of the original balance,
so we must pay at least this
much every month. 
One-twelfth of the original balance 
is a good lower bound.

 a good upper bound for the monthly payment 
 would be one-twelfth of the balance, 
 after having its interest 
 compounded monthly for an entire year.
'''
	      