import os

def is_text_file(path, use_os=True):
    """Returns true if this file looks like a text file. We can't be sure,
    of course, but this algorithm tries its best to guess.

    If ``use_os`` is True, then the first port of call will be the ``file``
    operating system program, which attempts to guess a filetype. Operating
    systems without this command will have this step skipped in all cases.
    Setting ``use_us`` to False forces the step to be skipped. This is mostly
    useful in testing, when we need to check the back-up algorithm."""

    # Try to use the OS's built in file detection machinery.
    f = None
    try:
        f = os.popen('file %s' % path, 'r')
        result = f.read()
        return 'text' in result
    finally:
        if f is not None: f.close()

    # Otherwise we have to go digging. Get the content.
    file = open(path)
    try:
        # Get just the first bit of its content (in case the file is huge).
        content = file.read(4000)
    finally:
        file.close()
    if not content:
        print 'No content -- binary'
        return False

    # Check for a byte order mark at the start (indicating UTF-8 encoded text).
    if content[:3] == '\xef\xbb\xbf':
        return True

    # Otherwise count the number of non-printable characters.
    npc = 0
    for char in content:
        c = ord(char)
        # Check for codes that are very unlikely to be in any text-document.
        if c in (0, 4, 21, 22, 24, 25):
            # We don't need to do statistics here, we can just assume
            # we're binary.
            return False

        elif c < 32 and (c < 9 or c > 13):
            npc += 1

    # And if we've got almost none of them, we're probably text.
    ratio = float(npc) / float(len(content))
    return ratio < 0.02
        
    
