/*! proso-questions-client 2015-01-11 */

!function(){"use strict";angular.module("addaptivePractice",["addaptivePractice.controllers","addaptivePractice.directives","addaptivePractice.filters","addaptivePractice.services","angulartics","angulartics.google.analytics","ngAnimate","ngMaterial","ngRoute","ngSanitize","timer","ui.bootstrap"]).value("$",jQuery).config(["$routeProvider","$locationProvider","domain",function(a,b,c){a.when("/",{}).when("/login/:somepath/",{controller:"ReloadController",templateUrl:"loading.html"}).when("/how-it-works",{templateUrl:"how-it-works.html"}).when("/about",{templateUrl:"static/tpl/about.html"}).when("/view/:category?",{controller:"AppView",templateUrl:"static/tpl/view_tpl.html",reloadOnSearch:!1}).when("/refreshpractice/:category?",{redirectTo:"/practice/:category"}).when("/practice/:category?",{controller:"AppPractice",templateUrl:"static/tpl/practice_tpl.html",reloadOnSearch:!1}).when("/test/",{controller:"AppTest",templateUrl:"static/tpl/test_tpl.html"}).when("/refreshtest/",{redirectTo:"/test/"}).when("/overview/:user?",{controller:"AppOverview",templateUrl:"static/tpl/overview_tpl.html"}).otherwise({})}]).run(["$analytics",function(a){a.settings.pageTracking.autoTrackFirstPage=!1}])}(),function(){"use strict";angular.module("addaptivePractice.controllers",[]).controller("AppCtrl",["$scope","$rootScope","user","pageTitle","$modal","$window",function(a,b,c,d,e,f){b.topScope=b,b.initTitle=function(a){b.initialTitle=a,b.title=a},b.$on("$routeChangeStart",function(a,c){b.title=d(c)+b.initialTitle,b.isHomepage=!c.templateUrl});var g=function(a){b.user=a};a.initUser=function(a,d){b.user=c.initUser(a,d)},b.logout=function(){b.user=c.logout(g)},a.feedback={user_agent:f.navigator.userAgent,email:"@",text:""},a.openFeedback=function(){b.user&&b.user.email&&(a.feedback.email=b.user.email),e.open({templateUrl:"feedback_modal.html",controller:h,size:"lg",resolve:{feedback:function(){return a.feedback}}})};var h=["$scope","$modalInstance","$http","$cookies","$location","feedback",function(a,b,c,d,e,f){a.feedback=f,a.alerts=[],a.send=function(){f.page=e.absUrl(),c.defaults.headers.post["X-CSRFToken"]=d.csrftoken,c.post("/feedback/",f).success(function(b){a.alerts.push(b),a.sending=!1}).error(function(){a.alerts.push({type:"danger",msg:"V aplikaci bohužel nastala chyba."}),a.sending=!1}),a.sending=!0},a.closeAlert=function(b){a.alerts.splice(b,1)},a.cancel=function(){b.dismiss("cancel")}}]}]).controller("AppView",["$scope","$routeParams","$filter","questions",function(a,b,c,d){function e(){a.loading||(a.loading=!0,d.get(a.categoryId,a.page).error(function(){a.error="V aplikaci bohužel nastala chyba.",a.loading=!1}).success(function(b){var c=b.data;c=c.map(function(a){for(var b=0;b<a.options.length;b++)a.options[b].correct&&(a.correct=a.options[b].order);return a}),a.questions=a.questions.concat(c),a.loading=!1,a.hasMoreQuestions=c.length>0,a.categoryId&&c.length>0&&(a.category=c[0].categories[0])}),a.page++)}a.categoryId=b.category,a.page=0,a.questions=[],a.onBottomReached=function(){e()},e()}]).controller("AppPractice",["$scope","$routeParams","$timeout","$filter","practice","user","events",function(a,b,c,d,e,f,g){function h(){a.progress=0,a.questions=[],a.summary=e.summary(),a.showSummary=!0,g.emit("questionSetFinished",f.getUser().points)}function i(b){a.question=b,a.questions=[b],a.canNext=!1}function j(b){a.question.options.map(function(a){return a.disabled=!0,a.selected=a==b,a})}a.categoryId=b.category,a.checkAnswer=function(b){j(b),b&&(a.question.answered=b),a.progress=e.answer(a.question,a.categoryId),b&&b.correct?(c(function(){a.next()},700),f.addPoint()):a.canNext=!0},a.next=function(){a.progress<100?e.next(a.categoryId,i):h()},e.first(a.categoryId,function(a){i(a)}).error(function(){a.error="V aplikaci bohužel nastala chyba."})}]).controller("AppTest",["$scope","$timeout","practice","$",function(a,b,c,d){function e(){f(),a.question=a.questions[a.activeQuestionIndex],a.question.start_time=(new Date).valueOf()}function f(){a.question&&(a.question.response_time+=(new Date).valueOf()-a.question.start_time)}function g(b){a.question.options.map(function(a){return a.selected=a==b,a})}a.checkAnswer=function(c){g(c),c&&(a.question.answered=c),b(function(){a.next()},700)},a.prev=function(){a.activeQuestionIndex--,a.activeQuestionIndex<0&&(a.activeQuestionIndex=a.questions.length-1),e()},a.next=function(){a.activeQuestionIndex++,a.activeQuestionIndex>a.questions.length-1&&(a.activeQuestionIndex=0),e()},a.activateQuestion=function(b){a.activeQuestionIndex=b,e()},a.evaluate=function(b){f(),a.activeQuestionIndex=void 0,a.showSummary=!0,a.loading=!0,c.evaluateTest(a.test,a.questions).success(function(b){var c=b.data;a.result=c,a.result.pointsRatio=c.score_achieved/c.score_max,a.result.pointsMissingToPass=Math.max(0,c.score_to_pass-c.score_achieved),a.result.pointsToPassPortion=a.result.pointsMissingToPass/c.score_max;for(var d=0;d<b.data.questions.length;d++)for(var e=0;e<a.questions.length;e++)a.questions[e].id==b.data.questions[d].question_id&&(a.questions[e].points=b.data.questions[d].score+" b");a.loading=!1}),a.questions.map(function(a){a.isCorrect=a.answered&&a.answered.correct,a.isWrong=!a.isCorrect,a.prediction=(a.answered?a.answered.correct:0)+0,a.points=" "}),a.summary={questions:a.questions,correctlyAnsweredRatio:.5},b?a.$apply():d("timer")[0].stop()},a.start=function(){a.started=!0,c.test(function(b){a.questions=b.questions,a.questions.map(function(a){a.response_time=0}),a.test=b.test,a.activateQuestion(0)}).error(function(){a.error="V aplikaci bohužel nastala chyba."})}}]).controller("ReloadController",["$window",function(a){a.location.reload()}])}(),function(){"use strict";angular.module("addaptivePractice.services",["ngCookies"]).value("chroma",chroma).constant("domain",window.domain||"").value("colors",{GOOD:"#0f9d58",BAD:"d9534f",NEUTRAL:"#bbb",BRIGHT_GRAY:"#ddd"}).factory("colorScale",["colors","chroma",function(a,b){var c=b.scale([a.BAD,"#ff4500","#ffa500","#ffff00",a.GOOD]);return c}]).factory("questions",["$http","$routeParams","params","domain",function(a,b,c,d){var e={get:function(e,f){var g=d+"/questions/questions/",h={params:angular.extend({stats:!0,page:f,limit:b.limit||20},c.all())};e&&(h.params.filter_column="category_id",h.params.filter_value=e),h.params.json_orderby="prediction";var i=a.get(g,h);return i},fetchPredicitons:function(b,e){e=e||"prediction";var f=d+"/models/model/?items=";f+=b.map(function(a){return a.item_id}).join(",");var g={params:c.all()};a.get(f,g).success(function(a){for(var c=0;c<a.data.predictions.length;c++)for(var d=0;d<b.length;d++)b[d].item_id==a.data.predictions[c].item_id&&(b[d][e]=a.data.predictions[c].prediction)})}};return e}]).service("practice",["$http","$log","$cookies","$","$routeParams","questions","params","domain",function(a,b,c,d,e,f,g,h){function i(a){var b=m[l++];b&&(b.response_time=-(new Date).valueOf()),a(b)}function j(a){for(var b=0,c=a.length;c>b+1;b++)if(a[b].id==a[b+1].id)return!1;return!0}var k,l=0;a.defaults.headers.post["Content-Type"]="application/x-www-form-urlencoded";var m=[],n=[],o={};return{test:function(b){k=h+"/questions/test";var c={params:g.all()},d=a.get(k,c).success(function(a){b(a.data)});return d},evaluateTest:function(b,e){var f=d.param({question:e.map(function(a){return a.id}),answered:e.map(function(a){return a.answered&&a.answered.id}),response_time:e.map(function(a){return a.response_time})}),i=h+b.test_evaluate_url+"?hack"+g.queryString(),j=a({method:"POST",url:i,data:f,headers:{"X-CSRFToken":c.csrftoken}});return j},first:function(b,c){o.params=angular.extend({category:b,stats:!0},g.all()),k=h+"/questions/practice",n=[];var d=a.get(k,o).success(function(a){l=0,m=a.data.questions,i(c)});return d},next:function(a,b){i(b)},answer:function(e,f){e.response_time+=(new Date).valueOf(),e.index=l-1;var i=d.param({question:e.id,answered:e.answered.id,response_time:e.response_time}),k=(o.params.limit||10)-e.index-1;return n.push(e),a({method:"POST",url:h+"/questions/practice?stats=true"+(f?"&category="+f:"")+g.queryString()+"&limit="+k,data:i,headers:{"Content-Type":"application/x-www-form-urlencoded","X-CSRFToken":c.csrftoken}}).success(function(a){var c=l+a.questions.length;if(console.log(c,a),m.length==c){var d=m.slice(0,l).concat(a.questions);j(d)&&(m=d,b.log("questions updated, question index",l))}}),100*l/m.length},summary:function(){var a=n.filter(function(a){return a.answered.correct});return f.fetchPredicitons(n,"predictionAfter"),{correctlyAnsweredRatio:a.length/n.length,questions:n}}}}]).factory("user",["$http","$cookies","events","domain",function(a,b,c,d){var e;return{initUser:function(a,b){return e={username:a,points:b}},getUser:function(){return e},logout:function(b){return a.get(d+"/user/logout/").success(b),this.initUser("",0),c.emit("userUpdated",e),e},addPoint:function(){e.points++,b.points=e.points,c.emit("userUpdated",e)}}}]).factory("events",function(){var a={};return{on:function(b,c){a[b]=a[b]||[],a[b].push(c)},emit:function(b,c){a[b]=a[b]||[],a[b].map(function(a){a(c)})}}}).factory("pageTitle",[function(){var a={"":"","../templates/home/how_it_works.html":"Jak to funguje? - ","static/tpl/about.html":"O prjektu - ","static/tpl/view_tpl.html":"Prohlížení otázek - ","static/tpl/practice_tpl.html":"Procvičování otázek - ","static/tpl/test_tpl.html":"Test - "};return function(b){var c=b.templateUrl?a[b.templateUrl]:"";return c}}]).factory("params",["$routeParams","$location",function(a,b){var c=["user","debug","time","limit"],d={},e={get:function(c){return d[c]&&!a[c]&&b.search(c,d[c]),a[c]&&(d[c]=a[c]),d[c]},all:function(){for(var a=0;a<c.length;a++)e.get(c[a]);return d},queryString:function(){e.all();var a=c.map(function(a){return e.get(a)?"&"+a+"="+e.get(a):""}).join("");return a}};return e}])}(),function(){"use strict";angular.module("addaptivePractice.filters",[]).filter("percent",function(){return function(a){return a=a||0,Math.round(100*a)+"%"}}).filter("StatesFromPlaces",function(){return function(a){var b={};return a&&a[0]&&angular.forEach(a,function(a){!a.haveMaps&&a.places&&angular.forEach(a.places,function(a){b[a.code]=a})}),b}}).filter("colNum",function(){return function(a){return Math.floor(12/a)}}).filter("isActive",["$location",function(a){return function(b){return-1!=a.path().indexOf(b)?"active":""}}]).filter("isFindOnMapType",function(){return function(a){return a&&a.type<20}}).filter("isPickNameOfType",function(){return function(a){return a&&a.type>=20}}).filter("isAllowedOption",function(){return function(a,b){return!a.options||1==a.options.filter(function(a){return a.code==b}).length}}).filter("imgSrc",function(){return function(a){var b=a&&a.images&&a.images[0]&&a.images[0].url;return b}}).filter("stripImg",function(){return function(a){return a&&a.text&&a.text.replace(/\!\[Image\]\((.*)\)/,"").replace("<br />","")}}).filter("stripHtml",function(){return function(a){return a.replace(/(<([^>]+)>)/gi,"")}}).filter("isTypeCategory",function(){return function(a,b){return a=a&&a.filter(function(a){return 1==b.types.filter(function(b){return b==a.slug}).length})}}).filter("codeToName",["places",function(a){return function(b){return a.getName(b)||"Neznámý"}}]).filter("probColor",["colorScale",function(a){return function(b){return a(b).hex()}}]).filter("sumCounts",[function(){return function(a){if(!a||0===a.length)return 0;var b=a.map(function(a){return a.count}).reduce(function(a,b){return a+b});return b}}]).filter("prettify",function(){function a(a){var b=JSON.stringify(a,void 0,4)||"";return b=b.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),b.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(a){var b="number";return/^"/.test(a)?b=/:$/.test(a)?"key":"string":/true|false/.test(a)?b="boolean":/null/.test(a)&&(b="null"),'<span class="'+b+'">'+a+"</span>"})}return a})}(),function(){"use strict";angular.module("addaptivePractice.directives",[]).directive("email",function(){return{restrict:"C",compile:function(a){var b=a.html();b=b.replace("{zavinac}","@"),b='<a href="mailto:'+b+'">'+b+"</a>",a.html(b)}}}).directive("atooltip",function(){return{restrict:"C",link:function(a,b,c){b.tooltip({placement:c.placement||"bottom",container:c.container})}}}).directive("dropLogin",["$",function(a){return{restrict:"C",compile:function(b){b.bind("click",function(){b.tooltip("destroy"),a(".tooltip").each(function(){-1!=a(this).text().indexOf("Přihlašte se")&&a(this).remove()})})}}}]).directive("dropLogin",["$timeout","events",function(a,b){return{restrict:"C",link:function(c,d){b.on("questionSetFinished",function(b){b>10&&20>=b&&a(function(){d.tooltip("show")},0)})}}}]).directive("categoryProgress",[function(){return{restrict:"C",template:'<div class="progress overview-progress"><div class="progress-bar progress-bar-learned" style="width: {{(skills.learned / count)|percent}};"></div><div class="progress-bar progress-bar-practiced" style="width: {{(skills.practiced / count)|percent}};"></div></div>',link:function(a,b,c){a.count=c.count,c.$observe("skills",function(c){""!==c&&(a.skills=angular.fromJson(c),b.tooltip({html:!0,placement:"bottom",title:'<div class="skill-tooltip">Naučeno: <span class="badge badge-default"><i class="color-indicator learned"></i>'+a.skills.learned+" / "+a.count+'</span></div><div class="skill-tooltip">Procvičováno: <span class="badge badge-default"><i class="color-indicator practiced"></i>'+a.skills.practiced+" / "+a.count+"</span></div>"}))})}}}]).directive("levelProgressBar",["user","$timeout",function(a,b){function c(a){for(var b=0,c=30,d=0,e=1;!0;e++){if(b+=c,b>a)return{level:e,form:b-c,to:b,range:c,points:a-(b-c)};c+=d,d+=10}}return{restrict:"C",template:'<span class="badge level-start atooltip" ng-bind="level.level" title="Aktuální úroveň"></span><div class="progress level-progress" ><div class="progress-bar progress-bar-warning" style="width: {{(level.points/level.range)|percent}};"></div></div><span class="badge level-goal atooltip" ng-bind="level.level+1" title="Příští úroveň"></span>',link:function(d,e){d.level=c(a.getUser().points),b(function(){e.find(".level-progress").tooltip({placement:"bottom",title:d.level.points+" z "+d.level.range+" bodů"})},100)}}}]).directive("infiniteScroll",["$window","$document","$",function(a,b,c){return{link:function(d,e,f){var g=parseInt(f.threshold)||0;b.unbind("scroll"),b.bind("scroll",function(){d.$eval(f.canLoad)&&c(a).scrollTop()+c(a).height()>=c(b).height()-g&&d.$apply(f.infiniteScroll)})}}}]).directive("debug",["params",function(a){return{restrict:"A",template:'<pre ng-show="debug" ng-bind-html="debug | prettify"></pre>',link:function(b,c,d){b.$watch(d.debug,function(){b.debug=a.get("debug")?b[d.debug]:void 0})}}}]).directive("loadingIndicator",[function(){return{restrict:"C",template:'<svg class="spinner" width="65px" height="65px"  viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg"><circle class="path" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle></svg>'}}]).directive("questionsList",[function(){return{restrict:"A",templateUrl:"static/tpl/questions_list_tpl.html",scope:!1,link:function(a,b,c){a.$watch(c.questionsList,function(b){a.questionsList=b}),a.selectQuestion=function(b){a.selected=b!=a.selected?b:void 0},a.showCategories="true"==c.showCategories}}}]).directive("options",[function(){return{restrict:"A",templateUrl:"static/tpl/options_tpl.html",scope:!1,link:function(a,b,c){a.$watch(c.options,function(b){a.question=b,a.disabled=c.ngDisabled,a.noAnswers=c.noAnswers})}}}]).directive("dynamicTitle",["events",function(a){return{restrict:"A",template:"{{dynamicTitle}}",scope:!1,link:function(b,c,d){a.on("titleChaged",function(a){b.dynamicTitle=a}),d.dynamicTitle&&a.emit("titleChaged",d.dynamicTitle)}}}])}(),angular.module("addaptivePractice").run(["$templateCache",function(a){"use strict";a.put("static/tpl/about.html",'<div class="how-it-works"><h2>O projektu</h2><div class="col-md-offset-1 col-md-10 col-lg-offset-3 col-lg-6"><div class="works-div"><h3>Kdo za tím stojí</h3><p>Slepé mapy jsou vyvíjeny na <a href="http://www.fi.muni.cz/">Fakultě informatiky Masarykovy univerzity</a>, konkrétně v rámci skupiny <a href="http://www.fi.muni.cz/~xpelanek/proso/">PROSO</a>. Mezi předchozí projekty této skupiny patří například <a href="http://tutor.fi.muni.cz/">Problem Solving Tutor</a>.</p><p>Na vývoji Slepých map se podílí především Vít Stanislav a Jan Papoušek.</p><p>Pokud studujete na FI a máte zájem se zapojit do vývoje podobného typu systémů, případně pokud máte zájem o výzkumnou spolupráci, kontaktujte <a href="http://www.muni.cz/people/4297">Radka Pelánka</a>.</p><p>Náměty k rozvoji systému zasílejte na <span class="email contact">slepemapy{zavinac}googlegroups.com</span>.</p></div><div class="works-div"><h3>Soukromí</h3>Data o odpovědích jsou ukládána a jsou využívána pro výběr vhodných otázek a pro výzkumné účely. Všechna tato data jsou zpracovávána anonymně. Přihlašovací údaje (Facebook, Google) jsou použity pouze pro určení identity při opakovaných návštěvách, jinak se s nimi nepracuje.</div><div class="works-div"><h3>Zdroje</h3><ul><li><a href="http://www.naturalearthdata.com/">Natural Earth Data</a> - zdroj většiny mapových podkladů (svět, kontinenty, většina států)</li><li><a href="http://www.gadm.org/">Global Administrative Areas</a> - administrativní členění Itálie, Francie a Španělska</li><li><a href="http://download.geofabrik.de/">OpenStreetMap Data Extracts</a> - města České republiky a Slovenska</li></ul><ul><li><a href="http://flag-sprites.com/">Flag sprites</a> - vlaječky států světa a USA</li><li><a href="http://en.wikipedia.org/wiki/Template:Flag">Wikipedia Flags</a> - vlaječky ostatních administrativnách celků</li></ul></div></div><div class="clearfix"></div></div>'),a.put("static/tpl/options_tpl.html",'<md-radio-group class="options" ng-model="question.correct"><md-radio-button ng-repeat="option in question.options" ng-value="option.order" aria-label="{{(option | stripImg) || \'\'}}" ng-disabled="option.disabled || disabled" ng-click="checkAnswer(option)" ng-class="{\n      \'correct\': !noAnswers && (question.answered || question.points) && option.correct,\n      \'wrong\': !noAnswers && question.answered == option && !option.correct,\n      \'inline-block\': option.images.length\n    }">{{(option | stripImg) || \'\'}} <img ng-src="{{option | imgSrc}}"></md-radio-button></md-radio-group>'),a.put("static/tpl/practice_tpl.html",'<div class="progress quesions-progress"><div class="progress-bar progress-bar-learned" style="width: {{summary.correctlyAnsweredRatio * 100  }}%"></div><div class="progress-bar progress-bar-danger" style="width: {{showSummary && (1 - summary.correctlyAnsweredRatio) * 100 }}%"></div><div class="progress-bar progress-bar-practice" style="width: {{progress}}%"></div></div><span ng-hide="true" dynamic-title="Procvičování"></span><div id="container" class="practice-container col-lg-12"><div ng-hide="question || showSummary || error" class="loading-indicator"></div><div ng-show="error" ng-bind="error" class="alert alert-danger"></div><div ng-repeat="question in questions" class="practice"><div class="well" ng-if="question|imgSrc"><img ng-src="{{question|imgSrc}}"></div><div class="question"><div ng-bind="question | stripImg"></div></div><div options="question"></div><div class="pull-right"><button class="btn btn-lg next" ng-class="(canNext && \'btn-primary\') || \'btn-default\'" ng-click="next()" ng-disabled="!canNext"><i class="glyphicon glyphicon-arrow-right"></i> Další</button></div><div class="clearfix"></div><div debug="question"></div></div><div ng-show="showSummary" class="summary"><div><div class="progress-label">Úspěšnost: {{summary.correctlyAnsweredRatio | percent }}</div><h2 ng-show="errorMessage != undefined" ng-bind="errorMessage"></h2><div questions-list="summary.questions"></div></div><br><span class="pull-right"><a class="btn btn-lg btn-default" href="#/refreshpractice/{{categoryId}}"><i class="glyphicon glyphicon-repeat"></i> Znovu procvičovat</a> <a class="btn-continue btn btn-lg btn-primary" href="#/view/{{categoryId}}">Přehled znalostí</a></span><div class="clearfix"></div><div debug="summary"></div></div><div class="clearfix"></div></div>'),a.put("static/tpl/questions_list_tpl.html",'<div class="questions-list"><div ng-repeat="question in questionsList"><div class="questions-item" ng-click="selectQuestion(question)"><span class="badge badge-default" title="Odhad znalosti {{question.predictionAfter && \'před\' || \'\'}}"><i class="color-indicator" style="background-color: {{question.prediction|probColor}}"></i> {{question.points || (question.prediction | percent)}}</span> <i class="glyphicon glyphicon-circle-arrow-right prediction-shift" ng-if="question.predictionAfter" style="color: {{(question.answered.correct + 0) | probColor}}"></i> <span class="badge badge-default" title="Odhad znalosti po" ng-if="question.predictionAfter"><i class="color-indicator" style="background-color: {{question.predictionAfter|probColor}}"></i> {{(question.predictionAfter | percent)}}</span> <span ng-repeat="cat in question.categories" ng-if="!categoryId" class="badge badge-default pull-right category" title="Kategorie">{{cat.name}}</span> <span class="inline-question" ng-bind="question.html|stripHtml"></span></div><div class="question-details" ng-if="question == selected" ng-class="{\'ng-leave\' : question != selected}"><img style="display: block" ng-src="{{question | imgSrc}}"><div options="question" ng-disabled="true"></div><div debug="question"></div></div><md-divider class="md-default-theme"></md-divider></div><br><div ng-click="onBottomReached()" ng-show="hasMoreQuestions && !loading" class="btn btn-default btn-block">Další otázky</div><div class="clearfix"></div></div>'),a.put("static/tpl/test_tpl.html",'<div id="container" class="practice-container"><div ng-if="!started"><div class="ng-view-header hidden-xs"><h2 dynamic-title="Test">Test</h2></div><br><div ng-include="\'test_description.html\'" class="col-lg-12"></div><br><div class="text-center"><a href="" class="btn btn-primary btn-lg" ng-click="start()">Spustit test</a></div></div><div ng-if="started" class="col-lg-12"><div ng-if="questions" ng-hide="showSummary || error"><timer countdown="30 * 60" max-time-unit="\'minute\'" interval="1000" finish-callback="evaluate(true);" title="Zývá do konce" class="pull-right"><i class="glyphicon glyphicon-time"></i> {{minutes}}:{{sseconds}}</timer><ul class="progress-indicator"><li class="prev" ng-click="prev()">&lt;</li><li ng-repeat="question in questions" class="question-switcher" ng-class="{ \n            \'active\': ($index == activeQuestionIndex),\n            \'answered\': question.answered !== undefined, \n            \'correct\': question.isCorrect,\n            \'wrong\': question.isWrong\n          }" ng-click="activateQuestion($index)">{{$index}}</li><li class="next" ng-click="next()">&gt;</li></ul></div><div ng-hide="questions || showSummary || error" class="loading-indicator"></div><div ng-show="error" ng-bind="error" class="alert alert-danger"></div><div ng-repeat="question in questions" ng-if="$index == activeQuestionIndex" class="practice"><div class="well" ng-if="question|imgSrc"><img ng-src="{{question|imgSrc}}"></div><div class="question"><div ng-bind="question | stripImg"></div></div><div options="question" no-answers="true"></div><div class="pull-right"><button class="btn btn-lg btn-default next {{!canNext || \'btn-primary\'}}" ng-click="next()" ng-disabled="questions.length == $index + 1"><i class="glyphicon glyphicon-arrow-right"></i> Další</button></div><button class="btn btn-lg btn-default prev" ng-click="prev()" ng-disabled="$index == 0"><i class="glyphicon glyphicon-arrow-left"></i> Předchozí</button> <button class="btn btn-lg btn-default" ng-show="!showSummary" ng-click="evaluate()"><i class="glyphicon glyphicon-saved"></i> Vyhodnotit</button><div debug="question"></div></div><div ng-show="showSummary" class="summary"><div class="ng-view-header hidden-xs"><h2 dynamic-title="Výsledky testu"></h2></div><div><h2 ng-show="errorMessage != undefined" ng-bind="errorMessage"></h2><div questions-list="summary.questions"></div><div class="progress" ng-show="summary != undefined"><div class="progress-bar progress-bar-success" style="width: {{result.pointsRatio * 100 }}%"></div><div class="progress-bar progress-bar-danger" style="width: {{result.pointsToPassPortion * 100 }}%"></div></div><div ng-show="loading" class="loading-indicator"></div><div ng-hide="loading"><div class="progress-label"><strong>Celkem získáno</strong> <span class="badge badge-default"><i class="color-indicator" style="background-color: {{1|probColor}}"></i> {{result.score_achieved}} b</span> <span class="col-offset-2" ng-hide="result.pointsMissingToPass == 0">a do úspěšného složení testu chybí <span class="badge badge-default"><i class="color-indicator" style="background-color: {{0|probColor}}"></i> {{result.pointsMissingToPass}} b</span></span></div><br><div class="alert alert-success" ng-show="result.pointsMissingToPass == 0"><h3>Gratulujeme k úspěšnému složení testu!</h3><div></div></div><br><span class="pull-right" ng-if="showSummary"><a class="btn-continue btn btn-lg btn-default" href="#/view/">Přehled znalostí</a> <a class="btn-continue btn btn-lg btn-default" href="#/refreshtest/">Další test</a> <a class="btn-continue btn btn-lg btn-primary" href="#/practice/">Procvičovat</a></span></div><div class="clearfix"></div></div></div></div></div>'),a.put("static/tpl/view_tpl.html",'<div id="container" infinite-scroll="onBottomReached()" threshold="100" can-load="hasMoreQuestions"><div class="view-questions"><div class="ng-view-header"><a href="#/practice/{{categoryId}}" class="btn btn-primary pull-right"><i class="glyphicon glyphicon-check"></i> Procvičovat</a><h2 ng-if="category" class="hidden-xs" dynamic-title="{{category.name}}">{{category.name}}</h2><span ng-hide="true" dynamic-title="Přehled znalostí"></span><div class="clearfix"></div></div><!--\n    <div class="category-progress" count="{{type.places.length}}"  \n         skills="{{ {\n           practiced:(type.places|filter:{practiced:true}).length,\n           learned:(type.places|filter:{learned:true}).length\n         } }}"></div>\n    --><div questions-list="questions"></div></div><div ng-show="loading" class="loading-indicator"></div><div ng-show="error" ng-bind="error" class="alert alert-danger"></div></div>')}]);
//# sourceMappingURL=proso-questions-client.min.map