# -*- coding: utf-8 -*-


"""
proxyapi.generators
~~~~~~~~~~~~~~

This module provides generators for http and https proxies.

"""

import json
import requests


def get_proxies(url, proxy_type=None):
    """Return a list of proxy entries from specified URL."""
    proxy_json = json.loads(requests.get(url).text)
    if proxy_type is None:
        proxies = proxy_json
    else:
        proxies = [p for p in proxy_json if p['type'] == proxy_type]

    return proxies


def get_http_proxy(url):
    """Create a generator of http proxies."""
    http_proxies = get_proxies(url, 'http')
    num_proxies = len(http_proxies)
    i = 0
    while i < num_proxies:
        yield http_proxies[i]
        i += 1


def get_https_proxy(url):
    """Create a generator of https proxies."""
    https_proxies = get_proxies(url, 'https')
    num_proxies = len(https_proxies)
    i = 0
    while i < num_proxies:
        yield https_proxies[i]
        i += 1
