# -*- coding: utf-8 -*-


"""
proxyapi.requestsproxies
~~~~~~~~~~~~~~

This module provides a proxy dictionary for the requests library.
"""

from .generators import get_http_proxy, get_https_proxy


class RequestsProxies(object):

    """A RequestsProxies dictionary."""

    def __init__(self, url='http://proxyapi.davidxia.com/'):
        self.http_proxy_gen = get_http_proxy(url)
        self.https_proxy_gen = get_https_proxy(url)

        self.proxies = {}
        self.next_http_proxy()
        self.next_https_proxy()

    def get_proxies(self):
        """Return proxies dictionary."""
        return self.proxies

    def next_http_proxy(self):
        """Update dictionary with next http proxy."""
        http_proxy = next(self.http_proxy_gen)
        self.proxies.update({
            'http': ('http://%s:%s' % (http_proxy['ip_address'],
                                       http_proxy['port']))
        })

    def next_https_proxy(self):
        """Update dictionary with next https proxy."""
        https_proxy = next(self.https_proxy_gen)
        self.proxies.update({
            'https': ('https://%s:%s' % (https_proxy['ip_address'],
                                         https_proxy['port'])),
        })
