# -*- coding: utf-8 -*-


"""This module provides a proxy dictionary for the requests library."""


from .generators import get_http_proxy, get_https_proxy
from .generators import get_http_proxy_from_json, get_https_proxy_from_json


class RequestsProxies(object):

    """A RequestsProxies dictionary."""

    def __init__(self, json_str=None, file_path=None, url='http://proxyapi.davidxia.com/'):
        if json_str is not None:
            self.http_proxy_gen = get_http_proxy_from_json(json_str)
            self.https_proxy_gen = get_https_proxy_from_json(json_str)
        elif file_path is not None:
            with open(file_path) as f:
                json_str = f.read()
            self.http_proxy_gen = get_http_proxy_from_json(json_str)
            self.https_proxy_gen = get_https_proxy_from_json(json_str)
        else:
            self.http_proxy_gen = get_http_proxy(url)
            self.https_proxy_gen = get_https_proxy(url)

        self.proxies = {}
        self.next_http_proxy()
        self.next_https_proxy()

    def get_proxies(self):
        """Return proxies dictionary."""
        return self.proxies

    def next_http_proxy(self):
        """Update dictionary with next http proxy."""
        http_proxy = next(self.http_proxy_gen)
        self.proxies.update({
            'http': ('http://%s:%s' % (http_proxy['ip_address'],
                                       http_proxy['port']))
        })

    def next_https_proxy(self):
        """Update dictionary with next https proxy."""
        https_proxy = next(self.https_proxy_gen)
        self.proxies.update({
            'https': ('https://%s:%s' % (https_proxy['ip_address'],
                                         https_proxy['port'])),
        })
