# coding: utf-8

import re

__author__ = 'Alex Musayev'
__license__ = 'MIT'
__status__ = 'Development'
__url__ = 'http://github.com/dreikanter/python-urlify'
__version_info__ = (0, 0, 1)
__version__ = '.'.join(map(str, __version_info__))


UBERMAP = {
    # Latin:
    ord(u'À'): u'A',
    ord(u'Á'): u'A',
    ord(u'Â'): u'A',
    ord(u'Ã'): u'A',
    ord(u'Ä'): u'A',
    ord(u'Å'): u'A',
    ord(u'Æ'): u'AE',
    ord(u'Ç'): u'C',
    ord(u'È'): u'E',
    ord(u'É'): u'E',
    ord(u'Ê'): u'E',
    ord(u'Ë'): u'E',
    ord(u'Ì'): u'I',
    ord(u'Í'): u'I',
    ord(u'Î'): u'I',
    ord(u'Ï'): u'I',
    ord(u'Ð'): u'D',
    ord(u'Ñ'): u'N',
    ord(u'Ò'): u'O',
    ord(u'Ó'): u'O',
    ord(u'Ô'): u'O',
    ord(u'Õ'): u'O',
    ord(u'Ö'): u'O',
    ord(u'Ő'): u'O',
    ord(u'Ø'): u'O',
    ord(u'Ù'): u'U',
    ord(u'Ú'): u'U',
    ord(u'Û'): u'U',
    ord(u'Ü'): u'U',
    ord(u'Ű'): u'U',
    ord(u'Ý'): u'Y',
    ord(u'Þ'): u'TH',
    ord(u'ß'): u'ss',
    ord(u'à'): u'a',
    ord(u'á'): u'a',
    ord(u'â'): u'a',
    ord(u'ã'): u'a',
    ord(u'ä'): u'a',
    ord(u'å'): u'a',
    ord(u'æ'): u'ae',
    ord(u'ç'): u'c',
    ord(u'è'): u'e',
    ord(u'é'): u'e',
    ord(u'ê'): u'e',
    ord(u'ë'): u'e',
    ord(u'ì'): u'i',
    ord(u'í'): u'i',
    ord(u'î'): u'i',
    ord(u'ï'): u'i',
    ord(u'ð'): u'd',
    ord(u'ñ'): u'n',
    ord(u'ò'): u'o',
    ord(u'ó'): u'o',
    ord(u'ô'): u'o',
    ord(u'õ'): u'o',
    ord(u'ö'): u'o',
    ord(u'ő'): u'o',
    ord(u'ø'): u'o',
    ord(u'ù'): u'u',
    ord(u'ú'): u'u',
    ord(u'û'): u'u',
    ord(u'ü'): u'u',
    ord(u'ű'): u'u',
    ord(u'ý'): u'y',
    ord(u'þ'): u'th',
    ord(u'ÿ'): u'y',

    ord(u'©'): u'c',

# Greek:
    ord(u'α'): u'a',
    ord(u'β'): u'b',
    ord(u'γ'): u'g',
    ord(u'δ'): u'd',
    ord(u'ε'): u'e',
    ord(u'ζ'): u'z',
    ord(u'η'): u'h',
    ord(u'θ'): u'8',
    ord(u'ι'): u'i',
    ord(u'κ'): u'k',
    ord(u'λ'): u'l',
    ord(u'μ'): u'm',
    ord(u'ν'): u'n',
    ord(u'ξ'): u'3',
    ord(u'ο'): u'o',
    ord(u'π'): u'p',
    ord(u'ρ'): u'r',
    ord(u'σ'): u's',
    ord(u'τ'): u't',
    ord(u'υ'): u'y',
    ord(u'φ'): u'f',
    ord(u'χ'): u'x',
    ord(u'ψ'): u'ps',
    ord(u'ω'): u'w',
    ord(u'ά'): u'a',
    ord(u'έ'): u'e',
    ord(u'ί'): u'i',
    ord(u'ό'): u'o',
    ord(u'ύ'): u'y',
    ord(u'ή'): u'h',
    ord(u'ώ'): u'w',
    ord(u'ς'): u's',
    ord(u'ϊ'): u'i',
    ord(u'ΰ'): u'y',
    ord(u'ϋ'): u'y',
    ord(u'ΐ'): u'i',
    ord(u'Α'): u'A',
    ord(u'Β'): u'B',
    ord(u'Γ'): u'G',
    ord(u'Δ'): u'D',
    ord(u'Ε'): u'E',
    ord(u'Ζ'): u'Z',
    ord(u'Η'): u'H',
    ord(u'Θ'): u'8',
    ord(u'Ι'): u'I',
    ord(u'Κ'): u'K',
    ord(u'Λ'): u'L',
    ord(u'Μ'): u'M',
    ord(u'Ν'): u'N',
    ord(u'Ξ'): u'3',
    ord(u'Ο'): u'O',
    ord(u'Π'): u'P',
    ord(u'Ρ'): u'R',
    ord(u'Σ'): u'S',
    ord(u'Τ'): u'T',
    ord(u'Υ'): u'Y',
    ord(u'Φ'): u'F',
    ord(u'Χ'): u'X',
    ord(u'Ψ'): u'PS',
    ord(u'Ω'): u'W',
    ord(u'Ά'): u'A',
    ord(u'Έ'): u'E',
    ord(u'Ί'): u'I',
    ord(u'Ό'): u'O',
    ord(u'Ύ'): u'Y',
    ord(u'Ή'): u'H',
    ord(u'Ώ'): u'W',
    ord(u'Ϊ'): u'I',
    ord(u'Ϋ'): u'Y',

# Turkish:
    ord(u'ş'): u's',
    ord(u'Ş'): u'S',
    ord(u'ı'): u'i',
    ord(u'İ'): u'I',
    ord(u'ç'): u'c',
    ord(u'Ç'): u'C',
    ord(u'ü'): u'u',
    ord(u'Ü'): u'U',
    ord(u'ö'): u'o',
    ord(u'Ö'): u'O',
    ord(u'ğ'): u'g',
    ord(u'Ğ'): u'G',

# Russian:
    ord(u'а'): u'a',
    ord(u'б'): u'b',
    ord(u'в'): u'v',
    ord(u'г'): u'g',
    ord(u'д'): u'd',
    ord(u'е'): u'e',
    ord(u'ё'): u'yo',
    ord(u'ж'): u'zh',
    ord(u'з'): u'z',
    ord(u'и'): u'i',
    ord(u'й'): u'j',
    ord(u'к'): u'k',
    ord(u'л'): u'l',
    ord(u'м'): u'm',
    ord(u'н'): u'n',
    ord(u'о'): u'o',
    ord(u'п'): u'p',
    ord(u'р'): u'r',
    ord(u'с'): u's',
    ord(u'т'): u't',
    ord(u'у'): u'u',
    ord(u'ф'): u'f',
    ord(u'х'): u'h',
    ord(u'ц'): u'c',
    ord(u'ч'): u'ch',
    ord(u'ш'): u'sh',
    ord(u'щ'): u'sch',
    ord(u'ъ'): u'',
    ord(u'ы'): u'y',
    ord(u'ь'): u'',
    ord(u'э'): u'e',
    ord(u'ю'): u'yu',
    ord(u'я'): u'ya',
    ord(u'А'): u'A',
    ord(u'Б'): u'B',
    ord(u'В'): u'V',
    ord(u'Г'): u'G',
    ord(u'Д'): u'D',
    ord(u'Е'): u'E',
    ord(u'Ё'): u'Yo',
    ord(u'Ж'): u'Zh',
    ord(u'З'): u'Z',
    ord(u'И'): u'I',
    ord(u'Й'): u'J',
    ord(u'К'): u'K',
    ord(u'Л'): u'L',
    ord(u'М'): u'M',
    ord(u'Н'): u'N',
    ord(u'О'): u'O',
    ord(u'П'): u'P',
    ord(u'Р'): u'R',
    ord(u'С'): u'S',
    ord(u'Т'): u'T',
    ord(u'У'): u'U',
    ord(u'Ф'): u'F',
    ord(u'Х'): u'H',
    ord(u'Ц'): u'C',
    ord(u'Ч'): u'Ch',
    ord(u'Ш'): u'Sh',
    ord(u'Щ'): u'Sch',
    ord(u'Ъ'): u'',
    ord(u'Ы'): u'Y',
    ord(u'Ь'): u'',
    ord(u'Э'): u'E',
    ord(u'Ю'): u'Yu',
    ord(u'Я'): u'Ya',

# Ukrainian:
    ord(u'Є'): u'Ye',
    ord(u'І'): u'I',
    ord(u'Ї'): u'Yi',
    ord(u'Ґ'): u'G',
    ord(u'є'): u'ye',
    ord(u'і'): u'i',
    ord(u'ї'): u'yi',
    ord(u'ґ'): u'g',

# Czech:
    ord(u'č'): u'c',
    ord(u'ď'): u'd',
    ord(u'ě'): u'e',
    ord(u'ň'): u'n',
    ord(u'ř'): u'r',
    ord(u'š'): u's',
    ord(u'ť'): u't',
    ord(u'ů'): u'u',
    ord(u'ž'): u'z',
    ord(u'Č'): u'C',
    ord(u'Ď'): u'D',
    ord(u'Ě'): u'E',
    ord(u'Ň'): u'N',
    ord(u'Ř'): u'R',
    ord(u'Š'): u'S',
    ord(u'Ť'): u'T',
    ord(u'Ů'): u'U',
    ord(u'Ž'): u'Z',

# Polish:
    ord(u'ą'): u'a',
    ord(u'ć'): u'c',
    ord(u'ę'): u'e',
    ord(u'ł'): u'l',
    ord(u'ń'): u'n',
    ord(u'ó'): u'o',
    ord(u'ś'): u's',
    ord(u'ź'): u'z',
    ord(u'ż'): u'z',
    ord(u'Ą'): u'A',
    ord(u'Ć'): u'C',
    ord(u'Ę'): u'e',
    ord(u'Ł'): u'L',
    ord(u'Ń'): u'N',
    ord(u'Ó'): u'o',
    ord(u'Ś'): u'S',
    ord(u'Ź'): u'Z',
    ord(u'Ż'): u'Z',

# Latvian:
    ord(u'ā'): u'a',
    ord(u'č'): u'c',
    ord(u'ē'): u'e',
    ord(u'ģ'): u'g',
    ord(u'ī'): u'i',
    ord(u'ķ'): u'k',
    ord(u'ļ'): u'l',
    ord(u'ņ'): u'n',
    ord(u'š'): u's',
    ord(u'ū'): u'u',
    ord(u'ž'): u'z',
    ord(u'Ā'): u'A',
    ord(u'Č'): u'C',
    ord(u'Ē'): u'E',
    ord(u'Ģ'): u'G',
    ord(u'Ī'): u'i',
    ord(u'Ķ'): u'k',
    ord(u'Ļ'): u'L',
    ord(u'Ņ'): u'N',
    ord(u'Š'): u'S',
    ord(u'Ū'): u'u',
    ord(u'Ž'): u'Z',
}

EXCLUSIONS = [
    'a',
    'an',
    'as',
    'at',
    'before',
    'but',
    'by',
    'for',
    'from',
    'is',
    'in',
    'into',
    'like',
    'of',
    'off',
    'on',
    'onto',
    'per',
    'since',
    'than',
    'the',
    'this',
    'that',
    'to',
    'up',
    'via',
    'with',
]

_base = re.compile(r"[a-zA-Z\d\s-]+")
_exclude = re.compile('|'.join([r"\b%s\b" % word for word in EXCLUSIONS]))
_space = re.compile(r"[\s_\-]+")


def urlify(text, exclude=EXCLUSIONS, ext_map={}):
    UBERMAP.update(ext_map)
    mapchar = lambda c: c if _base.match(c) else UBERMAP.get(ord(c), '')
    result = ''.join(map(mapchar, text)).lower()
    return _space.sub('-', _exclude.sub('', result).strip())
