/**
    @overview A minimal emulation of the standard features of nodejs necessary
    to get jsdoc to run.
 */

/**
    Emulate timeout/interval functions.
    @see http://stackoverflow.com/q/2261705
 */

setTimeout = null,
clearTimeout = null,
setInterval = null,
clearInterval = null;

(function() {
    var timer = new java.util.Timer();
    var counter = 1;
    var ids = {};

    setTimeout = function (fn, delay) {
        delay = delay || 0;
        var id = counter++;
        ids[id] = new JavaAdapter(java.util.TimerTask, {run: fn});
        timer.schedule(ids[id], delay);
        return id;
    };

    clearTimeout = function (id) {
        ids[id].cancel();
        timer.purge();
        delete ids[id];
    };

    setInterval = function (fn, delay) {
        delay = delay || 0;
        var id = counter++;
        ids[id] = new JavaAdapter(java.util.TimerTask, {run: fn});
        timer.schedule(ids[id], delay, delay);
        return id;
    };

    clearInterval = clearTimeout;
}())

/**
    Emulate nodejs console functions.
    @see http://nodejs.org/docs/v0.4.8/api/stdio.html
 */
console = {
    log: function(/*...*/) {
        var args = Array.prototype.slice.call(arguments, 0),
            dumper = dumper || require('jsdoc/util/dumper');

        for (var i = 0, len = args.length; i < len; i++) {
            if (typeof args[i] !== 'string') {
                args[i] = dumper.dump(args[i]);
            }
        }

        print( args.join(' ') );
    }
};

/**
    Emulate nodejs process functions.
    @see http://nodejs.org/docs/v0.4.8/api/process.html
 */
process = {
    argv: [env.dirname + '/jsdoc.js'].concat(Array.prototype.slice.call(arguments, 0)),
    cwd: function() {
        return new Packages.java.io.File('.').getCanonicalPath() + '';
    },
    env: java.lang.System.getProperties(),
    exit: function(n) {
        n = n || 0;
        java.lang.System.exit(n);
    }
};
