'''
Documentation for utilities used by pulsar internals. This module is
independent from all other pulsar modules and therefore can be used
as a stand-alone library.

HTTP
============

.. automodule:: pulsar.utils.httpurl

   

.. _tools-ws-parser:

Websocket
==============================

.. automodule:: pulsar.utils.websocket

Frame
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

.. autoclass:: Frame
   :members:
   :member-order: bysource
   
   
Frame Parser
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

.. autoclass:: FrameParser
   :members:
   :member-order: bysource
   
   
.. _api-config:

Configuration
==================

.. automodule:: pulsar.utils.config


     
.. _socket_address:

Socket and addresses
=======================

.. automodule:: pulsar.utils.internet
   :members:

Internals
=======================


.. module:: pulsar.utils.system

System info
~~~~~~~~~~~~~~~~~

.. autofunction:: system_info



.. module:: pulsar.utils.tools

checkarity
~~~~~~~~~~~~~~~~~

.. autofunction:: checkarity


Structures
==================

.. automodule:: pulsar.utils.structures


HTML & Text
==================

.. automodule:: pulsar.utils.html
   :members:
   
Logging
==================

.. automodule:: pulsar.utils.log
   :members:
   
   
Path
==================

.. automodule:: pulsar.utils.html
   :members:
'''