SUCCESS = 1
FAILURE = 2
REVOKED = 3
RETRY = 4
STARTED = 5
QUEUED = 6

FULL_RUN_STATES = frozenset([SUCCESS, FAILURE])
READY_STATES = frozenset([SUCCESS, FAILURE, REVOKED])
EXCEPTION_STATES = frozenset([FAILURE, REVOKED])
UNREADY_STATES = frozenset([QUEUED, STARTED, RETRY])

CODES = {SUCCESS: "SUCCESS",
         FAILURE: "FAILURE",
         REVOKED: "REVOKED",
         RETRY: 'RETRY',
         STARTED: "STARTED",
         QUEUED: "QUEUED"}
UNKNOWN = 'UNKNOWN'


def status_string(status):
    return CODES.get(status, UNKNOWN)
