'''
Documentation for utilities used by pulsar internals. This module is
independent from all other pulsar modules and therefore can be used
as a stand-alone library.

HTTP
============

.. automodule:: pulsar.utils.httpurl


.. _tools-ws-parser:

Websocket
==============================

.. automodule:: pulsar.utils.websocket


.. _api-config:

Configuration
==================

.. automodule:: pulsar.utils.config


.. _socket_address:

Socket and addresses
=======================

.. automodule:: pulsar.utils.internet
   :members:

Internals
=======================

.. module:: pulsar.utils.system

System info
~~~~~~~~~~~~~~~~~

.. autofunction:: process_info


.. module:: pulsar.utils.tools

checkarity
~~~~~~~~~~~~~~~~~

.. autofunction:: checkarity


Structures
==================

.. automodule:: pulsar.utils.structures


HTML & Text
==================

.. automodule:: pulsar.utils.html
   :members:

Slugify
==================

.. automodule:: pulsar.utils.slugify


Logging
==================

.. automodule:: pulsar.utils.log
   :members:


Path
==================

.. automodule:: pulsar.utils.path
   :members:

'''
