import os, re

def generate(self):
    """Generates a dictionary of all the known CRC formats from:
    http://reveng.sourceforge.net/crc-catalogue/all.htm

    See pwnlib/data/crcsum.txt for more information.
    """

    curdir, _ = os.path.split(__file__)
    path = os.path.join(curdir, '..', 'data', 'crcsums.txt')
    with open(path) as fd:
        data = fd.read()
    out = {}
    def fixup(s):
        if s == 'true':
            return True
        elif s == 'false':
            return False
        elif s.startswith('"'):
            assert re.match('"[^"]+"', s)
            return s[1:-1]
        elif s.startswith('0x'):
            assert re.match('0x[0-9a-fA-F]+', s)
            return int(s[2:], 16)
        else:
            assert re.match('[0-9]+', s)
            return int(s, 10)

    for l in data.strip().split('\n'):
        if not l or l[0] == '#':
            continue

        ref, l = l.split(' ', 1)

        cur = {}
        cur['link'] = 'http://reveng.sourceforge.net/crc-catalogue/all.htm#' + ref
        for key in ['width', 'poly', 'init', 'refin', 'refout', 'xorout', 'check', 'name']:
            cur[key] = fixup(re.findall(r'%s=(\S+)' % key, l)[0])

        cur['name'] = cur['name'].lower().replace('/', '_').replace('-', '_')
        assert cur['name'] not in out
        out[cur['name']] = cur

    return out


all_crcs = \
{'arc': {'check': 47933,
         'init': 0,
         'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.16',
         'name': 'arc',
         'poly': 32773,
         'refin': True,
         'refout': True,
         'width': 16,
         'xorout': 0},
 'crc_10': {'check': 409,
            'init': 0,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.10',
            'name': 'crc_10',
            'poly': 563,
            'refin': False,
            'refout': False,
            'width': 10,
            'xorout': 0},
 'crc_10_cdma2000': {'check': 563,
                     'init': 1023,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-10-cdma2000',
                     'name': 'crc_10_cdma2000',
                     'poly': 985,
                     'refin': False,
                     'refout': False,
                     'width': 10,
                     'xorout': 0},
 'crc_11': {'check': 1443,
            'init': 26,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.11',
            'name': 'crc_11',
            'poly': 901,
            'refin': False,
            'refout': False,
            'width': 11,
            'xorout': 0},
 'crc_12_3gpp': {'check': 3503,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.12',
                 'name': 'crc_12_3gpp',
                 'poly': 2063,
                 'refin': False,
                 'refout': True,
                 'width': 12,
                 'xorout': 0},
 'crc_12_cdma2000': {'check': 3405,
                     'init': 4095,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-12-cdma2000',
                     'name': 'crc_12_cdma2000',
                     'poly': 3859,
                     'refin': False,
                     'refout': False,
                     'width': 12,
                     'xorout': 0},
 'crc_12_dect': {'check': 3931,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-12-dect',
                 'name': 'crc_12_dect',
                 'poly': 2063,
                 'refin': False,
                 'refout': False,
                 'width': 12,
                 'xorout': 0},
 'crc_13_bbc': {'check': 1274,
                'init': 0,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.13',
                'name': 'crc_13_bbc',
                'poly': 7413,
                'refin': False,
                'refout': False,
                'width': 13,
                'xorout': 0},
 'crc_14_darc': {'check': 2093,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.14',
                 'name': 'crc_14_darc',
                 'poly': 2053,
                 'refin': True,
                 'refout': True,
                 'width': 14,
                 'xorout': 0},
 'crc_15': {'check': 1438,
            'init': 0,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.15',
            'name': 'crc_15',
            'poly': 17817,
            'refin': False,
            'refout': False,
            'width': 15,
            'xorout': 0},
 'crc_15_mpt1327': {'check': 9574,
                    'init': 0,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-15-mpt1327',
                    'name': 'crc_15_mpt1327',
                    'poly': 26645,
                    'refin': False,
                    'refout': False,
                    'width': 15,
                    'xorout': 1},
 'crc_16_aug_ccitt': {'check': 58828,
                      'init': 7439,
                      'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-aug-ccitt',
                      'name': 'crc_16_aug_ccitt',
                      'poly': 4129,
                      'refin': False,
                      'refout': False,
                      'width': 16,
                      'xorout': 0},
 'crc_16_buypass': {'check': 65256,
                    'init': 0,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-buypass',
                    'name': 'crc_16_buypass',
                    'poly': 32773,
                    'refin': False,
                    'refout': False,
                    'width': 16,
                    'xorout': 0},
 'crc_16_ccitt_false': {'check': 10673,
                        'init': 65535,
                        'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-ccitt-false',
                        'name': 'crc_16_ccitt_false',
                        'poly': 4129,
                        'refin': False,
                        'refout': False,
                        'width': 16,
                        'xorout': 0},
 'crc_16_cdma2000': {'check': 19462,
                     'init': 65535,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-cdma2000',
                     'name': 'crc_16_cdma2000',
                     'poly': 51303,
                     'refin': False,
                     'refout': False,
                     'width': 16,
                     'xorout': 0},
 'crc_16_dds_110': {'check': 40655,
                    'init': 32781,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-dds-110',
                    'name': 'crc_16_dds_110',
                    'poly': 32773,
                    'refin': False,
                    'refout': False,
                    'width': 16,
                    'xorout': 0},
 'crc_16_dect_r': {'check': 126,
                   'init': 0,
                   'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-dect-r',
                   'name': 'crc_16_dect_r',
                   'poly': 1417,
                   'refin': False,
                   'refout': False,
                   'width': 16,
                   'xorout': 1},
 'crc_16_dect_x': {'check': 127,
                   'init': 0,
                   'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-dect-x',
                   'name': 'crc_16_dect_x',
                   'poly': 1417,
                   'refin': False,
                   'refout': False,
                   'width': 16,
                   'xorout': 0},
 'crc_16_dnp': {'check': 60034,
                'init': 0,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-dnp',
                'name': 'crc_16_dnp',
                'poly': 15717,
                'refin': True,
                'refout': True,
                'width': 16,
                'xorout': 65535},
 'crc_16_en_13757': {'check': 49847,
                     'init': 0,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-en-13757',
                     'name': 'crc_16_en_13757',
                     'poly': 15717,
                     'refin': False,
                     'refout': False,
                     'width': 16,
                     'xorout': 65535},
 'crc_16_genibus': {'check': 54862,
                    'init': 65535,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-genibus',
                    'name': 'crc_16_genibus',
                    'poly': 4129,
                    'refin': False,
                    'refout': False,
                    'width': 16,
                    'xorout': 65535},
 'crc_16_maxim': {'check': 17602,
                  'init': 0,
                  'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-maxim',
                  'name': 'crc_16_maxim',
                  'poly': 32773,
                  'refin': True,
                  'refout': True,
                  'width': 16,
                  'xorout': 65535},
 'crc_16_mcrf4xx': {'check': 28561,
                    'init': 65535,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-mcrf4xx',
                    'name': 'crc_16_mcrf4xx',
                    'poly': 4129,
                    'refin': True,
                    'refout': True,
                    'width': 16,
                    'xorout': 0},
 'crc_16_riello': {'check': 25552,
                   'init': 45738,
                   'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-riello',
                   'name': 'crc_16_riello',
                   'poly': 4129,
                   'refin': True,
                   'refout': True,
                   'width': 16,
                   'xorout': 0},
 'crc_16_t10_dif': {'check': 53467,
                    'init': 0,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-t10-dif',
                    'name': 'crc_16_t10_dif',
                    'poly': 35767,
                    'refin': False,
                    'refout': False,
                    'width': 16,
                    'xorout': 0},
 'crc_16_teledisk': {'check': 4019,
                     'init': 0,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-teledisk',
                     'name': 'crc_16_teledisk',
                     'poly': 41111,
                     'refin': False,
                     'refout': False,
                     'width': 16,
                     'xorout': 0},
 'crc_16_tms37157': {'check': 9905,
                     'init': 35308,
                     'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-tms37157',
                     'name': 'crc_16_tms37157',
                     'poly': 4129,
                     'refin': True,
                     'refout': True,
                     'width': 16,
                     'xorout': 0},
 'crc_16_usb': {'check': 46280,
                'init': 65535,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-16-usb',
                'name': 'crc_16_usb',
                'poly': 32773,
                'refin': True,
                'refout': True,
                'width': 16,
                'xorout': 65535},
 'crc_24': {'check': 2215682,
            'init': 11994318,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.24',
            'name': 'crc_24',
            'poly': 8801531,
            'refin': False,
            'refout': False,
            'width': 24,
            'xorout': 0},
 'crc_24_flexray_a': {'check': 7961021,
                      'init': 16702650,
                      'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-24-flexray-a',
                      'name': 'crc_24_flexray_a',
                      'poly': 6122955,
                      'refin': False,
                      'refout': False,
                      'width': 24,
                      'xorout': 0},
 'crc_24_flexray_b': {'check': 2040760,
                      'init': 11259375,
                      'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-24-flexray-b',
                      'name': 'crc_24_flexray_b',
                      'poly': 6122955,
                      'refin': False,
                      'refout': False,
                      'width': 24,
                      'xorout': 0},
 'crc_31_philips': {'check': 216654956,
                    'init': 2147483647,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.31',
                    'name': 'crc_31_philips',
                    'poly': 79764919,
                    'refin': False,
                    'refout': False,
                    'width': 31,
                    'xorout': 2147483647},
 'crc_32': {'check': 3421780262,
            'init': 4294967295,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.32',
            'name': 'crc_32',
            'poly': 79764919,
            'refin': True,
            'refout': True,
            'width': 32,
            'xorout': 4294967295},
 'crc_32_bzip2': {'check': 4236843288,
                  'init': 4294967295,
                  'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32-bzip2',
                  'name': 'crc_32_bzip2',
                  'poly': 79764919,
                  'refin': False,
                  'refout': False,
                  'width': 32,
                  'xorout': 4294967295},
 'crc_32_mpeg_2': {'check': 58124007,
                   'init': 4294967295,
                   'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32-mpeg-2',
                   'name': 'crc_32_mpeg_2',
                   'poly': 79764919,
                   'refin': False,
                   'refout': False,
                   'width': 32,
                   'xorout': 0},
 'crc_32_posix': {'check': 1985902208,
                  'init': 0,
                  'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32-posix',
                  'name': 'crc_32_posix',
                  'poly': 79764919,
                  'refin': False,
                  'refout': False,
                  'width': 32,
                  'xorout': 4294967295},
 'crc_32c': {'check': 3808858755,
             'init': 4294967295,
             'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32c',
             'name': 'crc_32c',
             'poly': 517762881,
             'refin': True,
             'refout': True,
             'width': 32,
             'xorout': 4294967295},
 'crc_32d': {'check': 2268157302,
             'init': 4294967295,
             'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32d',
             'name': 'crc_32d',
             'poly': 2821953579,
             'refin': True,
             'refout': True,
             'width': 32,
             'xorout': 4294967295},
 'crc_32q': {'check': 806403967,
             'init': 0,
             'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-32q',
             'name': 'crc_32q',
             'poly': 2168537515,
             'refin': False,
             'refout': False,
             'width': 32,
             'xorout': 0},
 'crc_3_rohc': {'check': 6,
                'init': 7,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.3',
                'name': 'crc_3_rohc',
                'poly': 3,
                'refin': True,
                'refout': True,
                'width': 3,
                'xorout': 0},
 'crc_40_gsm': {'check': 910907393606,
                'init': 0,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.40',
                'name': 'crc_40_gsm',
                'poly': 75628553,
                'refin': False,
                'refout': False,
                'width': 40,
                'xorout': 1099511627775},
 'crc_4_itu': {'check': 7,
               'init': 0,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.4',
               'name': 'crc_4_itu',
               'poly': 3,
               'refin': True,
               'refout': True,
               'width': 4,
               'xorout': 0},
 'crc_5_epc': {'check': 0,
               'init': 9,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.5',
               'name': 'crc_5_epc',
               'poly': 9,
               'refin': False,
               'refout': False,
               'width': 5,
               'xorout': 0},
 'crc_5_itu': {'check': 7,
               'init': 0,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-5-itu',
               'name': 'crc_5_itu',
               'poly': 21,
               'refin': True,
               'refout': True,
               'width': 5,
               'xorout': 0},
 'crc_5_usb': {'check': 25,
               'init': 31,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-5-usb',
               'name': 'crc_5_usb',
               'poly': 5,
               'refin': True,
               'refout': True,
               'width': 5,
               'xorout': 31},
 'crc_64': {'check': 7800480153909949255,
            'init': 0,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.64',
            'name': 'crc_64',
            'poly': 4823603603198064275,
            'refin': False,
            'refout': False,
            'width': 64,
            'xorout': 0},
 'crc_64_we': {'check': 7128171145767219210,
               'init': 18446744073709551615L,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-64-we',
               'name': 'crc_64_we',
               'poly': 4823603603198064275,
               'refin': False,
               'refout': False,
               'width': 64,
               'xorout': 18446744073709551615L},
 'crc_64_xz': {'check': 11051210869376104954L,
               'init': 18446744073709551615L,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-64-xz',
               'name': 'crc_64_xz',
               'poly': 4823603603198064275,
               'refin': True,
               'refout': True,
               'width': 64,
               'xorout': 18446744073709551615L},
 'crc_6_cdma2000_a': {'check': 13,
                      'init': 63,
                      'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.6',
                      'name': 'crc_6_cdma2000_a',
                      'poly': 39,
                      'refin': False,
                      'refout': False,
                      'width': 6,
                      'xorout': 0},
 'crc_6_cdma2000_b': {'check': 59,
                      'init': 63,
                      'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-6-cdma2000-b',
                      'name': 'crc_6_cdma2000_b',
                      'poly': 7,
                      'refin': False,
                      'refout': False,
                      'width': 6,
                      'xorout': 0},
 'crc_6_darc': {'check': 38,
                'init': 0,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-6-darc',
                'name': 'crc_6_darc',
                'poly': 25,
                'refin': True,
                'refout': True,
                'width': 6,
                'xorout': 0},
 'crc_6_itu': {'check': 6,
               'init': 0,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-6-itu',
               'name': 'crc_6_itu',
               'poly': 3,
               'refin': True,
               'refout': True,
               'width': 6,
               'xorout': 0},
 'crc_7': {'check': 117,
           'init': 0,
           'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.7',
           'name': 'crc_7',
           'poly': 9,
           'refin': False,
           'refout': False,
           'width': 7,
           'xorout': 0},
 'crc_7_rohc': {'check': 83,
                'init': 127,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-7-rohc',
                'name': 'crc_7_rohc',
                'poly': 79,
                'refin': True,
                'refout': True,
                'width': 7,
                'xorout': 0},
 'crc_8': {'check': 244,
           'init': 0,
           'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.8',
           'name': 'crc_8',
           'poly': 7,
           'refin': False,
           'refout': False,
           'width': 8,
           'xorout': 0},
 'crc_82_darc': {'check': 749237524598872659187218L,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat-bits.82',
                 'name': 'crc_82_darc',
                 'poly': 229256212191916381701137L,
                 'refin': True,
                 'refout': True,
                 'width': 82,
                 'xorout': 0},
 'crc_8_cdma2000': {'check': 218,
                    'init': 255,
                    'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-cdma2000',
                    'name': 'crc_8_cdma2000',
                    'poly': 155,
                    'refin': False,
                    'refout': False,
                    'width': 8,
                    'xorout': 0},
 'crc_8_darc': {'check': 21,
                'init': 0,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-darc',
                'name': 'crc_8_darc',
                'poly': 57,
                'refin': True,
                'refout': True,
                'width': 8,
                'xorout': 0},
 'crc_8_dvb_s2': {'check': 188,
                  'init': 0,
                  'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-dvb-s2',
                  'name': 'crc_8_dvb_s2',
                  'poly': 213,
                  'refin': False,
                  'refout': False,
                  'width': 8,
                  'xorout': 0},
 'crc_8_ebu': {'check': 151,
               'init': 255,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-ebu',
               'name': 'crc_8_ebu',
               'poly': 29,
               'refin': True,
               'refout': True,
               'width': 8,
               'xorout': 0},
 'crc_8_i_code': {'check': 126,
                  'init': 253,
                  'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-i-code',
                  'name': 'crc_8_i_code',
                  'poly': 29,
                  'refin': False,
                  'refout': False,
                  'width': 8,
                  'xorout': 0},
 'crc_8_itu': {'check': 161,
               'init': 0,
               'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-itu',
               'name': 'crc_8_itu',
               'poly': 7,
               'refin': False,
               'refout': False,
               'width': 8,
               'xorout': 85},
 'crc_8_maxim': {'check': 161,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-maxim',
                 'name': 'crc_8_maxim',
                 'poly': 49,
                 'refin': True,
                 'refout': True,
                 'width': 8,
                 'xorout': 0},
 'crc_8_rohc': {'check': 208,
                'init': 255,
                'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-rohc',
                'name': 'crc_8_rohc',
                'poly': 7,
                'refin': True,
                'refout': True,
                'width': 8,
                'xorout': 0},
 'crc_8_wcdma': {'check': 37,
                 'init': 0,
                 'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-8-wdcma',
                 'name': 'crc_8_wcdma',
                 'poly': 155,
                 'refin': True,
                 'refout': True,
                 'width': 8,
                 'xorout': 0},
 'crc_a': {'check': 48901,
           'init': 50886,
           'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.crc-a',
           'name': 'crc_a',
           'poly': 4129,
           'refin': True,
           'refout': True,
           'width': 16,
           'xorout': 0},
 'jamcrc': {'check': 873187033,
            'init': 4294967295,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.jamcrc',
            'name': 'jamcrc',
            'poly': 79764919,
            'refin': True,
            'refout': True,
            'width': 32,
            'xorout': 0},
 'kermit': {'check': 8585,
            'init': 0,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.kermit',
            'name': 'kermit',
            'poly': 4129,
            'refin': True,
            'refout': True,
            'width': 16,
            'xorout': 0},
 'modbus': {'check': 19255,
            'init': 65535,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.modbus',
            'name': 'modbus',
            'poly': 32773,
            'refin': True,
            'refout': True,
            'width': 16,
            'xorout': 0},
 'x_25': {'check': 36974,
          'init': 65535,
          'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.x-25',
          'name': 'x_25',
          'poly': 4129,
          'refin': True,
          'refout': True,
          'width': 16,
          'xorout': 65535},
 'xfer': {'check': 3171672888,
          'init': 0,
          'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.xfer',
          'name': 'xfer',
          'poly': 175,
          'refin': False,
          'refout': False,
          'width': 32,
          'xorout': 0},
 'xmodem': {'check': 12739,
            'init': 0,
            'link': 'http://reveng.sourceforge.net/crc-catalogue/all.htm#crc.cat.xmodem',
            'name': 'xmodem',
            'poly': 4129,
            'refin': False,
            'refout': False,
            'width': 16,
            'xorout': 0}}