DROP TABLE IF EXISTS `type_conversion_test_1`;

-- SPLIT

DROP TABLE IF EXISTS `type_conversion_test_2`;

-- SPLIT

CREATE TABLE `type_conversion_test_1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
-- ENUM
  `type_enum_1` enum('small','medium','large') COLLATE utf8_bin NOT NULL DEFAULT 'large',
  `type_enum_2` enum('small','medium','large') COLLATE utf8_bin DEFAULT 'medium',
  `type_enum_3` enum('small','medium','large') COLLATE utf8_bin DEFAULT NULL,
  `type_enum_4` enum('small','medium','large') COLLATE utf8_bin NOT NULL,
-- SET
  `type_set_1` set('a','b','c','d','e') COLLATE utf8_bin NOT NULL DEFAULT 'a,b',
  `type_set_2` set('a','b','c','d','e') COLLATE utf8_bin DEFAULT 'c,d',
  `type_set_3` set('a','b','c','d','e') COLLATE utf8_bin DEFAULT NULL,
  `type_set_4` set('a','b','c','d','e') COLLATE utf8_bin NOT NULL,
-- CHAR
  `type_char_1` char(3) COLLATE utf8_bin NOT NULL DEFAULT 'abc',
  `type_char_2` char(3) COLLATE utf8_bin DEFAULT 'def',
  `type_char_3` char(3) COLLATE utf8_bin DEFAULT NULL,
  `type_char_4` char(3) COLLATE utf8_bin NOT NULL,
-- VARCHAR
  `type_varchar_1` varchar(45) COLLATE utf8_bin NOT NULL DEFAULT 'ghi',
  `type_varchar_2` varchar(45) COLLATE utf8_bin DEFAULT 'jkl',
  `type_varchar_3` varchar(45) COLLATE utf8_bin DEFAULT NULL,
  `type_varchar_4` varchar(45) COLLATE utf8_bin NOT NULL,
-- TINYTEXT
  `type_tinytext_1` tinytext COLLATE utf8_bin,
  `type_tinytext_2` tinytext COLLATE utf8_bin NOT NULL,
-- MEDIUMTEXT
  `type_mediumtext_1` mediumtext COLLATE utf8_bin,
  `type_mediumtext_2` mediumtext COLLATE utf8_bin NOT NULL,
-- TEXT
  `type_text_1` text COLLATE utf8_bin,
  `type_text_2` text COLLATE utf8_bin NOT NULL,
-- LONGTEXT
  `type_longtext_1` longtext COLLATE utf8_bin,
  `type_longtext_2` longtext COLLATE utf8_bin NOT NULL,
-- TINYBLOB
  `type_tinyblob_1` tinyblob,
  `type_tinyblob_2` tinyblob NOT NULL,
-- MEDIUMBLOB
  `type_mediumblob_1` mediumblob,
  `type_mediumblob_2` mediumblob NOT NULL,
-- BLOB
  `type_blob_1` blob,
  `type_blob_2` blob NOT NULL,
-- LONGBLOB
  `type_longblob_1` longblob,
  `type_longblob_2` longblob NOT NULL,
-- BINARY
  `type_binary_1` binary(3) DEFAULT NULL,
  `type_binary_2` binary(3) NOT NULL,
-- VARBINARY
  `type_varbinary_1` varbinary(50) DEFAULT NULL,
  `type_varbinary_2` varbinary(50) NOT NULL,
-- BIT
  `type_bit_1` bit(8) NOT NULL DEFAULT b'11111111',
  `type_bit_2` bit(8) DEFAULT b'1010',
  `type_bit_3` bit(8) DEFAULT NULL,
  `type_bit_4` bit(8) NOT NULL,
-- UNSIGNED TINYINT
  `type_tinyint_1` tinyint unsigned NOT NULL DEFAULT '0',
  `type_tinyint_2` tinyint unsigned DEFAULT '1',
  `type_tinyint_3` tinyint unsigned DEFAULT NULL,
  `type_tinyint_4` tinyint unsigned NOT NULL,
-- TINYINT
  `type_tinyint_5` tinyint NOT NULL DEFAULT '-2',
  `type_tinyint_6` tinyint DEFAULT '-3',
  `type_tinyint_7` tinyint DEFAULT NULL,
  `type_tinyint_8` tinyint NOT NULL,
  `type_tinyint_9` tinyint(1) NOT NULL DEFAULT '0',
  `type_tinyint_10` tinyint(1) DEFAULT '1',
-- UNSIGNED SMALLINT
  `type_smallint_1` smallint unsigned NOT NULL DEFAULT '4',
  `type_smallint_2` smallint unsigned DEFAULT '5',
  `type_smallint_3` smallint unsigned DEFAULT NULL,
  `type_smallint_4` smallint unsigned NOT NULL,
-- SMALLINT
  `type_smallint_5` smallint NOT NULL DEFAULT '-6',
  `type_smallint_6` smallint DEFAULT '-7',
  `type_smallint_7` smallint DEFAULT NULL,
  `type_smallint_8` smallint NOT NULL,
-- UNSIGNED MEDIUMINT
  `type_mediumint_1` mediumint unsigned NOT NULL DEFAULT '8',
  `type_mediumint_2` mediumint unsigned DEFAULT '9',
  `type_mediumint_3` mediumint unsigned DEFAULT NULL,
  `type_mediumint_4` mediumint unsigned NOT NULL,
-- MEDIUMINT
  `type_mediumint_5` mediumint NOT NULL DEFAULT '-10',
  `type_mediumint_6` mediumint DEFAULT '-11',
  `type_mediumint_7` mediumint DEFAULT NULL,
  `type_mediumint_8` mediumint NOT NULL,
-- UNSIGNED INT
  `type_int_1` int unsigned NOT NULL DEFAULT '12',
  `type_int_2` int unsigned DEFAULT '13',
  `type_int_3` int unsigned DEFAULT NULL,
  `type_int_4` int unsigned NOT NULL,
-- INT
  `type_int_5` int NOT NULL DEFAULT '-14',
  `type_int_6` int DEFAULT '-15',
  `type_int_7` int DEFAULT NULL,
  `type_int_8` int NOT NULL,
-- UNSIGNED BIGINT
  `type_bigint_1` bigint unsigned NOT NULL DEFAULT '16',
  `type_bigint_2` bigint unsigned DEFAULT '17',
  `type_bigint_3` bigint unsigned DEFAULT NULL,
  `type_bigint_4` bigint unsigned NOT NULL,
-- BIGINT
  `type_bigint_5` bigint NOT NULL DEFAULT '-18',
  `type_bigint_6` bigint DEFAULT '-19',
  `type_bigint_7` bigint DEFAULT NULL,
  `type_bigint_8` bigint NOT NULL,
-- UNSIGNED FLOAT
  `type_float_1` float unsigned NOT NULL DEFAULT '20.01',
  `type_float_2` float unsigned DEFAULT '21.01',
  `type_float_3` float unsigned DEFAULT NULL,
  `type_float_4` float unsigned NOT NULL,
-- FLOAT
  `type_float_5` float NOT NULL DEFAULT '-22.01',
  `type_float_6` float DEFAULT '-23.01',
  `type_float_7` float DEFAULT NULL,
  `type_float_8` float NOT NULL,
-- UNSIGNED DOUBLE
  `type_double_1` double unsigned NOT NULL DEFAULT '24.01',
  `type_double_2` double unsigned DEFAULT '25.01',
  `type_double_3` double unsigned DEFAULT NULL,
  `type_double_4` double unsigned NOT NULL,
-- DOUBLE
  `type_double_5` double NOT NULL DEFAULT '-26.01',
  `type_double_6` double DEFAULT '-27.01',
  `type_double_7` double DEFAULT NULL,
  `type_double_8` double NOT NULL,
-- UNSIGNED DECIMAL
  `type_decimal_1` decimal(5,2) unsigned NOT NULL DEFAULT '28.01',
  `type_decimal_2` decimal(5,2) unsigned DEFAULT '29.01',
  `type_decimal_3` decimal(5,2) unsigned DEFAULT NULL,
  `type_decimal_4` decimal(5,2) unsigned NOT NULL,
-- DECIMAL
  `type_decimal_5` decimal(5,2) NOT NULL DEFAULT '-30.01',
  `type_decimal_6` decimal(5,2) DEFAULT '-31.01',
  `type_decimal_7` decimal(5,2) DEFAULT NULL,
  `type_decimal_8` decimal(5,2) NOT NULL,
-- DATE
  `type_date_1` date NOT NULL DEFAULT '2011-08-01',
  `type_date_2` date NOT NULL DEFAULT '0000-00-00',
  `type_date_3` date DEFAULT '2011-08-02',
  `type_date_4` date DEFAULT '0000-00-00',
  `type_date_5` date DEFAULT NULL,
  `type_date_6` date NOT NULL,
-- DATETIME
  `type_datetime_1` datetime NOT NULL DEFAULT '2011-08-03 12:00:00',
  `type_datetime_2` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type_datetime_3` datetime DEFAULT '2011-08-04 12:00:00',
  `type_datetime_4` datetime DEFAULT '0000-00-00 00:00:00',
  `type_datetime_5` datetime DEFAULT NULL,
  `type_datetime_6` datetime NOT NULL,
-- TIME
  `type_time_1` time NOT NULL DEFAULT '13:00:00',
  `type_time_2` time NOT NULL DEFAULT '00:00:00',
  `type_time_3` time DEFAULT '14:00:00',
  `type_time_4` time DEFAULT '00:00:00',
  `type_time_5` time DEFAULT NULL,
  `type_time_6` time NOT NULL,
-- TIMESTAMP
  `type_timestamp_1` timestamp NOT NULL DEFAULT '2011-08-05 12:00:00',
  `type_timestamp_2` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type_timestamp_3` timestamp DEFAULT '2011-08-06 12:00:00',
  `type_timestamp_4` timestamp DEFAULT '0000-00-00 00:00:00',
  `type_timestamp_5` timestamp DEFAULT CURRENT_TIMESTAMP,
  `type_timestamp_6` timestamp NOT NULL,
-- YEAR
  `type_year_1` year(4) NOT NULL DEFAULT '0000',
  `type_year_2` year(4) NOT NULL DEFAULT '2011',
  `type_year_3` year(4) NOT NULL DEFAULT '12',
  `type_year_4` year(4) DEFAULT NULL,
  `type_year_5` year(4) NOT NULL,
-- UNSIGNED NUMERIC
  `type_numeric_1` numeric(15,5) unsigned NOT NULL DEFAULT '32.32',
  `type_numeric_2` numeric(15,5) unsigned DEFAULT '33.33',
  `type_numeric_3` numeric(15,5) unsigned DEFAULT NULL,
  `type_numeric_4` numeric(15,5) unsigned NOT NULL,
-- NUMERIC
  `type_numeric_5` numeric(15,5) NOT NULL DEFAULT '-34.34',
  `type_numeric_6` numeric(15,5) DEFAULT '-35.35',
  `type_numeric_7` numeric(15,5) DEFAULT NULL,
  `type_numeric_8` numeric(15,5) NOT NULL,

  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- SPLIT

INSERT INTO `type_conversion_test_1`
(`type_enum_1`,
`type_enum_4`,
`type_set_1`,
`type_set_4`,
`type_char_1`,
`type_char_4`,
`type_varchar_1`,
`type_varchar_4`,
`type_tinytext_2`,
`type_mediumtext_2`,
`type_text_2`,
`type_longtext_2`,
`type_tinyblob_2`,
`type_mediumblob_2`,
`type_blob_2`,
`type_longblob_2`,
`type_binary_2`,
`type_varbinary_2`,
`type_bit_1`,
`type_bit_4`,
`type_tinyint_1`,
`type_tinyint_4`,
`type_tinyint_5`,
`type_tinyint_8`,
`type_tinyint_9`,
`type_tinyint_10`,
`type_smallint_1`,
`type_smallint_4`,
`type_smallint_5`,
`type_smallint_8`,
`type_mediumint_1`,
`type_mediumint_4`,
`type_mediumint_5`,
`type_mediumint_8`,
`type_int_1`,
`type_int_4`,
`type_int_5`,
`type_int_8`,
`type_bigint_1`,
`type_bigint_4`,
`type_bigint_5`,
`type_bigint_8`,
`type_float_1`,
`type_float_4`,
`type_float_5`,
`type_float_8`,
`type_double_1`,
`type_double_4`,
`type_double_5`,
`type_double_8`,
`type_decimal_1`,
`type_decimal_4`,
`type_decimal_5`,
`type_decimal_8`,
`type_date_1`,
`type_date_2`,
`type_date_6`,
`type_datetime_1`,
`type_datetime_2`,
`type_datetime_6`,
`type_time_1`,
`type_time_2`,
`type_time_6`,
`type_timestamp_1`,
`type_timestamp_2`,
`type_timestamp_3`,
`type_timestamp_4`,
`type_timestamp_5`,
`type_timestamp_6`,
`type_year_1`,
`type_year_2`,
`type_year_3`,
`type_year_5`,
`type_numeric_1`,
`type_numeric_4`,
`type_numeric_5`,
`type_numeric_8`
)
VALUES
(
'small',
'large',
'a,c,e',
'b,c,d',
'zzy',
'yyz',
'xxx',
'www',
'vvv',
'uuu',
'ttt',
'sss',
'tiny blob 2',
'medium blob 2',
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
'rr',
'qq',
b'0001',
b'0010',
1,
4,
5,
8,
1,
0,
11,
44,
55,
88,
111,
444,
555,
888,
1111,
4444,
5555,
8888,
11111,
44444,
55555,
88888,
1111.1111,
4444.4444,
5555.5555,
8888.8888,
11.11,
44.44,
55.55,
88.88,
111.11,
444.44,
555.55,
888.88,
'1980-01-01',
'1981-02-02',
'1982-03-03',
'1991-01-01 01:01:01',
'1992-01-01 03:03:02',
'1993-01-01 03:03:03',
'01:01:01',
'02:02:02',
'03:03:03',
'2000-01-01 00:00:00',
'2001-01-01 01:00:00',
'2002-01-01 02:00:00',
'2003-01-01 03:00:00',
NULL,
'2005-01-01 05:00:00',
2000,
2001,
2002,
2003,
333333.33,
444444.44,
-555555.55,
-666666.66
);

-- SPLIT

INSERT INTO `type_conversion_test_1`
(`type_enum_1`,
`type_enum_3`,
`type_enum_4`,
`type_set_1`,
`type_set_3`,
`type_set_4`,
`type_char_1`,
`type_char_3`,
`type_char_4`,
`type_varchar_1`,
`type_varchar_3`,
`type_varchar_4`,
`type_tinytext_1`,
`type_tinytext_2`,
`type_mediumtext_1`,
`type_mediumtext_2`,
`type_text_1`,
`type_text_2`,
`type_longtext_1`,
`type_longtext_2`,
`type_tinyblob_1`,
`type_tinyblob_2`,
`type_mediumblob_1`,
`type_mediumblob_2`,
`type_blob_1`,
`type_blob_2`,
`type_longblob_1`,
`type_longblob_2`,
`type_binary_2`,
`type_varbinary_2`,
`type_bit_1`,
`type_bit_4`,
`type_tinyint_1`,
`type_tinyint_4`,
`type_tinyint_5`,
`type_tinyint_8`,
`type_tinyint_9`,
`type_tinyint_10`,
`type_smallint_1`,
`type_smallint_4`,
`type_smallint_5`,
`type_smallint_8`,
`type_mediumint_1`,
`type_mediumint_4`,
`type_mediumint_5`,
`type_mediumint_8`,
`type_int_1`,
`type_int_4`,
`type_int_5`,
`type_int_8`,
`type_bigint_1`,
`type_bigint_4`,
`type_bigint_5`,
`type_bigint_8`,
`type_float_1`,
`type_float_4`,
`type_float_5`,
`type_float_8`,
`type_double_1`,
`type_double_4`,
`type_double_5`,
`type_double_8`,
`type_decimal_1`,
`type_decimal_4`,
`type_decimal_5`,
`type_decimal_8`,
`type_date_1`,
`type_date_2`,
`type_date_6`,
`type_datetime_1`,
`type_datetime_2`,
`type_datetime_6`,
`type_time_1`,
`type_time_2`,
`type_time_6`,
`type_timestamp_1`,
`type_timestamp_2`,
`type_timestamp_3`,
`type_timestamp_4`,
`type_timestamp_5`,
`type_timestamp_6`,
`type_year_1`,
`type_year_2`,
`type_year_3`,
`type_year_5`,
`type_numeric_1`,
`type_numeric_4`,
`type_numeric_5`,
`type_numeric_8`)
VALUES
(
'small',
'medium',
'large',
'a,c,e',
'e,b,e',
'b,c,d',
'zzz',
'zzy',
'yyy',
'xxx',
'www',
'vvv',
'uuu',
'ttt',
'sss',
'mmm',
'nnn',
'ooo',
'ppp',
'qqq',
'tiny blob 1',
'tiny blob 2',
'medium blob 1',
'medium blob 2',
'blob 1',
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
'long blob 1',
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
'rr',
'qq',
b'0001',
b'0010',
1,
4,
5,
8,
0,
1,
11,
44,
55,
88,
111,
444,
555,
888,
1111,
4444,
5555,
8888,
11111,
44444,
55555,
88888,
1111.1111,
4444.4444,
5555.5555,
8888.8888,
11.11,
44.44,
55.55,
88.88,
111.11,
444.44,
555.55,
888.88,
'1980-01-01',
'1981-02-02',
'1982-03-03',
'1991-01-01 01:01:01',
'1992-01-01 03:03:02',
'1993-01-01 03:03:03',
'01:01:01',
'02:02:02',
'03:03:03',
'2000-01-01 00:00:00',
'2001-01-01 01:00:00',
'2002-01-01 02:00:00',
'2003-01-01 03:00:00',
NULL,
'2005-01-01 05:00:00',
2000,
2001,
2002,
2003,
777.77,
888888.8,
-90909.09,
-21323.5
);

-- SPLIT

INSERT INTO `type_conversion_test_1`
(`type_enum_1`,
`type_enum_4`,
`type_set_1`,
`type_set_4`,
`type_char_1`,
`type_char_4`,
`type_varchar_1`,
`type_varchar_4`,
`type_tinytext_2`,
`type_mediumtext_2`,
`type_text_2`,
`type_longtext_2`,
`type_tinyblob_2`,
`type_mediumblob_2`,
`type_blob_2`,
`type_longblob_2`,
`type_binary_2`,
`type_varbinary_2`,
`type_bit_1`,
`type_bit_4`,
`type_tinyint_1`,
`type_tinyint_4`,
`type_tinyint_5`,
`type_tinyint_8`,
`type_tinyint_9`,
`type_tinyint_10`,
`type_smallint_1`,
`type_smallint_4`,
`type_smallint_5`,
`type_smallint_8`,
`type_mediumint_1`,
`type_mediumint_4`,
`type_mediumint_5`,
`type_mediumint_8`,
`type_int_1`,
`type_int_4`,
`type_int_5`,
`type_int_8`,
`type_bigint_1`,
`type_bigint_4`,
`type_bigint_5`,
`type_bigint_8`,
`type_float_1`,
`type_float_4`,
`type_float_5`,
`type_float_8`,
`type_double_1`,
`type_double_4`,
`type_double_5`,
`type_double_8`,
`type_decimal_1`,
`type_decimal_4`,
`type_decimal_5`,
`type_decimal_8`,
`type_date_1`,
`type_date_2`,
`type_date_6`,
`type_datetime_1`,
`type_datetime_2`,
`type_datetime_6`,
`type_time_1`,
`type_time_2`,
`type_time_6`,
`type_timestamp_1`,
`type_timestamp_2`,
`type_timestamp_3`,
`type_timestamp_4`,
`type_timestamp_5`,
`type_timestamp_6`,
`type_year_1`,
`type_year_2`,
`type_year_3`,
`type_year_5`,
`type_numeric_1`,
`type_numeric_4`,
`type_numeric_5`,
`type_numeric_8`
)
VALUES
(
'small',
'large',
'a,c,e',
'b,c,d',
'ozy',
'ayz',
'xxx',
'wow',
'vvv',
'uuu',
'ttt',
'sss',
'tiny blob 2',
'medium blob 2',
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
'rr',
'qq',
b'0001',
b'0010',
0,
255,
-128,
127,
1,
0,
0,
65535,
-32768,
32767,
0,
16777215,
-8388608,
8388607,
0,
4294967295,
-2147483648,
2147483647,
0,
18446744073709551615,
-9223372036854775808,
9223372036854775807,
1111.1111,
4444.4444,
5555.5555,
8888.8888,
11.11,
44.44,
55.55,
88.88,
111.11,
444.44,
555.55,
888.88,
'1980-01-01',
'1981-02-02',
'1982-03-03',
'1991-01-01 01:01:01',
'1992-01-01 03:03:02',
'1993-01-01 03:03:03',
'01:01:01',
'02:02:02',
'03:03:03',
'2000-01-01 00:00:00',
'2001-01-01 01:00:00',
'2002-01-01 02:00:00',
'2003-01-01 03:00:00',
NULL,
'2005-01-01 05:00:00',
2000,
2001,
2002,
2003,
333333.33,
444444.44,
-555555.55,
-666666.66
);

-- SPLIT

CREATE  TABLE `type_conversion_test_2` (
  `id` INT NOT NULL AUTO_INCREMENT ,
  `tct_1_id` INT NOT NULL ,
  `foo` VARCHAR(45) NULL DEFAULT 'bar' ,
  FOREIGN KEY (tct_1_id) REFERENCES `type_conversion_test_2`(id) ON DELETE CASCADE,
  PRIMARY KEY (`id`) )
ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- SPLIT

INSERT INTO `type_conversion_test_2` (`tct_1_id`, `foo`) VALUES (1, 'bar');

-- SPLIT

INSERT INTO `type_conversion_test_2` (`tct_1_id`, `foo`) VALUES (2, 'baz');

-- SPLIT

ALTER TABLE `type_conversion_test_1` 
ADD UNIQUE INDEX `uniq_1_col` (`type_varchar_4` ASC) 
, ADD UNIQUE INDEX `uniq_2_col` (`type_char_1` ASC, `type_char_4` ASC) 
, ADD INDEX `idx_1_col` (`type_char_2` ASC) 
, ADD INDEX `idx_2_col` (`type_varchar_1` ASC, `type_varchar_2` ASC) ;
