/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import py4j.Argument;
import py4j.Gateway;
import py4j.Py4JException;
import py4j.ReturnObject;

public class DefaultGateway
implements Gateway {
    private final ScriptEngineManager mgr = new ScriptEngineManager();
    private final ScriptEngine jsEngine = this.mgr.getEngineByName("JavaScript");
    private final Bindings bindings = this.jsEngine.getBindings(100);
    private final AtomicInteger objCounter = new AtomicInteger();
    private final AtomicInteger argCounter = new AtomicInteger();
    private static final String OBJECT_NAME_PREFIX = "o";
    private static final String ARG_NAME_PREFIX = "a";
    private final Logger logger = Logger.getLogger(DefaultGateway.class.getName());
    private boolean isStarted = false;

    @Override
    public List<String> getMethodNames(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            methodNames.add(method.getName());
        }
        return new ArrayList<String>(methodNames);
    }

    @Override
    public String getMethodNamesAsString(Object obj) {
        List<String> methodNames = this.getMethodNames(obj);
        StringBuilder buffer = new StringBuilder();
        for (String methodName : methodNames) {
            buffer.append(methodName);
            buffer.append(",");
        }
        return buffer.toString();
    }

    @Override
    public void shutdown() {
        this.isStarted = false;
        this.bindings.clear();
    }

    @Override
    public void startup() {
        this.isStarted = true;
        this.bindings.put("g", (Object)this);
    }

    @Override
    public Object getObject(String objectId) {
        return this.bindings.get(objectId);
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    protected String getNextObjectId() {
        return OBJECT_NAME_PREFIX + this.objCounter.getAndIncrement();
    }

    protected AtomicInteger getObjCounter() {
        return this.objCounter;
    }

    protected AtomicInteger getArgCounter() {
        return this.argCounter;
    }

    protected String putNewObject(Object object) {
        String id = this.getNextObjectId();
        this.bindings.put(id, object);
        return id;
    }

    protected Bindings getBindings() {
        return this.bindings;
    }

    @Override
    public ReturnObject invoke(String methodName, String targetObjectId, List<Argument> args) {
        if (args == null) {
            args = new ArrayList<Argument>();
        }
        ReturnObject returnObject = null;
        ArrayList<String> tempArgsIds = new ArrayList<String>();
        try {
            StringBuilder methodCall = new StringBuilder();
            methodCall.append(targetObjectId);
            methodCall.append(".");
            methodCall.append(methodName);
            methodCall.append(this.buildArgs(args, tempArgsIds));
            methodCall.append(";");
            this.logger.info("Calling: " + methodCall.toString());
            Object object = this.jsEngine.eval(methodCall.toString());
            returnObject = this.getReturnObject(object);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        finally {
            this.cleanTempArgs(tempArgsIds);
        }
        return returnObject;
    }

    @Override
    public ReturnObject getReturnObject(Object object) {
        ReturnObject returnObject;
        if (object != null) {
            if (this.isPrimitiveObject(object)) {
                returnObject = ReturnObject.getPrimitiveReturnObject(object);
            } else if (this.isList(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getListReturnObject(objectId, ((List)object).size());
            } else {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getReferenceReturnObject(objectId);
            }
        } else {
            returnObject = ReturnObject.getNullReturnObject();
        }
        return returnObject;
    }

    protected boolean isPrimitiveObject(Object object) {
        return object instanceof Boolean || object instanceof String || object instanceof Number || object instanceof Character;
    }

    protected boolean isList(Object object) {
        return object instanceof List;
    }

    private void cleanTempArgs(List<String> tempArgsIds) {
        for (String argId : tempArgsIds) {
            this.bindings.remove(argId);
        }
    }

    private String buildArgs(List<Argument> args, List<String> tempArgsIds) {
        StringBuilder argsString = new StringBuilder();
        argsString.append('(');
        int i = 0;
        for (Argument arg : args) {
            if (i != 0) {
                argsString.append(',');
            }
            String argumentRef = arg.getValue().toString();
            if (!arg.isReference()) {
                String tempArgId = ARG_NAME_PREFIX + this.argCounter.getAndIncrement();
                this.bindings.put(tempArgId, arg.getValue());
                tempArgsIds.add(tempArgId);
                argumentRef = tempArgId;
            }
            argsString.append(argumentRef);
            ++i;
        }
        argsString.append(')');
        return argsString.toString();
    }
}

