/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Argument;
import py4j.Command;
import py4j.Gateway;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.ReturnObject;

public abstract class AbstractCommand
implements Command {
    protected Gateway gateway;
    private final Logger logger = Logger.getLogger(AbstractCommand.class.getName());

    @Override
    public abstract void execute(String var1, BufferedReader var2, BufferedWriter var3) throws Py4JException, IOException;

    @Override
    public void init(Gateway gateway) {
        this.gateway = gateway;
    }

    protected List<Argument> getArguments(BufferedReader reader) throws IOException {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        String line = reader.readLine();
        while (!Protocol.isEmpty(line) && !Protocol.isEnd(line)) {
            this.logger.info("Raw Argument: " + line);
            Argument argument = new Argument(Protocol.getObject(line), Protocol.isReference(line));
            arguments.add(argument);
            line = reader.readLine();
        }
        return arguments;
    }

    protected ReturnObject getReturnObject(String methodName, String targetObjectId, List<Argument> arguments) {
        ReturnObject returnObject = null;
        try {
            returnObject = this.gateway.invoke(methodName, targetObjectId, arguments);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Received exception while executing this command: " + methodName, e);
            returnObject = ReturnObject.getErrorReturnObject();
        }
        return returnObject;
    }
}

