/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.NetworkUtil;

public class GatewayServer
implements Runnable {
    public static final int DEFAULT_PORT = 25333;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    private final int port;
    private final Gateway gateway;
    private final boolean acceptOnlyOne;
    private final int connect_timeout;
    private final int read_timeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private Socket currentSocket;
    private ServerSocket sSocket;

    public GatewayServer(Gateway gateway, int port, int connectTimeout, int readTimeout, boolean acceptOnlyOne) {
        this.gateway = gateway;
        this.port = port;
        this.connect_timeout = connectTimeout;
        this.read_timeout = readTimeout;
        this.acceptOnlyOne = acceptOnlyOne;
    }

    public GatewayServer(Gateway gateway) {
        this(gateway, 25333, 0, 0, false);
    }

    public GatewayServer(Gateway gateway, int port) {
        this(gateway, port, 0, 0, false);
    }

    @Override
    public void run() {
        try {
            this.gateway.startup();
            this.sSocket = new ServerSocket(this.port);
            this.sSocket.setSoTimeout(this.connect_timeout);
            while (true) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while waiting for connection.", e);
            return;
        }
    }

    private void processSocket(Socket socket) {
        try {
            if (this.acceptOnlyOne && this.isConnected()) {
                socket.close();
            } else {
                socket.setSoTimeout(this.read_timeout);
                new GatewayConnection(this, this.gateway, socket);
                if (this.acceptOnlyOne) {
                    this.currentSocket = socket;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while processing a connection.", e);
        }
    }

    private boolean isConnected() {
        return this.currentSocket != null && this.currentSocket.isConnected();
    }

    public void start(boolean fork) {
        if (fork) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    public void start() {
        this.start(true);
    }

    public void stop() {
        NetworkUtil.quietlyClose(this.sSocket);
        this.gateway.shutdown();
    }

    public boolean isAcceptOnlyOne() {
        return this.acceptOnlyOne;
    }

    public int getConnect_timeout() {
        return this.connect_timeout;
    }

    public int getRead_timeout() {
        return this.read_timeout;
    }

    public static void turnLoggingOff() {
        Logger.getLogger("py4j").setLevel(Level.OFF);
    }

    public static void turnLoggingOn() {
        Logger.getLogger("py4j").setLevel(Level.ALL);
    }
}

