/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import py4j.Gateway;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.StringUtil;

public class Protocol {
    public static final char INTEGER_TYPE = 'i';
    public static final char BOOLEAN_TYPE = 'b';
    public static final char DOUBLE_TYPE = 'd';
    public static final char STRING_TYPE = 's';
    public static final char REFERENCE_TYPE = 'r';
    public static final char LIST_TYPE = 'l';
    public static final char MAP_TYPE = 'a';
    public static final char NULL_TYPE = 'n';
    public static final char PACKAGE_TYPE = 'p';
    public static final char CLASS_TYPE = 'c';
    public static final char METHOD_TYPE = 'm';
    public static final char NO_MEMBER = 'o';
    public static final char VOID = 'v';
    public static final char END = 'e';
    public static final char END_OUTPUT = '\n';
    public static final char ERROR = 'x';
    public static final char SUCCESS = 'y';
    public static final String ERROR_COMMAND = "x\n";
    public static final String VOID_COMMAND = "yv\n";
    public static final String NO_SUCH_FIELD = "yo\n";
    public static final String ENTRY_POINT_OBJECT_ID = "t";
    public static final String CONNECTION_PROPERTY_OBJECT_ID = "c";
    public static final String STATIC_PREFIX = "z:";

    public static final boolean isEmpty(String commandPart) {
        return commandPart == null || commandPart.trim().length() == 0;
    }

    public static final boolean isEnd(String commandPart) {
        return commandPart.length() == 1 && commandPart.charAt(0) == 'e';
    }

    public static final boolean isInteger(String commandPart) {
        return commandPart.charAt(0) == 'i';
    }

    public static final int getInteger(String commandPart) {
        return Integer.parseInt(commandPart.substring(1, commandPart.length()));
    }

    public static final boolean isBoolean(String commandPart) {
        return commandPart.charAt(0) == 'b';
    }

    public static final boolean getBoolean(String commandPart) {
        return Boolean.parseBoolean(commandPart.substring(1, commandPart.length()));
    }

    public static final boolean isDouble(String commandPart) {
        return commandPart.charAt(0) == 'd';
    }

    public static final double getDouble(String commandPart) {
        return Double.parseDouble(commandPart.substring(1, commandPart.length()));
    }

    public static final boolean isReference(String commandPart) {
        return commandPart.charAt(0) == 'r';
    }

    public static final String getReference(String commandPart) {
        String reference = commandPart.substring(1, commandPart.length());
        if (reference.trim().length() == 0) {
            throw new Py4JException("Reference is empty.");
        }
        return reference;
    }

    public static final boolean isString(String commandPart) {
        return commandPart.charAt(0) == 's';
    }

    public static final String getString(String commandPart) {
        String toReturn = "";
        if (commandPart.length() >= 2) {
            toReturn = StringUtil.unescape(commandPart.substring(1, commandPart.length()));
        }
        return toReturn;
    }

    public static final boolean isNull(String commandPart) {
        return commandPart.charAt(0) == 'n';
    }

    public static final Object getNull(String commandPart) {
        return null;
    }

    public static final Object getObject(String commandPart, Gateway gateway) {
        Object obj = Protocol.getObject(commandPart);
        if (Protocol.isReference(commandPart)) {
            obj = gateway.getObject((String)obj);
        }
        return obj;
    }

    public static final Object getObject(String commandPart) {
        if (Protocol.isEmpty(commandPart) || Protocol.isEnd(commandPart)) {
            throw new Py4JException("Command Part is Empty or is the End of Command Part");
        }
        if (Protocol.isReference(commandPart)) {
            return Protocol.getReference(commandPart);
        }
        if (Protocol.isInteger(commandPart)) {
            return Protocol.getInteger(commandPart);
        }
        if (Protocol.isBoolean(commandPart)) {
            return Protocol.getBoolean(commandPart);
        }
        if (Protocol.isDouble(commandPart)) {
            return Protocol.getDouble(commandPart);
        }
        if (Protocol.isString(commandPart)) {
            return Protocol.getString(commandPart);
        }
        if (Protocol.isNull(commandPart)) {
            return Protocol.getNull(commandPart);
        }
        throw new Py4JException("Command Part is unknown.");
    }

    public static final String getOutputErrorCommand() {
        return ERROR_COMMAND;
    }

    public static final String getOutputVoidCommand() {
        return VOID_COMMAND;
    }

    public static final String getMemberOutputCommand(char memberType) {
        StringBuilder builder = new StringBuilder();
        builder.append('y');
        builder.append(memberType);
        builder.append('\n');
        return builder.toString();
    }

    public static final String getOutputCommand(ReturnObject rObject) {
        StringBuilder builder = new StringBuilder();
        if (rObject.isError()) {
            builder.append('x');
        } else {
            builder.append('y');
            if (rObject.isNull()) {
                builder.append('n');
            } else if (rObject.isVoid()) {
                builder.append('v');
            } else if (rObject.isList()) {
                builder.append('l');
                builder.append(rObject.getName());
            } else if (rObject.isMap()) {
                builder.append('a');
                builder.append(rObject.getName());
            } else if (rObject.isReference()) {
                builder.append('r');
                builder.append(rObject.getName());
            } else {
                Object primitiveObject = rObject.getPrimitiveObject();
                char primitiveType = Protocol.getPrimitiveType(primitiveObject);
                builder.append(Protocol.getPrimitiveType(primitiveObject));
                if (primitiveType == 's') {
                    builder.append(StringUtil.escape(primitiveObject.toString()));
                } else {
                    builder.append(primitiveObject.toString());
                }
            }
        }
        builder.append('\n');
        return builder.toString();
    }

    private static char getPrimitiveType(Object primitiveObject) {
        int c = 105;
        if (primitiveObject instanceof String || primitiveObject instanceof Character) {
            c = 115;
        } else if (primitiveObject instanceof Double || primitiveObject instanceof Float) {
            c = 100;
        } else if (primitiveObject instanceof Boolean) {
            c = 98;
        }
        return (char)c;
    }

    public static String getNoSuchFieldOutputCommand() {
        return NO_SUCH_FIELD;
    }
}

