/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import py4j.CommunicationChannel;
import py4j.NetworkUtil;
import py4j.Py4JNetworkException;

public class DefaultCommunicationChannel
implements CommunicationChannel {
    private boolean used;
    private final int port;
    private final InetAddress address;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private final Logger logger = Logger.getLogger(DefaultCommunicationChannel.class.getName());

    public DefaultCommunicationChannel(int port, InetAddress address) {
        this.port = port;
        this.address = address;
    }

    @Override
    public void start() throws IOException {
        this.logger.info("Starting Communication Channel on " + this.address + " at " + this.port);
        this.socket = new Socket(this.address, this.port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), Charset.forName("UTF-8")));
    }

    @Override
    public String sendCommand(String command) {
        String returnCommand = null;
        try {
            this.writer.write(command);
            this.writer.flush();
            returnCommand = this.reader.readLine();
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Error while sending a command: " + command, e);
        }
        return returnCommand;
    }

    @Override
    public void setUsed(boolean used) {
        this.used = used;
    }

    @Override
    public void shutdown() {
        NetworkUtil.quietlyClose(this.reader);
        NetworkUtil.quietlyClose(this.writer);
        NetworkUtil.quietlyClose(this.socket);
    }

    @Override
    public boolean wasUsed() {
        return this.used;
    }
}

