/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

public class MethodDescriptor {
    private String internalRepresentation;
    private String name;
    private Class container;
    private Class[] parameters;
    private final char DOT = (char)46;

    public MethodDescriptor(String name, Class container, Class[] parameters) {
        this.name = name;
        this.container = container;
        this.parameters = parameters;
        this.internalRepresentation = this.buildInternalRepresentation(container, name, parameters);
    }

    private String buildInternalRepresentation(Class container, String name, Class[] params) {
        StringBuilder builder = new StringBuilder();
        builder.append(container.getName());
        builder.append('.');
        builder.append(name);
        builder.append('(');
        for (Class param : params) {
            String paramName = "null";
            if (param != null) {
                paramName = param.getName();
            }
            builder.append(paramName);
            builder.append('.');
        }
        builder.append(')');
        return builder.toString();
    }

    public String getInternalRepresentation() {
        return this.internalRepresentation;
    }

    public String getName() {
        return this.name;
    }

    public Class getContainer() {
        return this.container;
    }

    public Class[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodDescriptor)) {
            return false;
        }
        return this.internalRepresentation.equals(((MethodDescriptor)obj).internalRepresentation);
    }

    public int hashCode() {
        return this.internalRepresentation.hashCode();
    }

    public String toString() {
        return this.internalRepresentation;
    }
}

