/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import py4j.CallbackClient;
import py4j.JVMView;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.reflection.MethodInvoker;
import py4j.reflection.ReflectionEngine;

public class Gateway {
    private final Map<String, Object> bindings = new ConcurrentHashMap<String, Object>();
    private final AtomicInteger objCounter = new AtomicInteger();
    private final AtomicInteger argCounter = new AtomicInteger();
    private static final String OBJECT_NAME_PREFIX = "o";
    private final Object entryPoint;
    private final ReflectionEngine rEngine = new ReflectionEngine();
    private final CallbackClient cbClient;
    private final JVMView defaultJVMView;
    private final Logger logger = Logger.getLogger(Gateway.class.getName());
    private boolean isStarted = false;

    public Gateway(Object entryPoint) {
        this(entryPoint, null);
    }

    public Gateway(Object entryPoint, CallbackClient cbClient) {
        this.entryPoint = entryPoint;
        this.cbClient = cbClient;
        this.defaultJVMView = new JVMView("default", "j");
    }

    public void closeConnection() {
        this.logger.info("Cleaning Connection");
    }

    public void deleteObject(String objectId) {
        this.bindings.remove(objectId);
    }

    protected AtomicInteger getArgCounter() {
        return this.argCounter;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public CallbackClient getCallbackClient() {
        return this.cbClient;
    }

    public Object getEntryPoint() {
        return this.entryPoint;
    }

    public JVMView getDefaultJVMView() {
        return this.defaultJVMView;
    }

    protected String getNextObjectId() {
        return OBJECT_NAME_PREFIX + this.objCounter.getAndIncrement();
    }

    protected AtomicInteger getObjCounter() {
        return this.objCounter;
    }

    public Object getObject(String objectId) {
        return this.bindings.get(objectId);
    }

    protected Object getObjectFromId(String targetObjectId) {
        if (targetObjectId.startsWith("z:")) {
            return null;
        }
        return this.getObject(targetObjectId);
    }

    public ReflectionEngine getReflectionEngine() {
        return this.rEngine;
    }

    public ReturnObject getReturnObject(Object object) {
        ReturnObject returnObject;
        if (object != null) {
            if (this.isPrimitiveObject(object)) {
                returnObject = ReturnObject.getPrimitiveReturnObject(object);
            } else if (object == ReflectionEngine.RETURN_VOID) {
                returnObject = ReturnObject.getVoidReturnObject();
            } else if (this.isList(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getListReturnObject(objectId, ((List)object).size());
            } else if (this.isMap(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getMapReturnObject(objectId, ((Map)object).size());
            } else if (this.isArray(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getArrayReturnObject(objectId, Array.getLength(object));
            } else if (this.isSet(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getSetReturnObject(objectId, ((Set)object).size());
            } else if (this.isIterator(object)) {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getIteratorReturnObject(objectId);
            } else {
                String objectId = this.putNewObject(object);
                returnObject = ReturnObject.getReferenceReturnObject(objectId);
            }
        } else {
            returnObject = ReturnObject.getNullReturnObject();
        }
        return returnObject;
    }

    public ReturnObject invoke(String fqn, List<Object> args) {
        if (args == null) {
            args = new ArrayList<Object>();
        }
        ReturnObject returnObject = null;
        try {
            this.logger.info("Calling constructor: " + fqn);
            Object[] parameters = args.toArray();
            MethodInvoker method = this.rEngine.getConstructor(fqn, parameters);
            Object object = this.rEngine.invoke(null, method, parameters);
            returnObject = this.getReturnObject(object);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        return returnObject;
    }

    public ReturnObject invoke(String methodName, String targetObjectId, List<Object> args) {
        if (args == null) {
            args = new ArrayList<Object>();
        }
        ReturnObject returnObject = null;
        try {
            Object targetObject = this.getObjectFromId(targetObjectId);
            this.logger.info("Calling: " + methodName);
            Object[] parameters = args.toArray();
            MethodInvoker method = null;
            method = targetObject != null ? this.rEngine.getMethod(targetObject, methodName, parameters) : this.rEngine.getMethod(targetObjectId.substring("z:".length()), methodName, parameters);
            Object object = this.rEngine.invoke(targetObject, method, parameters);
            returnObject = this.getReturnObject(object);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        return returnObject;
    }

    protected boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    protected boolean isList(Object object) {
        return object instanceof List;
    }

    protected boolean isMap(Object object) {
        return object instanceof Map;
    }

    protected boolean isPrimitiveObject(Object object) {
        return object instanceof Boolean || object instanceof String || object instanceof Number || object instanceof Character;
    }

    protected boolean isSet(Object object) {
        return object instanceof Set;
    }

    private boolean isIterator(Object object) {
        return object instanceof Iterator;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public String putNewObject(Object object) {
        String id = this.getNextObjectId();
        this.bindings.put(id, object);
        return id;
    }

    public Object putObject(String id, Object object) {
        return this.bindings.put(id, object);
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public void shutdown() {
        this.isStarted = false;
        this.bindings.clear();
    }

    public void startup() {
        this.isStarted = true;
        if (this.entryPoint != null) {
            this.bindings.put("t", this.entryPoint);
        }
        this.bindings.put("j", this.defaultJVMView);
    }
}

