# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
# This file is compatible with both classic and new-style classes.

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pyBioLCCC', [dirname(__file__)])
        except ImportError:
            import _pyBioLCCC
            return _pyBioLCCC
        if fp is not None:
            try:
                _mod = imp.load_module('_pyBioLCCC', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _pyBioLCCC = swig_import_helper()
    del swig_import_helper
else:
    import _pyBioLCCC
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pyBioLCCC.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self):
        """value(self) -> PyObject"""
        return _pyBioLCCC.SwigPyIterator_value(self)

    def incr(self, n = 1):
        """
        incr(self, n = 1) -> SwigPyIterator
        incr(self) -> SwigPyIterator
        """
        return _pyBioLCCC.SwigPyIterator_incr(self, n)

    def decr(self, n = 1):
        """
        decr(self, n = 1) -> SwigPyIterator
        decr(self) -> SwigPyIterator
        """
        return _pyBioLCCC.SwigPyIterator_decr(self, n)

    def distance(self, *args):
        """distance(self, x) -> ptrdiff_t"""
        return _pyBioLCCC.SwigPyIterator_distance(self, *args)

    def equal(self, *args):
        """equal(self, x) -> bool"""
        return _pyBioLCCC.SwigPyIterator_equal(self, *args)

    def copy(self):
        """copy(self) -> SwigPyIterator"""
        return _pyBioLCCC.SwigPyIterator_copy(self)

    def next(self):
        """next(self) -> PyObject"""
        return _pyBioLCCC.SwigPyIterator_next(self)

    def __next__(self):
        """__next__(self) -> PyObject"""
        return _pyBioLCCC.SwigPyIterator___next__(self)

    def previous(self):
        """previous(self) -> PyObject"""
        return _pyBioLCCC.SwigPyIterator_previous(self)

    def advance(self, *args):
        """advance(self, n) -> SwigPyIterator"""
        return _pyBioLCCC.SwigPyIterator_advance(self, *args)

    def __eq__(self, *args):
        """__eq__(self, x) -> bool"""
        return _pyBioLCCC.SwigPyIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, x) -> bool"""
        return _pyBioLCCC.SwigPyIterator___ne__(self, *args)

    def __iadd__(self, *args):
        """__iadd__(self, n) -> SwigPyIterator"""
        return _pyBioLCCC.SwigPyIterator___iadd__(self, *args)

    def __isub__(self, *args):
        """__isub__(self, n) -> SwigPyIterator"""
        return _pyBioLCCC.SwigPyIterator___isub__(self, *args)

    def __add__(self, *args):
        """__add__(self, n) -> SwigPyIterator"""
        return _pyBioLCCC.SwigPyIterator___add__(self, *args)

    def __sub__(self, *args):
        """
        __sub__(self, n) -> SwigPyIterator
        __sub__(self, x) -> ptrdiff_t
        """
        return _pyBioLCCC.SwigPyIterator___sub__(self, *args)

    def __iter__(self): return self
SwigPyIterator_swigregister = _pyBioLCCC.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class GradientPointVector(_object):
    """Proxy of C++ std::vector<(BioLCCC::GradientPoint)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GradientPointVector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GradientPointVector, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.GradientPointVector_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _pyBioLCCC.GradientPointVector___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _pyBioLCCC.GradientPointVector___bool__(self)

    def __len__(self):
        """__len__(self) -> size_type"""
        return _pyBioLCCC.GradientPointVector___len__(self)

    def pop(self):
        """pop(self) -> value_type"""
        return _pyBioLCCC.GradientPointVector_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> GradientPointVector"""
        return _pyBioLCCC.GradientPointVector___getslice__(self, *args)

    def __setslice__(self, *args):
        """__setslice__(self, i, j, v)"""
        return _pyBioLCCC.GradientPointVector___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _pyBioLCCC.GradientPointVector___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _pyBioLCCC.GradientPointVector___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> GradientPointVector
        __getitem__(self, i) -> value_type
        """
        return _pyBioLCCC.GradientPointVector___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, i, x)
        """
        return _pyBioLCCC.GradientPointVector___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _pyBioLCCC.GradientPointVector_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _pyBioLCCC.GradientPointVector_empty(self)

    def size(self):
        """size(self) -> size_type"""
        return _pyBioLCCC.GradientPointVector_size(self)

    def clear(self):
        """clear(self)"""
        return _pyBioLCCC.GradientPointVector_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _pyBioLCCC.GradientPointVector_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> allocator_type"""
        return _pyBioLCCC.GradientPointVector_get_allocator(self)

    def begin(self):
        """begin(self) -> const_iterator"""
        return _pyBioLCCC.GradientPointVector_begin(self)

    def end(self):
        """end(self) -> const_iterator"""
        return _pyBioLCCC.GradientPointVector_end(self)

    def rbegin(self):
        """rbegin(self) -> const_reverse_iterator"""
        return _pyBioLCCC.GradientPointVector_rbegin(self)

    def rend(self):
        """rend(self) -> const_reverse_iterator"""
        return _pyBioLCCC.GradientPointVector_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _pyBioLCCC.GradientPointVector_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> iterator
        erase(self, first, last) -> iterator
        """
        return _pyBioLCCC.GradientPointVector_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> GradientPointVector
        __init__(self, arg0) -> GradientPointVector
        __init__(self, size) -> GradientPointVector
        __init__(self, size, value) -> GradientPointVector
        """
        this = _pyBioLCCC.new_GradientPointVector(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _pyBioLCCC.GradientPointVector_push_back(self, *args)

    def front(self):
        """front(self) -> value_type"""
        return _pyBioLCCC.GradientPointVector_front(self)

    def back(self):
        """back(self) -> value_type"""
        return _pyBioLCCC.GradientPointVector_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _pyBioLCCC.GradientPointVector_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _pyBioLCCC.GradientPointVector_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> iterator
        insert(self, pos, n, x)
        """
        return _pyBioLCCC.GradientPointVector_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _pyBioLCCC.GradientPointVector_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> size_type"""
        return _pyBioLCCC.GradientPointVector_capacity(self)

    __swig_destroy__ = _pyBioLCCC.delete_GradientPointVector
    __del__ = lambda self : None;
GradientPointVector_swigregister = _pyBioLCCC.GradientPointVector_swigregister
GradientPointVector_swigregister(GradientPointVector)

class StringAminoacidMap(_object):
    """Proxy of C++ std::map<(std::string,BioLCCC::Aminoacid)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringAminoacidMap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringAminoacidMap, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringAminoacidMap_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _pyBioLCCC.StringAminoacidMap___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _pyBioLCCC.StringAminoacidMap___bool__(self)

    def __len__(self):
        """__len__(self) -> size_type"""
        return _pyBioLCCC.StringAminoacidMap___len__(self)

    def __getitem__(self, *args):
        """__getitem__(self, key) -> mapped_type"""
        return _pyBioLCCC.StringAminoacidMap___getitem__(self, *args)

    def __delitem__(self, *args):
        """__delitem__(self, key)"""
        return _pyBioLCCC.StringAminoacidMap___delitem__(self, *args)

    def has_key(self, *args):
        """has_key(self, key) -> bool"""
        return _pyBioLCCC.StringAminoacidMap_has_key(self, *args)

    def keys(self):
        """keys(self) -> PyObject"""
        return _pyBioLCCC.StringAminoacidMap_keys(self)

    def values(self):
        """values(self) -> PyObject"""
        return _pyBioLCCC.StringAminoacidMap_values(self)

    def items(self):
        """items(self) -> PyObject"""
        return _pyBioLCCC.StringAminoacidMap_items(self)

    def __contains__(self, *args):
        """__contains__(self, key) -> bool"""
        return _pyBioLCCC.StringAminoacidMap___contains__(self, *args)

    def key_iterator(self):
        """key_iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringAminoacidMap_key_iterator(self)

    def value_iterator(self):
        """value_iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringAminoacidMap_value_iterator(self)

    def __iter__(self): return self.key_iterator()
    def iterkeys(self): return self.key_iterator()
    def itervalues(self): return self.value_iterator()
    def iteritems(self): return self.iterator()
    def __setitem__(self, *args):
        """__setitem__(self, key, x)"""
        return _pyBioLCCC.StringAminoacidMap___setitem__(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, arg0) -> StringAminoacidMap
        __init__(self) -> StringAminoacidMap
        __init__(self, arg0) -> StringAminoacidMap
        """
        this = _pyBioLCCC.new_StringAminoacidMap(*args)
        try: self.this.append(this)
        except: self.this = this
    def empty(self):
        """empty(self) -> bool"""
        return _pyBioLCCC.StringAminoacidMap_empty(self)

    def size(self):
        """size(self) -> size_type"""
        return _pyBioLCCC.StringAminoacidMap_size(self)

    def clear(self):
        """clear(self)"""
        return _pyBioLCCC.StringAminoacidMap_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _pyBioLCCC.StringAminoacidMap_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> allocator_type"""
        return _pyBioLCCC.StringAminoacidMap_get_allocator(self)

    def begin(self):
        """begin(self) -> const_iterator"""
        return _pyBioLCCC.StringAminoacidMap_begin(self)

    def end(self):
        """end(self) -> const_iterator"""
        return _pyBioLCCC.StringAminoacidMap_end(self)

    def rbegin(self):
        """rbegin(self) -> const_reverse_iterator"""
        return _pyBioLCCC.StringAminoacidMap_rbegin(self)

    def rend(self):
        """rend(self) -> const_reverse_iterator"""
        return _pyBioLCCC.StringAminoacidMap_rend(self)

    def count(self, *args):
        """count(self, x) -> size_type"""
        return _pyBioLCCC.StringAminoacidMap_count(self, *args)

    def erase(self, *args):
        """
        erase(self, x) -> size_type
        erase(self, position)
        erase(self, first, last)
        """
        return _pyBioLCCC.StringAminoacidMap_erase(self, *args)

    def find(self, *args):
        """find(self, x) -> iterator"""
        return _pyBioLCCC.StringAminoacidMap_find(self, *args)

    def lower_bound(self, *args):
        """lower_bound(self, x) -> iterator"""
        return _pyBioLCCC.StringAminoacidMap_lower_bound(self, *args)

    def upper_bound(self, *args):
        """upper_bound(self, x) -> iterator"""
        return _pyBioLCCC.StringAminoacidMap_upper_bound(self, *args)

    __swig_destroy__ = _pyBioLCCC.delete_StringAminoacidMap
    __del__ = lambda self : None;
StringAminoacidMap_swigregister = _pyBioLCCC.StringAminoacidMap_swigregister
StringAminoacidMap_swigregister(StringAminoacidMap)

class StringTerminusMap(_object):
    """Proxy of C++ std::map<(std::string,BioLCCC::Terminus)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringTerminusMap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringTerminusMap, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringTerminusMap_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _pyBioLCCC.StringTerminusMap___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _pyBioLCCC.StringTerminusMap___bool__(self)

    def __len__(self):
        """__len__(self) -> size_type"""
        return _pyBioLCCC.StringTerminusMap___len__(self)

    def __getitem__(self, *args):
        """__getitem__(self, key) -> mapped_type"""
        return _pyBioLCCC.StringTerminusMap___getitem__(self, *args)

    def __delitem__(self, *args):
        """__delitem__(self, key)"""
        return _pyBioLCCC.StringTerminusMap___delitem__(self, *args)

    def has_key(self, *args):
        """has_key(self, key) -> bool"""
        return _pyBioLCCC.StringTerminusMap_has_key(self, *args)

    def keys(self):
        """keys(self) -> PyObject"""
        return _pyBioLCCC.StringTerminusMap_keys(self)

    def values(self):
        """values(self) -> PyObject"""
        return _pyBioLCCC.StringTerminusMap_values(self)

    def items(self):
        """items(self) -> PyObject"""
        return _pyBioLCCC.StringTerminusMap_items(self)

    def __contains__(self, *args):
        """__contains__(self, key) -> bool"""
        return _pyBioLCCC.StringTerminusMap___contains__(self, *args)

    def key_iterator(self):
        """key_iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringTerminusMap_key_iterator(self)

    def value_iterator(self):
        """value_iterator(self) -> SwigPyIterator"""
        return _pyBioLCCC.StringTerminusMap_value_iterator(self)

    def __iter__(self): return self.key_iterator()
    def iterkeys(self): return self.key_iterator()
    def itervalues(self): return self.value_iterator()
    def iteritems(self): return self.iterator()
    def __setitem__(self, *args):
        """__setitem__(self, key, x)"""
        return _pyBioLCCC.StringTerminusMap___setitem__(self, *args)

    def __init__(self, *args): 
        """
        __init__(self, arg0) -> StringTerminusMap
        __init__(self) -> StringTerminusMap
        __init__(self, arg0) -> StringTerminusMap
        """
        this = _pyBioLCCC.new_StringTerminusMap(*args)
        try: self.this.append(this)
        except: self.this = this
    def empty(self):
        """empty(self) -> bool"""
        return _pyBioLCCC.StringTerminusMap_empty(self)

    def size(self):
        """size(self) -> size_type"""
        return _pyBioLCCC.StringTerminusMap_size(self)

    def clear(self):
        """clear(self)"""
        return _pyBioLCCC.StringTerminusMap_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _pyBioLCCC.StringTerminusMap_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> allocator_type"""
        return _pyBioLCCC.StringTerminusMap_get_allocator(self)

    def begin(self):
        """begin(self) -> const_iterator"""
        return _pyBioLCCC.StringTerminusMap_begin(self)

    def end(self):
        """end(self) -> const_iterator"""
        return _pyBioLCCC.StringTerminusMap_end(self)

    def rbegin(self):
        """rbegin(self) -> const_reverse_iterator"""
        return _pyBioLCCC.StringTerminusMap_rbegin(self)

    def rend(self):
        """rend(self) -> const_reverse_iterator"""
        return _pyBioLCCC.StringTerminusMap_rend(self)

    def count(self, *args):
        """count(self, x) -> size_type"""
        return _pyBioLCCC.StringTerminusMap_count(self, *args)

    def erase(self, *args):
        """
        erase(self, x) -> size_type
        erase(self, position)
        erase(self, first, last)
        """
        return _pyBioLCCC.StringTerminusMap_erase(self, *args)

    def find(self, *args):
        """find(self, x) -> iterator"""
        return _pyBioLCCC.StringTerminusMap_find(self, *args)

    def lower_bound(self, *args):
        """lower_bound(self, x) -> iterator"""
        return _pyBioLCCC.StringTerminusMap_lower_bound(self, *args)

    def upper_bound(self, *args):
        """upper_bound(self, x) -> iterator"""
        return _pyBioLCCC.StringTerminusMap_upper_bound(self, *args)

    __swig_destroy__ = _pyBioLCCC.delete_StringTerminusMap
    __del__ = lambda self : None;
StringTerminusMap_swigregister = _pyBioLCCC.StringTerminusMap_swigregister
StringTerminusMap_swigregister(StringTerminusMap)

class Aminoacid(_object):
    """Proxy of C++ BioLCCC::Aminoacid class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Aminoacid, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Aminoacid, name)
    __repr__ = _swig_repr
    def __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0, 
    monoisotopicMass = 0.0): 
        """
        __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0, 
            monoisotopicMass = 0.0) -> Aminoacid
        __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0) -> Aminoacid
        __init__(self, name = "", label = "", bindEnergy = 0.0) -> Aminoacid
        __init__(self, name = "", label = "") -> Aminoacid
        __init__(self, name = "") -> Aminoacid
        __init__(self) -> Aminoacid
        """
        this = _pyBioLCCC.new_Aminoacid(name, label, bindEnergy, averageMass, monoisotopicMass)
        try: self.this.append(this)
        except: self.this = this
    def name(self):
        """name(self) -> string"""
        return _pyBioLCCC.Aminoacid_name(self)

    def label(self):
        """label(self) -> string"""
        return _pyBioLCCC.Aminoacid_label(self)

    def averageMass(self):
        """averageMass(self) -> double"""
        return _pyBioLCCC.Aminoacid_averageMass(self)

    def monoisotopicMass(self):
        """monoisotopicMass(self) -> double"""
        return _pyBioLCCC.Aminoacid_monoisotopicMass(self)

    def bindEnergy(self):
        """bindEnergy(self) -> double"""
        return _pyBioLCCC.Aminoacid_bindEnergy(self)

    def setBindEnergy(self, *args):
        """setBindEnergy(self, newBindEnergy)"""
        return _pyBioLCCC.Aminoacid_setBindEnergy(self, *args)

    def __getstate__(self):
        output_dict = {}
        output_dict['name'] = self.name()
        output_dict['label'] = self.label()
        output_dict['bindEnergy'] = self.bindEnergy()
        output_dict['averageMass'] = self.averageMass()
        output_dict['monoisotopicMass'] = self.monoisotopicMass()
        return output_dict

    __swig_destroy__ = _pyBioLCCC.delete_Aminoacid
    __del__ = lambda self : None;
Aminoacid_swigregister = _pyBioLCCC.Aminoacid_swigregister
Aminoacid_swigregister(Aminoacid)

class Terminus(_object):
    """Proxy of C++ BioLCCC::Terminus class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Terminus, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Terminus, name)
    __repr__ = _swig_repr
    def __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0, 
    monoisotopicMass = 0.0): 
        """
        __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0, 
            monoisotopicMass = 0.0) -> Terminus
        __init__(self, name = "", label = "", bindEnergy = 0.0, averageMass = 0.0) -> Terminus
        __init__(self, name = "", label = "", bindEnergy = 0.0) -> Terminus
        __init__(self, name = "", label = "") -> Terminus
        __init__(self, name = "") -> Terminus
        __init__(self) -> Terminus
        """
        this = _pyBioLCCC.new_Terminus(name, label, bindEnergy, averageMass, monoisotopicMass)
        try: self.this.append(this)
        except: self.this = this
    def name(self):
        """name(self) -> string"""
        return _pyBioLCCC.Terminus_name(self)

    def label(self):
        """label(self) -> string"""
        return _pyBioLCCC.Terminus_label(self)

    def averageMass(self):
        """averageMass(self) -> double"""
        return _pyBioLCCC.Terminus_averageMass(self)

    def monoisotopicMass(self):
        """monoisotopicMass(self) -> double"""
        return _pyBioLCCC.Terminus_monoisotopicMass(self)

    def bindEnergy(self):
        """bindEnergy(self) -> double"""
        return _pyBioLCCC.Terminus_bindEnergy(self)

    def setBindEnergy(self, *args):
        """setBindEnergy(self, newBindEnergy)"""
        return _pyBioLCCC.Terminus_setBindEnergy(self, *args)

    def __getstate__(self):
        output_dict = {}
        output_dict['name'] = self.name()
        output_dict['label'] = self.label()
        output_dict['bindEnergy'] = self.bindEnergy()
        output_dict['averageMass'] = self.averageMass()
        output_dict['monoisotopicMass'] = self.monoisotopicMass()
        return output_dict

    __swig_destroy__ = _pyBioLCCC.delete_Terminus
    __del__ = lambda self : None;
Terminus_swigregister = _pyBioLCCC.Terminus_swigregister
Terminus_swigregister(Terminus)

class ChemicalBasis(_object):
    """Proxy of C++ BioLCCC::ChemicalBasis class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChemicalBasis, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ChemicalBasis, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> ChemicalBasis"""
        this = _pyBioLCCC.new_ChemicalBasis()
        try: self.this.append(this)
        except: self.this = this
    def aminoacids(self):
        """aminoacids(self) -> StringAminoacidMap"""
        return _pyBioLCCC.ChemicalBasis_aminoacids(self)

    def NTermini(self):
        """NTermini(self) -> StringTerminusMap"""
        return _pyBioLCCC.ChemicalBasis_NTermini(self)

    def CTermini(self):
        """CTermini(self) -> StringTerminusMap"""
        return _pyBioLCCC.ChemicalBasis_CTermini(self)

    def defaultNTerminus(self):
        """defaultNTerminus(self) -> Terminus"""
        return _pyBioLCCC.ChemicalBasis_defaultNTerminus(self)

    def defaultCTerminus(self):
        """defaultCTerminus(self) -> Terminus"""
        return _pyBioLCCC.ChemicalBasis_defaultCTerminus(self)

    def secondSolventBindEnergy(self):
        """secondSolventBindEnergy(self) -> double"""
        return _pyBioLCCC.ChemicalBasis_secondSolventBindEnergy(self)

    def setSecondSolventBindEnergy(self, *args):
        """setSecondSolventBindEnergy(self, newEnergy)"""
        return _pyBioLCCC.ChemicalBasis_setSecondSolventBindEnergy(self, *args)

    def segmentLength(self):
        """segmentLength(self) -> double"""
        return _pyBioLCCC.ChemicalBasis_segmentLength(self)

    def setSegmentLength(self, *args):
        """setSegmentLength(self, newSegmentLength) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setSegmentLength(self, *args)

    def setPersistentLength(self, *args):
        """setPersistentLength(self, newPersistentLength) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setPersistentLength(self, *args)

    def persistentLength(self):
        """persistentLength(self) -> int"""
        return _pyBioLCCC.ChemicalBasis_persistentLength(self)

    def adsorbtionLayerWidth(self):
        """adsorbtionLayerWidth(self) -> double"""
        return _pyBioLCCC.ChemicalBasis_adsorbtionLayerWidth(self)

    def setAdsorbtionLayerWidth(self, *args):
        """setAdsorbtionLayerWidth(self, newAdsorbtionLayerWidth) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setAdsorbtionLayerWidth(self, *args)

    def addAminoacid(self, *args):
        """addAminoacid(self, newAminoacid)"""
        return _pyBioLCCC.ChemicalBasis_addAminoacid(self, *args)

    def addNTerminus(self, *args):
        """addNTerminus(self, newNTerminus)"""
        return _pyBioLCCC.ChemicalBasis_addNTerminus(self, *args)

    def addCTerminus(self, *args):
        """addCTerminus(self, newCTerminus)"""
        return _pyBioLCCC.ChemicalBasis_addCTerminus(self, *args)

    def removeAminoacid(self, *args):
        """removeAminoacid(self, label) -> bool"""
        return _pyBioLCCC.ChemicalBasis_removeAminoacid(self, *args)

    def removeNTerminus(self, *args):
        """removeNTerminus(self, label) -> bool"""
        return _pyBioLCCC.ChemicalBasis_removeNTerminus(self, *args)

    def removeCTerminus(self, *args):
        """removeCTerminus(self, label) -> bool"""
        return _pyBioLCCC.ChemicalBasis_removeCTerminus(self, *args)

    def clearAminoacids(self):
        """clearAminoacids(self)"""
        return _pyBioLCCC.ChemicalBasis_clearAminoacids(self)

    def clearNTermini(self):
        """clearNTermini(self)"""
        return _pyBioLCCC.ChemicalBasis_clearNTermini(self)

    def clearCTermini(self):
        """clearCTermini(self)"""
        return _pyBioLCCC.ChemicalBasis_clearCTermini(self)

    def setAminoacidBindEnergy(self, *args):
        """setAminoacidBindEnergy(self, label, newBindEnergy) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setAminoacidBindEnergy(self, *args)

    def setNTerminusBindEnergy(self, *args):
        """setNTerminusBindEnergy(self, label, newBindEnergy) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setNTerminusBindEnergy(self, *args)

    def setCTerminusBindEnergy(self, *args):
        """setCTerminusBindEnergy(self, label, newBindEnergy) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setCTerminusBindEnergy(self, *args)

    def setModel(self, *args):
        """setModel(self, newModel) -> bool"""
        return _pyBioLCCC.ChemicalBasis_setModel(self, *args)

    def model(self):
        """model(self) -> string"""
        return _pyBioLCCC.ChemicalBasis_model(self)

    def __str__(self):
        return str(self.min_inf()).replace(',', ',\n')

    def __getstate__(self):
        output_dict = {}
        output_dict['model'] = self.model()
        output_dict['segmentLength'] = self.segmentLength()
        output_dict['persistentLength'] = self.persistentLength()
        output_dict['adsorbtionLayerWidth'] = self.adsorbtionLayerWidth()
        output_dict['secondSolventBindEnergy'] = \
            self.secondSolventBindEnergy()

        output_dict['aminoacids'] = {}
        for label, aminoacid in self.aminoacids().items():
            output_dict['aminoacids'][label] = aminoacid.__getstate__()

        output_dict['CTermini'] = {}
        for label, CTerminus in self.CTermini().items():
            output_dict['CTermini'][label] = CTerminus.__getstate__()

        output_dict['NTermini'] = {}
        for label, NTerminus in self.NTermini().items():
            output_dict['NTermini'][label] = NTerminus.__getstate__()
        return output_dict

    def __setstate__(self, chembasis_dict):
        self.setModel(chembasis_dict['model'])
        self.setSegmentLength(chembasis_dict['segmentLength'])
        self.setPersistentLength(chembasis_dict['persistentLength'])
        self.setAdsorbtionLayerWidth(chembasis_dict['adsorbtionLayerWidth'])
        self.setSecondSolventBindEnergy(
            chembasis_dict['secondSolventBindEnergy'])
        self.clearAminoacids()
        for aminoacid_dict in chembasis_dict['aminoacids'].values():
            aminoacid = Aminoacid(aminoacid_dict['name'],
                                  aminoacid_dict['label'],
                                  aminoacid_dict['bindEnergy'],
                                  aminoacid_dict['averageMass'],
                                  aminoacid_dict['monoisotopicMass'])
            self.addAminoacid(aminoacid)
        self.clearCTermini()
        for CTerminus_dict in chembasis_dict['CTermini'].values():
            CTerminus = Terminus(CTerminus_dict['name'],
                                 CTerminus_dict['label'],
                                 CTerminus_dict['bindEnergy'],
                                 CTerminus_dict['averageMass'],
                                 CTerminus_dict['monoisotopicMass'])
            self.addCTerminus(CTerminus)
        self.clearNTermini()
        for NTerminus_dict in chembasis_dict['NTermini'].values():
            NTerminus = Terminus(NTerminus_dict['name'],
                                 NTerminus_dict['label'],
                                 NTerminus_dict['bindEnergy'],
                                 NTerminus_dict['averageMass'],
                                 NTerminus_dict['monoisotopicMass'])
            self.addNTerminus(NTerminus)

    def min_inf(self):
        output_dict = {}
        output_dict['model'] = self.model()
        output_dict['segmentLength'] = self.segmentLength()
        output_dict['persistentLength'] = self.persistentLength()
        output_dict['adsorbtionLayerWidth'] = self.adsorbtionLayerWidth()
        output_dict['secondSolventBindEnergy'] = \
            self.secondSolventBindEnergy()

        for label, aminoacid in self.aminoacids().items():
            output_dict[label] = aminoacid.bindEnergy()

        for label, CTerminus in self.CTermini().items():
            output_dict[label] = CTerminus.bindEnergy()

        for label, NTerminus in self.NTermini().items():
            output_dict[label] = NTerminus.bindEnergy()
        return output_dict

    def set_min_inf_element(self, key, value):
        if key == 'model':
            self.setModel(value)
        elif key == 'segmentLength':
            self.setSegmentLength(value)
        elif key == 'persistentLength':
            self.setPersistentLength(value)
        elif key == 'adsorbtionLayerWidth':
            self.setAdsorbtionLayerWidth(value)
        elif key == 'secondSolventBindEnergy':
            self.setSecondSolventBindEnergy(value)
        else:
            if key.endswith('-'):
                if key in self.NTermini():
                    self.setNTerminusBindEnergy(key, value) 
                else:
                    self.addNTerminus(Terminus("",
                                               key, 
                                               value))
            elif key.startswith('-'):
                if key in self.CTermini():
                    self.setCTerminusBindEnergy(key, value) 
                else:
                    self.addCTerminus(Terminus("",
                                               key, 
                                               value))
            else:
                if key in self.aminoacids():
                    self.setAminoacidBindEnergy(key, value) 
                else:
                    self.addAminoacid(Aminoacid("",
                                                key, 
                                                value))

    def set_min_inf(self, min_inf_dict):
        for key, value in min_inf_dict.items():
            self.set_min_inf_element(key, value)

    __swig_destroy__ = _pyBioLCCC.delete_ChemicalBasis
    __del__ = lambda self : None;
ChemicalBasis_swigregister = _pyBioLCCC.ChemicalBasis_swigregister
ChemicalBasis_swigregister(ChemicalBasis)

class GradientPoint(_object):
    """Proxy of C++ BioLCCC::GradientPoint class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GradientPoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GradientPoint, name)
    __repr__ = _swig_repr
    def __init__(self, iTime = 0.0, iConcentrationB = 0.0): 
        """
        __init__(self, iTime = 0.0, iConcentrationB = 0.0) -> GradientPoint
        __init__(self, iTime = 0.0) -> GradientPoint
        __init__(self) -> GradientPoint
        """
        this = _pyBioLCCC.new_GradientPoint(iTime, iConcentrationB)
        try: self.this.append(this)
        except: self.this = this
    def time(self):
        """time(self) -> double"""
        return _pyBioLCCC.GradientPoint_time(self)

    def concentrationB(self):
        """concentrationB(self) -> double"""
        return _pyBioLCCC.GradientPoint_concentrationB(self)

    def __str__(self):
        return '(%f,%f)' % (self.time(), self.concentrationB())

    __swig_destroy__ = _pyBioLCCC.delete_GradientPoint
    __del__ = lambda self : None;
GradientPoint_swigregister = _pyBioLCCC.GradientPoint_swigregister
GradientPoint_swigregister(GradientPoint)

class Gradient(GradientPointVector):
    """Proxy of C++ BioLCCC::Gradient class"""
    __swig_setmethods__ = {}
    for _s in [GradientPointVector]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Gradient, name, value)
    __swig_getmethods__ = {}
    for _s in [GradientPointVector]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Gradient, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> Gradient
        __init__(self, initialConcentrationB, finalConcentrationB, time) -> Gradient
        """
        this = _pyBioLCCC.new_Gradient(*args)
        try: self.this.append(this)
        except: self.this = this
    def addPoint(self, *args):
        """
        addPoint(self, iPoint) -> Gradient
        addPoint(self, iTime, iConcentrationB) -> Gradient
        """
        return _pyBioLCCC.Gradient_addPoint(self, *args)

    __swig_destroy__ = _pyBioLCCC.delete_Gradient
    __del__ = lambda self : None;
Gradient_swigregister = _pyBioLCCC.Gradient_swigregister
Gradient_swigregister(Gradient)

class ChromoConditions(_object):
    """Proxy of C++ BioLCCC::ChromoConditions class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChromoConditions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ChromoConditions, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003, 
            iDV = 0.0, iCalibrationParameter = 1.0, iColumnVpToVtot = 0.5, 
            iColumnPorosity = 0.9, iTemperature = 293.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003, 
            iDV = 0.0, iCalibrationParameter = 1.0, iColumnVpToVtot = 0.5, 
            iColumnPorosity = 0.9) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003, 
            iDV = 0.0, iCalibrationParameter = 1.0, iColumnVpToVtot = 0.5) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003, 
            iDV = 0.0, iCalibrationParameter = 1.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003, 
            iDV = 0.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0, iFlowRate = 0.0003) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0, 
            iDelayTime = 0.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0, 
            iSecondSolventConcentrationB = 80.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0), 
            iSecondSolventConcentrationA = 2.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0, 
            iGradient = BioLCCC::Gradient(0.0, 50.0, 60.0)) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075, iColumnPoreSize = 100.0) -> ChromoConditions
        __init__(self, iColumnLength = 150.0, iColumnDiameter = 0.075) -> ChromoConditions
        __init__(self, iColumnLength = 150.0) -> ChromoConditions
        __init__(self) -> ChromoConditions
        """
        this = _pyBioLCCC.new_ChromoConditions(*args)
        try: self.this.append(this)
        except: self.this = this
    def columnLength(self):
        """columnLength(self) -> double"""
        return _pyBioLCCC.ChromoConditions_columnLength(self)

    def setColumnLength(self, *args):
        """setColumnLength(self, newColumnLength)"""
        return _pyBioLCCC.ChromoConditions_setColumnLength(self, *args)

    def columnDiameter(self):
        """columnDiameter(self) -> double"""
        return _pyBioLCCC.ChromoConditions_columnDiameter(self)

    def setColumnDiameter(self, *args):
        """setColumnDiameter(self, newColumnDiameter)"""
        return _pyBioLCCC.ChromoConditions_setColumnDiameter(self, *args)

    def columnPoreSize(self):
        """columnPoreSize(self) -> double"""
        return _pyBioLCCC.ChromoConditions_columnPoreSize(self)

    def setColumnPoreSize(self, *args):
        """setColumnPoreSize(self, newColumnPoreSize)"""
        return _pyBioLCCC.ChromoConditions_setColumnPoreSize(self, *args)

    def columnVpToVtot(self):
        """columnVpToVtot(self) -> double"""
        return _pyBioLCCC.ChromoConditions_columnVpToVtot(self)

    def setColumnVpToVtot(self, *args):
        """setColumnVpToVtot(self, newColumnVpToVtot)"""
        return _pyBioLCCC.ChromoConditions_setColumnVpToVtot(self, *args)

    def columnPorosity(self):
        """columnPorosity(self) -> double"""
        return _pyBioLCCC.ChromoConditions_columnPorosity(self)

    def setColumnPorosity(self, *args):
        """setColumnPorosity(self, newColumnPorosity)"""
        return _pyBioLCCC.ChromoConditions_setColumnPorosity(self, *args)

    def temperature(self):
        """temperature(self) -> double"""
        return _pyBioLCCC.ChromoConditions_temperature(self)

    def setTemperature(self, *args):
        """setTemperature(self, newTemperature)"""
        return _pyBioLCCC.ChromoConditions_setTemperature(self, *args)

    def calibrationParameter(self):
        """calibrationParameter(self) -> double"""
        return _pyBioLCCC.ChromoConditions_calibrationParameter(self)

    def setCalibrationParameter(self, *args):
        """setCalibrationParameter(self, newCalibrationParameter)"""
        return _pyBioLCCC.ChromoConditions_setCalibrationParameter(self, *args)

    def flowRate(self):
        """flowRate(self) -> double"""
        return _pyBioLCCC.ChromoConditions_flowRate(self)

    def setFlowRate(self, *args):
        """setFlowRate(self, newFlowRate)"""
        return _pyBioLCCC.ChromoConditions_setFlowRate(self, *args)

    def dV(self):
        """dV(self) -> double"""
        return _pyBioLCCC.ChromoConditions_dV(self)

    def setDV(self, *args):
        """setDV(self, newDV)"""
        return _pyBioLCCC.ChromoConditions_setDV(self, *args)

    def delayTime(self):
        """delayTime(self) -> double"""
        return _pyBioLCCC.ChromoConditions_delayTime(self)

    def setDelayTime(self, *args):
        """setDelayTime(self, newDelayTime)"""
        return _pyBioLCCC.ChromoConditions_setDelayTime(self, *args)

    def secondSolvent(self):
        """secondSolvent(self) -> string"""
        return _pyBioLCCC.ChromoConditions_secondSolvent(self)

    def secondSolventConcentrationA(self):
        """secondSolventConcentrationA(self) -> double"""
        return _pyBioLCCC.ChromoConditions_secondSolventConcentrationA(self)

    def setSecondSolventConcentrationA(self, *args):
        """setSecondSolventConcentrationA(self, newSecondSolventConcentrationA)"""
        return _pyBioLCCC.ChromoConditions_setSecondSolventConcentrationA(self, *args)

    def secondSolventConcentrationB(self):
        """secondSolventConcentrationB(self) -> double"""
        return _pyBioLCCC.ChromoConditions_secondSolventConcentrationB(self)

    def setSecondSolventConcentrationB(self, *args):
        """setSecondSolventConcentrationB(self, newSecondSolventConcentrationB)"""
        return _pyBioLCCC.ChromoConditions_setSecondSolventConcentrationB(self, *args)

    def gradient(self):
        """gradient(self) -> Gradient"""
        return _pyBioLCCC.ChromoConditions_gradient(self)

    def setGradient(self, *args):
        """setGradient(self, newGradient)"""
        return _pyBioLCCC.ChromoConditions_setGradient(self, *args)

    def __str__(self):
        return str(self.__getstate__())

    def __getstate__(self):
        output_dict = {}
        output_dict['columnLength'] = self.columnLength()
        output_dict['columnDiameter'] = self.columnDiameter()
        output_dict['columnPoreSize'] = self.columnPoreSize()
        output_dict['gradient'] = [eval(str(i)) for i in self.gradient()]
        output_dict['secondSolventConcentrationA'] = \
            self.secondSolventConcentrationA()
        output_dict['secondSolventConcentrationB'] = \
            self.secondSolventConcentrationB()
        output_dict['delayTime'] = self.delayTime()
        output_dict['flowRate'] = self.flowRate()
        output_dict['dV'] = self.dV()
        output_dict['calibrationParameter'] = self.calibrationParameter()
        output_dict['columnVpToVtot'] = self.columnVpToVtot()
        output_dict['columnPorosity'] = self.columnPorosity()
        output_dict['temperature'] = self.temperature()
        return output_dict

    def __setstate__(self, input_dict):
        self.setColumnLength(input_dict['columnLength'])
        self.setColumnDiameter(input_dict['columnDiameter'])
        self.setColumnPoreSize(input_dict['columnPoreSize'])

        input_gradient = self.gradient();
        input_gradient.clear();
        for (time, concentrationB) in input_dict['gradient']:
            input_gradient.addPoint(time, concentrationB)
        self.setGradient(input_gradient)
        self.setSecondSolventConcentrationA(
            input_dict['secondSolventConcentrationA'])
        self.setSecondSolventConcentrationB(
            input_dict['secondSolventConcentrationB'])
        self.setDelayTime(input_dict['delayTime'])
        self.setFlowRate(input_dict['flowRate'])
        self.setDV(input_dict['dV'])
        self.setCalibrationParameter(input_dict['calibrationParameter'])
        self.setColumnVpToVtot(input_dict['columnVpToVtot'])
        self.setColumnPorosity(input_dict['columnPorosity'])
        self.setTemperature(input_dict['temperature'])

    __swig_destroy__ = _pyBioLCCC.delete_ChromoConditions
    __del__ = lambda self : None;
ChromoConditions_swigregister = _pyBioLCCC.ChromoConditions_swigregister
ChromoConditions_swigregister(ChromoConditions)


def calculatePeptideProperties(*args):
  """
    calculatePeptideProperties(sequence, conditions, chemBasis, RTBioLCCC, averageMass, 
        monoisotopicMass) -> bool
    """
  return _pyBioLCCC.calculatePeptideProperties(*args)

cvar = _pyBioLCCC.cvar
standardChromoConditions = cvar.standardChromoConditions
standardChemicalBasis = cvar.standardChemicalBasis

def calculateRT(*args):
  """
    calculateRT(sequence, conditions = standardChromoConditions, chemBasis = standardChemicalBasis, 
        continueGradient = True) -> double
    calculateRT(sequence, conditions = standardChromoConditions, chemBasis = standardChemicalBasis) -> double
    calculateRT(sequence, conditions = standardChromoConditions) -> double
    calculateRT(sequence) -> double
    """
  return _pyBioLCCC.calculateRT(*args)

def calculateAverageMass(*args):
  """
    calculateAverageMass(sequence, chemBasis = standardChemicalBasis) -> double
    calculateAverageMass(sequence) -> double
    """
  return _pyBioLCCC.calculateAverageMass(*args)

def calculateMonoisotopicMass(*args):
  """
    calculateMonoisotopicMass(sequence, chemBasis = standardChemicalBasis) -> double
    calculateMonoisotopicMass(sequence) -> double
    """
  return _pyBioLCCC.calculateMonoisotopicMass(*args)

def calculateKd(*args):
  """
    calculateKd(sequence, secondSolventConcentration, chemBasis = standardChemicalBasis, 
        columnPoreSize = 100.0, 
        calibrationParameter = 1.0, temperature = 293.0) -> double
    calculateKd(sequence, secondSolventConcentration, chemBasis = standardChemicalBasis, 
        columnPoreSize = 100.0, 
        calibrationParameter = 1.0) -> double
    calculateKd(sequence, secondSolventConcentration, chemBasis = standardChemicalBasis, 
        columnPoreSize = 100.0) -> double
    calculateKd(sequence, secondSolventConcentration, chemBasis = standardChemicalBasis) -> double
    calculateKd(sequence, secondSolventConcentration) -> double
    """
  return _pyBioLCCC.calculateKd(*args)

