"""CLI tools for Python.

Copyright (c) 2009-2010 Will Maier <will@m.aier.us>

Permission to use, copy, modify, and distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
"""

try:
    import unittest2 as unittest
except ImportError:
    import unittest

import cli.test

class BaseTest(unittest.TestCase):
    pass

class AppTest(cli.test.AppTest, BaseTest):
    pass

class DecoratorTests(object):

    def test_run(self):
        # This servers as a nice sanity check.
        self.app.run()

    def test_decorate_callable(self):
        @self.app_cls
        def foo(app):
            pass
        self.assertEqual(foo.name, "foo")

    def test_instantiate_and_decorate_callable(self):
        @self.app_cls(name="foo")
        def bar(app):
            pass
        self.assertEqual(bar.name, "foo")

    def test_wrap_non_function_callable(self):
        class foo(object):
            def __call__(self, app):
                pass
        # Required in Python 2.4.
        foo = foo()
        foo.__name__ = "foo"
        foo = self.app_cls(foo)
        setattr(foo, "__name__", "foo")

        self.assertEqual(foo.name, "foo")
    
    def test_subclass(self):
        cls = self.app_cls
        class Test(cls):
            
            def __init__(self, main=None, **kwargs):
                cls.__init__(self, main, **kwargs)
                self.exit_after_main = False

            def pre_run(self):
                # Skip things like CLI parsing...
                pass
            
            def main(self):
                return 0
        self.assertEqual(Test().run(), 0)
