/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.ConnectionLostException;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.Functions;
import com.detectright.core.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Cache {
    static ThreadLocal<LinkedHashMap<String, String>> connections = new ThreadLocal<LinkedHashMap<String, String>>(){

        @Override
        protected synchronized LinkedHashMap<String, String> initialValue() {
            return new LinkedHashMap<String, String>();
        }
    };
    static boolean useCache = false;
    static ArrayList<String> objectsToCache = new ArrayList();
    static LinkedHashMap<String, Cache> caches = new LinkedHashMap();
    String hash;
    String engine = "";
    boolean cacheOK = false;
    LinkedHashMap<String, String> params = new LinkedHashMap();
    double get_time = 0.0;
    double file_get_time = 0.0;
    double set_time = 0.0;
    double file_set_time = 0.0;
    Cache cache;
    String error = "";
    boolean enabled = false;

    static void main(String[] args) {
    }

    Cache(String hash) {
        this.hash = hash;
    }

    static void assign(String classname, String connectString) {
        LinkedHashMap<String, String> conns = connections.get();
        conns.put(classname, connectString);
    }

    static void init() throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Initialising Cache", 0);
        Map conns = connections.get();
        ArrayList<String> done = new ArrayList<String>();
        for (Map.Entry entry : conns.entrySet()) {
            Cache cache;
            String classname = (String)entry.getKey();
            done.add(classname);
            String connection = (String)entry.getValue();
            String hash = Functions.md5(connection);
            if (caches.containsKey(hash)) {
                cache = caches.get(connection);
            } else {
                cache = Cache.getConnection(connection);
                cache.enabled = useCache;
                caches.put(hash, cache);
            }
            if (Reflection.method_exists(classname, "setCacheLink")) {
                Reflection.invokeStaticMethodWithObject(classname, "setCacheLink", "Cache", cache);
                continue;
            }
            try {
                Field field = Reflection.getField(classname, "cacheLink");
                if (field == null) continue;
                field.setAccessible(true);
                ThreadLocal o = (ThreadLocal)field.get(null);
                if (o == null) continue;
                o.set(cache);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Cache cacheLink = DetectRight.getCacheLink();
        if (cacheLink == null) {
            cacheLink = new Cache("DUMMY");
            DetectRight.setCacheLink(cacheLink);
        }
        if (DetectRight.classes != null) {
            int i = 0;
            while (i < DetectRight.classes.size()) {
                String clsname = DetectRight.classes.get(i);
                if (!(clsname.equals("Cache") || clsname.equals("Functions") || clsname.equals("Reflection") || done.contains(clsname))) {
                    try {
                        Field field = Reflection.getField(clsname, "cacheLink");
                        if (field != null) {
                            field.setAccessible(true);
                            ThreadLocal o = (ThreadLocal)field.get(null);
                            o.set(cacheLink);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        DetectRight.checkPoint("Initialised cache", 0);
    }

    static Cache getConnection(String connectionStr) throws DetectRightException, ConnectionLostException {
        DetectRight.checkPoint("Getting cache connection");
        String hash = Functions.md5(connectionStr);
        Cache dummyCache = new Cache(hash);
        ArrayList<String> connection = Functions.explode("//", connectionStr);
        if (connection.size() < 1) {
            Functions.trigger_error("Failed cache connection, too few parts connection");
            return dummyCache;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("engine", Functions.array_shift(connection).toString());
        String engine = (String)params.get("engine");
        params.put("address", Functions.array_shift(connection).toString());
        if (connection.size() > 0) {
            params.put("port", Functions.array_shift(connection).toString());
        }
        if (connection.size() > 0) {
            params.put("username", Functions.array_shift(connection).toString());
        }
        if (connection.size() > 0) {
            params.put("password", Functions.array_shift(connection).toString());
        }
        if (connection.size() > 0) {
            params.put("bucket", Functions.array_shift(connection).toString());
        }
        try {
            Class<?> c = Class.forName(Reflection.cn(engine));
            Class[] partypes = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> ct = c.getConstructor(partypes);
            Object[] arglist = new Object[]{new String(hash)};
            Cache cache = (Cache)ct.newInstance(arglist);
            cache.cache_init(params);
            cache.enabled = useCache;
            Cache pointer = cache;
            DetectRight.checkPoint("Got cache connection");
            return pointer;
        }
        catch (Throwable e) {
            DetectRight.checkPoint("Returning dummy cache");
            return dummyCache;
        }
    }

    boolean checkCache() throws DetectRightException, ConnectionLostException {
        String random_number = String.valueOf(String.valueOf(Functions.time())) + String.valueOf(Functions.rand(0, 1000000));
        boolean result = this._set(random_number, "hellovalue", 10);
        if (!result || !this.get(random_number).equals("hellovalue")) {
            Functions.trigger_error("Cache problem" + this.error);
            this.cacheOK = false;
        } else {
            DetectRight.checkPoint("Memcache is OK");
            this.cacheOK = true;
        }
        return this.cacheOK;
    }

    boolean cache_ok() {
        if (!useCache) {
            return false;
        }
        return this.cacheOK;
    }

    void setCacheing(boolean status) {
        this.enabled = status;
    }

    void cache_init(LinkedHashMap<String, String> params) throws DetectRightException, ConnectionLostException {
        this.params = params;
        this.get_time = 0.0;
        this.set_time = 0.0;
        this.file_get_time = 0.0;
        this.file_set_time = 0.0;
        this.cacheOK = false;
        this.checkCache();
    }

    void cache_close() {
        caches.remove(this.hash);
    }

    long cache_increment(String key) {
        return 0L;
    }

    long cache_increment(String key, int amount) {
        return 0L;
    }

    boolean cache_delete(String key) {
        return true;
    }

    protected Object get(String key) {
        return null;
    }

    boolean _set(String key, Object value, int timeout) {
        return false;
    }

    boolean cache_set(String key, Object value) {
        return this.cache_set(key, value, 0);
    }

    boolean cache_set(String key, Object value, int timeout) {
        return false;
    }

    Object cache_get(String key) {
        return null;
    }

    boolean cache_flush() {
        return true;
    }

    LinkedHashMap<String, Object> stats() {
        LinkedHashMap<String, Object> output = this.cacheStats();
        return output;
    }

    LinkedHashMap<String, Object> cacheStats() {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("engine", this.engine);
        output.put("get_time", this.get_time);
        output.put("set_time", this.set_time);
        return output;
    }
}

