/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.DRLRUMap;
import com.detectright.core.DRProfileResult;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.DeviceNotFoundException;
import com.detectright.core.EntityAliasCore;
import com.detectright.core.EntityCore;
import com.detectright.core.EntitySigCollection;
import com.detectright.core.Functions;
import com.detectright.core.HTTPHeadersCore;
import com.detectright.core.PointerCore;
import com.detectright.core.SchemaPropertyCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRProfile {
    public LinkedHashMap<String, DRProfileResult> results = new LinkedHashMap();
    public LinkedHashMap<String, DRProfileResult> overrides = new LinkedHashMap();
    public LinkedHashMap<String, DRProfileResult> metadata = new LinkedHashMap();
    public String boolFormat = "truefalse";
    public boolean strictExportNames = true;
    public HTTPHeadersCore headers = null;
    public EntitySigCollection esc = null;
    public LinkedHashMap<String, SchemaPropertyCore> schema = new LinkedHashMap();
    public boolean filled = false;
    public String source = "";
    static boolean profileCache = false;

    public DRProfile() {
        this(true, "truefalse", "");
    }

    public DRProfile(boolean strictExportNames) {
        this(strictExportNames, "truefalse", "");
    }

    public DRProfile(boolean strictExportNames, String boolFormat) {
        this(strictExportNames, boolFormat, "");
    }

    public DRProfile(boolean strictExportNames, String boolFormat, String source) {
        this.strictExportNames = strictExportNames;
        if (!Functions.isEmpty(boolFormat)) {
            this.boolFormat = boolFormat;
        }
        if (!Functions.isEmpty(source)) {
            this.source = source;
        }
    }

    public boolean matches(String key, String value) {
        return this.matches(key, value, true);
    }

    public boolean matches(String key, String value, boolean checkOverrides) {
        DRProfileResult result = null;
        if (checkOverrides && (result = this.getOverrideObject(key)).matches(value)) {
            return true;
        }
        result = this.getProfileResult(key);
        if (result == null) {
            return false;
        }
        return result.matches(value);
    }

    public boolean matchesOverride(String key, String value) {
        DRProfileResult result = null;
        result = this.getOverrideObject(key);
        if (result == null) {
            return false;
        }
        return result.matches(value);
    }

    public DRProfileResult getProfileResult(String field) {
        if (this.results.containsKey(field)) {
            return null;
        }
        DRProfileResult pr = this.results.get(field);
        return pr;
    }

    public boolean overrideExists(String field) {
        return this.overrides.containsKey(field);
    }

    public DRProfileResult getOverrideObject(String field) {
        if (!this.overrideExists(field)) {
            return null;
        }
        return this.overrides.get(field);
    }

    public Object getOverride(String field) {
        DRProfileResult override = this.getOverrideObject(field);
        if (override == null) {
            return null;
        }
        return override.getValue();
    }

    public Object getValue(String field) {
        return this.getValue(field, true);
    }

    public Object getValue(String field, boolean checkOverrides) {
        Object override;
        if (checkOverrides && (override = this.getOverride(field)) != null) {
            return override;
        }
        DRProfileResult result = null;
        result = this.getProfileResult(field);
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    public boolean addProfileResult(DRProfileResult pr) {
        if (pr == null) {
            return false;
        }
        this.results.put(pr.getKey(), pr);
        return true;
    }

    public void addResult(SchemaPropertyCore sp, ArrayList<String> value, LinkedHashMap<String, Integer> importances) {
        String key = this.strictExportNames ? sp.display_name : sp.property;
        DRProfileResult result = DRProfileResult.newResult(key, value, importances, sp);
        result._boolFormat = this.boolFormat;
        this.results.put(key, result);
    }

    public ArrayList<String> getFieldList() {
        return Functions.array_keys_string(this.results);
    }

    public int getImportance(String field, String value) {
        DRProfileResult pr = this.getProfileResult(field);
        if (pr == null) {
            return 0;
        }
        return pr.getImportance(value);
    }

    public void addMetadata(String key, String value) throws DetectRightException, ConnectionLostException {
        this.addMetadata(key, value, "Literal");
    }

    public void addMetadata(String key, String value, String type) throws DetectRightException, ConnectionLostException {
        SchemaPropertyCore sp = new SchemaPropertyCore();
        LinkedHashMap<String, Integer> importances = new LinkedHashMap<String, Integer>();
        sp.property = key;
        sp.display_name = key;
        sp.type = type;
        importances.put(key, 999);
        ArrayList<String> valueArray = new ArrayList<String>(Arrays.asList(value));
        this.metadata.put(key, DRProfileResult.newResult(key, valueArray, importances, sp));
    }

    public LinkedHashMap<String, Object> getAllMetadata() {
        return this.getAllMetadata(true);
    }

    public LinkedHashMap<String, Object> getAllMetadata(boolean includeQDT) {
        LinkedHashMap<String, Object> output = new LinkedHashMap();
        if (includeQDT && this.esc.qdt != null) {
            output = this.esc.qdt.metadata;
        }
        for (Map.Entry entry : this.metadata.entrySet()) {
            String key = (String)entry.getKey();
            DRProfileResult result = (DRProfileResult)entry.getValue();
            if (result == null || key == null) continue;
            output.put(key, result.getValue());
        }
        return output;
    }

    public void clearOverrides() {
        this.overrides = new LinkedHashMap();
    }

    public void addOverride(String key, String value) throws DetectRightException, ConnectionLostException {
        this.addOverride(key, value, true, "Literal", "");
    }

    public void addOverride(String key, String value, boolean force) throws DetectRightException, ConnectionLostException {
        this.addOverride(key, value, force, "Literal", "");
    }

    public void addOverride(String key, String value, boolean force, String type) throws DetectRightException, ConnectionLostException {
        this.addOverride(key, value, force, type, "");
    }

    public void addOverride(String key, String value, boolean force, String type, String source) throws DetectRightException, ConnectionLostException {
        SchemaPropertyCore sp;
        LinkedHashMap<String, Integer> importances = new LinkedHashMap<String, Integer>();
        if (!force) {
            if (this.matches(key, value)) {
                return;
            }
            if (this.matchesOverride(key, value)) {
                return;
            }
            importances.put(key, 0);
        } else {
            importances.put(key, 200);
        }
        if (this.schema.containsKey(key)) {
            sp = this.schema.get(key);
        } else {
            sp = new SchemaPropertyCore();
            sp.property = key;
            sp.display_name = key;
            sp.type = type;
            sp.error = "";
        }
        ArrayList<String> valueArray = new ArrayList<String>(Arrays.asList(value));
        DRProfileResult result = DRProfileResult.newResult(key, valueArray, importances, sp);
        result.setSource(source);
        if (!Functions.isEmpty(type)) {
            result.setType(type);
        }
        this.overrides.put(key, result);
    }

    public LinkedHashMap<String, String> getAllOverrides() {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.overrides.entrySet()) {
            DRProfileResult result;
            String key = (String)entry.getKey();
            if (key == null || (result = (DRProfileResult)entry.getValue()) == null) continue;
            String value = Functions.nn(result.getValue());
            output.put(key, value.toString());
        }
        return output;
    }

    public LinkedHashMap<String, String> getAllData() {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (Map.Entry entry : this.results.entrySet()) {
            DRProfileResult result;
            String key = (String)entry.getKey();
            if (key == null || (result = (DRProfileResult)entry.getValue()) == null) continue;
            String value = Functions.nn(result.getValue());
            output.put(key, value.toString());
        }
        return output;
    }

    public void addSP(SchemaPropertyCore sp) {
        if (sp == null) {
            return;
        }
        String key = this.strictExportNames ? sp.display_name : sp.property;
        this.schema.put(key, sp);
    }

    public LinkedHashMap<String, String> getAllValues() throws DetectRightException, ConnectionLostException {
        this.fillMe();
        LinkedHashMap<String, String> data = this.getAllData();
        LinkedHashMap<String, String> overrides = this.getAllOverrides();
        data.putAll(overrides);
        return data;
    }

    public void fillMe() throws DetectRightException, ConnectionLostException {
        if (this.filled) {
            return;
        }
        this.esc.qdt.processPackages();
        for (Map.Entry entry : this.schema.entrySet()) {
            SchemaPropertyCore nsp = (SchemaPropertyCore)entry.getValue();
            if (nsp == null || nsp.error_trap > 0 || Functions.isEmpty(nsp.output_map)) continue;
            LinkedHashMap<String, Integer> array = new LinkedHashMap<String, Integer>();
            Object value = SchemaPropertyCore.getObjectValue(this.esc.qdt, nsp, array);
            if (Functions.is_array(value)) {
                this.addResult(nsp, (ArrayList)value, array);
                continue;
            }
            this.addResult(nsp, new ArrayList<String>(Arrays.asList(value.toString())), array);
        }
        this.filled = true;
    }

    public void getProfile() throws DetectRightException, ConnectionLostException {
        this.getProfile("");
    }

    public void getProfile(String schemas) throws DetectRightException, ConnectionLostException {
        ArrayList<String> schemaArray = Functions.explode(",", schemas);
        DetectRight.checkPoint("Getting profile");
        for (String schemaToUse : schemaArray) {
            LinkedHashMap<String, SchemaPropertyCore> schemaCollection = SchemaPropertyCore.getSchema(schemaToUse);
            for (Map.Entry entry : schemaCollection.entrySet()) {
                SchemaPropertyCore sp = (SchemaPropertyCore)entry.getValue();
                if (sp == null) continue;
                this.addSP(sp);
            }
        }
        this.fillMe();
        DetectRight.checkPoint("Generated Profile");
        EntityCore nomEntity = this.esc.getNominativeEntity();
        if (nomEntity == null) {
            nomEntity = EntityCore.addEntity("UserAgent", "UserAgent", this.headers.ua);
        }
        ArrayList<String> statusArray = new ArrayList<String>(Arrays.asList("1", "2"));
        ArrayList<EntityAliasCore> akas = EntityAliasCore.getAliasCollection(nomEntity.id(), statusArray);
        ArrayList<String> descriptors = new ArrayList<String>();
        ArrayList<String> hashes = new ArrayList<String>();
        for (EntityAliasCore ea : akas) {
            if (ea == null) continue;
            String desc = String.valueOf(ea.entitytype) + ":" + ea.category + ":" + ea.description;
            hashes.add(ea.hash);
            descriptors.add(desc);
        }
        this.addMetadata("deviceid", nomEntity.hash);
        this.addMetadata("id", nomEntity.hash);
        this.addMetadata("devicedescriptor", String.valueOf(nomEntity.entitytype) + ":" + nomEntity.category + ":" + nomEntity.description);
        this.addMetadata("components", Functions.implode(",", descriptors));
        if (this.headers != null) {
            this.addMetadata("uid", this.headers.uid);
        }
        this.addMetadata("altdescriptors", Functions.implode(",", descriptors));
        this.addMetadata("altids", Functions.implode(",", hashes));
        ArrayList<String> eHashes = new ArrayList<String>();
        eHashes.addAll(hashes);
        LinkedHashMap<String, Object> where = new LinkedHashMap();
        if (eHashes.size() > 0) {
            LinkedHashMap<String, Object> whereHashes = new LinkedHashMap<String, Object>();
            whereHashes.put("op", "in");
            whereHashes.put("value", eHashes);
            where.put("entityhash", whereHashes);
            DBLink dbLink = EntityCore.dbLink.get();
            if (dbLink == null) {
                dbLink = DetectRight.getDBLink();
            }
            this.addMetadata("dbconn", dbLink.getConnectionInfo());
            this.addOverrides(where, true);
        }
        where = DBLink.whereClause("entityhash", nomEntity.hash);
        this.addOverrides(where, true);
        where.clear();
        String deviceType = nomEntity.entitytype;
        Boolean readersAsTablets = DetectRight.getPropertyBool("readersAsTablets");
        if (readersAsTablets == null) {
            readersAsTablets = false;
        }
        if (readersAsTablets.booleanValue() && nomEntity != null && nomEntity.entitytype.equals("e-Reader")) {
            deviceType = "Tablet";
        }
        LinkedHashMap<String, Object> et = null;
        if (nomEntity != null && nomEntity.entitytype.equals("UserAgent")) {
            et = this.esc.getEntityTree();
            if (et != null && et.containsKey("Mobile Browser")) {
                deviceType = "Mobile Browser";
            } else if (et != null && et.containsKey("Browser")) {
                EntityCore e;
                deviceType = "Desktop";
                ArrayList eArr = (ArrayList)et.get("Browser");
                if (eArr != null && (e = (EntityCore)Functions.array_shift(eArr)) != null && e.entitytype.equals("Mobile Browser")) {
                    deviceType = "Mobile Device";
                }
            }
        }
        if (deviceType.equals("UserAgent")) {
            deviceType = "Desktop";
        }
        where.put("entityhash", "generic_" + deviceType);
        this.addOverrides(where, false);
        where.clear();
        where.put("entityhash", "generic");
        this.addOverrides(where, false);
        this.addMetadata("type", deviceType);
        if (et != null && et.containsKey("UserAgent") && !DetectRight.getEnableUserAgentEntityType()) {
            ArrayList<String> uaKeys = this.fieldsForValue(nomEntity.category, true);
            for (String uaKey : uaKeys) {
                this.addOverride(uaKey, "Generic");
            }
            uaKeys = this.fieldsForValue(nomEntity.description, true);
            for (String uaKey : uaKeys) {
                this.addOverride(uaKey, deviceType);
            }
        }
    }

    public ArrayList<String> fieldsForValue(Object value, boolean strict) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry entry : this.results.entrySet()) {
            String key;
            DRProfileResult result = (DRProfileResult)entry.getValue();
            if (result == null || (key = (String)entry.getKey()) == null) continue;
            Object resultValue = result.getValue();
            if (strict) {
                if (!result.equals(resultValue)) continue;
                keys.add((String)entry.getKey());
                continue;
            }
            if (!result.toString().equals(resultValue.toString())) continue;
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOverrides(LinkedHashMap<String, Object> where, boolean forceOverride) throws DetectRightException, ConnectionLostException {
        LinkedHashMap<String, Object> overrides = null;
        DBLink dbl = this.esc.db;
        if (dbl == null) {
            dbl = DetectRight.getDBLink();
        }
        if (dbl == null) {
            throw new ConnectionLostException();
        }
        String cacheKey = Functions.md5(Functions.serialize(where));
        DRLRUMap dRLRUMap = EntitySigCollection.gOverrides;
        synchronized (dRLRUMap) {
            if (EntitySigCollection.gOverrides.containsKey(cacheKey)) {
                overrides = (LinkedHashMap<String, Object>)EntitySigCollection.gOverrides.get(cacheKey);
            }
        }
        if (overrides == null) {
            dRLRUMap = EntitySigCollection.gOverrides;
            synchronized (dRLRUMap) {
                if (EntitySigCollection.gOverrides.containsKey(cacheKey)) {
                    overrides = (LinkedHashMap)EntitySigCollection.gOverrides.get(cacheKey);
                } else {
                    overrides = dbl.simpleFetch("entity_overrides", DBLink.allFields, where);
                    if (overrides != null) {
                        EntitySigCollection.gOverrides.add(cacheKey, overrides);
                    }
                }
            }
        }
        boolean custom = false;
        if (overrides != null) {
            LinkedHashMap<String, Object> tmpMap = overrides;
            for (Map.Entry entry : tmpMap.entrySet()) {
                Object rowObj = entry.getValue();
                if (!(rowObj instanceof LinkedHashMap)) continue;
                LinkedHashMap row = (LinkedHashMap)rowObj;
                String key = Functions.nn(Functions.gv(row, "key"));
                String value = Functions.nn(Functions.gv(row, "value"));
                this.addOverride(key, value, forceOverride);
                custom = true;
            }
        }
        if (custom) {
            this.addMetadata("customised", "1");
        }
    }

    public static DRProfile getProfileFromHeaders(Map<?, ?> lhm) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromHeaders(lhm, "", "", "truefalse");
    }

    public static DRProfile getProfileFromHeaders(Map<?, ?> lhm, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        HTTPHeadersCore headers;
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (schema == null) {
            schema = "";
        }
        if (lhm == null) {
            throw new DetectRightException("Null headers passed in", null);
        }
        profile.headers = headers = new HTTPHeadersCore((LinkedHashMap)lhm);
        String key = DetectRight.cacheKey("DRJavaDRP/" + profile.headers.uid + "/" + schema);
        try {
            Cache c = DetectRight.getCacheLink();
            if (profileCache && !DetectRight.getRedetect() && c != null) {
                try {
                    Object tmp = c.cache_get(key);
                    if (tmp != null) {
                        profile = (DRProfile)tmp;
                        return profile;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!profile.detect()) {
                return profile;
            }
            profile.getProfile(schema);
            if (profileCache && c != null) {
                c.cache_set(key, profile, 3600);
            }
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new DetectRightException(e.getMessage(), e);
        }
        return profile;
    }

    public static DRProfile getProfileFromPhoneID(String id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromPhoneID(id, "", "", "truefalse");
    }

    public static DRProfile getProfileFromPhoneID(String id, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(id)) {
            throw new DetectRightException("Empty ID!", null);
        }
        EntitySigCollection phoneIDESC = PointerCore.getESC("PhoneID", id);
        if (phoneIDESC == null || phoneIDESC.entities == null || phoneIDESC.entities.size() == 0) {
            throw new DeviceNotFoundException("Phone ID " + id + " Not Found");
        }
        profile.processDetection(phoneIDESC);
        profile.getProfile(schema);
        return profile;
    }

    public static DRProfile getProfileFromUAProfile(String uap) throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        return DRProfile.getProfileFromUAProfile(uap, "", "", "truefalse");
    }

    public static DRProfile getProfileFromUAProfile(String uap, String schema, String source, String boolFormat) throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (Functions.isEmpty(uap)) {
            return null;
        }
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(uap)) {
            throw new DetectRightException("Empty URL!", null);
        }
        String url = "";
        try {
            url = Functions.cleanURL(uap);
        }
        catch (Exception e) {
            throw new DetectRightException("Invalidly formatted URL", e);
        }
        EntitySigCollection uapESC = PointerCore.getESC("UAP", url);
        if (uapESC == null || uapESC.entities == null || uapESC.entities.size() == 0) {
            throw new DeviceNotFoundException("UAProfile link " + uap + " Not Found");
        }
        profile.processDetection(uapESC);
        profile.getProfile(schema);
        return profile;
    }

    public static DRProfile getProfileFromUA(String useragent) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromUA(useragent, "", "", "truefalse");
    }

    public static DRProfile getProfileFromUA(String useragent, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (Functions.isEmpty(useragent)) {
            return profile;
        }
        LinkedHashMap<String, Object> lhm = DBLink.whereClause("HTTP_USER_AGENT", useragent);
        return DRProfile.getProfileFromHeaders(lhm);
    }

    public static DRProfile getProfileFromTAC(String tac) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromTAC(tac, "", "", "truefalse");
    }

    public static DRProfile getProfileFromTAC(String tac, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (Functions.isEmpty(tac)) {
            throw new DetectRightException("TAC is empty", null);
        }
        if (schema == null) {
            schema = "";
        }
        if (tac.length() > 8) {
            tac = Functions.substr(tac, 0, 8);
        }
        if (tac.length() < 7) {
            throw new DetectRightException("Invalid TAC, less than 7 characters", null);
        }
        EntitySigCollection tacESC = null;
        tacESC = PointerCore.getESC("TAC", tac);
        if (tacESC == null || tacESC.entities == null || tacESC.entities.size() == 0) {
            throw new DeviceNotFoundException();
        }
        profile.processDetection(tacESC);
        profile.getProfile(schema);
        return profile;
    }

    public static DRProfile getProfileFromDeviceID(long id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromDeviceID(id, "", "", "truefalse");
    }

    public static DRProfile getProfileFromDeviceID(long id, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (schema == null) {
            schema = "";
        }
        try {
            if (!profile.detectDevice(id)) {
                return null;
            }
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DetectRightException("Detection error", e);
        }
        profile.getProfile(schema);
        return profile;
    }

    public static DRProfile getProfileFromDeviceID(String hash) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromDeviceID(hash, "", "", "truefalse");
    }

    public static DRProfile getProfileFromDeviceID(String hash, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        DRProfile profile = new DRProfile(DetectRight.getStrictExportNames(), boolFormat, source);
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(hash)) {
            throw new DetectRightException("Empty device id", null);
        }
        try {
            if (!profile.detectDevice(hash)) {
                return null;
            }
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (ConnectionLostException ce) {
            throw ce;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DetectRightException("Detection error", e);
        }
        EntityCore e = EntityCore.get(hash);
        if (e == null) {
            return profile;
        }
        profile.addMetadata("deviceid", e.hash);
        profile.addMetadata("devicedescriptor", e.descriptor());
        return profile;
    }

    public static Map<String, Object> getProfileMap() throws DetectRightException, ConnectionLostException {
        return DRProfile.getProfileMap("");
    }

    public static Map<String, Object> getProfileMap(String schema) throws DetectRightException, ConnectionLostException {
        EntitySigCollection lastDetection;
        if (schema == null) {
            schema = "";
        }
        if ((lastDetection = DetectRight.getLastDetection()) == null) {
            throw new DetectRightException("No valid detection has been done", null);
        }
        LinkedHashMap<String, Object> profile = lastDetection.getExportProfile(schema);
        if (profile == null) {
            profile = new LinkedHashMap();
        }
        if (!Functions.isEmpty(schema)) {
            profile.put("schema", schema);
        }
        DetectRight.postProcess(profile);
        return profile;
    }

    public static DRProfile getProfileFromDevice(String entitytype, String category, String description) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return DRProfile.getProfileFromDevice(entitytype, category, description, "", "", "truefalse");
    }

    public static DRProfile getProfileFromDevice(String entitytype, String category, String description, String schema, String source, String boolFormat) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (schema == null) {
            schema = "";
        }
        if (Functions.isEmpty(entitytype) || Functions.isEmpty(category) || Functions.isEmpty(description)) {
            throw new DetectRightException("Entitytype, category, or description missing", null);
        }
        EntityCore entity = EntityCore.getEntityFromCatDesc(category, description, entitytype, false);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        String hash = entity.hash;
        if (Functions.isEmpty(hash)) {
            throw new DeviceNotFoundException();
        }
        return DRProfile.getProfileFromDeviceID(hash, schema, source, boolFormat);
    }

    public boolean detectDevice(long id) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        EntityCore entity = EntityCore.get(id);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        return this.detectDevice(entity.hash);
    }

    public boolean detectDevice(String id) throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        EntityCore entity = Functions.is_numeric(id) && Functions.strlen(id) < 32 ? EntityCore.get(id) : EntityCore.get(0L, id);
        if (entity == null || !Functions.is_object(entity) || entity.id() == 0L) {
            throw new DeviceNotFoundException("Device id not found");
        }
        if (entity.id() < 0L) {
            throw new DeviceNotFoundException("Invalid entity object passed in");
        }
        EntitySigCollection esc = new EntitySigCollection();
        esc.addEntity(entity);
        esc.addEntityContains();
        DetectRight.checkPoint("Getting QDT");
        esc.getQDT();
        esc.qdt.processPackages();
        this.esc = esc;
        return true;
    }

    public boolean detectDevice(String entitytype, String manufacturer, String model) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        if (Functions.isEmpty(manufacturer) || Functions.isEmpty(model)) {
            throw new DetectRightException("Missing manufacturer or model", null);
        }
        EntityCore entity = EntityCore.getEntityFromCatDesc(manufacturer, model, entitytype);
        if (entity == null || entity.id() == 0L) {
            throw new DeviceNotFoundException();
        }
        return this.detectDevice(entity.hash);
    }

    public boolean detectDevice(String manufacturer, String model) throws DeviceNotFoundException, DetectRightException, ConnectionLostException {
        return this.detectDevice("", manufacturer, model);
    }

    public boolean detect() throws DetectRightException, ConnectionLostException, DeviceNotFoundException {
        if (Functions.isEmpty(this.headers)) {
            return false;
        }
        boolean result = false;
        try {
            this.headers.process();
            result = this.processDetection(this.headers.getESC());
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (ConnectionLostException cle) {
            throw cle;
        }
        catch (DeviceNotFoundException dnfe) {
            throw dnfe;
        }
        catch (Exception e) {
            throw new DetectRightException("Error detecting", e);
        }
        return result;
    }

    public boolean processDetection(EntitySigCollection esc) throws ConnectionLostException, DeviceNotFoundException, DetectRightException {
        try {
            esc.addEntityContains();
            DetectRight.checkPoint("Getting QDT");
            esc.getQDT();
            DetectRight.checkPoint("Got QDT");
            esc.qdt.processPackages();
            esc.resetRootEntity();
            this.esc = esc;
        }
        catch (DetectRightException de) {
            throw de;
        }
        catch (ConnectionLostException cle) {
            throw cle;
        }
        catch (Exception e) {
            throw new DetectRightException("Error detecting", e);
        }
        return true;
    }

    public void cacheMe() {
    }
}

