/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Functions;
import com.detectright.core.SchemaPropertyCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRProfileResult {
    private SchemaPropertyCore _sp;
    private String _key;
    private String _valueLiteral = null;
    private Boolean _valueBoolean = null;
    private Long _valueInteger = null;
    private Float _valueFloat = null;
    private ArrayList<String> _valueLiteralArray = null;
    private boolean _isBoolean = false;
    private boolean _isMissing = true;
    public String _boolFormat = "truefalse";
    private LinkedHashMap<String, Integer> _importanceArray = new LinkedHashMap();
    private int _importance = 0;
    private String source = "";
    private String type = "Literal";

    DRProfileResult() {
    }

    DRProfileResult(String key) {
        this(key, null);
    }

    DRProfileResult(String key, SchemaPropertyCore sp) {
        if (Functions.isEmpty(key)) {
            return;
        }
        this._key = key;
        if (sp != null) {
            this._sp = sp;
            this.type = sp.type;
            this._isBoolean = sp.type.equals("Boolean");
        }
    }

    static DRProfileResult newResult(String key, ArrayList<String> values, LinkedHashMap<String, Integer> importances, SchemaPropertyCore sp) {
        DRProfileResult result = new DRProfileResult(key, sp);
        if (values == null || values.size() == 0) {
            return result;
        }
        if (result.isArray()) {
            for (String value : values) {
                int importance = 0;
                if (importances != null && importances.containsKey(value)) {
                    importance = importances.get(value);
                }
                result.setValue(value, importance);
            }
        } else {
            Integer importance = 0;
            if (importances != null && importances.size() > 0) {
                importance = Functions.parseInt(Functions.nn(Functions.array_shift(importances)).toString());
            }
            String value = "";
            value = values.get(0);
            result.setValue(value, importance);
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        ArrayList<String> allowedTypes = new ArrayList<String>(Arrays.asList("Float", "Literal", "LiteralArray", "Bytesize", "Integer", "Boolean", "Dimension"));
        if (!allowedTypes.contains(type)) {
            return;
        }
        this.type = type;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isArray() {
        if (this._sp == null) {
            return false;
        }
        return this._sp.type.equals("LiteralArray");
    }

    public void setImportance(Integer importance, String value) {
        if (this.isArray()) {
            if (Functions.isEmpty(value) || value.equals(this.getValue())) {
                this._importance = importance;
            }
        } else {
            this._importanceArray.remove(value);
            this._importanceArray.put(value, importance);
        }
    }

    public int getImportance() {
        return this.getImportance("");
    }

    public int getImportance(String value) {
        boolean isArray = this.isArray();
        if (!isArray) {
            if (Functions.isEmpty(value) || value.equals(this.getValue())) {
                return this._importance;
            }
            return 0;
        }
        if (value == null) {
            return 0;
        }
        if (this._importanceArray == null || !this._importanceArray.containsKey(value)) {
            return 0;
        }
        return this._importanceArray.get(value);
    }

    public boolean isMissing() {
        return this._isMissing;
    }

    public String getDefaultValue() {
        if (this._sp == null) {
            return null;
        }
        return this._sp.default_value;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setSP(SchemaPropertyCore sp) {
        this._sp = sp;
    }

    public SchemaPropertyCore getSP() {
        return this._sp;
    }

    public Object getValue() {
        if (this._isMissing) {
            return null;
        }
        String type = this.getType();
        if (type.equals("Boolean")) {
            return this.getBoolString();
        }
        if (type.equals("LiteralArray")) {
            return this._valueLiteralArray;
        }
        if (type.equals("Float")) {
            return String.valueOf(this._valueFloat);
        }
        if (type.equals("Integer")) {
            return String.valueOf(this._valueInteger);
        }
        if (type.equals("Dimension")) {
            return this._valueLiteral;
        }
        if (type.equals("Literal")) {
            return this._valueLiteral;
        }
        return this._valueLiteral;
    }

    public String getDimensionX() {
        if (!this.isDimension()) {
            return null;
        }
        ArrayList<String> tmp = Functions.explode("x", this._valueLiteral);
        if (tmp.size() == 0) {
            return null;
        }
        return tmp.get(0);
    }

    public String getDimensionY() {
        if (!this.isDimension()) {
            return null;
        }
        ArrayList<String> tmp = Functions.explode("x", this._valueLiteral);
        if (tmp.size() < 2) {
            return null;
        }
        return tmp.get(1);
    }

    public String getDimensionZ() {
        if (!this.isDimension()) {
            return null;
        }
        ArrayList<String> tmp = Functions.explode("x", this._valueLiteral);
        if (tmp.size() < 2) {
            return null;
        }
        return tmp.get(1);
    }

    public boolean isDimension() {
        if (this._sp == null) {
            return false;
        }
        return this._sp.type == "Dimension";
    }

    public Object getBoolString() {
        Object boolString = "";
        if (!this.isBoolean()) {
            return null;
        }
        boolString = this._boolFormat.equals("YesNo") ? (this._valueBoolean != false ? "Yes" : "No") : (this._boolFormat.equals("yesno") ? (this._valueBoolean != false ? "Yes" : "No") : (this._boolFormat.equals("yesno") ? (this._valueBoolean != false ? "yes" : "no") : (this._boolFormat.equals("ZeroOne") ? (this._valueBoolean != false ? "1" : "0") : (this._boolFormat.equals("TrueFalse") ? (this._valueBoolean != false ? "True" : "False") : (this._boolFormat.equals("truefalse") ? (this._valueBoolean != false ? "true" : "false") : this._valueBoolean)))));
        return boolString;
    }

    public void setValue(String value, int importance) {
        this._isMissing = Functions.isEmpty(value);
        String type = this.getType();
        try {
            if (type.equals("LiteralArray")) {
                this._valueLiteralArray.add(value);
                this._importanceArray.put(value, importance);
            } else {
                this._importance = importance;
                if (type.equals("Float")) {
                    this._valueFloat = Float.valueOf(Float.parseFloat(value));
                } else if (type.equals("Integer") || type.equals("ByteSize")) {
                    this._valueInteger = Long.parseLong(value);
                } else if (type.equals("Boolean")) {
                    this._valueBoolean = Functions.to_boolean(value);
                } else {
                    this._valueLiteral = type.equals("Dimension") || type.equals("Literal") ? value : value;
                }
            }
        }
        catch (NumberFormatException nfe) {
            return;
        }
    }

    public void addSP(SchemaPropertyCore sp) {
        if (sp == null) {
            return;
        }
        this._sp = sp;
        this._isBoolean = sp.type.equals("Boolean");
    }

    public boolean isBoolean() {
        return this._isBoolean;
    }

    public boolean matches(String value) {
        return true;
    }
}

