/*
 * Decompiled with CFR 0.152.
 */
package com.detectright.core;

import com.detectright.core.Cache;
import com.detectright.core.ConnectionLostException;
import com.detectright.core.DBLink;
import com.detectright.core.Datapoint;
import com.detectright.core.DetectRight;
import com.detectright.core.DetectRightException;
import com.detectright.core.EntityCore;
import com.detectright.core.Functions;
import com.detectright.core.QuantumDataTree;
import com.detectright.core.Reflection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataquery {
    public String map = "";
    public ArrayList<String> path = new ArrayList();
    public String command = "";
    public String type = "";
    public QuantumDataTree rootQDT;
    public QuantumDataTree qdt;
    public String queryType = "qdc";
    public Datapoint datapoint;
    public ArrayList<String> result = new ArrayList();
    public boolean array = true;
    public boolean useSubtree = false;
    public static ThreadLocal<DBLink> dbLink;
    protected DBLink db;
    public static ThreadLocal<Cache> cacheLink;
    protected Cache cache;

    static {
        DetectRight.registerClass("Dataquery");
        dbLink = new ThreadLocal();
        cacheLink = new ThreadLocal();
    }

    public Dataquery() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public Dataquery(String map) throws DetectRightException, ConnectionLostException {
        this.cacheDB();
        ArrayList<String> tmp = Functions.explode("//", map);
        this.command = Functions.array_pop(tmp).toString();
        this.checkForExpression();
        this.path = tmp;
        this.datapoint = new Datapoint(this.command);
        if (!Functions.in("flag", this.command)) {
            this.datapoint.flag = "1";
        }
        this.datapoint.processValue();
    }

    public static void main(String[] args) {
    }

    public void cacheDB() throws ConnectionLostException, DetectRightException {
        if (Functions.is_null(cacheLink.get())) {
            cacheLink.set(DetectRight.getCacheLink());
        }
        this.cache = cacheLink.get();
        if (Functions.is_null(dbLink.get())) {
            dbLink.set(DetectRight.getDBLink());
        }
        this.db = dbLink.get();
        if (this.db == null) {
            throw new ConnectionLostException("Lost connection to database");
        }
    }

    public void __wakeup() throws ConnectionLostException, DetectRightException {
        this.cacheDB();
    }

    public ArrayList<String> __sleep() {
        LinkedHashMap<String, Object> ov = Reflection.get_object_vars(this);
        ov.remove("cache");
        ov.remove("db");
        return Functions.array_keys_string(ov);
    }

    public void checkForExpression() throws DetectRightException, ConnectionLostException {
        String command = this.command;
        if (command.startsWith("(")) {
            if (command.endsWith(")")) {
                this.queryType = command.contains(";") ? "concatenation" : "boolean";
                this.command = Functions.substr(command, 1, -1);
            } else {
                Functions.trigger_error("Command " + command + " is invalid", null, false);
            }
        }
        if (this.queryType.equals("qdc") && !command.contains("=")) {
            this.queryType = "direct";
        }
    }

    public void queryQDTWithDescriptor(QuantumDataTree qdt) throws DetectRightException, ConnectionLostException {
        if (qdt == null) {
            return;
        }
        this.rootQDT = qdt;
        this.qdt = new QuantumDataTree("", null);
        String path = Functions.implode(":", this.path);
        qdt.fillQDTWithDescriptor(this.qdt, path);
        this.process();
    }

    public void queryQDTWithPath(QuantumDataTree qdt) throws DetectRightException, ConnectionLostException {
        if (qdt == null) {
            return;
        }
        this.rootQDT = qdt;
        this.qdt = qdt.getQDT(this.path);
        this.process();
    }

    public void process() throws DetectRightException, ConnectionLostException {
        if (Functions.is_null(this.qdt)) {
            return;
        }
        this.qdt.useSubtree = this.useSubtree;
        if (this.queryType.equals("boolean")) {
            this.processBooleanQuery();
        } else if (this.queryType.equals("concatenation")) {
            this.processConcatQuery();
        } else if (this.queryType.equals("qdc")) {
            this.processQDCQuery();
        } else if (this.queryType.equals("direct")) {
            this.processDirectQuery();
        }
    }

    public void processBooleanQuery() {
        boolean resultBool;
        this.result.clear();
        String command = this.command;
        char firstChar = command.charAt(0);
        String mode = "or";
        switch (firstChar) {
            case '&': {
                mode = "and";
                command = Functions.substr(command, 1);
                break;
            }
            case '!': {
                mode = "none";
                command = Functions.substr(command, 1);
                break;
            }
            case '|': {
                mode = "or";
                command = Functions.substr(command, 1);
            }
        }
        try {
            resultBool = this.qdt.getBoolean(command, mode);
        }
        catch (Throwable e) {
            return;
        }
        this.result.add(resultBool ? "1" : "0");
    }

    public void processConcatQuery() throws DetectRightException {
        ArrayList<String> concatArray = Functions.explode(";", this.command);
        ArrayList<String> compulsoryPresent = new ArrayList<String>();
        ArrayList<String> compulsoryMissing = new ArrayList<String>();
        int key = 0;
        while (key < concatArray.size()) {
            String value = concatArray.get(key);
            if (!Functions.isEmpty(value)) {
                char chr = value.charAt(0);
                switch (chr) {
                    case '+': {
                        value = Functions.substr(value, 1);
                        concatArray.set(key, value);
                        compulsoryPresent.add(value);
                        break;
                    }
                    case '!': {
                        value = Functions.substr(value, 1);
                        concatArray.set(key, value);
                        compulsoryMissing.add(value);
                    }
                }
            }
            ++key;
        }
        ArrayList<String> descs = this.qdt.getDescriptors(1, true);
        ArrayList<Object> descriptors = new ArrayList();
        LinkedHashMap<String, Integer> importances = new LinkedHashMap<String, Integer>();
        for (String descriptor : descs) {
            String md5Desc;
            int pos = Functions.strpos(descriptor, "%/%");
            if (pos <= -1) continue;
            int importance = Functions.parseInt(Functions.substr(descriptor, pos + 3));
            if ((descriptor = Functions.substr(descriptor, 0, pos)).endsWith(":")) {
                descriptor = Functions.substr(descriptor, 0, -1);
            }
            if (!importances.containsKey(md5Desc = Functions.md5(descriptor))) {
                importances.put(md5Desc, importance);
            } else if (importance > (Integer)importances.get(md5Desc)) {
                importances.put(md5Desc, importance);
            }
            if (descriptors.contains(descriptor)) continue;
            descriptors.add(descriptor);
        }
        Functions.rsort(descriptors);
        ArrayList<String> output = new ArrayList<String>();
        descriptors = Functions.array_unique(descriptors);
        for (String string : descriptors) {
            if (string == null || Functions.stripos(string, this.qdt.descriptor) != 0) continue;
            int importance = (Integer)importances.get(Functions.md5(string));
            ArrayList expression = (ArrayList)concatArray.clone();
            boolean doBool = true;
            LinkedHashMap<String, String> tmp = EntityCore.parseEntityDescriptor(string);
            for (Map.Entry entry : tmp.entrySet()) {
                String field = (String)entry.getKey();
                String value = (String)entry.getValue();
                boolean valueEmpty = Functions.isEmpty(value);
                if (valueEmpty && compulsoryPresent.contains(field)) {
                    doBool = false;
                    break;
                }
                if (!valueEmpty && compulsoryMissing.contains(field)) {
                    doBool = false;
                    break;
                }
                int keyPos = concatArray.indexOf(field);
                if (keyPos <= -1) continue;
                expression.set(keyPos, value);
            }
            if (!doBool) continue;
            String exp = Functions.implode("", expression).trim();
            exp = Functions.str_replace("   ", " ", exp);
            if (Functions.isEmpty(exp = Functions.str_replace("  ", " ", exp))) continue;
            output.add(String.valueOf(exp) + "%/%" + String.valueOf(importance));
        }
        this.result = output;
    }

    public void processQDCQuery() throws DetectRightException {
        if (this.datapoint == null) {
            return;
        }
        String wildcardField = this.datapoint.getWildcardField();
        if (Functions.isEmpty(wildcardField)) {
            this.result = new ArrayList();
            return;
        }
        ArrayList<Datapoint> datapoints = this.qdt.getData(this.datapoint);
        this.result = new ArrayList();
        if (datapoints == null) {
            return;
        }
        for (Datapoint thisDP : datapoints) {
            String value;
            if (thisDP == null) continue;
            try {
                value = thisDP.getProperty(wildcardField);
            }
            catch (Throwable e) {
                continue;
            }
            if (this.datapoint.arg > 0) {
                int arg = this.datapoint.arg - 1;
                ArrayList<String> tmp = Functions.explode("x", value);
                value = tmp.size() > arg ? tmp.get(arg) : null;
            }
            if (Functions.isEmpty(value)) continue;
            this.result.add(String.valueOf(value) + "%/%" + thisDP.importance);
        }
    }

    public void processDirectQuery() throws DetectRightException, ConnectionLostException {
        ArrayList<String> output = this.qdt.getDirectValueArray(this.command, !this.useSubtree, true);
        this.result = output;
    }
}

